# This file is part of Email-Reminder.
#
# Email-Reminder is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 3 of the
# License, or (at your option) any later version.
#
# Email-Reminder is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Email-Reminder; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

package EmailReminder::MonthlyStore;

use strict;
use warnings;

use Gtk2;
use Glib::Object::Subclass
    Glib::Object::,
    interfaces => [ Gtk2::TreeModel:: ],
    ;

use EmailReminder::EventStore;
use EmailReminder::MonthlyEvent;

require Exporter;
our @ISA = ("EmailReminder::EventStore", "Exporter");

use constant TRUE => 1;
use constant FALSE => 0; 

# Column indices
my $NAME_INDEX = 1;
my $DAY_INDEX = 2;

sub init
{
    my ($this) = @_;

    $this->{TYPE} = EmailReminder::MonthlyEvent->get_type();
    $this->{NB_COLUMNS} = EmailReminder::MonthlyEvent->get_nb_fields();

    $this->EmailReminder::EventStore::init();
}

sub get_event_column
{
    my ($this, $event, $col) = @_;
    
    if ($col == $NAME_INDEX) {
        return $event->get_name();
    }
    elsif ($col == $DAY_INDEX) {
        return $event->get_day();
    }
    else {
        return $this->EmailReminder::EventStore::get_event_column($event, $col);
    }
}

sub set_event_column
{
    my ($this, $event, $col, $new_value) = @_;
    
    if ($col == $NAME_INDEX) {
        $event->set_name($new_value);
    }
    elsif ($col == $DAY_INDEX) {
        $event->set_day($new_value);
    }
    else {
        $this->EmailReminder::EventStore::set_event_column($event, $col, $new_value);
    }
}

1;
