/*						Atuo Ohki, 1998 Oct 23
 *							   2000 Mar 23
 * sort glossary.texi for AIUEO order
 * assuming
 *	some text
 *	@c ==jtable			<-- head of sort section
 *	@c ==jitem Hiragana-Yomi	<-- item delemiter & sort key
 *	  .....
 *	@c ==jend			<-- tail of sort section
 *	some text
 *
 * no Hankaku-Kana , no Kana !
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static int
jis_mtow(char *p, int *wp)
{
  int in_kanji = 0;

  while (p && *p) {
    if (p[0] == '\033' && p[1] == '$' && p[2] == 'B') {
      in_kanji = 1;
      p += 3;
      continue;
    }
    if (p[0] == '\033' && p[1] == '(' && (p[2] == 'B' || p[2] == 'J')) {
      in_kanji = 0;
      p += 3;
      continue;
    }
    if (!in_kanji && (' ' <= *p && *p <= '~' || *p == '\t')) {
      *(wp++) = *(p++);
      continue;
    }
    /* else in_kanji */
    if ('!' <= p[0] && p[0] <= '~' && '!' <= p[1] && p[1] <= '~' ) {
      *(wp++) = (p[0]<<8) | p[1];
      p += 2;
      continue;
    }
    if (p[0] == '\n' && p[1] == 0) break;
    return (0);
  }
  *wp = 0;
  return (1);
}

static int
euc_mtow(char *p, int *wp)
{
  while (p && *p) {
    if ((p[0] & 0x80) && '!' <= (p[0]&0x7f) && (p[0] & 0x7f) <= '~' &&
	(p[1] & 0x80) && '!' <= (p[1]&0x7f) && (p[1] & 0x7f) <= '~') {
      *(wp++) = ((p[0]&0x7f)<<8) | (p[1]&0x7f);
      p += 2;
      continue;
    }
    if (' ' <= *p && *p <= '~' || *p == '\t') {
      *(wp++) = *(p++);
      continue;
    }
    if (p[0] == '\n' && p[1] == 0) break;
    return (0);
  }
  *wp = 0;
  return (1);
}

static int
sjis_mtow(char *p, int *wp)
{
  int sh, sl;
  int jh, jl;

  while (p && *p) {
    if ((p[0] & 0x80) && p[1]) {
      sh = p[0] & 0xff;
      sl = p[1] & 0xff;
      jh = ((sh - ((sh >= 0xa0)? 0xc1: 0x81)) << 1)+0x21;
      if (sl >= 0x9f) {
	jh++;
	jl = sl - 0x7e;
      } else {
	jl = sl - ((sl <= 0x7e) ? 0x1f : 0x20);
      }
      if ('!' <= jh && jh < '~' && '!' <= jl && jl < '~') {
	*(wp++) = (jh<<8) | jl;
	p += 2;
	continue;
      }
      return (0);
    }
    if (' ' <= *p && *p <= '~' || *p == '\t') {
      *(wp++) = *(p++);
      continue;
    }
    if (p[0] == '\n' && p[1] == 0) break;
    return (0);
  }
  *wp = 0;
  return (1);
}

/* make 16-bit code */
static void
mtow(char *p, int *wp)
{
  if (jis_mtow(p, wp)) return;
  else if (euc_mtow(p, wp)) return;
  else if (sjis_mtow(p, wp)) return;
  fprintf(stderr, "unknown kanji code\n");
  exit(1);
}

#define xx(a,b) (((a)<<8)|(b))

static struct {
  int ch, cano;
} cano_tbl[] = {
  { xx('$','!'),  xx('$','"') },  /*   */
  { xx('$','#'),  xx('$','$') },  /*   */
  { xx('$','%'),  xx('$','&') },  /*   */
  { xx('$','\''), xx('$','(') },  /*   */
  { xx('$',')'),  xx('$','*') },  /*   */
  { xx('$',','),  xx('$','+') },  /*   */
  { xx('$','.'),  xx('$','-') },  /*   */
  { xx('$','0'),  xx('$','/') },  /*   */
  { xx('$','2'),  xx('$','1') },  /*   */
  { xx('$','4'),  xx('$','3') },  /*   */
  { xx('$','6'),  xx('$','5') },  /*   */
  { xx('$','8'),  xx('$','7') },  /*   */
  { xx('$',':'),  xx('$','9') },  /*   */
  { xx('$','<'),  xx('$',';') },  /*   */
  { xx('$','>'),  xx('$','>') },  /*   */
  { xx('$','@'),  xx('$','?') },  /*   */
  { xx('$','B'),  xx('$','A') },  /*   */
  { xx('$','E'),  xx('$','D') },  /*   */
  { xx('$','G'),  xx('$','F') },  /*   */
  { xx('$','I'),  xx('$','H') },  /*   */
  { xx('$','P'),  xx('$','O') },  /*   */
  { xx('$','Q'),  xx('$','O') },  /*   */
  { xx('$','S'),  xx('$','R') },  /*   */
  { xx('$','T'),  xx('$','R') },  /*   */
  { xx('$','V'),  xx('$','U') },  /*   */
  { xx('$','W'),  xx('$','U') },  /*   */
  { xx('$','Y'),  xx('$','X') },  /*   */
  { xx('$','Z'),  xx('$','X') },  /*   */
  { xx('$','\\'), xx('$','[') },  /*   */
  { xx('$',']'),  xx('$','[') },  /*   */
  { xx('$','c'),  xx('$','d') },  /*   */
  { xx('$','e'),  xx('$','f') },  /*   */
  { xx('$','g'),  xx('$','h') },  /*   */
  { 0, 0 }
};

static int
ch_cano(int a)
{
  int i;
  for (i=0; cano_tbl[i].ch; i++)
    if (cano_tbl[i].ch == a) return (cano_tbl[i].cano);
  return (a);
}

#define MAX_LINES 10000
#define LNSIZE  1000

struct ln_link {
  struct ln_link *ln_next;
  char ln_char[4];
} *lines[MAX_LINES];

/* compare ln_link */
static int
ln_cmp_0(const int *wa, const int *wb)
{
  int ca, cb;
  int result;

  if (*wa == 0 && *wb) return (-1);
  if (*wa && *wb == 0) return (1);
  ca = ch_cano(*wa);
  cb = ch_cano(*wb);
  if (ca == cb) {
    if ((result = ln_cmp_0(wa+1, wb+1))) return (result);
  }
  return (*wa - *wb);
}

static int
ln_cmp(const void *a, const void *b)
{
  struct ln_link *la = *((struct ln_link**)(a));
  struct ln_link *lb = *((struct ln_link**)(b));
  int wa[LNSIZE], wb[LNSIZE];

  mtow(&(la->ln_char[0]), wa);
  mtow(&(lb->ln_char[0]), wb);
  return (ln_cmp_0(wa, wb));
}

/* save line `cp' and return ln_link */
struct ln_link *
save_ln(char *cp)
{
  struct ln_link *v;
  char *l;

  if (v = (struct ln_link*) malloc(sizeof(struct ln_link) + strlen(cp) + 1)) {
    v->ln_next = NULL;
    strcpy(&(v->ln_char[0]), cp);
  } else
    v = NULL;
  return (v);
}

main()
{
  char ln[LNSIZE];
  int ln_count;
  int i;
  struct ln_link *lnp;

  ln_count = -1;
  /* preamble */
  while (fgets(ln, LNSIZE, stdin) == ln) {
    if (strncmp(ln, "@c ==jtable", 11)) {
      fputs(ln, stdout);
      continue;
    }
    ln_count = 0;
    break;
  }
  if (ln_count == 0) {
    /* jtable  jitem ...  jend */
    lnp = NULL;
    while (fgets(ln, LNSIZE, stdin) == ln) {
      if (strncmp(ln, "@c ==jitem ", 11) == 0) {
	/* make entry */
	lnp = lines[ln_count++] = save_ln(ln);
      } else if (strncmp(ln, "@c ==jend", 9) == 0) {
	break;
      } else if (lnp) {
	lnp->ln_next = save_ln(ln);
	lnp = lnp->ln_next;
      }
    }
    printf("@c == %d items\n", ln_count);
    /* sort them */
    if (ln_count > 0)
      qsort(lines, ln_count, sizeof(lines[0]), ln_cmp);
    /* print them */
    for (i=0; i<ln_count; i++) {
      lnp = lines[i];
      while (lnp) {
	fputs(&(lnp->ln_char[0]), stdout);
	lnp = lnp->ln_next;
      }
    }
  }
  /* postamble */
  while (fgets(ln, LNSIZE, stdin) == ln)
    fputs(ln, stdout);
}
