#ifndef __CONFHOLD_H__
#define __CONFHOLD_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "rstring.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void confhold_init (void);
extern void confhold_free_resources (void);
extern void confhold_register (const char *name, int fieldcount, ...);

extern int        confhold_open (const char *name);
extern void       confhold_close (int cd);
extern rstring_t *confhold_get_fields (int cd, const char *field);
extern void       confhold_select (int cd, int index);
extern void       confhold_select_where (int cd, const char *field,
                                         const char *desired);
extern char      *confhold_field_from_selected (int cd, const char *field);

extern char      *confhold_get_first (const char *name, const char *field);
extern rstring_t *confhold_get_all (const char *name);

extern int   confhold_prepare_to_insert (const char *name);
extern int   confhold_insert_value (const char *field, const char *val);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER confhold.h
 *
 ****************************************************************************/
#endif
