
/* implementation of tree construction functions */

#include "node.h"

#include "nodecode.h"

#include "attrpredef.h"

#include "visitmap.h"

#include "treeact.h"

#ifdef MONITOR
#include "attr_mon_dapto.h"
#endif

#include <stdlib.h>

#define _USE_OBSTACK 1

/* use of obstack: */

#if _USE_OBSTACK

#include "obstack.h"
static struct obstack TreeSpace;
static void *_TreeBase;

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	return obstack_alloc(&TreeSpace, size);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	return (char *)(obstack_alloc(&TreeSpace, size));
}
#endif

void InitTree()
{
	obstack_init(&TreeSpace);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

void FreeTree()
{
	obstack_free(&TreeSpace, _TreeBase);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

#else

#include <stdio.h>

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	void *retval = malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	char *retval = (char *) malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#endif

void InitTree() { }

void FreeTree() { }

#endif

#ifdef MONITOR
#define _SETCOORD(node) \
        node->_coord = _coordref ? *_coordref : NoCoord;
#define _COPYCOORD(node) \
        node->_coord = _currn->_desc1->_coord;
#else
#define _SETCOORD(node)
#define _COPYCOORD(node)
#endif
#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkRule (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkRule (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBRule)) return (_currn);
return(NULLNODEPTR);
}/* MkRule */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkDelim (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkDelim (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBDelim)) return (_currn);
return(NULLNODEPTR);
}/* MkDelim */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAlternatives (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAlternatives (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAlternatives)) return (_currn);
if (IsSymb (_currn, SYMBModification)) return (Mkrule_4(_coordref, _currn));
if (IsSymb (_currn, SYMBConnection)) return (Mkrule_4(_coordref, _currn));
if (IsSymb (_currn, SYMBElement)) return (Mkrule_4(_coordref, _currn));
if (IsSymb (_currn, SYMBElements)) return (Mkrule_4(_coordref, _currn));
if (IsSymb (_currn, SYMBAlternative)) return (Mkrule_4(_coordref, _currn));
if (IsSymb (_currn, SYMBSymbol)) return (Mkrule_4(_coordref, _currn));
return(NULLNODEPTR);
}/* MkAlternatives */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAlt (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAlt (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAlt)) return (_currn);
return(NULLNODEPTR);
}/* MkAlt */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkAlternative (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkAlternative (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBAlternative)) return (_currn);
if (IsSymb (_currn, SYMBModification)) return (Mkrule_5(_coordref, _currn));
if (IsSymb (_currn, SYMBConnection)) return (Mkrule_5(_coordref, _currn));
if (IsSymb (_currn, SYMBElement)) return (Mkrule_5(_coordref, _currn));
if (IsSymb (_currn, SYMBElements)) return (Mkrule_5(_coordref, _currn));
if (IsSymb (_currn, SYMBSymbol)) return (Mkrule_5(_coordref, _currn));
return(NULLNODEPTR);
}/* MkAlternative */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkSep (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkSep (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBSep)) return (_currn);
return(NULLNODEPTR);
}/* MkSep */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkSeparator (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkSeparator (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBSeparator)) return (_currn);
if (IsSymb (_currn, SYMBSymbol)) return (Mkrule_009(_coordref, _currn));
return(NULLNODEPTR);
}/* MkSeparator */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkElements (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkElements (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBElements)) return (_currn);
if (IsSymb (_currn, SYMBModification)) return (Mkrule_8(_coordref, _currn));
if (IsSymb (_currn, SYMBConnection)) return (Mkrule_8(_coordref, _currn));
if (IsSymb (_currn, SYMBElement)) return (Mkrule_8(_coordref, _currn));
if (IsSymb (_currn, SYMBSymbol)) return (Mkrule_8(_coordref, _currn));
return(NULLNODEPTR);
}/* MkElements */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkElement (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkElement (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBElement)) return (_currn);
if (IsSymb (_currn, SYMBModification)) return (Mkrule_11(_coordref, _currn));
if (IsSymb (_currn, SYMBConnection)) return (Mkrule_10(_coordref, _currn));
if (IsSymb (_currn, SYMBSymbol)) return (Mkrule_9(_coordref, _currn));
return(NULLNODEPTR);
}/* MkElement */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkSymbol (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkSymbol (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBSymbol)) return (_currn);
return(NULLNODEPTR);
}/* MkSymbol */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkConnection (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkConnection (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBConnection)) return (_currn);
return(NULLNODEPTR);
}/* MkConnection */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkModification (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkModification (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBModification)) return (_currn);
return(NULLNODEPTR);
}/* MkModification */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkSource (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkSource (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBSource)) return (_currn);
if (IsSymb (_currn, SYMBRules)) return (Mkrule_000(_coordref, _currn));
return(NULLNODEPTR);
}/* MkSource */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkRules (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkRules (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBRules)) return (_currn);
return(NULLNODEPTR);
}/* MkRules */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_000 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_000 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_000 _currn;
#ifdef __cplusplus
_currn = new _TPrule_000;
#else
_currn = (_TPPrule_000) TreeNodeAlloc (sizeof (struct _TPrule_000));
#endif
_currn->_prod = RULErule_000;
_currn->_desc1 = (_TSPRules) MkRules (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_000: root of subtree no. 1 can not be made a Rules node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_000;
return ( (NODEPTR) _currn);
}/* Mkrule_000 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_001 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_001 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_001 _currn;
#ifdef __cplusplus
_currn = new _TPrule_001;
#else
_currn = (_TPPrule_001) TreeNodeAlloc (sizeof (struct _TPrule_001));
#endif
_currn->_prod = RULErule_001;
_currn->_desc1 = (_TSPRules) MkRules (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 1 can not be made a Rules node ", 0, _coordref);
_currn->_desc2 = (_TSPRule) MkRule (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 2 can not be made a Rule node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_001;
return ( (NODEPTR) _currn);
}/* Mkrule_001 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_002 (POSITION *_coordref)
#else
NODEPTR Mkrule_002 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_002 _currn;
#ifdef __cplusplus
_currn = new _TPrule_002;
#else
_currn = (_TPPrule_002) TreeNodeAlloc (sizeof (struct _TPrule_002));
#endif
_currn->_prod = RULErule_002;
_SETCOORD(_currn)
_TERMACT_rule_002;
return ( (NODEPTR) _currn);
}/* Mkrule_002 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_003 (POSITION *_coordref)
#else
NODEPTR Mkrule_003 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_003 _currn;
#ifdef __cplusplus
_currn = new _TPrule_003;
#else
_currn = (_TPPrule_003) TreeNodeAlloc (sizeof (struct _TPrule_003));
#endif
_currn->_prod = RULErule_003;
_SETCOORD(_currn)
_TERMACT_rule_003;
return ( (NODEPTR) _currn);
}/* Mkrule_003 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_004 (POSITION *_coordref)
#else
NODEPTR Mkrule_004 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_004 _currn;
#ifdef __cplusplus
_currn = new _TPrule_004;
#else
_currn = (_TPPrule_004) TreeNodeAlloc (sizeof (struct _TPrule_004));
#endif
_currn->_prod = RULErule_004;
_SETCOORD(_currn)
_TERMACT_rule_004;
return ( (NODEPTR) _currn);
}/* Mkrule_004 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_005 (POSITION *_coordref)
#else
NODEPTR Mkrule_005 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_005 _currn;
#ifdef __cplusplus
_currn = new _TPrule_005;
#else
_currn = (_TPPrule_005) TreeNodeAlloc (sizeof (struct _TPrule_005));
#endif
_currn->_prod = RULErule_005;
_SETCOORD(_currn)
_TERMACT_rule_005;
return ( (NODEPTR) _currn);
}/* Mkrule_005 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_006 (POSITION *_coordref)
#else
NODEPTR Mkrule_006 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_006 _currn;
#ifdef __cplusplus
_currn = new _TPrule_006;
#else
_currn = (_TPPrule_006) TreeNodeAlloc (sizeof (struct _TPrule_006));
#endif
_currn->_prod = RULErule_006;
_SETCOORD(_currn)
_TERMACT_rule_006;
return ( (NODEPTR) _currn);
}/* Mkrule_006 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_007 (POSITION *_coordref)
#else
NODEPTR Mkrule_007 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_007 _currn;
#ifdef __cplusplus
_currn = new _TPrule_007;
#else
_currn = (_TPPrule_007) TreeNodeAlloc (sizeof (struct _TPrule_007));
#endif
_currn->_prod = RULErule_007;
_SETCOORD(_currn)
_TERMACT_rule_007;
return ( (NODEPTR) _currn);
}/* Mkrule_007 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_008 (POSITION *_coordref)
#else
NODEPTR Mkrule_008 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_008 _currn;
#ifdef __cplusplus
_currn = new _TPrule_008;
#else
_currn = (_TPPrule_008) TreeNodeAlloc (sizeof (struct _TPrule_008));
#endif
_currn->_prod = RULErule_008;
_SETCOORD(_currn)
_TERMACT_rule_008;
return ( (NODEPTR) _currn);
}/* Mkrule_008 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_009 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_009 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_009 _currn;
#ifdef __cplusplus
_currn = new _TPrule_009;
#else
_currn = (_TPPrule_009) TreeNodeAlloc (sizeof (struct _TPrule_009));
#endif
_currn->_prod = RULErule_009;
_currn->_desc1 = (_TSPSymbol) MkSymbol (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_009: root of subtree no. 1 can not be made a Symbol node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_009;
return ( (NODEPTR) _currn);
}/* Mkrule_009 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_010 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_010 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_010 _currn;
#ifdef __cplusplus
_currn = new _TPrule_010;
#else
_currn = (_TPPrule_010) TreeNodeAlloc (sizeof (struct _TPrule_010));
#endif
_currn->_prod = RULErule_010;
_currn->_desc1 = (_TSPSymbol) MkSymbol (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_010: root of subtree no. 1 can not be made a Symbol node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_010;
return ( (NODEPTR) _currn);
}/* Mkrule_010 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_1 (POSITION *_coordref, int _TERM1, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_1 (_coordref, _TERM1,_desc1,_desc2)
	POSITION *_coordref;
	int _TERM1;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_1 _currn;
#ifdef __cplusplus
_currn = new _TPrule_1;
#else
_currn = (_TPPrule_1) TreeNodeAlloc (sizeof (struct _TPrule_1));
#endif
_currn->_prod = RULErule_1;
_currn->_desc1 = (_TSPDelim) MkDelim (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_1: root of subtree no. 1 can not be made a Delim node ", 0, _coordref);
_currn->_desc2 = (_TSPAlternatives) MkAlternatives (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_1: root of subtree no. 2 can not be made a Alternatives node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_1;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_1 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_2 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_2 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_2 _currn;
#ifdef __cplusplus
_currn = new _TPrule_2;
#else
_currn = (_TPPrule_2) TreeNodeAlloc (sizeof (struct _TPrule_2));
#endif
_currn->_prod = RULErule_2;
_currn->_desc1 = (_TSPAlternatives) MkAlternatives (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_2: root of subtree no. 1 can not be made a Alternatives node ", 0, _coordref);
_currn->_desc2 = (_TSPAlt) MkAlt (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_2: root of subtree no. 2 can not be made a Alt node ", 0, _coordref);
_currn->_desc3 = (_TSPAlternative) MkAlternative (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_2: root of subtree no. 3 can not be made a Alternative node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_2;
return ( (NODEPTR) _currn);
}/* Mkrule_2 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_3 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_3 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_3 _currn;
#ifdef __cplusplus
_currn = new _TPrule_3;
#else
_currn = (_TPPrule_3) TreeNodeAlloc (sizeof (struct _TPrule_3));
#endif
_currn->_prod = RULErule_3;
_currn->_desc1 = (_TSPAlternatives) MkAlternatives (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 1 can not be made a Alternatives node ", 0, _coordref);
_currn->_desc2 = (_TSPSep) MkSep (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 2 can not be made a Sep node ", 0, _coordref);
_currn->_desc3 = (_TSPSeparator) MkSeparator (_coordref, _desc3);	
if (((NODEPTR)_currn->_desc3) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_3: root of subtree no. 3 can not be made a Separator node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_3;
return ( (NODEPTR) _currn);
}/* Mkrule_3 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_4 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_4 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_4 _currn;
#ifdef __cplusplus
_currn = new _TPrule_4;
#else
_currn = (_TPPrule_4) TreeNodeAlloc (sizeof (struct _TPrule_4));
#endif
_currn->_prod = RULErule_4;
_currn->_desc1 = (_TSPAlternative) MkAlternative (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_4: root of subtree no. 1 can not be made a Alternative node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_4;
return ( (NODEPTR) _currn);
}/* Mkrule_4 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_5 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_5 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_5 _currn;
#ifdef __cplusplus
_currn = new _TPrule_5;
#else
_currn = (_TPPrule_5) TreeNodeAlloc (sizeof (struct _TPrule_5));
#endif
_currn->_prod = RULErule_5;
_currn->_desc1 = (_TSPElements) MkElements (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_5: root of subtree no. 1 can not be made a Elements node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_5;
return ( (NODEPTR) _currn);
}/* Mkrule_5 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_6 (POSITION *_coordref)
#else
NODEPTR Mkrule_6 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_6 _currn;
#ifdef __cplusplus
_currn = new _TPrule_6;
#else
_currn = (_TPPrule_6) TreeNodeAlloc (sizeof (struct _TPrule_6));
#endif
_currn->_prod = RULErule_6;
_SETCOORD(_currn)
_TERMACT_rule_6;
return ( (NODEPTR) _currn);
}/* Mkrule_6 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_7 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_7 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_7 _currn;
#ifdef __cplusplus
_currn = new _TPrule_7;
#else
_currn = (_TPPrule_7) TreeNodeAlloc (sizeof (struct _TPrule_7));
#endif
_currn->_prod = RULErule_7;
_currn->_desc1 = (_TSPElements) MkElements (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_7: root of subtree no. 1 can not be made a Elements node ", 0, _coordref);
_currn->_desc2 = (_TSPElement) MkElement (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_7: root of subtree no. 2 can not be made a Element node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_7;
return ( (NODEPTR) _currn);
}/* Mkrule_7 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_8 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_8 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_8 _currn;
#ifdef __cplusplus
_currn = new _TPrule_8;
#else
_currn = (_TPPrule_8) TreeNodeAlloc (sizeof (struct _TPrule_8));
#endif
_currn->_prod = RULErule_8;
_currn->_desc1 = (_TSPElement) MkElement (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_8: root of subtree no. 1 can not be made a Element node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_8;
return ( (NODEPTR) _currn);
}/* Mkrule_8 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_9 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_9 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_9 _currn;
#ifdef __cplusplus
_currn = new _TPrule_9;
#else
_currn = (_TPPrule_9) TreeNodeAlloc (sizeof (struct _TPrule_9));
#endif
_currn->_prod = RULErule_9;
_currn->_desc1 = (_TSPSymbol) MkSymbol (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_9: root of subtree no. 1 can not be made a Symbol node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_9;
return ( (NODEPTR) _currn);
}/* Mkrule_9 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_10 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_10 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_10 _currn;
#ifdef __cplusplus
_currn = new _TPrule_10;
#else
_currn = (_TPPrule_10) TreeNodeAlloc (sizeof (struct _TPrule_10));
#endif
_currn->_prod = RULErule_10;
_currn->_desc1 = (_TSPConnection) MkConnection (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_10: root of subtree no. 1 can not be made a Connection node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_10;
return ( (NODEPTR) _currn);
}/* Mkrule_10 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_11 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_11 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_11 _currn;
#ifdef __cplusplus
_currn = new _TPrule_11;
#else
_currn = (_TPPrule_11) TreeNodeAlloc (sizeof (struct _TPrule_11));
#endif
_currn->_prod = RULErule_11;
_currn->_desc1 = (_TSPModification) MkModification (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_11: root of subtree no. 1 can not be made a Modification node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_11;
return ( (NODEPTR) _currn);
}/* Mkrule_11 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_12 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_12 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_12 _currn;
#ifdef __cplusplus
_currn = new _TPrule_12;
#else
_currn = (_TPPrule_12) TreeNodeAlloc (sizeof (struct _TPrule_12));
#endif
_currn->_prod = RULErule_12;
_currn->_desc1 = (_TSPSymbol) MkSymbol (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_12: root of subtree no. 1 can not be made a Symbol node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_12;
return ( (NODEPTR) _currn);
}/* Mkrule_12 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_13 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_13 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_13 _currn;
#ifdef __cplusplus
_currn = new _TPrule_13;
#else
_currn = (_TPPrule_13) TreeNodeAlloc (sizeof (struct _TPrule_13));
#endif
_currn->_prod = RULErule_13;
_currn->_desc1 = (_TSPSymbol) MkSymbol (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_13: root of subtree no. 1 can not be made a Symbol node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_13;
return ( (NODEPTR) _currn);
}/* Mkrule_13 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_14 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_14 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_14 _currn;
#ifdef __cplusplus
_currn = new _TPrule_14;
#else
_currn = (_TPPrule_14) TreeNodeAlloc (sizeof (struct _TPrule_14));
#endif
_currn->_prod = RULErule_14;
_currn->_desc1 = (_TSPAlternatives) MkAlternatives (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_14: root of subtree no. 1 can not be made a Alternatives node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_14;
return ( (NODEPTR) _currn);
}/* Mkrule_14 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_15 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_15 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_15 _currn;
#ifdef __cplusplus
_currn = new _TPrule_15;
#else
_currn = (_TPPrule_15) TreeNodeAlloc (sizeof (struct _TPrule_15));
#endif
_currn->_prod = RULErule_15;
_currn->_desc1 = (_TSPAlternatives) MkAlternatives (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_15: root of subtree no. 1 can not be made a Alternatives node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_15;
return ( (NODEPTR) _currn);
}/* Mkrule_15 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_16 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_16 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_16 _currn;
#ifdef __cplusplus
_currn = new _TPrule_16;
#else
_currn = (_TPPrule_16) TreeNodeAlloc (sizeof (struct _TPrule_16));
#endif
_currn->_prod = RULErule_16;
_currn->_desc1 = (_TSPElement) MkElement (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_16: root of subtree no. 1 can not be made a Element node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_16;
return ( (NODEPTR) _currn);
}/* Mkrule_16 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_17 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_17 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_17 _currn;
#ifdef __cplusplus
_currn = new _TPrule_17;
#else
_currn = (_TPPrule_17) TreeNodeAlloc (sizeof (struct _TPrule_17));
#endif
_currn->_prod = RULErule_17;
_currn->_desc1 = (_TSPElement) MkElement (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_17: root of subtree no. 1 can not be made a Element node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_17;
return ( (NODEPTR) _currn);
}/* Mkrule_17 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_18 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_18 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_18 _currn;
#ifdef __cplusplus
_currn = new _TPrule_18;
#else
_currn = (_TPPrule_18) TreeNodeAlloc (sizeof (struct _TPrule_18));
#endif
_currn->_prod = RULErule_18;
_SETCOORD(_currn)
_TERMACT_rule_18;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Identifier", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_18 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_19 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_19 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_19 _currn;
#ifdef __cplusplus
_currn = new _TPrule_19;
#else
_currn = (_TPPrule_19) TreeNodeAlloc (sizeof (struct _TPrule_19));
#endif
_currn->_prod = RULErule_19;
_SETCOORD(_currn)
_TERMACT_rule_19;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Literal", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_19 */
