-- Copyright 2000 Luc Taesch and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Gnome Canvas item representing text"
	author: "Luc Taesch"
	date: "June 2000"

class GNOME_CANVAS_TEXT

inherit

   GNOME_CANVAS_NPC 
		undefine 
			copy, is_equal 
		end

   GNOME_CANVAS_ITEM
		redefine 
			make, set_position
		end

creation 

	make

feature

	make(canvas: GNOME_CANVAS_GROUP) is 
		do  
			make_from_pointer(c_gnome_canvas_text_new(canvas.gtk_object));
			--some font set per default, can be overwritten
			set_fontset(
						"-adobe-helvetica-medium-r-*-*-14-*-*-*-p-*-*-*,-cronyx-helvetica-medium-r-normal-*-17-*-*-*-p-*-koi8-r,-*-*-medium-r-*-*-14-*-*-*-*-*-ksc5601.1987-0,*"
						);
			register_widget;
		end -- make
	
	set_text(s:STRING) is
		do
			canvas_npc.set_property(gtk_object,"text",s);
		end
	
	set_fontset(s:STRING) is
		do
			canvas_npc.set_property(gtk_object, "fontset",s)
		end

	set_position(xa, ya: INTEGER) is 
		local 
			xd, yd: DOUBLE;
		do  
			xd := xa;
			yd := ya;
			canvas_npc.set_property_double(gtk_object,"x",xd);
			--     set_property_double(gtk_object,"y",yd);
		end

end
