-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkScrolledWindow objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_scrolled_window_writer.e,v 1.13 2000/08/31 14:02:17 elphick Exp $"

class GTK_SCROLLED_WINDOW_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_add_widget_code
		end
	
	CHILD

creation

	make

feature

		
	type: STRING is "GTK_SCROLLED_WINDOW"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			hscrollbar_policy := widget_tree.get_string_from_field("hscrollbar_policy")
			vscrollbar_policy := widget_tree.get_string_from_field("vscrollbar_policy")
			hupdate_policy := widget_tree.get_string_from_field("hupdate_policy")
			vupdate_policy := widget_tree.get_string_from_field("vupdate_policy")
			create_child_class(widget_tree.find_child("widget"), 1)
		end
			
	hscrollbar_policy: STRING
	vscrollbar_policy: STRING
	hupdate_policy: STRING
	vupdate_policy: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_policy(" + name + "." + hscrollbar_policy + ", " + name + "." +
				vscrollbar_policy + ")")
			add_widget_code(code)
			precursor(code)
		end

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
			-- this code needs to give special treatment to classes that 
			-- have the set_scroll_adjustments() function (in gtk<type>.h)
		local
			s: STRING
		do
			!!s.make(0)
			if widget.self_scrolling then
				s.make_from_string(".add_widget(")
			else
				s.make_from_string(".add_widget_with_viewport(")
			end
			code.add_last(name + s + widget.name +")")
		end

end
