/* Copyright (C) 2001 to 2005 and 2009 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SOCKET_LIST_H
#define SOCKET_LIST_H

#include "prog_defs.h"

#include <string>
#include <list>
#include <utility>

#include <gtk/gtk.h>

#include "socket_server.h"

#include <c++-gtk-utils/gobj_handle.h>
#include <c++-gtk-utils/window.h>
#include <c++-gtk-utils/emitter.h>
#include <c++-gtk-utils/mutex.h>
#include <c++-gtk-utils/shared_ptr.h>


namespace { // we put the functions in anonymous namespace in socket_list.cpp
            // so they are not exported at link time
namespace SocketListDialogCB {
  extern "C" {
    void socket_list_button_clicked(GtkWidget*, void*);
    void socket_list_set_buttons(GtkTreeSelection*, void* data);
    gboolean tree_view_mouse_click(GtkWidget*, GdkEventButton*, void*);
  }
}
}

class SocketListDialog: public WinBase {
  static int is_socket_list;
  const int standard_size;

  GtkWidget* send_button_p;
  GtkWidget* view_button_p;
  GtkWidget* remove_button_p;
  GtkWidget* close_button_p;

  GobjHandle<GtkTreeModel> list_store_h;
  GtkTreeView* tree_view_p;

  void send_fax_impl(void);
  void view_file(void);
  void remove_file_prompt(void);
  void remove_file(void);
  std::pair<const char*, char* const*> get_view_file_parms(const std::string&);
  void delete_parms(std::pair<const char*, char* const*>);
  void set_socket_list_item(const std::pair<std::string, unsigned int>&);
public:
  friend void SocketListDialogCB::socket_list_button_clicked(GtkWidget*, void*);
  friend void SocketListDialogCB::socket_list_set_buttons(GtkTreeSelection*, void*);
  friend gboolean SocketListDialogCB::tree_view_mouse_click(GtkWidget*, GdkEventButton*, void*);

  Releaser releaser; // for MainWindow object

  EmitterArg<const std::pair<std::string, std::string>&> selected_fax;
  EmitterArg<const std::string&> remove_from_socket_server_filelist;

  void close_cb(void);

  void set_socket_list_rows(std::pair<SharedPtr<FilenamesList>, SharedPtr<Thread::Mutex::Lock> >);
  static int get_is_socket_list(void) {return is_socket_list;}

  SocketListDialog(std::pair<SharedPtr<FilenamesList>,
		             SharedPtr<Thread::Mutex::Lock> > filenames_pair,
		   const int standard_size_);
  ~SocketListDialog(void);
};

#endif
