#ifndef INCLUDED_QEINTERFACE_H
#define INCLUDED_QEINTERFACE_H

#include <string>
#include <qapplication.h>
#include <qwidget.h>
#include <ecasound/eca-audio-time.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef USE_CXX_STD_NAMESPACE
using std::string;
#endif

class QStatusBar;
class QBoxLayout;
class QLineEdit;
class QAccel;
class QGridLayout;
class QEButtonRow;
class QEChainOperatorInput;
class QEVUMeter;
class ECA_SESSION;
class ECA_CONTROL;

class QEInterface : public QWidget
{
  Q_OBJECT
public:
  QEInterface(const string& input, 
	      const string& output, 
	      QWidget *parent=0, const char *name=0);
  ~QEInterface(void);

public slots:
  void close_session(void);
  void start_processing(void);
  void stop_processing(void);
  void update_processing_parameters(void);
  void update_processing_operator(void);
  void button_rewind_begin(void);
  void button_rewind(void);
  void button_forward(void);

private slots:
  void update_statusbar(void);
  void not_implemented(void);
  void button_input_browse(void);
  void button_output_browse(void);
  void set_input_name(const QString& q);
  void set_output_name(const QString& q);
  void position_update(void);

private:
  ECA_SESSION* esession_repp;
  ECA_CONTROL* ectrl_repp;

  string input_rep;
  string output_rep;
  bool io_changed_rep;
  string current_dir_rep;
  double curpos_rep;
  
  QEChainOperatorInput* copinput_repp;
  QEButtonRow* buttonrow_repp;
  QEVUMeter* vumeter_repp;

  QAccel* accel_repp;
  QStatusBar* statusbar_repp;
  QGridLayout* io_rows_repp;
  QLineEdit* inputrow_name_repp;
  QLineEdit* inputrow_format_repp;
  QLineEdit* outputrow_name_repp;
  QLineEdit* outputrow_format_repp;

  void init_chainsetup(void);
  void init_layout(void);
  void init_buttons();
  void init_statusbar(void);
  void init_bottomrow(QBoxLayout* bottomrow);
  void init_io_rows(void);
};

#endif
