/*=============================================================================
		ps-font.c
			by Nobuyuki SHIRAKI
			Last change : 31 January 2002  21:49:29
=============================================================================*/

/*-----------------------------------------------------------------------------
			Set PS Fonts Width
-----------------------------------------------------------------------------*/

#include	"e2ps.h"


char *gsFonts = "Times-Roman
Times-Italic
Times-Bold
Times-BoldItalic
Helvetica
Helvetica-Oblique
Helvetica-Bold
Helvetica-BoldOblique
Courier
Courier-Oblique
Courier-Bold
Courier-BoldOblique
Symbol
AvantGarde-Book
AvantGarde_BookOblique
AvantGarde_Demi
AvantGarde_DemiOblique
Bookman-Light
Bookman-LightItalic
Bookman-Demi
Bookman-DemiItalic
Helvetica-Narrow
Helvetica-Narrow-Oblique
Helvetica-Narrow-Bold
Helvetica-Narrow-BoldObliqeu
NewCenturySchlbl-Roman
NewCenturySchlbl-Italic
NewCenturySchlbl-Bold
NewCenturySchlbl-BoldItalic
Palatino-Roman
Palatino-Italic
Palatino-Bold
Palatino-BoldItalic
Zapfchancery-MediumItalic
ZapfDingbats
Ryumin-Light.Hiragana
Ryumin-Light.Katakana
Gothic-Meduim.Hiragana
Gothic-Medium.Katakana
";


/* Set PostScript Font Width */
char *ps_font(char *font, float a[256]) {
  int	i;

  if ( font == NULL || *(font) == '\0' ) {
    return gsFonts;
  }
  else {
    for ( i = 0 ; i < 256 ; i++ ) a[i] = 0.0;
    if ( !strcmp(font, "Times-Roman") ) {
      a[32] = 0.25;
      a[33] = 0.332764;
      a[34] = 0.407959;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 0.832764;
      a[38] = 0.777832;
      a[39] = 0.332764;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.5;
      a[43] = 0.563965;
      a[44] = 0.25;
      a[45] = 0.332764;
      a[46] = 0.25;
      a[47] = 0.277832;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.277832;
      a[59] = 0.277832;
      a[60] = 0.563965;
      a[61] = 0.563965;
      a[62] = 0.563965;
      a[63] = 0.443848;
      a[64] = 0.920898;
      a[65] = 0.721924;
      a[66] = 0.666992;
      a[67] = 0.666992;
      a[68] = 0.721924;
      a[69] = 0.61084;
      a[70] = 0.555908;
      a[71] = 0.721924;
      a[72] = 0.721924;
      a[73] = 0.332764;
      a[74] = 0.388916;
      a[75] = 0.721924;
      a[76] = 0.61084;
      a[77] = 0.888916;
      a[78] = 0.721924;
      a[79] = 0.721924;
      a[80] = 0.555908;
      a[81] = 0.721924;
      a[82] = 0.666992;
      a[83] = 0.555908;
      a[84] = 0.61084;
      a[85] = 0.721924;
      a[86] = 0.721924;
      a[87] = 0.943848;
      a[88] = 0.721924;
      a[89] = 0.721924;
      a[90] = 0.61084;
      a[91] = 0.332764;
      a[92] = 0.277832;
      a[93] = 0.332764;
      a[94] = 0.468994;
      a[95] = 0.5;
      a[96] = 0.332764;
      a[97] = 0.443848;
      a[98] = 0.5;
      a[99] = 0.443848;
      a[100] = 0.5;
      a[101] = 0.443848;
      a[102] = 0.332764;
      a[103] = 0.5;
      a[104] = 0.5;
      a[105] = 0.277832;
      a[106] = 0.277832;
      a[107] = 0.5;
      a[108] = 0.277832;
      a[109] = 0.777832;
      a[110] = 0.5;
      a[111] = 0.5;
      a[112] = 0.5;
      a[113] = 0.5;
      a[114] = 0.332764;
      a[115] = 0.388916;
      a[116] = 0.277832;
      a[117] = 0.5;
      a[118] = 0.5;
      a[119] = 0.721924;
      a[120] = 0.5;
      a[121] = 0.5;
      a[122] = 0.443848;
      a[123] = 0.47998;
      a[124] = 0.199951;
      a[125] = 0.47998;
      a[126] = 0.540771;
      a[161] = 0.332764;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[167] = 0.5;
      a[168] = 0.5;
      a[169] = 0.179932;
      a[170] = 0.443848;
      a[171] = 0.5;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.555908;
      a[175] = 0.555908;
      a[177] = 0.5;
      a[178] = 0.5;
      a[179] = 0.5;
      a[180] = 0.25;
      a[182] = 0.452881;
      a[183] = 0.349854;
      a[184] = 0.332764;
      a[185] = 0.443848;
      a[186] = 0.443848;
      a[187] = 0.5;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.443848;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 0.888916;
      a[227] = 0.275879;
      a[232] = 0.61084;
      a[233] = 0.721924;
      a[234] = 0.888916;
      a[235] = 0.309814;
      a[241] = 0.666992;
      a[245] = 0.277832;
      a[248] = 0.277832;
      a[249] = 0.5;
      a[250] = 0.721924;
      a[251] = 0.5;
    }
    else if ( !strcmp(font, "Times-Italic") ) {
      a[32] = 0.25;
      a[33] = 0.332764;
      a[34] = 0.419922;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 0.832764;
      a[38] = 0.777832;
      a[39] = 0.332764;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.5;
      a[43] = 0.674805;
      a[44] = 0.25;
      a[45] = 0.332764;
      a[46] = 0.25;
      a[47] = 0.277832;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.332764;
      a[59] = 0.332764;
      a[60] = 0.674805;
      a[61] = 0.674805;
      a[62] = 0.674805;
      a[63] = 0.5;
      a[64] = 0.919922;
      a[65] = 0.61084;
      a[66] = 0.61084;
      a[67] = 0.666992;
      a[68] = 0.721924;
      a[69] = 0.61084;
      a[70] = 0.61084;
      a[71] = 0.721924;
      a[72] = 0.721924;
      a[73] = 0.332764;
      a[74] = 0.443848;
      a[75] = 0.666992;
      a[76] = 0.555908;
      a[77] = 0.832764;
      a[78] = 0.666992;
      a[79] = 0.721924;
      a[80] = 0.61084;
      a[81] = 0.721924;
      a[82] = 0.61084;
      a[83] = 0.5;
      a[84] = 0.555908;
      a[85] = 0.721924;
      a[86] = 0.61084;
      a[87] = 0.832764;
      a[88] = 0.61084;
      a[89] = 0.555908;
      a[90] = 0.555908;
      a[91] = 0.388916;
      a[92] = 0.277832;
      a[93] = 0.388916;
      a[94] = 0.421875;
      a[95] = 0.5;
      a[96] = 0.332764;
      a[97] = 0.5;
      a[98] = 0.5;
      a[99] = 0.443848;
      a[100] = 0.5;
      a[101] = 0.443848;
      a[102] = 0.277832;
      a[103] = 0.5;
      a[104] = 0.5;
      a[105] = 0.277832;
      a[106] = 0.277832;
      a[107] = 0.443848;
      a[108] = 0.277832;
      a[109] = 0.721924;
      a[110] = 0.5;
      a[111] = 0.5;
      a[112] = 0.5;
      a[113] = 0.5;
      a[114] = 0.388916;
      a[115] = 0.388916;
      a[116] = 0.277832;
      a[117] = 0.5;
      a[118] = 0.443848;
      a[119] = 0.666992;
      a[120] = 0.443848;
      a[121] = 0.443848;
      a[122] = 0.388916;
      a[123] = 0.399902;
      a[124] = 0.274902;
      a[125] = 0.399902;
      a[126] = 0.540771;
      a[161] = 0.388916;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[167] = 0.5;
      a[168] = 0.5;
      a[169] = 0.213867;
      a[170] = 0.555908;
      a[171] = 0.5;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.5;
      a[175] = 0.5;
      a[177] = 0.5;
      a[178] = 0.5;
      a[179] = 0.5;
      a[180] = 0.25;
      a[182] = 0.522949;
      a[183] = 0.349854;
      a[184] = 0.332764;
      a[185] = 0.555908;
      a[186] = 0.555908;
      a[187] = 0.5;
      a[188] = 0.888916;
      a[189] = 1.0;
      a[191] = 0.5;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 0.888916;
      a[225] = 0.888916;
      a[227] = 0.275879;
      a[232] = 0.555908;
      a[233] = 0.721924;
      a[234] = 0.943848;
      a[235] = 0.309814;
      a[241] = 0.666992;
      a[245] = 0.277832;
      a[248] = 0.277832;
      a[249] = 0.5;
      a[250] = 0.666992;
      a[251] = 0.5;
    }
    else if ( !strcmp(font, "Times-Bold") ) {
      a[32] = 0.25;
      a[33] = 0.332764;
      a[34] = 0.554932;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 1.0;
      a[38] = 0.832764;
      a[39] = 0.332764;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.5;
      a[43] = 0.569824;
      a[44] = 0.25;
      a[45] = 0.332764;
      a[46] = 0.25;
      a[47] = 0.277832;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.332764;
      a[59] = 0.332764;
      a[60] = 0.569824;
      a[61] = 0.569824;
      a[62] = 0.569824;
      a[63] = 0.5;
      a[64] = 0.929932;
      a[65] = 0.721924;
      a[66] = 0.666992;
      a[67] = 0.721924;
      a[68] = 0.721924;
      a[69] = 0.666992;
      a[70] = 0.61084;
      a[71] = 0.777832;
      a[72] = 0.777832;
      a[73] = 0.388916;
      a[74] = 0.5;
      a[75] = 0.777832;
      a[76] = 0.666992;
      a[77] = 0.943848;
      a[78] = 0.721924;
      a[79] = 0.777832;
      a[80] = 0.61084;
      a[81] = 0.777832;
      a[82] = 0.721924;
      a[83] = 0.555908;
      a[84] = 0.666992;
      a[85] = 0.721924;
      a[86] = 0.721924;
      a[87] = 1.0;
      a[88] = 0.721924;
      a[89] = 0.721924;
      a[90] = 0.666992;
      a[91] = 0.332764;
      a[92] = 0.277832;
      a[93] = 0.332764;
      a[94] = 0.580811;
      a[95] = 0.5;
      a[96] = 0.332764;
      a[97] = 0.5;
      a[98] = 0.555908;
      a[99] = 0.443848;
      a[100] = 0.555908;
      a[101] = 0.443848;
      a[102] = 0.332764;
      a[103] = 0.5;
      a[104] = 0.555908;
      a[105] = 0.277832;
      a[106] = 0.332764;
      a[107] = 0.555908;
      a[108] = 0.277832;
      a[109] = 0.832764;
      a[110] = 0.555908;
      a[111] = 0.5;
      a[112] = 0.555908;
      a[113] = 0.555908;
      a[114] = 0.443848;
      a[115] = 0.388916;
      a[116] = 0.332764;
      a[117] = 0.555908;
      a[118] = 0.5;
      a[119] = 0.721924;
      a[120] = 0.5;
      a[121] = 0.5;
      a[122] = 0.443848;
      a[123] = 0.393799;
      a[124] = 0.219971;
      a[125] = 0.393799;
      a[126] = 0.519775;
      a[161] = 0.332764;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[167] = 0.5;
      a[168] = 0.5;
      a[169] = 0.277832;
      a[170] = 0.5;
      a[171] = 0.5;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.555908;
      a[175] = 0.555908;
      a[177] = 0.5;
      a[178] = 0.5;
      a[179] = 0.5;
      a[180] = 0.25;
      a[182] = 0.539795;
      a[183] = 0.349854;
      a[184] = 0.332764;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.5;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.5;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 1.0;
      a[227] = 0.299805;
      a[232] = 0.666992;
      a[233] = 0.777832;
      a[234] = 1.0;
      a[235] = 0.329834;
      a[241] = 0.721924;
      a[245] = 0.277832;
      a[248] = 0.277832;
      a[249] = 0.5;
      a[250] = 0.721924;
      a[251] = 0.555908;
    }
    else if ( !strcmp(font, "Times-BoldItalic") ) {
      a[32] = 0.25;
      a[33] = 0.388916;
      a[34] = 0.554932;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 0.832764;
      a[38] = 0.777832;
      a[39] = 0.332764;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.5;
      a[43] = 0.569824;
      a[44] = 0.25;
      a[45] = 0.332764;
      a[46] = 0.25;
      a[47] = 0.277832;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.332764;
      a[59] = 0.332764;
      a[60] = 0.569824;
      a[61] = 0.569824;
      a[62] = 0.569824;
      a[63] = 0.5;
      a[64] = 0.831787;
      a[65] = 0.666992;
      a[66] = 0.666992;
      a[67] = 0.666992;
      a[68] = 0.721924;
      a[69] = 0.666992;
      a[70] = 0.666992;
      a[71] = 0.721924;
      a[72] = 0.777832;
      a[73] = 0.388916;
      a[74] = 0.5;
      a[75] = 0.666992;
      a[76] = 0.61084;
      a[77] = 0.888916;
      a[78] = 0.721924;
      a[79] = 0.721924;
      a[80] = 0.61084;
      a[81] = 0.721924;
      a[82] = 0.666992;
      a[83] = 0.555908;
      a[84] = 0.61084;
      a[85] = 0.721924;
      a[86] = 0.666992;
      a[87] = 0.888916;
      a[88] = 0.666992;
      a[89] = 0.61084;
      a[90] = 0.61084;
      a[91] = 0.332764;
      a[92] = 0.277832;
      a[93] = 0.332764;
      a[94] = 0.569824;
      a[95] = 0.5;
      a[96] = 0.332764;
      a[97] = 0.5;
      a[98] = 0.5;
      a[99] = 0.443848;
      a[100] = 0.5;
      a[101] = 0.443848;
      a[102] = 0.332764;
      a[103] = 0.5;
      a[104] = 0.555908;
      a[105] = 0.277832;
      a[106] = 0.277832;
      a[107] = 0.5;
      a[108] = 0.277832;
      a[109] = 0.777832;
      a[110] = 0.555908;
      a[111] = 0.5;
      a[112] = 0.5;
      a[113] = 0.5;
      a[114] = 0.388916;
      a[115] = 0.388916;
      a[116] = 0.277832;
      a[117] = 0.555908;
      a[118] = 0.443848;
      a[119] = 0.666992;
      a[120] = 0.5;
      a[121] = 0.443848;
      a[122] = 0.388916;
      a[123] = 0.3479;
      a[124] = 0.219971;
      a[125] = 0.3479;
      a[126] = 0.569824;
      a[161] = 0.388916;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[167] = 0.5;
      a[168] = 0.5;
      a[169] = 0.277832;
      a[170] = 0.5;
      a[171] = 0.5;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.555908;
      a[175] = 0.555908;
      a[177] = 0.5;
      a[178] = 0.5;
      a[179] = 0.5;
      a[180] = 0.25;
      a[182] = 0.5;
      a[183] = 0.349854;
      a[184] = 0.332764;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.5;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.5;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 0.943848;
      a[227] = 0.265869;
      a[232] = 0.61084;
      a[233] = 0.721924;
      a[234] = 0.943848;
      a[235] = 0.299805;
      a[241] = 0.721924;
      a[245] = 0.277832;
      a[248] = 0.277832;
      a[249] = 0.5;
      a[250] = 0.721924;
      a[251] = 0.5;
    }
    else if ( !strcmp(font, "Helvetica") ) {
      a[32] = 0.277832;
      a[33] = 0.277832;
      a[34] = 0.35498;
      a[35] = 0.555908;
      a[36] = 0.555908;
      a[37] = 0.888916;
      a[38] = 0.666992;
      a[39] = 0.221924;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.388916;
      a[43] = 0.583984;
      a[44] = 0.277832;
      a[45] = 0.332764;
      a[46] = 0.277832;
      a[47] = 0.277832;
      a[48] = 0.555908;
      a[49] = 0.555908;
      a[50] = 0.555908;
      a[51] = 0.555908;
      a[52] = 0.555908;
      a[53] = 0.555908;
      a[54] = 0.555908;
      a[55] = 0.555908;
      a[56] = 0.555908;
      a[57] = 0.555908;
      a[58] = 0.277832;
      a[59] = 0.277832;
      a[60] = 0.583984;
      a[61] = 0.583984;
      a[62] = 0.583984;
      a[63] = 0.555908;
      a[64] = 1.01489;
      a[65] = 0.666992;
      a[66] = 0.666992;
      a[67] = 0.721924;
      a[68] = 0.721924;
      a[69] = 0.666992;
      a[70] = 0.61084;
      a[71] = 0.777832;
      a[72] = 0.721924;
      a[73] = 0.277832;
      a[74] = 0.5;
      a[75] = 0.666992;
      a[76] = 0.555908;
      a[77] = 0.832764;
      a[78] = 0.721924;
      a[79] = 0.777832;
      a[80] = 0.666992;
      a[81] = 0.777832;
      a[82] = 0.721924;
      a[83] = 0.666992;
      a[84] = 0.61084;
      a[85] = 0.721924;
      a[86] = 0.666992;
      a[87] = 0.943848;
      a[88] = 0.666992;
      a[89] = 0.666992;
      a[90] = 0.61084;
      a[91] = 0.277832;
      a[92] = 0.277832;
      a[93] = 0.277832;
      a[94] = 0.468994;
      a[95] = 0.555908;
      a[96] = 0.221924;
      a[97] = 0.555908;
      a[98] = 0.555908;
      a[99] = 0.5;
      a[100] = 0.555908;
      a[101] = 0.555908;
      a[102] = 0.277832;
      a[103] = 0.555908;
      a[104] = 0.555908;
      a[105] = 0.221924;
      a[106] = 0.221924;
      a[107] = 0.5;
      a[108] = 0.221924;
      a[109] = 0.832764;
      a[110] = 0.555908;
      a[111] = 0.555908;
      a[112] = 0.555908;
      a[113] = 0.555908;
      a[114] = 0.332764;
      a[115] = 0.5;
      a[116] = 0.277832;
      a[117] = 0.555908;
      a[118] = 0.5;
      a[119] = 0.721924;
      a[120] = 0.5;
      a[121] = 0.5;
      a[122] = 0.5;
      a[123] = 0.333984;
      a[124] = 0.259766;
      a[125] = 0.333984;
      a[126] = 0.583984;
      a[161] = 0.332764;
      a[162] = 0.555908;
      a[163] = 0.555908;
      a[164] = 0.166992;
      a[165] = 0.555908;
      a[166] = 0.555908;
      a[167] = 0.555908;
      a[168] = 0.555908;
      a[169] = 0.190918;
      a[170] = 0.332764;
      a[171] = 0.555908;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.5;
      a[175] = 0.5;
      a[177] = 0.555908;
      a[178] = 0.555908;
      a[179] = 0.555908;
      a[180] = 0.277832;
      a[182] = 0.536865;
      a[183] = 0.349854;
      a[184] = 0.221924;
      a[185] = 0.332764;
      a[186] = 0.332764;
      a[187] = 0.555908;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.61084;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 1.0;
      a[227] = 0.369873;
      a[232] = 0.555908;
      a[233] = 0.777832;
      a[234] = 1.0;
      a[235] = 0.36499;
      a[241] = 0.888916;
      a[245] = 0.277832;
      a[248] = 0.221924;
      a[249] = 0.61084;
      a[250] = 0.943848;
      a[251] = 0.61084;
    }
    else if ( !strcmp(font, "Helvetica-Oblique") ) {
      a[32] = 0.277832;
      a[33] = 0.277832;
      a[34] = 0.35498;
      a[35] = 0.555908;
      a[36] = 0.555908;
      a[37] = 0.888916;
      a[38] = 0.666992;
      a[39] = 0.221924;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.388916;
      a[43] = 0.583984;
      a[44] = 0.277832;
      a[45] = 0.332764;
      a[46] = 0.277832;
      a[47] = 0.277832;
      a[48] = 0.555908;
      a[49] = 0.555908;
      a[50] = 0.555908;
      a[51] = 0.555908;
      a[52] = 0.555908;
      a[53] = 0.555908;
      a[54] = 0.555908;
      a[55] = 0.555908;
      a[56] = 0.555908;
      a[57] = 0.555908;
      a[58] = 0.277832;
      a[59] = 0.277832;
      a[60] = 0.583984;
      a[61] = 0.583984;
      a[62] = 0.583984;
      a[63] = 0.555908;
      a[64] = 1.01489;
      a[65] = 0.666992;
      a[66] = 0.666992;
      a[67] = 0.721924;
      a[68] = 0.721924;
      a[69] = 0.666992;
      a[70] = 0.61084;
      a[71] = 0.777832;
      a[72] = 0.721924;
      a[73] = 0.277832;
      a[74] = 0.5;
      a[75] = 0.666992;
      a[76] = 0.555908;
      a[77] = 0.832764;
      a[78] = 0.721924;
      a[79] = 0.777832;
      a[80] = 0.666992;
      a[81] = 0.777832;
      a[82] = 0.721924;
      a[83] = 0.666992;
      a[84] = 0.61084;
      a[85] = 0.721924;
      a[86] = 0.666992;
      a[87] = 0.943848;
      a[88] = 0.666992;
      a[89] = 0.666992;
      a[90] = 0.61084;
      a[91] = 0.277832;
      a[92] = 0.277832;
      a[93] = 0.277832;
      a[94] = 0.468994;
      a[95] = 0.555908;
      a[96] = 0.221924;
      a[97] = 0.555908;
      a[98] = 0.555908;
      a[99] = 0.5;
      a[100] = 0.555908;
      a[101] = 0.555908;
      a[102] = 0.277832;
      a[103] = 0.555908;
      a[104] = 0.555908;
      a[105] = 0.221924;
      a[106] = 0.221924;
      a[107] = 0.5;
      a[108] = 0.221924;
      a[109] = 0.832764;
      a[110] = 0.555908;
      a[111] = 0.555908;
      a[112] = 0.555908;
      a[113] = 0.555908;
      a[114] = 0.332764;
      a[115] = 0.5;
      a[116] = 0.277832;
      a[117] = 0.555908;
      a[118] = 0.5;
      a[119] = 0.721924;
      a[120] = 0.5;
      a[121] = 0.5;
      a[122] = 0.5;
      a[123] = 0.333984;
      a[124] = 0.259766;
      a[125] = 0.333984;
      a[126] = 0.583984;
      a[161] = 0.332764;
      a[162] = 0.555908;
      a[163] = 0.555908;
      a[164] = 0.166992;
      a[165] = 0.555908;
      a[166] = 0.555908;
      a[167] = 0.555908;
      a[168] = 0.555908;
      a[169] = 0.190918;
      a[170] = 0.332764;
      a[171] = 0.555908;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.5;
      a[175] = 0.5;
      a[177] = 0.555908;
      a[178] = 0.555908;
      a[179] = 0.555908;
      a[180] = 0.277832;
      a[182] = 0.536865;
      a[183] = 0.349854;
      a[184] = 0.221924;
      a[185] = 0.332764;
      a[186] = 0.332764;
      a[187] = 0.555908;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.61084;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 1.0;
      a[227] = 0.369873;
      a[232] = 0.555908;
      a[233] = 0.777832;
      a[234] = 1.0;
      a[235] = 0.36499;
      a[241] = 0.888916;
      a[245] = 0.277832;
      a[248] = 0.221924;
      a[249] = 0.61084;
      a[250] = 0.943848;
      a[251] = 0.61084;
    }
    else if ( !strcmp(font, "Helvetica-Bold") ) {
      a[32] = 0.277832;
      a[33] = 0.332764;
      a[34] = 0.473877;
      a[35] = 0.555908;
      a[36] = 0.555908;
      a[37] = 0.888916;
      a[38] = 0.721924;
      a[39] = 0.277832;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.388916;
      a[43] = 0.583984;
      a[44] = 0.277832;
      a[45] = 0.332764;
      a[46] = 0.277832;
      a[47] = 0.277832;
      a[48] = 0.555908;
      a[49] = 0.555908;
      a[50] = 0.555908;
      a[51] = 0.555908;
      a[52] = 0.555908;
      a[53] = 0.555908;
      a[54] = 0.555908;
      a[55] = 0.555908;
      a[56] = 0.555908;
      a[57] = 0.555908;
      a[58] = 0.332764;
      a[59] = 0.332764;
      a[60] = 0.583984;
      a[61] = 0.583984;
      a[62] = 0.583984;
      a[63] = 0.61084;
      a[64] = 0.974854;
      a[65] = 0.721924;
      a[66] = 0.721924;
      a[67] = 0.721924;
      a[68] = 0.721924;
      a[69] = 0.666992;
      a[70] = 0.61084;
      a[71] = 0.777832;
      a[72] = 0.721924;
      a[73] = 0.277832;
      a[74] = 0.555908;
      a[75] = 0.721924;
      a[76] = 0.61084;
      a[77] = 0.832764;
      a[78] = 0.721924;
      a[79] = 0.777832;
      a[80] = 0.666992;
      a[81] = 0.777832;
      a[82] = 0.721924;
      a[83] = 0.666992;
      a[84] = 0.61084;
      a[85] = 0.721924;
      a[86] = 0.666992;
      a[87] = 0.943848;
      a[88] = 0.666992;
      a[89] = 0.666992;
      a[90] = 0.61084;
      a[91] = 0.332764;
      a[92] = 0.277832;
      a[93] = 0.332764;
      a[94] = 0.583984;
      a[95] = 0.555908;
      a[96] = 0.277832;
      a[97] = 0.555908;
      a[98] = 0.61084;
      a[99] = 0.555908;
      a[100] = 0.61084;
      a[101] = 0.555908;
      a[102] = 0.332764;
      a[103] = 0.61084;
      a[104] = 0.61084;
      a[105] = 0.277832;
      a[106] = 0.277832;
      a[107] = 0.555908;
      a[108] = 0.277832;
      a[109] = 0.888916;
      a[110] = 0.61084;
      a[111] = 0.61084;
      a[112] = 0.61084;
      a[113] = 0.61084;
      a[114] = 0.388916;
      a[115] = 0.555908;
      a[116] = 0.332764;
      a[117] = 0.61084;
      a[118] = 0.555908;
      a[119] = 0.777832;
      a[120] = 0.555908;
      a[121] = 0.555908;
      a[122] = 0.5;
      a[123] = 0.388916;
      a[124] = 0.279785;
      a[125] = 0.388916;
      a[126] = 0.583984;
      a[161] = 0.332764;
      a[162] = 0.555908;
      a[163] = 0.555908;
      a[164] = 0.166992;
      a[165] = 0.555908;
      a[166] = 0.555908;
      a[167] = 0.555908;
      a[168] = 0.555908;
      a[169] = 0.237793;
      a[170] = 0.5;
      a[171] = 0.555908;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.61084;
      a[175] = 0.61084;
      a[177] = 0.555908;
      a[178] = 0.555908;
      a[179] = 0.555908;
      a[180] = 0.277832;
      a[182] = 0.555908;
      a[183] = 0.349854;
      a[184] = 0.277832;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.555908;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.61084;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 1.0;
      a[227] = 0.369873;
      a[232] = 0.61084;
      a[233] = 0.777832;
      a[234] = 1.0;
      a[235] = 0.36499;
      a[241] = 0.888916;
      a[245] = 0.277832;
      a[248] = 0.277832;
      a[249] = 0.61084;
      a[250] = 0.943848;
      a[251] = 0.61084;
    }
    else if ( !strcmp(font, "Helvetica-BoldOblique") ) {
      a[32] = 0.277832;
      a[33] = 0.332764;
      a[34] = 0.473877;
      a[35] = 0.555908;
      a[36] = 0.555908;
      a[37] = 0.888916;
      a[38] = 0.721924;
      a[39] = 0.277832;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.388916;
      a[43] = 0.583984;
      a[44] = 0.277832;
      a[45] = 0.332764;
      a[46] = 0.277832;
      a[47] = 0.277832;
      a[48] = 0.555908;
      a[49] = 0.555908;
      a[50] = 0.555908;
      a[51] = 0.555908;
      a[52] = 0.555908;
      a[53] = 0.555908;
      a[54] = 0.555908;
      a[55] = 0.555908;
      a[56] = 0.555908;
      a[57] = 0.555908;
      a[58] = 0.332764;
      a[59] = 0.332764;
      a[60] = 0.583984;
      a[61] = 0.583984;
      a[62] = 0.583984;
      a[63] = 0.61084;
      a[64] = 0.974854;
      a[65] = 0.721924;
      a[66] = 0.721924;
      a[67] = 0.721924;
      a[68] = 0.721924;
      a[69] = 0.666992;
      a[70] = 0.61084;
      a[71] = 0.777832;
      a[72] = 0.721924;
      a[73] = 0.277832;
      a[74] = 0.555908;
      a[75] = 0.721924;
      a[76] = 0.61084;
      a[77] = 0.832764;
      a[78] = 0.721924;
      a[79] = 0.777832;
      a[80] = 0.666992;
      a[81] = 0.777832;
      a[82] = 0.721924;
      a[83] = 0.666992;
      a[84] = 0.61084;
      a[85] = 0.721924;
      a[86] = 0.666992;
      a[87] = 0.943848;
      a[88] = 0.666992;
      a[89] = 0.666992;
      a[90] = 0.61084;
      a[91] = 0.332764;
      a[92] = 0.277832;
      a[93] = 0.332764;
      a[94] = 0.583984;
      a[95] = 0.555908;
      a[96] = 0.277832;
      a[97] = 0.555908;
      a[98] = 0.61084;
      a[99] = 0.555908;
      a[100] = 0.61084;
      a[101] = 0.555908;
      a[102] = 0.332764;
      a[103] = 0.61084;
      a[104] = 0.61084;
      a[105] = 0.277832;
      a[106] = 0.277832;
      a[107] = 0.555908;
      a[108] = 0.277832;
      a[109] = 0.888916;
      a[110] = 0.61084;
      a[111] = 0.61084;
      a[112] = 0.61084;
      a[113] = 0.61084;
      a[114] = 0.388916;
      a[115] = 0.555908;
      a[116] = 0.332764;
      a[117] = 0.61084;
      a[118] = 0.555908;
      a[119] = 0.777832;
      a[120] = 0.555908;
      a[121] = 0.555908;
      a[122] = 0.5;
      a[123] = 0.388916;
      a[124] = 0.279785;
      a[125] = 0.388916;
      a[126] = 0.583984;
      a[161] = 0.332764;
      a[162] = 0.555908;
      a[163] = 0.555908;
      a[164] = 0.166992;
      a[165] = 0.555908;
      a[166] = 0.555908;
      a[167] = 0.555908;
      a[168] = 0.555908;
      a[169] = 0.237793;
      a[170] = 0.5;
      a[171] = 0.555908;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.61084;
      a[175] = 0.61084;
      a[177] = 0.555908;
      a[178] = 0.555908;
      a[179] = 0.555908;
      a[180] = 0.277832;
      a[182] = 0.555908;
      a[183] = 0.349854;
      a[184] = 0.277832;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.555908;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.61084;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 1.0;
      a[227] = 0.369873;
      a[232] = 0.61084;
      a[233] = 0.777832;
      a[234] = 1.0;
      a[235] = 0.36499;
      a[241] = 0.888916;
      a[245] = 0.277832;
      a[248] = 0.277832;
      a[249] = 0.61084;
      a[250] = 0.943848;
      a[251] = 0.61084;
    }
    else if ( !strcmp(font, "Courier") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Courier-Oblique") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Courier-Bold") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Courier-BoldOblique") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Symbol") ) {
      a[32] = 0.25;
      a[33] = 0.332764;
      a[34] = 0.712891;
      a[35] = 0.5;
      a[36] = 0.548828;
      a[37] = 0.832764;
      a[38] = 0.777832;
      a[39] = 0.438965;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.5;
      a[43] = 0.548828;
      a[44] = 0.25;
      a[45] = 0.548828;
      a[46] = 0.25;
      a[47] = 0.277832;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.277832;
      a[59] = 0.277832;
      a[60] = 0.548828;
      a[61] = 0.548828;
      a[62] = 0.548828;
      a[63] = 0.443848;
      a[64] = 0.548828;
      a[65] = 0.721924;
      a[66] = 0.666992;
      a[67] = 0.721924;
      a[68] = 0.611816;
      a[69] = 0.61084;
      a[70] = 0.762939;
      a[71] = 0.602783;
      a[72] = 0.721924;
      a[73] = 0.332764;
      a[74] = 0.630859;
      a[75] = 0.721924;
      a[76] = 0.685791;
      a[77] = 0.888916;
      a[78] = 0.721924;
      a[79] = 0.721924;
      a[80] = 0.767822;
      a[81] = 0.740967;
      a[82] = 0.555908;
      a[83] = 0.591797;
      a[84] = 0.61084;
      a[85] = 0.689941;
      a[86] = 0.438965;
      a[87] = 0.767822;
      a[88] = 0.644775;
      a[89] = 0.794922;
      a[90] = 0.61084;
      a[91] = 0.332764;
      a[92] = 0.862793;
      a[93] = 0.332764;
      a[94] = 0.657959;
      a[95] = 0.5;
      a[96] = 0.5;
      a[97] = 0.630859;
      a[98] = 0.548828;
      a[99] = 0.548828;
      a[100] = 0.493896;
      a[101] = 0.438965;
      a[102] = 0.520996;
      a[103] = 0.410889;
      a[104] = 0.602783;
      a[105] = 0.328857;
      a[106] = 0.602783;
      a[107] = 0.548828;
      a[108] = 0.548828;
      a[109] = 0.575928;
      a[110] = 0.520996;
      a[111] = 0.548828;
      a[112] = 0.548828;
      a[113] = 0.520996;
      a[114] = 0.548828;
      a[115] = 0.602783;
      a[116] = 0.438965;
      a[117] = 0.575928;
      a[118] = 0.712891;
      a[119] = 0.685791;
      a[120] = 0.49292;
      a[121] = 0.685791;
      a[122] = 0.493896;
      a[123] = 0.47998;
      a[124] = 0.199951;
      a[125] = 0.47998;
      a[126] = 0.548828;
      a[161] = 0.619873;
      a[162] = 0.246826;
      a[163] = 0.548828;
      a[164] = 0.166992;
      a[165] = 0.712891;
      a[166] = 0.5;
      a[167] = 0.75293;
      a[168] = 0.75293;
      a[169] = 0.75293;
      a[170] = 0.75293;
      a[171] = 1.04199;
      a[172] = 0.986816;
      a[173] = 0.602783;
      a[174] = 0.986816;
      a[175] = 0.602783;
      a[176] = 0.399902;
      a[177] = 0.548828;
      a[178] = 0.410889;
      a[179] = 0.548828;
      a[180] = 0.548828;
      a[181] = 0.712891;
      a[182] = 0.493896;
      a[183] = 0.459961;
      a[184] = 0.548828;
      a[185] = 0.548828;
      a[186] = 0.548828;
      a[187] = 0.548828;
      a[188] = 1.0;
      a[189] = 0.602783;
      a[190] = 1.0;
      a[191] = 0.657959;
      a[192] = 0.822998;
      a[193] = 0.685791;
      a[194] = 0.794922;
      a[195] = 0.986816;
      a[196] = 0.767822;
      a[197] = 0.767822;
      a[198] = 0.822998;
      a[199] = 0.767822;
      a[200] = 0.767822;
      a[201] = 0.712891;
      a[202] = 0.712891;
      a[203] = 0.712891;
      a[204] = 0.712891;
      a[205] = 0.712891;
      a[206] = 0.712891;
      a[207] = 0.712891;
      a[208] = 0.767822;
      a[209] = 0.712891;
      a[210] = 0.789795;
      a[211] = 0.789795;
      a[212] = 0.889893;
      a[213] = 0.822998;
      a[214] = 0.548828;
      a[215] = 0.25;
      a[216] = 0.712891;
      a[217] = 0.602783;
      a[218] = 0.602783;
      a[219] = 1.04199;
      a[220] = 0.986816;
      a[221] = 0.602783;
      a[222] = 0.986816;
      a[223] = 0.602783;
      a[224] = 0.493896;
      a[225] = 0.328857;
      a[226] = 0.789795;
      a[227] = 0.789795;
      a[228] = 0.785889;
      a[229] = 0.712891;
      a[230] = 0.383789;
      a[231] = 0.383789;
      a[232] = 0.383789;
      a[233] = 0.383789;
      a[234] = 0.383789;
      a[235] = 0.383789;
      a[236] = 0.493896;
      a[237] = 0.493896;
      a[238] = 0.493896;
      a[239] = 0.493896;
      a[241] = 0.328857;
      a[242] = 0.273926;
      a[243] = 0.685791;
      a[244] = 0.685791;
      a[245] = 0.685791;
      a[246] = 0.383789;
      a[247] = 0.383789;
      a[248] = 0.383789;
      a[249] = 0.383789;
      a[250] = 0.383789;
      a[251] = 0.383789;
      a[252] = 0.493896;
      a[253] = 0.493896;
      a[254] = 0.493896;
    }
    else if (
	     !strcmp(font, "AvantGarde-Book") ||
	     !strcmp(font, "AvantGarde-BookOblique") ) {
      a[32] = 0.276855;
      a[33] = 0.294922;
      a[34] = 0.308838;
      a[35] = 0.719971;
      a[36] = 0.553955;
      a[37] = 0.774902;
      a[38] = 0.756836;
      a[39] = 0.35083;
      a[40] = 0.368896;
      a[41] = 0.368896;
      a[42] = 0.424805;
      a[43] = 0.605957;
      a[44] = 0.276855;
      a[45] = 0.331787;
      a[46] = 0.276855;
      a[47] = 0.436768;
      a[48] = 0.553955;
      a[49] = 0.553955;
      a[50] = 0.553955;
      a[51] = 0.553955;
      a[52] = 0.553955;
      a[53] = 0.553955;
      a[54] = 0.553955;
      a[55] = 0.553955;
      a[56] = 0.553955;
      a[57] = 0.553955;
      a[58] = 0.276855;
      a[59] = 0.276855;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.59082;
      a[64] = 0.866943;
      a[65] = 0.73999;
      a[66] = 0.573975;
      a[67] = 0.812988;
      a[68] = 0.743896;
      a[69] = 0.535889;
      a[70] = 0.484863;
      a[71] = 0.871826;
      a[72] = 0.682861;
      a[73] = 0.22583;
      a[74] = 0.481934;
      a[75] = 0.59082;
      a[76] = 0.461914;
      a[77] = 0.918945;
      a[78] = 0.73999;
      a[79] = 0.868896;
      a[80] = 0.591797;
      a[81] = 0.87085;
      a[82] = 0.606934;
      a[83] = 0.497803;
      a[84] = 0.425781;
      a[85] = 0.654785;
      a[86] = 0.701904;
      a[87] = 0.959961;
      a[88] = 0.608887;
      a[89] = 0.591797;
      a[90] = 0.47998;
      a[91] = 0.35083;
      a[92] = 0.60498;
      a[93] = 0.35083;
      a[94] = 0.671875;
      a[95] = 0.5;
      a[96] = 0.35083;
      a[97] = 0.682861;
      a[98] = 0.681885;
      a[99] = 0.646973;
      a[100] = 0.684814;
      a[101] = 0.649902;
      a[102] = 0.313965;
      a[103] = 0.672852;
      a[104] = 0.609863;
      a[105] = 0.199951;
      a[106] = 0.202881;
      a[107] = 0.501953;
      a[108] = 0.199951;
      a[109] = 0.937988;
      a[110] = 0.609863;
      a[111] = 0.654785;
      a[112] = 0.681885;
      a[113] = 0.681885;
      a[114] = 0.300781;
      a[115] = 0.387939;
      a[116] = 0.338867;
      a[117] = 0.60791;
      a[118] = 0.553955;
      a[119] = 0.830811;
      a[120] = 0.47998;
      a[121] = 0.535889;
      a[122] = 0.424805;
      a[123] = 0.35083;
      a[124] = 0.671875;
      a[125] = 0.35083;
      a[126] = 0.605957;
      a[161] = 0.294922;
      a[162] = 0.553955;
      a[163] = 0.553955;
      a[164] = 0.165771;
      a[165] = 0.553955;
      a[166] = 0.553955;
      a[169] = 0.197998;
      a[170] = 0.501953;
      a[171] = 0.424805;
      a[172] = 0.250977;
      a[173] = 0.250977;
      a[174] = 0.486816;
      a[175] = 0.484863;
      a[177] = 0.5;
      a[179] = 0.552979;
      a[180] = 0.276855;
      a[183] = 0.605957;
      a[185] = 0.501953;
      a[186] = 0.483887;
      a[187] = 0.424805;
      a[188] = 1.0;
      a[191] = 0.59082;
      a[193] = 0.37793;
      a[194] = 0.375;
      a[195] = 0.501953;
      a[196] = 0.438965;
      a[200] = 0.368896;
      a[203] = 0.323975;
      a[205] = 0.551758;
      a[208] = 1.0;
      a[225] = 0.991943;
      a[234] = 1.19385;
      a[241] = 1.15698;
      a[245] = 0.199951;
      a[250] = 1.13696;
      a[251] = 0.553955;
    }
    else if (
	     !strcmp(font, "AvantGarde-Demi") ||
	     !strcmp(font, "AvantGarde-DemiOblique") ) {
      a[32] = 0.279785;
      a[33] = 0.279785;
      a[34] = 0.359863;
      a[35] = 0.599854;
      a[36] = 0.559814;
      a[37] = 0.859863;
      a[38] = 0.679932;
      a[39] = 0.279785;
      a[40] = 0.379883;
      a[41] = 0.379883;
      a[42] = 0.439941;
      a[43] = 0.599854;
      a[44] = 0.279785;
      a[45] = 0.419922;
      a[46] = 0.279785;
      a[47] = 0.459961;
      a[48] = 0.559814;
      a[49] = 0.559814;
      a[50] = 0.559814;
      a[51] = 0.559814;
      a[52] = 0.559814;
      a[53] = 0.559814;
      a[54] = 0.559814;
      a[55] = 0.559814;
      a[56] = 0.559814;
      a[57] = 0.559814;
      a[58] = 0.279785;
      a[59] = 0.279785;
      a[60] = 0.599854;
      a[61] = 0.599854;
      a[62] = 0.599854;
      a[63] = 0.559814;
      a[64] = 0.73999;
      a[65] = 0.73999;
      a[66] = 0.579834;
      a[67] = 0.779785;
      a[68] = 0.699951;
      a[69] = 0.519775;
      a[70] = 0.47998;
      a[71] = 0.839844;
      a[72] = 0.679932;
      a[73] = 0.279785;
      a[74] = 0.47998;
      a[75] = 0.619873;
      a[76] = 0.439941;
      a[77] = 0.899902;
      a[78] = 0.73999;
      a[79] = 0.839844;
      a[80] = 0.559814;
      a[81] = 0.839844;
      a[82] = 0.579834;
      a[83] = 0.519775;
      a[84] = 0.419922;
      a[85] = 0.639893;
      a[86] = 0.699951;
      a[87] = 0.899902;
      a[88] = 0.679932;
      a[89] = 0.619873;
      a[90] = 0.5;
      a[91] = 0.319824;
      a[92] = 0.639893;
      a[93] = 0.319824;
      a[94] = 0.599854;
      a[95] = 0.5;
      a[96] = 0.279785;
      a[97] = 0.659912;
      a[98] = 0.659912;
      a[99] = 0.639893;
      a[100] = 0.659912;
      a[101] = 0.639893;
      a[102] = 0.279785;
      a[103] = 0.659912;
      a[104] = 0.599854;
      a[105] = 0.23999;
      a[106] = 0.259766;
      a[107] = 0.579834;
      a[108] = 0.23999;
      a[109] = 0.939941;
      a[110] = 0.599854;
      a[111] = 0.639893;
      a[112] = 0.659912;
      a[113] = 0.659912;
      a[114] = 0.319824;
      a[115] = 0.439941;
      a[116] = 0.299805;
      a[117] = 0.599854;
      a[118] = 0.559814;
      a[119] = 0.799805;
      a[120] = 0.559814;
      a[121] = 0.579834;
      a[122] = 0.459961;
      a[123] = 0.339844;
      a[124] = 0.599854;
      a[125] = 0.339844;
      a[126] = 0.599854;
      a[161] = 0.279785;
      a[162] = 0.559814;
      a[163] = 0.559814;
      a[164] = 0.159912;
      a[165] = 0.559814;
      a[166] = 0.559814;
      a[169] = 0.219971;
      a[170] = 0.47998;
      a[171] = 0.459961;
      a[172] = 0.23999;
      a[173] = 0.23999;
      a[174] = 0.519775;
      a[175] = 0.519775;
      a[177] = 0.5;
      a[179] = 0.559814;
      a[180] = 0.279785;
      a[183] = 0.599854;
      a[185] = 0.47998;
      a[186] = 0.47998;
      a[187] = 0.459961;
      a[188] = 1.0;
      a[191] = 0.559814;
      a[193] = 0.419922;
      a[194] = 0.419922;
      a[195] = 0.539795;
      a[196] = 0.47998;
      a[200] = 0.5;
      a[203] = 0.339844;
      a[205] = 0.699951;
      a[208] = 1.0;
      a[225] = 0.899902;
      a[234] = 1.05981;
      a[241] = 1.07983;
      a[245] = 0.23999;
      a[250] = 1.07983;
      a[251] = 0.599854;
    }
    else if ( !strcmp(font, "Bookman-Light") ) {
      a[32] = 0.319824;
      a[33] = 0.299805;
      a[34] = 0.379883;
      a[35] = 0.619873;
      a[36] = 0.619873;
      a[37] = 0.899902;
      a[38] = 0.799805;
      a[39] = 0.219971;
      a[40] = 0.299805;
      a[41] = 0.299805;
      a[42] = 0.439941;
      a[43] = 0.599854;
      a[44] = 0.319824;
      a[45] = 0.399902;
      a[46] = 0.319824;
      a[47] = 0.599854;
      a[48] = 0.619873;
      a[49] = 0.619873;
      a[50] = 0.619873;
      a[51] = 0.619873;
      a[52] = 0.619873;
      a[53] = 0.619873;
      a[54] = 0.619873;
      a[55] = 0.619873;
      a[56] = 0.619873;
      a[57] = 0.619873;
      a[58] = 0.319824;
      a[59] = 0.319824;
      a[60] = 0.599854;
      a[61] = 0.599854;
      a[62] = 0.599854;
      a[63] = 0.539795;
      a[64] = 0.819824;
      a[65] = 0.679932;
      a[66] = 0.73999;
      a[67] = 0.73999;
      a[68] = 0.799805;
      a[69] = 0.719971;
      a[70] = 0.639893;
      a[71] = 0.799805;
      a[72] = 0.799805;
      a[73] = 0.339844;
      a[74] = 0.599854;
      a[75] = 0.719971;
      a[76] = 0.599854;
      a[77] = 0.919922;
      a[78] = 0.73999;
      a[79] = 0.799805;
      a[80] = 0.619873;
      a[81] = 0.819824;
      a[82] = 0.719971;
      a[83] = 0.659912;
      a[84] = 0.619873;
      a[85] = 0.779785;
      a[86] = 0.699951;
      a[87] = 0.959961;
      a[88] = 0.719971;
      a[89] = 0.639893;
      a[90] = 0.639893;
      a[91] = 0.299805;
      a[92] = 0.599854;
      a[93] = 0.299805;
      a[94] = 0.599854;
      a[95] = 0.5;
      a[96] = 0.219971;
      a[97] = 0.579834;
      a[98] = 0.619873;
      a[99] = 0.519775;
      a[100] = 0.619873;
      a[101] = 0.519775;
      a[102] = 0.319824;
      a[103] = 0.539795;
      a[104] = 0.659912;
      a[105] = 0.299805;
      a[106] = 0.299805;
      a[107] = 0.619873;
      a[108] = 0.299805;
      a[109] = 0.939941;
      a[110] = 0.659912;
      a[111] = 0.559814;
      a[112] = 0.619873;
      a[113] = 0.579834;
      a[114] = 0.439941;
      a[115] = 0.519775;
      a[116] = 0.379883;
      a[117] = 0.679932;
      a[118] = 0.519775;
      a[119] = 0.779785;
      a[120] = 0.559814;
      a[121] = 0.539795;
      a[122] = 0.47998;
      a[123] = 0.279785;
      a[124] = 0.599854;
      a[125] = 0.279785;
      a[126] = 0.599854;
      a[161] = 0.299805;
      a[162] = 0.619873;
      a[163] = 0.619873;
      a[164] = 0.139893;
      a[165] = 0.619873;
      a[166] = 0.619873;
      a[169] = 0.219971;
      a[170] = 0.399902;
      a[171] = 0.359863;
      a[172] = 0.23999;
      a[173] = 0.23999;
      a[174] = 0.619873;
      a[175] = 0.619873;
      a[177] = 0.5;
      a[179] = 0.539795;
      a[180] = 0.319824;
      a[183] = 0.459961;
      a[185] = 0.399902;
      a[186] = 0.399902;
      a[187] = 0.359863;
      a[188] = 1.0;
      a[191] = 0.539795;
      a[193] = 0.339844;
      a[194] = 0.339844;
      a[195] = 0.419922;
      a[196] = 0.439941;
      a[200] = 0.419922;
      a[203] = 0.319824;
      a[205] = 0.379883;
      a[208] = 1.0;
      a[225] = 1.25977;
      a[234] = 1.23999;
      a[241] = 0.859863;
      a[245] = 0.299805;
      a[250] = 0.899902;
      a[251] = 0.659912;
    }
    else if ( !strcmp(font, "Bookman-LightItalic") ) {
      a[32] = 0.299805;
      a[33] = 0.319824;
      a[34] = 0.359863;
      a[35] = 0.619873;
      a[36] = 0.619873;
      a[37] = 0.799805;
      a[38] = 0.819824;
      a[39] = 0.279785;
      a[40] = 0.279785;
      a[41] = 0.279785;
      a[42] = 0.439941;
      a[43] = 0.599854;
      a[44] = 0.299805;
      a[45] = 0.319824;
      a[46] = 0.299805;
      a[47] = 0.599854;
      a[48] = 0.619873;
      a[49] = 0.619873;
      a[50] = 0.619873;
      a[51] = 0.619873;
      a[52] = 0.619873;
      a[53] = 0.619873;
      a[54] = 0.619873;
      a[55] = 0.619873;
      a[56] = 0.619873;
      a[57] = 0.619873;
      a[58] = 0.299805;
      a[59] = 0.299805;
      a[60] = 0.599854;
      a[61] = 0.599854;
      a[62] = 0.599854;
      a[63] = 0.539795;
      a[64] = 0.779785;
      a[65] = 0.699951;
      a[66] = 0.719971;
      a[67] = 0.719971;
      a[68] = 0.73999;
      a[69] = 0.679932;
      a[70] = 0.619873;
      a[71] = 0.759766;
      a[72] = 0.799805;
      a[73] = 0.319824;
      a[74] = 0.559814;
      a[75] = 0.719971;
      a[76] = 0.579834;
      a[77] = 0.859863;
      a[78] = 0.719971;
      a[79] = 0.759766;
      a[80] = 0.599854;
      a[81] = 0.779785;
      a[82] = 0.699951;
      a[83] = 0.639893;
      a[84] = 0.599854;
      a[85] = 0.719971;
      a[86] = 0.679932;
      a[87] = 0.959961;
      a[88] = 0.699951;
      a[89] = 0.659912;
      a[90] = 0.579834;
      a[91] = 0.259766;
      a[92] = 0.599854;
      a[93] = 0.259766;
      a[94] = 0.599854;
      a[95] = 0.5;
      a[96] = 0.279785;
      a[97] = 0.619873;
      a[98] = 0.599854;
      a[99] = 0.47998;
      a[100] = 0.639893;
      a[101] = 0.539795;
      a[102] = 0.339844;
      a[103] = 0.559814;
      a[104] = 0.619873;
      a[105] = 0.279785;
      a[106] = 0.279785;
      a[107] = 0.599854;
      a[108] = 0.279785;
      a[109] = 0.879883;
      a[110] = 0.619873;
      a[111] = 0.539795;
      a[112] = 0.599854;
      a[113] = 0.559814;
      a[114] = 0.399902;
      a[115] = 0.539795;
      a[116] = 0.339844;
      a[117] = 0.619873;
      a[118] = 0.539795;
      a[119] = 0.879883;
      a[120] = 0.539795;
      a[121] = 0.599854;
      a[122] = 0.519775;
      a[123] = 0.359863;
      a[124] = 0.599854;
      a[125] = 0.379883;
      a[126] = 0.599854;
      a[161] = 0.319824;
      a[162] = 0.619873;
      a[163] = 0.619873;
      a[164] = 0.0197754;
      a[165] = 0.619873;
      a[166] = 0.619873;
      a[169] = 0.199951;
      a[170] = 0.439941;
      a[171] = 0.299805;
      a[172] = 0.179932;
      a[173] = 0.179932;
      a[174] = 0.639893;
      a[175] = 0.659912;
      a[177] = 0.5;
      a[179] = 0.619873;
      a[180] = 0.299805;
      a[183] = 0.459961;
      a[185] = 0.47998;
      a[186] = 0.439941;
      a[187] = 0.299805;
      a[188] = 1.0;
      a[191] = 0.539795;
      a[193] = 0.339844;
      a[194] = 0.319824;
      a[195] = 0.439941;
      a[196] = 0.439941;
      a[200] = 0.419922;
      a[203] = 0.319824;
      a[205] = 0.339844;
      a[208] = 1.0;
      a[225] = 1.21997;
      a[234] = 1.17993;
      a[241] = 0.879883;
      a[245] = 0.279785;
      a[250] = 0.899902;
      a[251] = 0.619873;
    }
    else if ( !strcmp(font, "Bookman-Demi") ) {
      a[32] = 0.339844;
      a[33] = 0.359863;
      a[34] = 0.419922;
      a[35] = 0.659912;
      a[36] = 0.659912;
      a[37] = 0.939941;
      a[38] = 0.799805;
      a[39] = 0.319824;
      a[40] = 0.319824;
      a[41] = 0.319824;
      a[42] = 0.459961;
      a[43] = 0.599854;
      a[44] = 0.339844;
      a[45] = 0.359863;
      a[46] = 0.339844;
      a[47] = 0.599854;
      a[48] = 0.659912;
      a[49] = 0.659912;
      a[50] = 0.659912;
      a[51] = 0.659912;
      a[52] = 0.659912;
      a[53] = 0.659912;
      a[54] = 0.659912;
      a[55] = 0.659912;
      a[56] = 0.659912;
      a[57] = 0.659912;
      a[58] = 0.339844;
      a[59] = 0.339844;
      a[60] = 0.599854;
      a[61] = 0.599854;
      a[62] = 0.599854;
      a[63] = 0.659912;
      a[64] = 0.819824;
      a[65] = 0.719971;
      a[66] = 0.719971;
      a[67] = 0.73999;
      a[68] = 0.779785;
      a[69] = 0.719971;
      a[70] = 0.679932;
      a[71] = 0.779785;
      a[72] = 0.819824;
      a[73] = 0.399902;
      a[74] = 0.639893;
      a[75] = 0.799805;
      a[76] = 0.639893;
      a[77] = 0.939941;
      a[78] = 0.73999;
      a[79] = 0.799805;
      a[80] = 0.659912;
      a[81] = 0.799805;
      a[82] = 0.779785;
      a[83] = 0.659912;
      a[84] = 0.699951;
      a[85] = 0.73999;
      a[86] = 0.719971;
      a[87] = 0.939941;
      a[88] = 0.779785;
      a[89] = 0.699951;
      a[90] = 0.639893;
      a[91] = 0.299805;
      a[92] = 0.599854;
      a[93] = 0.299805;
      a[94] = 0.599854;
      a[95] = 0.5;
      a[96] = 0.319824;
      a[97] = 0.579834;
      a[98] = 0.599854;
      a[99] = 0.579834;
      a[100] = 0.639893;
      a[101] = 0.579834;
      a[102] = 0.379883;
      a[103] = 0.579834;
      a[104] = 0.679932;
      a[105] = 0.359863;
      a[106] = 0.339844;
      a[107] = 0.659912;
      a[108] = 0.339844;
      a[109] = 1.0;
      a[110] = 0.679932;
      a[111] = 0.619873;
      a[112] = 0.639893;
      a[113] = 0.619873;
      a[114] = 0.459961;
      a[115] = 0.519775;
      a[116] = 0.459961;
      a[117] = 0.659912;
      a[118] = 0.599854;
      a[119] = 0.799805;
      a[120] = 0.599854;
      a[121] = 0.619873;
      a[122] = 0.559814;
      a[123] = 0.319824;
      a[124] = 0.599854;
      a[125] = 0.319824;
      a[126] = 0.599854;
      a[161] = 0.359863;
      a[162] = 0.659912;
      a[163] = 0.659912;
      a[164] = 0.119873;
      a[165] = 0.659912;
      a[166] = 0.659912;
      a[169] = 0.23999;
      a[170] = 0.539795;
      a[171] = 0.399902;
      a[172] = 0.219971;
      a[173] = 0.219971;
      a[174] = 0.73999;
      a[175] = 0.73999;
      a[177] = 0.5;
      a[179] = 0.379883;
      a[180] = 0.339844;
      a[183] = 0.459961;
      a[185] = 0.539795;
      a[186] = 0.539795;
      a[187] = 0.399902;
      a[188] = 1.0;
      a[191] = 0.659912;
      a[193] = 0.399902;
      a[194] = 0.399902;
      a[195] = 0.5;
      a[196] = 0.47998;
      a[200] = 0.5;
      a[203] = 0.359863;
      a[205] = 0.439941;
      a[208] = 1.0;
      a[225] = 1.13989;
      a[234] = 1.21997;
      a[241] = 0.879883;
      a[245] = 0.359863;
      a[250] = 0.939941;
      a[251] = 0.659912;
    }
    else if ( !strcmp(font, "Bookman-DemiItalic") ) {
      a[32] = 0.339844;
      a[33] = 0.319824;
      a[34] = 0.379883;
      a[35] = 0.679932;
      a[36] = 0.679932;
      a[37] = 0.879883;
      a[38] = 0.97998;
      a[39] = 0.319824;
      a[40] = 0.259766;
      a[41] = 0.259766;
      a[42] = 0.459961;
      a[43] = 0.599854;
      a[44] = 0.339844;
      a[45] = 0.279785;
      a[46] = 0.339844;
      a[47] = 0.359863;
      a[48] = 0.679932;
      a[49] = 0.679932;
      a[50] = 0.679932;
      a[51] = 0.679932;
      a[52] = 0.679932;
      a[53] = 0.679932;
      a[54] = 0.679932;
      a[55] = 0.679932;
      a[56] = 0.679932;
      a[57] = 0.679932;
      a[58] = 0.339844;
      a[59] = 0.339844;
      a[60] = 0.619873;
      a[61] = 0.599854;
      a[62] = 0.619873;
      a[63] = 0.619873;
      a[64] = 0.779785;
      a[65] = 0.719971;
      a[66] = 0.719971;
      a[67] = 0.699951;
      a[68] = 0.759766;
      a[69] = 0.719971;
      a[70] = 0.659912;
      a[71] = 0.759766;
      a[72] = 0.799805;
      a[73] = 0.379883;
      a[74] = 0.619873;
      a[75] = 0.779785;
      a[76] = 0.639893;
      a[77] = 0.859863;
      a[78] = 0.73999;
      a[79] = 0.759766;
      a[80] = 0.639893;
      a[81] = 0.759766;
      a[82] = 0.73999;
      a[83] = 0.699951;
      a[84] = 0.699951;
      a[85] = 0.73999;
      a[86] = 0.659912;
      a[87] = 1.0;
      a[88] = 0.73999;
      a[89] = 0.659912;
      a[90] = 0.679932;
      a[91] = 0.259766;
      a[92] = 0.579834;
      a[93] = 0.259766;
      a[94] = 0.619873;
      a[95] = 0.5;
      a[96] = 0.319824;
      a[97] = 0.679932;
      a[98] = 0.599854;
      a[99] = 0.559814;
      a[100] = 0.679932;
      a[101] = 0.559814;
      a[102] = 0.419922;
      a[103] = 0.619873;
      a[104] = 0.699951;
      a[105] = 0.379883;
      a[106] = 0.319824;
      a[107] = 0.699951;
      a[108] = 0.379883;
      a[109] = 0.959961;
      a[110] = 0.679932;
      a[111] = 0.599854;
      a[112] = 0.659912;
      a[113] = 0.619873;
      a[114] = 0.5;
      a[115] = 0.539795;
      a[116] = 0.439941;
      a[117] = 0.679932;
      a[118] = 0.539795;
      a[119] = 0.859863;
      a[120] = 0.619873;
      a[121] = 0.599854;
      a[122] = 0.559814;
      a[123] = 0.299805;
      a[124] = 0.619873;
      a[125] = 0.299805;
      a[126] = 0.619873;
      a[161] = 0.319824;
      a[162] = 0.679932;
      a[163] = 0.679932;
      a[164] = 0.119873;
      a[165] = 0.679932;
      a[166] = 0.679932;
      a[169] = 0.179932;
      a[170] = 0.519775;
      a[171] = 0.379883;
      a[172] = 0.219971;
      a[173] = 0.219971;
      a[174] = 0.819824;
      a[175] = 0.819824;
      a[177] = 0.5;
      a[179] = 0.419922;
      a[180] = 0.339844;
      a[183] = 0.359863;
      a[185] = 0.519775;
      a[186] = 0.519775;
      a[187] = 0.379883;
      a[188] = 1.0;
      a[191] = 0.619873;
      a[193] = 0.379883;
      a[194] = 0.339844;
      a[195] = 0.47998;
      a[196] = 0.47998;
      a[200] = 0.519775;
      a[203] = 0.359863;
      a[205] = 0.559814;
      a[208] = 1.0;
      a[225] = 1.13989;
      a[234] = 1.17993;
      a[241] = 0.879883;
      a[245] = 0.379883;
      a[250] = 0.919922;
      a[251] = 0.659912;
    }
    else if ( !strcmp(font, "Helvetica-Narrow") ) {
      a[32] = 0.227783;
      a[33] = 0.227783;
      a[34] = 0.290771;
      a[35] = 0.455811;
      a[36] = 0.455811;
      a[37] = 0.72876;
      a[38] = 0.546875;
      a[39] = 0.181885;
      a[40] = 0.272949;
      a[41] = 0.272949;
      a[42] = 0.318848;
      a[43] = 0.47876;
      a[44] = 0.227783;
      a[45] = 0.272949;
      a[46] = 0.227783;
      a[47] = 0.227783;
      a[48] = 0.455811;
      a[49] = 0.455811;
      a[50] = 0.455811;
      a[51] = 0.455811;
      a[52] = 0.455811;
      a[53] = 0.455811;
      a[54] = 0.455811;
      a[55] = 0.455811;
      a[56] = 0.455811;
      a[57] = 0.455811;
      a[58] = 0.227783;
      a[59] = 0.227783;
      a[60] = 0.47876;
      a[61] = 0.47876;
      a[62] = 0.47876;
      a[63] = 0.455811;
      a[64] = 0.831787;
      a[65] = 0.546875;
      a[66] = 0.546875;
      a[67] = 0.591797;
      a[68] = 0.591797;
      a[69] = 0.546875;
      a[70] = 0.500977;
      a[71] = 0.637939;
      a[72] = 0.591797;
      a[73] = 0.227783;
      a[74] = 0.409912;
      a[75] = 0.546875;
      a[76] = 0.455811;
      a[77] = 0.682861;
      a[78] = 0.591797;
      a[79] = 0.637939;
      a[80] = 0.546875;
      a[81] = 0.637939;
      a[82] = 0.591797;
      a[83] = 0.546875;
      a[84] = 0.500977;
      a[85] = 0.591797;
      a[86] = 0.546875;
      a[87] = 0.773926;
      a[88] = 0.546875;
      a[89] = 0.546875;
      a[90] = 0.500977;
      a[91] = 0.227783;
      a[92] = 0.227783;
      a[93] = 0.227783;
      a[94] = 0.384766;
      a[95] = 0.455811;
      a[96] = 0.181885;
      a[97] = 0.455811;
      a[98] = 0.455811;
      a[99] = 0.409912;
      a[100] = 0.455811;
      a[101] = 0.455811;
      a[102] = 0.227783;
      a[103] = 0.455811;
      a[104] = 0.455811;
      a[105] = 0.181885;
      a[106] = 0.181885;
      a[107] = 0.409912;
      a[108] = 0.181885;
      a[109] = 0.682861;
      a[110] = 0.455811;
      a[111] = 0.455811;
      a[112] = 0.455811;
      a[113] = 0.455811;
      a[114] = 0.272949;
      a[115] = 0.409912;
      a[116] = 0.227783;
      a[117] = 0.455811;
      a[118] = 0.409912;
      a[119] = 0.591797;
      a[120] = 0.409912;
      a[121] = 0.409912;
      a[122] = 0.409912;
      a[123] = 0.273926;
      a[124] = 0.212891;
      a[125] = 0.273926;
      a[126] = 0.47876;
      a[161] = 0.272949;
      a[162] = 0.455811;
      a[163] = 0.455811;
      a[164] = 0.136963;
      a[165] = 0.455811;
      a[166] = 0.455811;
      a[169] = 0.156982;
      a[170] = 0.272949;
      a[171] = 0.455811;
      a[172] = 0.272949;
      a[173] = 0.272949;
      a[174] = 0.409912;
      a[175] = 0.409912;
      a[177] = 0.455811;
      a[179] = 0.455811;
      a[180] = 0.227783;
      a[183] = 0.286865;
      a[185] = 0.272949;
      a[186] = 0.272949;
      a[187] = 0.455811;
      a[188] = 0.819824;
      a[191] = 0.500977;
      a[193] = 0.272949;
      a[194] = 0.272949;
      a[195] = 0.272949;
      a[196] = 0.272949;
      a[200] = 0.272949;
      a[203] = 0.272949;
      a[205] = 0.272949;
      a[208] = 0.819824;
      a[225] = 0.819824;
      a[234] = 0.819824;
      a[241] = 0.72876;
      a[245] = 0.227783;
      a[250] = 0.773926;
      a[251] = 0.500977;
    }
    else if ( !strcmp(font, "Helvetica-Narrow-Oblique") ) {
      a[32] = 0.570801;
      a[33] = 0.570801;
      a[34] = 0.570801;
      a[35] = 0.570801;
      a[36] = 0.570801;
      a[37] = 0.570801;
      a[38] = 0.570801;
      a[39] = 0.570801;
      a[40] = 0.570801;
      a[41] = 0.570801;
      a[42] = 0.570801;
      a[43] = 0.570801;
      a[44] = 0.570801;
      a[45] = 0.570801;
      a[46] = 0.570801;
      a[47] = 0.570801;
      a[48] = 0.570801;
      a[49] = 0.570801;
      a[50] = 0.570801;
      a[51] = 0.570801;
      a[52] = 0.570801;
      a[53] = 0.570801;
      a[54] = 0.570801;
      a[55] = 0.570801;
      a[56] = 0.570801;
      a[57] = 0.570801;
      a[58] = 0.570801;
      a[59] = 0.570801;
      a[60] = 0.570801;
      a[61] = 0.570801;
      a[62] = 0.570801;
      a[63] = 0.570801;
      a[64] = 0.570801;
      a[65] = 0.570801;
      a[66] = 0.570801;
      a[67] = 0.570801;
      a[68] = 0.570801;
      a[69] = 0.570801;
      a[70] = 0.570801;
      a[71] = 0.570801;
      a[72] = 0.570801;
      a[73] = 0.570801;
      a[74] = 0.570801;
      a[75] = 0.570801;
      a[76] = 0.570801;
      a[77] = 0.570801;
      a[78] = 0.570801;
      a[79] = 0.570801;
      a[80] = 0.570801;
      a[81] = 0.570801;
      a[82] = 0.570801;
      a[83] = 0.570801;
      a[84] = 0.570801;
      a[85] = 0.570801;
      a[86] = 0.570801;
      a[87] = 0.570801;
      a[88] = 0.570801;
      a[89] = 0.570801;
      a[90] = 0.570801;
      a[91] = 0.570801;
      a[92] = 0.570801;
      a[93] = 0.570801;
      a[94] = 0.570801;
      a[95] = 0.570801;
      a[96] = 0.570801;
      a[97] = 0.570801;
      a[98] = 0.570801;
      a[99] = 0.570801;
      a[100] = 0.570801;
      a[101] = 0.570801;
      a[102] = 0.570801;
      a[103] = 0.570801;
      a[104] = 0.570801;
      a[105] = 0.570801;
      a[106] = 0.570801;
      a[107] = 0.570801;
      a[108] = 0.570801;
      a[109] = 0.570801;
      a[110] = 0.570801;
      a[111] = 0.570801;
      a[112] = 0.570801;
      a[113] = 0.570801;
      a[114] = 0.570801;
      a[115] = 0.570801;
      a[116] = 0.570801;
      a[117] = 0.570801;
      a[118] = 0.570801;
      a[119] = 0.570801;
      a[120] = 0.570801;
      a[121] = 0.570801;
      a[122] = 0.570801;
      a[123] = 0.570801;
      a[124] = 0.570801;
      a[125] = 0.570801;
      a[126] = 0.570801;
      a[161] = 0.570801;
      a[162] = 0.570801;
      a[163] = 0.570801;
      a[164] = 0.570801;
      a[165] = 0.570801;
      a[166] = 0.570801;
      a[169] = 0.570801;
      a[170] = 0.570801;
      a[172] = 0.570801;
      a[173] = 0.570801;
      a[179] = 0.570801;
      a[180] = 0.570801;
      a[183] = 0.570801;
      a[185] = 0.570801;
      a[186] = 0.570801;
      a[191] = 0.570801;
      a[193] = 0.570801;
      a[194] = 0.570801;
      a[195] = 0.570801;
      a[196] = 0.570801;
      a[200] = 0.570801;
      a[203] = 0.570801;
      a[205] = 0.570801;
      a[245] = 0.570801;
    }
    else if ( !strcmp(font, "Helvetica-Narrow-Bold") ) {
      a[32] = 0.227783;
      a[33] = 0.227783;
      a[34] = 0.290771;
      a[35] = 0.455811;
      a[36] = 0.455811;
      a[37] = 0.72876;
      a[38] = 0.546875;
      a[39] = 0.181885;
      a[40] = 0.272949;
      a[41] = 0.272949;
      a[42] = 0.318848;
      a[43] = 0.47876;
      a[44] = 0.227783;
      a[45] = 0.272949;
      a[46] = 0.227783;
      a[47] = 0.227783;
      a[48] = 0.455811;
      a[49] = 0.455811;
      a[50] = 0.455811;
      a[51] = 0.455811;
      a[52] = 0.455811;
      a[53] = 0.455811;
      a[54] = 0.455811;
      a[55] = 0.455811;
      a[56] = 0.455811;
      a[57] = 0.455811;
      a[58] = 0.227783;
      a[59] = 0.227783;
      a[60] = 0.47876;
      a[61] = 0.47876;
      a[62] = 0.47876;
      a[63] = 0.455811;
      a[64] = 0.831787;
      a[65] = 0.546875;
      a[66] = 0.546875;
      a[67] = 0.591797;
      a[68] = 0.591797;
      a[69] = 0.546875;
      a[70] = 0.500977;
      a[71] = 0.637939;
      a[72] = 0.591797;
      a[73] = 0.227783;
      a[74] = 0.409912;
      a[75] = 0.546875;
      a[76] = 0.455811;
      a[77] = 0.682861;
      a[78] = 0.591797;
      a[79] = 0.637939;
      a[80] = 0.546875;
      a[81] = 0.637939;
      a[82] = 0.591797;
      a[83] = 0.546875;
      a[84] = 0.500977;
      a[85] = 0.591797;
      a[86] = 0.546875;
      a[87] = 0.773926;
      a[88] = 0.546875;
      a[89] = 0.546875;
      a[90] = 0.500977;
      a[91] = 0.227783;
      a[92] = 0.227783;
      a[93] = 0.227783;
      a[94] = 0.384766;
      a[95] = 0.455811;
      a[96] = 0.181885;
      a[97] = 0.455811;
      a[98] = 0.455811;
      a[99] = 0.409912;
      a[100] = 0.455811;
      a[101] = 0.455811;
      a[102] = 0.227783;
      a[103] = 0.455811;
      a[104] = 0.455811;
      a[105] = 0.181885;
      a[106] = 0.181885;
      a[107] = 0.409912;
      a[108] = 0.181885;
      a[109] = 0.682861;
      a[110] = 0.455811;
      a[111] = 0.455811;
      a[112] = 0.455811;
      a[113] = 0.455811;
      a[114] = 0.272949;
      a[115] = 0.409912;
      a[116] = 0.227783;
      a[117] = 0.455811;
      a[118] = 0.409912;
      a[119] = 0.591797;
      a[120] = 0.409912;
      a[121] = 0.409912;
      a[122] = 0.409912;
      a[123] = 0.273926;
      a[124] = 0.212891;
      a[125] = 0.273926;
      a[126] = 0.47876;
      a[161] = 0.272949;
      a[162] = 0.455811;
      a[163] = 0.455811;
      a[164] = 0.136963;
      a[165] = 0.455811;
      a[166] = 0.455811;
      a[169] = 0.156982;
      a[170] = 0.272949;
      a[171] = 0.455811;
      a[172] = 0.272949;
      a[173] = 0.272949;
      a[174] = 0.409912;
      a[175] = 0.409912;
      a[177] = 0.455811;
      a[179] = 0.455811;
      a[180] = 0.227783;
      a[183] = 0.286865;
      a[185] = 0.272949;
      a[186] = 0.272949;
      a[187] = 0.455811;
      a[188] = 0.819824;
      a[191] = 0.500977;
      a[193] = 0.272949;
      a[194] = 0.272949;
      a[195] = 0.272949;
      a[196] = 0.272949;
      a[200] = 0.272949;
      a[203] = 0.272949;
      a[205] = 0.272949;
      a[208] = 0.819824;
      a[225] = 0.819824;
      a[234] = 0.819824;
      a[241] = 0.72876;
      a[245] = 0.227783;
      a[250] = 0.773926;
      a[251] = 0.500977;
    }
    else if ( !strcmp(font, "Helvetica-Narrow-BoldOblique") ) {
      a[32] = 0.570801;
      a[33] = 0.570801;
      a[34] = 0.570801;
      a[35] = 0.570801;
      a[36] = 0.570801;
      a[37] = 0.570801;
      a[38] = 0.570801;
      a[39] = 0.570801;
      a[40] = 0.570801;
      a[41] = 0.570801;
      a[42] = 0.570801;
      a[43] = 0.570801;
      a[44] = 0.570801;
      a[45] = 0.570801;
      a[46] = 0.570801;
      a[47] = 0.570801;
      a[48] = 0.570801;
      a[49] = 0.570801;
      a[50] = 0.570801;
      a[51] = 0.570801;
      a[52] = 0.570801;
      a[53] = 0.570801;
      a[54] = 0.570801;
      a[55] = 0.570801;
      a[56] = 0.570801;
      a[57] = 0.570801;
      a[58] = 0.570801;
      a[59] = 0.570801;
      a[60] = 0.570801;
      a[61] = 0.570801;
      a[62] = 0.570801;
      a[63] = 0.570801;
      a[64] = 0.570801;
      a[65] = 0.570801;
      a[66] = 0.570801;
      a[67] = 0.570801;
      a[68] = 0.570801;
      a[69] = 0.570801;
      a[70] = 0.570801;
      a[71] = 0.570801;
      a[72] = 0.570801;
      a[73] = 0.570801;
      a[74] = 0.570801;
      a[75] = 0.570801;
      a[76] = 0.570801;
      a[77] = 0.570801;
      a[78] = 0.570801;
      a[79] = 0.570801;
      a[80] = 0.570801;
      a[81] = 0.570801;
      a[82] = 0.570801;
      a[83] = 0.570801;
      a[84] = 0.570801;
      a[85] = 0.570801;
      a[86] = 0.570801;
      a[87] = 0.570801;
      a[88] = 0.570801;
      a[89] = 0.570801;
      a[90] = 0.570801;
      a[91] = 0.570801;
      a[92] = 0.570801;
      a[93] = 0.570801;
      a[94] = 0.570801;
      a[95] = 0.570801;
      a[96] = 0.570801;
      a[97] = 0.570801;
      a[98] = 0.570801;
      a[99] = 0.570801;
      a[100] = 0.570801;
      a[101] = 0.570801;
      a[102] = 0.570801;
      a[103] = 0.570801;
      a[104] = 0.570801;
      a[105] = 0.570801;
      a[106] = 0.570801;
      a[107] = 0.570801;
      a[108] = 0.570801;
      a[109] = 0.570801;
      a[110] = 0.570801;
      a[111] = 0.570801;
      a[112] = 0.570801;
      a[113] = 0.570801;
      a[114] = 0.570801;
      a[115] = 0.570801;
      a[116] = 0.570801;
      a[117] = 0.570801;
      a[118] = 0.570801;
      a[119] = 0.570801;
      a[120] = 0.570801;
      a[121] = 0.570801;
      a[122] = 0.570801;
      a[123] = 0.570801;
      a[124] = 0.570801;
      a[125] = 0.570801;
      a[126] = 0.570801;
      a[161] = 0.570801;
      a[162] = 0.570801;
      a[163] = 0.570801;
      a[164] = 0.570801;
      a[165] = 0.570801;
      a[166] = 0.570801;
      a[169] = 0.570801;
      a[170] = 0.570801;
      a[172] = 0.570801;
      a[173] = 0.570801;
      a[179] = 0.570801;
      a[180] = 0.570801;
      a[183] = 0.570801;
      a[185] = 0.570801;
      a[186] = 0.570801;
      a[191] = 0.570801;
      a[193] = 0.570801;
      a[194] = 0.570801;
      a[195] = 0.570801;
      a[196] = 0.570801;
      a[200] = 0.570801;
      a[203] = 0.570801;
      a[205] = 0.570801;
      a[245] = 0.570801;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-Roman") ) {
      a[32] = 0.277832;
      a[33] = 0.295898;
      a[34] = 0.388916;
      a[35] = 0.555908;
      a[36] = 0.555908;
      a[37] = 0.832764;
      a[38] = 0.814941;
      a[39] = 0.203857;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.5;
      a[43] = 0.605957;
      a[44] = 0.277832;
      a[45] = 0.332764;
      a[46] = 0.277832;
      a[47] = 0.277832;
      a[48] = 0.555908;
      a[49] = 0.555908;
      a[50] = 0.555908;
      a[51] = 0.555908;
      a[52] = 0.555908;
      a[53] = 0.555908;
      a[54] = 0.555908;
      a[55] = 0.555908;
      a[56] = 0.555908;
      a[57] = 0.555908;
      a[58] = 0.277832;
      a[59] = 0.277832;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.443848;
      a[64] = 0.736816;
      a[65] = 0.721924;
      a[66] = 0.721924;
      a[67] = 0.721924;
      a[68] = 0.777832;
      a[69] = 0.721924;
      a[70] = 0.666992;
      a[71] = 0.777832;
      a[72] = 0.832764;
      a[73] = 0.406982;
      a[74] = 0.555908;
      a[75] = 0.777832;
      a[76] = 0.666992;
      a[77] = 0.943848;
      a[78] = 0.814941;
      a[79] = 0.777832;
      a[80] = 0.666992;
      a[81] = 0.777832;
      a[82] = 0.721924;
      a[83] = 0.629883;
      a[84] = 0.666992;
      a[85] = 0.814941;
      a[86] = 0.721924;
      a[87] = 0.980957;
      a[88] = 0.703857;
      a[89] = 0.703857;
      a[90] = 0.61084;
      a[91] = 0.332764;
      a[92] = 0.605957;
      a[93] = 0.332764;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.203857;
      a[97] = 0.555908;
      a[98] = 0.555908;
      a[99] = 0.443848;
      a[100] = 0.573975;
      a[101] = 0.5;
      a[102] = 0.332764;
      a[103] = 0.536865;
      a[104] = 0.61084;
      a[105] = 0.314941;
      a[106] = 0.295898;
      a[107] = 0.592773;
      a[108] = 0.314941;
      a[109] = 0.888916;
      a[110] = 0.61084;
      a[111] = 0.5;
      a[112] = 0.573975;
      a[113] = 0.555908;
      a[114] = 0.443848;
      a[115] = 0.462891;
      a[116] = 0.388916;
      a[117] = 0.61084;
      a[118] = 0.536865;
      a[119] = 0.777832;
      a[120] = 0.536865;
      a[121] = 0.536865;
      a[122] = 0.480957;
      a[123] = 0.332764;
      a[124] = 0.605957;
      a[125] = 0.332764;
      a[126] = 0.605957;
      a[161] = 0.295898;
      a[162] = 0.555908;
      a[163] = 0.555908;
      a[164] = 0.166992;
      a[165] = 0.703857;
      a[166] = 0.555908;
      a[167] = 0.5;
      a[168] = 0.605957;
      a[169] = 0.203857;
      a[170] = 0.388916;
      a[171] = 0.425781;
      a[172] = 0.258789;
      a[173] = 0.258789;
      a[174] = 0.61084;
      a[175] = 0.61084;
      a[177] = 0.555908;
      a[178] = 0.5;
      a[179] = 0.5;
      a[180] = 0.277832;
      a[182] = 0.605957;
      a[183] = 0.605957;
      a[184] = 0.203857;
      a[185] = 0.388916;
      a[186] = 0.388916;
      a[187] = 0.425781;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.443848;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 1.0;
      a[227] = 0.333984;
      a[232] = 0.666992;
      a[233] = 0.777832;
      a[234] = 1.0;
      a[235] = 0.299805;
      a[241] = 0.795898;
      a[245] = 0.314941;
      a[248] = 0.314941;
      a[249] = 0.5;
      a[250] = 0.832764;
      a[251] = 0.573975;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-Italic") ) {
      a[32] = 0.277832;
      a[33] = 0.332764;
      a[34] = 0.399902;
      a[35] = 0.605957;
      a[36] = 0.555908;
      a[37] = 0.832764;
      a[38] = 0.851807;
      a[39] = 0.203857;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.5;
      a[43] = 0.605957;
      a[44] = 0.277832;
      a[45] = 0.332764;
      a[46] = 0.277832;
      a[47] = 0.605957;
      a[48] = 0.555908;
      a[49] = 0.555908;
      a[50] = 0.555908;
      a[51] = 0.555908;
      a[52] = 0.555908;
      a[53] = 0.555908;
      a[54] = 0.555908;
      a[55] = 0.555908;
      a[56] = 0.555908;
      a[57] = 0.555908;
      a[58] = 0.277832;
      a[59] = 0.277832;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.443848;
      a[64] = 0.746826;
      a[65] = 0.703857;
      a[66] = 0.721924;
      a[67] = 0.721924;
      a[68] = 0.777832;
      a[69] = 0.721924;
      a[70] = 0.666992;
      a[71] = 0.777832;
      a[72] = 0.832764;
      a[73] = 0.406982;
      a[74] = 0.61084;
      a[75] = 0.740967;
      a[76] = 0.666992;
      a[77] = 0.943848;
      a[78] = 0.814941;
      a[79] = 0.777832;
      a[80] = 0.666992;
      a[81] = 0.777832;
      a[82] = 0.740967;
      a[83] = 0.666992;
      a[84] = 0.684814;
      a[85] = 0.814941;
      a[86] = 0.703857;
      a[87] = 0.925781;
      a[88] = 0.703857;
      a[89] = 0.684814;
      a[90] = 0.666992;
      a[91] = 0.332764;
      a[92] = 0.605957;
      a[93] = 0.332764;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.203857;
      a[97] = 0.573975;
      a[98] = 0.555908;
      a[99] = 0.443848;
      a[100] = 0.61084;
      a[101] = 0.443848;
      a[102] = 0.332764;
      a[103] = 0.536865;
      a[104] = 0.61084;
      a[105] = 0.332764;
      a[106] = 0.314941;
      a[107] = 0.555908;
      a[108] = 0.332764;
      a[109] = 0.888916;
      a[110] = 0.61084;
      a[111] = 0.5;
      a[112] = 0.573975;
      a[113] = 0.555908;
      a[114] = 0.443848;
      a[115] = 0.443848;
      a[116] = 0.351807;
      a[117] = 0.61084;
      a[118] = 0.518799;
      a[119] = 0.777832;
      a[120] = 0.5;
      a[121] = 0.5;
      a[122] = 0.462891;
      a[123] = 0.332764;
      a[124] = 0.605957;
      a[125] = 0.332764;
      a[126] = 0.605957;
      a[161] = 0.332764;
      a[162] = 0.555908;
      a[163] = 0.555908;
      a[164] = 0.166992;
      a[165] = 0.555908;
      a[166] = 0.555908;
      a[167] = 0.5;
      a[168] = 0.605957;
      a[169] = 0.277832;
      a[170] = 0.388916;
      a[171] = 0.425781;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.61084;
      a[175] = 0.61084;
      a[177] = 0.5;
      a[178] = 0.5;
      a[179] = 0.5;
      a[180] = 0.277832;
      a[182] = 0.649902;
      a[183] = 0.605957;
      a[184] = 0.203857;
      a[185] = 0.388916;
      a[186] = 0.388916;
      a[187] = 0.425781;
      a[188] = 1.0;
      a[189] = 1.0;
      a[191] = 0.443848;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[198] = 0.332764;
      a[199] = 0.332764;
      a[200] = 0.332764;
      a[202] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[206] = 0.332764;
      a[207] = 0.332764;
      a[208] = 1.0;
      a[225] = 0.869873;
      a[227] = 0.421875;
      a[232] = 0.666992;
      a[233] = 0.777832;
      a[234] = 0.980957;
      a[235] = 0.371826;
      a[241] = 0.721924;
      a[245] = 0.332764;
      a[248] = 0.332764;
      a[249] = 0.5;
      a[250] = 0.777832;
      a[251] = 0.555908;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-Bold") ) {
      a[32] = 0.286865;
      a[33] = 0.295898;
      a[34] = 0.332764;
      a[35] = 0.573975;
      a[36] = 0.573975;
      a[37] = 0.832764;
      a[38] = 0.851807;
      a[39] = 0.240967;
      a[40] = 0.388916;
      a[41] = 0.388916;
      a[42] = 0.5;
      a[43] = 0.605957;
      a[44] = 0.277832;
      a[45] = 0.332764;
      a[46] = 0.277832;
      a[47] = 0.277832;
      a[48] = 0.573975;
      a[49] = 0.573975;
      a[50] = 0.573975;
      a[51] = 0.573975;
      a[52] = 0.573975;
      a[53] = 0.573975;
      a[54] = 0.573975;
      a[55] = 0.573975;
      a[56] = 0.573975;
      a[57] = 0.573975;
      a[58] = 0.277832;
      a[59] = 0.277832;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.5;
      a[64] = 0.746826;
      a[65] = 0.758789;
      a[66] = 0.777832;
      a[67] = 0.777832;
      a[68] = 0.832764;
      a[69] = 0.758789;
      a[70] = 0.721924;
      a[71] = 0.832764;
      a[72] = 0.869873;
      a[73] = 0.443848;
      a[74] = 0.647949;
      a[75] = 0.814941;
      a[76] = 0.721924;
      a[77] = 0.980957;
      a[78] = 0.832764;
      a[79] = 0.832764;
      a[80] = 0.758789;
      a[81] = 0.832764;
      a[82] = 0.814941;
      a[83] = 0.666992;
      a[84] = 0.721924;
      a[85] = 0.832764;
      a[86] = 0.758789;
      a[87] = 0.980957;
      a[88] = 0.721924;
      a[89] = 0.721924;
      a[90] = 0.666992;
      a[91] = 0.388916;
      a[92] = 0.605957;
      a[93] = 0.388916;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.240967;
      a[97] = 0.61084;
      a[98] = 0.647949;
      a[99] = 0.555908;
      a[100] = 0.666992;
      a[101] = 0.573975;
      a[102] = 0.388916;
      a[103] = 0.61084;
      a[104] = 0.684814;
      a[105] = 0.369873;
      a[106] = 0.351807;
      a[107] = 0.666992;
      a[108] = 0.351807;
      a[109] = 0.962891;
      a[110] = 0.684814;
      a[111] = 0.61084;
      a[112] = 0.666992;
      a[113] = 0.647949;
      a[114] = 0.518799;
      a[115] = 0.5;
      a[116] = 0.425781;
      a[117] = 0.684814;
      a[118] = 0.61084;
      a[119] = 0.888916;
      a[120] = 0.61084;
      a[121] = 0.61084;
      a[122] = 0.536865;
      a[123] = 0.388916;
      a[124] = 0.605957;
      a[125] = 0.388916;
      a[126] = 0.605957;
      a[161] = 0.295898;
      a[162] = 0.573975;
      a[163] = 0.573975;
      a[164] = 0.166992;
      a[165] = 0.721924;
      a[166] = 0.573975;
      a[167] = 0.5;
      a[168] = 0.605957;
      a[169] = 0.240967;
      a[170] = 0.480957;
      a[171] = 0.5;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.684814;
      a[175] = 0.684814;
      a[177] = 0.5;
      a[179] = 0.5;
      a[180] = 0.277832;
      a[182] = 0.746826;
      a[183] = 0.605957;
      a[185] = 0.480957;
      a[186] = 0.480957;
      a[187] = 0.5;
      a[188] = 1.0;
      a[191] = 0.5;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[200] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[208] = 1.0;
      a[225] = 0.980957;
      a[227] = 0.366943;
      a[233] = 0.832764;
      a[234] = 1.0;
      a[235] = 0.366943;
      a[241] = 0.869873;
      a[245] = 0.369873;
      a[249] = 0.61084;
      a[250] = 0.906982;
      a[251] = 0.61084;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-BoldItalic") ) {
      a[32] = 0.286865;
      a[33] = 0.332764;
      a[34] = 0.399902;
      a[35] = 0.605957;
      a[36] = 0.573975;
      a[37] = 0.888916;
      a[38] = 0.888916;
      a[39] = 0.258789;
      a[40] = 0.406982;
      a[41] = 0.406982;
      a[42] = 0.5;
      a[43] = 0.605957;
      a[44] = 0.286865;
      a[45] = 0.332764;
      a[46] = 0.286865;
      a[47] = 0.277832;
      a[48] = 0.573975;
      a[49] = 0.573975;
      a[50] = 0.573975;
      a[51] = 0.573975;
      a[52] = 0.573975;
      a[53] = 0.573975;
      a[54] = 0.573975;
      a[55] = 0.573975;
      a[56] = 0.573975;
      a[57] = 0.573975;
      a[58] = 0.286865;
      a[59] = 0.286865;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.480957;
      a[64] = 0.746826;
      a[65] = 0.740967;
      a[66] = 0.758789;
      a[67] = 0.758789;
      a[68] = 0.832764;
      a[69] = 0.740967;
      a[70] = 0.703857;
      a[71] = 0.814941;
      a[72] = 0.869873;
      a[73] = 0.443848;
      a[74] = 0.666992;
      a[75] = 0.777832;
      a[76] = 0.703857;
      a[77] = 0.943848;
      a[78] = 0.851807;
      a[79] = 0.832764;
      a[80] = 0.740967;
      a[81] = 0.832764;
      a[82] = 0.795898;
      a[83] = 0.684814;
      a[84] = 0.721924;
      a[85] = 0.832764;
      a[86] = 0.740967;
      a[87] = 0.943848;
      a[88] = 0.740967;
      a[89] = 0.703857;
      a[90] = 0.703857;
      a[91] = 0.406982;
      a[92] = 0.605957;
      a[93] = 0.406982;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.258789;
      a[97] = 0.666992;
      a[98] = 0.61084;
      a[99] = 0.536865;
      a[100] = 0.666992;
      a[101] = 0.518799;
      a[102] = 0.388916;
      a[103] = 0.61084;
      a[104] = 0.684814;
      a[105] = 0.388916;
      a[106] = 0.369873;
      a[107] = 0.647949;
      a[108] = 0.388916;
      a[109] = 0.943848;
      a[110] = 0.684814;
      a[111] = 0.573975;
      a[112] = 0.647949;
      a[113] = 0.629883;
      a[114] = 0.518799;
      a[115] = 0.480957;
      a[116] = 0.406982;
      a[117] = 0.684814;
      a[118] = 0.555908;
      a[119] = 0.832764;
      a[120] = 0.573975;
      a[121] = 0.518799;
      a[122] = 0.518799;
      a[123] = 0.406982;
      a[124] = 0.605957;
      a[125] = 0.406982;
      a[126] = 0.605957;
      a[161] = 0.332764;
      a[162] = 0.573975;
      a[163] = 0.573975;
      a[164] = 0.166992;
      a[165] = 0.573975;
      a[166] = 0.573975;
      a[167] = 0.5;
      a[168] = 0.573975;
      a[169] = 0.286865;
      a[170] = 0.480957;
      a[171] = 0.480957;
      a[172] = 0.277832;
      a[173] = 0.277832;
      a[174] = 0.684814;
      a[175] = 0.684814;
      a[177] = 0.5;
      a[179] = 0.5;
      a[180] = 0.286865;
      a[182] = 0.649902;
      a[183] = 0.605957;
      a[185] = 0.480957;
      a[186] = 0.480957;
      a[187] = 0.480957;
      a[188] = 1.0;
      a[191] = 0.480957;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[197] = 0.332764;
      a[200] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[208] = 1.0;
      a[225] = 0.888916;
      a[227] = 0.411865;
      a[233] = 0.832764;
      a[234] = 0.962891;
      a[235] = 0.355957;
      a[241] = 0.814941;
      a[245] = 0.388916;
      a[249] = 0.573975;
      a[250] = 0.851807;
      a[251] = 0.573975;
    }
    else if ( !strcmp(font, "Palatino-Roman") ) {
      a[32] = 0.25;
      a[33] = 0.277832;
      a[34] = 0.37085;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 0.839844;
      a[38] = 0.777832;
      a[39] = 0.277832;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.388916;
      a[43] = 0.605957;
      a[44] = 0.25;
      a[45] = 0.332764;
      a[46] = 0.25;
      a[47] = 0.605957;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.25;
      a[59] = 0.25;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.443848;
      a[64] = 0.746826;
      a[65] = 0.777832;
      a[66] = 0.61084;
      a[67] = 0.708984;
      a[68] = 0.773926;
      a[69] = 0.61084;
      a[70] = 0.555908;
      a[71] = 0.762939;
      a[72] = 0.831787;
      a[73] = 0.336914;
      a[74] = 0.332764;
      a[75] = 0.72583;
      a[76] = 0.61084;
      a[77] = 0.945801;
      a[78] = 0.830811;
      a[79] = 0.785889;
      a[80] = 0.60376;
      a[81] = 0.785889;
      a[82] = 0.667969;
      a[83] = 0.524902;
      a[84] = 0.612793;
      a[85] = 0.777832;
      a[86] = 0.721924;
      a[87] = 1.0;
      a[88] = 0.666992;
      a[89] = 0.666992;
      a[90] = 0.666992;
      a[91] = 0.332764;
      a[92] = 0.605957;
      a[93] = 0.332764;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.277832;
      a[97] = 0.5;
      a[98] = 0.552979;
      a[99] = 0.443848;
      a[100] = 0.61084;
      a[101] = 0.47876;
      a[102] = 0.332764;
      a[103] = 0.555908;
      a[104] = 0.581787;
      a[105] = 0.290771;
      a[106] = 0.233887;
      a[107] = 0.555908;
      a[108] = 0.290771;
      a[109] = 0.882812;
      a[110] = 0.581787;
      a[111] = 0.545898;
      a[112] = 0.60083;
      a[113] = 0.559814;
      a[114] = 0.394775;
      a[115] = 0.423828;
      a[116] = 0.325928;
      a[117] = 0.602783;
      a[118] = 0.564941;
      a[119] = 0.833984;
      a[120] = 0.515869;
      a[121] = 0.555908;
      a[122] = 0.5;
      a[123] = 0.332764;
      a[124] = 0.605957;
      a[125] = 0.332764;
      a[126] = 0.605957;
      a[161] = 0.277832;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[169] = 0.207764;
      a[170] = 0.5;
      a[171] = 0.5;
      a[172] = 0.330811;
      a[173] = 0.330811;
      a[174] = 0.60498;
      a[175] = 0.60791;
      a[177] = 0.5;
      a[179] = 0.5;
      a[180] = 0.25;
      a[183] = 0.605957;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.5;
      a[188] = 1.0;
      a[191] = 0.443848;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[200] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.379883;
      a[208] = 1.0;
      a[225] = 0.943848;
      a[234] = 0.997803;
      a[241] = 0.757812;
      a[245] = 0.286865;
      a[250] = 0.826904;
      a[251] = 0.555908;
    }
    else if ( !strcmp(font, "Palatino-Italic") ) {
      a[32] = 0.25;
      a[33] = 0.332764;
      a[34] = 0.5;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 0.888916;
      a[38] = 0.777832;
      a[39] = 0.277832;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.388916;
      a[43] = 0.605957;
      a[44] = 0.25;
      a[45] = 0.332764;
      a[46] = 0.25;
      a[47] = 0.295898;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.25;
      a[59] = 0.25;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.5;
      a[64] = 0.746826;
      a[65] = 0.721924;
      a[66] = 0.61084;
      a[67] = 0.666992;
      a[68] = 0.777832;
      a[69] = 0.61084;
      a[70] = 0.555908;
      a[71] = 0.721924;
      a[72] = 0.777832;
      a[73] = 0.332764;
      a[74] = 0.332764;
      a[75] = 0.666992;
      a[76] = 0.555908;
      a[77] = 0.943848;
      a[78] = 0.777832;
      a[79] = 0.777832;
      a[80] = 0.61084;
      a[81] = 0.777832;
      a[82] = 0.666992;
      a[83] = 0.555908;
      a[84] = 0.61084;
      a[85] = 0.777832;
      a[86] = 0.721924;
      a[87] = 0.943848;
      a[88] = 0.721924;
      a[89] = 0.666992;
      a[90] = 0.666992;
      a[91] = 0.332764;
      a[92] = 0.605957;
      a[93] = 0.332764;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.277832;
      a[97] = 0.443848;
      a[98] = 0.462891;
      a[99] = 0.406982;
      a[100] = 0.5;
      a[101] = 0.388916;
      a[102] = 0.277832;
      a[103] = 0.5;
      a[104] = 0.5;
      a[105] = 0.277832;
      a[106] = 0.277832;
      a[107] = 0.443848;
      a[108] = 0.277832;
      a[109] = 0.777832;
      a[110] = 0.555908;
      a[111] = 0.443848;
      a[112] = 0.5;
      a[113] = 0.462891;
      a[114] = 0.388916;
      a[115] = 0.388916;
      a[116] = 0.332764;
      a[117] = 0.555908;
      a[118] = 0.5;
      a[119] = 0.721924;
      a[120] = 0.5;
      a[121] = 0.5;
      a[122] = 0.443848;
      a[123] = 0.332764;
      a[124] = 0.605957;
      a[125] = 0.332764;
      a[126] = 0.605957;
      a[161] = 0.332764;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[169] = 0.332764;
      a[170] = 0.5;
      a[171] = 0.5;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.527832;
      a[175] = 0.544922;
      a[177] = 0.5;
      a[179] = 0.5;
      a[180] = 0.25;
      a[183] = 0.5;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.5;
      a[188] = 1.0;
      a[191] = 0.5;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[200] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[208] = 1.0;
      a[225] = 0.940918;
      a[234] = 1.02783;
      a[241] = 0.637939;
      a[245] = 0.277832;
      a[250] = 0.668945;
      a[251] = 0.5;
    }
    else if ( !strcmp(font, "Palatino-Bold") ) {
      a[32] = 0.25;
      a[33] = 0.277832;
      a[34] = 0.401855;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 0.888916;
      a[38] = 0.832764;
      a[39] = 0.277832;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.443848;
      a[43] = 0.605957;
      a[44] = 0.25;
      a[45] = 0.332764;
      a[46] = 0.25;
      a[47] = 0.295898;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.25;
      a[59] = 0.25;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.443848;
      a[64] = 0.746826;
      a[65] = 0.777832;
      a[66] = 0.666992;
      a[67] = 0.721924;
      a[68] = 0.832764;
      a[69] = 0.61084;
      a[70] = 0.555908;
      a[71] = 0.832764;
      a[72] = 0.832764;
      a[73] = 0.388916;
      a[74] = 0.388916;
      a[75] = 0.777832;
      a[76] = 0.61084;
      a[77] = 1.0;
      a[78] = 0.832764;
      a[79] = 0.832764;
      a[80] = 0.61084;
      a[81] = 0.832764;
      a[82] = 0.721924;
      a[83] = 0.61084;
      a[84] = 0.666992;
      a[85] = 0.777832;
      a[86] = 0.777832;
      a[87] = 1.0;
      a[88] = 0.666992;
      a[89] = 0.666992;
      a[90] = 0.666992;
      a[91] = 0.332764;
      a[92] = 0.605957;
      a[93] = 0.332764;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.277832;
      a[97] = 0.5;
      a[98] = 0.61084;
      a[99] = 0.443848;
      a[100] = 0.61084;
      a[101] = 0.5;
      a[102] = 0.388916;
      a[103] = 0.555908;
      a[104] = 0.61084;
      a[105] = 0.332764;
      a[106] = 0.332764;
      a[107] = 0.61084;
      a[108] = 0.332764;
      a[109] = 0.888916;
      a[110] = 0.61084;
      a[111] = 0.555908;
      a[112] = 0.61084;
      a[113] = 0.61084;
      a[114] = 0.388916;
      a[115] = 0.443848;
      a[116] = 0.332764;
      a[117] = 0.61084;
      a[118] = 0.555908;
      a[119] = 0.832764;
      a[120] = 0.5;
      a[121] = 0.555908;
      a[122] = 0.5;
      a[123] = 0.309814;
      a[124] = 0.605957;
      a[125] = 0.309814;
      a[126] = 0.605957;
      a[161] = 0.277832;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[169] = 0.226807;
      a[170] = 0.5;
      a[171] = 0.5;
      a[172] = 0.388916;
      a[173] = 0.388916;
      a[174] = 0.61084;
      a[175] = 0.61084;
      a[177] = 0.5;
      a[179] = 0.5;
      a[180] = 0.25;
      a[183] = 0.605957;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.5;
      a[188] = 1.0;
      a[191] = 0.443848;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[200] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[208] = 1.0;
      a[225] = 1.0;
      a[234] = 1.0;
      a[241] = 0.777832;
      a[245] = 0.332764;
      a[250] = 0.832764;
      a[251] = 0.61084;
    }
    else if ( !strcmp(font, "Palatino-BoldItalic") ) {
      a[32] = 0.25;
      a[33] = 0.332764;
      a[34] = 0.5;
      a[35] = 0.5;
      a[36] = 0.5;
      a[37] = 0.888916;
      a[38] = 0.832764;
      a[39] = 0.277832;
      a[40] = 0.332764;
      a[41] = 0.332764;
      a[42] = 0.443848;
      a[43] = 0.605957;
      a[44] = 0.25;
      a[45] = 0.388916;
      a[46] = 0.25;
      a[47] = 0.314941;
      a[48] = 0.5;
      a[49] = 0.5;
      a[50] = 0.5;
      a[51] = 0.5;
      a[52] = 0.5;
      a[53] = 0.5;
      a[54] = 0.5;
      a[55] = 0.5;
      a[56] = 0.5;
      a[57] = 0.5;
      a[58] = 0.25;
      a[59] = 0.25;
      a[60] = 0.605957;
      a[61] = 0.605957;
      a[62] = 0.605957;
      a[63] = 0.443848;
      a[64] = 0.832764;
      a[65] = 0.721924;
      a[66] = 0.666992;
      a[67] = 0.684814;
      a[68] = 0.777832;
      a[69] = 0.61084;
      a[70] = 0.555908;
      a[71] = 0.777832;
      a[72] = 0.777832;
      a[73] = 0.388916;
      a[74] = 0.388916;
      a[75] = 0.721924;
      a[76] = 0.61084;
      a[77] = 0.943848;
      a[78] = 0.777832;
      a[79] = 0.832764;
      a[80] = 0.666992;
      a[81] = 0.832764;
      a[82] = 0.721924;
      a[83] = 0.555908;
      a[84] = 0.61084;
      a[85] = 0.777832;
      a[86] = 0.666992;
      a[87] = 1.0;
      a[88] = 0.721924;
      a[89] = 0.61084;
      a[90] = 0.666992;
      a[91] = 0.332764;
      a[92] = 0.605957;
      a[93] = 0.332764;
      a[94] = 0.605957;
      a[95] = 0.5;
      a[96] = 0.277832;
      a[97] = 0.555908;
      a[98] = 0.536865;
      a[99] = 0.443848;
      a[100] = 0.555908;
      a[101] = 0.443848;
      a[102] = 0.332764;
      a[103] = 0.5;
      a[104] = 0.555908;
      a[105] = 0.332764;
      a[106] = 0.332764;
      a[107] = 0.555908;
      a[108] = 0.332764;
      a[109] = 0.832764;
      a[110] = 0.555908;
      a[111] = 0.555908;
      a[112] = 0.555908;
      a[113] = 0.536865;
      a[114] = 0.388916;
      a[115] = 0.443848;
      a[116] = 0.388916;
      a[117] = 0.555908;
      a[118] = 0.555908;
      a[119] = 0.832764;
      a[120] = 0.5;
      a[121] = 0.555908;
      a[122] = 0.5;
      a[123] = 0.332764;
      a[124] = 0.605957;
      a[125] = 0.332764;
      a[126] = 0.605957;
      a[161] = 0.332764;
      a[162] = 0.5;
      a[163] = 0.5;
      a[164] = 0.166992;
      a[165] = 0.5;
      a[166] = 0.5;
      a[169] = 0.25;
      a[170] = 0.5;
      a[171] = 0.5;
      a[172] = 0.332764;
      a[173] = 0.332764;
      a[174] = 0.61084;
      a[175] = 0.61084;
      a[177] = 0.5;
      a[179] = 0.555908;
      a[180] = 0.25;
      a[183] = 0.605957;
      a[185] = 0.5;
      a[186] = 0.5;
      a[187] = 0.5;
      a[188] = 1.0;
      a[191] = 0.443848;
      a[193] = 0.332764;
      a[194] = 0.332764;
      a[195] = 0.332764;
      a[196] = 0.332764;
      a[200] = 0.332764;
      a[203] = 0.332764;
      a[205] = 0.332764;
      a[208] = 1.0;
      a[225] = 0.943848;
      a[234] = 0.943848;
      a[241] = 0.737793;
      a[245] = 0.332764;
      a[250] = 0.777832;
      a[251] = 0.555908;
    }
    else if ( !strcmp(font, "ZapfChancery-MediumItalic") ) {
      a[32] = 0.219971;
      a[33] = 0.279785;
      a[34] = 0.219971;
      a[35] = 0.439941;
      a[36] = 0.439941;
      a[37] = 0.679932;
      a[38] = 0.779785;
      a[39] = 0.23999;
      a[40] = 0.259766;
      a[41] = 0.219971;
      a[42] = 0.419922;
      a[43] = 0.519775;
      a[44] = 0.219971;
      a[45] = 0.279785;
      a[46] = 0.219971;
      a[47] = 0.339844;
      a[48] = 0.439941;
      a[49] = 0.439941;
      a[50] = 0.439941;
      a[51] = 0.439941;
      a[52] = 0.439941;
      a[53] = 0.439941;
      a[54] = 0.439941;
      a[55] = 0.439941;
      a[56] = 0.439941;
      a[57] = 0.439941;
      a[58] = 0.259766;
      a[59] = 0.23999;
      a[60] = 0.519775;
      a[61] = 0.519775;
      a[62] = 0.519775;
      a[63] = 0.379883;
      a[64] = 0.699951;
      a[65] = 0.619873;
      a[66] = 0.599854;
      a[67] = 0.519775;
      a[68] = 0.699951;
      a[69] = 0.619873;
      a[70] = 0.579834;
      a[71] = 0.619873;
      a[72] = 0.679932;
      a[73] = 0.379883;
      a[74] = 0.399902;
      a[75] = 0.659912;
      a[76] = 0.579834;
      a[77] = 0.839844;
      a[78] = 0.699951;
      a[79] = 0.599854;
      a[80] = 0.539795;
      a[81] = 0.599854;
      a[82] = 0.599854;
      a[83] = 0.459961;
      a[84] = 0.5;
      a[85] = 0.73999;
      a[86] = 0.639893;
      a[87] = 0.879883;
      a[88] = 0.559814;
      a[89] = 0.559814;
      a[90] = 0.619873;
      a[91] = 0.23999;
      a[92] = 0.47998;
      a[93] = 0.319824;
      a[94] = 0.519775;
      a[95] = 0.5;
      a[96] = 0.23999;
      a[97] = 0.419922;
      a[98] = 0.419922;
      a[99] = 0.339844;
      a[100] = 0.439941;
      a[101] = 0.339844;
      a[102] = 0.319824;
      a[103] = 0.399902;
      a[104] = 0.439941;
      a[105] = 0.23999;
      a[106] = 0.219971;
      a[107] = 0.439941;
      a[108] = 0.23999;
      a[109] = 0.619873;
      a[110] = 0.459961;
      a[111] = 0.399902;
      a[112] = 0.439941;
      a[113] = 0.399902;
      a[114] = 0.299805;
      a[115] = 0.319824;
      a[116] = 0.319824;
      a[117] = 0.459961;
      a[118] = 0.439941;
      a[119] = 0.679932;
      a[120] = 0.419922;
      a[121] = 0.399902;
      a[122] = 0.439941;
      a[123] = 0.23999;
      a[124] = 0.519775;
      a[125] = 0.23999;
      a[126] = 0.519775;
      a[161] = 0.279785;
      a[162] = 0.439941;
      a[163] = 0.439941;
      a[164] = 0.0598145;
      a[165] = 0.439941;
      a[166] = 0.439941;
      a[169] = 0.159912;
      a[170] = 0.339844;
      a[171] = 0.339844;
      a[172] = 0.23999;
      a[173] = 0.259766;
      a[174] = 0.519775;
      a[175] = 0.519775;
      a[177] = 0.5;
      a[179] = 0.47998;
      a[180] = 0.219971;
      a[183] = 0.599854;
      a[185] = 0.279785;
      a[186] = 0.359863;
      a[187] = 0.379883;
      a[188] = 1.0;
      a[191] = 0.399902;
      a[193] = 0.219971;
      a[194] = 0.299805;
      a[195] = 0.339844;
      a[196] = 0.439941;
      a[200] = 0.359863;
      a[203] = 0.299805;
      a[205] = 0.399902;
      a[208] = 1.0;
      a[225] = 0.73999;
      a[234] = 0.819824;
      a[241] = 0.539795;
      a[245] = 0.23999;
      a[250] = 0.559814;
      a[251] = 0.419922;
    }
    else if ( !strcmp(font, "ZapfDingbats") ) {
      a[32] = 0.278;
      a[33] = 0.973877;
      a[34] = 0.960938;
      a[35] = 0.973877;
      a[36] = 0.97998;
      a[37] = 0.718994;
      a[38] = 0.788818;
      a[39] = 0.789795;
      a[40] = 0.790771;
      a[41] = 0.689941;
      a[42] = 0.959961;
      a[43] = 0.938965;
      a[44] = 0.548828;
      a[45] = 0.85498;
      a[46] = 0.910889;
      a[47] = 0.932861;
      a[48] = 0.910889;
      a[49] = 0.944824;
      a[50] = 0.973877;
      a[51] = 0.754883;
      a[52] = 0.845947;
      a[53] = 0.761963;
      a[54] = 0.760986;
      a[55] = 0.570801;
      a[56] = 0.676758;
      a[57] = 0.762939;
      a[58] = 0.759766;
      a[59] = 0.758789;
      a[60] = 0.753906;
      a[61] = 0.493896;
      a[62] = 0.551758;
      a[63] = 0.536865;
      a[64] = 0.576904;
      a[65] = 0.691895;
      a[66] = 0.785889;
      a[67] = 0.787842;
      a[68] = 0.787842;
      a[69] = 0.789795;
      a[70] = 0.792969;
      a[71] = 0.793945;
      a[72] = 0.815918;
      a[73] = 0.822998;
      a[74] = 0.788818;
      a[75] = 0.84082;
      a[76] = 0.822998;
      a[77] = 0.832764;
      a[78] = 0.815918;
      a[79] = 0.830811;
      a[80] = 0.922852;
      a[81] = 0.743896;
      a[82] = 0.7229;
      a[83] = 0.748779;
      a[84] = 0.789795;
      a[85] = 0.791992;
      a[86] = 0.694824;
      a[87] = 0.775879;
      a[88] = 0.767822;
      a[89] = 0.791992;
      a[90] = 0.758789;
      a[91] = 0.706787;
      a[92] = 0.707764;
      a[93] = 0.681885;
      a[94] = 0.700928;
      a[95] = 0.825928;
      a[96] = 0.814941;
      a[97] = 0.788818;
      a[98] = 0.788818;
      a[99] = 0.706787;
      a[100] = 0.686768;
      a[101] = 0.695801;
      a[102] = 0.688989;
      a[103] = 0.785889;
      a[104] = 0.786865;
      a[105] = 0.712891;
      a[106] = 0.790771;
      a[107] = 0.784912;
      a[108] = 0.790771;
      a[109] = 0.872803;
      a[110] = 0.760986;
      a[111] = 0.761963;
      a[112] = 0.761963;
      a[113] = 0.758789;
      a[114] = 0.758789;
      a[115] = 0.891846;
      a[116] = 0.891846;
      a[117] = 0.787842;
      a[118] = 0.783936;
      a[119] = 0.437988;
      a[120] = 0.137939;
      a[121] = 0.276855;
      a[122] = 0.414795;
      a[123] = 0.391846;
      a[124] = 0.391846;
      a[125] = 0.667969;
      a[126] = 0.667969;
      a[161] = 0.731934;
      a[162] = 0.543945;
      a[163] = 0.543945;
      a[164] = 0.909912;
      a[165] = 0.666992;
      a[166] = 0.759766;
      a[167] = 0.759766;
      a[168] = 0.775879;
      a[169] = 0.594971;
      a[170] = 0.693848;
      a[171] = 0.625977;
      a[172] = 0.787842;
      a[173] = 0.787842;
      a[174] = 0.787842;
      a[175] = 0.787842;
      a[176] = 0.787842;
      a[177] = 0.787842;
      a[178] = 0.787842;
      a[179] = 0.787842;
      a[180] = 0.787842;
      a[181] = 0.787842;
      a[182] = 0.787842;
      a[183] = 0.787842;
      a[184] = 0.787842;
      a[185] = 0.787842;
      a[186] = 0.787842;
      a[187] = 0.787842;
      a[188] = 0.787842;
      a[189] = 0.787842;
      a[190] = 0.787842;
      a[191] = 0.787842;
      a[192] = 0.787842;
      a[193] = 0.787842;
      a[194] = 0.787842;
      a[195] = 0.787842;
      a[196] = 0.787842;
      a[197] = 0.787842;
      a[198] = 0.787842;
      a[199] = 0.787842;
      a[200] = 0.787842;
      a[201] = 0.787842;
      a[202] = 0.787842;
      a[203] = 0.787842;
      a[204] = 0.787842;
      a[205] = 0.787842;
      a[206] = 0.787842;
      a[207] = 0.787842;
      a[208] = 0.787842;
      a[209] = 0.787842;
      a[210] = 0.787842;
      a[211] = 0.787842;
      a[212] = 0.893799;
      a[213] = 0.837891;
      a[214] = 1.01587;
      a[215] = 0.457764;
      a[216] = 0.747803;
      a[217] = 0.923828;
      a[218] = 0.747803;
      a[219] = 0.917969;
      a[220] = 0.926758;
      a[221] = 0.927979;
      a[222] = 0.927979;
      a[223] = 0.833984;
      a[224] = 0.872803;
      a[225] = 0.827881;
      a[226] = 0.923828;
      a[227] = 0.923828;
      a[228] = 0.916992;
      a[229] = 0.929932;
      a[230] = 0.930908;
      a[231] = 0.462891;
      a[232] = 0.882812;
      a[233] = 0.835938;
      a[234] = 0.835938;
      a[235] = 0.866943;
      a[236] = 0.866943;
      a[237] = 0.695801;
      a[238] = 0.695801;
      a[239] = 0.873779;
      a[241] = 0.873779;
      a[242] = 0.759766;
      a[243] = 0.945801;
      a[244] = 0.770996;
      a[245] = 0.86499;
      a[246] = 0.770996;
      a[247] = 0.887939;
      a[248] = 0.966797;
      a[249] = 0.887939;
      a[250] = 0.830811;
      a[251] = 0.872803;
      a[252] = 0.926758;
      a[253] = 0.969971;
      a[254] = 0.917969;
    }
    else if ( !strcmp(font, "Gothic-Medium.Hiragana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.5;
      }
    }
    else if ( !strcmp(font, "Gothic-Medium.Katakana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.5;
      }
    }
    else if ( !strcmp(font, "Ryumin-Light.Hiragana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.5;
      }
    }
    else if ( !strcmp(font, "Ryumin-Light.Katakana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 0.5;
      }
    }
    else {
      for ( i = 0 ; i < 256 ; i++ ) {
	a[i] = 1.0;
      }
    }
    return NULL;
  }
}


/*=============================================================================
			end
=============================================================================*/
