/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/

// IHM implementation header

#ifndef QDVRGUIIMPL_H
#define QDVRGUIIMPL_H
#include <pthread.h>

#include <string>
#include <utility>

#include <qapplication.h>
#include <qlist.h>

#include "QDvrGUI.h"

using namespace std;

class DVR;
class QV4LWindow;

//attributes of a predefined type of image
//could be extended with bpp, margins, etc  (will be in the future)
struct PredefinedSize {
	char	*label;
	int		width;
	int		height;
};


// the kernel of this application
class QDvrGUIImpl : public QDvrGUI
{ 
    Q_OBJECT

public:
    QDvrGUIImpl(QApplication *app, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~QDvrGUIImpl();

public slots:
	void startRecording();
	void stopRecording();
//	void replay();
	
	void changeTopMargin(int);
	void changeBottomMargin(int);	
		
	void setVideoFrameWidth(int);
	void setVideoFrameHeight(int);	
	void setVideoFrameSize(const QString &);
	void setTopMargin(int);
	void setBottomMargin(int);
	
	void isRecordDone();
	void verifyStartTime();

	void setCodecParameters();
	void setAudioParameters();
	void setVideoParameters();
	
	void browseFile();
	void changeTimeEnabling();
	virtual void setPreviewMode();
  void changeVideoFrameRate();
	
protected:
	void closeEvent(QCloseEvent *);
	
	void postRecordingProcessing();

	void loadConfigFile();
	void saveConfigFile();
	int cpuLoad();

	void errorProcessing();

  void enableVideoPreview(bool on);

	static void *video_monitoring(void *);

protected:
	QApplication *app;

	DVR			*my_dvr;
	
	QV4LWindow	*qt_video_display;
	
	int 		gui_video_width;
	int 		gui_video_height;
	int 		gui_video_bpp;
	int 		gui_video_top_margin;
	int 		gui_video_bottom_margin;
	string	gui_video_codec_name;

	bool		gui_sound_recording_enabled;
	int			gui_sound_sample_size;
	int			gui_sound_frequency;
	int			gui_sound_channels;
	int			gui_sound_format;					// compression format, not capture (only PCM for the moment)
	int			gui_sound_byterate; 				// byterate not bitrate

	int			gui_video_channel;
	int			gui_video_norm;
	string	gui_sound_device;
	string	gui_video_device;
	
	
	
	QList<pair<QString*, unsigned long> > channels;	//name and frequency of the channels
	string	current_channel;

	static struct	PredefinedSize	predefined_sizes[];

	QTimer		*qtt_is_record_done;
	QTimer		*qtt_start_time;				//used to start recording at a specified time

	string		config_file_name;			//name of the config file to use

	int				predefined_size;			//parameter
	
	pthread_t	t_video_monitoring;
};

#endif // QDVRGUIIMPL_H
