<?php
# dvdisaster: Russian homepage translation
# Copyright (C) 2007-2009 Igor Gorbounov
#
# UTF-8 trigger: äöüß 
#
# Include our PHP sub routines, then call begin_page()
# to start the HTML page, insert the header, 
# navigation and news if appropriate.

require("../include/dvdisaster.php");
begin_page();
?>

<!--- Insert actual page content below --->

<h3>Идея, лежащая в основе исправления ошибок</h3>

<table width="100%">
<tr valign="top">
<td><img src="../images/bad-cd.png"></td>
<td> </td>
<td><img src="../images/ecc.png"></td>
<td> &nbsp; </td>
<td rowspan="3">
Из примера на предыдущей странице мы знаем, как dvdisaster воссоздает
данные, используя всё еще читаемые части носителя в совокупности с
данными для исправления ошибок.<p>

Чтобы получить максимум отдачи от dvdisaster, полезно понимать основы 
метода исправления ошибок. Пользуясь случаем, мы можем опровергнуть
неправильное предположение, которое можно то и дело услышать - данные для
исправления ошибок <b>не</b> являются просто копией последних 20% секторов носителя.
Это был бы и в самом деле дешевый трюк ;-)
</td>
</tr>

<tr>
<td align="right">80%<img src="../images/rdiag-arrow.png"></td>
<td> </td>
<td align="left"><img src="../images/ldiag-arrow.png">20%</td>
<td> </td>
</tr>

<tr>
<td> </td>
<td> <img src="../images/good-image.png"></td>
<td> </td>
<td> </td>
</tr>
</table><p>

<b>Пример: Пин-код для ящика письменного стола Анны</b><p>

У Анны есть стол, в котором ящики открываются, только если ввести в кодовый замок
числа "8 6 2 3". Поскольку в этих ящиках нет какой-либо деликатной
информации, она решает записать числа прямо на поверхности стола:<p>

<img src="../images/ecc-example1.png"><p>

Анна предусмотрительна и предполагает, что одно из чисел станет нечитаемым, 
если на него случайно капнут чернила. Поэтому она записывает также и
сумму этих четырех чисел ("+" и "=" - добавлены только для ясности):<p>

<img src="../images/ecc-example2.png"><p>

Через какое-то время на числа, действительно, попало чернильное пятно:<p>

<img src="../images/ecc-example3.png"><p>

Но это не проблема, раз Анна может вновь вычислить недостающее число <i>x</i>,
переписав все еще читаемые части уравнения:<p>

8 + x + 2 + 3 = 19, отсюда<p>

x = 19 - 8 - 2 - 3, и, следовательно, x = 6.<p>

Легко видеть, что любое из первоначальных пяти чисел может быть
восстановлено по оставшимся четырем. Этот пример также демонстрирует
некоторые важные свойства исправления ошибок:
<p>

<table><tr><td><img src="../images/ecc-example4.png"></td><td>&nbsp;&nbsp;</td>
<td valign="top">
Для данного набора данных (например, числа "8 6 2 3")
дополнительные данные для исправления ошибок (например, сумма "19") могут быть созданы
таким образом, что потерянное данное может быть вновь рассчитано по оставшимся данным.<p>

Такой же принцип используется в dvdisaster; защищаемая последовательность чисел
есть ничто иное, как ISO-образ CD, DVD или BD.</td>
</tr></table><p>

Концепция <b>избыточности</b> может быть объяснена следующим образом:

<ul>
<li>Одно "число для исправления ошибок" рассчитывается для четырех входных чисел.
1 из 4 (или 1/4) соответствует избыточности в 25%.</li>
<li> По одному числу для исправления ошибок мы можем вновь рассчитать точно одно
недостающее число, или самое большее 25% данных. 
Избыточность эквивалентна максимальной возможности исправления ошибок.</li>
<li> Дополнительное место, требуемое для размещения данных для исправления ошибок,
также определяется избыточностью (25% в примере).</li>
</ul>

В dvdisaster понятие избыточности используется соответствующим образом. Кроме того,
обратите внимание, что
<ul>
<li>никакие данные не могут быть восстановлены, когда потеря данных превышает избыточность
(уравнение в примере нельзя решить для двух и более неизвестных).</li>
<li>данные для исправления ошибок должны быть рассчитаны тогда, когда все данные
еще присутствуют / читаются.</li>
</ul><p>

Приведенный выше пример не обобщается на схему исправления ошибок
для восстановления более одного недостающего значения данных. Чтобы сделать это,
требуется более мощная система уравнений, которая может быть решена для более чем
одного недостающего значения. dvdisaster использует 
<a href="http://de.wikipedia.org/wiki/Reed-Solomon-Code">код Рида-Соломона</a>, 
у которого есть такие качества; однако необходимая для этого математика не преподается
в школе. Поэтому заинтересованные читатели отсылаются к соответствующим
книгам по теории кодирования.


<!--- do not change below --->

<?php
# end_page() adds the footer line and closes the HTML properly.

end_page();
?>
