/*
 * parseconf.c - parse /etc/dumpconfig.c 
 * Created by:  Troy Heber (troy.heber@hp.com)
 *
 * Copyright 2004 Hewlett-Packard Development Company, L.P.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "parseconf.h"


struct pconf *
parseconf(char * config_file)
{
    int i;
    FILE *fp;
    struct pconf *conf;
    char line[MAXLINE];
    char *p, *val;
    char *parse[LIST_SIZE] = {"DUMP_ACTIVE", 
	                      "DUMPDEV", 
		      	      "DUMPDIR", 
		      	      "DUMP_LEVEL",
		      	      "DUMP_FLAGS",
		      	      "DUMP_COMPRESS",
		      	      "PANIC_TIMEOUT",
			      "TARGET_HOST",
			      "TARGET_PORT",
			      "SOURCE_PORT",
			      "ETH_ADDRESS"

    };

     if  ((conf=malloc(sizeof(struct pconf))) == NULL){
	perror("FATAL ERROR: Couldn't allocate enough memory");
	exit(10);
    }
     
    conf->dump_active[0] = '\0';
    conf->dumpdev[0] = '\0';
    conf->dumpdir[0] = '\0';
    conf->dump_level[0]= '\0';
    conf->dump_flags[0]= '\0';
    conf->dump_compress[0]= '\0';
    conf->panic_timeout[0] = '\0';
    conf->target_host[0] = '\0';
    conf->target_port[0] = '\0';
    conf->source_port[0] = '\0';
    conf->eth_address[0] = '\0';

    if((fp = fopen(config_file, "r")) != NULL){
	while (fgets(line,sizeof(line),fp) != NULL)
	{
	    // Ignore comments 
	    if ((p = strchr(line, '#')) != NULL)
		*p = '\0';
	    
	    // Find '='
	    if ((p = strchr(line, '=')) != NULL){
		*p = '\0';
		val = p + 1;

		while(*val == ' ' || *val == '\t')
		    val++;
		
	    }else // Bad line or comment
		continue;

		
	    for (i=0; i < LIST_SIZE; i++){
		    if(strstr(line,parse[i])){
			if ((p = strchr(val,'\n'))) // kill the newline char
			    *p = '\0';

			switch (i)
			{
			    case 0: // DUMP_ACTIVE
				strcpy(conf->dump_active, val);
				break;
			    case 1: // DUMPDEV
				strcpy(conf->dumpdev, val);
				break;
			    case 2: // DUMPDIR
				strcpy(conf->dumpdir, val);
				break;
			    case 3: // DUMP_LEVEL
				strcpy(conf->dump_level, val);
				break;
			    case 4: // DUMP_FLAGS
				strcpy(conf->dump_flags, val);
				break;
			    case 5: // DUMP_COMPRESS
				strcpy(conf->dump_compress, val);
				break;
			    case 6: // PANIC_TIMEOUT
				strcpy(conf->panic_timeout, val);
				break;
			    case 7:  //  TARGET_HOST",
				strcpy(conf->target_host, val);
				break;
			    case 8:  // TARGET_PORT",
				strcpy(conf->target_port, val);
				break;
			    case 10: // SOURCE_PORT",
				strcpy(conf->source_port, val);
				break;
			    case 11: // ETH_ADDRESS"
				strcpy(conf->eth_address, val);
				break;
			}
		    }// if 
	    }// for

	}// while
	fclose(fp);
    }else
	return NULL;

    return conf;
}


