#
# app_init.tcl
#

proc app_init_tcl {} {
    global DEBUG tcl_precision tcl_prompt1 main

    #set the DEBUG flag
    set DEBUG 0

    # full precision for double <--> str conversions
    set tcl_precision 17
 
    # set prompt routine
    set tcl_prompt1 "app_prompt"
    
    install_postmaster

    # set initial message
    message_push "DsTool - A DYNAMICAL SYSTEMS TOOLKIT"
}

proc app_prompt {} {
    puts -nonewline "DsTool% "
}


proc load_model n {
    global Model

    begin_wait "Loading new model."
    pm PUT Model.Load_Number $n
    pm EXEC Model.Load
    pm_to_tcl
    if { [llength [ info procs window(rebuild)]] > 0 } {
	window(rebuild)
    }
    end_wait "New model loaded."

}

proc load_model_by_name name {
    global Model

    for {set i 0} {$i < $Model(Names)} {incr i} {
	if {[string compare $name $Model(Names,$i)] == 0} {
	    load_model $i
	    return
	}
    }
    
    # Cannot match model name

}

proc pmtcl_func args {
    tcl_to_pm
    pm_to_tcl
    eval $args
    pm_to_tcl
}

proc message_show msg {
    global main
    set main(message) $msg
}

proc message_push msg {
    global main

    lappend main(msgstack) $msg
    message_show $msg
}

proc message_pop {args} {
    global main

    set n [llength $main(msgstack)]
    if {$n <= 1} {
	puts "error - nothing left on main message stack"
    } else {
	incr n -1
	if {[llength $args]} {
	    message_show [lindex $args 0]
	} else {
	    message_show [lindex $main(msgstack) [expr $n-1]]
	}
	set main(msgstack) [lreplace $main(msgstack) $n $n]
    }
}

