/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

// drip general
#include "../src/drip.h"
#include "../src/external.h"
// libmpeg2
#include <mpeg2dec/mpeg2.h>
#include "mpeg2_internal.h"
// liba52
#include <a52dec/a52.h>
#include <a52dec/audio_out.h>
#include <a52dec/mm_accel.h>
// other
#include <unistd.h>
#include <string.h>
#include <errno.h>

#ifdef __cplusplus
}
#endif

// defines
//none

// enums
typedef enum mpeg_buffer_e {EMPTY,READ,PROCESSING,UNAVAILABLE};// mpeg_buffer_e;
// Structs
typedef struct mpeg_read_buffer_s mpeg_read_buffer_t;
typedef struct mpeg_read_buffer_s {
    guint8 *buffer;
    size_t lenght;
    //enum mpeg_buffer_e status;
};
    
    
// globals
extern glong SCRstream;
extern gint PTSvideo;
extern gboolean demuxing;


// functions
gint drip_mpeg_open(gchar *input,void handler(guint8*[3],uint32_t,gint));
gint drip_mpeg_close(gboolean lock);
gint drip_mpeg_seek_percentage(gdouble perc);
void drip_mpeg_start_demuxing(gint **audio_channel);
guchar* drip_mpeg_frame(void);
guchar* drip_mpeg_next_frame(void);
gint drip_mpeg_width(void);
gint drip_mpeg_height(void);
gdouble drip_framerate(void);
gint16* fetch_from_audio_buffer(gint chunk_size, gint SCR,gint channel);
gint drip_audio_samplerate(void);
gint drip_audio_bitrate(void);
gint drip_audio_channels(void);
gboolean output_audio(glong frame);
gdouble TimeStamp_Frame(void);
gdouble drip_PTS_correction(void);
void add_silence_to_audio_buffer(gint PTS,gboolean frame);
