/* You may find the license in the LICENSE file */

const METALINK_LOGO = 'chrome://dta/skin/icons/metalink48.png';

Cu.import("resource://dta/version.jsm");

const MetaSelect = {
 	_insertDownload: function(d) {
		try {
	 		if (d.lang && d.lang.search(/^\w{2}(?:-\w{2})?$/) != -1) {
	 			d.selected = Version.LOCALE.slice(0,2) == d.lang.slice(0,2);
	 		}
	 		let e = document.createElement('richlistitem');
	 		e.setAttribute("class", "item");
	 		e.download = d;
	 		$('downloads').appendChild(e);
		}
		catch (ex) {
			Debug.log("Failed to add download from metalink", ex);
		}
 	},
 	load: function ML_load() {
 		$('cancelbutton').label = _('button-cancel');
 		
 		try {
 			let downloads = window.arguments[0];
 			if (downloads.length) {
 				downloads.forEach(this._insertDownload, this);
 			}
 		}
 		catch(ex) {
 			Debug.log("Failed to load downloads from Metalink", ex);
 			// no-op
 		}
 		let info = {
 			'identity': _('mlidentity'),
 			'description': _('mldescription'),
 			'logo': null,
 			'publisher': null,
 			'license': null
 		}
 		try {
 			let oi = window.arguments[1];
 			for (x in info) {
 				if (x in oi && oi[x]) {
 					info[x] = oi[x];
 				}
 			}
 		}
 		catch (ex) {
 			// no-op
 		}
 		$('identity').value = info.identity;
 		$('desc').appendChild(document.createTextNode(info.description));
		let logo = new Image();
		logo.onload = function() {
			let canvas = $('icon');
			try {
				canvas.width = canvas.clientWidth;
				canvas.height = canvas.clientHeight;
				let ctx = canvas.getContext('2d');
				
				let w = logo.naturalWidth;
				let h = logo.naturalHeight;
				let d = Math.max(canvas.width, w, h);
				
				if (d != canvas.width) {
					ctx.scale(canvas.width / d, canvas.height / d);
				}
				
				ctx.drawImage(logo, (d - w) /2, (d - h) / 2);								
			}
			catch (ex) {
				Debug.log("Cannot load logo", ex);
				logo.src = METALINK_LOGO;
			}
		};
		logo.onerror = function() {
			logo.src = METALINK_LOGO;
		};
		logo.src = info.logo ? info.logo : METALINK_LOGO;
 		if (info.publisher) {
 			let e = $('publisher');
 			e.value = info.publisher[0];
 			e.link = info.publisher[1]; 			
 		}
 		else {
 			$('boxPublisher').hidden = true;
 		}
 		if (info.license) {
 			let e = $('license');
 			e.value = info.license[0];
 			e.link = info.license[1]; 			
 		}
 		else {
 			$('boxLicense').hidden = true;
 		} 		
 	},
	browseDir: function() {
		// get a new directory
		let newDir = Utils.askForDir(
			$('directory').value, // initialize dialog with the current directory
			_("validdestination")
		);
		// alright, we got something new, so lets set it.
		if (newDir) {
			$('directory').value = newDir;
		}
	}, 	
	download: function ML_download(start) {
		let [notifications, directory, mask] = $('notifications', 'directory', 'renaming');
		notifications.removeAllNotifications(true);
		
		function err(msg) {
			notifications.appendNotification(msg, 0, null, notifications.PRIORITY_CRITICAL_MEDIUM, null);
		}
		
		directory.value = directory.value.trim();
		mask.value = mask.value.trim();
		
		if (!mask.value) {
			err(_('alertmask'));
			return false;
		}
		if (!directory.value || !Utils.validateDir(directory.value)) {
			err(_(directory.value ? 'alertinvaliddir' : 'alertnodir'));
			return false;
		}
		
		let selected = false;
		Array.forEach(
			document.getElementsByTagName('richlistitem'),
			function(n) {
				n.download.dirSave = directory.value;
				n.download.mask = mask.value;		
				n.download.selected = n.checked;
				selected |= n.checked;
			},
			this
		);
		if (!selected) {
			err(_('nolinks'));
			return false;
		}
		window.arguments[1].start = start;
		self.close();
		return true;
	},
	cancel: function ML_cancel() {
		Array.forEach(
			document.getElementsByTagName('richlistitem'),
			function(n) {
				n.download.selected = false;
			},
			this
		);
		self.close();
		return true;
	},
	openLink: function(e) {
		openUrl(e.link);
	},
	select: function(type) {
		let f;
		switch (type) {
		case 'all':
			f = function(node) { return true; }
		break;
		case 'none':
			f = function(node) { return false; }
		break;
		case 'invert':
			f = function(node) { return !node.checked; }
		break;
		default:
		return;
		}
		let nodes = document.getElementsByTagName('richlistitem');
		for (let i = 0, e = nodes.length, node; i < e; ++i) {
			node = nodes[i];
			node.checked = f(node);
		}
	}
};
addEventListener('load', function() {
	removeEventListener('load', arguments.callee, false);
	try {
		MetaSelect.load();
	}
	catch (ex) {
		Debug.log("Failed to load", ex);
	}
}, false);
addEventListener('close', function() {
	removeEventListener('close', arguments.callee, false);
	MetaSelect.cancel();
}, false);
