import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule
from dosage.util import getQueryParams

class MacHall(BasicComicModule):
    latestUrl = 'http://www.machall.com/'
    imageUrl = 'http://www.machall.com/index.php?strip_id=%s'
    imageSearch = re.compile(r'<img src=\'(/index.php\?do_command=show_strip&strip_id=\d+?&auth=[\d-]+?)\'', re.IGNORECASE)
    prevSearch = re.compile(r'<a href=\'(/index.php\?strip_id=\d+?)\'><img border=0 src=\'drop_shadow/previous.gif\'', re.IGNORECASE)
    help = 'Index format: n (unpadded)'

    def getFilename(self, imageUrl, pageUrl):
        return getQueryParams(imageUrl)['strip_id'][0]
