import re
import urllib
from dosage.modules.helpers import BasicComicModule as bcm

class ComicsDotCom(bcm.BasicComicModule, bcm.IndirectLatestMixin):
    baseUrl = 'http://www.comics.com/%s/%s/archive/'
    imageUrl = '%s-%%s.html'
    imageSearch = re.compile(r'SRC="(/[\w/]+?/archive/images/\w+?\d+\..+?)"')
    prevSearch = re.compile(r'<A HREF="(/[\w/]+?/archive/\w+?-\d{8}\.html)">(?:<IMG SRC="/[\w/]+?/images/arrow_left.gif|(?:<font[^>]*?>)?Previous Day)')
    latestSearch = re.compile(r'<A HREF="(/[\w/]+?/archive/\w+?-\d{8}\.html)">(?:<IMG SRC="/[\w/]+?/images/arrow_right.gif|(?:<font[^>]*?>)?Next Day)')
    help = 'Index format: yyyymmdd'

    submodules = {
        'chickweed': 'comics',
        'agnes': 'creators',
        'alleyoop': 'comics',
        'andycapp': 'creators',
        'arlonjanis': 'comics',
        'bc': 'creators',
        'ballardst': 'creators',
        'barkeaterlake': 'comics',
        'ben': 'comics',
        'betty': 'comics',
        'bignate': 'comics',
        'bonanas': 'wash',
        'bornloser': 'comics',
        'buckets': 'comics',
        'candorville': 'wash',
        'acaseinpoint': 'comics',
        'cheapthrills': 'wash',
        'committed': 'comics',
        'dilbert': 'comics',
        'drabble': 'comics',
        'fatcats': 'comics',
        'ferdnand': 'comics',
        'flightdeck': 'creators',
        'floandfriends': 'creators',
        'franknernest': 'comics',
        'frazz': 'comics',
        'geech': 'comics',
        'getfuzzy': 'comics',
        'gofish': 'comics',
        'graffiti': 'comics',
        'grandave': 'comics',
        'grizzwells': 'comics',
        'heathcliff': 'creators',
        'herbnjamaal': 'creators',
        'herman': 'comics',
        'humblestumble': 'comics',
        'janesworld': 'comics',
        'jumpstart': 'comics',
        'kitncarlyle': 'comics',
        'liberty': 'creators',
        'lilabner': 'comics',
        'luann': 'comics',
        'marmaduke': 'comics',
        'meg': 'comics',
        'moderatelyconfused': 'comics',
        'momma': 'creators',
        'monty': 'comics',
        'motley': 'comics',
        'nancy': 'comics',
        'naturalselection': 'creators',
        'offthemark': 'comics',
        'onebighappy': 'creators',
        'othercoast': 'creators',
        'genepool': 'wash',
        'hedge': 'comics',
        'pcnpixel': 'wash',
        'peanuts': 'comics',
        'pearls': 'comics',
        'pibgorn': 'comics',
        'pickles': 'wash',
        'raisingduncan': 'comics',
        'reality': 'comics',
        'redandrover': 'wash',
        'ripleys': 'comics',
        'roseisrose': 'comics',
        'rubes': 'creators',
        'rudypark': 'comics',
        'sheldon': 'comics',
        'shirleynson': 'comics',
        'soup2nutz': 'comics',
        'speedbump': 'creators',
        'spotthefrog': 'comics',
        'strangebrew': 'creators',
        'sunshineclub': 'comics',
        'tarzan': 'comics',
        'thatslife': 'wash',
        'wizardofid': 'creators',
        'workingdaze': 'comics',
        'workingitout': 'creators',
    }

    def __init__(self, submodule):
        bcm.BasicComicModule.__init__(self)
        self.baseUrl = self.baseUrl % (self.submodules[submodule], submodule)
        self.imageUrl = urllib.basejoin(self.baseUrl, self.imageUrl % (submodule,))
        self.name = 'ComicsDotCom' + '/' + submodule

    def getFilename(self, imageUrl, pageUrl):
        htmlname = pageUrl.split('/')[-1]
        filename = htmlname.split('.')[0]
        return filename
