import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin

class SomethingPositive(BasicComicModule, BounceMixin):
    baseUrl = 'http://www.somethingpositive.net/'
    imageUrl = 'http://www.somethingpositive.net/sp%s.shtml'
    imageSearch = re.compile(r'<img src="(/?arch/.+\..+?)"')
    prevSearch = re.compile(r'<a href="(sp\d{8}\.shtml)"><font size=1\nface=".+?"\nSTYLE=".+?">Previous', re.MULTILINE)
    nextSearch = re.compile(r'<a href="(sp\d{8}\.shtml)"><font size=1\nface=".+?"\nSTYLE=".+?">Next', re.MULTILINE)
    help = 'Index format: mmddyyyy'

    def getFilename(self, imageUrl, pageUrl):
        return pageUrl.split('/')[-1].split('.')[0]
