import java.net.URL;

/**
 * Interface for classes that can extract links from a document
 *
 * @version $Id: LinkExtractor.java,v 1.4 2002/08/23 03:40:23 blsecres Exp $
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 */
public interface LinkExtractor {
    /**
     * Extract links from file
     * @param file The file to extract links from
     */
    public String[] getLinks(IGFile file);


    /**
     * Instruct the extractor whether or not to collect links
     * @param pref If the preference is <tt>true</tt>, links will be collected.
     * 	If <tt>false</tt>, no links will be collected.
     */
    public void wantURLs(boolean pref);
}

/*
 * $Log: LinkExtractor.java,v $
 * Revision 1.4  2002/08/23 03:40:23  blsecres
 * Integrated LinkScanner into FileList.makeList().
 * Started coding support for 'linkfollow' based file system search
 *     in LinkScanner.
 *
 * Revision 1.3  2002/08/20 18:00:08  blsecres
 * Added ant build file.
 * Fixed case error on javadoc comments.
 *
 * Revision 1.2  2002/08/19 18:45:34  blsecres
 * Fixed bugs in and added features to LinkScanner and calling classes.
 *
 * Revision 1.1  2002/08/17 14:19:06  blsecres
 * Merged scratch/blsecres code into main source tree.
 *
 */
