// This code conforms with the UFC specification version 1.4.0
// and was automatically generated by FFC version 1.4.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no-evaluate_basis:              True
//   no-evaluate_basis_derivatives:  True
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          True

#include "Poisson3D_4.h"

/// Constructor
poisson3d_4_finite_element_0::poisson3d_4_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
poisson3d_4_finite_element_0::~poisson3d_4_finite_element_0()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* poisson3d_4_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 4, None)";
}

/// Return the cell shape
ufc::shape poisson3d_4_finite_element_0::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
std::size_t poisson3d_4_finite_element_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
std::size_t poisson3d_4_finite_element_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
std::size_t poisson3d_4_finite_element_0::space_dimension() const
{
    return 35;
}

/// Return the rank of the value space
std::size_t poisson3d_4_finite_element_0::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
std::size_t poisson3d_4_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

/// Evaluate basis function i at given point x in cell
void poisson3d_4_finite_element_0::_evaluate_basis(std::size_t i,
                                    double* values,
                                    const double* x,
                                    const double* vertex_coordinates,
                                    int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis not generated (compiled with -fno-evaluate_basis)");
}

/// Evaluate all basis functions at given point x in cell
void poisson3d_4_finite_element_0::_evaluate_basis_all(double* values,
                                        const double* x,
                                        const double* vertex_coordinates,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 35; r++)
    {
      _evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void poisson3d_4_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double* values,
                                                const double* x,
                                                const double* vertex_coordinates,
                                                int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis_derivatives not generated (compiled with -fno-evaluate_basis_derivatives)");
}

/// Evaluate order n derivatives of all basis functions at given point x in cell
void poisson3d_4_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double* values,
                                                    const double* x,
                                                    const double* vertex_coordinates,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 35; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 4)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[81];
    for (unsigned int r = 0; r < 81; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 35; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

/// Evaluate linear functional for dof i on the function f
double poisson3d_4_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double* vertex_coordinates,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.75*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.75*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.75*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.25*vertex_coordinates[6] + 0.75*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[7] + 0.75*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[8] + 0.75*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
      y[1] = 0.75*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
      y[2] = 0.75*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[4] + 0.75*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[5] + 0.75*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
      y[1] = 0.75*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
      y[2] = 0.75*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[6];
      y[1] = 0.25*vertex_coordinates[4] + 0.75*vertex_coordinates[7];
      y[2] = 0.25*vertex_coordinates[5] + 0.75*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[9];
      y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[10];
      y[2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[6];
      y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[7];
      y[2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[6];
      y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[7];
      y[2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[3];
      y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[4];
      y[2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 21:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[3];
      y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[4];
      y[2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 22:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 23:
      {
        y[0] = 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 24:
      {
        y[0] = 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 25:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 26:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 27:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 28:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 29:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 30:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 31:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 32:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
      y[1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
      y[2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 33:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 34:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

/// Evaluate linear functionals for all dofs on the function f
void poisson3d_4_finite_element_0::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const double* vertex_coordinates,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.75*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.75*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.75*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.25*vertex_coordinates[6] + 0.75*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[7] + 0.75*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[8] + 0.75*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
    y[1] = 0.75*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
    y[2] = 0.75*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[4] + 0.75*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[5] + 0.75*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
    y[1] = 0.75*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
    y[2] = 0.75*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[6];
    y[1] = 0.25*vertex_coordinates[4] + 0.75*vertex_coordinates[7];
    y[2] = 0.25*vertex_coordinates[5] + 0.75*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[9];
    y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[10];
    y[2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[6];
    y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[7];
    y[2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[6];
    y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[7];
    y[2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[3];
    y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[4];
    y[2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[3];
    y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[4];
    y[2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[21] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[22] = vals[0];
    y[0] = 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[23] = vals[0];
    y[0] = 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[24] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[25] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[26] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[27] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[28] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[29] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[30] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[31] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
    y[1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
    y[2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[32] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[33] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[34] = vals[0];
}

/// Interpolate vertex values from dof values
void poisson3d_4_finite_element_0::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const double* vertex_coordinates,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void poisson3d_4_finite_element_0::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void poisson3d_4_finite_element_0::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
}

/// Return the number of sub elements (for a mixed element)
std::size_t poisson3d_4_finite_element_0::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* poisson3d_4_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* poisson3d_4_finite_element_0::create() const
{
    return new poisson3d_4_finite_element_0();
}

/// Constructor
poisson3d_4_dofmap_0::poisson3d_4_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

/// Destructor
poisson3d_4_dofmap_0::~poisson3d_4_dofmap_0()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* poisson3d_4_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 4, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool poisson3d_4_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    case 3:
      {
        return true;
        break;
      }
    }
    
    return false;
}

/// Return the topological dimension of the associated cell shape
std::size_t poisson3d_4_dofmap_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
std::size_t poisson3d_4_dofmap_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
std::size_t poisson3d_4_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0] + 3*num_global_entities[1] + 3*num_global_entities[2] + num_global_entities[3];
}

/// Return the dimension of the local finite element function space for a cell
std::size_t poisson3d_4_dofmap_0::local_dimension() const
{
    return 35;
}

/// Return the number of dofs on each cell facet
std::size_t poisson3d_4_dofmap_0::num_facet_dofs() const
{
    return 15;
}

/// Return the number of dofs associated with each cell entity of dimension d
std::size_t poisson3d_4_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void poisson3d_4_dofmap_0::tabulate_dofs(std::size_t* dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const ufc::cell& c) const
{
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + 3*c.entity_indices[1][0];
    dofs[5] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[6] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[7] = offset + 3*c.entity_indices[1][1];
    dofs[8] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[9] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[10] = offset + 3*c.entity_indices[1][2];
    dofs[11] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[12] = offset + 3*c.entity_indices[1][2] + 2;
    dofs[13] = offset + 3*c.entity_indices[1][3];
    dofs[14] = offset + 3*c.entity_indices[1][3] + 1;
    dofs[15] = offset + 3*c.entity_indices[1][3] + 2;
    dofs[16] = offset + 3*c.entity_indices[1][4];
    dofs[17] = offset + 3*c.entity_indices[1][4] + 1;
    dofs[18] = offset + 3*c.entity_indices[1][4] + 2;
    dofs[19] = offset + 3*c.entity_indices[1][5];
    dofs[20] = offset + 3*c.entity_indices[1][5] + 1;
    dofs[21] = offset + 3*c.entity_indices[1][5] + 2;
    offset += 3*num_global_entities[1];
    dofs[22] = offset + 3*c.entity_indices[2][0];
    dofs[23] = offset + 3*c.entity_indices[2][0] + 1;
    dofs[24] = offset + 3*c.entity_indices[2][0] + 2;
    dofs[25] = offset + 3*c.entity_indices[2][1];
    dofs[26] = offset + 3*c.entity_indices[2][1] + 1;
    dofs[27] = offset + 3*c.entity_indices[2][1] + 2;
    dofs[28] = offset + 3*c.entity_indices[2][2];
    dofs[29] = offset + 3*c.entity_indices[2][2] + 1;
    dofs[30] = offset + 3*c.entity_indices[2][2] + 2;
    dofs[31] = offset + 3*c.entity_indices[2][3];
    dofs[32] = offset + 3*c.entity_indices[2][3] + 1;
    dofs[33] = offset + 3*c.entity_indices[2][3] + 2;
    offset += 3*num_global_entities[2];
    dofs[34] = offset + c.entity_indices[3][0];
    offset += num_global_entities[3];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void poisson3d_4_dofmap_0::tabulate_facet_dofs(std::size_t* dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 7;
      dofs[7] = 8;
      dofs[8] = 9;
      dofs[9] = 10;
      dofs[10] = 11;
      dofs[11] = 12;
      dofs[12] = 22;
      dofs[13] = 23;
      dofs[14] = 24;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 13;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 16;
      dofs[10] = 17;
      dofs[11] = 18;
      dofs[12] = 25;
      dofs[13] = 26;
      dofs[14] = 27;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 7;
      dofs[4] = 8;
      dofs[5] = 9;
      dofs[6] = 13;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 19;
      dofs[10] = 20;
      dofs[11] = 21;
      dofs[12] = 28;
      dofs[13] = 29;
      dofs[14] = 30;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 10;
      dofs[4] = 11;
      dofs[5] = 12;
      dofs[6] = 16;
      dofs[7] = 17;
      dofs[8] = 18;
      dofs[9] = 19;
      dofs[10] = 20;
      dofs[11] = 21;
      dofs[12] = 31;
      dofs[13] = 32;
      dofs[14] = 33;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void poisson3d_4_dofmap_0::tabulate_entity_dofs(std::size_t* dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 5;
        dofs[2] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 10;
        dofs[1] = 11;
        dofs[2] = 12;
          break;
        }
      case 3:
        {
          dofs[0] = 13;
        dofs[1] = 14;
        dofs[2] = 15;
          break;
        }
      case 4:
        {
          dofs[0] = 16;
        dofs[1] = 17;
        dofs[2] = 18;
          break;
        }
      case 5:
        {
          dofs[0] = 19;
        dofs[1] = 20;
        dofs[2] = 21;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 22;
        dofs[1] = 23;
        dofs[2] = 24;
          break;
        }
      case 1:
        {
          dofs[0] = 25;
        dofs[1] = 26;
        dofs[2] = 27;
          break;
        }
      case 2:
        {
          dofs[0] = 28;
        dofs[1] = 29;
        dofs[2] = 30;
          break;
        }
      case 3:
        {
          dofs[0] = 31;
        dofs[1] = 32;
        dofs[2] = 33;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 34;
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void poisson3d_4_dofmap_0::tabulate_coordinates(double** dof_coordinates,
                                         const double* vertex_coordinates) const
{
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[0][2] = vertex_coordinates[2];
    dof_coordinates[1][0] = vertex_coordinates[3];
    dof_coordinates[1][1] = vertex_coordinates[4];
    dof_coordinates[1][2] = vertex_coordinates[5];
    dof_coordinates[2][0] = vertex_coordinates[6];
    dof_coordinates[2][1] = vertex_coordinates[7];
    dof_coordinates[2][2] = vertex_coordinates[8];
    dof_coordinates[3][0] = vertex_coordinates[9];
    dof_coordinates[3][1] = vertex_coordinates[10];
    dof_coordinates[3][2] = vertex_coordinates[11];
    dof_coordinates[4][0] = 0.75*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[4][1] = 0.75*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[4][2] = 0.75*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    dof_coordinates[5][0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[5][1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[5][2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[6][0] = 0.25*vertex_coordinates[6] + 0.75*vertex_coordinates[9];
    dof_coordinates[6][1] = 0.25*vertex_coordinates[7] + 0.75*vertex_coordinates[10];
    dof_coordinates[6][2] = 0.25*vertex_coordinates[8] + 0.75*vertex_coordinates[11];
    dof_coordinates[7][0] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
    dof_coordinates[7][1] = 0.75*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
    dof_coordinates[7][2] = 0.75*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
    dof_coordinates[8][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[8][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[8][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[9][0] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[9];
    dof_coordinates[9][1] = 0.25*vertex_coordinates[4] + 0.75*vertex_coordinates[10];
    dof_coordinates[9][2] = 0.25*vertex_coordinates[5] + 0.75*vertex_coordinates[11];
    dof_coordinates[10][0] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
    dof_coordinates[10][1] = 0.75*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
    dof_coordinates[10][2] = 0.75*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
    dof_coordinates[11][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[11][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[11][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[12][0] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[6];
    dof_coordinates[12][1] = 0.25*vertex_coordinates[4] + 0.75*vertex_coordinates[7];
    dof_coordinates[12][2] = 0.25*vertex_coordinates[5] + 0.75*vertex_coordinates[8];
    dof_coordinates[13][0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[9];
    dof_coordinates[13][1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[10];
    dof_coordinates[13][2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[11];
    dof_coordinates[14][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[14][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[14][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[15][0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[9];
    dof_coordinates[15][1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[10];
    dof_coordinates[15][2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[11];
    dof_coordinates[16][0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[6];
    dof_coordinates[16][1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[7];
    dof_coordinates[16][2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[8];
    dof_coordinates[17][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[17][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[17][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[18][0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[6];
    dof_coordinates[18][1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[7];
    dof_coordinates[18][2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[8];
    dof_coordinates[19][0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[3];
    dof_coordinates[19][1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[4];
    dof_coordinates[19][2] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[5];
    dof_coordinates[20][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[20][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[20][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    dof_coordinates[21][0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[3];
    dof_coordinates[21][1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[4];
    dof_coordinates[21][2] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[5];
    dof_coordinates[22][0] = 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[22][1] = 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[22][2] = 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    dof_coordinates[23][0] = 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[23][1] = 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[23][2] = 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    dof_coordinates[24][0] = 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[24][1] = 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[24][2] = 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[25][0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[25][1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[25][2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    dof_coordinates[26][0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[26][1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[26][2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    dof_coordinates[27][0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[27][1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[27][2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[28][0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
    dof_coordinates[28][1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
    dof_coordinates[28][2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
    dof_coordinates[29][0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[9];
    dof_coordinates[29][1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[10];
    dof_coordinates[29][2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[11];
    dof_coordinates[30][0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[30][1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[30][2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[31][0] = 0.5*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
    dof_coordinates[31][1] = 0.5*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
    dof_coordinates[31][2] = 0.5*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
    dof_coordinates[32][0] = 0.25*vertex_coordinates[0] + 0.5*vertex_coordinates[3] + 0.25*vertex_coordinates[6];
    dof_coordinates[32][1] = 0.25*vertex_coordinates[1] + 0.5*vertex_coordinates[4] + 0.25*vertex_coordinates[7];
    dof_coordinates[32][2] = 0.25*vertex_coordinates[2] + 0.5*vertex_coordinates[5] + 0.25*vertex_coordinates[8];
    dof_coordinates[33][0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[33][1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[33][2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[34][0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[34][1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[34][2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
}

/// Return the number of sub dofmaps (for a mixed element)
std::size_t poisson3d_4_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* poisson3d_4_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* poisson3d_4_dofmap_0::create() const
{
    return new poisson3d_4_dofmap_0();
}

/// Constructor
poisson3d_4_cell_integral_0_otherwise::poisson3d_4_cell_integral_0_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson3d_4_cell_integral_0_otherwise::~poisson3d_4_cell_integral_0_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & poisson3d_4_cell_integral_0_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void poisson3d_4_cell_integral_0_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 6311
    // Total number of operations (multiply-add pairs):                  6341
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    const double G0_0_1 = det*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    const double G0_0_2 = det*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    const double G0_1_0 = det*(K[3]*K[0] + K[4]*K[1] + K[5]*K[2]);
    const double G0_1_1 = det*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    const double G0_1_2 = det*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    const double G0_2_0 = det*(K[6]*K[0] + K[7]*K[1] + K[8]*K[2]);
    const double G0_2_1 = det*(K[6]*K[3] + K[7]*K[4] + K[8]*K[5]);
    const double G0_2_2 = det*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    
    // Compute element tensor
    A[0] = 0.0379188712522047*G0_0_0 + 0.0379188712522047*G0_0_1 + 0.0379188712522047*G0_0_2 + 0.0379188712522047*G0_1_0 + 0.0379188712522047*G0_1_1 + 0.0379188712522047*G0_1_2 + 0.0379188712522047*G0_2_0 + 0.0379188712522047*G0_2_1 + 0.0379188712522048*G0_2_2;
    A[1] = 0.00511463844797185*G0_0_0 + 0.00511463844797184*G0_1_0 + 0.00511463844797185*G0_2_0;
    A[2] = 0.00511463844797184*G0_0_1 + 0.00511463844797184*G0_1_1 + 0.00511463844797184*G0_2_1;
    A[3] = 0.00511463844797178*G0_0_2 + 0.00511463844797179*G0_1_2 + 0.00511463844797181*G0_2_2;
    A[4] = 0.00776014109347431*G0_0_1 + 0.00776014109347443*G0_0_2 + 0.00776014109347433*G0_1_1 + 0.00776014109347443*G0_1_2 + 0.00776014109347432*G0_2_1 + 0.00776014109347443*G0_2_2;
    A[5] = 0.00511463844797182*G0_0_1 + 0.00511463844797174*G0_0_2 + 0.00511463844797182*G0_1_1 + 0.00511463844797176*G0_1_2 + 0.00511463844797184*G0_2_1 + 0.00511463844797177*G0_2_2;
    A[6] = 0.00776014109347439*G0_0_1 + 0.00776014109347442*G0_0_2 + 0.00776014109347441*G0_1_1 + 0.00776014109347441*G0_1_2 + 0.00776014109347439*G0_2_1 + 0.00776014109347437*G0_2_2;
    A[7] = 0.00776014109347427*G0_0_0 + 0.00776014109347443*G0_0_2 + 0.0077601410934743*G0_1_0 + 0.00776014109347443*G0_1_2 + 0.00776014109347429*G0_2_0 + 0.00776014109347443*G0_2_2;
    A[8] = 0.00511463844797186*G0_0_0 + 0.00511463844797174*G0_0_2 + 0.00511463844797183*G0_1_0 + 0.00511463844797174*G0_1_2 + 0.00511463844797186*G0_2_0 + 0.00511463844797178*G0_2_2;
    A[9] = 0.00776014109347439*G0_0_0 + 0.00776014109347442*G0_0_2 + 0.00776014109347441*G0_1_0 + 0.00776014109347441*G0_1_2 + 0.00776014109347439*G0_2_0 + 0.00776014109347436*G0_2_2;
    A[10] = 0.00776014109347433*G0_0_0 + 0.00776014109347442*G0_0_1 + 0.00776014109347435*G0_1_0 + 0.00776014109347442*G0_1_1 + 0.00776014109347434*G0_2_0 + 0.00776014109347442*G0_2_1;
    A[11] = 0.00511463844797171*G0_0_0 + 0.00511463844797175*G0_0_1 + 0.0051146384479717*G0_1_0 + 0.00511463844797174*G0_1_1 + 0.00511463844797168*G0_2_0 + 0.00511463844797172*G0_2_1;
    A[12] = 0.00776014109347443*G0_0_0 + 0.00776014109347435*G0_0_1 + 0.00776014109347443*G0_1_0 + 0.00776014109347434*G0_1_1 + 0.00776014109347443*G0_2_0 + 0.00776014109347435*G0_2_1;
    A[13] = -0.0246913580246911*G0_0_0 - 0.0246913580246912*G0_0_1 - 0.0705467372134041*G0_0_2 - 0.0246913580246911*G0_1_0 - 0.0246913580246912*G0_1_1 - 0.0705467372134041*G0_1_2 - 0.0246913580246911*G0_2_0 - 0.0246913580246912*G0_2_1 - 0.0705467372134041*G0_2_2;
    A[14] = 0.0202821869488535*G0_0_0 + 0.0202821869488535*G0_0_1 + 0.052910052910053*G0_0_2 + 0.0202821869488535*G0_1_0 + 0.0202821869488535*G0_1_1 + 0.052910052910053*G0_1_2 + 0.0202821869488535*G0_2_0 + 0.0202821869488535*G0_2_1 + 0.0529100529100531*G0_2_2;
    A[15] = -0.00776014109347439*G0_0_0 - 0.00776014109347439*G0_0_1 - 0.0253968253968254*G0_0_2 - 0.00776014109347441*G0_1_0 - 0.00776014109347442*G0_1_1 - 0.0253968253968254*G0_1_2 - 0.00776014109347438*G0_2_0 - 0.00776014109347439*G0_2_1 - 0.0253968253968254*G0_2_2;
    A[16] = -0.0246913580246912*G0_0_0 - 0.0705467372134042*G0_0_1 - 0.0246913580246912*G0_0_2 - 0.0246913580246912*G0_1_0 - 0.0705467372134042*G0_1_1 - 0.0246913580246912*G0_1_2 - 0.0246913580246912*G0_2_0 - 0.0705467372134042*G0_2_1 - 0.0246913580246913*G0_2_2;
    A[17] = 0.0202821869488536*G0_0_0 + 0.0529100529100531*G0_0_1 + 0.0202821869488536*G0_0_2 + 0.0202821869488535*G0_1_0 + 0.0529100529100531*G0_1_1 + 0.0202821869488535*G0_1_2 + 0.0202821869488536*G0_2_0 + 0.0529100529100531*G0_2_1 + 0.0202821869488536*G0_2_2;
    A[18] = -0.00776014109347444*G0_0_0 - 0.0253968253968255*G0_0_1 - 0.00776014109347443*G0_0_2 - 0.00776014109347444*G0_1_0 - 0.0253968253968255*G0_1_1 - 0.00776014109347443*G0_1_2 - 0.00776014109347444*G0_2_0 - 0.0253968253968255*G0_2_1 - 0.00776014109347444*G0_2_2;
    A[19] = -0.0705467372134042*G0_0_0 - 0.0246913580246913*G0_0_1 - 0.0246913580246913*G0_0_2 - 0.0705467372134042*G0_1_0 - 0.0246913580246913*G0_1_1 - 0.0246913580246913*G0_1_2 - 0.0705467372134042*G0_2_0 - 0.0246913580246913*G0_2_1 - 0.0246913580246913*G0_2_2;
    A[20] = 0.0529100529100532*G0_0_0 + 0.0202821869488536*G0_0_1 + 0.0202821869488535*G0_0_2 + 0.0529100529100532*G0_1_0 + 0.0202821869488536*G0_1_1 + 0.0202821869488536*G0_1_2 + 0.0529100529100532*G0_2_0 + 0.0202821869488536*G0_2_1 + 0.0202821869488536*G0_2_2;
    A[21] = -0.0253968253968256*G0_0_0 - 0.0077601410934744*G0_0_1 - 0.00776014109347439*G0_0_2 - 0.0253968253968256*G0_1_0 - 0.00776014109347441*G0_1_1 - 0.00776014109347439*G0_1_2 - 0.0253968253968256*G0_2_0 - 0.0077601410934744*G0_2_1 - 0.00776014109347439*G0_2_2;
    A[22] = 0.0183421516754852*G0_0_0 + 0.0183421516754849*G0_0_1 + 0.0183421516754849*G0_0_2 + 0.0183421516754852*G0_1_0 + 0.0183421516754848*G0_1_1 + 0.0183421516754848*G0_1_2 + 0.0183421516754852*G0_2_0 + 0.0183421516754849*G0_2_1 + 0.0183421516754848*G0_2_2;
    A[23] = 0.0183421516754849*G0_0_0 + 0.0183421516754853*G0_0_1 + 0.018342151675485*G0_0_2 + 0.018342151675485*G0_1_0 + 0.0183421516754853*G0_1_1 + 0.018342151675485*G0_1_2 + 0.018342151675485*G0_2_0 + 0.0183421516754853*G0_2_1 + 0.018342151675485*G0_2_2;
    A[24] = 0.0183421516754852*G0_0_0 + 0.0183421516754852*G0_0_1 + 0.0183421516754854*G0_0_2 + 0.0183421516754853*G0_1_0 + 0.0183421516754852*G0_1_1 + 0.0183421516754855*G0_1_2 + 0.0183421516754853*G0_2_0 + 0.0183421516754852*G0_2_1 + 0.0183421516754856*G0_2_2;
    A[25] = 0.0493827160493826*G0_0_0 + 0.042328042328042*G0_0_1 + 0.0423280423280421*G0_0_2 + 0.0493827160493825*G0_1_0 + 0.042328042328042*G0_1_1 + 0.0423280423280421*G0_1_2 + 0.0493827160493825*G0_2_0 + 0.042328042328042*G0_2_1 + 0.042328042328042*G0_2_2;
    A[26] = -0.0183421516754849*G0_0_0 - 0.0253968253968252*G0_0_1 - 0.0253968253968254*G0_0_2 - 0.018342151675485*G0_1_0 - 0.0253968253968252*G0_1_1 - 0.0253968253968254*G0_1_2 - 0.018342151675485*G0_2_0 - 0.0253968253968252*G0_2_1 - 0.0253968253968254*G0_2_2;
    A[27] = -0.0183421516754852*G0_0_0 - 0.0253968253968253*G0_0_1 - 0.0253968253968252*G0_0_2 - 0.0183421516754852*G0_1_0 - 0.0253968253968253*G0_1_1 - 0.0253968253968252*G0_1_2 - 0.0183421516754852*G0_2_0 - 0.0253968253968253*G0_2_1 - 0.0253968253968252*G0_2_2;
    A[28] = 0.042328042328042*G0_0_0 + 0.0493827160493825*G0_0_1 + 0.0423280423280422*G0_0_2 + 0.042328042328042*G0_1_0 + 0.0493827160493826*G0_1_1 + 0.0423280423280422*G0_1_2 + 0.042328042328042*G0_2_0 + 0.0493827160493825*G0_2_1 + 0.0423280423280421*G0_2_2;
    A[29] = -0.0253968253968251*G0_0_0 - 0.0183421516754849*G0_0_1 - 0.0253968253968253*G0_0_2 - 0.0253968253968251*G0_1_0 - 0.0183421516754848*G0_1_1 - 0.0253968253968253*G0_1_2 - 0.0253968253968251*G0_2_0 - 0.0183421516754849*G0_2_1 - 0.0253968253968254*G0_2_2;
    A[30] = -0.0253968253968253*G0_0_0 - 0.0183421516754853*G0_0_1 - 0.0253968253968253*G0_0_2 - 0.0253968253968253*G0_1_0 - 0.0183421516754853*G0_1_1 - 0.0253968253968253*G0_1_2 - 0.0253968253968253*G0_2_0 - 0.0183421516754853*G0_2_1 - 0.0253968253968252*G0_2_2;
    A[31] = 0.0423280423280421*G0_0_0 + 0.0423280423280422*G0_0_1 + 0.0493827160493826*G0_0_2 + 0.0423280423280421*G0_1_0 + 0.0423280423280422*G0_1_1 + 0.0493827160493826*G0_1_2 + 0.0423280423280421*G0_2_0 + 0.0423280423280422*G0_2_1 + 0.0493827160493826*G0_2_2;
    A[32] = -0.0253968253968252*G0_0_0 - 0.0253968253968253*G0_0_1 - 0.0183421516754849*G0_0_2 - 0.0253968253968252*G0_1_0 - 0.0253968253968254*G0_1_1 - 0.0183421516754849*G0_1_2 - 0.0253968253968252*G0_2_0 - 0.0253968253968253*G0_2_1 - 0.0183421516754848*G0_2_2;
    A[33] = -0.0253968253968253*G0_0_0 - 0.0253968253968253*G0_0_1 - 0.0183421516754849*G0_0_2 - 0.0253968253968253*G0_1_0 - 0.0253968253968252*G0_1_1 - 0.018342151675485*G0_1_2 - 0.0253968253968253*G0_2_0 - 0.0253968253968253*G0_2_1 - 0.0183421516754849*G0_2_2;
    A[34] = -0.0677248677248679*G0_0_0 - 0.0677248677248678*G0_0_1 - 0.067724867724868*G0_0_2 - 0.0677248677248678*G0_1_0 - 0.0677248677248679*G0_1_1 - 0.067724867724868*G0_1_2 - 0.0677248677248678*G0_2_0 - 0.0677248677248678*G0_2_1 - 0.0677248677248681*G0_2_2;
    A[35] = 0.00511463844797185*G0_0_0 + 0.00511463844797184*G0_0_1 + 0.00511463844797185*G0_0_2;
    A[36] = 0.0379188712522048*G0_0_0;
    A[37] = -0.0051146384479718*G0_0_1;
    A[38] = -0.00511463844797184*G0_0_2;
    A[39] = -0.00776014109347447*G0_0_1 - 0.00776014109347444*G0_0_2;
    A[40] = -0.00511463844797174*G0_0_1 - 0.00511463844797182*G0_0_2;
    A[41] = -0.00776014109347443*G0_0_1 - 0.00776014109347433*G0_0_2;
    A[42] = -0.0246913580246914*G0_0_0 + 0.0458553791887129*G0_0_2;
    A[43] = 0.0202821869488536*G0_0_0 - 0.0326278659611997*G0_0_2;
    A[44] = -0.00776014109347442*G0_0_0 + 0.0176366843033512*G0_0_2;
    A[45] = -0.0246913580246913*G0_0_0 + 0.0458553791887129*G0_0_1;
    A[46] = 0.0202821869488536*G0_0_0 - 0.0326278659611995*G0_0_1;
    A[47] = -0.00776014109347445*G0_0_0 + 0.017636684303351*G0_0_1;
    A[48] = 0.0077601410934745*G0_0_0 + 0.00776014109347449*G0_0_1;
    A[49] = 0.00511463844797171*G0_0_0 + 0.0051146384479717*G0_0_1;
    A[50] = 0.00776014109347442*G0_0_0 + 0.00776014109347442*G0_0_1;
    A[51] = 0.00776014109347446*G0_0_0 + 0.00776014109347445*G0_0_2;
    A[52] = 0.00511463844797175*G0_0_0 + 0.00511463844797175*G0_0_2;
    A[53] = 0.00776014109347445*G0_0_0 + 0.00776014109347447*G0_0_2;
    A[54] = -0.0253968253968256*G0_0_0 - 0.017636684303351*G0_0_1 - 0.017636684303351*G0_0_2;
    A[55] = 0.0529100529100531*G0_0_0 + 0.0326278659611996*G0_0_1 + 0.0326278659611995*G0_0_2;
    A[56] = -0.0705467372134042*G0_0_0 - 0.0458553791887129*G0_0_1 - 0.0458553791887129*G0_0_2;
    A[57] = 0.0493827160493828*G0_0_0 + 0.00705467372134029*G0_0_1 + 0.0070546737213405*G0_0_2;
    A[58] = -0.0183421516754851*G0_0_0 + 0.00705467372134041*G0_0_1 + 0.00705467372134037*G0_0_2;
    A[59] = -0.0183421516754848*G0_0_0 + 0.00705467372134061*G0_0_1 + 0.00705467372134052*G0_0_2;
    A[60] = 0.018342151675485*G0_0_0;
    A[61] = 0.0183421516754851*G0_0_0;
    A[62] = 0.0183421516754848*G0_0_0;
    A[63] = -0.0253968253968255*G0_0_0 - 0.00705467372134048*G0_0_1;
    A[64] = 0.0423280423280424*G0_0_0 - 0.00705467372134026*G0_0_1;
    A[65] = -0.0253968253968254*G0_0_0 - 0.00705467372134063*G0_0_1;
    A[66] = -0.0253968253968254*G0_0_0 - 0.00705467372134037*G0_0_2;
    A[67] = 0.0423280423280422*G0_0_0 - 0.00705467372134043*G0_0_2;
    A[68] = -0.0253968253968254*G0_0_0 - 0.00705467372134036*G0_0_2;
    A[69] = -0.0677248677248677*G0_0_0;
    A[70] = 0.00511463844797184*G0_1_0 + 0.00511463844797184*G0_1_1 + 0.00511463844797184*G0_1_2;
    A[71] = -0.00511463844797179*G0_1_0;
    A[72] = 0.0379188712522048*G0_1_1;
    A[73] = -0.00511463844797181*G0_1_2;
    A[74] = -0.0246913580246914*G0_1_1 + 0.0458553791887129*G0_1_2;
    A[75] = 0.0202821869488536*G0_1_1 - 0.0326278659611996*G0_1_2;
    A[76] = -0.00776014109347458*G0_1_1 + 0.0176366843033509*G0_1_2;
    A[77] = -0.00776014109347446*G0_1_0 - 0.00776014109347441*G0_1_2;
    A[78] = -0.00511463844797169*G0_1_0 - 0.00511463844797175*G0_1_2;
    A[79] = -0.00776014109347458*G0_1_0 - 0.00776014109347452*G0_1_2;
    A[80] = 0.0176366843033511*G0_1_0 - 0.00776014109347443*G0_1_1;
    A[81] = -0.0326278659611996*G0_1_0 + 0.0202821869488536*G0_1_1;
    A[82] = 0.0458553791887128*G0_1_0 - 0.0246913580246914*G0_1_1;
    A[83] = 0.00776014109347445*G0_1_0 + 0.00776014109347444*G0_1_1;
    A[84] = 0.00511463844797169*G0_1_0 + 0.00511463844797171*G0_1_1;
    A[85] = 0.00776014109347457*G0_1_0 + 0.00776014109347458*G0_1_1;
    A[86] = -0.017636684303351*G0_1_0 - 0.0253968253968256*G0_1_1 - 0.017636684303351*G0_1_2;
    A[87] = 0.0326278659611995*G0_1_0 + 0.0529100529100532*G0_1_1 + 0.0326278659611995*G0_1_2;
    A[88] = -0.0458553791887129*G0_1_0 - 0.0705467372134042*G0_1_1 - 0.0458553791887129*G0_1_2;
    A[89] = 0.00776014109347447*G0_1_1 + 0.00776014109347447*G0_1_2;
    A[90] = 0.0051146384479718*G0_1_1 + 0.0051146384479718*G0_1_2;
    A[91] = 0.00776014109347443*G0_1_1 + 0.00776014109347443*G0_1_2;
    A[92] = 0.00705467372134048*G0_1_0 - 0.0183421516754849*G0_1_1 + 0.00705467372134043*G0_1_2;
    A[93] = 0.00705467372134035*G0_1_0 + 0.0493827160493827*G0_1_1 + 0.00705467372134039*G0_1_2;
    A[94] = 0.00705467372134015*G0_1_0 - 0.0183421516754851*G0_1_1 + 0.00705467372134029*G0_1_2;
    A[95] = -0.0070546737213406*G0_1_0 - 0.0253968253968254*G0_1_1;
    A[96] = -0.00705467372134032*G0_1_0 + 0.0423280423280423*G0_1_1;
    A[97] = -0.00705467372134016*G0_1_0 - 0.0253968253968253*G0_1_1;
    A[98] = 0.0183421516754848*G0_1_1;
    A[99] = 0.0183421516754849*G0_1_1;
    A[100] = 0.0183421516754851*G0_1_1;
    A[101] = -0.0253968253968254*G0_1_1 - 0.00705467372134047*G0_1_2;
    A[102] = -0.0253968253968254*G0_1_1 - 0.00705467372134051*G0_1_2;
    A[103] = 0.0423280423280423*G0_1_1 - 0.00705467372134034*G0_1_2;
    A[104] = -0.0677248677248675*G0_1_1;
    A[105] = 0.00511463844797178*G0_2_0 + 0.00511463844797179*G0_2_1 + 0.00511463844797181*G0_2_2;
    A[106] = -0.00511463844797184*G0_2_0;
    A[107] = -0.00511463844797181*G0_2_1;
    A[108] = 0.0379188712522048*G0_2_2;
    A[109] = 0.0176366843033511*G0_2_1 - 0.00776014109347449*G0_2_2;
    A[110] = -0.0326278659611996*G0_2_1 + 0.0202821869488537*G0_2_2;
    A[111] = 0.045855379188713*G0_2_1 - 0.0246913580246914*G0_2_2;
    A[112] = 0.0176366843033511*G0_2_0 - 0.00776014109347452*G0_2_2;
    A[113] = -0.0326278659611996*G0_2_0 + 0.0202821869488537*G0_2_2;
    A[114] = 0.045855379188713*G0_2_0 - 0.0246913580246915*G0_2_2;
    A[115] = -0.00776014109347448*G0_2_0 - 0.00776014109347453*G0_2_1;
    A[116] = -0.00511463844797174*G0_2_0 - 0.00511463844797171*G0_2_1;
    A[117] = -0.00776014109347446*G0_2_0 - 0.00776014109347445*G0_2_1;
    A[118] = -0.0176366843033511*G0_2_0 - 0.0176366843033511*G0_2_1 - 0.0253968253968255*G0_2_2;
    A[119] = 0.0326278659611996*G0_2_0 + 0.0326278659611997*G0_2_1 + 0.0529100529100532*G0_2_2;
    A[120] = -0.045855379188713*G0_2_0 - 0.045855379188713*G0_2_1 - 0.0705467372134043*G0_2_2;
    A[121] = 0.00776014109347442*G0_2_0 + 0.0077601410934744*G0_2_2;
    A[122] = 0.00511463844797173*G0_2_0 + 0.00511463844797174*G0_2_2;
    A[123] = 0.00776014109347446*G0_2_0 + 0.00776014109347446*G0_2_2;
    A[124] = 0.0077601410934744*G0_2_1 + 0.0077601410934744*G0_2_2;
    A[125] = 0.00511463844797174*G0_2_1 + 0.00511463844797175*G0_2_2;
    A[126] = 0.00776014109347453*G0_2_1 + 0.00776014109347454*G0_2_2;
    A[127] = 0.00705467372134042*G0_2_0 + 0.00705467372134034*G0_2_1 - 0.0183421516754851*G0_2_2;
    A[128] = 0.00705467372134039*G0_2_0 + 0.00705467372134051*G0_2_1 - 0.0183421516754849*G0_2_2;
    A[129] = 0.00705467372134039*G0_2_0 + 0.00705467372134029*G0_2_1 + 0.0493827160493827*G0_2_2;
    A[130] = -0.00705467372134034*G0_2_0 - 0.0253968253968253*G0_2_2;
    A[131] = -0.00705467372134041*G0_2_0 - 0.0253968253968254*G0_2_2;
    A[132] = -0.00705467372134039*G0_2_0 + 0.0423280423280422*G0_2_2;
    A[133] = -0.00705467372134036*G0_2_1 - 0.0253968253968253*G0_2_2;
    A[134] = -0.00705467372134038*G0_2_1 - 0.0253968253968254*G0_2_2;
    A[135] = -0.00705467372134029*G0_2_1 + 0.0423280423280423*G0_2_2;
    A[136] = 0.018342151675485*G0_2_2;
    A[137] = 0.0183421516754851*G0_2_2;
    A[138] = 0.018342151675485*G0_2_2;
    A[139] = -0.0677248677248676*G0_2_2;
    A[140] = 0.00776014109347431*G0_1_0 + 0.00776014109347433*G0_1_1 + 0.00776014109347432*G0_1_2 + 0.00776014109347443*G0_2_0 + 0.00776014109347443*G0_2_1 + 0.00776014109347443*G0_2_2;
    A[141] = -0.00776014109347447*G0_1_0 - 0.00776014109347444*G0_2_0;
    A[142] = -0.0246913580246914*G0_1_1 + 0.0458553791887129*G0_2_1;
    A[143] = 0.0176366843033511*G0_1_2 - 0.00776014109347449*G0_2_2;
    A[144] = 0.203174603174603*G0_1_1 + 0.0790123456790126*G0_1_2 + 0.0790123456790126*G0_2_1 + 0.158024691358026*G0_2_2;
    A[145] = -0.118518518518519*G0_1_1 + 0.0423280423280421*G0_1_2 - 0.0310405643738979*G0_2_1 - 0.0902998236331577*G0_2_2;
    A[146] = 0.0451499118165789*G0_1_1 - 0.0338624338624336*G0_1_2 + 0.0112874779541446*G0_2_1 + 0.0451499118165786*G0_2_2;
    A[147] = 0.0225749559082894*G0_1_0 + 0.0112874779541447*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541448*G0_2_2;
    A[148] = 0.0169312169312166*G0_1_0 + 0.0141093474426807*G0_1_2 + 0.00282186948853615*G0_2_0 + 0.00282186948853593*G0_2_2;
    A[149] = 0.0451499118165789*G0_1_0 + 0.033862433862434*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541447*G0_2_2;
    A[150] = 0.0338624338624338*G0_1_0 + 0.0112874779541447*G0_1_1 + 0.0451499118165788*G0_2_0 + 0.0112874779541448*G0_2_1;
    A[151] = -0.0592592592592594*G0_1_0 - 0.0423280423280426*G0_1_1 - 0.0902998236331578*G0_2_0 - 0.031040564373898*G0_2_1;
    A[152] = 0.0790123456790126*G0_1_0 + 0.101587301587302*G0_1_1 + 0.158024691358025*G0_2_0 + 0.0790123456790126*G0_2_1;
    A[153] = -0.0225749559082892*G0_1_0 - 0.0225749559082893*G0_1_1 - 0.0112874779541444*G0_1_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541446*G0_2_1;
    A[154] = -0.0169312169312168*G0_1_0 - 0.0169312169312168*G0_1_1 - 0.00282186948853633*G0_1_2 - 0.00282186948853641*G0_2_0 - 0.00282186948853637*G0_2_1;
    A[155] = -0.0451499118165788*G0_1_0 - 0.0451499118165789*G0_1_1 - 0.0112874779541447*G0_1_2 - 0.0112874779541445*G0_2_0 - 0.0112874779541446*G0_2_1;
    A[156] = -0.0338624338624339*G0_1_0 - 0.022574955908289*G0_1_1 - 0.0338624338624339*G0_1_2 - 0.0451499118165787*G0_2_0 - 0.033862433862434*G0_2_1 - 0.0451499118165787*G0_2_2;
    A[157] = 0.0592592592592594*G0_1_0 + 0.0169312169312167*G0_1_1 + 0.0592592592592594*G0_1_2 + 0.0902998236331577*G0_2_0 + 0.0592592592592596*G0_2_1 + 0.0902998236331577*G0_2_2;
    A[158] = -0.0790123456790126*G0_1_0 + 0.0225749559082893*G0_1_1 - 0.0790123456790126*G0_1_2 - 0.158024691358026*G0_2_0 - 0.079012345679013*G0_2_1 - 0.158024691358026*G0_2_2;
    A[159] = -0.0112874779541448*G0_1_1 - 0.0112874779541448*G0_1_2 - 0.0112874779541447*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[160] = -0.00282186948853621*G0_1_1 - 0.00282186948853615*G0_1_2 - 0.00282186948853615*G0_2_1 - 0.00282186948853608*G0_2_2;
    A[161] = -0.0112874779541446*G0_1_1 - 0.0112874779541446*G0_1_2 - 0.0112874779541447*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[162] = -0.0677248677248677*G0_1_0 + 0.0225749559082892*G0_1_1 - 0.0338624338624341*G0_1_2 - 0.0225749559082894*G0_2_0 + 0.0112874779541446*G0_2_1 - 0.0225749559082894*G0_2_2;
    A[163] = 0.203174603174603*G0_1_0 - 0.0677248677248675*G0_1_1 + 0.101587301587302*G0_1_2 + 0.112874779541446*G0_2_0 + 0.0112874779541444*G0_2_1 + 0.112874779541446*G0_2_2;
    A[164] = -0.0677248677248675*G0_1_0 + 0.0677248677248678*G0_1_1 - 0.0338624338624338*G0_1_2 - 0.0225749559082896*G0_2_0 + 0.0112874779541444*G0_2_1 - 0.0225749559082895*G0_2_2;
    A[165] = 0.0677248677248676*G0_1_0 + 0.0902998236331568*G0_1_1 + 0.0338624338624338*G0_1_2 + 0.0225749559082888*G0_2_0 + 0.0338624338624339*G0_2_1;
    A[166] = -0.203174603174603*G0_1_0 - 0.270899470899471*G0_1_1 - 0.101587301587302*G0_1_2 - 0.112874779541446*G0_2_0 - 0.101587301587302*G0_2_1;
    A[167] = 0.0677248677248677*G0_1_0 + 0.135449735449736*G0_1_1 + 0.0338624338624338*G0_1_2 + 0.0225749559082897*G0_2_0 + 0.0338624338624343*G0_2_1;
    A[168] = -0.0225749559082893*G0_1_1 - 0.0112874779541444*G0_1_2 - 0.0112874779541452*G0_2_1;
    A[169] = -0.0225749559082893*G0_1_1 - 0.0112874779541447*G0_1_2 - 0.0112874779541447*G0_2_1;
    A[170] = -0.0677248677248678*G0_1_1 - 0.0112874779541447*G0_1_2 - 0.0112874779541445*G0_2_1;
    A[171] = 0.0451499118165788*G0_1_1 + 0.0338624338624339*G0_1_2 + 0.0338624338624341*G0_2_1 + 0.022574955908289*G0_2_2;
    A[172] = 0.0451499118165786*G0_1_1 + 0.0338624338624339*G0_1_2 + 0.0338624338624339*G0_2_1 + 0.022574955908289*G0_2_2;
    A[173] = -0.135449735449736*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1 - 0.112874779541446*G0_2_2;
    A[174] = 0.0902998236331569*G0_1_1;
    A[175] = 0.00511463844797182*G0_1_0 + 0.00511463844797182*G0_1_1 + 0.00511463844797184*G0_1_2 + 0.00511463844797174*G0_2_0 + 0.00511463844797177*G0_2_1 + 0.00511463844797177*G0_2_2;
    A[176] = -0.00511463844797175*G0_1_0 - 0.00511463844797182*G0_2_0;
    A[177] = 0.0202821869488536*G0_1_1 - 0.0326278659611996*G0_2_1;
    A[178] = -0.0326278659611996*G0_1_2 + 0.0202821869488537*G0_2_2;
    A[179] = -0.118518518518519*G0_1_1 - 0.0310405643738979*G0_1_2 + 0.0423280423280421*G0_2_1 - 0.0902998236331577*G0_2_2;
    A[180] = 0.249735449735451*G0_1_1 + 0.0825396825396829*G0_1_2 + 0.0825396825396829*G0_2_1 + 0.249735449735451*G0_2_2;
    A[181] = -0.0902998236331578*G0_1_1 + 0.0423280423280421*G0_1_2 - 0.0310405643738977*G0_2_1 - 0.118518518518519*G0_2_2;
    A[182] = 0.0169312169312167*G0_1_0 + 0.00282186948853615*G0_1_2 + 0.0141093474426809*G0_2_0 + 0.00282186948853596*G0_2_2;
    A[183] = -0.0211640211640206*G0_1_0 - 0.0105820105820106*G0_1_2 - 0.0105820105820106*G0_2_0 - 0.0134038800705465*G0_2_2;
    A[184] = -0.0902998236331577*G0_1_0 - 0.0592592592592593*G0_1_2 - 0.0310405643738977*G0_2_0 - 0.0423280423280424*G0_2_2;
    A[185] = 0.0141093474426808*G0_1_0 + 0.00282186948853617*G0_1_1 + 0.0169312169312166*G0_2_0 + 0.002821869488536*G0_2_1;
    A[186] = -0.0105820105820105*G0_1_0 - 0.0134038800705467*G0_1_1 - 0.0211640211640206*G0_2_0 - 0.0105820105820105*G0_2_1;
    A[187] = -0.031040564373898*G0_1_0 - 0.0423280423280424*G0_1_1 - 0.0902998236331577*G0_2_0 - 0.0592592592592593*G0_2_1;
    A[188] = -0.0169312169312169*G0_1_0 - 0.0169312169312169*G0_1_1 - 0.0141093474426809*G0_1_2 - 0.0141093474426808*G0_2_0 - 0.0141093474426809*G0_2_1 - 0.0112874779541446*G0_2_2;
    A[189] = 0.0211640211640209*G0_1_0 + 0.0211640211640209*G0_1_1 + 0.0105820105820105*G0_1_2 + 0.0105820105820109*G0_2_0 + 0.010582010582011*G0_2_1 - 0.00282186948853612*G0_2_2;
    A[190] = 0.0902998236331577*G0_1_0 + 0.0902998236331578*G0_1_1 + 0.0310405643738981*G0_1_2 + 0.0310405643738977*G0_2_0 + 0.0310405643738977*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[191] = -0.0141093474426808*G0_1_0 - 0.0112874779541447*G0_1_1 - 0.0141093474426808*G0_1_2 - 0.0169312169312168*G0_2_0 - 0.0141093474426806*G0_2_1 - 0.0169312169312168*G0_2_2;
    A[192] = 0.0105820105820105*G0_1_0 - 0.0028218694885361*G0_1_1 + 0.0105820105820105*G0_1_2 + 0.0211640211640205*G0_2_0 + 0.0105820105820101*G0_2_1 + 0.0211640211640206*G0_2_2;
    A[193] = 0.0310405643738979*G0_1_0 - 0.0112874779541446*G0_1_1 + 0.0310405643738979*G0_1_2 + 0.0902998236331577*G0_2_0 + 0.0310405643738983*G0_2_1 + 0.0902998236331577*G0_2_2;
    A[194] = -0.00282186948853615*G0_1_1 - 0.00282186948853612*G0_1_2 - 0.00282186948853622*G0_2_1 - 0.00282186948853618*G0_2_2;
    A[195] = -0.00917107583774254*G0_1_1 - 0.00917107583774254*G0_1_2 - 0.00917107583774259*G0_2_1 - 0.00917107583774262*G0_2_2;
    A[196] = -0.00282186948853617*G0_1_1 - 0.0028218694885362*G0_1_2 - 0.002821869488536*G0_2_1 - 0.00282186948853601*G0_2_2;
    A[197] = -0.0846560846560849*G0_1_0 - 0.0169312169312168*G0_1_1 - 0.019753086419753*G0_1_2 - 0.0846560846560847*G0_2_0 - 0.019753086419753*G0_2_1 - 0.016931216931217*G0_2_2;
    A[198] = 0.050793650793651*G0_1_0 + 0.118518518518518*G0_1_1 - 0.0423280423280426*G0_1_2 + 0.186243386243387*G0_2_0 + 0.0931216931216937*G0_2_1 - 0.0846560846560845*G0_2_2;
    A[199] = 0.186243386243386*G0_1_0 - 0.0846560846560847*G0_1_1 + 0.0931216931216931*G0_1_2 + 0.0507936507936512*G0_2_0 - 0.0423280423280424*G0_2_1 + 0.118518518518519*G0_2_2;
    A[200] = 0.0846560846560849*G0_1_0 + 0.0677248677248681*G0_1_1 + 0.0649029982363317*G0_1_2 + 0.0846560846560853*G0_2_0 + 0.0649029982363317*G0_2_1 + 0.0677248677248682*G0_2_2;
    A[201] = -0.050793650793651*G0_1_0 + 0.0677248677248675*G0_1_1 - 0.0931216931216935*G0_1_2 - 0.186243386243387*G0_2_0 - 0.093121693121693*G0_2_1 - 0.270899470899471*G0_2_2;
    A[202] = -0.186243386243386*G0_1_0 - 0.270899470899471*G0_1_1 - 0.093121693121693*G0_1_2 - 0.0507936507936511*G0_2_0 - 0.0931216931216939*G0_2_1 + 0.0677248677248673*G0_2_2;
    A[203] = 0.0169312169312173*G0_1_1 + 0.0197530864197532*G0_1_2 + 0.0197530864197541*G0_2_1 + 0.02257495590829*G0_2_2;
    A[204] = 0.0169312169312169*G0_1_1 + 0.0197530864197532*G0_1_2 + 0.019753086419753*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[205] = 0.0846560846560847*G0_1_1 + 0.0423280423280422*G0_1_2 + 0.0423280423280424*G0_2_1 + 0.0225749559082886*G0_2_2;
    A[206] = 0.0225749559082893*G0_1_1 + 0.0197530864197532*G0_1_2 + 0.0197530864197531*G0_2_1 + 0.0169312169312173*G0_2_2;
    A[207] = 0.0225749559082893*G0_1_1 + 0.0197530864197531*G0_1_2 + 0.0197530864197531*G0_2_1 + 0.0169312169312171*G0_2_2;
    A[208] = 0.0225749559082892*G0_1_1 + 0.0423280423280424*G0_1_2 + 0.0423280423280425*G0_2_1 + 0.0846560846560843*G0_2_2;
    A[209] = -0.135449735449736*G0_1_1 - 0.112874779541446*G0_1_2 - 0.112874779541448*G0_2_1 - 0.135449735449736*G0_2_2;
    A[210] = 0.00776014109347439*G0_1_0 + 0.00776014109347441*G0_1_1 + 0.00776014109347439*G0_1_2 + 0.00776014109347442*G0_2_0 + 0.00776014109347441*G0_2_1 + 0.00776014109347438*G0_2_2;
    A[211] = -0.00776014109347443*G0_1_0 - 0.00776014109347433*G0_2_0;
    A[212] = -0.00776014109347458*G0_1_1 + 0.0176366843033509*G0_2_1;
    A[213] = 0.045855379188713*G0_1_2 - 0.0246913580246914*G0_2_2;
    A[214] = 0.0451499118165789*G0_1_1 + 0.0112874779541446*G0_1_2 - 0.0338624338624337*G0_2_1 + 0.0451499118165786*G0_2_2;
    A[215] = -0.0902998236331578*G0_1_1 - 0.0310405643738977*G0_1_2 + 0.0423280423280421*G0_2_1 - 0.118518518518519*G0_2_2;
    A[216] = 0.158024691358026*G0_1_1 + 0.0790123456790127*G0_1_2 + 0.0790123456790127*G0_2_1 + 0.203174603174603*G0_2_2;
    A[217] = 0.0451499118165789*G0_1_0 + 0.0112874779541448*G0_1_2 + 0.033862433862434*G0_2_0 + 0.011287477954145*G0_2_2;
    A[218] = -0.0902998236331579*G0_1_0 - 0.031040564373898*G0_1_2 - 0.0592592592592595*G0_2_0 - 0.0423280423280428*G0_2_2;
    A[219] = 0.158024691358026*G0_1_0 + 0.0790123456790127*G0_1_2 + 0.0790123456790127*G0_2_0 + 0.101587301587302*G0_2_2;
    A[220] = 0.0112874779541447*G0_1_0 + 0.0112874779541448*G0_1_1 + 0.0225749559082894*G0_2_0 + 0.0112874779541449*G0_2_1;
    A[221] = 0.00282186948853624*G0_1_0 + 0.00282186948853603*G0_1_1 + 0.0169312169312168*G0_2_0 + 0.0141093474426806*G0_2_1;
    A[222] = 0.0112874779541446*G0_1_0 + 0.0112874779541448*G0_1_1 + 0.0451499118165785*G0_2_0 + 0.033862433862434*G0_2_1;
    A[223] = -0.0451499118165788*G0_1_0 - 0.0451499118165788*G0_1_1 - 0.0338624338624338*G0_1_2 - 0.033862433862434*G0_2_0 - 0.0338624338624339*G0_2_1 - 0.0225749559082891*G0_2_2;
    A[224] = 0.0902998236331578*G0_1_0 + 0.090299823633158*G0_1_1 + 0.0592592592592595*G0_1_2 + 0.0592592592592594*G0_2_0 + 0.0592592592592595*G0_2_1 + 0.0169312169312168*G0_2_2;
    A[225] = -0.158024691358026*G0_1_0 - 0.158024691358026*G0_1_1 - 0.079012345679013*G0_1_2 - 0.0790123456790127*G0_2_0 - 0.0790123456790127*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[226] = -0.0112874779541448*G0_1_0 - 0.0112874779541447*G0_1_2 - 0.0225749559082894*G0_2_0 - 0.0112874779541446*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[227] = -0.00282186948853619*G0_1_0 - 0.00282186948853617*G0_1_2 - 0.0169312169312168*G0_2_0 - 0.00282186948853612*G0_2_1 - 0.0169312169312168*G0_2_2;
    A[228] = -0.0112874779541446*G0_1_0 - 0.0112874779541446*G0_1_2 - 0.0451499118165786*G0_2_0 - 0.0112874779541446*G0_2_1 - 0.0451499118165786*G0_2_2;
    A[229] = -0.0112874779541449*G0_1_1 - 0.0112874779541449*G0_1_2 - 0.0112874779541448*G0_2_1 - 0.0112874779541448*G0_2_2;
    A[230] = -0.00282186948853618*G0_1_1 - 0.0028218694885362*G0_1_2 - 0.00282186948853617*G0_2_1 - 0.00282186948853618*G0_2_2;
    A[231] = -0.0112874779541448*G0_1_1 - 0.0112874779541448*G0_1_2 - 0.0112874779541449*G0_2_1 - 0.0112874779541449*G0_2_2;
    A[232] = -0.0225749559082894*G0_1_0 - 0.0225749559082893*G0_1_1 + 0.0112874779541447*G0_1_2 - 0.067724867724868*G0_2_0 - 0.0338624338624339*G0_2_1 + 0.0225749559082895*G0_2_2;
    A[233] = -0.022574955908289*G0_1_0 - 0.0225749559082891*G0_1_1 + 0.011287477954145*G0_1_2 - 0.0677248677248676*G0_2_0 - 0.0338624338624341*G0_2_1 + 0.0677248677248678*G0_2_2;
    A[234] = 0.112874779541446*G0_1_0 + 0.112874779541446*G0_1_1 + 0.0112874779541445*G0_1_2 + 0.203174603174603*G0_2_0 + 0.101587301587302*G0_2_1 - 0.0677248677248681*G0_2_2;
    A[235] = 0.0225749559082896*G0_1_0 + 0.0338624338624344*G0_1_2 + 0.0677248677248677*G0_2_0 + 0.0338624338624339*G0_2_1 + 0.0902998236331572*G0_2_2;
    A[236] = 0.022574955908289*G0_1_0 + 0.0338624338624339*G0_1_2 + 0.0677248677248676*G0_2_0 + 0.0338624338624337*G0_2_1 + 0.135449735449735*G0_2_2;
    A[237] = -0.112874779541446*G0_1_0 - 0.101587301587302*G0_1_2 - 0.203174603174603*G0_2_0 - 0.101587301587301*G0_2_1 - 0.270899470899471*G0_2_2;
    A[238] = 0.0225749559082895*G0_1_1 + 0.0338624338624345*G0_1_2 + 0.0338624338624337*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[239] = 0.0225749559082892*G0_1_1 + 0.0338624338624341*G0_1_2 + 0.0338624338624338*G0_2_1 + 0.0451499118165789*G0_2_2;
    A[240] = -0.112874779541446*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1 - 0.135449735449736*G0_2_2;
    A[241] = -0.0112874779541448*G0_1_2 - 0.0112874779541446*G0_2_1 - 0.0225749559082896*G0_2_2;
    A[242] = -0.0112874779541449*G0_1_2 - 0.0112874779541445*G0_2_1 - 0.0225749559082897*G0_2_2;
    A[243] = -0.0112874779541449*G0_1_2 - 0.0112874779541447*G0_2_1 - 0.0677248677248677*G0_2_2;
    A[244] = 0.0902998236331576*G0_2_2;
    A[245] = 0.00776014109347427*G0_0_0 + 0.0077601410934743*G0_0_1 + 0.00776014109347429*G0_0_2 + 0.00776014109347443*G0_2_0 + 0.00776014109347443*G0_2_1 + 0.00776014109347443*G0_2_2;
    A[246] = -0.0246913580246914*G0_0_0 + 0.0458553791887129*G0_2_0;
    A[247] = -0.00776014109347446*G0_0_1 - 0.00776014109347441*G0_2_1;
    A[248] = 0.0176366843033511*G0_0_2 - 0.00776014109347452*G0_2_2;
    A[249] = 0.0225749559082894*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.0112874779541447*G0_2_1 + 0.0112874779541448*G0_2_2;
    A[250] = 0.0169312169312167*G0_0_1 + 0.0141093474426809*G0_0_2 + 0.00282186948853615*G0_2_1 + 0.00282186948853596*G0_2_2;
    A[251] = 0.0451499118165789*G0_0_1 + 0.033862433862434*G0_0_2 + 0.0112874779541448*G0_2_1 + 0.011287477954145*G0_2_2;
    A[252] = 0.203174603174603*G0_0_0 + 0.0790123456790124*G0_0_2 + 0.0790123456790124*G0_2_0 + 0.158024691358026*G0_2_2;
    A[253] = -0.118518518518519*G0_0_0 + 0.0423280423280422*G0_0_2 - 0.0310405643738979*G0_2_0 - 0.0902998236331578*G0_2_2;
    A[254] = 0.0451499118165789*G0_0_0 - 0.0338624338624337*G0_0_2 + 0.0112874779541448*G0_2_0 + 0.045149911816579*G0_2_2;
    A[255] = 0.101587301587302*G0_0_0 + 0.0790123456790125*G0_0_1 + 0.0790123456790126*G0_2_0 + 0.158024691358026*G0_2_1;
    A[256] = -0.0423280423280425*G0_0_0 - 0.0592592592592595*G0_0_1 - 0.0310405643738979*G0_2_0 - 0.0902998236331577*G0_2_1;
    A[257] = 0.0112874779541446*G0_0_0 + 0.033862433862434*G0_0_1 + 0.0112874779541448*G0_2_0 + 0.0451499118165788*G0_2_1;
    A[258] = -0.0225749559082893*G0_0_0 - 0.0225749559082893*G0_0_1 - 0.0112874779541443*G0_0_2 - 0.0112874779541445*G0_2_0 - 0.0112874779541445*G0_2_1;
    A[259] = -0.0169312169312165*G0_0_0 - 0.0169312169312164*G0_0_1 - 0.00282186948853633*G0_0_2 - 0.00282186948853623*G0_2_0 - 0.00282186948853618*G0_2_1;
    A[260] = -0.0451499118165789*G0_0_0 - 0.0451499118165789*G0_0_1 - 0.0112874779541447*G0_0_2 - 0.0112874779541448*G0_2_0 - 0.0112874779541448*G0_2_1;
    A[261] = -0.0112874779541447*G0_0_0 - 0.0112874779541446*G0_0_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541446*G0_2_2;
    A[262] = -0.00282186948853622*G0_0_0 - 0.00282186948853616*G0_0_2 - 0.00282186948853608*G0_2_0 - 0.00282186948853603*G0_2_2;
    A[263] = -0.0112874779541446*G0_0_0 - 0.0112874779541447*G0_0_2 - 0.0112874779541448*G0_2_0 - 0.0112874779541448*G0_2_2;
    A[264] = -0.022574955908289*G0_0_0 - 0.033862433862434*G0_0_1 - 0.0338624338624339*G0_0_2 - 0.0338624338624339*G0_2_0 - 0.0451499118165786*G0_2_1 - 0.0451499118165786*G0_2_2;
    A[265] = 0.0169312169312167*G0_0_0 + 0.059259259259259*G0_0_1 + 0.059259259259259*G0_0_2 + 0.0592592592592595*G0_2_0 + 0.0902998236331574*G0_2_1 + 0.0902998236331573*G0_2_2;
    A[266] = 0.0225749559082893*G0_0_0 - 0.0790123456790124*G0_0_1 - 0.0790123456790124*G0_0_2 - 0.0790123456790129*G0_2_0 - 0.158024691358026*G0_2_1 - 0.158024691358026*G0_2_2;
    A[267] = -0.0677248677248682*G0_0_0 + 0.203174603174603*G0_0_1 + 0.101587301587301*G0_0_2 + 0.0112874779541444*G0_2_0 + 0.112874779541446*G0_2_1 + 0.112874779541446*G0_2_2;
    A[268] = 0.0225749559082894*G0_0_0 - 0.0677248677248678*G0_0_1 - 0.0338624338624338*G0_0_2 + 0.0112874779541446*G0_2_0 - 0.0225749559082894*G0_2_1 - 0.0225749559082892*G0_2_2;
    A[269] = 0.0677248677248677*G0_0_0 - 0.067724867724868*G0_0_1 - 0.0338624338624342*G0_0_2 + 0.0112874779541451*G0_2_0 - 0.022574955908289*G0_2_1 - 0.0225749559082892*G0_2_2;
    A[270] = -0.0225749559082891*G0_0_0 - 0.0112874779541443*G0_0_2 - 0.0112874779541447*G0_2_0;
    A[271] = -0.0225749559082895*G0_0_0 - 0.0112874779541447*G0_0_2 - 0.0112874779541447*G0_2_0;
    A[272] = -0.0677248677248676*G0_0_0 - 0.0112874779541451*G0_0_2 - 0.011287477954145*G0_2_0;
    A[273] = 0.0902998236331567*G0_0_0 + 0.0677248677248678*G0_0_1 + 0.0338624338624342*G0_0_2 + 0.0338624338624336*G0_2_0 + 0.022574955908289*G0_2_1;
    A[274] = -0.270899470899471*G0_0_0 - 0.203174603174603*G0_0_1 - 0.101587301587301*G0_0_2 - 0.101587301587302*G0_2_0 - 0.112874779541446*G0_2_1;
    A[275] = 0.135449735449736*G0_0_0 + 0.067724867724868*G0_0_1 + 0.0338624338624335*G0_0_2 + 0.0338624338624342*G0_2_0 + 0.022574955908289*G0_2_1;
    A[276] = 0.0451499118165784*G0_0_0 + 0.0338624338624337*G0_0_2 + 0.0338624338624338*G0_2_0 + 0.0225749559082892*G0_2_2;
    A[277] = -0.135449735449735*G0_0_0 - 0.101587301587301*G0_0_2 - 0.101587301587302*G0_2_0 - 0.112874779541446*G0_2_2;
    A[278] = 0.0451499118165786*G0_0_0 + 0.0338624338624338*G0_0_2 + 0.033862433862434*G0_2_0 + 0.0225749559082893*G0_2_2;
    A[279] = 0.0902998236331571*G0_0_0;
    A[280] = 0.00511463844797186*G0_0_0 + 0.00511463844797183*G0_0_1 + 0.00511463844797185*G0_0_2 + 0.00511463844797174*G0_2_0 + 0.00511463844797174*G0_2_1 + 0.00511463844797177*G0_2_2;
    A[281] = 0.0202821869488536*G0_0_0 - 0.0326278659611997*G0_2_0;
    A[282] = -0.00511463844797169*G0_0_1 - 0.00511463844797175*G0_2_1;
    A[283] = -0.0326278659611996*G0_0_2 + 0.0202821869488537*G0_2_2;
    A[284] = 0.0169312169312166*G0_0_1 + 0.00282186948853615*G0_0_2 + 0.0141093474426807*G0_2_1 + 0.00282186948853593*G0_2_2;
    A[285] = -0.0211640211640205*G0_0_1 - 0.0105820105820106*G0_0_2 - 0.0105820105820106*G0_2_1 - 0.0134038800705465*G0_2_2;
    A[286] = -0.0902998236331579*G0_0_1 - 0.0592592592592595*G0_0_2 - 0.031040564373898*G0_2_1 - 0.0423280423280428*G0_2_2;
    A[287] = -0.118518518518519*G0_0_0 - 0.0310405643738979*G0_0_2 + 0.0423280423280421*G0_2_0 - 0.0902998236331578*G0_2_2;
    A[288] = 0.249735449735451*G0_0_0 + 0.0825396825396829*G0_0_2 + 0.0825396825396829*G0_2_0 + 0.249735449735451*G0_2_2;
    A[289] = -0.0902998236331578*G0_0_0 + 0.0423280423280422*G0_0_2 - 0.0310405643738979*G0_2_0 - 0.118518518518519*G0_2_2;
    A[290] = -0.0423280423280425*G0_0_0 - 0.0310405643738979*G0_0_1 - 0.0592592592592595*G0_2_0 - 0.0902998236331579*G0_2_1;
    A[291] = -0.0134038800705468*G0_0_0 - 0.0105820105820104*G0_0_1 - 0.0105820105820106*G0_2_0 - 0.0211640211640206*G0_2_1;
    A[292] = 0.00282186948853614*G0_0_0 + 0.0141093474426805*G0_0_1 + 0.00282186948853598*G0_2_0 + 0.0169312169312165*G0_2_1;
    A[293] = -0.0169312169312168*G0_0_0 - 0.0169312169312167*G0_0_1 - 0.0141093474426808*G0_0_2 - 0.014109347442681*G0_2_0 - 0.0141093474426809*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[294] = 0.0211640211640205*G0_0_0 + 0.0211640211640204*G0_0_1 + 0.0105820105820104*G0_0_2 + 0.0105820105820109*G0_2_0 + 0.0105820105820108*G0_2_1 - 0.00282186948853586*G0_2_2;
    A[295] = 0.0902998236331579*G0_0_0 + 0.0902998236331579*G0_0_1 + 0.0310405643738983*G0_0_2 + 0.031040564373898*G0_2_0 + 0.0310405643738979*G0_2_1 - 0.0112874779541449*G0_2_2;
    A[296] = -0.00282186948853615*G0_0_0 - 0.00282186948853623*G0_0_2 - 0.00282186948853634*G0_2_0 - 0.00282186948853637*G0_2_2;
    A[297] = -0.00917107583774225*G0_0_0 - 0.00917107583774232*G0_0_2 - 0.00917107583774249*G0_2_0 - 0.00917107583774253*G0_2_2;
    A[298] = -0.00282186948853616*G0_0_0 - 0.0028218694885361*G0_0_2 - 0.00282186948853598*G0_2_0 - 0.00282186948853597*G0_2_2;
    A[299] = -0.0112874779541448*G0_0_0 - 0.0141093474426807*G0_0_1 - 0.0141093474426808*G0_0_2 - 0.0141093474426807*G0_2_0 - 0.016931216931217*G0_2_1 - 0.016931216931217*G0_2_2;
    A[300] = -0.00282186948853612*G0_0_0 + 0.0105820105820106*G0_0_1 + 0.0105820105820107*G0_0_2 + 0.0105820105820102*G0_2_0 + 0.0211640211640209*G0_2_1 + 0.0211640211640209*G0_2_2;
    A[301] = -0.0112874779541446*G0_0_0 + 0.0310405643738979*G0_0_1 + 0.0310405643738979*G0_0_2 + 0.0310405643738983*G0_2_0 + 0.0902998236331578*G0_2_1 + 0.0902998236331578*G0_2_2;
    A[302] = 0.118518518518519*G0_0_0 + 0.0507936507936509*G0_0_1 - 0.0423280423280424*G0_0_2 + 0.0931216931216933*G0_2_0 + 0.186243386243386*G0_2_1 - 0.084656084656085*G0_2_2;
    A[303] = -0.0169312169312171*G0_0_0 - 0.0846560846560847*G0_0_1 - 0.0197530864197533*G0_0_2 - 0.0197530864197531*G0_2_0 - 0.0846560846560847*G0_2_1 - 0.0169312169312172*G0_2_2;
    A[304] = -0.0846560846560844*G0_0_0 + 0.186243386243387*G0_0_1 + 0.0931216931216938*G0_0_2 - 0.0423280423280429*G0_2_0 + 0.0507936507936505*G0_2_1 + 0.118518518518519*G0_2_2;
    A[305] = 0.0169312169312167*G0_0_0 + 0.0197530864197529*G0_0_2 + 0.0197530864197532*G0_2_0 + 0.0225749559082897*G0_2_2;
    A[306] = 0.0169312169312171*G0_0_0 + 0.0197530864197528*G0_0_2 + 0.0197530864197531*G0_2_0 + 0.022574955908289*G0_2_2;
    A[307] = 0.0846560846560844*G0_0_0 + 0.0423280423280429*G0_0_2 + 0.0423280423280429*G0_2_0 + 0.0225749559082896*G0_2_2;
    A[308] = 0.0677248677248677*G0_0_0 + 0.0846560846560843*G0_0_1 + 0.0649029982363311*G0_0_2 + 0.0649029982363318*G0_2_0 + 0.0846560846560848*G0_2_1 + 0.067724867724868*G0_2_2;
    A[309] = 0.0677248677248681*G0_0_0 - 0.0507936507936508*G0_0_1 - 0.0931216931216934*G0_0_2 - 0.093121693121693*G0_2_0 - 0.186243386243386*G0_2_1 - 0.270899470899472*G0_2_2;
    A[310] = -0.270899470899471*G0_0_0 - 0.186243386243387*G0_0_1 - 0.0931216931216927*G0_0_2 - 0.0931216931216937*G0_2_0 - 0.0507936507936505*G0_2_1 + 0.067724867724868*G0_2_2;
    A[311] = 0.0225749559082894*G0_0_0 + 0.0197530864197533*G0_0_2 + 0.0197530864197536*G0_2_0 + 0.0169312169312171*G0_2_2;
    A[312] = 0.0225749559082892*G0_0_0 + 0.0423280423280425*G0_0_2 + 0.0423280423280423*G0_2_0 + 0.0846560846560851*G0_2_2;
    A[313] = 0.0225749559082891*G0_0_0 + 0.0197530864197535*G0_0_2 + 0.0197530864197532*G0_2_0 + 0.0169312169312173*G0_2_2;
    A[314] = -0.135449735449736*G0_0_0 - 0.112874779541447*G0_0_2 - 0.112874779541446*G0_2_0 - 0.135449735449736*G0_2_2;
    A[315] = 0.00776014109347439*G0_0_0 + 0.00776014109347441*G0_0_1 + 0.00776014109347439*G0_0_2 + 0.00776014109347442*G0_2_0 + 0.00776014109347441*G0_2_1 + 0.00776014109347436*G0_2_2;
    A[316] = -0.00776014109347442*G0_0_0 + 0.0176366843033512*G0_2_0;
    A[317] = -0.00776014109347459*G0_0_1 - 0.00776014109347452*G0_2_1;
    A[318] = 0.045855379188713*G0_0_2 - 0.0246913580246915*G0_2_2;
    A[319] = 0.0451499118165789*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.033862433862434*G0_2_1 + 0.0112874779541447*G0_2_2;
    A[320] = -0.0902998236331577*G0_0_1 - 0.0310405643738977*G0_0_2 - 0.0592592592592593*G0_2_1 - 0.0423280423280424*G0_2_2;
    A[321] = 0.158024691358026*G0_0_1 + 0.0790123456790127*G0_0_2 + 0.0790123456790127*G0_2_1 + 0.101587301587302*G0_2_2;
    A[322] = 0.0451499118165789*G0_0_0 + 0.0112874779541448*G0_0_2 - 0.0338624338624337*G0_2_0 + 0.045149911816579*G0_2_2;
    A[323] = -0.0902998236331578*G0_0_0 - 0.031040564373898*G0_0_2 + 0.0423280423280422*G0_2_0 - 0.118518518518519*G0_2_2;
    A[324] = 0.158024691358026*G0_0_0 + 0.0790123456790127*G0_0_2 + 0.0790123456790127*G0_2_0 + 0.203174603174604*G0_2_2;
    A[325] = 0.0112874779541447*G0_0_0 + 0.0112874779541448*G0_0_1 + 0.033862433862434*G0_2_0 + 0.0451499118165791*G0_2_1;
    A[326] = 0.00282186948853622*G0_0_0 + 0.00282186948853601*G0_0_1 + 0.0141093474426808*G0_2_0 + 0.0169312169312166*G0_2_1;
    A[327] = 0.0112874779541446*G0_0_0 + 0.0112874779541448*G0_0_1 + 0.0112874779541446*G0_2_0 + 0.0225749559082895*G0_2_1;
    A[328] = -0.0451499118165788*G0_0_0 - 0.0451499118165788*G0_0_1 - 0.0338624338624338*G0_0_2 - 0.0338624338624338*G0_2_0 - 0.0338624338624338*G0_2_1 - 0.022574955908289*G0_2_2;
    A[329] = 0.0902998236331578*G0_0_0 + 0.090299823633158*G0_0_1 + 0.0592592592592595*G0_0_2 + 0.0592592592592592*G0_2_0 + 0.0592592592592593*G0_2_1 + 0.0169312169312166*G0_2_2;
    A[330] = -0.158024691358026*G0_0_0 - 0.158024691358026*G0_0_1 - 0.079012345679013*G0_0_2 - 0.0790123456790127*G0_2_0 - 0.0790123456790127*G0_2_1 + 0.0225749559082895*G0_2_2;
    A[331] = -0.0112874779541448*G0_0_0 - 0.0112874779541447*G0_0_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541446*G0_2_2;
    A[332] = -0.00282186948853622*G0_0_0 - 0.0028218694885362*G0_0_2 - 0.00282186948853609*G0_2_0 - 0.00282186948853608*G0_2_2;
    A[333] = -0.0112874779541446*G0_0_0 - 0.0112874779541446*G0_0_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541447*G0_2_2;
    A[334] = -0.0112874779541449*G0_0_1 - 0.0112874779541449*G0_0_2 - 0.0112874779541446*G0_2_0 - 0.0225749559082894*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[335] = -0.00282186948853616*G0_0_1 - 0.00282186948853618*G0_0_2 - 0.00282186948853601*G0_2_0 - 0.0169312169312168*G0_2_1 - 0.0169312169312168*G0_2_2;
    A[336] = -0.0112874779541448*G0_0_1 - 0.0112874779541448*G0_0_2 - 0.0112874779541449*G0_2_0 - 0.0451499118165791*G0_2_1 - 0.045149911816579*G0_2_2;
    A[337] = -0.0225749559082894*G0_0_0 - 0.0225749559082893*G0_0_1 + 0.0112874779541447*G0_0_2 - 0.033862433862434*G0_2_0 - 0.0677248677248678*G0_2_1 + 0.067724867724868*G0_2_2;
    A[338] = -0.022574955908289*G0_0_0 - 0.0225749559082891*G0_0_1 + 0.011287477954145*G0_0_2 - 0.0338624338624338*G0_2_0 - 0.0677248677248677*G0_2_1 + 0.0225749559082894*G0_2_2;
    A[339] = 0.112874779541446*G0_0_0 + 0.112874779541446*G0_0_1 + 0.0112874779541444*G0_0_2 + 0.101587301587302*G0_2_0 + 0.203174603174604*G0_2_1 - 0.0677248677248676*G0_2_2;
    A[340] = 0.0225749559082896*G0_0_0 + 0.0338624338624344*G0_0_2 + 0.033862433862434*G0_2_0 + 0.0451499118165785*G0_2_2;
    A[341] = 0.022574955908289*G0_0_0 + 0.0338624338624339*G0_0_2 + 0.0338624338624338*G0_2_0 + 0.0451499118165784*G0_2_2;
    A[342] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_2 - 0.101587301587302*G0_2_0 - 0.135449735449736*G0_2_2;
    A[343] = 0.0225749559082895*G0_0_1 + 0.0338624338624345*G0_0_2 + 0.0338624338624337*G0_2_0 + 0.0677248677248676*G0_2_1 + 0.090299823633157*G0_2_2;
    A[344] = 0.0225749559082892*G0_0_1 + 0.0338624338624341*G0_0_2 + 0.0338624338624339*G0_2_0 + 0.0677248677248678*G0_2_1 + 0.135449735449736*G0_2_2;
    A[345] = -0.112874779541446*G0_0_1 - 0.101587301587302*G0_0_2 - 0.101587301587301*G0_2_0 - 0.203174603174604*G0_2_1 - 0.270899470899472*G0_2_2;
    A[346] = -0.0112874779541448*G0_0_2 - 0.0112874779541448*G0_2_0 - 0.0225749559082893*G0_2_2;
    A[347] = -0.0112874779541448*G0_0_2 - 0.0112874779541446*G0_2_0 - 0.0677248677248681*G0_2_2;
    A[348] = -0.0112874779541448*G0_0_2 - 0.0112874779541448*G0_2_0 - 0.0225749559082893*G0_2_2;
    A[349] = 0.0902998236331568*G0_2_2;
    A[350] = 0.00776014109347433*G0_0_0 + 0.00776014109347435*G0_0_1 + 0.00776014109347434*G0_0_2 + 0.00776014109347442*G0_1_0 + 0.00776014109347442*G0_1_1 + 0.00776014109347442*G0_1_2;
    A[351] = -0.0246913580246913*G0_0_0 + 0.0458553791887129*G0_1_0;
    A[352] = 0.0176366843033511*G0_0_1 - 0.00776014109347442*G0_1_1;
    A[353] = -0.00776014109347448*G0_0_2 - 0.00776014109347453*G0_1_2;
    A[354] = 0.0338624338624338*G0_0_1 + 0.0451499118165788*G0_0_2 + 0.0112874779541447*G0_1_1 + 0.0112874779541448*G0_1_2;
    A[355] = 0.0141093474426808*G0_0_1 + 0.0169312169312166*G0_0_2 + 0.00282186948853617*G0_1_1 + 0.002821869488536*G0_1_2;
    A[356] = 0.0112874779541447*G0_0_1 + 0.0225749559082894*G0_0_2 + 0.0112874779541448*G0_1_1 + 0.0112874779541449*G0_1_2;
    A[357] = 0.101587301587302*G0_0_0 + 0.0790123456790126*G0_0_2 + 0.0790123456790125*G0_1_0 + 0.158024691358026*G0_1_2;
    A[358] = -0.0423280423280425*G0_0_0 - 0.0592592592592595*G0_0_2 - 0.0310405643738979*G0_1_0 - 0.0902998236331578*G0_1_2;
    A[359] = 0.0112874779541447*G0_0_0 + 0.033862433862434*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0451499118165791*G0_1_2;
    A[360] = 0.203174603174603*G0_0_0 + 0.0790123456790126*G0_0_1 + 0.0790123456790126*G0_1_0 + 0.158024691358026*G0_1_1;
    A[361] = -0.118518518518519*G0_0_0 + 0.042328042328042*G0_0_1 - 0.0310405643738979*G0_1_0 - 0.0902998236331578*G0_1_1;
    A[362] = 0.0451499118165788*G0_0_0 - 0.0338624338624337*G0_0_1 + 0.0112874779541448*G0_1_0 + 0.0451499118165788*G0_1_1;
    A[363] = -0.0112874779541446*G0_0_0 - 0.0112874779541446*G0_0_1 - 0.0112874779541446*G0_1_0 - 0.0112874779541446*G0_1_1;
    A[364] = -0.00282186948853612*G0_0_0 - 0.00282186948853603*G0_0_1 - 0.00282186948853618*G0_1_0 - 0.00282186948853612*G0_1_1;
    A[365] = -0.0112874779541446*G0_0_0 - 0.0112874779541447*G0_0_1 - 0.0112874779541448*G0_1_0 - 0.0112874779541448*G0_1_1;
    A[366] = -0.0225749559082894*G0_0_0 - 0.0112874779541445*G0_0_1 - 0.0225749559082893*G0_0_2 - 0.0112874779541447*G0_1_0 - 0.0112874779541447*G0_1_2;
    A[367] = -0.0169312169312167*G0_0_0 - 0.00282186948853614*G0_0_1 - 0.0169312169312166*G0_0_2 - 0.00282186948853603*G0_1_0 - 0.00282186948853599*G0_1_2;
    A[368] = -0.0451499118165788*G0_0_0 - 0.0112874779541448*G0_0_1 - 0.0451499118165788*G0_0_2 - 0.0112874779541448*G0_1_0 - 0.0112874779541448*G0_1_2;
    A[369] = -0.022574955908289*G0_0_0 - 0.0338624338624339*G0_0_1 - 0.0338624338624339*G0_0_2 - 0.0338624338624339*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.0451499118165787*G0_1_2;
    A[370] = 0.0169312169312168*G0_0_0 + 0.0592592592592591*G0_0_1 + 0.0592592592592592*G0_0_2 + 0.0592592592592595*G0_1_0 + 0.0902998236331574*G0_1_1 + 0.0902998236331574*G0_1_2;
    A[371] = 0.0225749559082892*G0_0_0 - 0.0790123456790125*G0_0_1 - 0.0790123456790125*G0_0_2 - 0.079012345679013*G0_1_0 - 0.158024691358026*G0_1_1 - 0.158024691358026*G0_1_2;
    A[372] = -0.067724867724868*G0_0_0 + 0.101587301587301*G0_0_1 + 0.203174603174603*G0_0_2 + 0.0112874779541444*G0_1_0 + 0.112874779541446*G0_1_1 + 0.112874779541446*G0_1_2;
    A[373] = 0.0677248677248677*G0_0_0 - 0.0338624338624341*G0_0_1 - 0.0677248677248678*G0_0_2 + 0.0112874779541446*G0_1_0 - 0.0225749559082894*G0_1_1 - 0.0225749559082893*G0_1_2;
    A[374] = 0.0225749559082892*G0_0_0 - 0.0338624338624341*G0_0_1 - 0.067724867724868*G0_0_2 + 0.011287477954145*G0_1_0 - 0.0225749559082891*G0_1_1 - 0.0225749559082892*G0_1_2;
    A[375] = -0.0225749559082892*G0_0_0 - 0.0112874779541446*G0_0_1 - 0.0112874779541446*G0_1_0;
    A[376] = -0.0677248677248677*G0_0_0 - 0.0112874779541447*G0_0_1 - 0.0112874779541447*G0_1_0;
    A[377] = -0.0225749559082891*G0_0_0 - 0.0112874779541447*G0_0_1 - 0.011287477954145*G0_1_0;
    A[378] = 0.0451499118165784*G0_0_0 + 0.0338624338624339*G0_0_1 + 0.0338624338624336*G0_1_0 + 0.022574955908289*G0_1_1;
    A[379] = -0.135449735449735*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587302*G0_1_0 - 0.112874779541446*G0_1_1;
    A[380] = 0.0451499118165786*G0_0_0 + 0.0338624338624341*G0_0_1 + 0.0338624338624341*G0_1_0 + 0.0225749559082891*G0_1_1;
    A[381] = 0.0902998236331569*G0_0_0 + 0.0338624338624339*G0_0_1 + 0.0677248677248677*G0_0_2 + 0.0338624338624339*G0_1_0 + 0.0225749559082892*G0_1_2;
    A[382] = -0.270899470899471*G0_0_0 - 0.101587301587301*G0_0_1 - 0.203174603174603*G0_0_2 - 0.101587301587302*G0_1_0 - 0.112874779541446*G0_1_2;
    A[383] = 0.135449735449735*G0_0_0 + 0.0338624338624336*G0_0_1 + 0.0677248677248678*G0_0_2 + 0.0338624338624339*G0_1_0 + 0.0225749559082893*G0_1_2;
    A[384] = 0.090299823633157*G0_0_0;
    A[385] = 0.00511463844797172*G0_0_0 + 0.0051146384479717*G0_0_1 + 0.00511463844797168*G0_0_2 + 0.00511463844797175*G0_1_0 + 0.00511463844797174*G0_1_1 + 0.00511463844797172*G0_1_2;
    A[386] = 0.0202821869488536*G0_0_0 - 0.0326278659611995*G0_1_0;
    A[387] = -0.0326278659611996*G0_0_1 + 0.0202821869488536*G0_1_1;
    A[388] = -0.00511463844797174*G0_0_2 - 0.00511463844797171*G0_1_2;
    A[389] = -0.0592592592592594*G0_0_1 - 0.0902998236331578*G0_0_2 - 0.0423280423280426*G0_1_1 - 0.031040564373898*G0_1_2;
    A[390] = -0.0105820105820105*G0_0_1 - 0.0211640211640206*G0_0_2 - 0.0134038800705467*G0_1_1 - 0.0105820105820105*G0_1_2;
    A[391] = 0.00282186948853624*G0_0_1 + 0.0169312169312168*G0_0_2 + 0.00282186948853603*G0_1_1 + 0.0141093474426806*G0_1_2;
    A[392] = -0.0423280423280425*G0_0_0 - 0.0310405643738979*G0_0_2 - 0.0592592592592595*G0_1_0 - 0.0902998236331577*G0_1_2;
    A[393] = -0.0134038800705468*G0_0_0 - 0.0105820105820106*G0_0_2 - 0.0105820105820104*G0_1_0 - 0.0211640211640206*G0_1_2;
    A[394] = 0.00282186948853622*G0_0_0 + 0.0141093474426808*G0_0_2 + 0.00282186948853601*G0_1_0 + 0.0169312169312166*G0_1_2;
    A[395] = -0.118518518518519*G0_0_0 - 0.0310405643738979*G0_0_1 + 0.042328042328042*G0_1_0 - 0.0902998236331578*G0_1_1;
    A[396] = 0.24973544973545*G0_0_0 + 0.0825396825396829*G0_0_1 + 0.0825396825396829*G0_1_0 + 0.24973544973545*G0_1_1;
    A[397] = -0.0902998236331578*G0_0_0 + 0.0423280423280419*G0_0_1 - 0.031040564373898*G0_1_0 - 0.118518518518519*G0_1_1;
    A[398] = -0.00282186948853619*G0_0_0 - 0.00282186948853608*G0_0_1 - 0.0028218694885362*G0_1_0 - 0.00282186948853612*G0_1_1;
    A[399] = -0.0091710758377423*G0_0_0 - 0.00917107583774238*G0_0_1 - 0.00917107583774232*G0_1_0 - 0.0091710758377424*G0_1_1;
    A[400] = -0.00282186948853626*G0_0_0 - 0.00282186948853622*G0_0_1 - 0.00282186948853605*G0_1_0 - 0.00282186948853601*G0_1_1;
    A[401] = -0.0169312169312166*G0_0_0 - 0.0141093474426804*G0_0_1 - 0.0169312169312166*G0_0_2 - 0.0141093474426806*G0_1_0 - 0.0112874779541446*G0_1_1 - 0.0141093474426805*G0_1_2;
    A[402] = 0.0211640211640205*G0_0_0 + 0.0105820105820101*G0_0_1 + 0.0211640211640204*G0_0_2 + 0.0105820105820103*G0_1_0 - 0.00282186948853616*G0_1_1 + 0.0105820105820102*G0_1_2;
    A[403] = 0.0902998236331578*G0_0_0 + 0.0310405643738983*G0_0_1 + 0.0902998236331579*G0_0_2 + 0.031040564373898*G0_1_0 - 0.0112874779541445*G0_1_1 + 0.0310405643738981*G0_1_2;
    A[404] = -0.0112874779541446*G0_0_0 - 0.0141093474426807*G0_0_1 - 0.0141093474426807*G0_0_2 - 0.0141093474426807*G0_1_0 - 0.0169312169312166*G0_1_1 - 0.0169312169312167*G0_1_2;
    A[405] = -0.00282186948853615*G0_0_0 + 0.0105820105820105*G0_0_1 + 0.0105820105820105*G0_0_2 + 0.0105820105820103*G0_1_0 + 0.0211640211640207*G0_1_1 + 0.0211640211640207*G0_1_2;
    A[406] = -0.0112874779541446*G0_0_0 + 0.0310405643738979*G0_0_1 + 0.0310405643738979*G0_0_2 + 0.0310405643738982*G0_1_0 + 0.0902998236331577*G0_1_1 + 0.0902998236331578*G0_1_2;
    A[407] = 0.118518518518519*G0_0_0 - 0.0423280423280426*G0_0_1 + 0.0507936507936509*G0_0_2 + 0.0931216931216932*G0_1_0 - 0.084656084656085*G0_1_1 + 0.186243386243386*G0_1_2;
    A[408] = -0.0846560846560848*G0_0_0 + 0.0931216931216935*G0_0_1 + 0.186243386243386*G0_0_2 - 0.0423280423280427*G0_1_0 + 0.118518518518519*G0_1_1 + 0.0507936507936506*G0_1_2;
    A[409] = -0.0169312169312166*G0_0_0 - 0.0197530864197529*G0_0_1 - 0.0846560846560844*G0_0_2 - 0.0197530864197533*G0_1_0 - 0.016931216931217*G0_1_1 - 0.0846560846560847*G0_1_2;
    A[410] = 0.0169312169312169*G0_0_0 + 0.0197530864197528*G0_0_1 + 0.0197530864197529*G0_1_0 + 0.0225749559082889*G0_1_1;
    A[411] = 0.0846560846560848*G0_0_0 + 0.0423280423280428*G0_0_1 + 0.0423280423280427*G0_1_0 + 0.0225749559082899*G0_1_1;
    A[412] = 0.0169312169312166*G0_0_0 + 0.0197530864197529*G0_0_1 + 0.0197530864197532*G0_1_0 + 0.0225749559082891*G0_1_1;
    A[413] = 0.0225749559082892*G0_0_0 + 0.0197530864197531*G0_0_1 + 0.0197530864197533*G0_1_0 + 0.0169312169312169*G0_1_1;
    A[414] = 0.0225749559082895*G0_0_0 + 0.0423280423280426*G0_0_1 + 0.0423280423280425*G0_1_0 + 0.084656084656085*G0_1_1;
    A[415] = 0.0225749559082891*G0_0_0 + 0.0197530864197529*G0_0_1 + 0.0197530864197528*G0_1_0 + 0.016931216931217*G0_1_1;
    A[416] = 0.0677248677248675*G0_0_0 + 0.0649029982363311*G0_0_1 + 0.0846560846560842*G0_0_2 + 0.0649029982363313*G0_1_0 + 0.0677248677248673*G0_1_1 + 0.0846560846560842*G0_1_2;
    A[417] = 0.0677248677248679*G0_0_0 - 0.0931216931216933*G0_0_1 - 0.0507936507936508*G0_0_2 - 0.0931216931216928*G0_1_0 - 0.270899470899471*G0_1_1 - 0.186243386243386*G0_1_2;
    A[418] = -0.270899470899471*G0_0_0 - 0.0931216931216925*G0_0_1 - 0.186243386243386*G0_0_2 - 0.0931216931216931*G0_1_0 + 0.0677248677248683*G0_1_1 - 0.0507936507936508*G0_1_2;
    A[419] = -0.135449735449735*G0_0_0 - 0.112874779541447*G0_0_1 - 0.112874779541446*G0_1_0 - 0.135449735449736*G0_1_1;
    A[420] = 0.00776014109347443*G0_0_0 + 0.00776014109347443*G0_0_1 + 0.00776014109347443*G0_0_2 + 0.00776014109347435*G0_1_0 + 0.00776014109347434*G0_1_1 + 0.00776014109347435*G0_1_2;
    A[421] = -0.00776014109347445*G0_0_0 + 0.017636684303351*G0_1_0;
    A[422] = 0.0458553791887128*G0_0_1 - 0.0246913580246914*G0_1_1;
    A[423] = -0.00776014109347445*G0_0_2 - 0.00776014109347445*G0_1_2;
    A[424] = 0.0790123456790126*G0_0_1 + 0.158024691358025*G0_0_2 + 0.101587301587302*G0_1_1 + 0.0790123456790126*G0_1_2;
    A[425] = -0.031040564373898*G0_0_1 - 0.0902998236331577*G0_0_2 - 0.0423280423280424*G0_1_1 - 0.0592592592592593*G0_1_2;
    A[426] = 0.0112874779541446*G0_0_1 + 0.0451499118165785*G0_0_2 + 0.0112874779541448*G0_1_1 + 0.033862433862434*G0_1_2;
    A[427] = 0.0112874779541446*G0_0_0 + 0.0112874779541448*G0_0_2 + 0.033862433862434*G0_1_0 + 0.0451499118165788*G0_1_2;
    A[428] = 0.00282186948853614*G0_0_0 + 0.00282186948853598*G0_0_2 + 0.0141093474426805*G0_1_0 + 0.0169312169312165*G0_1_2;
    A[429] = 0.0112874779541446*G0_0_0 + 0.0112874779541446*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0225749559082895*G0_1_2;
    A[430] = 0.0451499118165788*G0_0_0 + 0.0112874779541448*G0_0_1 - 0.0338624338624337*G0_1_0 + 0.0451499118165788*G0_1_1;
    A[431] = -0.0902998236331578*G0_0_0 - 0.031040564373898*G0_0_1 + 0.0423280423280419*G0_1_0 - 0.118518518518519*G0_1_1;
    A[432] = 0.158024691358025*G0_0_0 + 0.0790123456790126*G0_0_1 + 0.0790123456790126*G0_1_0 + 0.203174603174603*G0_1_1;
    A[433] = -0.0112874779541445*G0_0_0 - 0.0112874779541446*G0_0_1 - 0.0112874779541445*G0_1_0 - 0.0112874779541446*G0_1_1;
    A[434] = -0.00282186948853637*G0_0_0 - 0.00282186948853633*G0_0_1 - 0.00282186948853624*G0_1_0 - 0.00282186948853621*G0_1_1;
    A[435] = -0.0112874779541445*G0_0_0 - 0.0112874779541446*G0_0_1 - 0.0112874779541448*G0_1_0 - 0.0112874779541448*G0_1_1;
    A[436] = -0.0451499118165787*G0_0_0 - 0.033862433862434*G0_0_1 - 0.0451499118165787*G0_0_2 - 0.0338624338624338*G0_1_0 - 0.022574955908289*G0_1_1 - 0.0338624338624339*G0_1_2;
    A[437] = 0.0902998236331576*G0_0_0 + 0.0592592592592596*G0_0_1 + 0.0902998236331576*G0_0_2 + 0.0592592592592594*G0_1_0 + 0.0169312169312167*G0_1_1 + 0.0592592592592594*G0_1_2;
    A[438] = -0.158024691358026*G0_0_0 - 0.0790123456790129*G0_0_1 - 0.158024691358026*G0_0_2 - 0.0790123456790126*G0_1_0 + 0.0225749559082893*G0_1_1 - 0.0790123456790126*G0_1_2;
    A[439] = -0.0112874779541447*G0_0_1 - 0.0112874779541447*G0_0_2 - 0.0112874779541446*G0_1_0 - 0.0225749559082894*G0_1_1 - 0.0225749559082894*G0_1_2;
    A[440] = -0.00282186948853616*G0_0_1 - 0.00282186948853609*G0_0_2 - 0.00282186948853594*G0_1_0 - 0.0169312169312169*G0_1_1 - 0.0169312169312168*G0_1_2;
    A[441] = -0.0112874779541447*G0_0_1 - 0.0112874779541447*G0_0_2 - 0.0112874779541448*G0_1_0 - 0.0451499118165788*G0_1_1 - 0.0451499118165788*G0_1_2;
    A[442] = -0.0225749559082894*G0_0_0 + 0.0112874779541446*G0_0_1 - 0.0225749559082895*G0_0_2 - 0.0338624338624342*G0_1_0 + 0.0677248677248677*G0_1_1 - 0.0677248677248679*G0_1_2;
    A[443] = 0.112874779541446*G0_0_0 + 0.0112874779541442*G0_0_1 + 0.112874779541446*G0_0_2 + 0.101587301587302*G0_1_0 - 0.0677248677248678*G0_1_1 + 0.203174603174603*G0_1_2;
    A[444] = -0.0225749559082898*G0_0_0 + 0.0112874779541443*G0_0_1 - 0.0225749559082896*G0_0_2 - 0.0338624338624337*G0_1_0 + 0.0225749559082892*G0_1_1 - 0.0677248677248677*G0_1_2;
    A[445] = 0.0225749559082887*G0_0_0 + 0.0338624338624339*G0_0_1 + 0.0338624338624337*G0_1_0 + 0.0451499118165784*G0_1_1;
    A[446] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587302*G0_1_0 - 0.135449735449736*G0_1_1;
    A[447] = 0.0225749559082899*G0_0_0 + 0.0338624338624343*G0_0_1 + 0.0338624338624338*G0_1_0 + 0.0451499118165786*G0_1_1;
    A[448] = -0.0112874779541452*G0_0_1 - 0.0112874779541449*G0_1_0 - 0.0225749559082896*G0_1_1;
    A[449] = -0.0112874779541447*G0_0_1 - 0.0112874779541445*G0_1_0 - 0.0677248677248677*G0_1_1;
    A[450] = -0.0112874779541443*G0_0_1 - 0.0112874779541443*G0_1_0 - 0.0225749559082892*G0_1_1;
    A[451] = 0.0338624338624341*G0_0_1 + 0.0225749559082891*G0_0_2 + 0.0338624338624337*G0_1_0 + 0.0902998236331571*G0_1_1 + 0.0677248677248675*G0_1_2;
    A[452] = 0.033862433862434*G0_0_1 + 0.0225749559082891*G0_0_2 + 0.0338624338624338*G0_1_0 + 0.135449735449736*G0_1_1 + 0.0677248677248677*G0_1_2;
    A[453] = -0.101587301587302*G0_0_1 - 0.112874779541446*G0_0_2 - 0.101587301587301*G0_1_0 - 0.270899470899471*G0_1_1 - 0.203174603174603*G0_1_2;
    A[454] = 0.0902998236331575*G0_1_1;
    A[455] = -0.0246913580246911*G0_0_0 - 0.0246913580246911*G0_0_1 - 0.0246913580246911*G0_0_2 - 0.0246913580246912*G0_1_0 - 0.0246913580246912*G0_1_1 - 0.0246913580246912*G0_1_2 - 0.0705467372134041*G0_2_0 - 0.0705467372134041*G0_2_1 - 0.0705467372134041*G0_2_2;
    A[456] = 0.0077601410934745*G0_0_0 + 0.00776014109347449*G0_1_0;
    A[457] = 0.00776014109347445*G0_0_1 + 0.00776014109347444*G0_1_1;
    A[458] = -0.0176366843033511*G0_0_2 - 0.0176366843033511*G0_1_2 - 0.0253968253968255*G0_2_2;
    A[459] = -0.0225749559082892*G0_0_1 - 0.0112874779541446*G0_0_2 - 0.0225749559082893*G0_1_1 - 0.0112874779541446*G0_1_2 - 0.0112874779541444*G0_2_1;
    A[460] = -0.0169312169312169*G0_0_1 - 0.0141093474426808*G0_0_2 - 0.0169312169312169*G0_1_1 - 0.0141093474426809*G0_1_2 - 0.0141093474426809*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[461] = -0.0451499118165788*G0_0_1 - 0.033862433862434*G0_0_2 - 0.0451499118165788*G0_1_1 - 0.0338624338624339*G0_1_2 - 0.0338624338624339*G0_2_1 - 0.0225749559082891*G0_2_2;
    A[462] = -0.0225749559082893*G0_0_0 - 0.0112874779541445*G0_0_2 - 0.0225749559082893*G0_1_0 - 0.0112874779541445*G0_1_2 - 0.0112874779541443*G0_2_0;
    A[463] = -0.0169312169312168*G0_0_0 - 0.014109347442681*G0_0_2 - 0.0169312169312167*G0_1_0 - 0.0141093474426809*G0_1_2 - 0.0141093474426808*G0_2_0 - 0.0112874779541447*G0_2_2;
    A[464] = -0.0451499118165788*G0_0_0 - 0.0338624338624338*G0_0_2 - 0.0451499118165788*G0_1_0 - 0.0338624338624338*G0_1_2 - 0.0338624338624339*G0_2_0 - 0.022574955908289*G0_2_2;
    A[465] = -0.0112874779541446*G0_0_0 - 0.0112874779541446*G0_0_1 - 0.0112874779541446*G0_1_0 - 0.0112874779541446*G0_1_1;
    A[466] = -0.00282186948853619*G0_0_0 - 0.00282186948853619*G0_0_1 - 0.00282186948853608*G0_1_0 - 0.00282186948853612*G0_1_1;
    A[467] = -0.0112874779541445*G0_0_0 - 0.0112874779541445*G0_0_1 - 0.0112874779541446*G0_1_0 - 0.0112874779541446*G0_1_1;
    A[468] = 0.203174603174603*G0_0_0 + 0.203174603174603*G0_0_1 + 0.12416225749559*G0_0_2 + 0.203174603174603*G0_1_0 + 0.203174603174603*G0_1_1 + 0.12416225749559*G0_1_2 + 0.12416225749559*G0_2_0 + 0.12416225749559*G0_2_1 + 0.203174603174603*G0_2_2;
    A[469] = -0.118518518518519*G0_0_0 - 0.118518518518519*G0_0_1 - 0.16084656084656*G0_0_2 - 0.118518518518519*G0_1_0 - 0.118518518518519*G0_1_1 - 0.160846560846561*G0_1_2 - 0.0874779541446205*G0_2_0 - 0.0874779541446205*G0_2_1 - 0.22010582010582*G0_2_2;
    A[470] = 0.0451499118165788*G0_0_0 + 0.0451499118165788*G0_0_1 + 0.0790123456790123*G0_0_2 + 0.0451499118165788*G0_1_0 + 0.0451499118165789*G0_1_1 + 0.0790123456790124*G0_1_2 + 0.0338624338624339*G0_2_0 + 0.0338624338624339*G0_2_1 + 0.112874779541446*G0_2_2;
    A[471] = 0.101587301587302*G0_0_0 + 0.0225749559082888*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587302*G0_1_0 + 0.0225749559082888*G0_1_1 + 0.101587301587302*G0_1_2 + 0.0225749559082889*G0_2_0 + 0.101587301587302*G0_2_1 + 0.022574955908289*G0_2_2;
    A[472] = -0.0423280423280423*G0_0_0 + 0.0169312169312174*G0_0_1 - 0.0423280423280422*G0_0_2 - 0.0423280423280423*G0_1_0 + 0.0169312169312173*G0_1_1 - 0.0423280423280423*G0_1_2 - 0.0112874779541445*G0_2_0 - 0.0423280423280426*G0_2_1 - 0.0112874779541445*G0_2_2;
    A[473] = 0.0112874779541446*G0_0_0 - 0.0225749559082895*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.0112874779541446*G0_1_0 - 0.0225749559082894*G0_1_1 + 0.0112874779541446*G0_1_2 + 0.0112874779541449*G0_2_1;
    A[474] = 0.022574955908289*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.022574955908289*G0_1_0 + 0.101587301587302*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587302*G0_2_0 + 0.0225749559082891*G0_2_1 + 0.0225749559082891*G0_2_2;
    A[475] = 0.0169312169312171*G0_0_0 - 0.0423280423280423*G0_0_1 - 0.0423280423280423*G0_0_2 + 0.016931216931217*G0_1_0 - 0.0423280423280422*G0_1_1 - 0.0423280423280422*G0_1_2 - 0.0423280423280429*G0_2_0 - 0.0112874779541446*G0_2_1 - 0.0112874779541446*G0_2_2;
    A[476] = -0.0225749559082894*G0_0_0 + 0.0112874779541445*G0_0_1 + 0.0112874779541445*G0_0_2 - 0.0225749559082894*G0_1_0 + 0.0112874779541445*G0_1_1 + 0.0112874779541445*G0_1_2 + 0.0112874779541449*G0_2_0;
    A[477] = -0.0225749559082894*G0_0_0 - 0.0225749559082891*G0_0_1 - 0.0112874779541445*G0_0_2 - 0.0225749559082894*G0_1_0 - 0.0225749559082892*G0_1_1 - 0.0112874779541445*G0_1_2 - 0.011287477954145*G0_2_0 - 0.0112874779541443*G0_2_1;
    A[478] = -0.0225749559082893*G0_0_0 - 0.0225749559082897*G0_0_1 - 0.0112874779541447*G0_0_2 - 0.0225749559082895*G0_1_0 - 0.0225749559082898*G0_1_1 - 0.0112874779541446*G0_1_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541454*G0_2_1;
    A[479] = -0.0677248677248681*G0_0_0 - 0.0677248677248678*G0_0_1 - 0.0564373897707236*G0_0_2 - 0.0677248677248681*G0_1_0 - 0.0677248677248678*G0_1_1 - 0.0564373897707236*G0_1_2 - 0.0564373897707237*G0_2_0 - 0.0564373897707236*G0_2_1 - 0.0451499118165797*G0_2_2;
    A[480] = -0.0677248677248676*G0_0_0 - 0.270899470899471*G0_0_1 - 0.16931216931217*G0_0_2 - 0.0677248677248677*G0_1_0 - 0.270899470899471*G0_1_1 - 0.16931216931217*G0_1_2 - 0.0790123456790117*G0_2_0 - 0.169312169312169*G0_2_1 - 0.067724867724867*G0_2_2;
    A[481] = 0.0225749559082893*G0_0_0 + 0.0902998236331568*G0_0_1 + 0.0564373897707232*G0_0_2 + 0.0225749559082895*G0_1_0 + 0.0902998236331569*G0_1_1 + 0.0564373897707233*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0564373897707225*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[482] = 0.067724867724868*G0_0_0 + 0.135449735449736*G0_0_1 + 0.101587301587302*G0_0_2 + 0.067724867724868*G0_1_0 + 0.135449735449736*G0_1_1 + 0.101587301587302*G0_1_2 + 0.0564373897707236*G0_2_0 + 0.101587301587301*G0_2_1 + 0.067724867724867*G0_2_2;
    A[483] = -0.270899470899471*G0_0_0 - 0.0677248677248678*G0_0_1 - 0.16931216931217*G0_0_2 - 0.270899470899471*G0_1_0 - 0.0677248677248676*G0_1_1 - 0.16931216931217*G0_1_2 - 0.169312169312168*G0_2_0 - 0.0790123456790118*G0_2_1 - 0.0677248677248672*G0_2_2;
    A[484] = 0.0902998236331569*G0_0_0 + 0.0225749559082894*G0_0_1 + 0.0564373897707234*G0_0_2 + 0.0902998236331567*G0_1_0 + 0.0225749559082894*G0_1_1 + 0.0564373897707232*G0_1_2 + 0.0564373897707224*G0_2_0 + 0.0112874779541444*G0_2_1 + 0.0225749559082894*G0_2_2;
    A[485] = 0.135449735449736*G0_0_0 + 0.0677248677248679*G0_0_1 + 0.101587301587302*G0_0_2 + 0.135449735449736*G0_1_0 + 0.0677248677248679*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587301*G0_2_0 + 0.0564373897707237*G0_2_1 + 0.0677248677248671*G0_2_2;
    A[486] = -0.135449735449736*G0_0_0 - 0.135449735449736*G0_0_1 - 0.0338624338624336*G0_0_2 - 0.135449735449735*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0338624338624335*G0_1_2 - 0.0338624338624334*G0_2_0 - 0.0338624338624336*G0_2_1 - 0.0451499118165782*G0_2_2;
    A[487] = 0.0451499118165785*G0_0_0 + 0.0451499118165786*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.0451499118165783*G0_1_0 + 0.0451499118165784*G0_1_1 + 0.0112874779541446*G0_1_2 + 0.0112874779541441*G0_2_0 + 0.0112874779541447*G0_2_1;
    A[488] = 0.0451499118165785*G0_0_0 + 0.0451499118165784*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.0451499118165784*G0_1_0 + 0.0451499118165784*G0_1_1 + 0.0112874779541446*G0_1_2 + 0.0112874779541444*G0_2_0 + 0.0112874779541442*G0_2_1;
    A[489] = 0.0902998236331572*G0_0_0 + 0.0902998236331573*G0_0_1 + 0.0902998236331572*G0_0_2 + 0.0902998236331572*G0_1_0 + 0.0902998236331571*G0_1_1 + 0.0902998236331571*G0_1_2 + 0.0902998236331568*G0_2_0 + 0.090299823633157*G0_2_1 + 0.0902998236331578*G0_2_2;
    A[490] = 0.0202821869488535*G0_0_0 + 0.0202821869488535*G0_0_1 + 0.0202821869488535*G0_0_2 + 0.0202821869488535*G0_1_0 + 0.0202821869488535*G0_1_1 + 0.0202821869488535*G0_1_2 + 0.052910052910053*G0_2_0 + 0.052910052910053*G0_2_1 + 0.0529100529100531*G0_2_2;
    A[491] = 0.00511463844797171*G0_0_0 + 0.0051146384479717*G0_1_0;
    A[492] = 0.00511463844797169*G0_0_1 + 0.00511463844797171*G0_1_1;
    A[493] = 0.0326278659611996*G0_0_2 + 0.0326278659611997*G0_1_2 + 0.0529100529100532*G0_2_2;
    A[494] = -0.0169312169312168*G0_0_1 - 0.00282186948853641*G0_0_2 - 0.0169312169312168*G0_1_1 - 0.00282186948853637*G0_1_2 - 0.00282186948853633*G0_2_1;
    A[495] = 0.0211640211640209*G0_0_1 + 0.0105820105820109*G0_0_2 + 0.0211640211640209*G0_1_1 + 0.010582010582011*G0_1_2 + 0.0105820105820105*G0_2_1 - 0.00282186948853612*G0_2_2;
    A[496] = 0.0902998236331578*G0_0_1 + 0.0592592592592594*G0_0_2 + 0.090299823633158*G0_1_1 + 0.0592592592592595*G0_1_2 + 0.0592592592592595*G0_2_1 + 0.0169312169312168*G0_2_2;
    A[497] = -0.0169312169312165*G0_0_0 - 0.00282186948853623*G0_0_2 - 0.0169312169312164*G0_1_0 - 0.00282186948853618*G0_1_2 - 0.00282186948853633*G0_2_0;
    A[498] = 0.0211640211640205*G0_0_0 + 0.0105820105820108*G0_0_2 + 0.0211640211640204*G0_1_0 + 0.0105820105820108*G0_1_2 + 0.0105820105820104*G0_2_0 - 0.00282186948853586*G0_2_2;
    A[499] = 0.0902998236331578*G0_0_0 + 0.0592592592592592*G0_0_2 + 0.090299823633158*G0_1_0 + 0.0592592592592593*G0_1_2 + 0.0592592592592595*G0_2_0 + 0.0169312169312166*G0_2_2;
    A[500] = -0.00282186948853612*G0_0_0 - 0.00282186948853618*G0_0_1 - 0.00282186948853603*G0_1_0 - 0.00282186948853612*G0_1_1;
    A[501] = -0.0091710758377423*G0_0_0 - 0.00917107583774232*G0_0_1 - 0.00917107583774238*G0_1_0 - 0.0091710758377424*G0_1_1;
    A[502] = -0.00282186948853637*G0_0_0 - 0.00282186948853624*G0_0_1 - 0.00282186948853633*G0_1_0 - 0.00282186948853621*G0_1_1;
    A[503] = -0.118518518518519*G0_0_0 - 0.118518518518519*G0_0_1 - 0.0874779541446205*G0_0_2 - 0.118518518518519*G0_1_0 - 0.118518518518519*G0_1_1 - 0.0874779541446205*G0_1_2 - 0.16084656084656*G0_2_0 - 0.160846560846561*G0_2_1 - 0.22010582010582*G0_2_2;
    A[504] = 0.249735449735451*G0_0_0 + 0.249735449735451*G0_0_1 + 0.167195767195767*G0_0_2 + 0.249735449735451*G0_1_0 + 0.249735449735451*G0_1_1 + 0.167195767195767*G0_1_2 + 0.167195767195767*G0_2_0 + 0.167195767195767*G0_2_1 + 0.334391534391535*G0_2_2;
    A[505] = -0.0902998236331578*G0_0_0 - 0.0902998236331579*G0_0_1 - 0.1326278659612*G0_0_2 - 0.0902998236331579*G0_1_0 - 0.090299823633158*G0_1_1 - 0.1326278659612*G0_1_2 - 0.0592592592592595*G0_2_0 - 0.0592592592592596*G0_2_1 - 0.22010582010582*G0_2_2;
    A[506] = -0.0423280423280427*G0_0_0 - 0.0112874779541444*G0_0_1 - 0.0423280423280427*G0_0_2 - 0.0423280423280427*G0_1_0 - 0.0112874779541444*G0_1_1 - 0.0423280423280428*G0_1_2 + 0.0169312169312171*G0_2_0 - 0.0423280423280425*G0_2_1 + 0.0169312169312171*G0_2_2;
    A[507] = -0.0134038800705467*G0_0_0 - 0.00282186948853641*G0_0_1 - 0.0134038800705467*G0_0_2 - 0.0134038800705468*G0_1_0 - 0.00282186948853637*G0_1_1 - 0.0134038800705468*G0_1_2 - 0.00282186948853613*G0_2_0 - 0.0134038800705466*G0_2_1 - 0.0028218694885361*G0_2_2;
    A[508] = 0.00282186948853633*G0_0_0 - 0.0112874779541444*G0_0_1 + 0.00282186948853632*G0_0_2 + 0.00282186948853629*G0_1_0 - 0.0112874779541445*G0_1_1 + 0.00282186948853628*G0_1_2 + 0.00282186948853593*G0_2_1;
    A[509] = -0.0112874779541445*G0_0_0 - 0.0423280423280428*G0_0_1 - 0.0423280423280428*G0_0_2 - 0.0112874779541445*G0_1_0 - 0.0423280423280428*G0_1_1 - 0.0423280423280428*G0_1_2 - 0.0423280423280427*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[510] = -0.00282186948853629*G0_0_0 - 0.0134038800705468*G0_0_1 - 0.0134038800705468*G0_0_2 - 0.00282186948853628*G0_1_0 - 0.0134038800705467*G0_1_1 - 0.0134038800705468*G0_1_2 - 0.0134038800705463*G0_2_0 - 0.00282186948853607*G0_2_1 - 0.00282186948853606*G0_2_2;
    A[511] = -0.0112874779541444*G0_0_0 + 0.00282186948853618*G0_0_1 + 0.00282186948853619*G0_0_2 - 0.0112874779541445*G0_1_0 + 0.00282186948853613*G0_1_1 + 0.00282186948853614*G0_1_2 + 0.00282186948853591*G0_2_0;
    A[512] = 0.0169312169312175*G0_0_0 + 0.0169312169312175*G0_0_1 - 0.0028218694885357*G0_0_2 + 0.0169312169312173*G0_1_0 + 0.0169312169312175*G0_1_1 - 0.00282186948853573*G0_1_2 - 0.00282186948853541*G0_2_0 - 0.00282186948853636*G0_2_1;
    A[513] = 0.0169312169312172*G0_0_0 + 0.0169312169312176*G0_0_1 - 0.00282186948853591*G0_0_2 + 0.0169312169312174*G0_1_0 + 0.0169312169312177*G0_1_1 - 0.00282186948853583*G0_1_2 - 0.00282186948853611*G0_2_0 - 0.0028218694885351*G0_2_1;
    A[514] = 0.0846560846560849*G0_0_0 + 0.0846560846560844*G0_0_1 + 0.0423280423280426*G0_0_2 + 0.0846560846560851*G0_1_0 + 0.0846560846560845*G0_1_1 + 0.0423280423280427*G0_1_2 + 0.042328042328043*G0_2_0 + 0.0423280423280428*G0_2_1 + 0.0225749559082906*G0_2_2;
    A[515] = 0.118518518518519*G0_0_0 + 0.067724867724868*G0_0_1 + 0.160846560846562*G0_0_2 + 0.118518518518519*G0_1_0 + 0.0677248677248678*G0_1_1 + 0.160846560846562*G0_1_2 + 0.0253968253968248*G0_2_0 + 0.16084656084656*G0_2_1 - 0.0169312169312177*G0_2_2;
    A[516] = -0.0169312169312172*G0_0_0 + 0.0677248677248678*G0_0_1 + 0.00282186948853585*G0_0_2 - 0.0169312169312174*G0_1_0 + 0.067724867724868*G0_1_1 + 0.0028218694885358*G0_1_2 + 0.0028218694885361*G0_2_0 + 0.00282186948853683*G0_2_1 + 0.00564373897707232*G0_2_2;
    A[517] = -0.0846560846560849*G0_0_0 - 0.270899470899471*G0_0_1 - 0.177777777777779*G0_0_2 - 0.0846560846560851*G0_1_0 - 0.270899470899472*G0_1_1 - 0.177777777777779*G0_1_2 - 0.042328042328043*G0_2_0 - 0.177777777777778*G0_2_1 - 0.0169312169312162*G0_2_2;
    A[518] = 0.0677248677248679*G0_0_0 + 0.118518518518519*G0_0_1 + 0.160846560846562*G0_0_2 + 0.0677248677248679*G0_1_0 + 0.118518518518519*G0_1_1 + 0.160846560846562*G0_1_2 + 0.16084656084656*G0_2_0 + 0.0253968253968248*G0_2_1 - 0.0169312169312175*G0_2_2;
    A[519] = 0.0677248677248675*G0_0_0 - 0.0169312169312176*G0_0_1 + 0.00282186948853595*G0_0_2 + 0.0677248677248675*G0_1_0 - 0.0169312169312176*G0_1_1 + 0.00282186948853597*G0_1_2 + 0.00282186948853693*G0_2_0 + 0.0028218694885362*G0_2_1 + 0.00564373897707188*G0_2_2;
    A[520] = -0.270899470899471*G0_0_0 - 0.0846560846560845*G0_0_1 - 0.177777777777778*G0_0_2 - 0.270899470899471*G0_1_0 - 0.0846560846560846*G0_1_1 - 0.177777777777779*G0_1_2 - 0.177777777777777*G0_2_0 - 0.0423280423280429*G0_2_1 - 0.016931216931216*G0_2_2;
    A[521] = 0.0225749559082896*G0_0_0 + 0.0225749559082897*G0_0_1 - 0.0197530864197531*G0_0_2 + 0.0225749559082896*G0_1_0 + 0.0225749559082896*G0_1_1 - 0.0197530864197532*G0_1_2 - 0.0197530864197535*G0_2_0 - 0.0197530864197532*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[522] = 0.0225749559082893*G0_0_0 + 0.0225749559082891*G0_0_1 + 0.00282186948853563*G0_0_2 + 0.0225749559082892*G0_1_0 + 0.0225749559082892*G0_1_1 + 0.00282186948853566*G0_1_2 + 0.00282186948853655*G0_2_0 + 0.00282186948853578*G0_2_1;
    A[523] = 0.0225749559082891*G0_0_0 + 0.0225749559082893*G0_0_1 + 0.002821869488536*G0_0_2 + 0.0225749559082892*G0_1_0 + 0.0225749559082894*G0_1_1 + 0.00282186948853593*G0_1_2 + 0.00282186948853608*G0_2_0 + 0.00282186948853646*G0_2_1;
    A[524] = -0.135449735449737*G0_0_0 - 0.135449735449737*G0_0_1 - 0.0225749559082896*G0_0_2 - 0.135449735449737*G0_1_0 - 0.135449735449737*G0_1_1 - 0.0225749559082896*G0_1_2 - 0.0225749559082895*G0_2_0 - 0.0225749559082896*G0_2_1 - 0.0451499118165797*G0_2_2;
    A[525] = -0.00776014109347439*G0_0_0 - 0.00776014109347441*G0_0_1 - 0.00776014109347438*G0_0_2 - 0.00776014109347439*G0_1_0 - 0.00776014109347442*G0_1_1 - 0.00776014109347439*G0_1_2 - 0.0253968253968254*G0_2_0 - 0.0253968253968254*G0_2_1 - 0.0253968253968254*G0_2_2;
    A[526] = 0.00776014109347442*G0_0_0 + 0.00776014109347442*G0_1_0;
    A[527] = 0.00776014109347457*G0_0_1 + 0.00776014109347458*G0_1_1;
    A[528] = -0.045855379188713*G0_0_2 - 0.045855379188713*G0_1_2 - 0.0705467372134043*G0_2_2;
    A[529] = -0.0451499118165788*G0_0_1 - 0.0112874779541445*G0_0_2 - 0.0451499118165789*G0_1_1 - 0.0112874779541446*G0_1_2 - 0.0112874779541447*G0_2_1;
    A[530] = 0.0902998236331577*G0_0_1 + 0.0310405643738977*G0_0_2 + 0.0902998236331577*G0_1_1 + 0.0310405643738977*G0_1_2 + 0.0310405643738981*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[531] = -0.158024691358026*G0_0_1 - 0.0790123456790127*G0_0_2 - 0.158024691358026*G0_1_1 - 0.0790123456790127*G0_1_2 - 0.079012345679013*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[532] = -0.0451499118165789*G0_0_0 - 0.0112874779541448*G0_0_2 - 0.0451499118165789*G0_1_0 - 0.0112874779541448*G0_1_2 - 0.0112874779541447*G0_2_0;
    A[533] = 0.0902998236331579*G0_0_0 + 0.031040564373898*G0_0_2 + 0.0902998236331579*G0_1_0 + 0.0310405643738979*G0_1_2 + 0.0310405643738983*G0_2_0 - 0.0112874779541449*G0_2_2;
    A[534] = -0.158024691358026*G0_0_0 - 0.0790123456790127*G0_0_2 - 0.158024691358026*G0_1_0 - 0.0790123456790127*G0_1_2 - 0.079012345679013*G0_2_0 + 0.0225749559082895*G0_2_2;
    A[535] = -0.0112874779541446*G0_0_0 - 0.0112874779541448*G0_0_1 - 0.0112874779541447*G0_1_0 - 0.0112874779541448*G0_1_1;
    A[536] = -0.00282186948853626*G0_0_0 - 0.00282186948853605*G0_0_1 - 0.00282186948853622*G0_1_0 - 0.00282186948853601*G0_1_1;
    A[537] = -0.0112874779541445*G0_0_0 - 0.0112874779541448*G0_0_1 - 0.0112874779541446*G0_1_0 - 0.0112874779541448*G0_1_1;
    A[538] = 0.0451499118165788*G0_0_0 + 0.0451499118165788*G0_0_1 + 0.0338624338624339*G0_0_2 + 0.0451499118165788*G0_1_0 + 0.0451499118165789*G0_1_1 + 0.0338624338624339*G0_1_2 + 0.0790123456790123*G0_2_0 + 0.0790123456790124*G0_2_1 + 0.112874779541446*G0_2_2;
    A[539] = -0.0902998236331578*G0_0_0 - 0.0902998236331579*G0_0_1 - 0.0592592592592595*G0_0_2 - 0.0902998236331579*G0_1_0 - 0.090299823633158*G0_1_1 - 0.0592592592592596*G0_1_2 - 0.1326278659612*G0_2_0 - 0.1326278659612*G0_2_1 - 0.22010582010582*G0_2_2;
    A[540] = 0.158024691358026*G0_0_0 + 0.158024691358026*G0_0_1 + 0.079012345679013*G0_0_2 + 0.158024691358026*G0_1_0 + 0.158024691358026*G0_1_1 + 0.0790123456790131*G0_1_2 + 0.079012345679013*G0_2_0 + 0.0790123456790131*G0_2_1 + 0.203174603174604*G0_2_2;
    A[541] = 0.0112874779541447*G0_0_0 + 0.0112874779541447*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0112874779541447*G0_1_2 - 0.0225749559082893*G0_2_0 + 0.0112874779541446*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[542] = 0.00282186948853622*G0_0_0 + 0.00282186948853619*G0_0_2 + 0.0028218694885362*G0_1_0 + 0.00282186948853617*G0_1_2 - 0.0112874779541446*G0_2_0 + 0.00282186948853616*G0_2_1 - 0.0112874779541446*G0_2_2;
    A[543] = 0.0112874779541446*G0_0_0 + 0.0112874779541446*G0_0_2 + 0.0112874779541446*G0_1_0 + 0.0112874779541446*G0_1_2 + 0.0112874779541447*G0_2_1;
    A[544] = 0.0112874779541448*G0_0_1 + 0.0112874779541448*G0_0_2 + 0.0112874779541449*G0_1_1 + 0.0112874779541449*G0_1_2 + 0.0112874779541446*G0_2_0 - 0.0225749559082893*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[545] = 0.00282186948853619*G0_0_1 + 0.00282186948853621*G0_0_2 + 0.00282186948853617*G0_1_1 + 0.0028218694885362*G0_1_2 + 0.00282186948853601*G0_2_0 - 0.0112874779541446*G0_2_1 - 0.0112874779541446*G0_2_2;
    A[546] = 0.0112874779541448*G0_0_1 + 0.0112874779541448*G0_0_2 + 0.0112874779541448*G0_1_1 + 0.0112874779541448*G0_1_2 + 0.0112874779541447*G0_2_0;
    A[547] = 0.0225749559082894*G0_0_0 + 0.0225749559082894*G0_0_1 - 0.0112874779541446*G0_0_2 + 0.0225749559082894*G0_1_0 + 0.0225749559082893*G0_1_1 - 0.0112874779541447*G0_1_2 - 0.0112874779541448*G0_2_0 - 0.0112874779541444*G0_2_1;
    A[548] = 0.0225749559082891*G0_0_0 + 0.0225749559082891*G0_0_1 - 0.0112874779541449*G0_0_2 + 0.022574955908289*G0_1_0 + 0.0225749559082892*G0_1_1 - 0.0112874779541449*G0_1_2 - 0.0112874779541447*G0_2_0 - 0.0112874779541451*G0_2_1;
    A[549] = -0.112874779541446*G0_0_0 - 0.112874779541446*G0_0_1 - 0.0112874779541444*G0_0_2 - 0.112874779541446*G0_1_0 - 0.112874779541446*G0_1_1 - 0.0112874779541444*G0_1_2 - 0.0112874779541449*G0_2_0 - 0.0112874779541446*G0_2_1 - 0.0451499118165789*G0_2_2;
    A[550] = -0.0225749559082897*G0_0_0 - 0.0338624338624344*G0_0_2 - 0.0225749559082897*G0_1_0 - 0.0338624338624344*G0_1_2 + 0.0112874779541449*G0_2_0 - 0.0338624338624334*G0_2_1 + 0.067724867724868*G0_2_2;
    A[551] = -0.0225749559082891*G0_0_0 - 0.0338624338624339*G0_0_2 - 0.022574955908289*G0_1_0 - 0.0338624338624339*G0_1_2 + 0.0112874779541447*G0_2_0 - 0.0338624338624343*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[552] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_2 + 0.112874779541446*G0_1_0 + 0.101587301587302*G0_1_2 + 0.0112874779541449*G0_2_0 + 0.101587301587302*G0_2_1 - 0.0677248677248679*G0_2_2;
    A[553] = -0.0225749559082895*G0_0_1 - 0.0338624338624345*G0_0_2 - 0.0225749559082895*G0_1_1 - 0.0338624338624345*G0_1_2 - 0.0338624338624332*G0_2_0 + 0.011287477954145*G0_2_1 + 0.067724867724868*G0_2_2;
    A[554] = -0.0225749559082893*G0_0_1 - 0.0338624338624341*G0_0_2 - 0.0225749559082892*G0_1_1 - 0.0338624338624341*G0_1_2 - 0.0338624338624343*G0_2_0 + 0.0112874779541445*G0_2_1 + 0.0225749559082894*G0_2_2;
    A[555] = 0.112874779541446*G0_0_1 + 0.101587301587302*G0_0_2 + 0.112874779541446*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587301*G0_2_0 + 0.0112874779541446*G0_2_1 - 0.0677248677248682*G0_2_2;
    A[556] = 0.0112874779541447*G0_0_2 + 0.0112874779541448*G0_1_2 + 0.0112874779541449*G0_2_0 + 0.0112874779541448*G0_2_1 - 0.0451499118165782*G0_2_2;
    A[557] = 0.0112874779541448*G0_0_2 + 0.0112874779541449*G0_1_2 + 0.0112874779541443*G0_2_0 + 0.0112874779541447*G0_2_1;
    A[558] = 0.0112874779541448*G0_0_2 + 0.0112874779541448*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541444*G0_2_1;
    A[559] = 0.0902998236331571*G0_2_2;
    A[560] = -0.0246913580246912*G0_0_0 - 0.0246913580246912*G0_0_1 - 0.0246913580246912*G0_0_2 - 0.0705467372134042*G0_1_0 - 0.0705467372134042*G0_1_1 - 0.0705467372134042*G0_1_2 - 0.0246913580246912*G0_2_0 - 0.0246913580246912*G0_2_1 - 0.0246913580246912*G0_2_2;
    A[561] = 0.00776014109347446*G0_0_0 + 0.00776014109347445*G0_2_0;
    A[562] = -0.017636684303351*G0_0_1 - 0.0253968253968256*G0_1_1 - 0.017636684303351*G0_2_1;
    A[563] = 0.00776014109347441*G0_0_2 + 0.0077601410934744*G0_2_2;
    A[564] = -0.0338624338624339*G0_0_1 - 0.0451499118165787*G0_0_2 - 0.022574955908289*G0_1_1 - 0.033862433862434*G0_1_2 - 0.0338624338624339*G0_2_1 - 0.0451499118165787*G0_2_2;
    A[565] = -0.0141093474426808*G0_0_1 - 0.0169312169312168*G0_0_2 - 0.0112874779541447*G0_1_1 - 0.0141093474426806*G0_1_2 - 0.0141093474426808*G0_2_1 - 0.0169312169312168*G0_2_2;
    A[566] = -0.0112874779541448*G0_0_1 - 0.0225749559082894*G0_0_2 - 0.0112874779541446*G0_1_2 - 0.0112874779541447*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[567] = -0.0112874779541447*G0_0_0 - 0.0112874779541446*G0_0_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541446*G0_2_2;
    A[568] = -0.00282186948853615*G0_0_0 - 0.00282186948853634*G0_0_2 - 0.00282186948853623*G0_2_0 - 0.00282186948853637*G0_2_2;
    A[569] = -0.0112874779541448*G0_0_0 - 0.0112874779541446*G0_0_2 - 0.0112874779541447*G0_2_0 - 0.0112874779541446*G0_2_2;
    A[570] = -0.0225749559082894*G0_0_0 - 0.0112874779541447*G0_0_1 - 0.0112874779541445*G0_1_0 - 0.0225749559082893*G0_2_0 - 0.0112874779541447*G0_2_1;
    A[571] = -0.0169312169312166*G0_0_0 - 0.0141093474426806*G0_0_1 - 0.0141093474426804*G0_1_0 - 0.0112874779541446*G0_1_1 - 0.0169312169312165*G0_2_0 - 0.0141093474426805*G0_2_1;
    A[572] = -0.0451499118165787*G0_0_0 - 0.0338624338624338*G0_0_1 - 0.033862433862434*G0_1_0 - 0.022574955908289*G0_1_1 - 0.0451499118165787*G0_2_0 - 0.0338624338624339*G0_2_1;
    A[573] = 0.101587301587302*G0_0_0 + 0.101587301587302*G0_0_1 + 0.0225749559082889*G0_0_2 + 0.0225749559082888*G0_1_0 + 0.0225749559082888*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 + 0.022574955908289*G0_2_2;
    A[574] = -0.0423280423280428*G0_0_0 - 0.0423280423280427*G0_0_1 + 0.0169312169312171*G0_0_2 - 0.0112874779541444*G0_1_0 - 0.0112874779541444*G0_1_1 - 0.0423280423280425*G0_1_2 - 0.0423280423280428*G0_2_0 - 0.0423280423280427*G0_2_1 + 0.0169312169312171*G0_2_2;
    A[575] = 0.0112874779541447*G0_0_0 + 0.0112874779541448*G0_0_1 - 0.0225749559082893*G0_0_2 + 0.0112874779541446*G0_1_2 + 0.0112874779541447*G0_2_0 + 0.0112874779541447*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[576] = 0.203174603174603*G0_0_0 + 0.124162257495591*G0_0_1 + 0.203174603174603*G0_0_2 + 0.124162257495591*G0_1_0 + 0.203174603174604*G0_1_1 + 0.124162257495591*G0_1_2 + 0.203174603174603*G0_2_0 + 0.124162257495591*G0_2_1 + 0.203174603174603*G0_2_2;
    A[577] = -0.118518518518519*G0_0_0 - 0.16084656084656*G0_0_1 - 0.118518518518518*G0_0_2 - 0.0874779541446206*G0_1_0 - 0.22010582010582*G0_1_1 - 0.0874779541446206*G0_1_2 - 0.118518518518519*G0_2_0 - 0.160846560846561*G0_2_1 - 0.118518518518518*G0_2_2;
    A[578] = 0.0451499118165787*G0_0_0 + 0.0790123456790123*G0_0_1 + 0.0451499118165787*G0_0_2 + 0.033862433862434*G0_1_0 + 0.112874779541446*G0_1_1 + 0.033862433862434*G0_1_2 + 0.0451499118165787*G0_2_0 + 0.0790123456790123*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[579] = 0.0225749559082891*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587302*G0_1_0 + 0.0225749559082891*G0_1_1 + 0.0225749559082891*G0_1_2 + 0.0225749559082891*G0_2_0 + 0.101587301587302*G0_2_1 + 0.101587301587302*G0_2_2;
    A[580] = 0.016931216931217*G0_0_0 - 0.0423280423280422*G0_0_1 - 0.0423280423280423*G0_0_2 - 0.0423280423280428*G0_1_0 - 0.0112874779541445*G0_1_1 - 0.0112874779541445*G0_1_2 + 0.016931216931217*G0_2_0 - 0.0423280423280422*G0_2_1 - 0.0423280423280422*G0_2_2;
    A[581] = -0.0225749559082893*G0_0_0 + 0.0112874779541446*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.0112874779541449*G0_1_0 - 0.0225749559082893*G0_2_0 + 0.0112874779541446*G0_2_1 + 0.0112874779541446*G0_2_2;
    A[582] = -0.0225749559082895*G0_0_0 - 0.0112874779541449*G0_0_1 - 0.0225749559082892*G0_0_2 - 0.011287477954145*G0_1_0 - 0.0112874779541443*G0_1_2 - 0.0225749559082895*G0_2_0 - 0.0112874779541449*G0_2_1 - 0.0225749559082891*G0_2_2;
    A[583] = -0.0677248677248679*G0_0_0 - 0.0564373897707235*G0_0_1 - 0.0677248677248677*G0_0_2 - 0.0564373897707231*G0_1_0 - 0.045149911816579*G0_1_1 - 0.056437389770723*G0_1_2 - 0.0677248677248679*G0_2_0 - 0.0564373897707235*G0_2_1 - 0.0677248677248677*G0_2_2;
    A[584] = -0.0225749559082894*G0_0_0 - 0.0112874779541446*G0_0_1 - 0.0225749559082896*G0_0_2 - 0.011287477954145*G0_1_0 - 0.0112874779541455*G0_1_2 - 0.0225749559082893*G0_2_0 - 0.0112874779541446*G0_2_1 - 0.0225749559082897*G0_2_2;
    A[585] = -0.067724867724868*G0_0_0 - 0.169312169312169*G0_0_1 - 0.270899470899472*G0_0_2 - 0.0790123456790121*G0_1_0 - 0.067724867724867*G0_1_1 - 0.169312169312169*G0_1_2 - 0.067724867724868*G0_2_0 - 0.16931216931217*G0_2_1 - 0.270899470899472*G0_2_2;
    A[586] = 0.0677248677248679*G0_0_0 + 0.101587301587302*G0_0_1 + 0.135449735449736*G0_0_2 + 0.0564373897707231*G0_1_0 + 0.0677248677248673*G0_1_1 + 0.101587301587301*G0_1_2 + 0.067724867724868*G0_2_0 + 0.101587301587302*G0_2_1 + 0.135449735449736*G0_2_2;
    A[587] = 0.0225749559082893*G0_0_0 + 0.0564373897707235*G0_0_1 + 0.0902998236331572*G0_0_2 + 0.0112874779541449*G0_1_0 + 0.0225749559082891*G0_1_1 + 0.0564373897707227*G0_1_2 + 0.0225749559082892*G0_2_0 + 0.0564373897707234*G0_2_1 + 0.0902998236331572*G0_2_2;
    A[588] = -0.135449735449736*G0_0_0 - 0.0338624338624342*G0_0_1 - 0.135449735449736*G0_0_2 - 0.0338624338624333*G0_1_0 - 0.0451499118165783*G0_1_1 - 0.0338624338624337*G0_1_2 - 0.135449735449736*G0_2_0 - 0.0338624338624341*G0_2_1 - 0.135449735449736*G0_2_2;
    A[589] = 0.0451499118165786*G0_0_0 + 0.011287477954145*G0_0_1 + 0.0451499118165787*G0_0_2 + 0.0112874779541442*G0_1_0 + 0.0112874779541446*G0_1_2 + 0.0451499118165785*G0_2_0 + 0.011287477954145*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[590] = 0.0451499118165789*G0_0_0 + 0.0112874779541446*G0_0_1 + 0.0451499118165789*G0_0_2 + 0.0112874779541446*G0_1_0 + 0.0112874779541444*G0_1_2 + 0.045149911816579*G0_2_0 + 0.0112874779541447*G0_2_1 + 0.0451499118165789*G0_2_2;
    A[591] = -0.270899470899471*G0_0_0 - 0.16931216931217*G0_0_1 - 0.0677248677248675*G0_0_2 - 0.169312169312169*G0_1_0 - 0.0677248677248675*G0_1_1 - 0.0790123456790121*G0_1_2 - 0.270899470899471*G0_2_0 - 0.16931216931217*G0_2_1 - 0.0677248677248675*G0_2_2;
    A[592] = 0.090299823633157*G0_0_0 + 0.056437389770723*G0_0_1 + 0.0225749559082893*G0_0_2 + 0.0564373897707228*G0_1_0 + 0.0225749559082892*G0_1_1 + 0.0112874779541444*G0_1_2 + 0.090299823633157*G0_2_0 + 0.0564373897707229*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[593] = 0.135449735449735*G0_0_0 + 0.101587301587301*G0_0_1 + 0.0677248677248676*G0_0_2 + 0.101587301587301*G0_1_0 + 0.0677248677248674*G0_1_1 + 0.0564373897707229*G0_1_2 + 0.135449735449735*G0_2_0 + 0.101587301587301*G0_2_1 + 0.0677248677248675*G0_2_2;
    A[594] = 0.0902998236331576*G0_0_0 + 0.0902998236331575*G0_0_1 + 0.0902998236331571*G0_0_2 + 0.0902998236331572*G0_1_0 + 0.0902998236331573*G0_1_1 + 0.0902998236331576*G0_1_2 + 0.0902998236331576*G0_2_0 + 0.0902998236331574*G0_2_1 + 0.0902998236331571*G0_2_2;
    A[595] = 0.0202821869488536*G0_0_0 + 0.0202821869488535*G0_0_1 + 0.0202821869488536*G0_0_2 + 0.0529100529100531*G0_1_0 + 0.0529100529100531*G0_1_1 + 0.0529100529100531*G0_1_2 + 0.0202821869488536*G0_2_0 + 0.0202821869488535*G0_2_1 + 0.0202821869488536*G0_2_2;
    A[596] = 0.00511463844797175*G0_0_0 + 0.00511463844797175*G0_2_0;
    A[597] = 0.0326278659611995*G0_0_1 + 0.0529100529100532*G0_1_1 + 0.0326278659611995*G0_2_1;
    A[598] = 0.00511463844797173*G0_0_2 + 0.00511463844797174*G0_2_2;
    A[599] = 0.0592592592592594*G0_0_1 + 0.0902998236331577*G0_0_2 + 0.0169312169312167*G0_1_1 + 0.0592592592592596*G0_1_2 + 0.0592592592592594*G0_2_1 + 0.0902998236331577*G0_2_2;
    A[600] = 0.0105820105820105*G0_0_1 + 0.0211640211640205*G0_0_2 - 0.0028218694885361*G0_1_1 + 0.0105820105820101*G0_1_2 + 0.0105820105820105*G0_2_1 + 0.0211640211640206*G0_2_2;
    A[601] = -0.00282186948853619*G0_0_1 - 0.0169312169312168*G0_0_2 - 0.00282186948853612*G0_1_2 - 0.00282186948853617*G0_2_1 - 0.0169312169312168*G0_2_2;
    A[602] = -0.00282186948853622*G0_0_0 - 0.00282186948853608*G0_0_2 - 0.00282186948853617*G0_2_0 - 0.00282186948853603*G0_2_2;
    A[603] = -0.00917107583774225*G0_0_0 - 0.00917107583774249*G0_0_2 - 0.00917107583774232*G0_2_0 - 0.00917107583774253*G0_2_2;
    A[604] = -0.00282186948853622*G0_0_0 - 0.00282186948853609*G0_0_2 - 0.0028218694885362*G0_2_0 - 0.00282186948853608*G0_2_2;
    A[605] = -0.0169312169312167*G0_0_0 - 0.00282186948853603*G0_0_1 - 0.00282186948853613*G0_1_0 - 0.0169312169312166*G0_2_0 - 0.00282186948853599*G0_2_1;
    A[606] = 0.0211640211640205*G0_0_0 + 0.0105820105820103*G0_0_1 + 0.0105820105820101*G0_1_0 - 0.00282186948853616*G0_1_1 + 0.0211640211640204*G0_2_0 + 0.0105820105820102*G0_2_1;
    A[607] = 0.0902998236331576*G0_0_0 + 0.0592592592592594*G0_0_1 + 0.0592592592592596*G0_1_0 + 0.0169312169312167*G0_1_1 + 0.0902998236331576*G0_2_0 + 0.0592592592592594*G0_2_1;
    A[608] = -0.0423280423280423*G0_0_0 - 0.0423280423280423*G0_0_1 - 0.0112874779541445*G0_0_2 + 0.0169312169312174*G0_1_0 + 0.0169312169312173*G0_1_1 - 0.0423280423280426*G0_1_2 - 0.0423280423280422*G0_2_0 - 0.0423280423280423*G0_2_1 - 0.0112874779541445*G0_2_2;
    A[609] = -0.0134038800705467*G0_0_0 - 0.0134038800705468*G0_0_1 - 0.00282186948853613*G0_0_2 - 0.00282186948853641*G0_1_0 - 0.00282186948853637*G0_1_1 - 0.0134038800705466*G0_1_2 - 0.0134038800705467*G0_2_0 - 0.0134038800705468*G0_2_1 - 0.0028218694885361*G0_2_2;
    A[610] = 0.00282186948853622*G0_0_0 + 0.0028218694885362*G0_0_1 - 0.0112874779541446*G0_0_2 + 0.00282186948853616*G0_1_2 + 0.00282186948853619*G0_2_0 + 0.00282186948853617*G0_2_1 - 0.0112874779541446*G0_2_2;
    A[611] = -0.118518518518518*G0_0_0 - 0.0874779541446206*G0_0_1 - 0.118518518518518*G0_0_2 - 0.16084656084656*G0_1_0 - 0.22010582010582*G0_1_1 - 0.16084656084656*G0_1_2 - 0.118518518518518*G0_2_0 - 0.0874779541446206*G0_2_1 - 0.118518518518519*G0_2_2;
    A[612] = 0.24973544973545*G0_0_0 + 0.167195767195767*G0_0_1 + 0.24973544973545*G0_0_2 + 0.167195767195767*G0_1_0 + 0.334391534391535*G0_1_1 + 0.167195767195767*G0_1_2 + 0.24973544973545*G0_2_0 + 0.167195767195767*G0_2_1 + 0.24973544973545*G0_2_2;
    A[613] = -0.0902998236331576*G0_0_0 - 0.1326278659612*G0_0_1 - 0.0902998236331577*G0_0_2 - 0.0592592592592596*G0_1_0 - 0.220105820105821*G0_1_1 - 0.0592592592592596*G0_1_2 - 0.0902998236331577*G0_2_0 - 0.1326278659612*G0_2_1 - 0.0902998236331577*G0_2_2;
    A[614] = -0.0112874779541445*G0_0_0 - 0.0423280423280424*G0_0_1 - 0.0423280423280424*G0_0_2 - 0.0423280423280427*G0_1_0 + 0.0169312169312172*G0_1_1 + 0.0169312169312172*G0_1_2 - 0.0112874779541445*G0_2_0 - 0.0423280423280423*G0_2_1 - 0.0423280423280423*G0_2_2;
    A[615] = -0.00282186948853619*G0_0_0 - 0.0134038800705469*G0_0_1 - 0.0134038800705468*G0_0_2 - 0.0134038800705464*G0_1_0 - 0.00282186948853624*G0_1_1 - 0.00282186948853626*G0_1_2 - 0.00282186948853618*G0_2_0 - 0.0134038800705469*G0_2_1 - 0.0134038800705468*G0_2_2;
    A[616] = -0.0112874779541446*G0_0_0 + 0.00282186948853617*G0_0_1 + 0.00282186948853619*G0_0_2 + 0.00282186948853592*G0_1_0 - 0.0112874779541446*G0_2_0 + 0.00282186948853612*G0_2_1 + 0.00282186948853615*G0_2_2;
    A[617] = 0.016931216931217*G0_0_0 - 0.00282186948853603*G0_0_1 + 0.0169312169312168*G0_0_2 - 0.00282186948853567*G0_1_0 - 0.00282186948853633*G0_1_2 + 0.016931216931217*G0_2_0 - 0.00282186948853597*G0_2_1 + 0.0169312169312168*G0_2_2;
    A[618] = 0.0846560846560848*G0_0_0 + 0.0423280423280422*G0_0_1 + 0.0846560846560847*G0_0_2 + 0.0423280423280421*G0_1_0 + 0.0225749559082896*G0_1_1 + 0.0423280423280422*G0_1_2 + 0.0846560846560848*G0_2_0 + 0.0423280423280422*G0_2_1 + 0.0846560846560847*G0_2_2;
    A[619] = 0.0169312169312169*G0_0_0 - 0.00282186948853599*G0_0_1 + 0.0169312169312171*G0_0_2 - 0.00282186948853602*G0_1_0 - 0.00282186948853552*G0_1_2 + 0.0169312169312169*G0_2_0 - 0.00282186948853603*G0_2_1 + 0.0169312169312171*G0_2_2;
    A[620] = 0.118518518518518*G0_0_0 + 0.160846560846561*G0_0_1 + 0.0677248677248674*G0_0_2 + 0.025396825396825*G0_1_0 - 0.0169312169312177*G0_1_1 + 0.16084656084656*G0_1_2 + 0.118518518518518*G0_2_0 + 0.160846560846561*G0_2_1 + 0.0677248677248674*G0_2_2;
    A[621] = -0.0846560846560848*G0_0_0 - 0.177777777777778*G0_0_1 - 0.270899470899471*G0_0_2 - 0.0423280423280421*G0_1_0 - 0.0169312169312163*G0_1_1 - 0.177777777777777*G0_1_2 - 0.0846560846560848*G0_2_0 - 0.177777777777778*G0_2_1 - 0.270899470899471*G0_2_2;
    A[622] = -0.0169312169312168*G0_0_0 + 0.00282186948853631*G0_0_1 + 0.0677248677248682*G0_0_2 + 0.00282186948853606*G0_1_0 + 0.00564373897707248*G0_1_1 + 0.00282186948853666*G0_1_2 - 0.0169312169312168*G0_2_0 + 0.0028218694885363*G0_2_1 + 0.0677248677248682*G0_2_2;
    A[623] = 0.0225749559082894*G0_0_0 - 0.0197530864197531*G0_0_1 + 0.0225749559082892*G0_0_2 - 0.0197530864197536*G0_1_0 + 0.0225749559082891*G0_1_1 - 0.0197530864197534*G0_1_2 + 0.0225749559082893*G0_2_0 - 0.0197530864197531*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[624] = 0.0225749559082893*G0_0_0 + 0.00282186948853594*G0_0_1 + 0.0225749559082892*G0_0_2 + 0.00282186948853654*G0_1_0 + 0.00282186948853605*G0_1_2 + 0.0225749559082893*G0_2_0 + 0.00282186948853588*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[625] = 0.022574955908289*G0_0_0 + 0.00282186948853596*G0_0_1 + 0.0225749559082892*G0_0_2 + 0.00282186948853611*G0_1_0 + 0.00282186948853643*G0_1_2 + 0.022574955908289*G0_2_0 + 0.002821869488536*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[626] = 0.0677248677248675*G0_0_0 + 0.160846560846561*G0_0_1 + 0.118518518518518*G0_0_2 + 0.16084656084656*G0_1_0 - 0.0169312169312173*G0_1_1 + 0.0253968253968253*G0_1_2 + 0.0677248677248674*G0_2_0 + 0.160846560846561*G0_2_1 + 0.118518518518518*G0_2_2;
    A[627] = 0.0677248677248676*G0_0_0 + 0.00282186948853633*G0_0_1 - 0.016931216931217*G0_0_2 + 0.00282186948853634*G0_1_0 + 0.00564373897707231*G0_1_1 + 0.00282186948853621*G0_1_2 + 0.0677248677248677*G0_2_0 + 0.00282186948853639*G0_2_1 - 0.0169312169312171*G0_2_2;
    A[628] = -0.270899470899471*G0_0_0 - 0.177777777777778*G0_0_1 - 0.0846560846560846*G0_0_2 - 0.177777777777777*G0_1_0 - 0.0169312169312165*G0_1_1 - 0.0423280423280421*G0_1_2 - 0.270899470899471*G0_2_0 - 0.177777777777778*G0_2_1 - 0.0846560846560845*G0_2_2;
    A[629] = -0.135449735449735*G0_0_0 - 0.022574955908289*G0_0_1 - 0.135449735449736*G0_0_2 - 0.0225749559082894*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.0225749559082897*G0_1_2 - 0.135449735449736*G0_2_0 - 0.0225749559082889*G0_2_1 - 0.135449735449735*G0_2_2;
    A[630] = -0.00776014109347444*G0_0_0 - 0.00776014109347444*G0_0_1 - 0.00776014109347444*G0_0_2 - 0.0253968253968255*G0_1_0 - 0.0253968253968255*G0_1_1 - 0.0253968253968255*G0_1_2 - 0.00776014109347443*G0_2_0 - 0.00776014109347443*G0_2_1 - 0.00776014109347443*G0_2_2;
    A[631] = 0.00776014109347445*G0_0_0 + 0.00776014109347447*G0_2_0;
    A[632] = -0.0458553791887129*G0_0_1 - 0.0705467372134042*G0_1_1 - 0.0458553791887129*G0_2_1;
    A[633] = 0.00776014109347446*G0_0_2 + 0.00776014109347446*G0_2_2;
    A[634] = -0.0790123456790126*G0_0_1 - 0.158024691358026*G0_0_2 + 0.0225749559082893*G0_1_1 - 0.079012345679013*G0_1_2 - 0.0790123456790126*G0_2_1 - 0.158024691358026*G0_2_2;
    A[635] = 0.0310405643738979*G0_0_1 + 0.0902998236331577*G0_0_2 - 0.0112874779541446*G0_1_1 + 0.0310405643738983*G0_1_2 + 0.0310405643738979*G0_2_1 + 0.0902998236331577*G0_2_2;
    A[636] = -0.0112874779541446*G0_0_1 - 0.0451499118165786*G0_0_2 - 0.0112874779541446*G0_1_2 - 0.0112874779541447*G0_2_1 - 0.0451499118165786*G0_2_2;
    A[637] = -0.0112874779541446*G0_0_0 - 0.0112874779541448*G0_0_2 - 0.0112874779541447*G0_2_0 - 0.0112874779541448*G0_2_2;
    A[638] = -0.00282186948853616*G0_0_0 - 0.00282186948853598*G0_0_2 - 0.0028218694885361*G0_2_0 - 0.00282186948853597*G0_2_2;
    A[639] = -0.0112874779541446*G0_0_0 - 0.0112874779541446*G0_0_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541447*G0_2_2;
    A[640] = -0.0451499118165788*G0_0_0 - 0.0112874779541448*G0_0_1 - 0.0112874779541448*G0_1_0 - 0.0451499118165788*G0_2_0 - 0.0112874779541448*G0_2_1;
    A[641] = 0.0902998236331578*G0_0_0 + 0.031040564373898*G0_0_1 + 0.0310405643738983*G0_1_0 - 0.0112874779541445*G0_1_1 + 0.0902998236331579*G0_2_0 + 0.0310405643738981*G0_2_1;
    A[642] = -0.158024691358026*G0_0_0 - 0.0790123456790126*G0_0_1 - 0.0790123456790129*G0_1_0 + 0.0225749559082893*G0_1_1 - 0.158024691358026*G0_2_0 - 0.0790123456790126*G0_2_1;
    A[643] = 0.0112874779541446*G0_0_0 + 0.0112874779541446*G0_0_1 - 0.0225749559082895*G0_1_0 - 0.0225749559082894*G0_1_1 + 0.0112874779541449*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541446*G0_2_1;
    A[644] = 0.00282186948853633*G0_0_0 + 0.00282186948853629*G0_0_1 - 0.0112874779541444*G0_1_0 - 0.0112874779541445*G0_1_1 + 0.00282186948853593*G0_1_2 + 0.00282186948853632*G0_2_0 + 0.00282186948853628*G0_2_1;
    A[645] = 0.0112874779541446*G0_0_0 + 0.0112874779541446*G0_0_1 + 0.0112874779541447*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541446*G0_2_1;
    A[646] = 0.0451499118165787*G0_0_0 + 0.033862433862434*G0_0_1 + 0.0451499118165787*G0_0_2 + 0.0790123456790123*G0_1_0 + 0.112874779541446*G0_1_1 + 0.0790123456790123*G0_1_2 + 0.0451499118165787*G0_2_0 + 0.033862433862434*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[647] = -0.0902998236331576*G0_0_0 - 0.0592592592592596*G0_0_1 - 0.0902998236331576*G0_0_2 - 0.1326278659612*G0_1_0 - 0.220105820105821*G0_1_1 - 0.1326278659612*G0_1_2 - 0.0902998236331577*G0_2_0 - 0.0592592592592596*G0_2_1 - 0.0902998236331577*G0_2_2;
    A[648] = 0.158024691358026*G0_0_0 + 0.079012345679013*G0_0_1 + 0.158024691358026*G0_0_2 + 0.079012345679013*G0_1_0 + 0.203174603174604*G0_1_1 + 0.079012345679013*G0_1_2 + 0.158024691358026*G0_2_0 + 0.079012345679013*G0_2_1 + 0.158024691358026*G0_2_2;
    A[649] = 0.0112874779541447*G0_0_1 + 0.0112874779541447*G0_0_2 + 0.0112874779541448*G0_1_0 - 0.0225749559082895*G0_1_1 - 0.0225749559082894*G0_1_2 + 0.0112874779541447*G0_2_1 + 0.0112874779541447*G0_2_2;
    A[650] = 0.00282186948853617*G0_0_1 + 0.0028218694885361*G0_0_2 + 0.00282186948853601*G0_1_0 - 0.0112874779541446*G0_1_1 - 0.0112874779541446*G0_1_2 + 0.00282186948853621*G0_2_1 + 0.00282186948853614*G0_2_2;
    A[651] = 0.0112874779541447*G0_0_1 + 0.0112874779541447*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0112874779541447*G0_2_1 + 0.0112874779541447*G0_2_2;
    A[652] = 0.0225749559082894*G0_0_0 - 0.0112874779541446*G0_0_1 + 0.0225749559082895*G0_0_2 - 0.0112874779541448*G0_1_0 - 0.0112874779541445*G0_1_2 + 0.0225749559082894*G0_2_0 - 0.0112874779541446*G0_2_1 + 0.0225749559082895*G0_2_2;
    A[653] = -0.112874779541446*G0_0_0 - 0.0112874779541444*G0_0_1 - 0.112874779541446*G0_0_2 - 0.0112874779541444*G0_1_0 - 0.0451499118165784*G0_1_1 - 0.0112874779541445*G0_1_2 - 0.112874779541446*G0_2_0 - 0.0112874779541444*G0_2_1 - 0.112874779541446*G0_2_2;
    A[654] = 0.0225749559082896*G0_0_0 - 0.0112874779541444*G0_0_1 + 0.0225749559082894*G0_0_2 - 0.0112874779541445*G0_1_0 - 0.0112874779541447*G0_1_2 + 0.0225749559082896*G0_2_0 - 0.0112874779541444*G0_2_1 + 0.0225749559082895*G0_2_2;
    A[655] = -0.0225749559082887*G0_0_0 - 0.0338624338624338*G0_0_1 + 0.0112874779541451*G0_1_0 + 0.0677248677248681*G0_1_1 - 0.0338624338624333*G0_1_2 - 0.0225749559082887*G0_2_0 - 0.0338624338624338*G0_2_1;
    A[656] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_1 + 0.0112874779541444*G0_1_0 - 0.0677248677248681*G0_1_1 + 0.101587301587301*G0_1_2 + 0.112874779541446*G0_2_0 + 0.101587301587302*G0_2_1;
    A[657] = -0.0225749559082897*G0_0_0 - 0.0338624338624343*G0_0_1 + 0.0112874779541445*G0_1_0 + 0.0225749559082891*G0_1_1 - 0.0338624338624343*G0_1_2 - 0.0225749559082897*G0_2_0 - 0.0338624338624343*G0_2_1;
    A[658] = 0.0112874779541452*G0_0_1 + 0.0112874779541448*G0_1_0 - 0.0451499118165782*G0_1_1 + 0.0112874779541451*G0_1_2 + 0.0112874779541452*G0_2_1;
    A[659] = 0.0112874779541447*G0_0_1 + 0.0112874779541444*G0_1_0 + 0.0112874779541447*G0_1_2 + 0.0112874779541447*G0_2_1;
    A[660] = 0.0112874779541445*G0_0_1 + 0.0112874779541447*G0_1_0 + 0.0112874779541442*G0_1_2 + 0.0112874779541445*G0_2_1;
    A[661] = -0.033862433862434*G0_0_1 - 0.022574955908289*G0_0_2 - 0.0338624338624335*G0_1_0 + 0.067724867724868*G0_1_1 + 0.0112874779541447*G0_1_2 - 0.033862433862434*G0_2_1 - 0.0225749559082889*G0_2_2;
    A[662] = -0.033862433862434*G0_0_1 - 0.0225749559082891*G0_0_2 - 0.0338624338624339*G0_1_0 + 0.0225749559082892*G0_1_1 + 0.0112874779541447*G0_1_2 - 0.0338624338624341*G0_2_1 - 0.0225749559082892*G0_2_2;
    A[663] = 0.101587301587302*G0_0_1 + 0.112874779541446*G0_0_2 + 0.101587301587301*G0_1_0 - 0.0677248677248679*G0_1_1 + 0.0112874779541444*G0_1_2 + 0.101587301587302*G0_2_1 + 0.112874779541446*G0_2_2;
    A[664] = 0.0902998236331566*G0_1_1;
    A[665] = -0.0705467372134042*G0_0_0 - 0.0705467372134042*G0_0_1 - 0.0705467372134042*G0_0_2 - 0.0246913580246913*G0_1_0 - 0.0246913580246913*G0_1_1 - 0.0246913580246913*G0_1_2 - 0.0246913580246913*G0_2_0 - 0.0246913580246913*G0_2_1 - 0.0246913580246913*G0_2_2;
    A[666] = -0.0253968253968255*G0_0_0 - 0.017636684303351*G0_1_0 - 0.017636684303351*G0_2_0;
    A[667] = 0.00776014109347447*G0_1_1 + 0.00776014109347447*G0_2_1;
    A[668] = 0.0077601410934744*G0_1_2 + 0.00776014109347439*G0_2_2;
    A[669] = -0.0112874779541448*G0_1_1 - 0.0112874779541447*G0_1_2 - 0.0112874779541448*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[670] = -0.00282186948853615*G0_1_1 - 0.00282186948853622*G0_1_2 - 0.00282186948853612*G0_2_1 - 0.00282186948853618*G0_2_2;
    A[671] = -0.0112874779541449*G0_1_1 - 0.0112874779541448*G0_1_2 - 0.0112874779541449*G0_2_1 - 0.0112874779541448*G0_2_2;
    A[672] = -0.022574955908289*G0_0_0 - 0.0338624338624339*G0_0_2 - 0.033862433862434*G0_1_0 - 0.0451499118165786*G0_1_2 - 0.0338624338624339*G0_2_0 - 0.0451499118165786*G0_2_2;
    A[673] = -0.0112874779541447*G0_0_0 - 0.0141093474426807*G0_0_2 - 0.0141093474426807*G0_1_0 - 0.016931216931217*G0_1_2 - 0.0141093474426808*G0_2_0 - 0.016931216931217*G0_2_2;
    A[674] = -0.0112874779541446*G0_0_2 - 0.0112874779541449*G0_1_0 - 0.0225749559082894*G0_1_2 - 0.0112874779541449*G0_2_0 - 0.0225749559082894*G0_2_2;
    A[675] = -0.022574955908289*G0_0_0 - 0.0338624338624339*G0_0_1 - 0.0338624338624339*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.0338624338624339*G0_2_0 - 0.0451499118165787*G0_2_1;
    A[676] = -0.0112874779541446*G0_0_0 - 0.0141093474426807*G0_0_1 - 0.0141093474426807*G0_1_0 - 0.0169312169312166*G0_1_1 - 0.0141093474426807*G0_2_0 - 0.0169312169312167*G0_2_1;
    A[677] = -0.0112874779541446*G0_0_1 - 0.0112874779541447*G0_1_0 - 0.0225749559082894*G0_1_1 - 0.0112874779541447*G0_2_0 - 0.0225749559082894*G0_2_1;
    A[678] = 0.022574955908289*G0_0_0 + 0.022574955908289*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587302*G0_1_0 + 0.101587301587302*G0_1_1 + 0.0225749559082891*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 + 0.0225749559082891*G0_2_2;
    A[679] = -0.0112874779541445*G0_0_0 - 0.0112874779541444*G0_0_1 - 0.0423280423280426*G0_0_2 - 0.0423280423280428*G0_1_0 - 0.0423280423280428*G0_1_1 + 0.016931216931217*G0_1_2 - 0.0423280423280428*G0_2_0 - 0.0423280423280428*G0_2_1 + 0.016931216931217*G0_2_2;
    A[680] = 0.0112874779541446*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0112874779541449*G0_1_1 - 0.0225749559082893*G0_1_2 + 0.0112874779541448*G0_2_0 + 0.0112874779541449*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[681] = 0.0225749559082891*G0_0_0 + 0.101587301587302*G0_0_1 + 0.0225749559082891*G0_0_2 + 0.101587301587302*G0_1_0 + 0.0225749559082891*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587302*G0_2_0 + 0.0225749559082891*G0_2_1 + 0.101587301587302*G0_2_2;
    A[682] = -0.0112874779541445*G0_0_0 - 0.0423280423280427*G0_0_1 - 0.0112874779541445*G0_0_2 - 0.0423280423280424*G0_1_0 + 0.0169312169312172*G0_1_1 - 0.0423280423280423*G0_1_2 - 0.0423280423280424*G0_2_0 + 0.0169312169312172*G0_2_1 - 0.0423280423280423*G0_2_2;
    A[683] = 0.0112874779541448*G0_0_1 + 0.0112874779541447*G0_1_0 - 0.0225749559082895*G0_1_1 + 0.0112874779541447*G0_1_2 + 0.0112874779541447*G0_2_0 - 0.0225749559082894*G0_2_1 + 0.0112874779541447*G0_2_2;
    A[684] = 0.203174603174604*G0_0_0 + 0.124162257495591*G0_0_1 + 0.124162257495591*G0_0_2 + 0.124162257495591*G0_1_0 + 0.203174603174604*G0_1_1 + 0.203174603174604*G0_1_2 + 0.124162257495591*G0_2_0 + 0.203174603174604*G0_2_1 + 0.203174603174604*G0_2_2;
    A[685] = -0.220105820105821*G0_0_0 - 0.0874779541446208*G0_0_1 - 0.0874779541446208*G0_0_2 - 0.160846560846561*G0_1_0 - 0.118518518518518*G0_1_1 - 0.118518518518519*G0_1_2 - 0.160846560846561*G0_2_0 - 0.118518518518519*G0_2_1 - 0.118518518518519*G0_2_2;
    A[686] = 0.112874779541447*G0_0_0 + 0.0338624338624339*G0_0_1 + 0.0338624338624339*G0_0_2 + 0.0790123456790124*G0_1_0 + 0.0451499118165787*G0_1_1 + 0.0451499118165787*G0_1_2 + 0.0790123456790124*G0_2_0 + 0.0451499118165786*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[687] = -0.0451499118165789*G0_0_0 - 0.0564373897707228*G0_0_1 - 0.0564373897707228*G0_0_2 - 0.0564373897707233*G0_1_0 - 0.0677248677248679*G0_1_1 - 0.0677248677248676*G0_1_2 - 0.0564373897707233*G0_2_0 - 0.0677248677248678*G0_2_1 - 0.0677248677248676*G0_2_2;
    A[688] = -0.0112874779541452*G0_0_1 - 0.0112874779541447*G0_0_2 - 0.011287477954145*G0_1_0 - 0.0225749559082896*G0_1_1 - 0.0225749559082894*G0_1_2 - 0.011287477954145*G0_2_0 - 0.0225749559082896*G0_2_1 - 0.0225749559082895*G0_2_2;
    A[689] = -0.011287477954145*G0_0_1 - 0.0112874779541454*G0_0_2 - 0.0112874779541448*G0_1_0 - 0.0225749559082893*G0_1_1 - 0.0225749559082896*G0_1_2 - 0.0112874779541448*G0_2_0 - 0.0225749559082893*G0_2_1 - 0.0225749559082896*G0_2_2;
    A[690] = -0.0451499118165784*G0_0_0 - 0.0338624338624336*G0_0_1 - 0.0338624338624336*G0_0_2 - 0.0338624338624343*G0_1_0 - 0.135449735449736*G0_1_1 - 0.135449735449736*G0_1_2 - 0.0338624338624343*G0_2_0 - 0.135449735449736*G0_2_1 - 0.135449735449736*G0_2_2;
    A[691] = 0.0112874779541444*G0_0_1 + 0.0112874779541445*G0_0_2 + 0.011287477954145*G0_1_0 + 0.0451499118165788*G0_1_1 + 0.0451499118165788*G0_1_2 + 0.011287477954145*G0_2_0 + 0.0451499118165787*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[692] = 0.0112874779541445*G0_0_1 + 0.0112874779541445*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0451499118165789*G0_1_1 + 0.0451499118165789*G0_1_2 + 0.0112874779541447*G0_2_0 + 0.0451499118165789*G0_2_1 + 0.0451499118165789*G0_2_2;
    A[693] = -0.0677248677248674*G0_0_0 - 0.0790123456790122*G0_0_1 - 0.169312169312169*G0_0_2 - 0.16931216931217*G0_1_0 - 0.0677248677248681*G0_1_1 - 0.270899470899472*G0_1_2 - 0.16931216931217*G0_2_0 - 0.0677248677248681*G0_2_1 - 0.270899470899472*G0_2_2;
    A[694] = 0.0677248677248673*G0_0_0 + 0.0564373897707228*G0_0_1 + 0.101587301587301*G0_0_2 + 0.101587301587302*G0_1_0 + 0.067724867724868*G0_1_1 + 0.135449735449735*G0_1_2 + 0.101587301587302*G0_2_0 + 0.0677248677248679*G0_2_1 + 0.135449735449736*G0_2_2;
    A[695] = 0.0225749559082892*G0_0_0 + 0.0112874779541451*G0_0_1 + 0.056437389770723*G0_0_2 + 0.0564373897707235*G0_1_0 + 0.0225749559082893*G0_1_1 + 0.0902998236331576*G0_1_2 + 0.0564373897707235*G0_2_0 + 0.0225749559082894*G0_2_1 + 0.0902998236331575*G0_2_2;
    A[696] = -0.0677248677248674*G0_0_0 - 0.169312169312169*G0_0_1 - 0.0790123456790121*G0_0_2 - 0.16931216931217*G0_1_0 - 0.270899470899471*G0_1_1 - 0.0677248677248675*G0_1_2 - 0.16931216931217*G0_2_0 - 0.270899470899471*G0_2_1 - 0.0677248677248675*G0_2_2;
    A[697] = 0.0677248677248673*G0_0_0 + 0.101587301587301*G0_0_1 + 0.0564373897707228*G0_0_2 + 0.101587301587302*G0_1_0 + 0.135449735449735*G0_1_1 + 0.0677248677248677*G0_1_2 + 0.101587301587302*G0_2_0 + 0.135449735449735*G0_2_1 + 0.0677248677248676*G0_2_2;
    A[698] = 0.0225749559082891*G0_0_0 + 0.056437389770723*G0_0_1 + 0.0112874779541447*G0_0_2 + 0.056437389770723*G0_1_0 + 0.0902998236331571*G0_1_1 + 0.0225749559082893*G0_1_2 + 0.0564373897707231*G0_2_0 + 0.090299823633157*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[699] = 0.0902998236331574*G0_0_0 + 0.0902998236331573*G0_0_1 + 0.0902998236331575*G0_0_2 + 0.0902998236331577*G0_1_0 + 0.0902998236331576*G0_1_1 + 0.0902998236331571*G0_1_2 + 0.0902998236331577*G0_2_0 + 0.0902998236331576*G0_2_1 + 0.0902998236331572*G0_2_2;
    A[700] = 0.0529100529100532*G0_0_0 + 0.0529100529100532*G0_0_1 + 0.0529100529100532*G0_0_2 + 0.0202821869488536*G0_1_0 + 0.0202821869488536*G0_1_1 + 0.0202821869488536*G0_1_2 + 0.0202821869488535*G0_2_0 + 0.0202821869488536*G0_2_1 + 0.0202821869488536*G0_2_2;
    A[701] = 0.0529100529100531*G0_0_0 + 0.0326278659611995*G0_1_0 + 0.0326278659611995*G0_2_0;
    A[702] = 0.0051146384479718*G0_1_1 + 0.0051146384479718*G0_2_1;
    A[703] = 0.00511463844797175*G0_1_2 + 0.00511463844797175*G0_2_2;
    A[704] = -0.00282186948853621*G0_1_1 - 0.00282186948853615*G0_1_2 - 0.00282186948853615*G0_2_1 - 0.00282186948853608*G0_2_2;
    A[705] = -0.00917107583774254*G0_1_1 - 0.00917107583774259*G0_1_2 - 0.00917107583774254*G0_2_1 - 0.00917107583774262*G0_2_2;
    A[706] = -0.00282186948853618*G0_1_1 - 0.00282186948853617*G0_1_2 - 0.0028218694885362*G0_2_1 - 0.00282186948853618*G0_2_2;
    A[707] = 0.0169312169312167*G0_0_0 + 0.0592592592592595*G0_0_2 + 0.059259259259259*G0_1_0 + 0.0902998236331573*G0_1_2 + 0.059259259259259*G0_2_0 + 0.0902998236331573*G0_2_2;
    A[708] = -0.00282186948853612*G0_0_0 + 0.0105820105820102*G0_0_2 + 0.0105820105820106*G0_1_0 + 0.0211640211640209*G0_1_2 + 0.0105820105820107*G0_2_0 + 0.0211640211640209*G0_2_2;
    A[709] = -0.002821869488536*G0_0_2 - 0.00282186948853616*G0_1_0 - 0.0169312169312168*G0_1_2 - 0.00282186948853618*G0_2_0 - 0.0169312169312168*G0_2_2;
    A[710] = 0.0169312169312168*G0_0_0 + 0.0592592592592595*G0_0_1 + 0.0592592592592591*G0_1_0 + 0.0902998236331574*G0_1_1 + 0.0592592592592592*G0_2_0 + 0.0902998236331574*G0_2_1;
    A[711] = -0.00282186948853615*G0_0_0 + 0.0105820105820103*G0_0_1 + 0.0105820105820105*G0_1_0 + 0.0211640211640207*G0_1_1 + 0.0105820105820105*G0_2_0 + 0.0211640211640207*G0_2_1;
    A[712] = -0.00282186948853594*G0_0_1 - 0.00282186948853616*G0_1_0 - 0.0169312169312169*G0_1_1 - 0.00282186948853609*G0_2_0 - 0.0169312169312168*G0_2_1;
    A[713] = 0.0169312169312171*G0_0_0 + 0.016931216931217*G0_0_1 - 0.0423280423280429*G0_0_2 - 0.0423280423280423*G0_1_0 - 0.0423280423280422*G0_1_1 - 0.0112874779541446*G0_1_2 - 0.0423280423280423*G0_2_0 - 0.0423280423280422*G0_2_1 - 0.0112874779541446*G0_2_2;
    A[714] = -0.00282186948853629*G0_0_0 - 0.00282186948853628*G0_0_1 - 0.0134038800705463*G0_0_2 - 0.0134038800705468*G0_1_0 - 0.0134038800705467*G0_1_1 - 0.00282186948853607*G0_1_2 - 0.0134038800705468*G0_2_0 - 0.0134038800705468*G0_2_1 - 0.00282186948853606*G0_2_2;
    A[715] = 0.00282186948853601*G0_0_2 + 0.00282186948853619*G0_1_0 + 0.00282186948853617*G0_1_1 - 0.0112874779541446*G0_1_2 + 0.00282186948853621*G0_2_0 + 0.0028218694885362*G0_2_1 - 0.0112874779541446*G0_2_2;
    A[716] = 0.016931216931217*G0_0_0 - 0.0423280423280428*G0_0_1 + 0.016931216931217*G0_0_2 - 0.0423280423280422*G0_1_0 - 0.0112874779541445*G0_1_1 - 0.0423280423280422*G0_1_2 - 0.0423280423280423*G0_2_0 - 0.0112874779541445*G0_2_1 - 0.0423280423280422*G0_2_2;
    A[717] = -0.00282186948853619*G0_0_0 - 0.0134038800705464*G0_0_1 - 0.00282186948853618*G0_0_2 - 0.0134038800705469*G0_1_0 - 0.00282186948853623*G0_1_1 - 0.0134038800705469*G0_1_2 - 0.0134038800705468*G0_2_0 - 0.00282186948853626*G0_2_1 - 0.0134038800705468*G0_2_2;
    A[718] = 0.002821869488536*G0_0_1 + 0.00282186948853617*G0_1_0 - 0.0112874779541446*G0_1_1 + 0.00282186948853621*G0_1_2 + 0.0028218694885361*G0_2_0 - 0.0112874779541446*G0_2_1 + 0.00282186948853614*G0_2_2;
    A[719] = -0.220105820105821*G0_0_0 - 0.160846560846561*G0_0_1 - 0.160846560846561*G0_0_2 - 0.0874779541446208*G0_1_0 - 0.118518518518518*G0_1_1 - 0.118518518518519*G0_1_2 - 0.0874779541446208*G0_2_0 - 0.118518518518519*G0_2_1 - 0.118518518518519*G0_2_2;
    A[720] = 0.334391534391535*G0_0_0 + 0.167195767195767*G0_0_1 + 0.167195767195767*G0_0_2 + 0.167195767195767*G0_1_0 + 0.24973544973545*G0_1_1 + 0.24973544973545*G0_1_2 + 0.167195767195767*G0_2_0 + 0.24973544973545*G0_2_1 + 0.24973544973545*G0_2_2;
    A[721] = -0.220105820105821*G0_0_0 - 0.0592592592592595*G0_0_1 - 0.0592592592592596*G0_0_2 - 0.1326278659612*G0_1_0 - 0.0902998236331573*G0_1_1 - 0.0902998236331574*G0_1_2 - 0.1326278659612*G0_2_0 - 0.0902998236331574*G0_2_1 - 0.0902998236331574*G0_2_2;
    A[722] = 0.0225749559082893*G0_0_0 + 0.0423280423280419*G0_0_1 + 0.0423280423280419*G0_0_2 + 0.0423280423280421*G0_1_0 + 0.084656084656084*G0_1_1 + 0.0846560846560842*G0_1_2 + 0.0423280423280421*G0_2_0 + 0.084656084656084*G0_2_1 + 0.0846560846560842*G0_2_2;
    A[723] = -0.00282186948853573*G0_0_1 - 0.00282186948853577*G0_0_2 - 0.00282186948853616*G0_1_0 + 0.0169312169312171*G0_1_1 + 0.016931216931217*G0_1_2 - 0.00282186948853613*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[724] = -0.00282186948853587*G0_0_1 - 0.00282186948853582*G0_0_2 - 0.00282186948853605*G0_1_0 + 0.0169312169312171*G0_1_1 + 0.016931216931217*G0_1_2 - 0.00282186948853608*G0_2_0 + 0.0169312169312171*G0_2_1 + 0.0169312169312171*G0_2_2;
    A[725] = 0.022574955908289*G0_0_0 - 0.0197530864197533*G0_0_1 - 0.0197530864197533*G0_0_2 - 0.0197530864197535*G0_1_0 + 0.0225749559082888*G0_1_1 + 0.0225749559082891*G0_1_2 - 0.0197530864197535*G0_2_0 + 0.0225749559082889*G0_2_1 + 0.0225749559082891*G0_2_2;
    A[726] = 0.00282186948853627*G0_0_1 + 0.00282186948853625*G0_0_2 + 0.00282186948853618*G0_1_0 + 0.0225749559082896*G0_1_1 + 0.0225749559082894*G0_1_2 + 0.00282186948853615*G0_2_0 + 0.0225749559082894*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[727] = 0.00282186948853634*G0_0_1 + 0.00282186948853632*G0_0_2 + 0.00282186948853608*G0_1_0 + 0.0225749559082893*G0_1_1 + 0.0225749559082893*G0_1_2 + 0.00282186948853611*G0_2_0 + 0.0225749559082893*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[728] = -0.0169312169312171*G0_0_0 + 0.0253968253968251*G0_0_1 + 0.16084656084656*G0_0_2 + 0.160846560846561*G0_1_0 + 0.118518518518518*G0_1_1 + 0.0677248677248675*G0_1_2 + 0.160846560846561*G0_2_0 + 0.118518518518518*G0_2_1 + 0.0677248677248675*G0_2_2;
    A[729] = -0.0169312169312166*G0_0_0 - 0.0423280423280418*G0_0_1 - 0.177777777777778*G0_0_2 - 0.177777777777777*G0_1_0 - 0.084656084656084*G0_1_1 - 0.270899470899471*G0_1_2 - 0.177777777777777*G0_2_0 - 0.0846560846560841*G0_2_1 - 0.270899470899471*G0_2_2;
    A[730] = 0.00564373897707242*G0_0_0 + 0.00282186948853587*G0_0_1 + 0.00282186948853634*G0_0_2 + 0.00282186948853617*G0_1_0 - 0.0169312169312171*G0_1_1 + 0.0677248677248679*G0_1_2 + 0.00282186948853616*G0_2_0 - 0.0169312169312171*G0_2_1 + 0.0677248677248679*G0_2_2;
    A[731] = -0.0169312169312172*G0_0_0 + 0.16084656084656*G0_0_1 + 0.0253968253968251*G0_0_2 + 0.160846560846561*G0_1_0 + 0.0677248677248673*G0_1_1 + 0.118518518518518*G0_1_2 + 0.160846560846561*G0_2_0 + 0.0677248677248674*G0_2_1 + 0.118518518518518*G0_2_2;
    A[732] = -0.0169312169312166*G0_0_0 - 0.177777777777778*G0_0_1 - 0.0423280423280419*G0_0_2 - 0.177777777777778*G0_1_0 - 0.270899470899471*G0_1_1 - 0.0846560846560841*G0_1_2 - 0.177777777777778*G0_2_0 - 0.270899470899471*G0_2_1 - 0.0846560846560841*G0_2_2;
    A[733] = 0.00564373897707234*G0_0_0 + 0.00282186948853616*G0_0_1 + 0.00282186948853582*G0_0_2 + 0.00282186948853632*G0_1_0 + 0.0677248677248681*G0_1_1 - 0.0169312169312168*G0_1_2 + 0.0028218694885363*G0_2_0 + 0.0677248677248679*G0_2_1 - 0.0169312169312168*G0_2_2;
    A[734] = -0.0451499118165784*G0_0_0 - 0.0225749559082894*G0_0_1 - 0.0225749559082894*G0_0_2 - 0.0225749559082888*G0_1_0 - 0.135449735449735*G0_1_1 - 0.135449735449735*G0_1_2 - 0.0225749559082887*G0_2_0 - 0.135449735449735*G0_2_1 - 0.135449735449735*G0_2_2;
    A[735] = -0.0253968253968256*G0_0_0 - 0.0253968253968256*G0_0_1 - 0.0253968253968256*G0_0_2 - 0.0077601410934744*G0_1_0 - 0.00776014109347441*G0_1_1 - 0.0077601410934744*G0_1_2 - 0.00776014109347439*G0_2_0 - 0.00776014109347439*G0_2_1 - 0.00776014109347439*G0_2_2;
    A[736] = -0.0705467372134042*G0_0_0 - 0.0458553791887129*G0_1_0 - 0.0458553791887129*G0_2_0;
    A[737] = 0.00776014109347442*G0_1_1 + 0.00776014109347443*G0_2_1;
    A[738] = 0.00776014109347453*G0_1_2 + 0.00776014109347454*G0_2_2;
    A[739] = -0.0112874779541446*G0_1_1 - 0.0112874779541447*G0_1_2 - 0.0112874779541446*G0_2_1 - 0.0112874779541447*G0_2_2;
    A[740] = -0.00282186948853617*G0_1_1 - 0.002821869488536*G0_1_2 - 0.0028218694885362*G0_2_1 - 0.00282186948853601*G0_2_2;
    A[741] = -0.0112874779541448*G0_1_1 - 0.0112874779541449*G0_1_2 - 0.0112874779541448*G0_2_1 - 0.0112874779541449*G0_2_2;
    A[742] = 0.0225749559082893*G0_0_0 - 0.0790123456790129*G0_0_2 - 0.0790123456790124*G0_1_0 - 0.158024691358026*G0_1_2 - 0.0790123456790124*G0_2_0 - 0.158024691358026*G0_2_2;
    A[743] = -0.0112874779541446*G0_0_0 + 0.0310405643738983*G0_0_2 + 0.0310405643738979*G0_1_0 + 0.0902998236331578*G0_1_2 + 0.0310405643738979*G0_2_0 + 0.0902998236331578*G0_2_2;
    A[744] = -0.0112874779541449*G0_0_2 - 0.0112874779541448*G0_1_0 - 0.0451499118165791*G0_1_2 - 0.0112874779541448*G0_2_0 - 0.045149911816579*G0_2_2;
    A[745] = 0.0225749559082892*G0_0_0 - 0.079012345679013*G0_0_1 - 0.0790123456790125*G0_1_0 - 0.158024691358026*G0_1_1 - 0.0790123456790125*G0_2_0 - 0.158024691358026*G0_2_1;
    A[746] = -0.0112874779541446*G0_0_0 + 0.0310405643738982*G0_0_1 + 0.0310405643738979*G0_1_0 + 0.0902998236331577*G0_1_1 + 0.0310405643738979*G0_2_0 + 0.0902998236331577*G0_2_1;
    A[747] = -0.0112874779541448*G0_0_1 - 0.0112874779541447*G0_1_0 - 0.0451499118165788*G0_1_1 - 0.0112874779541447*G0_2_0 - 0.0451499118165788*G0_2_1;
    A[748] = -0.0225749559082894*G0_0_0 - 0.0225749559082894*G0_0_1 + 0.0112874779541449*G0_0_2 + 0.0112874779541445*G0_1_0 + 0.0112874779541445*G0_1_1 + 0.0112874779541445*G0_2_0 + 0.0112874779541445*G0_2_1;
    A[749] = -0.0112874779541444*G0_0_0 - 0.0112874779541444*G0_0_1 + 0.00282186948853591*G0_0_2 + 0.00282186948853618*G0_1_0 + 0.00282186948853613*G0_1_1 + 0.00282186948853619*G0_2_0 + 0.00282186948853614*G0_2_1;
    A[750] = 0.0112874779541447*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0112874779541448*G0_1_1 + 0.0112874779541448*G0_2_0 + 0.0112874779541448*G0_2_1;
    A[751] = -0.0225749559082893*G0_0_0 + 0.0112874779541449*G0_0_1 - 0.0225749559082893*G0_0_2 + 0.0112874779541446*G0_1_0 + 0.0112874779541446*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541446*G0_2_2;
    A[752] = -0.0112874779541446*G0_0_0 + 0.00282186948853593*G0_0_1 - 0.0112874779541446*G0_0_2 + 0.00282186948853617*G0_1_0 + 0.00282186948853612*G0_1_2 + 0.00282186948853619*G0_2_0 + 0.00282186948853615*G0_2_2;
    A[753] = 0.0112874779541448*G0_0_1 + 0.0112874779541447*G0_1_0 + 0.0112874779541447*G0_1_2 + 0.0112874779541447*G0_2_0 + 0.0112874779541447*G0_2_2;
    A[754] = 0.112874779541447*G0_0_0 + 0.0790123456790124*G0_0_1 + 0.0790123456790124*G0_0_2 + 0.0338624338624339*G0_1_0 + 0.0451499118165787*G0_1_1 + 0.0451499118165786*G0_1_2 + 0.0338624338624339*G0_2_0 + 0.0451499118165787*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[755] = -0.220105820105821*G0_0_0 - 0.1326278659612*G0_0_1 - 0.1326278659612*G0_0_2 - 0.0592592592592595*G0_1_0 - 0.0902998236331573*G0_1_1 - 0.0902998236331573*G0_1_2 - 0.0592592592592595*G0_2_0 - 0.0902998236331574*G0_2_1 - 0.0902998236331574*G0_2_2;
    A[756] = 0.203174603174604*G0_0_0 + 0.079012345679013*G0_0_1 + 0.079012345679013*G0_0_2 + 0.079012345679013*G0_1_0 + 0.158024691358026*G0_1_1 + 0.158024691358026*G0_1_2 + 0.079012345679013*G0_2_0 + 0.158024691358026*G0_2_1 + 0.158024691358025*G0_2_2;
    A[757] = -0.0451499118165785*G0_0_0 - 0.0112874779541443*G0_0_1 - 0.0112874779541446*G0_0_2 - 0.0112874779541445*G0_1_0 - 0.112874779541446*G0_1_1 - 0.112874779541446*G0_1_2 - 0.0112874779541444*G0_2_0 - 0.112874779541446*G0_2_1 - 0.112874779541446*G0_2_2;
    A[758] = -0.0112874779541448*G0_0_1 - 0.0112874779541448*G0_0_2 - 0.0112874779541446*G0_1_0 + 0.0225749559082893*G0_1_1 + 0.0225749559082893*G0_1_2 - 0.0112874779541446*G0_2_0 + 0.0225749559082893*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[759] = -0.0112874779541449*G0_0_1 - 0.0112874779541448*G0_0_2 - 0.0112874779541451*G0_1_0 + 0.022574955908289*G0_1_1 + 0.0225749559082891*G0_1_2 - 0.0112874779541451*G0_2_0 + 0.022574955908289*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[760] = -0.0451499118165782*G0_0_0 + 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.0112874779541448*G0_1_0 + 0.0112874779541448*G0_2_0;
    A[761] = 0.0112874779541444*G0_0_1 + 0.0112874779541445*G0_0_2 + 0.0112874779541446*G0_1_0 + 0.0112874779541446*G0_2_0;
    A[762] = 0.0112874779541444*G0_0_1 + 0.0112874779541444*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_0;
    A[763] = 0.0677248677248679*G0_0_0 + 0.0112874779541449*G0_0_1 - 0.0338624338624334*G0_0_2 - 0.0338624338624336*G0_1_0 - 0.0225749559082891*G0_1_1 - 0.0338624338624336*G0_2_0 - 0.0225749559082891*G0_2_1;
    A[764] = -0.0677248677248679*G0_0_0 + 0.0112874779541442*G0_0_1 + 0.101587301587301*G0_0_2 + 0.101587301587302*G0_1_0 + 0.112874779541446*G0_1_1 + 0.101587301587302*G0_2_0 + 0.112874779541446*G0_2_1;
    A[765] = 0.0225749559082891*G0_0_0 + 0.0112874779541449*G0_0_1 - 0.0338624338624341*G0_0_2 - 0.0338624338624341*G0_1_0 - 0.022574955908289*G0_1_1 - 0.0338624338624341*G0_2_0 - 0.022574955908289*G0_2_1;
    A[766] = 0.0677248677248678*G0_0_0 - 0.0338624338624335*G0_0_1 + 0.0112874779541448*G0_0_2 - 0.0338624338624337*G0_1_0 - 0.0225749559082891*G0_1_2 - 0.0338624338624338*G0_2_0 - 0.0225749559082891*G0_2_2;
    A[767] = -0.0677248677248677*G0_0_0 + 0.101587301587302*G0_0_1 + 0.0112874779541445*G0_0_2 + 0.101587301587302*G0_1_0 + 0.112874779541446*G0_1_2 + 0.101587301587302*G0_2_0 + 0.112874779541446*G0_2_2;
    A[768] = 0.0225749559082892*G0_0_0 - 0.033862433862434*G0_0_1 + 0.0112874779541448*G0_0_2 - 0.033862433862434*G0_1_0 - 0.0225749559082894*G0_1_2 - 0.033862433862434*G0_2_0 - 0.0225749559082893*G0_2_2;
    A[769] = 0.0902998236331566*G0_0_0;
    A[770] = 0.0183421516754852*G0_0_0 + 0.0183421516754852*G0_0_1 + 0.0183421516754852*G0_0_2 + 0.0183421516754849*G0_1_0 + 0.0183421516754848*G0_1_1 + 0.0183421516754849*G0_1_2 + 0.0183421516754849*G0_2_0 + 0.0183421516754848*G0_2_1 + 0.0183421516754848*G0_2_2;
    A[771] = 0.0493827160493828*G0_0_0 + 0.00705467372134029*G0_1_0 + 0.0070546737213405*G0_2_0;
    A[772] = 0.00705467372134047*G0_0_1 - 0.0183421516754849*G0_1_1 + 0.00705467372134043*G0_2_1;
    A[773] = 0.00705467372134042*G0_0_2 + 0.00705467372134033*G0_1_2 - 0.0183421516754851*G0_2_2;
    A[774] = -0.0677248677248677*G0_0_1 - 0.0225749559082894*G0_0_2 + 0.0225749559082892*G0_1_1 + 0.0112874779541446*G0_1_2 - 0.0338624338624341*G0_2_1 - 0.0225749559082894*G0_2_2;
    A[775] = -0.0846560846560849*G0_0_1 - 0.0846560846560847*G0_0_2 - 0.0169312169312168*G0_1_1 - 0.019753086419753*G0_1_2 - 0.019753086419753*G0_2_1 - 0.016931216931217*G0_2_2;
    A[776] = -0.0225749559082894*G0_0_1 - 0.067724867724868*G0_0_2 - 0.0225749559082893*G0_1_1 - 0.0338624338624339*G0_1_2 + 0.0112874779541447*G0_2_1 + 0.0225749559082895*G0_2_2;
    A[777] = -0.0677248677248682*G0_0_0 + 0.0112874779541444*G0_0_2 + 0.203174603174603*G0_1_0 + 0.112874779541446*G0_1_2 + 0.101587301587301*G0_2_0 + 0.112874779541446*G0_2_2;
    A[778] = 0.118518518518519*G0_0_0 + 0.0931216931216934*G0_0_2 + 0.0507936507936509*G0_1_0 + 0.186243386243386*G0_1_2 - 0.0423280423280424*G0_2_0 - 0.084656084656085*G0_2_2;
    A[779] = -0.0225749559082894*G0_0_0 - 0.033862433862434*G0_0_2 - 0.0225749559082893*G0_1_0 - 0.0677248677248678*G0_1_2 + 0.0112874779541447*G0_2_0 + 0.067724867724868*G0_2_2;
    A[780] = -0.067724867724868*G0_0_0 + 0.0112874779541444*G0_0_1 + 0.101587301587301*G0_1_0 + 0.112874779541446*G0_1_1 + 0.203174603174603*G0_2_0 + 0.112874779541446*G0_2_1;
    A[781] = 0.118518518518519*G0_0_0 + 0.0931216931216932*G0_0_1 - 0.0423280423280426*G0_1_0 - 0.084656084656085*G0_1_1 + 0.0507936507936509*G0_2_0 + 0.186243386243386*G0_2_1;
    A[782] = -0.0225749559082894*G0_0_0 - 0.0338624338624342*G0_0_1 + 0.0112874779541446*G0_1_0 + 0.0677248677248677*G0_1_1 - 0.0225749559082895*G0_2_0 - 0.0677248677248679*G0_2_1;
    A[783] = -0.0225749559082894*G0_0_0 - 0.0225749559082894*G0_0_1 - 0.011287477954145*G0_0_2 - 0.0225749559082891*G0_1_0 - 0.0225749559082892*G0_1_1 - 0.0112874779541443*G0_1_2 - 0.0112874779541445*G0_2_0 - 0.0112874779541445*G0_2_1;
    A[784] = 0.0169312169312175*G0_0_0 + 0.0169312169312173*G0_0_1 - 0.00282186948853541*G0_0_2 + 0.0169312169312175*G0_1_0 + 0.0169312169312175*G0_1_1 - 0.00282186948853636*G0_1_2 - 0.0028218694885357*G0_2_0 - 0.00282186948853573*G0_2_1;
    A[785] = 0.0225749559082894*G0_0_0 + 0.0225749559082894*G0_0_1 - 0.0112874779541448*G0_0_2 + 0.0225749559082894*G0_1_0 + 0.0225749559082893*G0_1_1 - 0.0112874779541444*G0_1_2 - 0.0112874779541446*G0_2_0 - 0.0112874779541447*G0_2_1;
    A[786] = -0.0225749559082895*G0_0_0 - 0.011287477954145*G0_0_1 - 0.0225749559082895*G0_0_2 - 0.0112874779541449*G0_1_0 - 0.0112874779541449*G0_1_2 - 0.0225749559082892*G0_2_0 - 0.0112874779541443*G0_2_1 - 0.0225749559082891*G0_2_2;
    A[787] = 0.016931216931217*G0_0_0 - 0.00282186948853567*G0_0_1 + 0.016931216931217*G0_0_2 - 0.00282186948853604*G0_1_0 - 0.00282186948853597*G0_1_2 + 0.0169312169312168*G0_2_0 - 0.00282186948853633*G0_2_1 + 0.0169312169312168*G0_2_2;
    A[788] = 0.0225749559082894*G0_0_0 - 0.0112874779541448*G0_0_1 + 0.0225749559082894*G0_0_2 - 0.0112874779541446*G0_1_0 - 0.0112874779541446*G0_1_2 + 0.0225749559082895*G0_2_0 - 0.0112874779541445*G0_2_1 + 0.0225749559082895*G0_2_2;
    A[789] = -0.0451499118165789*G0_0_0 - 0.0564373897707233*G0_0_1 - 0.0564373897707233*G0_0_2 - 0.0564373897707228*G0_1_0 - 0.0677248677248679*G0_1_1 - 0.0677248677248679*G0_1_2 - 0.0564373897707228*G0_2_0 - 0.0677248677248676*G0_2_1 - 0.0677248677248676*G0_2_2;
    A[790] = 0.0225749559082893*G0_0_0 + 0.0423280423280422*G0_0_1 + 0.0423280423280421*G0_0_2 + 0.0423280423280419*G0_1_0 + 0.084656084656084*G0_1_1 + 0.084656084656084*G0_1_2 + 0.0423280423280419*G0_2_0 + 0.0846560846560842*G0_2_1 + 0.0846560846560842*G0_2_2;
    A[791] = -0.0451499118165785*G0_0_0 - 0.0112874779541445*G0_0_1 - 0.0112874779541444*G0_0_2 - 0.0112874779541443*G0_1_0 - 0.112874779541446*G0_1_1 - 0.112874779541446*G0_1_2 - 0.0112874779541446*G0_2_0 - 0.112874779541446*G0_2_1 - 0.112874779541446*G0_2_2;
    A[792] = 0.632098765432099*G0_0_0 + 0.27089947089947*G0_0_1 + 0.270899470899471*G0_0_2 + 0.27089947089947*G0_1_0 + 0.541798941798942*G0_1_1 + 0.27089947089947*G0_1_2 + 0.270899470899471*G0_2_0 + 0.27089947089947*G0_2_1 + 0.541798941798942*G0_2_2;
    A[793] = -0.135449735449736*G0_0_0 + 0.225749559082893*G0_0_1 + 0.0677248677248675*G0_0_2 - 0.0451499118165787*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0677248677248683*G0_1_2 - 0.0677248677248682*G0_2_0 + 0.0677248677248676*G0_2_1;
    A[794] = -0.135449735449736*G0_0_0 + 0.0677248677248676*G0_0_1 + 0.225749559082892*G0_0_2 - 0.0677248677248679*G0_1_0 + 0.0677248677248675*G0_1_2 - 0.0451499118165783*G0_2_0 - 0.0677248677248678*G0_2_1 - 0.135449735449736*G0_2_2;
    A[795] = 0.090299823633157*G0_0_0 + 0.0451499118165789*G0_0_1 + 0.0451499118165791*G0_0_2 + 0.0451499118165789*G0_1_0 + 0.0225749559082901*G0_1_2 + 0.0451499118165787*G0_2_0 + 0.0225749559082891*G0_2_1;
    A[796] = 0.135449735449736*G0_0_0 + 0.0451499118165785*G0_0_1 + 0.0677248677248674*G0_0_2 + 0.0451499118165786*G0_1_0 + 0.0225749559082888*G0_1_2 + 0.0677248677248681*G0_2_0 + 0.0225749559082897*G0_2_1;
    A[797] = 0.135449735449736*G0_0_0 + 0.0677248677248676*G0_0_1 + 0.0451499118165787*G0_0_2 + 0.067724867724868*G0_1_0 + 0.0225749559082887*G0_1_2 + 0.0451499118165784*G0_2_0 + 0.0225749559082888*G0_2_1;
    A[798] = 0.0451499118165789*G0_0_0 + 0.0902998236331567*G0_0_1 + 0.0451499118165789*G0_0_2 + 0.0902998236331565*G0_1_0 + 0.135449735449735*G0_1_1 + 0.0677248677248683*G0_1_2 + 0.0451499118165783*G0_2_0 + 0.0677248677248677*G0_2_1;
    A[799] = 0.0451499118165791*G0_0_0 - 0.27089947089947*G0_0_1 - 0.135449735449735*G0_0_2 - 0.27089947089947*G0_1_0 - 0.541798941798942*G0_1_1 - 0.27089947089947*G0_1_2 - 0.135449735449735*G0_2_0 - 0.27089947089947*G0_2_1;
    A[800] = -0.135449735449736*G0_0_0 - 0.0677248677248676*G0_0_1 + 0.0451499118165783*G0_0_2 - 0.0677248677248682*G0_1_0 + 0.0677248677248673*G0_1_2 + 0.0451499118165782*G0_2_0 + 0.0677248677248678*G0_2_1;
    A[801] = 0.0451499118165789*G0_0_0 + 0.0451499118165786*G0_0_1 + 0.0902998236331567*G0_0_2 + 0.0451499118165787*G0_1_0 + 0.0677248677248675*G0_1_2 + 0.0902998236331567*G0_2_0 + 0.0677248677248673*G0_2_1 + 0.135449735449735*G0_2_2;
    A[802] = 0.0451499118165786*G0_0_0 - 0.135449735449735*G0_0_1 - 0.270899470899471*G0_0_2 - 0.135449735449735*G0_1_0 - 0.27089947089947*G0_1_2 - 0.270899470899471*G0_2_0 - 0.27089947089947*G0_2_1 - 0.541798941798942*G0_2_2;
    A[803] = -0.135449735449736*G0_0_0 + 0.0451499118165786*G0_0_1 - 0.0677248677248675*G0_0_2 + 0.0451499118165787*G0_1_0 + 0.0677248677248683*G0_1_2 - 0.0677248677248678*G0_2_0 + 0.067724867724868*G0_2_1;
    A[804] = -0.722398589065256*G0_0_0 - 0.316049382716049*G0_0_1 - 0.316049382716049*G0_0_2 - 0.316049382716049*G0_1_0 - 0.135449735449735*G0_1_2 - 0.316049382716049*G0_2_0 - 0.135449735449735*G0_2_1;
    A[805] = 0.0183421516754849*G0_0_0 + 0.018342151675485*G0_0_1 + 0.018342151675485*G0_0_2 + 0.0183421516754853*G0_1_0 + 0.0183421516754853*G0_1_1 + 0.0183421516754853*G0_1_2 + 0.018342151675485*G0_2_0 + 0.018342151675485*G0_2_1 + 0.018342151675485*G0_2_2;
    A[806] = -0.0183421516754851*G0_0_0 + 0.00705467372134041*G0_1_0 + 0.00705467372134037*G0_2_0;
    A[807] = 0.00705467372134034*G0_0_1 + 0.0493827160493827*G0_1_1 + 0.00705467372134039*G0_2_1;
    A[808] = 0.0070546737213404*G0_0_2 + 0.00705467372134051*G0_1_2 - 0.0183421516754849*G0_2_2;
    A[809] = 0.203174603174603*G0_0_1 + 0.112874779541446*G0_0_2 - 0.0677248677248675*G0_1_1 + 0.0112874779541444*G0_1_2 + 0.101587301587302*G0_2_1 + 0.112874779541446*G0_2_2;
    A[810] = 0.050793650793651*G0_0_1 + 0.186243386243387*G0_0_2 + 0.118518518518518*G0_1_1 + 0.0931216931216937*G0_1_2 - 0.0423280423280426*G0_2_1 - 0.0846560846560845*G0_2_2;
    A[811] = -0.022574955908289*G0_0_1 - 0.0677248677248676*G0_0_2 - 0.0225749559082891*G0_1_1 - 0.0338624338624341*G0_1_2 + 0.011287477954145*G0_2_1 + 0.0677248677248678*G0_2_2;
    A[812] = 0.0225749559082894*G0_0_0 + 0.0112874779541446*G0_0_2 - 0.0677248677248678*G0_1_0 - 0.0225749559082894*G0_1_2 - 0.0338624338624338*G0_2_0 - 0.0225749559082892*G0_2_2;
    A[813] = -0.0169312169312171*G0_0_0 - 0.0197530864197531*G0_0_2 - 0.0846560846560847*G0_1_0 - 0.0846560846560847*G0_1_2 - 0.0197530864197533*G0_2_0 - 0.0169312169312172*G0_2_2;
    A[814] = -0.022574955908289*G0_0_0 - 0.0338624338624338*G0_0_2 - 0.0225749559082891*G0_1_0 - 0.0677248677248678*G0_1_2 + 0.011287477954145*G0_2_0 + 0.0225749559082894*G0_2_2;
    A[815] = 0.0677248677248677*G0_0_0 + 0.0112874779541446*G0_0_1 - 0.0338624338624341*G0_1_0 - 0.0225749559082894*G0_1_1 - 0.0677248677248677*G0_2_0 - 0.0225749559082893*G0_2_1;
    A[816] = -0.0846560846560848*G0_0_0 - 0.0423280423280427*G0_0_1 + 0.0931216931216935*G0_1_0 + 0.118518518518519*G0_1_1 + 0.186243386243386*G0_2_0 + 0.0507936507936506*G0_2_1;
    A[817] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_1 + 0.0112874779541442*G0_1_0 - 0.0677248677248679*G0_1_1 + 0.112874779541446*G0_2_0 + 0.203174603174603*G0_2_1;
    A[818] = -0.0225749559082893*G0_0_0 - 0.0225749559082895*G0_0_1 - 0.0112874779541446*G0_0_2 - 0.0225749559082897*G0_1_0 - 0.0225749559082898*G0_1_1 - 0.0112874779541454*G0_1_2 - 0.0112874779541447*G0_2_0 - 0.0112874779541446*G0_2_1;
    A[819] = 0.0169312169312172*G0_0_0 + 0.0169312169312174*G0_0_1 - 0.0028218694885361*G0_0_2 + 0.0169312169312176*G0_1_0 + 0.0169312169312177*G0_1_1 - 0.0028218694885351*G0_1_2 - 0.00282186948853591*G0_2_0 - 0.00282186948853583*G0_2_1;
    A[820] = 0.0225749559082891*G0_0_0 + 0.022574955908289*G0_0_1 - 0.0112874779541447*G0_0_2 + 0.0225749559082891*G0_1_0 + 0.0225749559082892*G0_1_1 - 0.0112874779541451*G0_1_2 - 0.0112874779541449*G0_2_0 - 0.0112874779541449*G0_2_1;
    A[821] = -0.0677248677248679*G0_0_0 - 0.0564373897707231*G0_0_1 - 0.0677248677248679*G0_0_2 - 0.0564373897707235*G0_1_0 - 0.045149911816579*G0_1_1 - 0.0564373897707235*G0_1_2 - 0.0677248677248677*G0_2_0 - 0.056437389770723*G0_2_1 - 0.0677248677248677*G0_2_2;
    A[822] = 0.0846560846560848*G0_0_0 + 0.0423280423280421*G0_0_1 + 0.0846560846560848*G0_0_2 + 0.0423280423280422*G0_1_0 + 0.0225749559082896*G0_1_1 + 0.0423280423280422*G0_1_2 + 0.0846560846560847*G0_2_0 + 0.0423280423280422*G0_2_1 + 0.0846560846560847*G0_2_2;
    A[823] = -0.112874779541446*G0_0_0 - 0.0112874779541444*G0_0_1 - 0.112874779541446*G0_0_2 - 0.0112874779541444*G0_1_0 - 0.0451499118165784*G0_1_1 - 0.0112874779541444*G0_1_2 - 0.112874779541446*G0_2_0 - 0.0112874779541445*G0_2_1 - 0.112874779541446*G0_2_2;
    A[824] = -0.011287477954145*G0_0_1 - 0.011287477954145*G0_0_2 - 0.0112874779541452*G0_1_0 - 0.0225749559082896*G0_1_1 - 0.0225749559082896*G0_1_2 - 0.0112874779541447*G0_2_0 - 0.0225749559082894*G0_2_1 - 0.0225749559082895*G0_2_2;
    A[825] = -0.00282186948853616*G0_0_1 - 0.00282186948853613*G0_0_2 - 0.00282186948853573*G0_1_0 + 0.0169312169312171*G0_1_1 + 0.016931216931217*G0_1_2 - 0.00282186948853577*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[826] = -0.0112874779541446*G0_0_1 - 0.0112874779541446*G0_0_2 - 0.0112874779541448*G0_1_0 + 0.0225749559082893*G0_1_1 + 0.0225749559082893*G0_1_2 - 0.0112874779541448*G0_2_0 + 0.0225749559082893*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[827] = -0.135449735449736*G0_0_0 - 0.0451499118165787*G0_0_1 - 0.0677248677248682*G0_0_2 + 0.225749559082893*G0_1_0 - 0.135449735449736*G0_1_1 + 0.0677248677248676*G0_1_2 + 0.0677248677248675*G0_2_0 - 0.0677248677248683*G0_2_1;
    A[828] = 0.541798941798943*G0_0_0 + 0.270899470899472*G0_0_1 + 0.270899470899472*G0_0_2 + 0.270899470899472*G0_1_0 + 0.6320987654321*G0_1_1 + 0.270899470899472*G0_1_2 + 0.270899470899472*G0_2_0 + 0.270899470899472*G0_2_1 + 0.541798941798943*G0_2_2;
    A[829] = -0.0677248677248679*G0_0_1 + 0.0677248677248679*G0_0_2 + 0.0677248677248676*G0_1_0 - 0.135449735449736*G0_1_1 + 0.225749559082892*G0_1_2 - 0.0677248677248675*G0_2_0 - 0.0451499118165784*G0_2_1 - 0.135449735449735*G0_2_2;
    A[830] = 0.135449735449736*G0_0_0 + 0.0902998236331572*G0_0_1 + 0.0677248677248681*G0_0_2 + 0.0902998236331573*G0_1_0 + 0.0451499118165792*G0_1_1 + 0.0451499118165792*G0_1_2 + 0.0677248677248674*G0_2_0 + 0.0451499118165782*G0_2_1;
    A[831] = -0.541798941798943*G0_0_0 - 0.270899470899471*G0_0_1 - 0.270899470899471*G0_0_2 - 0.270899470899472*G0_1_0 + 0.0451499118165784*G0_1_1 - 0.135449735449736*G0_1_2 - 0.270899470899472*G0_2_0 - 0.135449735449735*G0_2_1;
    A[832] = -0.0677248677248683*G0_0_1 + 0.0677248677248675*G0_0_2 - 0.0677248677248673*G0_1_0 - 0.135449735449736*G0_1_1 + 0.0451499118165784*G0_1_2 + 0.0677248677248677*G0_2_0 + 0.0451499118165785*G0_2_1;
    A[833] = 0.0451499118165788*G0_0_1 + 0.0225749559082901*G0_0_2 + 0.0451499118165798*G0_1_0 + 0.0902998236331573*G0_1_1 + 0.0451499118165795*G0_1_2 + 0.0225749559082892*G0_2_0 + 0.045149911816578*G0_2_1;
    A[834] = 0.0451499118165785*G0_0_1 + 0.0225749559082893*G0_0_2 + 0.0451499118165782*G0_1_0 + 0.135449735449736*G0_1_1 + 0.0677248677248678*G0_1_2 + 0.0225749559082896*G0_2_0 + 0.0677248677248681*G0_2_1;
    A[835] = 0.0677248677248678*G0_0_1 + 0.0225749559082887*G0_0_2 + 0.0677248677248671*G0_1_0 + 0.135449735449736*G0_1_1 + 0.0451499118165779*G0_1_2 + 0.0225749559082892*G0_2_0 + 0.0451499118165783*G0_2_1;
    A[836] = 0.0451499118165789*G0_0_1 + 0.0677248677248675*G0_0_2 + 0.0451499118165788*G0_1_0 + 0.0451499118165786*G0_1_1 + 0.0902998236331564*G0_1_2 + 0.0677248677248674*G0_2_0 + 0.0902998236331569*G0_2_1 + 0.135449735449734*G0_2_2;
    A[837] = 0.0451499118165785*G0_0_1 + 0.0677248677248677*G0_0_2 + 0.0451499118165787*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0677248677248679*G0_1_2 + 0.0677248677248681*G0_2_0 - 0.0677248677248678*G0_2_1;
    A[838] = -0.135449735449736*G0_0_1 - 0.270899470899471*G0_0_2 - 0.135449735449736*G0_1_0 + 0.0451499118165788*G0_1_1 - 0.270899470899472*G0_1_2 - 0.270899470899471*G0_2_0 - 0.270899470899471*G0_2_1 - 0.541798941798942*G0_2_2;
    A[839] = -0.31604938271605*G0_0_1 - 0.135449735449735*G0_0_2 - 0.31604938271605*G0_1_0 - 0.722398589065257*G0_1_1 - 0.316049382716048*G0_1_2 - 0.135449735449735*G0_2_0 - 0.31604938271605*G0_2_1;
    A[840] = 0.0183421516754852*G0_0_0 + 0.0183421516754853*G0_0_1 + 0.0183421516754853*G0_0_2 + 0.0183421516754852*G0_1_0 + 0.0183421516754852*G0_1_1 + 0.0183421516754852*G0_1_2 + 0.0183421516754854*G0_2_0 + 0.0183421516754855*G0_2_1 + 0.0183421516754855*G0_2_2;
    A[841] = -0.0183421516754848*G0_0_0 + 0.00705467372134062*G0_1_0 + 0.00705467372134052*G0_2_0;
    A[842] = 0.00705467372134016*G0_0_1 - 0.0183421516754851*G0_1_1 + 0.00705467372134029*G0_2_1;
    A[843] = 0.00705467372134039*G0_0_2 + 0.00705467372134029*G0_1_2 + 0.0493827160493827*G0_2_2;
    A[844] = -0.0677248677248676*G0_0_1 - 0.0225749559082896*G0_0_2 + 0.0677248677248678*G0_1_1 + 0.0112874779541444*G0_1_2 - 0.0338624338624338*G0_2_1 - 0.0225749559082895*G0_2_2;
    A[845] = 0.186243386243386*G0_0_1 + 0.0507936507936512*G0_0_2 - 0.0846560846560848*G0_1_1 - 0.0423280423280424*G0_1_2 + 0.0931216931216931*G0_2_1 + 0.118518518518519*G0_2_2;
    A[846] = 0.112874779541446*G0_0_1 + 0.203174603174603*G0_0_2 + 0.112874779541446*G0_1_1 + 0.101587301587302*G0_1_2 + 0.0112874779541444*G0_2_1 - 0.0677248677248681*G0_2_2;
    A[847] = 0.0677248677248677*G0_0_0 + 0.0112874779541451*G0_0_2 - 0.067724867724868*G0_1_0 - 0.022574955908289*G0_1_2 - 0.0338624338624342*G0_2_0 - 0.0225749559082892*G0_2_2;
    A[848] = -0.0846560846560844*G0_0_0 - 0.0423280423280429*G0_0_2 + 0.186243386243387*G0_1_0 + 0.0507936507936505*G0_1_2 + 0.0931216931216938*G0_2_0 + 0.118518518518519*G0_2_2;
    A[849] = 0.112874779541446*G0_0_0 + 0.101587301587302*G0_0_2 + 0.112874779541446*G0_1_0 + 0.203174603174604*G0_1_2 + 0.0112874779541444*G0_2_0 - 0.0677248677248676*G0_2_2;
    A[850] = 0.0225749559082892*G0_0_0 + 0.011287477954145*G0_0_1 - 0.0338624338624341*G0_1_0 - 0.0225749559082891*G0_1_1 - 0.067724867724868*G0_2_0 - 0.0225749559082892*G0_2_1;
    A[851] = -0.0169312169312166*G0_0_0 - 0.0197530864197533*G0_0_1 - 0.0197530864197529*G0_1_0 - 0.016931216931217*G0_1_1 - 0.0846560846560844*G0_2_0 - 0.0846560846560847*G0_2_1;
    A[852] = -0.0225749559082898*G0_0_0 - 0.0338624338624337*G0_0_1 + 0.0112874779541443*G0_1_0 + 0.0225749559082892*G0_1_1 - 0.0225749559082896*G0_2_0 - 0.0677248677248677*G0_2_1;
    A[853] = -0.0677248677248681*G0_0_0 - 0.0677248677248681*G0_0_1 - 0.0564373897707237*G0_0_2 - 0.0677248677248678*G0_1_0 - 0.0677248677248678*G0_1_1 - 0.0564373897707236*G0_1_2 - 0.0564373897707236*G0_2_0 - 0.0564373897707236*G0_2_1 - 0.0451499118165797*G0_2_2;
    A[854] = 0.084656084656085*G0_0_0 + 0.0846560846560851*G0_0_1 + 0.042328042328043*G0_0_2 + 0.0846560846560844*G0_1_0 + 0.0846560846560845*G0_1_1 + 0.0423280423280427*G0_1_2 + 0.0423280423280426*G0_2_0 + 0.0423280423280427*G0_2_1 + 0.0225749559082906*G0_2_2;
    A[855] = -0.112874779541446*G0_0_0 - 0.112874779541446*G0_0_1 - 0.0112874779541449*G0_0_2 - 0.112874779541446*G0_1_0 - 0.112874779541446*G0_1_1 - 0.0112874779541446*G0_1_2 - 0.0112874779541444*G0_2_0 - 0.0112874779541444*G0_2_1 - 0.0451499118165789*G0_2_2;
    A[856] = -0.0225749559082894*G0_0_0 - 0.011287477954145*G0_0_1 - 0.0225749559082893*G0_0_2 - 0.0112874779541446*G0_1_0 - 0.0112874779541446*G0_1_2 - 0.0225749559082896*G0_2_0 - 0.0112874779541455*G0_2_1 - 0.0225749559082897*G0_2_2;
    A[857] = 0.0169312169312169*G0_0_0 - 0.00282186948853602*G0_0_1 + 0.0169312169312169*G0_0_2 - 0.00282186948853599*G0_1_0 - 0.00282186948853603*G0_1_2 + 0.0169312169312171*G0_2_0 - 0.00282186948853552*G0_2_1 + 0.0169312169312171*G0_2_2;
    A[858] = 0.0225749559082896*G0_0_0 - 0.0112874779541445*G0_0_1 + 0.0225749559082896*G0_0_2 - 0.0112874779541444*G0_1_0 - 0.0112874779541444*G0_1_2 + 0.0225749559082894*G0_2_0 - 0.0112874779541447*G0_2_1 + 0.0225749559082895*G0_2_2;
    A[859] = -0.0112874779541448*G0_0_1 - 0.0112874779541448*G0_0_2 - 0.011287477954145*G0_1_0 - 0.0225749559082893*G0_1_1 - 0.0225749559082893*G0_1_2 - 0.0112874779541454*G0_2_0 - 0.0225749559082896*G0_2_1 - 0.0225749559082896*G0_2_2;
    A[860] = -0.00282186948853605*G0_0_1 - 0.00282186948853608*G0_0_2 - 0.00282186948853587*G0_1_0 + 0.0169312169312171*G0_1_1 + 0.0169312169312171*G0_1_2 - 0.00282186948853582*G0_2_0 + 0.016931216931217*G0_2_1 + 0.016931216931217*G0_2_2;
    A[861] = -0.0112874779541451*G0_0_1 - 0.0112874779541451*G0_0_2 - 0.0112874779541449*G0_1_0 + 0.022574955908289*G0_1_1 + 0.022574955908289*G0_1_2 - 0.0112874779541447*G0_2_0 + 0.0225749559082891*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[862] = -0.135449735449736*G0_0_0 - 0.0677248677248679*G0_0_1 - 0.0451499118165783*G0_0_2 + 0.0677248677248676*G0_1_0 - 0.0677248677248678*G0_1_2 + 0.225749559082892*G0_2_0 + 0.0677248677248675*G0_2_1 - 0.135449735449736*G0_2_2;
    A[863] = 0.0677248677248676*G0_0_1 - 0.0677248677248675*G0_0_2 - 0.0677248677248679*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0451499118165784*G0_1_2 + 0.0677248677248679*G0_2_0 + 0.225749559082892*G0_2_1 - 0.135449735449735*G0_2_2;
    A[864] = 0.541798941798942*G0_0_0 + 0.270899470899471*G0_0_1 + 0.270899470899471*G0_0_2 + 0.270899470899471*G0_1_0 + 0.541798941798943*G0_1_1 + 0.270899470899471*G0_1_2 + 0.270899470899471*G0_2_0 + 0.270899470899471*G0_2_1 + 0.632098765432098*G0_2_2;
    A[865] = 0.135449735449736*G0_0_0 + 0.0677248677248685*G0_0_1 + 0.0902998236331574*G0_0_2 + 0.0677248677248676*G0_1_0 + 0.0451499118165784*G0_1_2 + 0.0902998236331575*G0_2_0 + 0.0451499118165798*G0_2_1 + 0.0451499118165793*G0_2_2;
    A[866] = 0.0677248677248672*G0_0_1 - 0.0677248677248682*G0_0_2 + 0.0677248677248679*G0_1_0 + 0.0451499118165782*G0_1_2 - 0.0677248677248679*G0_2_0 + 0.0451499118165777*G0_2_1 - 0.135449735449736*G0_2_2;
    A[867] = -0.541798941798942*G0_0_0 - 0.270899470899471*G0_0_1 - 0.270899470899471*G0_0_2 - 0.270899470899471*G0_1_0 - 0.135449735449735*G0_1_2 - 0.27089947089947*G0_2_0 - 0.135449735449736*G0_2_1 + 0.0451499118165786*G0_2_2;
    A[868] = 0.0677248677248683*G0_0_1 + 0.0451499118165791*G0_0_2 + 0.0677248677248681*G0_1_0 + 0.135449735449735*G0_1_1 + 0.0902998236331569*G0_1_2 + 0.0451499118165799*G0_2_0 + 0.0902998236331575*G0_2_1 + 0.0451499118165792*G0_2_2;
    A[869] = 0.0677248677248678*G0_0_1 + 0.045149911816579*G0_0_2 + 0.0677248677248679*G0_1_0 - 0.0677248677248673*G0_1_2 + 0.0451499118165781*G0_2_0 - 0.0677248677248676*G0_2_1 - 0.135449735449735*G0_2_2;
    A[870] = -0.270899470899471*G0_0_1 - 0.135449735449737*G0_0_2 - 0.270899470899471*G0_1_0 - 0.541798941798943*G0_1_1 - 0.270899470899471*G0_1_2 - 0.135449735449736*G0_2_0 - 0.270899470899471*G0_2_1 + 0.0451499118165778*G0_2_2;
    A[871] = 0.0225749559082894*G0_0_1 + 0.0451499118165787*G0_0_2 + 0.0225749559082895*G0_1_0 + 0.0451499118165786*G0_1_2 + 0.0451499118165793*G0_2_0 + 0.0451499118165791*G0_2_1 + 0.0902998236331574*G0_2_2;
    A[872] = 0.0225749559082894*G0_0_1 + 0.0451499118165781*G0_0_2 + 0.0225749559082892*G0_1_0 + 0.0677248677248677*G0_1_2 + 0.0451499118165782*G0_2_0 + 0.0677248677248678*G0_2_1 + 0.135449735449736*G0_2_2;
    A[873] = 0.0225749559082891*G0_0_1 + 0.0677248677248675*G0_0_2 + 0.0225749559082888*G0_1_0 + 0.0451499118165788*G0_1_2 + 0.0677248677248672*G0_2_0 + 0.0451499118165781*G0_2_1 + 0.135449735449735*G0_2_2;
    A[874] = -0.135449735449736*G0_0_1 - 0.316049382716049*G0_0_2 - 0.135449735449735*G0_1_0 - 0.31604938271605*G0_1_2 - 0.31604938271605*G0_2_0 - 0.31604938271605*G0_2_1 - 0.722398589065256*G0_2_2;
    A[875] = 0.0493827160493826*G0_0_0 + 0.0493827160493825*G0_0_1 + 0.0493827160493825*G0_0_2 + 0.042328042328042*G0_1_0 + 0.042328042328042*G0_1_1 + 0.042328042328042*G0_1_2 + 0.0423280423280421*G0_2_0 + 0.0423280423280421*G0_2_1 + 0.042328042328042*G0_2_2;
    A[876] = 0.018342151675485*G0_0_0;
    A[877] = -0.0070546737213406*G0_0_1 - 0.0253968253968254*G0_1_1;
    A[878] = -0.00705467372134034*G0_0_2 - 0.0253968253968253*G0_2_2;
    A[879] = 0.0677248677248676*G0_0_1 + 0.0225749559082888*G0_0_2 + 0.0902998236331568*G0_1_1 + 0.0338624338624339*G0_1_2 + 0.0338624338624338*G0_2_1;
    A[880] = 0.0846560846560849*G0_0_1 + 0.0846560846560853*G0_0_2 + 0.0677248677248681*G0_1_1 + 0.0649029982363317*G0_1_2 + 0.0649029982363317*G0_2_1 + 0.0677248677248682*G0_2_2;
    A[881] = 0.0225749559082896*G0_0_1 + 0.0677248677248677*G0_0_2 + 0.0338624338624339*G0_1_2 + 0.0338624338624344*G0_2_1 + 0.0902998236331572*G0_2_2;
    A[882] = -0.0225749559082891*G0_0_0 - 0.0112874779541447*G0_0_2 - 0.0112874779541443*G0_2_0;
    A[883] = 0.0169312169312167*G0_0_0 + 0.0197530864197532*G0_0_2 + 0.0197530864197529*G0_2_0 + 0.0225749559082897*G0_2_2;
    A[884] = 0.0225749559082896*G0_0_0 + 0.033862433862434*G0_0_2 + 0.0338624338624344*G0_2_0 + 0.0451499118165785*G0_2_2;
    A[885] = -0.0225749559082892*G0_0_0 - 0.0112874779541446*G0_0_1 - 0.0112874779541446*G0_1_0;
    A[886] = 0.0169312169312169*G0_0_0 + 0.0197530864197529*G0_0_1 + 0.0197530864197528*G0_1_0 + 0.0225749559082889*G0_1_1;
    A[887] = 0.0225749559082887*G0_0_0 + 0.0338624338624337*G0_0_1 + 0.0338624338624339*G0_1_0 + 0.0451499118165784*G0_1_1;
    A[888] = -0.0677248677248676*G0_0_0 - 0.0677248677248677*G0_0_1 - 0.0790123456790117*G0_0_2 - 0.270899470899471*G0_1_0 - 0.270899470899471*G0_1_1 - 0.169312169312169*G0_1_2 - 0.16931216931217*G0_2_0 - 0.16931216931217*G0_2_1 - 0.067724867724867*G0_2_2;
    A[889] = 0.118518518518519*G0_0_0 + 0.118518518518519*G0_0_1 + 0.0253968253968248*G0_0_2 + 0.067724867724868*G0_1_0 + 0.0677248677248678*G0_1_1 + 0.16084656084656*G0_1_2 + 0.160846560846562*G0_2_0 + 0.160846560846562*G0_2_1 - 0.0169312169312177*G0_2_2;
    A[890] = -0.0225749559082897*G0_0_0 - 0.0225749559082897*G0_0_1 + 0.0112874779541449*G0_0_2 - 0.0338624338624334*G0_1_2 - 0.0338624338624344*G0_2_0 - 0.0338624338624344*G0_2_1 + 0.067724867724868*G0_2_2;
    A[891] = -0.067724867724868*G0_0_0 - 0.0790123456790121*G0_0_1 - 0.0677248677248679*G0_0_2 - 0.169312169312169*G0_1_0 - 0.067724867724867*G0_1_1 - 0.16931216931217*G0_1_2 - 0.270899470899472*G0_2_0 - 0.169312169312169*G0_2_1 - 0.270899470899472*G0_2_2;
    A[892] = 0.118518518518518*G0_0_0 + 0.025396825396825*G0_0_1 + 0.118518518518518*G0_0_2 + 0.160846560846561*G0_1_0 - 0.0169312169312177*G0_1_1 + 0.160846560846561*G0_1_2 + 0.0677248677248674*G0_2_0 + 0.16084656084656*G0_2_1 + 0.0677248677248674*G0_2_2;
    A[893] = -0.0225749559082887*G0_0_0 + 0.011287477954145*G0_0_1 - 0.0225749559082887*G0_0_2 - 0.0338624338624338*G0_1_0 + 0.0677248677248681*G0_1_1 - 0.0338624338624338*G0_1_2 - 0.0338624338624333*G0_2_1;
    A[894] = -0.0451499118165784*G0_0_0 - 0.0338624338624343*G0_0_1 - 0.0338624338624343*G0_0_2 - 0.0338624338624336*G0_1_0 - 0.135449735449736*G0_1_1 - 0.135449735449736*G0_1_2 - 0.0338624338624336*G0_2_0 - 0.135449735449736*G0_2_1 - 0.135449735449736*G0_2_2;
    A[895] = 0.022574955908289*G0_0_0 - 0.0197530864197535*G0_0_1 - 0.0197530864197535*G0_0_2 - 0.0197530864197533*G0_1_0 + 0.0225749559082888*G0_1_1 + 0.0225749559082889*G0_1_2 - 0.0197530864197533*G0_2_0 + 0.0225749559082891*G0_2_1 + 0.0225749559082891*G0_2_2;
    A[896] = -0.0451499118165782*G0_0_0 + 0.0112874779541448*G0_0_1 + 0.0112874779541448*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_2_0;
    A[897] = 0.090299823633157*G0_0_0 + 0.0451499118165789*G0_0_1 + 0.0451499118165787*G0_0_2 + 0.0451499118165789*G0_1_0 + 0.0225749559082891*G0_1_2 + 0.0451499118165791*G0_2_0 + 0.0225749559082901*G0_2_1;
    A[898] = 0.135449735449736*G0_0_0 + 0.0902998236331573*G0_0_1 + 0.0677248677248674*G0_0_2 + 0.0902998236331572*G0_1_0 + 0.0451499118165792*G0_1_1 + 0.0451499118165782*G0_1_2 + 0.0677248677248681*G0_2_0 + 0.0451499118165792*G0_2_1;
    A[899] = 0.135449735449736*G0_0_0 + 0.0677248677248676*G0_0_1 + 0.0902998236331575*G0_0_2 + 0.0677248677248685*G0_1_0 + 0.0451499118165798*G0_1_2 + 0.0902998236331574*G0_2_0 + 0.0451499118165784*G0_2_1 + 0.0451499118165793*G0_2_2;
    A[900] = 0.6320987654321*G0_0_0 + 0.361199294532628*G0_0_1 + 0.361199294532629*G0_0_2 + 0.361199294532628*G0_1_0 + 0.632098765432099*G0_1_1 + 0.361199294532629*G0_1_2 + 0.361199294532629*G0_2_0 + 0.361199294532629*G0_2_1 + 0.632098765432101*G0_2_2;
    A[901] = -0.135449735449736*G0_0_0 - 0.361199294532628*G0_0_1 - 0.203174603174604*G0_0_2 - 0.0902998236331573*G0_1_0 - 0.451499118165785*G0_1_1 - 0.225749559082893*G0_1_2 - 0.0677248677248681*G0_2_0 - 0.225749559082893*G0_2_1 - 0.135449735449736*G0_2_2;
    A[902] = -0.135449735449736*G0_0_0 - 0.203174603174604*G0_0_1 - 0.361199294532629*G0_0_2 - 0.0677248677248683*G0_1_0 - 0.135449735449736*G0_1_1 - 0.225749559082892*G0_1_2 - 0.0902998236331573*G0_2_0 - 0.225749559082893*G0_2_1 - 0.451499118165786*G0_2_2;
    A[903] = 0.0451499118165788*G0_0_0 + 0.31604938271605*G0_0_1 + 0.180599647266315*G0_0_2 + 0.31604938271605*G0_1_0 + 0.0451499118165789*G0_1_1 + 0.180599647266315*G0_1_2 + 0.180599647266315*G0_2_0 + 0.180599647266315*G0_2_1 + 0.316049382716052*G0_2_2;
    A[904] = 0.0451499118165784*G0_0_0 - 0.0451499118165787*G0_0_1 - 0.0451499118165784*G0_1_0 - 0.0225749559082894*G0_1_2 - 0.0225749559082902*G0_2_1 - 0.0451499118165789*G0_2_2;
    A[905] = -0.135449735449736*G0_0_0 - 0.0677248677248679*G0_0_1 - 0.180599647266315*G0_0_2 - 0.0677248677248681*G0_1_0 - 0.0451499118165791*G0_1_2 - 0.180599647266315*G0_2_0 - 0.0451499118165786*G0_2_1 - 0.225749559082894*G0_2_2;
    A[906] = 0.0451499118165789*G0_0_0 + 0.180599647266315*G0_0_1 + 0.31604938271605*G0_0_2 + 0.180599647266314*G0_1_0 + 0.31604938271605*G0_1_1 + 0.180599647266314*G0_1_2 + 0.31604938271605*G0_2_0 + 0.180599647266315*G0_2_1 + 0.0451499118165786*G0_2_2;
    A[907] = 0.0451499118165783*G0_0_0 - 0.0451499118165787*G0_0_2 - 0.0451499118165782*G0_1_1 - 0.0225749559082893*G0_1_2 - 0.0451499118165788*G0_2_0 - 0.0225749559082892*G0_2_1;
    A[908] = -0.135449735449735*G0_0_0 - 0.180599647266314*G0_0_1 - 0.067724867724867*G0_0_2 - 0.180599647266314*G0_1_0 - 0.225749559082892*G0_1_1 - 0.045149911816578*G0_1_2 - 0.0677248677248672*G0_2_0 - 0.0451499118165784*G0_2_1;
    A[909] = -0.722398589065257*G0_0_0 - 0.406349206349208*G0_0_1 - 0.406349206349207*G0_0_2 - 0.406349206349207*G0_1_0 - 0.0902998236331577*G0_1_1 - 0.225749559082894*G0_1_2 - 0.406349206349208*G0_2_0 - 0.225749559082894*G0_2_1 - 0.090299823633158*G0_2_2;
    A[910] = -0.0183421516754849*G0_0_0 - 0.018342151675485*G0_0_1 - 0.018342151675485*G0_0_2 - 0.0253968253968252*G0_1_0 - 0.0253968253968252*G0_1_1 - 0.0253968253968252*G0_1_2 - 0.0253968253968254*G0_2_0 - 0.0253968253968253*G0_2_1 - 0.0253968253968254*G0_2_2;
    A[911] = 0.0183421516754851*G0_0_0;
    A[912] = -0.00705467372134032*G0_0_1 + 0.0423280423280423*G0_1_1;
    A[913] = -0.00705467372134041*G0_0_2 - 0.0253968253968254*G0_2_2;
    A[914] = -0.203174603174603*G0_0_1 - 0.112874779541446*G0_0_2 - 0.270899470899471*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1;
    A[915] = -0.050793650793651*G0_0_1 - 0.186243386243387*G0_0_2 + 0.0677248677248675*G0_1_1 - 0.093121693121693*G0_1_2 - 0.0931216931216935*G0_2_1 - 0.270899470899471*G0_2_2;
    A[916] = 0.022574955908289*G0_0_1 + 0.0677248677248676*G0_0_2 + 0.0338624338624337*G0_1_2 + 0.0338624338624339*G0_2_1 + 0.135449735449735*G0_2_2;
    A[917] = -0.0225749559082895*G0_0_0 - 0.0112874779541447*G0_0_2 - 0.0112874779541447*G0_2_0;
    A[918] = 0.0169312169312171*G0_0_0 + 0.0197530864197531*G0_0_2 + 0.0197530864197528*G0_2_0 + 0.022574955908289*G0_2_2;
    A[919] = 0.022574955908289*G0_0_0 + 0.0338624338624338*G0_0_2 + 0.0338624338624339*G0_2_0 + 0.0451499118165784*G0_2_2;
    A[920] = -0.0677248677248677*G0_0_0 - 0.0112874779541447*G0_0_1 - 0.0112874779541447*G0_1_0;
    A[921] = 0.0846560846560848*G0_0_0 + 0.0423280423280427*G0_0_1 + 0.0423280423280428*G0_1_0 + 0.0225749559082899*G0_1_1;
    A[922] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587302*G0_1_0 - 0.135449735449736*G0_1_1;
    A[923] = 0.0225749559082893*G0_0_0 + 0.0225749559082895*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.0902998236331568*G0_1_0 + 0.0902998236331569*G0_1_1 + 0.0564373897707225*G0_1_2 + 0.0564373897707232*G0_2_0 + 0.0564373897707233*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[924] = -0.0169312169312172*G0_0_0 - 0.0169312169312174*G0_0_1 + 0.0028218694885361*G0_0_2 + 0.0677248677248678*G0_1_0 + 0.0677248677248679*G0_1_1 + 0.00282186948853683*G0_1_2 + 0.00282186948853585*G0_2_0 + 0.0028218694885358*G0_2_1 + 0.00564373897707232*G0_2_2;
    A[925] = -0.0225749559082891*G0_0_0 - 0.022574955908289*G0_0_1 + 0.0112874779541447*G0_0_2 - 0.0338624338624343*G0_1_2 - 0.0338624338624339*G0_2_0 - 0.0338624338624339*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[926] = 0.0677248677248679*G0_0_0 + 0.0564373897707231*G0_0_1 + 0.0677248677248679*G0_0_2 + 0.101587301587302*G0_1_0 + 0.0677248677248673*G0_1_1 + 0.101587301587302*G0_1_2 + 0.135449735449736*G0_2_0 + 0.101587301587301*G0_2_1 + 0.135449735449736*G0_2_2;
    A[927] = -0.0846560846560848*G0_0_0 - 0.0423280423280421*G0_0_1 - 0.0846560846560848*G0_0_2 - 0.177777777777778*G0_1_0 - 0.0169312169312163*G0_1_1 - 0.177777777777778*G0_1_2 - 0.270899470899471*G0_2_0 - 0.177777777777777*G0_2_1 - 0.270899470899471*G0_2_2;
    A[928] = 0.112874779541446*G0_0_0 + 0.0112874779541444*G0_0_1 + 0.112874779541446*G0_0_2 + 0.101587301587302*G0_1_0 - 0.067724867724868*G0_1_1 + 0.101587301587302*G0_1_2 + 0.101587301587301*G0_2_1;
    A[929] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.0112874779541444*G0_1_0 + 0.0451499118165788*G0_1_1 + 0.0451499118165787*G0_1_2 + 0.0112874779541445*G0_2_0 + 0.0451499118165788*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[930] = 0.00282186948853618*G0_0_1 + 0.00282186948853615*G0_0_2 + 0.00282186948853627*G0_1_0 + 0.0225749559082896*G0_1_1 + 0.0225749559082894*G0_1_2 + 0.00282186948853626*G0_2_0 + 0.0225749559082894*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[931] = 0.0112874779541446*G0_0_1 + 0.0112874779541446*G0_0_2 + 0.0112874779541444*G0_1_0 + 0.0112874779541445*G0_2_0;
    A[932] = 0.135449735449736*G0_0_0 + 0.0451499118165786*G0_0_1 + 0.0677248677248681*G0_0_2 + 0.0451499118165785*G0_1_0 + 0.0225749559082897*G0_1_2 + 0.0677248677248674*G0_2_0 + 0.0225749559082888*G0_2_1;
    A[933] = -0.541798941798943*G0_0_0 - 0.270899470899472*G0_0_1 - 0.270899470899472*G0_0_2 - 0.270899470899471*G0_1_0 + 0.0451499118165784*G0_1_1 - 0.135449735449735*G0_1_2 - 0.270899470899471*G0_2_0 - 0.135449735449736*G0_2_1;
    A[934] = 0.0677248677248679*G0_0_1 - 0.0677248677248679*G0_0_2 + 0.0677248677248672*G0_1_0 + 0.0451499118165777*G0_1_2 - 0.0677248677248682*G0_2_0 + 0.0451499118165782*G0_2_1 - 0.135449735449736*G0_2_2;
    A[935] = -0.135449735449736*G0_0_0 - 0.0902998236331573*G0_0_1 - 0.0677248677248681*G0_0_2 - 0.361199294532628*G0_1_0 - 0.451499118165785*G0_1_1 - 0.225749559082893*G0_1_2 - 0.203174603174604*G0_2_0 - 0.225749559082893*G0_2_1 - 0.135449735449736*G0_2_2;
    A[936] = 0.541798941798943*G0_0_0 + 0.270899470899471*G0_0_1 + 0.270899470899471*G0_0_2 + 0.270899470899471*G0_1_0 + 0.632098765432099*G0_1_1 + 0.270899470899471*G0_1_2 + 0.270899470899471*G0_2_0 + 0.270899470899471*G0_2_1 + 0.541798941798942*G0_2_2;
    A[937] = 0.0677248677248684*G0_0_1 - 0.0677248677248675*G0_0_2 - 0.0677248677248675*G0_1_0 - 0.135449735449736*G0_1_1 + 0.090299823633157*G0_1_2 + 0.067724867724868*G0_2_0 + 0.0902998236331577*G0_2_1 - 0.135449735449735*G0_2_2;
    A[938] = -0.0451499118165788*G0_0_1 - 0.0225749559082901*G0_0_2 - 0.0451499118165786*G0_1_0 + 0.0451499118165781*G0_1_1 - 0.0225749559082899*G0_2_0 - 0.0451499118165794*G0_2_2;
    A[939] = -0.0451499118165784*G0_0_1 - 0.0225749559082893*G0_0_2 - 0.0451499118165784*G0_1_0 - 0.0225749559082891*G0_1_2 - 0.0225749559082888*G0_2_0 - 0.0225749559082887*G0_2_1 - 0.0451499118165783*G0_2_2;
    A[940] = -0.0677248677248678*G0_0_1 - 0.0225749559082888*G0_0_2 - 0.0677248677248676*G0_1_0 - 0.0451499118165781*G0_1_2 - 0.0225749559082885*G0_2_0 - 0.0451499118165782*G0_2_1 - 0.0451499118165778*G0_2_2;
    A[941] = -0.0451499118165789*G0_0_1 - 0.0677248677248675*G0_0_2 - 0.0451499118165786*G0_1_0 - 0.225749559082893*G0_1_1 - 0.180599647266314*G0_1_2 - 0.0677248677248678*G0_2_0 - 0.180599647266314*G0_2_1 - 0.135449735449736*G0_2_2;
    A[942] = -0.0451499118165786*G0_0_1 - 0.0677248677248677*G0_0_2 - 0.0451499118165783*G0_1_0 - 0.0451499118165789*G0_1_1 - 0.0225749559082894*G0_1_2 - 0.0677248677248676*G0_2_0 - 0.0225749559082894*G0_2_1;
    A[943] = 0.135449735449736*G0_0_1 + 0.270899470899471*G0_0_2 + 0.135449735449735*G0_1_0 + 0.31604938271605*G0_1_1 + 0.135449735449735*G0_1_2 + 0.270899470899471*G0_2_0 + 0.135449735449736*G0_2_1;
    A[944] = 0.31604938271605*G0_0_1 + 0.135449735449735*G0_0_2 + 0.31604938271605*G0_1_0 - 0.0902998236331568*G0_1_1 + 0.135449735449737*G0_1_2 + 0.135449735449737*G0_2_0 + 0.135449735449737*G0_2_1 + 0.270899470899472*G0_2_2;
    A[945] = -0.0183421516754852*G0_0_0 - 0.0183421516754852*G0_0_1 - 0.0183421516754852*G0_0_2 - 0.0253968253968253*G0_1_0 - 0.0253968253968253*G0_1_1 - 0.0253968253968253*G0_1_2 - 0.0253968253968252*G0_2_0 - 0.0253968253968252*G0_2_1 - 0.0253968253968251*G0_2_2;
    A[946] = 0.0183421516754848*G0_0_0;
    A[947] = -0.00705467372134016*G0_0_1 - 0.0253968253968253*G0_1_1;
    A[948] = -0.00705467372134039*G0_0_2 + 0.0423280423280422*G0_2_2;
    A[949] = 0.0677248677248677*G0_0_1 + 0.0225749559082897*G0_0_2 + 0.135449735449736*G0_1_1 + 0.0338624338624343*G0_1_2 + 0.0338624338624338*G0_2_1;
    A[950] = -0.186243386243386*G0_0_1 - 0.0507936507936511*G0_0_2 - 0.270899470899471*G0_1_1 - 0.0931216931216939*G0_1_2 - 0.093121693121693*G0_2_1 + 0.0677248677248673*G0_2_2;
    A[951] = -0.112874779541446*G0_0_1 - 0.203174603174603*G0_0_2 - 0.101587301587301*G0_1_2 - 0.101587301587302*G0_2_1 - 0.270899470899471*G0_2_2;
    A[952] = -0.0677248677248676*G0_0_0 - 0.011287477954145*G0_0_2 - 0.0112874779541451*G0_2_0;
    A[953] = 0.0846560846560844*G0_0_0 + 0.0423280423280429*G0_0_2 + 0.0423280423280429*G0_2_0 + 0.0225749559082896*G0_2_2;
    A[954] = -0.112874779541446*G0_0_0 - 0.101587301587302*G0_0_2 - 0.101587301587302*G0_2_0 - 0.135449735449736*G0_2_2;
    A[955] = -0.0225749559082891*G0_0_0 - 0.011287477954145*G0_0_1 - 0.0112874779541447*G0_1_0;
    A[956] = 0.0169312169312166*G0_0_0 + 0.0197530864197532*G0_0_1 + 0.0197530864197529*G0_1_0 + 0.0225749559082891*G0_1_1;
    A[957] = 0.0225749559082899*G0_0_0 + 0.0338624338624338*G0_0_1 + 0.0338624338624343*G0_1_0 + 0.0451499118165786*G0_1_1;
    A[958] = 0.067724867724868*G0_0_0 + 0.067724867724868*G0_0_1 + 0.0564373897707236*G0_0_2 + 0.135449735449736*G0_1_0 + 0.135449735449736*G0_1_1 + 0.101587301587301*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 + 0.0677248677248671*G0_2_2;
    A[959] = -0.0846560846560849*G0_0_0 - 0.0846560846560851*G0_0_1 - 0.042328042328043*G0_0_2 - 0.270899470899471*G0_1_0 - 0.270899470899472*G0_1_1 - 0.177777777777778*G0_1_2 - 0.177777777777779*G0_2_0 - 0.177777777777779*G0_2_1 - 0.0169312169312162*G0_2_2;
    A[960] = 0.112874779541446*G0_0_0 + 0.112874779541446*G0_0_1 + 0.0112874779541449*G0_0_2 + 0.101587301587302*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 - 0.0677248677248679*G0_2_2;
    A[961] = 0.0225749559082893*G0_0_0 + 0.0112874779541449*G0_0_1 + 0.0225749559082892*G0_0_2 + 0.0564373897707235*G0_1_0 + 0.0225749559082891*G0_1_1 + 0.0564373897707234*G0_1_2 + 0.0902998236331572*G0_2_0 + 0.0564373897707227*G0_2_1 + 0.0902998236331572*G0_2_2;
    A[962] = -0.0169312169312168*G0_0_0 + 0.00282186948853606*G0_0_1 - 0.0169312169312168*G0_0_2 + 0.00282186948853632*G0_1_0 + 0.00564373897707248*G0_1_1 + 0.0028218694885363*G0_1_2 + 0.0677248677248682*G0_2_0 + 0.00282186948853665*G0_2_1 + 0.0677248677248682*G0_2_2;
    A[963] = -0.0225749559082897*G0_0_0 + 0.0112874779541445*G0_0_1 - 0.0225749559082897*G0_0_2 - 0.0338624338624343*G0_1_0 + 0.0225749559082891*G0_1_1 - 0.0338624338624343*G0_1_2 - 0.0338624338624344*G0_2_1;
    A[964] = 0.0112874779541448*G0_0_1 + 0.0112874779541448*G0_0_2 + 0.0112874779541445*G0_1_0 + 0.0451499118165789*G0_1_1 + 0.0451499118165789*G0_1_2 + 0.0112874779541445*G0_2_0 + 0.0451499118165789*G0_2_1 + 0.0451499118165789*G0_2_2;
    A[965] = 0.00282186948853608*G0_0_1 + 0.00282186948853611*G0_0_2 + 0.00282186948853634*G0_1_0 + 0.0225749559082893*G0_1_1 + 0.0225749559082893*G0_1_2 + 0.00282186948853633*G0_2_0 + 0.0225749559082893*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[966] = 0.011287477954145*G0_0_1 + 0.011287477954145*G0_0_2 + 0.0112874779541444*G0_1_0 + 0.0112874779541444*G0_2_0;
    A[967] = 0.135449735449736*G0_0_0 + 0.067724867724868*G0_0_1 + 0.0451499118165784*G0_0_2 + 0.0677248677248676*G0_1_0 + 0.0225749559082888*G0_1_2 + 0.0451499118165787*G0_2_0 + 0.0225749559082887*G0_2_1;
    A[968] = -0.0677248677248673*G0_0_1 + 0.0677248677248677*G0_0_2 - 0.0677248677248683*G0_1_0 - 0.135449735449736*G0_1_1 + 0.0451499118165785*G0_1_2 + 0.0677248677248675*G0_2_0 + 0.0451499118165784*G0_2_1;
    A[969] = -0.541798941798942*G0_0_0 - 0.270899470899471*G0_0_1 - 0.27089947089947*G0_0_2 - 0.270899470899471*G0_1_0 - 0.135449735449736*G0_1_2 - 0.270899470899471*G0_2_0 - 0.135449735449735*G0_2_1 + 0.0451499118165786*G0_2_2;
    A[970] = -0.135449735449736*G0_0_0 - 0.0677248677248683*G0_0_1 - 0.0902998236331573*G0_0_2 - 0.203174603174604*G0_1_0 - 0.135449735449736*G0_1_1 - 0.225749559082893*G0_1_2 - 0.361199294532629*G0_2_0 - 0.225749559082892*G0_2_1 - 0.451499118165786*G0_2_2;
    A[971] = -0.0677248677248675*G0_0_1 + 0.067724867724868*G0_0_2 + 0.0677248677248683*G0_1_0 - 0.135449735449736*G0_1_1 + 0.0902998236331576*G0_1_2 - 0.0677248677248675*G0_2_0 + 0.090299823633157*G0_2_1 - 0.135449735449735*G0_2_2;
    A[972] = 0.541798941798941*G0_0_0 + 0.270899470899471*G0_0_1 + 0.270899470899471*G0_0_2 + 0.270899470899471*G0_1_0 + 0.541798941798943*G0_1_1 + 0.270899470899471*G0_1_2 + 0.270899470899471*G0_2_0 + 0.270899470899471*G0_2_1 + 0.6320987654321*G0_2_2;
    A[973] = -0.0677248677248683*G0_0_1 - 0.045149911816579*G0_0_2 - 0.0677248677248681*G0_1_0 - 0.135449735449736*G0_1_1 - 0.180599647266315*G0_1_2 - 0.0451499118165788*G0_2_0 - 0.180599647266315*G0_2_1 - 0.225749559082894*G0_2_2;
    A[974] = -0.0677248677248679*G0_0_1 - 0.0451499118165791*G0_0_2 - 0.0677248677248673*G0_1_0 - 0.0225749559082891*G0_1_2 - 0.045149911816578*G0_2_0 - 0.0225749559082888*G0_2_1 - 0.0451499118165787*G0_2_2;
    A[975] = 0.270899470899471*G0_0_1 + 0.135449735449737*G0_0_2 + 0.270899470899471*G0_1_0 + 0.135449735449736*G0_1_2 + 0.135449735449736*G0_2_0 + 0.135449735449735*G0_2_1 + 0.316049382716051*G0_2_2;
    A[976] = -0.0225749559082893*G0_0_1 - 0.0451499118165785*G0_0_2 - 0.0225749559082896*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.045149911816579*G0_2_0 + 0.0451499118165784*G0_2_2;
    A[977] = -0.0225749559082894*G0_0_1 - 0.0451499118165782*G0_0_2 - 0.0225749559082891*G0_1_0 - 0.0451499118165786*G0_1_1 - 0.0225749559082888*G0_1_2 - 0.0451499118165779*G0_2_0 - 0.0225749559082893*G0_2_1;
    A[978] = -0.0225749559082892*G0_0_1 - 0.0677248677248678*G0_0_2 - 0.0225749559082892*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.0451499118165784*G0_1_2 - 0.0677248677248682*G0_2_0 - 0.0451499118165787*G0_2_1;
    A[979] = 0.135449735449736*G0_0_1 + 0.316049382716049*G0_0_2 + 0.135449735449736*G0_1_0 + 0.270899470899472*G0_1_1 + 0.135449735449736*G0_1_2 + 0.31604938271605*G0_2_0 + 0.135449735449737*G0_2_1 - 0.0902998236331569*G0_2_2;
    A[980] = 0.042328042328042*G0_0_0 + 0.042328042328042*G0_0_1 + 0.042328042328042*G0_0_2 + 0.0493827160493825*G0_1_0 + 0.0493827160493826*G0_1_1 + 0.0493827160493825*G0_1_2 + 0.0423280423280422*G0_2_0 + 0.0423280423280422*G0_2_1 + 0.0423280423280421*G0_2_2;
    A[981] = -0.0253968253968255*G0_0_0 - 0.00705467372134048*G0_1_0;
    A[982] = 0.0183421516754848*G0_1_1;
    A[983] = -0.00705467372134036*G0_1_2 - 0.0253968253968253*G0_2_2;
    A[984] = -0.0225749559082893*G0_1_1 - 0.0112874779541452*G0_1_2 - 0.0112874779541444*G0_2_1;
    A[985] = 0.0169312169312173*G0_1_1 + 0.0197530864197541*G0_1_2 + 0.0197530864197532*G0_2_1 + 0.02257495590829*G0_2_2;
    A[986] = 0.0225749559082895*G0_1_1 + 0.0338624338624338*G0_1_2 + 0.0338624338624345*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[987] = 0.0902998236331567*G0_0_0 + 0.0338624338624336*G0_0_2 + 0.0677248677248678*G0_1_0 + 0.022574955908289*G0_1_2 + 0.0338624338624342*G0_2_0;
    A[988] = 0.0677248677248677*G0_0_0 + 0.0649029982363318*G0_0_2 + 0.0846560846560843*G0_1_0 + 0.0846560846560848*G0_1_2 + 0.0649029982363311*G0_2_0 + 0.067724867724868*G0_2_2;
    A[989] = 0.0338624338624337*G0_0_2 + 0.0225749559082895*G0_1_0 + 0.0677248677248677*G0_1_2 + 0.0338624338624345*G0_2_0 + 0.090299823633157*G0_2_2;
    A[990] = 0.0451499118165784*G0_0_0 + 0.0338624338624336*G0_0_1 + 0.0338624338624339*G0_1_0 + 0.022574955908289*G0_1_1;
    A[991] = 0.0225749559082892*G0_0_0 + 0.0197530864197533*G0_0_1 + 0.0197530864197531*G0_1_0 + 0.0169312169312169*G0_1_1;
    A[992] = -0.0112874779541449*G0_0_1 - 0.0112874779541452*G0_1_0 - 0.0225749559082896*G0_1_1;
    A[993] = -0.270899470899471*G0_0_0 - 0.270899470899471*G0_0_1 - 0.169312169312169*G0_0_2 - 0.0677248677248678*G0_1_0 - 0.0677248677248676*G0_1_1 - 0.0790123456790118*G0_1_2 - 0.16931216931217*G0_2_0 - 0.16931216931217*G0_2_1 - 0.0677248677248672*G0_2_2;
    A[994] = 0.0677248677248679*G0_0_0 + 0.0677248677248679*G0_0_1 + 0.16084656084656*G0_0_2 + 0.118518518518519*G0_1_0 + 0.118518518518519*G0_1_1 + 0.0253968253968248*G0_1_2 + 0.160846560846562*G0_2_0 + 0.160846560846562*G0_2_1 - 0.0169312169312175*G0_2_2;
    A[995] = -0.0338624338624332*G0_0_2 - 0.0225749559082895*G0_1_0 - 0.0225749559082895*G0_1_1 + 0.011287477954145*G0_1_2 - 0.0338624338624345*G0_2_0 - 0.0338624338624345*G0_2_1 + 0.067724867724868*G0_2_2;
    A[996] = -0.135449735449736*G0_0_0 - 0.0338624338624333*G0_0_1 - 0.135449735449736*G0_0_2 - 0.0338624338624342*G0_1_0 - 0.0451499118165783*G0_1_1 - 0.0338624338624341*G0_1_2 - 0.135449735449736*G0_2_0 - 0.0338624338624337*G0_2_1 - 0.135449735449736*G0_2_2;
    A[997] = 0.0225749559082894*G0_0_0 - 0.0197530864197536*G0_0_1 + 0.0225749559082893*G0_0_2 - 0.0197530864197531*G0_1_0 + 0.0225749559082891*G0_1_1 - 0.0197530864197532*G0_1_2 + 0.0225749559082892*G0_2_0 - 0.0197530864197534*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[998] = 0.0112874779541449*G0_0_1 + 0.0112874779541452*G0_1_0 - 0.0451499118165782*G0_1_1 + 0.0112874779541452*G0_1_2 + 0.0112874779541451*G0_2_1;
    A[999] = -0.0677248677248674*G0_0_0 - 0.16931216931217*G0_0_1 - 0.16931216931217*G0_0_2 - 0.0790123456790122*G0_1_0 - 0.0677248677248681*G0_1_1 - 0.0677248677248681*G0_1_2 - 0.169312169312169*G0_2_0 - 0.270899470899472*G0_2_1 - 0.270899470899472*G0_2_2;
    A[1000] = -0.0169312169312171*G0_0_0 + 0.160846560846561*G0_0_1 + 0.160846560846561*G0_0_2 + 0.0253968253968251*G0_1_0 + 0.118518518518518*G0_1_1 + 0.118518518518518*G0_1_2 + 0.16084656084656*G0_2_0 + 0.0677248677248675*G0_2_1 + 0.0677248677248675*G0_2_2;
    A[1001] = 0.0677248677248679*G0_0_0 - 0.0338624338624336*G0_0_1 - 0.0338624338624336*G0_0_2 + 0.0112874779541449*G0_1_0 - 0.0225749559082891*G0_1_1 - 0.0225749559082891*G0_1_2 - 0.0338624338624334*G0_2_0;
    A[1002] = 0.0451499118165789*G0_0_0 + 0.0902998236331565*G0_0_1 + 0.0451499118165783*G0_0_2 + 0.0902998236331567*G0_1_0 + 0.135449735449735*G0_1_1 + 0.0677248677248678*G0_1_2 + 0.0451499118165789*G0_2_0 + 0.0677248677248683*G0_2_1;
    A[1003] = 0.0451499118165798*G0_0_1 + 0.0225749559082892*G0_0_2 + 0.0451499118165788*G0_1_0 + 0.0902998236331572*G0_1_1 + 0.045149911816578*G0_1_2 + 0.0225749559082901*G0_2_0 + 0.0451499118165795*G0_2_1;
    A[1004] = 0.0677248677248681*G0_0_1 + 0.0451499118165799*G0_0_2 + 0.0677248677248683*G0_1_0 + 0.135449735449735*G0_1_1 + 0.0902998236331575*G0_1_2 + 0.0451499118165791*G0_2_0 + 0.0902998236331569*G0_2_1 + 0.0451499118165792*G0_2_2;
    A[1005] = 0.0451499118165787*G0_0_0 + 0.31604938271605*G0_0_1 + 0.180599647266315*G0_0_2 + 0.31604938271605*G0_1_0 + 0.0451499118165789*G0_1_1 + 0.180599647266315*G0_1_2 + 0.180599647266315*G0_2_0 + 0.180599647266315*G0_2_1 + 0.316049382716052*G0_2_2;
    A[1006] = -0.0451499118165786*G0_0_1 - 0.0225749559082899*G0_0_2 - 0.0451499118165788*G0_1_0 + 0.0451499118165782*G0_1_1 - 0.0225749559082901*G0_2_0 - 0.0451499118165794*G0_2_2;
    A[1007] = -0.0677248677248681*G0_0_1 - 0.0451499118165788*G0_0_2 - 0.0677248677248683*G0_1_0 - 0.135449735449736*G0_1_1 - 0.180599647266315*G0_1_2 - 0.045149911816579*G0_2_0 - 0.180599647266315*G0_2_1 - 0.225749559082894*G0_2_2;
    A[1008] = 0.632098765432099*G0_0_0 + 0.361199294532628*G0_0_1 + 0.361199294532629*G0_0_2 + 0.361199294532628*G0_1_0 + 0.632098765432099*G0_1_1 + 0.361199294532629*G0_1_2 + 0.361199294532629*G0_2_0 + 0.361199294532629*G0_2_1 + 0.632098765432101*G0_2_2;
    A[1009] = -0.451499118165784*G0_0_0 - 0.0902998236331568*G0_0_1 - 0.225749559082893*G0_0_2 - 0.361199294532628*G0_1_0 - 0.135449735449735*G0_1_1 - 0.203174603174602*G0_1_2 - 0.225749559082893*G0_2_0 - 0.0677248677248683*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1010] = -0.135449735449736*G0_0_0 - 0.0677248677248683*G0_0_1 - 0.225749559082893*G0_0_2 - 0.203174603174603*G0_1_0 - 0.135449735449736*G0_1_1 - 0.361199294532629*G0_1_2 - 0.225749559082893*G0_2_0 - 0.0902998236331571*G0_2_1 - 0.451499118165786*G0_2_2;
    A[1011] = 0.31604938271605*G0_0_0 + 0.180599647266315*G0_0_1 + 0.180599647266314*G0_0_2 + 0.180599647266314*G0_1_0 + 0.045149911816579*G0_1_1 + 0.316049382716049*G0_1_2 + 0.180599647266315*G0_2_0 + 0.31604938271605*G0_2_1 + 0.0451499118165784*G0_2_2;
    A[1012] = -0.225749559082892*G0_0_0 - 0.180599647266314*G0_0_1 - 0.0451499118165783*G0_0_2 - 0.180599647266314*G0_1_0 - 0.135449735449735*G0_1_1 - 0.0677248677248676*G0_1_2 - 0.0451499118165785*G0_2_0 - 0.0677248677248675*G0_2_1;
    A[1013] = -0.0451499118165786*G0_0_0 - 0.022574955908289*G0_0_2 + 0.0451499118165786*G0_1_1 - 0.0451499118165775*G0_1_2 - 0.0225749559082892*G0_2_0 - 0.0451499118165787*G0_2_1;
    A[1014] = -0.0902998236331579*G0_0_0 - 0.406349206349207*G0_0_1 - 0.225749559082894*G0_0_2 - 0.406349206349207*G0_1_0 - 0.722398589065256*G0_1_1 - 0.406349206349207*G0_1_2 - 0.225749559082894*G0_2_0 - 0.406349206349208*G0_2_1 - 0.0902998236331579*G0_2_2;
    A[1015] = -0.0253968253968251*G0_0_0 - 0.0253968253968251*G0_0_1 - 0.0253968253968251*G0_0_2 - 0.0183421516754849*G0_1_0 - 0.0183421516754848*G0_1_1 - 0.0183421516754849*G0_1_2 - 0.0253968253968253*G0_2_0 - 0.0253968253968253*G0_2_1 - 0.0253968253968254*G0_2_2;
    A[1016] = 0.0423280423280424*G0_0_0 - 0.00705467372134026*G0_1_0;
    A[1017] = 0.0183421516754849*G0_1_1;
    A[1018] = -0.00705467372134038*G0_1_2 - 0.0253968253968254*G0_2_2;
    A[1019] = -0.0225749559082893*G0_1_1 - 0.0112874779541447*G0_1_2 - 0.0112874779541447*G0_2_1;
    A[1020] = 0.0169312169312169*G0_1_1 + 0.019753086419753*G0_1_2 + 0.0197530864197532*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[1021] = 0.0225749559082892*G0_1_1 + 0.0338624338624338*G0_1_2 + 0.0338624338624341*G0_2_1 + 0.0451499118165789*G0_2_2;
    A[1022] = -0.270899470899471*G0_0_0 - 0.101587301587302*G0_0_2 - 0.203174603174603*G0_1_0 - 0.112874779541446*G0_1_2 - 0.101587301587301*G0_2_0;
    A[1023] = 0.0677248677248681*G0_0_0 - 0.093121693121693*G0_0_2 - 0.0507936507936508*G0_1_0 - 0.186243386243386*G0_1_2 - 0.0931216931216934*G0_2_0 - 0.270899470899472*G0_2_2;
    A[1024] = 0.0338624338624339*G0_0_2 + 0.0225749559082892*G0_1_0 + 0.0677248677248678*G0_1_2 + 0.0338624338624341*G0_2_0 + 0.135449735449736*G0_2_2;
    A[1025] = -0.135449735449735*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587301*G0_1_0 - 0.112874779541446*G0_1_1;
    A[1026] = 0.0225749559082895*G0_0_0 + 0.0423280423280425*G0_0_1 + 0.0423280423280426*G0_1_0 + 0.084656084656085*G0_1_1;
    A[1027] = -0.0112874779541445*G0_0_1 - 0.0112874779541447*G0_1_0 - 0.0677248677248677*G0_1_1;
    A[1028] = 0.0902998236331569*G0_0_0 + 0.0902998236331567*G0_0_1 + 0.0564373897707224*G0_0_2 + 0.0225749559082894*G0_1_0 + 0.0225749559082894*G0_1_1 + 0.0112874779541444*G0_1_2 + 0.0564373897707234*G0_2_0 + 0.0564373897707232*G0_2_1 + 0.0225749559082894*G0_2_2;
    A[1029] = 0.0677248677248675*G0_0_0 + 0.0677248677248675*G0_0_1 + 0.00282186948853692*G0_0_2 - 0.0169312169312176*G0_1_0 - 0.0169312169312176*G0_1_1 + 0.0028218694885362*G0_1_2 + 0.00282186948853595*G0_2_0 + 0.00282186948853597*G0_2_1 + 0.00564373897707188*G0_2_2;
    A[1030] = -0.0338624338624343*G0_0_2 - 0.0225749559082893*G0_1_0 - 0.0225749559082892*G0_1_1 + 0.0112874779541445*G0_1_2 - 0.0338624338624341*G0_2_0 - 0.0338624338624341*G0_2_1 + 0.0225749559082894*G0_2_2;
    A[1031] = 0.0451499118165786*G0_0_0 + 0.0112874779541442*G0_0_1 + 0.0451499118165785*G0_0_2 + 0.011287477954145*G0_1_0 + 0.011287477954145*G0_1_2 + 0.0451499118165787*G0_2_0 + 0.0112874779541446*G0_2_1 + 0.0451499118165787*G0_2_2;
    A[1032] = 0.0225749559082893*G0_0_0 + 0.00282186948853653*G0_0_1 + 0.0225749559082892*G0_0_2 + 0.00282186948853595*G0_1_0 + 0.00282186948853588*G0_1_2 + 0.0225749559082892*G0_2_0 + 0.00282186948853604*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[1033] = 0.0112874779541444*G0_0_1 + 0.0112874779541447*G0_1_0 + 0.0112874779541447*G0_1_2 + 0.0112874779541447*G0_2_1;
    A[1034] = 0.0677248677248673*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.0564373897707228*G0_1_0 + 0.067724867724868*G0_1_1 + 0.0677248677248679*G0_1_2 + 0.101587301587301*G0_2_0 + 0.135449735449735*G0_2_1 + 0.135449735449736*G0_2_2;
    A[1035] = -0.0169312169312166*G0_0_0 - 0.177777777777777*G0_0_1 - 0.177777777777777*G0_0_2 - 0.0423280423280418*G0_1_0 - 0.084656084656084*G0_1_1 - 0.0846560846560841*G0_1_2 - 0.177777777777778*G0_2_0 - 0.270899470899471*G0_2_1 - 0.270899470899471*G0_2_2;
    A[1036] = -0.0677248677248679*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.0112874779541442*G0_1_0 + 0.112874779541446*G0_1_1 + 0.112874779541446*G0_1_2 + 0.101587301587301*G0_2_0;
    A[1037] = 0.0451499118165791*G0_0_0 - 0.27089947089947*G0_0_1 - 0.135449735449735*G0_0_2 - 0.27089947089947*G0_1_0 - 0.541798941798942*G0_1_1 - 0.27089947089947*G0_1_2 - 0.135449735449735*G0_2_0 - 0.27089947089947*G0_2_1;
    A[1038] = 0.0451499118165782*G0_0_1 + 0.0225749559082896*G0_0_2 + 0.0451499118165785*G0_1_0 + 0.135449735449736*G0_1_1 + 0.0677248677248681*G0_1_2 + 0.0225749559082893*G0_2_0 + 0.0677248677248678*G0_2_1;
    A[1039] = 0.0677248677248679*G0_0_1 + 0.0451499118165781*G0_0_2 + 0.0677248677248678*G0_1_0 - 0.0677248677248676*G0_1_2 + 0.0451499118165791*G0_2_0 - 0.0677248677248673*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1040] = 0.0451499118165784*G0_0_0 - 0.0451499118165784*G0_0_1 - 0.0451499118165787*G0_1_0 - 0.0225749559082902*G0_1_2 - 0.0225749559082894*G0_2_1 - 0.0451499118165789*G0_2_2;
    A[1041] = -0.0451499118165784*G0_0_1 - 0.0225749559082888*G0_0_2 - 0.0451499118165784*G0_1_0 - 0.0225749559082887*G0_1_2 - 0.0225749559082893*G0_2_0 - 0.0225749559082891*G0_2_1 - 0.0451499118165783*G0_2_2;
    A[1042] = -0.0677248677248673*G0_0_1 - 0.045149911816578*G0_0_2 - 0.0677248677248679*G0_1_0 - 0.0225749559082888*G0_1_2 - 0.0451499118165791*G0_2_0 - 0.0225749559082891*G0_2_1 - 0.0451499118165787*G0_2_2;
    A[1043] = -0.451499118165784*G0_0_0 - 0.361199294532628*G0_0_1 - 0.225749559082893*G0_0_2 - 0.0902998236331568*G0_1_0 - 0.135449735449735*G0_1_1 - 0.0677248677248683*G0_1_2 - 0.225749559082892*G0_2_0 - 0.203174603174602*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1044] = 0.632098765432098*G0_0_0 + 0.27089947089947*G0_0_1 + 0.27089947089947*G0_0_2 + 0.27089947089947*G0_1_0 + 0.541798941798941*G0_1_1 + 0.27089947089947*G0_1_2 + 0.27089947089947*G0_2_0 + 0.27089947089947*G0_2_1 + 0.541798941798942*G0_2_2;
    A[1045] = -0.135449735449736*G0_0_0 - 0.0677248677248678*G0_0_1 + 0.0902998236331573*G0_0_2 + 0.0677248677248682*G0_1_0 - 0.0677248677248674*G0_1_2 + 0.0902998236331574*G0_2_0 + 0.0677248677248673*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1046] = -0.225749559082892*G0_0_0 - 0.0451499118165787*G0_0_1 - 0.180599647266313*G0_0_2 - 0.0451499118165788*G0_1_0 - 0.0677248677248674*G0_1_2 - 0.180599647266314*G0_2_0 - 0.0677248677248677*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1047] = 0.316049382716049*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449735*G0_1_0 + 0.27089947089947*G0_1_2 + 0.135449735449735*G0_2_0 + 0.270899470899471*G0_2_1;
    A[1048] = -0.0451499118165788*G0_0_0 - 0.0451499118165786*G0_0_1 - 0.0225749559082898*G0_0_2 - 0.0451499118165786*G0_1_0 - 0.0677248677248681*G0_1_2 - 0.0225749559082894*G0_2_0 - 0.0677248677248679*G0_2_1;
    A[1049] = -0.0902998236331572*G0_0_0 + 0.316049382716049*G0_0_1 + 0.135449735449735*G0_0_2 + 0.316049382716049*G0_1_0 + 0.135449735449735*G0_1_2 + 0.135449735449735*G0_2_0 + 0.135449735449734*G0_2_1 + 0.27089947089947*G0_2_2;
    A[1050] = -0.0253968253968253*G0_0_0 - 0.0253968253968253*G0_0_1 - 0.0253968253968253*G0_0_2 - 0.0183421516754853*G0_1_0 - 0.0183421516754853*G0_1_1 - 0.0183421516754853*G0_1_2 - 0.0253968253968253*G0_2_0 - 0.0253968253968253*G0_2_1 - 0.0253968253968252*G0_2_2;
    A[1051] = -0.0253968253968254*G0_0_0 - 0.00705467372134063*G0_1_0;
    A[1052] = 0.0183421516754851*G0_1_1;
    A[1053] = -0.00705467372134029*G0_1_2 + 0.0423280423280423*G0_2_2;
    A[1054] = -0.0677248677248678*G0_1_1 - 0.0112874779541445*G0_1_2 - 0.0112874779541447*G0_2_1;
    A[1055] = 0.0846560846560847*G0_1_1 + 0.0423280423280424*G0_1_2 + 0.0423280423280422*G0_2_1 + 0.0225749559082886*G0_2_2;
    A[1056] = -0.112874779541446*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1057] = 0.135449735449736*G0_0_0 + 0.0338624338624342*G0_0_2 + 0.067724867724868*G0_1_0 + 0.022574955908289*G0_1_2 + 0.0338624338624335*G0_2_0;
    A[1058] = -0.270899470899471*G0_0_0 - 0.0931216931216937*G0_0_2 - 0.186243386243387*G0_1_0 - 0.0507936507936504*G0_1_2 - 0.0931216931216927*G0_2_0 + 0.067724867724868*G0_2_2;
    A[1059] = -0.101587301587301*G0_0_2 - 0.112874779541446*G0_1_0 - 0.203174603174604*G0_1_2 - 0.101587301587302*G0_2_0 - 0.270899470899472*G0_2_2;
    A[1060] = 0.0451499118165786*G0_0_0 + 0.0338624338624341*G0_0_1 + 0.0338624338624341*G0_1_0 + 0.0225749559082891*G0_1_1;
    A[1061] = 0.0225749559082891*G0_0_0 + 0.0197530864197528*G0_0_1 + 0.0197530864197529*G0_1_0 + 0.016931216931217*G0_1_1;
    A[1062] = -0.0112874779541444*G0_0_1 - 0.0112874779541443*G0_1_0 - 0.0225749559082892*G0_1_1;
    A[1063] = 0.135449735449736*G0_0_0 + 0.135449735449736*G0_0_1 + 0.101587301587301*G0_0_2 + 0.0677248677248679*G0_1_0 + 0.0677248677248679*G0_1_1 + 0.0564373897707237*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 + 0.0677248677248671*G0_2_2;
    A[1064] = -0.270899470899471*G0_0_0 - 0.270899470899471*G0_0_1 - 0.177777777777777*G0_0_2 - 0.0846560846560845*G0_1_0 - 0.0846560846560846*G0_1_1 - 0.0423280423280429*G0_1_2 - 0.177777777777778*G0_2_0 - 0.177777777777779*G0_2_1 - 0.016931216931216*G0_2_2;
    A[1065] = 0.101587301587301*G0_0_2 + 0.112874779541446*G0_1_0 + 0.112874779541446*G0_1_1 + 0.0112874779541446*G0_1_2 + 0.101587301587302*G0_2_0 + 0.101587301587302*G0_2_1 - 0.0677248677248682*G0_2_2;
    A[1066] = 0.0451499118165789*G0_0_0 + 0.0112874779541446*G0_0_1 + 0.045149911816579*G0_0_2 + 0.0112874779541446*G0_1_0 + 0.0112874779541447*G0_1_2 + 0.0451499118165789*G0_2_0 + 0.0112874779541444*G0_2_1 + 0.0451499118165789*G0_2_2;
    A[1067] = 0.022574955908289*G0_0_0 + 0.00282186948853611*G0_0_1 + 0.022574955908289*G0_0_2 + 0.00282186948853596*G0_1_0 + 0.002821869488536*G0_1_2 + 0.0225749559082892*G0_2_0 + 0.00282186948853643*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[1068] = 0.0112874779541447*G0_0_1 + 0.0112874779541445*G0_1_0 + 0.0112874779541445*G0_1_2 + 0.0112874779541442*G0_2_1;
    A[1069] = 0.0225749559082892*G0_0_0 + 0.0564373897707235*G0_0_1 + 0.0564373897707235*G0_0_2 + 0.0112874779541451*G0_1_0 + 0.0225749559082893*G0_1_1 + 0.0225749559082894*G0_1_2 + 0.056437389770723*G0_2_0 + 0.0902998236331576*G0_2_1 + 0.0902998236331575*G0_2_2;
    A[1070] = 0.00564373897707241*G0_0_0 + 0.00282186948853617*G0_0_1 + 0.00282186948853616*G0_0_2 + 0.00282186948853587*G0_1_0 - 0.0169312169312171*G0_1_1 - 0.0169312169312171*G0_1_2 + 0.00282186948853634*G0_2_0 + 0.0677248677248679*G0_2_1 + 0.0677248677248679*G0_2_2;
    A[1071] = 0.0225749559082891*G0_0_0 - 0.0338624338624341*G0_0_1 - 0.0338624338624341*G0_0_2 + 0.0112874779541449*G0_1_0 - 0.022574955908289*G0_1_1 - 0.022574955908289*G0_1_2 - 0.0338624338624341*G0_2_0;
    A[1072] = -0.135449735449736*G0_0_0 - 0.0677248677248682*G0_0_1 + 0.0451499118165782*G0_0_2 - 0.0677248677248676*G0_1_0 + 0.0677248677248678*G0_1_2 + 0.0451499118165783*G0_2_0 + 0.0677248677248673*G0_2_1;
    A[1073] = 0.0677248677248671*G0_0_1 + 0.0225749559082892*G0_0_2 + 0.0677248677248678*G0_1_0 + 0.135449735449736*G0_1_1 + 0.0451499118165783*G0_1_2 + 0.0225749559082887*G0_2_0 + 0.0451499118165779*G0_2_1;
    A[1074] = -0.270899470899471*G0_0_1 - 0.135449735449736*G0_0_2 - 0.270899470899471*G0_1_0 - 0.541798941798943*G0_1_1 - 0.270899470899471*G0_1_2 - 0.135449735449737*G0_2_0 - 0.270899470899471*G0_2_1 + 0.0451499118165778*G0_2_2;
    A[1075] = -0.135449735449736*G0_0_0 - 0.0677248677248681*G0_0_1 - 0.180599647266315*G0_0_2 - 0.0677248677248679*G0_1_0 - 0.0451499118165786*G0_1_2 - 0.180599647266315*G0_2_0 - 0.0451499118165791*G0_2_1 - 0.225749559082894*G0_2_2;
    A[1076] = -0.0677248677248676*G0_0_1 - 0.0225749559082885*G0_0_2 - 0.0677248677248678*G0_1_0 - 0.0451499118165781*G0_1_2 - 0.0225749559082888*G0_2_0 - 0.0451499118165782*G0_2_1 - 0.0451499118165778*G0_2_2;
    A[1077] = 0.270899470899471*G0_0_1 + 0.135449735449736*G0_0_2 + 0.270899470899471*G0_1_0 + 0.135449735449735*G0_1_2 + 0.135449735449737*G0_2_0 + 0.135449735449736*G0_2_1 + 0.316049382716051*G0_2_2;
    A[1078] = -0.135449735449736*G0_0_0 - 0.203174603174603*G0_0_1 - 0.225749559082893*G0_0_2 - 0.0677248677248683*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0902998236331571*G0_1_2 - 0.225749559082893*G0_2_0 - 0.361199294532629*G0_2_1 - 0.451499118165786*G0_2_2;
    A[1079] = -0.135449735449736*G0_0_0 + 0.0677248677248682*G0_0_1 + 0.0902998236331574*G0_0_2 - 0.0677248677248678*G0_1_0 + 0.0677248677248674*G0_1_2 + 0.0902998236331573*G0_2_0 - 0.0677248677248674*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1080] = 0.541798941798942*G0_0_0 + 0.270899470899471*G0_0_1 + 0.270899470899471*G0_0_2 + 0.270899470899471*G0_1_0 + 0.541798941798943*G0_1_1 + 0.270899470899472*G0_1_2 + 0.270899470899471*G0_2_0 + 0.270899470899472*G0_2_1 + 0.6320987654321*G0_2_2;
    A[1081] = -0.045149911816579*G0_0_0 - 0.0225749559082898*G0_0_1 - 0.0225749559082895*G0_1_0 - 0.0451499118165787*G0_1_2 - 0.0451499118165793*G0_2_1 + 0.0451499118165781*G0_2_2;
    A[1082] = -0.0451499118165786*G0_0_0 - 0.0225749559082891*G0_0_1 - 0.0451499118165783*G0_0_2 - 0.0225749559082892*G0_1_0 - 0.0677248677248677*G0_1_2 - 0.0451499118165783*G0_2_0 - 0.067724867724868*G0_2_1;
    A[1083] = -0.0451499118165782*G0_0_0 - 0.0225749559082892*G0_0_1 - 0.0225749559082894*G0_0_2 - 0.0225749559082888*G0_1_0 - 0.0451499118165786*G0_1_2 - 0.0225749559082891*G0_2_0 - 0.0451499118165782*G0_2_1;
    A[1084] = 0.270899470899472*G0_0_0 + 0.135449735449736*G0_0_1 + 0.135449735449737*G0_0_2 + 0.135449735449736*G0_1_0 + 0.31604938271605*G0_1_2 + 0.135449735449737*G0_2_0 + 0.316049382716051*G0_2_1 - 0.0902998236331556*G0_2_2;
    A[1085] = 0.0423280423280421*G0_0_0 + 0.0423280423280421*G0_0_1 + 0.0423280423280421*G0_0_2 + 0.0423280423280422*G0_1_0 + 0.0423280423280422*G0_1_1 + 0.0423280423280422*G0_1_2 + 0.0493827160493826*G0_2_0 + 0.0493827160493826*G0_2_1 + 0.0493827160493826*G0_2_2;
    A[1086] = -0.0253968253968254*G0_0_0 - 0.00705467372134038*G0_2_0;
    A[1087] = -0.0253968253968254*G0_1_1 - 0.00705467372134047*G0_2_1;
    A[1088] = 0.018342151675485*G0_2_2;
    A[1089] = 0.0451499118165788*G0_1_1 + 0.0338624338624341*G0_1_2 + 0.0338624338624339*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1090] = 0.0225749559082893*G0_1_1 + 0.0197530864197531*G0_1_2 + 0.0197530864197532*G0_2_1 + 0.0169312169312173*G0_2_2;
    A[1091] = -0.0112874779541446*G0_1_2 - 0.0112874779541448*G0_2_1 - 0.0225749559082896*G0_2_2;
    A[1092] = 0.0451499118165784*G0_0_0 + 0.0338624338624338*G0_0_2 + 0.0338624338624337*G0_2_0 + 0.0225749559082892*G0_2_2;
    A[1093] = 0.0225749559082894*G0_0_0 + 0.0197530864197536*G0_0_2 + 0.0197530864197533*G0_2_0 + 0.0169312169312171*G0_2_2;
    A[1094] = -0.0112874779541448*G0_0_2 - 0.0112874779541448*G0_2_0 - 0.0225749559082893*G0_2_2;
    A[1095] = 0.0902998236331568*G0_0_0 + 0.0338624338624339*G0_0_1 + 0.033862433862434*G0_1_0 + 0.0677248677248677*G0_2_0 + 0.0225749559082892*G0_2_1;
    A[1096] = 0.0677248677248675*G0_0_0 + 0.0649029982363313*G0_0_1 + 0.0649029982363311*G0_1_0 + 0.0677248677248673*G0_1_1 + 0.0846560846560842*G0_2_0 + 0.0846560846560842*G0_2_1;
    A[1097] = 0.0338624338624337*G0_0_1 + 0.0338624338624341*G0_1_0 + 0.0902998236331571*G0_1_1 + 0.0225749559082891*G0_2_0 + 0.0677248677248675*G0_2_1;
    A[1098] = -0.135449735449736*G0_0_0 - 0.135449735449735*G0_0_1 - 0.0338624338624334*G0_0_2 - 0.135449735449736*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0338624338624336*G0_1_2 - 0.0338624338624336*G0_2_0 - 0.0338624338624335*G0_2_1 - 0.0451499118165782*G0_2_2;
    A[1099] = 0.0225749559082896*G0_0_0 + 0.0225749559082896*G0_0_1 - 0.0197530864197535*G0_0_2 + 0.0225749559082897*G0_1_0 + 0.0225749559082896*G0_1_1 - 0.0197530864197532*G0_1_2 - 0.0197530864197531*G0_2_0 - 0.0197530864197532*G0_2_1 + 0.0225749559082892*G0_2_2;
    A[1100] = 0.0112874779541449*G0_0_2 + 0.0112874779541448*G0_1_2 + 0.0112874779541447*G0_2_0 + 0.0112874779541448*G0_2_1 - 0.0451499118165783*G0_2_2;
    A[1101] = -0.270899470899471*G0_0_0 - 0.169312169312169*G0_0_1 - 0.270899470899471*G0_0_2 - 0.16931216931217*G0_1_0 - 0.0677248677248675*G0_1_1 - 0.16931216931217*G0_1_2 - 0.0677248677248675*G0_2_0 - 0.0790123456790122*G0_2_1 - 0.0677248677248675*G0_2_2;
    A[1102] = 0.0677248677248675*G0_0_0 + 0.16084656084656*G0_0_1 + 0.0677248677248674*G0_0_2 + 0.160846560846561*G0_1_0 - 0.0169312169312173*G0_1_1 + 0.160846560846561*G0_1_2 + 0.118518518518518*G0_2_0 + 0.0253968253968253*G0_2_1 + 0.118518518518518*G0_2_2;
    A[1103] = -0.0338624338624335*G0_0_1 - 0.033862433862434*G0_1_0 + 0.067724867724868*G0_1_1 - 0.033862433862434*G0_1_2 - 0.022574955908289*G0_2_0 + 0.0112874779541447*G0_2_1 - 0.0225749559082889*G0_2_2;
    A[1104] = -0.0677248677248674*G0_0_0 - 0.16931216931217*G0_0_1 - 0.16931216931217*G0_0_2 - 0.169312169312169*G0_1_0 - 0.270899470899471*G0_1_1 - 0.270899470899471*G0_1_2 - 0.0790123456790121*G0_2_0 - 0.0677248677248675*G0_2_1 - 0.0677248677248675*G0_2_2;
    A[1105] = -0.0169312169312172*G0_0_0 + 0.160846560846561*G0_0_1 + 0.160846560846561*G0_0_2 + 0.16084656084656*G0_1_0 + 0.0677248677248673*G0_1_1 + 0.0677248677248674*G0_1_2 + 0.0253968253968251*G0_2_0 + 0.118518518518518*G0_2_1 + 0.118518518518518*G0_2_2;
    A[1106] = 0.0677248677248678*G0_0_0 - 0.0338624338624337*G0_0_1 - 0.0338624338624338*G0_0_2 - 0.0338624338624335*G0_1_0 + 0.0112874779541448*G0_2_0 - 0.0225749559082891*G0_2_1 - 0.0225749559082891*G0_2_2;
    A[1107] = 0.0451499118165789*G0_0_0 + 0.0451499118165787*G0_0_1 + 0.0902998236331567*G0_0_2 + 0.0451499118165786*G0_1_0 + 0.0677248677248673*G0_1_2 + 0.0902998236331567*G0_2_0 + 0.0677248677248675*G0_2_1 + 0.135449735449735*G0_2_2;
    A[1108] = 0.0451499118165788*G0_0_1 + 0.0677248677248674*G0_0_2 + 0.045149911816579*G0_1_0 + 0.0451499118165786*G0_1_1 + 0.0902998236331569*G0_1_2 + 0.0677248677248675*G0_2_0 + 0.0902998236331564*G0_2_1 + 0.135449735449734*G0_2_2;
    A[1109] = 0.0225749559082895*G0_0_1 + 0.0451499118165793*G0_0_2 + 0.0225749559082894*G0_1_0 + 0.0451499118165791*G0_1_2 + 0.0451499118165787*G0_2_0 + 0.0451499118165786*G0_2_1 + 0.0902998236331574*G0_2_2;
    A[1110] = 0.0451499118165789*G0_0_0 + 0.180599647266314*G0_0_1 + 0.31604938271605*G0_0_2 + 0.180599647266315*G0_1_0 + 0.31604938271605*G0_1_1 + 0.180599647266315*G0_1_2 + 0.31604938271605*G0_2_0 + 0.180599647266314*G0_2_1 + 0.0451499118165786*G0_2_2;
    A[1111] = -0.0451499118165786*G0_0_1 - 0.0677248677248678*G0_0_2 - 0.0451499118165789*G0_1_0 - 0.225749559082893*G0_1_1 - 0.180599647266314*G0_1_2 - 0.0677248677248675*G0_2_0 - 0.180599647266314*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1112] = -0.0225749559082895*G0_0_1 - 0.045149911816579*G0_0_2 - 0.0225749559082893*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.0451499118165785*G0_2_0 + 0.0451499118165784*G0_2_2;
    A[1113] = 0.31604938271605*G0_0_0 + 0.180599647266314*G0_0_1 + 0.180599647266315*G0_0_2 + 0.180599647266315*G0_1_0 + 0.045149911816579*G0_1_1 + 0.31604938271605*G0_1_2 + 0.180599647266314*G0_2_0 + 0.316049382716049*G0_2_1 + 0.0451499118165784*G0_2_2;
    A[1114] = -0.225749559082892*G0_0_0 - 0.0451499118165788*G0_0_1 - 0.180599647266314*G0_0_2 - 0.0451499118165787*G0_1_0 - 0.0677248677248677*G0_1_2 - 0.180599647266313*G0_2_0 - 0.0677248677248674*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1115] = -0.045149911816579*G0_0_0 - 0.0225749559082895*G0_0_1 - 0.0225749559082898*G0_1_0 - 0.0451499118165793*G0_1_2 - 0.0451499118165788*G0_2_1 + 0.0451499118165781*G0_2_2;
    A[1116] = 0.632098765432099*G0_0_0 + 0.361199294532628*G0_0_1 + 0.361199294532628*G0_0_2 + 0.361199294532628*G0_1_0 + 0.632098765432099*G0_1_1 + 0.361199294532628*G0_1_2 + 0.361199294532627*G0_2_0 + 0.361199294532628*G0_2_1 + 0.632098765432099*G0_2_2;
    A[1117] = -0.451499118165785*G0_0_0 - 0.225749559082892*G0_0_1 - 0.0902998236331567*G0_0_2 - 0.225749559082892*G0_1_0 - 0.135449735449735*G0_1_1 - 0.0677248677248675*G0_1_2 - 0.361199294532628*G0_2_0 - 0.203174603174602*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1118] = -0.135449735449735*G0_0_0 - 0.225749559082892*G0_0_1 - 0.0677248677248671*G0_0_2 - 0.225749559082892*G0_1_0 - 0.451499118165785*G0_1_1 - 0.0902998236331566*G0_1_2 - 0.203174603174603*G0_2_0 - 0.361199294532628*G0_2_1 - 0.135449735449734*G0_2_2;
    A[1119] = -0.0902998236331582*G0_0_0 - 0.225749559082893*G0_0_1 - 0.406349206349207*G0_0_2 - 0.225749559082894*G0_1_0 - 0.0902998236331575*G0_1_1 - 0.406349206349207*G0_1_2 - 0.406349206349207*G0_2_0 - 0.406349206349206*G0_2_1 - 0.722398589065256*G0_2_2;
    A[1120] = -0.0253968253968252*G0_0_0 - 0.0253968253968252*G0_0_1 - 0.0253968253968252*G0_0_2 - 0.0253968253968253*G0_1_0 - 0.0253968253968254*G0_1_1 - 0.0253968253968253*G0_1_2 - 0.0183421516754849*G0_2_0 - 0.0183421516754849*G0_2_1 - 0.0183421516754848*G0_2_2;
    A[1121] = 0.0423280423280422*G0_0_0 - 0.00705467372134043*G0_2_0;
    A[1122] = -0.0253968253968254*G0_1_1 - 0.00705467372134051*G0_2_1;
    A[1123] = 0.0183421516754851*G0_2_2;
    A[1124] = 0.0451499118165786*G0_1_1 + 0.0338624338624339*G0_1_2 + 0.0338624338624339*G0_2_1 + 0.022574955908289*G0_2_2;
    A[1125] = 0.0225749559082893*G0_1_1 + 0.0197530864197531*G0_1_2 + 0.0197530864197531*G0_2_1 + 0.0169312169312171*G0_2_2;
    A[1126] = -0.0112874779541445*G0_1_2 - 0.0112874779541449*G0_2_1 - 0.0225749559082897*G0_2_2;
    A[1127] = -0.135449735449735*G0_0_0 - 0.101587301587302*G0_0_2 - 0.101587301587301*G0_2_0 - 0.112874779541446*G0_2_2;
    A[1128] = 0.0225749559082892*G0_0_0 + 0.0423280423280423*G0_0_2 + 0.0423280423280425*G0_2_0 + 0.0846560846560851*G0_2_2;
    A[1129] = -0.0112874779541446*G0_0_2 - 0.0112874779541448*G0_2_0 - 0.0677248677248681*G0_2_2;
    A[1130] = -0.270899470899471*G0_0_0 - 0.101587301587302*G0_0_1 - 0.101587301587301*G0_1_0 - 0.203174603174603*G0_2_0 - 0.112874779541446*G0_2_1;
    A[1131] = 0.0677248677248679*G0_0_0 - 0.0931216931216928*G0_0_1 - 0.0931216931216933*G0_1_0 - 0.270899470899471*G0_1_1 - 0.0507936507936508*G0_2_0 - 0.186243386243386*G0_2_1;
    A[1132] = 0.0338624338624338*G0_0_1 + 0.033862433862434*G0_1_0 + 0.135449735449736*G0_1_1 + 0.0225749559082891*G0_2_0 + 0.0677248677248677*G0_2_1;
    A[1133] = 0.0451499118165785*G0_0_0 + 0.0451499118165783*G0_0_1 + 0.0112874779541441*G0_0_2 + 0.0451499118165786*G0_1_0 + 0.0451499118165784*G0_1_1 + 0.0112874779541447*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541446*G0_2_1;
    A[1134] = 0.0225749559082893*G0_0_0 + 0.0225749559082892*G0_0_1 + 0.00282186948853655*G0_0_2 + 0.0225749559082891*G0_1_0 + 0.0225749559082892*G0_1_1 + 0.00282186948853577*G0_1_2 + 0.00282186948853563*G0_2_0 + 0.00282186948853566*G0_2_1;
    A[1135] = 0.0112874779541443*G0_0_2 + 0.0112874779541447*G0_1_2 + 0.0112874779541448*G0_2_0 + 0.0112874779541449*G0_2_1;
    A[1136] = 0.090299823633157*G0_0_0 + 0.0564373897707228*G0_0_1 + 0.090299823633157*G0_0_2 + 0.056437389770723*G0_1_0 + 0.0225749559082892*G0_1_1 + 0.0564373897707229*G0_1_2 + 0.0225749559082893*G0_2_0 + 0.0112874779541444*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[1137] = 0.0677248677248676*G0_0_0 + 0.00282186948853633*G0_0_1 + 0.0677248677248677*G0_0_2 + 0.00282186948853632*G0_1_0 + 0.00564373897707231*G0_1_1 + 0.00282186948853639*G0_1_2 - 0.016931216931217*G0_2_0 + 0.00282186948853621*G0_2_1 - 0.0169312169312171*G0_2_2;
    A[1138] = -0.0338624338624339*G0_0_1 - 0.033862433862434*G0_1_0 + 0.0225749559082892*G0_1_1 - 0.0338624338624341*G0_1_2 - 0.0225749559082891*G0_2_0 + 0.0112874779541446*G0_2_1 - 0.0225749559082892*G0_2_2;
    A[1139] = 0.0677248677248673*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587301*G0_1_0 + 0.135449735449735*G0_1_1 + 0.135449735449735*G0_1_2 + 0.0564373897707228*G0_2_0 + 0.0677248677248677*G0_2_1 + 0.0677248677248676*G0_2_2;
    A[1140] = -0.0169312169312166*G0_0_0 - 0.177777777777778*G0_0_1 - 0.177777777777778*G0_0_2 - 0.177777777777778*G0_1_0 - 0.270899470899471*G0_1_1 - 0.270899470899471*G0_1_2 - 0.0423280423280418*G0_2_0 - 0.0846560846560841*G0_2_1 - 0.0846560846560841*G0_2_2;
    A[1141] = -0.0677248677248677*G0_0_0 + 0.101587301587302*G0_0_1 + 0.101587301587302*G0_0_2 + 0.101587301587302*G0_1_0 + 0.0112874779541445*G0_2_0 + 0.112874779541446*G0_2_1 + 0.112874779541446*G0_2_2;
    A[1142] = 0.0451499118165786*G0_0_0 - 0.135449735449735*G0_0_1 - 0.270899470899471*G0_0_2 - 0.135449735449735*G0_1_0 - 0.27089947089947*G0_1_2 - 0.270899470899471*G0_2_0 - 0.27089947089947*G0_2_1 - 0.541798941798942*G0_2_2;
    A[1143] = 0.0451499118165787*G0_0_1 + 0.0677248677248681*G0_0_2 + 0.0451499118165785*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0677248677248678*G0_1_2 + 0.0677248677248677*G0_2_0 - 0.0677248677248679*G0_2_1;
    A[1144] = 0.0225749559082892*G0_0_1 + 0.0451499118165782*G0_0_2 + 0.0225749559082894*G0_1_0 + 0.0677248677248678*G0_1_2 + 0.0451499118165781*G0_2_0 + 0.0677248677248677*G0_2_1 + 0.135449735449736*G0_2_2;
    A[1145] = 0.0451499118165783*G0_0_0 - 0.0451499118165788*G0_0_2 - 0.0451499118165782*G0_1_1 - 0.0225749559082892*G0_1_2 - 0.0451499118165787*G0_2_0 - 0.0225749559082893*G0_2_1;
    A[1146] = -0.0451499118165783*G0_0_1 - 0.0677248677248676*G0_0_2 - 0.0451499118165786*G0_1_0 - 0.0451499118165789*G0_1_1 - 0.0225749559082894*G0_1_2 - 0.0677248677248677*G0_2_0 - 0.0225749559082894*G0_2_1;
    A[1147] = -0.0225749559082892*G0_0_1 - 0.0451499118165779*G0_0_2 - 0.0225749559082894*G0_1_0 - 0.0451499118165786*G0_1_1 - 0.0225749559082893*G0_1_2 - 0.0451499118165782*G0_2_0 - 0.0225749559082888*G0_2_1;
    A[1148] = -0.225749559082892*G0_0_0 - 0.180599647266314*G0_0_1 - 0.0451499118165785*G0_0_2 - 0.180599647266314*G0_1_0 - 0.135449735449735*G0_1_1 - 0.0677248677248675*G0_1_2 - 0.0451499118165783*G0_2_0 - 0.0677248677248676*G0_2_1;
    A[1149] = 0.316049382716049*G0_0_0 + 0.135449735449735*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899471*G0_1_2 + 0.135449735449735*G0_2_0 + 0.27089947089947*G0_2_1;
    A[1150] = -0.0451499118165786*G0_0_0 - 0.0225749559082892*G0_0_1 - 0.0451499118165783*G0_0_2 - 0.0225749559082891*G0_1_0 - 0.067724867724868*G0_1_2 - 0.0451499118165783*G0_2_0 - 0.0677248677248677*G0_2_1;
    A[1151] = -0.451499118165785*G0_0_0 - 0.225749559082892*G0_0_1 - 0.361199294532628*G0_0_2 - 0.225749559082892*G0_1_0 - 0.135449735449735*G0_1_1 - 0.203174603174602*G0_1_2 - 0.0902998236331567*G0_2_0 - 0.0677248677248675*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1152] = 0.632098765432099*G0_0_0 + 0.27089947089947*G0_0_1 + 0.270899470899471*G0_0_2 + 0.27089947089947*G0_1_0 + 0.541798941798942*G0_1_1 + 0.27089947089947*G0_1_2 + 0.270899470899471*G0_2_0 + 0.27089947089947*G0_2_1 + 0.541798941798942*G0_2_2;
    A[1153] = -0.135449735449736*G0_0_0 + 0.0902998236331569*G0_0_1 - 0.0677248677248682*G0_0_2 + 0.0902998236331571*G0_1_0 - 0.135449735449736*G0_1_1 + 0.0677248677248678*G0_1_2 + 0.0677248677248679*G0_2_0 - 0.0677248677248676*G0_2_1;
    A[1154] = -0.0902998236331566*G0_0_0 + 0.135449735449735*G0_0_1 + 0.316049382716049*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899471*G0_1_1 + 0.135449735449735*G0_1_2 + 0.316049382716049*G0_2_0 + 0.135449735449736*G0_2_1;
    A[1155] = -0.0253968253968253*G0_0_0 - 0.0253968253968252*G0_0_1 - 0.0253968253968253*G0_0_2 - 0.0253968253968253*G0_1_0 - 0.0253968253968252*G0_1_1 - 0.0253968253968253*G0_1_2 - 0.0183421516754849*G0_2_0 - 0.018342151675485*G0_2_1 - 0.0183421516754849*G0_2_2;
    A[1156] = -0.0253968253968254*G0_0_0 - 0.00705467372134036*G0_2_0;
    A[1157] = 0.0423280423280423*G0_1_1 - 0.00705467372134033*G0_2_1;
    A[1158] = 0.018342151675485*G0_2_2;
    A[1159] = -0.135449735449736*G0_1_1 - 0.101587301587302*G0_1_2 - 0.101587301587302*G0_2_1 - 0.112874779541446*G0_2_2;
    A[1160] = 0.0225749559082892*G0_1_1 + 0.0423280423280425*G0_1_2 + 0.0423280423280424*G0_2_1 + 0.0846560846560844*G0_2_2;
    A[1161] = -0.0112874779541447*G0_1_2 - 0.0112874779541449*G0_2_1 - 0.0677248677248677*G0_2_2;
    A[1162] = 0.0451499118165786*G0_0_0 + 0.0338624338624339*G0_0_2 + 0.0338624338624338*G0_2_0 + 0.0225749559082893*G0_2_2;
    A[1163] = 0.0225749559082891*G0_0_0 + 0.0197530864197532*G0_0_2 + 0.0197530864197535*G0_2_0 + 0.0169312169312173*G0_2_2;
    A[1164] = -0.0112874779541448*G0_0_2 - 0.0112874779541448*G0_2_0 - 0.0225749559082893*G0_2_2;
    A[1165] = 0.135449735449735*G0_0_0 + 0.0338624338624339*G0_0_1 + 0.0338624338624336*G0_1_0 + 0.0677248677248678*G0_2_0 + 0.0225749559082893*G0_2_1;
    A[1166] = -0.270899470899471*G0_0_0 - 0.0931216931216931*G0_0_1 - 0.0931216931216925*G0_1_0 + 0.0677248677248683*G0_1_1 - 0.186243386243386*G0_2_0 - 0.0507936507936508*G0_2_1;
    A[1167] = -0.101587301587301*G0_0_1 - 0.101587301587302*G0_1_0 - 0.270899470899471*G0_1_1 - 0.112874779541446*G0_2_0 - 0.203174603174603*G0_2_1;
    A[1168] = 0.0451499118165785*G0_0_0 + 0.0451499118165784*G0_0_1 + 0.0112874779541444*G0_0_2 + 0.0451499118165783*G0_1_0 + 0.0451499118165784*G0_1_1 + 0.0112874779541442*G0_1_2 + 0.0112874779541446*G0_2_0 + 0.0112874779541446*G0_2_1;
    A[1169] = 0.0225749559082891*G0_0_0 + 0.0225749559082892*G0_0_1 + 0.00282186948853609*G0_0_2 + 0.0225749559082893*G0_1_0 + 0.0225749559082894*G0_1_1 + 0.00282186948853646*G0_1_2 + 0.002821869488536*G0_2_0 + 0.00282186948853593*G0_2_1;
    A[1170] = 0.0112874779541446*G0_0_2 + 0.0112874779541444*G0_1_2 + 0.0112874779541448*G0_2_0 + 0.0112874779541448*G0_2_1;
    A[1171] = 0.135449735449735*G0_0_0 + 0.101587301587301*G0_0_1 + 0.135449735449735*G0_0_2 + 0.101587301587301*G0_1_0 + 0.0677248677248674*G0_1_1 + 0.101587301587301*G0_1_2 + 0.0677248677248676*G0_2_0 + 0.0564373897707229*G0_2_1 + 0.0677248677248675*G0_2_2;
    A[1172] = -0.270899470899471*G0_0_0 - 0.177777777777777*G0_0_1 - 0.270899470899471*G0_0_2 - 0.177777777777778*G0_1_0 - 0.0169312169312165*G0_1_1 - 0.177777777777778*G0_1_2 - 0.0846560846560845*G0_2_0 - 0.0423280423280421*G0_2_1 - 0.0846560846560845*G0_2_2;
    A[1173] = 0.101587301587301*G0_0_1 + 0.101587301587302*G0_1_0 - 0.0677248677248679*G0_1_1 + 0.101587301587302*G0_1_2 + 0.112874779541446*G0_2_0 + 0.0112874779541444*G0_2_1 + 0.112874779541446*G0_2_2;
    A[1174] = 0.0225749559082891*G0_0_0 + 0.056437389770723*G0_0_1 + 0.0564373897707231*G0_0_2 + 0.056437389770723*G0_1_0 + 0.0902998236331571*G0_1_1 + 0.0902998236331571*G0_1_2 + 0.0112874779541447*G0_2_0 + 0.0225749559082893*G0_2_1 + 0.0225749559082893*G0_2_2;
    A[1175] = 0.00564373897707234*G0_0_0 + 0.00282186948853632*G0_0_1 + 0.0028218694885363*G0_0_2 + 0.00282186948853616*G0_1_0 + 0.0677248677248681*G0_1_1 + 0.0677248677248679*G0_1_2 + 0.00282186948853582*G0_2_0 - 0.0169312169312168*G0_2_1 - 0.0169312169312168*G0_2_2;
    A[1176] = 0.0225749559082892*G0_0_0 - 0.033862433862434*G0_0_1 - 0.033862433862434*G0_0_2 - 0.033862433862434*G0_1_0 + 0.0112874779541448*G0_2_0 - 0.0225749559082894*G0_2_1 - 0.0225749559082893*G0_2_2;
    A[1177] = -0.135449735449736*G0_0_0 + 0.0451499118165787*G0_0_1 - 0.0677248677248678*G0_0_2 + 0.0451499118165786*G0_1_0 + 0.067724867724868*G0_1_2 - 0.0677248677248675*G0_2_0 + 0.0677248677248683*G0_2_1;
    A[1178] = -0.135449735449736*G0_0_1 - 0.270899470899471*G0_0_2 - 0.135449735449736*G0_1_0 + 0.0451499118165789*G0_1_1 - 0.270899470899471*G0_1_2 - 0.270899470899471*G0_2_0 - 0.270899470899472*G0_2_1 - 0.541798941798942*G0_2_2;
    A[1179] = 0.0225749559082888*G0_0_1 + 0.0677248677248672*G0_0_2 + 0.0225749559082891*G0_1_0 + 0.0451499118165781*G0_1_2 + 0.0677248677248675*G0_2_0 + 0.0451499118165788*G0_2_1 + 0.135449735449735*G0_2_2;
    A[1180] = -0.135449735449735*G0_0_0 - 0.180599647266314*G0_0_1 - 0.0677248677248672*G0_0_2 - 0.180599647266314*G0_1_0 - 0.225749559082892*G0_1_1 - 0.0451499118165784*G0_1_2 - 0.067724867724867*G0_2_0 - 0.045149911816578*G0_2_1;
    A[1181] = 0.135449735449735*G0_0_1 + 0.270899470899471*G0_0_2 + 0.135449735449736*G0_1_0 + 0.31604938271605*G0_1_1 + 0.135449735449736*G0_1_2 + 0.270899470899471*G0_2_0 + 0.135449735449735*G0_2_1;
    A[1182] = -0.0225749559082892*G0_0_1 - 0.0677248677248682*G0_0_2 - 0.0225749559082892*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.0451499118165787*G0_1_2 - 0.0677248677248678*G0_2_0 - 0.0451499118165784*G0_2_1;
    A[1183] = -0.0451499118165786*G0_0_0 - 0.0225749559082892*G0_0_2 + 0.0451499118165786*G0_1_1 - 0.0451499118165786*G0_1_2 - 0.022574955908289*G0_2_0 - 0.0451499118165775*G0_2_1;
    A[1184] = -0.0451499118165788*G0_0_0 - 0.0451499118165786*G0_0_1 - 0.0225749559082894*G0_0_2 - 0.0451499118165786*G0_1_0 - 0.0677248677248679*G0_1_2 - 0.0225749559082898*G0_2_0 - 0.0677248677248681*G0_2_1;
    A[1185] = -0.0451499118165782*G0_0_0 - 0.0225749559082888*G0_0_1 - 0.0225749559082891*G0_0_2 - 0.0225749559082892*G0_1_0 - 0.0451499118165782*G0_1_2 - 0.0225749559082894*G0_2_0 - 0.0451499118165786*G0_2_1;
    A[1186] = -0.135449735449735*G0_0_0 - 0.225749559082892*G0_0_1 - 0.203174603174603*G0_0_2 - 0.225749559082892*G0_1_0 - 0.451499118165785*G0_1_1 - 0.361199294532628*G0_1_2 - 0.0677248677248671*G0_2_0 - 0.0902998236331566*G0_2_1 - 0.135449735449734*G0_2_2;
    A[1187] = -0.135449735449736*G0_0_0 + 0.0902998236331571*G0_0_1 + 0.0677248677248679*G0_0_2 + 0.0902998236331569*G0_1_0 - 0.135449735449736*G0_1_1 - 0.0677248677248676*G0_1_2 - 0.0677248677248682*G0_2_0 + 0.0677248677248678*G0_2_1;
    A[1188] = 0.541798941798942*G0_0_0 + 0.27089947089947*G0_0_1 + 0.270899470899471*G0_0_2 + 0.27089947089947*G0_1_0 + 0.632098765432099*G0_1_1 + 0.27089947089947*G0_1_2 + 0.270899470899471*G0_2_0 + 0.27089947089947*G0_2_1 + 0.541798941798942*G0_2_2;
    A[1189] = 0.270899470899471*G0_0_0 + 0.135449735449736*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449736*G0_1_0 - 0.0902998236331575*G0_1_1 + 0.316049382716049*G0_1_2 + 0.135449735449735*G0_2_0 + 0.316049382716049*G0_2_1;
    A[1190] = -0.0677248677248679*G0_0_0 - 0.0677248677248678*G0_0_1 - 0.0677248677248678*G0_0_2 - 0.0677248677248678*G0_1_0 - 0.0677248677248679*G0_1_1 - 0.0677248677248678*G0_1_2 - 0.067724867724868*G0_2_0 - 0.067724867724868*G0_2_1 - 0.0677248677248681*G0_2_2;
    A[1191] = -0.0677248677248677*G0_0_0;
    A[1192] = -0.0677248677248675*G0_1_1;
    A[1193] = -0.0677248677248676*G0_2_2;
    A[1194] = 0.0902998236331569*G0_1_1;
    A[1195] = -0.135449735449736*G0_1_1 - 0.112874779541448*G0_1_2 - 0.112874779541446*G0_2_1 - 0.135449735449736*G0_2_2;
    A[1196] = 0.0902998236331575*G0_2_2;
    A[1197] = 0.0902998236331571*G0_0_0;
    A[1198] = -0.135449735449736*G0_0_0 - 0.112874779541446*G0_0_2 - 0.112874779541447*G0_2_0 - 0.135449735449736*G0_2_2;
    A[1199] = 0.0902998236331568*G0_2_2;
    A[1200] = 0.090299823633157*G0_0_0;
    A[1201] = -0.135449735449735*G0_0_0 - 0.112874779541446*G0_0_1 - 0.112874779541447*G0_1_0 - 0.135449735449736*G0_1_1;
    A[1202] = 0.0902998236331575*G0_1_1;
    A[1203] = 0.0902998236331572*G0_0_0 + 0.0902998236331572*G0_0_1 + 0.0902998236331568*G0_0_2 + 0.0902998236331573*G0_1_0 + 0.0902998236331571*G0_1_1 + 0.090299823633157*G0_1_2 + 0.0902998236331572*G0_2_0 + 0.0902998236331571*G0_2_1 + 0.0902998236331578*G0_2_2;
    A[1204] = -0.135449735449737*G0_0_0 - 0.135449735449737*G0_0_1 - 0.0225749559082894*G0_0_2 - 0.135449735449737*G0_1_0 - 0.135449735449737*G0_1_1 - 0.0225749559082896*G0_1_2 - 0.0225749559082896*G0_2_0 - 0.0225749559082896*G0_2_1 - 0.0451499118165797*G0_2_2;
    A[1205] = 0.0902998236331571*G0_2_2;
    A[1206] = 0.0902998236331576*G0_0_0 + 0.0902998236331571*G0_0_1 + 0.0902998236331577*G0_0_2 + 0.0902998236331575*G0_1_0 + 0.0902998236331573*G0_1_1 + 0.0902998236331574*G0_1_2 + 0.0902998236331571*G0_2_0 + 0.0902998236331576*G0_2_1 + 0.0902998236331571*G0_2_2;
    A[1207] = -0.135449735449735*G0_0_0 - 0.0225749559082894*G0_0_1 - 0.135449735449736*G0_0_2 - 0.022574955908289*G0_1_0 - 0.0451499118165787*G0_1_1 - 0.0225749559082889*G0_1_2 - 0.135449735449736*G0_2_0 - 0.0225749559082897*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1208] = 0.0902998236331566*G0_1_1;
    A[1209] = 0.0902998236331574*G0_0_0 + 0.0902998236331577*G0_0_1 + 0.0902998236331577*G0_0_2 + 0.0902998236331573*G0_1_0 + 0.0902998236331576*G0_1_1 + 0.0902998236331576*G0_1_2 + 0.0902998236331575*G0_2_0 + 0.0902998236331571*G0_2_1 + 0.0902998236331572*G0_2_2;
    A[1210] = -0.0451499118165784*G0_0_0 - 0.0225749559082888*G0_0_1 - 0.0225749559082887*G0_0_2 - 0.0225749559082894*G0_1_0 - 0.135449735449735*G0_1_1 - 0.135449735449735*G0_1_2 - 0.0225749559082894*G0_2_0 - 0.135449735449735*G0_2_1 - 0.135449735449735*G0_2_2;
    A[1211] = 0.0902998236331566*G0_0_0;
    A[1212] = -0.722398589065256*G0_0_0 - 0.316049382716049*G0_0_1 - 0.316049382716049*G0_0_2 - 0.316049382716049*G0_1_0 - 0.135449735449735*G0_1_2 - 0.316049382716049*G0_2_0 - 0.135449735449735*G0_2_1;
    A[1213] = -0.31604938271605*G0_0_1 - 0.135449735449735*G0_0_2 - 0.31604938271605*G0_1_0 - 0.722398589065257*G0_1_1 - 0.31604938271605*G0_1_2 - 0.135449735449735*G0_2_0 - 0.316049382716048*G0_2_1;
    A[1214] = -0.135449735449735*G0_0_1 - 0.31604938271605*G0_0_2 - 0.135449735449736*G0_1_0 - 0.31604938271605*G0_1_2 - 0.316049382716049*G0_2_0 - 0.31604938271605*G0_2_1 - 0.722398589065256*G0_2_2;
    A[1215] = -0.722398589065257*G0_0_0 - 0.406349206349207*G0_0_1 - 0.406349206349208*G0_0_2 - 0.406349206349208*G0_1_0 - 0.0902998236331577*G0_1_1 - 0.225749559082894*G0_1_2 - 0.406349206349207*G0_2_0 - 0.225749559082894*G0_2_1 - 0.090299823633158*G0_2_2;
    A[1216] = 0.31604938271605*G0_0_1 + 0.135449735449737*G0_0_2 + 0.31604938271605*G0_1_0 - 0.0902998236331568*G0_1_1 + 0.135449735449737*G0_1_2 + 0.135449735449735*G0_2_0 + 0.135449735449737*G0_2_1 + 0.270899470899472*G0_2_2;
    A[1217] = 0.135449735449736*G0_0_1 + 0.31604938271605*G0_0_2 + 0.135449735449736*G0_1_0 + 0.270899470899472*G0_1_1 + 0.135449735449737*G0_1_2 + 0.316049382716049*G0_2_0 + 0.135449735449736*G0_2_1 - 0.0902998236331569*G0_2_2;
    A[1218] = -0.0902998236331579*G0_0_0 - 0.406349206349207*G0_0_1 - 0.225749559082895*G0_0_2 - 0.406349206349207*G0_1_0 - 0.722398589065256*G0_1_1 - 0.406349206349208*G0_1_2 - 0.225749559082894*G0_2_0 - 0.406349206349207*G0_2_1 - 0.0902998236331579*G0_2_2;
    A[1219] = -0.0902998236331572*G0_0_0 + 0.316049382716049*G0_0_1 + 0.135449735449735*G0_0_2 + 0.316049382716049*G0_1_0 + 0.135449735449734*G0_1_2 + 0.135449735449735*G0_2_0 + 0.135449735449735*G0_2_1 + 0.27089947089947*G0_2_2;
    A[1220] = 0.270899470899472*G0_0_0 + 0.135449735449736*G0_0_1 + 0.135449735449737*G0_0_2 + 0.135449735449736*G0_1_0 + 0.316049382716051*G0_1_2 + 0.135449735449737*G0_2_0 + 0.31604938271605*G0_2_1 - 0.0902998236331556*G0_2_2;
    A[1221] = -0.0902998236331582*G0_0_0 - 0.225749559082894*G0_0_1 - 0.406349206349207*G0_0_2 - 0.225749559082893*G0_1_0 - 0.0902998236331575*G0_1_1 - 0.406349206349206*G0_1_2 - 0.406349206349207*G0_2_0 - 0.406349206349207*G0_2_1 - 0.722398589065256*G0_2_2;
    A[1222] = -0.0902998236331566*G0_0_0 + 0.135449735449735*G0_0_1 + 0.316049382716049*G0_0_2 + 0.135449735449735*G0_1_0 + 0.270899470899471*G0_1_1 + 0.135449735449736*G0_1_2 + 0.316049382716049*G0_2_0 + 0.135449735449735*G0_2_1;
    A[1223] = 0.270899470899471*G0_0_0 + 0.135449735449736*G0_0_1 + 0.135449735449735*G0_0_2 + 0.135449735449736*G0_1_0 - 0.0902998236331575*G0_1_1 + 0.316049382716049*G0_1_2 + 0.135449735449735*G0_2_0 + 0.316049382716049*G0_2_1;
    A[1224] = 1.44479717813051*G0_0_0 + 0.722398589065257*G0_0_1 + 0.722398589065257*G0_0_2 + 0.722398589065257*G0_1_0 + 1.44479717813051*G0_1_1 + 0.722398589065256*G0_1_2 + 0.722398589065257*G0_2_0 + 0.722398589065255*G0_2_1 + 1.44479717813051*G0_2_2;
}

/// Constructor
poisson3d_4_cell_integral_1_otherwise::poisson3d_4_cell_integral_1_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson3d_4_cell_integral_1_otherwise::~poisson3d_4_cell_integral_1_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & poisson3d_4_cell_integral_1_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void poisson3d_4_cell_integral_1_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    35
    // Number of operations (multiply-add pairs) for tensor contraction: 1207
    // Total number of operations (multiply-add pairs):                  1245
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    const double G0_20 = det*w[0][20]*(1.0);
    const double G0_21 = det*w[0][21]*(1.0);
    const double G0_22 = det*w[0][22]*(1.0);
    const double G0_23 = det*w[0][23]*(1.0);
    const double G0_24 = det*w[0][24]*(1.0);
    const double G0_25 = det*w[0][25]*(1.0);
    const double G0_26 = det*w[0][26]*(1.0);
    const double G0_27 = det*w[0][27]*(1.0);
    const double G0_28 = det*w[0][28]*(1.0);
    const double G0_29 = det*w[0][29]*(1.0);
    const double G0_30 = det*w[0][30]*(1.0);
    const double G0_31 = det*w[0][31]*(1.0);
    const double G0_32 = det*w[0][32]*(1.0);
    const double G0_33 = det*w[0][33]*(1.0);
    const double G0_34 = det*w[0][34]*(1.0);
    
    // Compute element tensor
    A[0] = 0.000200416867083531*G0_0 + 1.63005718561269e-05*G0_1 + 1.63005718561268e-05*G0_2 + 1.63005718561269e-05*G0_3 - 0.000121853455186786*G0_4 + 8.39078616856376e-05*G0_5 - 0.000121853455186786*G0_6 - 0.000121853455186786*G0_7 + 8.39078616856376e-05*G0_8 - 0.000121853455186786*G0_9 - 0.000121853455186786*G0_10 + 8.39078616856378e-05*G0_11 - 0.000121853455186786*G0_12 - 0.000149644594089037*G0_13 + 0.000112233445566778*G0_14 - 6.84089572978449e-05*G0_15 - 0.000149644594089036*G0_16 + 0.000112233445566777*G0_17 - 6.84089572978445e-05*G0_18 - 0.000149644594089037*G0_19 + 0.000112233445566777*G0_20 - 6.84089572978438e-05*G0_21 - 0.000215915771471324*G0_22 - 0.000215915771471324*G0_23 - 0.000215915771471325*G0_24 + 0.000288600288600288*G0_25 - 0.000185986852653516*G0_26 - 0.000185986852653516*G0_27 + 0.000288600288600287*G0_28 - 0.000185986852653516*G0_29 - 0.000185986852653516*G0_30 + 0.000288600288600287*G0_31 - 0.000185986852653516*G0_32 - 0.000185986852653516*G0_33 - 0.000538720538720526*G0_34;
    A[1] = 1.63005718561269e-05*G0_0 + 0.000200416867083532*G0_1 + 1.63005718561273e-05*G0_2 + 1.63005718561274e-05*G0_3 - 0.000121853455186787*G0_4 + 8.39078616856389e-05*G0_5 - 0.000121853455186788*G0_6 - 0.000149644594089039*G0_7 + 0.000112233445566779*G0_8 - 6.84089572978461e-05*G0_9 - 0.000149644594089038*G0_10 + 0.000112233445566778*G0_11 - 6.84089572978456e-05*G0_12 - 0.000121853455186788*G0_13 + 8.39078616856391e-05*G0_14 - 0.000121853455186788*G0_15 - 0.000121853455186787*G0_16 + 8.39078616856391e-05*G0_17 - 0.000121853455186788*G0_18 - 6.84089572978459e-05*G0_19 + 0.000112233445566778*G0_20 - 0.000149644594089037*G0_21 + 0.000288600288600287*G0_22 - 0.000185986852653519*G0_23 - 0.000185986852653518*G0_24 - 0.000215915771471325*G0_25 - 0.000215915771471326*G0_26 - 0.000215915771471326*G0_27 - 0.000185986852653518*G0_28 + 0.000288600288600287*G0_29 - 0.000185986852653518*G0_30 - 0.000185986852653518*G0_31 + 0.000288600288600287*G0_32 - 0.000185986852653518*G0_33 - 0.000538720538720536*G0_34;
    A[2] = 1.63005718561268e-05*G0_0 + 1.63005718561273e-05*G0_1 + 0.000200416867083532*G0_2 + 1.63005718561271e-05*G0_3 - 0.000149644594089038*G0_4 + 0.000112233445566779*G0_5 - 6.84089572978459e-05*G0_6 - 0.000121853455186787*G0_7 + 8.39078616856385e-05*G0_8 - 0.000121853455186787*G0_9 - 6.84089572978448e-05*G0_10 + 0.000112233445566778*G0_11 - 0.000149644594089037*G0_12 - 0.000121853455186788*G0_13 + 8.39078616856394e-05*G0_14 - 0.000121853455186788*G0_15 - 6.8408957297845e-05*G0_16 + 0.000112233445566778*G0_17 - 0.000149644594089037*G0_18 - 0.000121853455186787*G0_19 + 8.39078616856388e-05*G0_20 - 0.000121853455186787*G0_21 - 0.000185986852653516*G0_22 + 0.000288600288600287*G0_23 - 0.000185986852653519*G0_24 - 0.000185986852653517*G0_25 + 0.000288600288600288*G0_26 - 0.000185986852653519*G0_27 - 0.000215915771471325*G0_28 - 0.000215915771471324*G0_29 - 0.000215915771471327*G0_30 - 0.000185986852653518*G0_31 - 0.000185986852653517*G0_32 + 0.000288600288600287*G0_33 - 0.000538720538720532*G0_34;
    A[3] = 1.63005718561269e-05*G0_0 + 1.63005718561274e-05*G0_1 + 1.63005718561271e-05*G0_2 + 0.000200416867083533*G0_3 - 6.84089572978455e-05*G0_4 + 0.000112233445566778*G0_5 - 0.000149644594089037*G0_6 - 6.84089572978457e-05*G0_7 + 0.000112233445566778*G0_8 - 0.000149644594089037*G0_9 - 0.000121853455186787*G0_10 + 8.3907861685639e-05*G0_11 - 0.000121853455186787*G0_12 - 6.84089572978461e-05*G0_13 + 0.000112233445566779*G0_14 - 0.000149644594089038*G0_15 - 0.000121853455186787*G0_16 + 8.39078616856391e-05*G0_17 - 0.000121853455186788*G0_18 - 0.000121853455186788*G0_19 + 8.3907861685639e-05*G0_20 - 0.000121853455186787*G0_21 - 0.000185986852653517*G0_22 - 0.000185986852653519*G0_23 + 0.000288600288600286*G0_24 - 0.000185986852653518*G0_25 - 0.000185986852653518*G0_26 + 0.000288600288600287*G0_27 - 0.000185986852653518*G0_28 - 0.000185986852653518*G0_29 + 0.000288600288600286*G0_30 - 0.000215915771471325*G0_31 - 0.000215915771471325*G0_32 - 0.000215915771471326*G0_33 - 0.000538720538720535*G0_34;
    A[4] = -0.000121853455186786*G0_0 - 0.000121853455186787*G0_1 - 0.000149644594089038*G0_2 - 6.84089572978455e-05*G0_3 + 0.00171022393244614*G0_4 - 0.00125701459034791*G0_5 + 0.000684089572978457*G0_6 + 0.000273635829191384*G0_7 - 0.000153920153920153*G0_8 + 0.00035914702581369*G0_9 + 0.000359147025813688*G0_10 - 0.000654160654160648*G0_11 + 0.000855111966223068*G0_12 + 0.000273635829191384*G0_13 - 0.000153920153920154*G0_14 + 0.000359147025813691*G0_15 + 0.000359147025813688*G0_16 - 0.000654160654160648*G0_17 + 0.00085511196622307*G0_18 + 0.000136817914595692*G0_19 - 9.83378761156539e-05*G0_20 + 0.00013681791459569*G0_21 - 3.42044786489231e-05*G0_22 + 0.000102613435946766*G0_23 + 0.000513067179733844*G0_24 - 3.42044786489231e-05*G0_25 + 0.000102613435946766*G0_26 + 0.000513067179733845*G0_27 + 8.55111966223083e-05*G0_28 + 8.55111966223071e-05*G0_29 + 0.000974827641494301*G0_30 - 1.7102239324461e-05*G0_31 - 1.71022393244622e-05*G0_32 + 5.13067179733819e-05*G0_33 + 0.00109454331676553*G0_34;
    A[5] = 8.39078616856376e-05*G0_0 + 8.39078616856389e-05*G0_1 + 0.000112233445566779*G0_2 + 0.000112233445566778*G0_3 - 0.00125701459034791*G0_4 + 0.00238576238576237*G0_5 - 0.00125701459034792*G0_6 - 0.000153920153920155*G0_7 + 0.000256533589866923*G0_8 - 0.000654160654160652*G0_9 - 0.000153920153920152*G0_10 + 0.000256533589866921*G0_11 - 0.000654160654160647*G0_12 - 0.000153920153920154*G0_13 + 0.000256533589866923*G0_14 - 0.000654160654160651*G0_15 - 0.000153920153920152*G0_16 + 0.000256533589866921*G0_17 - 0.000654160654160649*G0_18 - 9.83378761156543e-05*G0_19 + 1.92400192400202e-05*G0_20 - 9.83378761156527e-05*G0_21 - 0.000179573512906845*G0_22 - 7.69600769600751e-05*G0_23 - 7.6960076960077e-05*G0_24 - 0.000179573512906845*G0_25 - 7.69600769600741e-05*G0_26 - 7.69600769600776e-05*G0_27 + 0.000269360269360266*G0_28 + 0.000269360269360268*G0_29 - 0.00101330767997434*G0_30 + 0.000269360269360267*G0_31 + 0.000269360269360267*G0_32 - 0.00101330767997434*G0_33 - 0.00102613435946768*G0_34;
    A[6] = -0.000121853455186786*G0_0 - 0.000121853455186788*G0_1 - 6.84089572978459e-05*G0_2 - 0.000149644594089037*G0_3 + 0.000684089572978457*G0_4 - 0.00125701459034792*G0_5 + 0.00171022393244614*G0_6 + 0.000359147025813692*G0_7 - 0.000654160654160651*G0_8 + 0.000855111966223073*G0_9 + 0.000273635829191382*G0_10 - 0.000153920153920153*G0_11 + 0.000359147025813688*G0_12 + 0.000359147025813692*G0_13 - 0.000654160654160652*G0_14 + 0.000855111966223072*G0_15 + 0.000273635829191382*G0_16 - 0.000153920153920154*G0_17 + 0.00035914702581369*G0_18 + 0.000136817914595693*G0_19 - 9.83378761156542e-05*G0_20 + 0.00013681791459569*G0_21 - 3.42044786489236e-05*G0_22 + 0.000513067179733842*G0_23 + 0.000102613435946769*G0_24 - 3.42044786489239e-05*G0_25 + 0.000513067179733843*G0_26 + 0.000102613435946769*G0_27 - 1.71022393244599e-05*G0_28 - 1.71022393244606e-05*G0_29 + 5.13067179733835e-05*G0_30 + 8.55111966223066e-05*G0_31 + 8.5511196622307e-05*G0_32 + 0.0009748276414943*G0_33 + 0.00109454331676553*G0_34;
    A[7] = -0.000121853455186786*G0_0 - 0.000149644594089039*G0_1 - 0.000121853455186787*G0_2 - 6.84089572978457e-05*G0_3 + 0.000273635829191384*G0_4 - 0.000153920153920155*G0_5 + 0.000359147025813692*G0_6 + 0.00171022393244614*G0_7 - 0.00125701459034791*G0_8 + 0.000684089572978457*G0_9 + 0.000855111966223069*G0_10 - 0.000654160654160648*G0_11 + 0.000359147025813689*G0_12 + 0.000273635829191385*G0_13 - 0.000153920153920155*G0_14 + 0.000359147025813691*G0_15 + 0.000136817914595691*G0_16 - 9.83378761156544e-05*G0_17 + 0.000136817914595693*G0_18 + 0.00035914702581369*G0_19 - 0.000654160654160649*G0_20 + 0.000855111966223068*G0_21 + 0.000102613435946766*G0_22 - 3.42044786489207e-05*G0_23 + 0.000513067179733846*G0_24 + 8.55111966223045e-05*G0_25 + 8.55111966223094e-05*G0_26 + 0.000974827641494305*G0_27 - 3.42044786489234e-05*G0_28 + 0.000102613435946768*G0_29 + 0.000513067179733846*G0_30 - 1.71022393244627e-05*G0_31 + 5.13067179733828e-05*G0_32 - 1.71022393244584e-05*G0_33 + 0.00109454331676554*G0_34;
    A[8] = 8.39078616856376e-05*G0_0 + 0.000112233445566779*G0_1 + 8.39078616856386e-05*G0_2 + 0.000112233445566778*G0_3 - 0.000153920153920154*G0_4 + 0.000256533589866923*G0_5 - 0.000654160654160651*G0_6 - 0.00125701459034791*G0_7 + 0.00238576238576237*G0_8 - 0.00125701459034791*G0_9 - 0.000654160654160647*G0_10 + 0.00025653358986692*G0_11 - 0.000153920153920152*G0_12 - 0.000153920153920154*G0_13 + 0.000256533589866923*G0_14 - 0.000654160654160651*G0_15 - 9.8337876115653e-05*G0_16 + 1.92400192400203e-05*G0_17 - 9.83378761156543e-05*G0_18 - 0.000153920153920153*G0_19 + 0.000256533589866921*G0_20 - 0.000654160654160646*G0_21 - 7.69600769600723e-05*G0_22 - 0.000179573512906847*G0_23 - 7.69600769600749e-05*G0_24 + 0.000269360269360267*G0_25 + 0.000269360269360265*G0_26 - 0.00101330767997434*G0_27 - 0.000179573512906847*G0_28 - 7.69600769600744e-05*G0_29 - 7.69600769600763e-05*G0_30 + 0.000269360269360267*G0_31 - 0.00101330767997434*G0_32 + 0.000269360269360265*G0_33 - 0.00102613435946769*G0_34;
    A[9] = -0.000121853455186786*G0_0 - 6.84089572978461e-05*G0_1 - 0.000121853455186787*G0_2 - 0.000149644594089037*G0_3 + 0.00035914702581369*G0_4 - 0.000654160654160652*G0_5 + 0.000855111966223073*G0_6 + 0.000684089572978457*G0_7 - 0.00125701459034791*G0_8 + 0.00171022393244614*G0_9 + 0.000359147025813688*G0_10 - 0.000153920153920153*G0_11 + 0.000273635829191382*G0_12 + 0.000359147025813692*G0_13 - 0.000654160654160652*G0_14 + 0.000855111966223072*G0_15 + 0.000136817914595691*G0_16 - 9.83378761156542e-05*G0_17 + 0.000136817914595692*G0_18 + 0.000273635829191383*G0_19 - 0.000153920153920154*G0_20 + 0.000359147025813688*G0_21 + 0.000513067179733841*G0_22 - 3.4204478648922e-05*G0_23 + 0.000102613435946769*G0_24 - 1.71022393244626e-05*G0_25 - 1.71022393244607e-05*G0_26 + 5.13067179733846e-05*G0_27 - 3.42044786489222e-05*G0_28 + 0.000513067179733842*G0_29 + 0.000102613435946769*G0_30 + 8.55111966223058e-05*G0_31 + 0.000974827641494298*G0_32 + 8.55111966223081e-05*G0_33 + 0.00109454331676553*G0_34;
    A[10] = -0.000121853455186786*G0_0 - 0.000149644594089038*G0_1 - 6.84089572978448e-05*G0_2 - 0.000121853455186787*G0_3 + 0.000359147025813688*G0_4 - 0.000153920153920152*G0_5 + 0.000273635829191382*G0_6 + 0.000855111966223069*G0_7 - 0.000654160654160647*G0_8 + 0.000359147025813688*G0_9 + 0.00171022393244614*G0_10 - 0.00125701459034791*G0_11 + 0.000684089572978454*G0_12 + 0.000136817914595692*G0_13 - 9.83378761156536e-05*G0_14 + 0.000136817914595691*G0_15 + 0.000273635829191381*G0_16 - 0.000153920153920153*G0_17 + 0.000359147025813689*G0_18 + 0.000359147025813689*G0_19 - 0.000654160654160648*G0_20 + 0.000855111966223068*G0_21 + 0.000102613435946764*G0_22 + 0.000513067179733843*G0_23 - 3.42044786489217e-05*G0_24 + 8.55111966223058e-05*G0_25 + 0.000974827641494302*G0_26 + 8.55111966223086e-05*G0_27 - 1.71022393244607e-05*G0_28 + 5.13067179733813e-05*G0_29 - 1.71022393244607e-05*G0_30 - 3.42044786489237e-05*G0_31 + 0.000102613435946766*G0_32 + 0.000513067179733843*G0_33 + 0.00109454331676553*G0_34;
    A[11] = 8.39078616856378e-05*G0_0 + 0.000112233445566778*G0_1 + 0.000112233445566778*G0_2 + 8.3907861685639e-05*G0_3 - 0.000654160654160648*G0_4 + 0.000256533589866921*G0_5 - 0.000153920153920153*G0_6 - 0.000654160654160648*G0_7 + 0.00025653358986692*G0_8 - 0.000153920153920153*G0_9 - 0.00125701459034791*G0_10 + 0.00238576238576236*G0_11 - 0.00125701459034791*G0_12 - 9.83378761156541e-05*G0_13 + 1.92400192400198e-05*G0_14 - 9.83378761156533e-05*G0_15 - 0.000153920153920152*G0_16 + 0.000256533589866921*G0_17 - 0.000654160654160648*G0_18 - 0.000153920153920153*G0_19 + 0.000256533589866921*G0_20 - 0.000654160654160647*G0_21 - 7.69600769600791e-05*G0_22 - 7.69600769600788e-05*G0_23 - 0.000179573512906844*G0_24 + 0.000269360269360269*G0_25 - 0.00101330767997434*G0_26 + 0.000269360269360267*G0_27 + 0.000269360269360268*G0_28 - 0.00101330767997434*G0_29 + 0.000269360269360266*G0_30 - 0.000179573512906843*G0_31 - 7.6960076960077e-05*G0_32 - 7.69600769600788e-05*G0_33 - 0.00102613435946769*G0_34;
    A[12] = -0.000121853455186786*G0_0 - 6.84089572978456e-05*G0_1 - 0.000149644594089037*G0_2 - 0.000121853455186787*G0_3 + 0.000855111966223068*G0_4 - 0.000654160654160647*G0_5 + 0.000359147025813688*G0_6 + 0.000359147025813689*G0_7 - 0.000153920153920152*G0_8 + 0.000273635829191381*G0_9 + 0.000684089572978454*G0_10 - 0.00125701459034791*G0_11 + 0.00171022393244614*G0_12 + 0.000136817914595692*G0_13 - 9.83378761156539e-05*G0_14 + 0.000136817914595691*G0_15 + 0.000359147025813687*G0_16 - 0.000654160654160647*G0_17 + 0.00085511196622307*G0_18 + 0.000273635829191382*G0_19 - 0.000153920153920153*G0_20 + 0.000359147025813688*G0_21 + 0.000513067179733841*G0_22 + 0.000102613435946763*G0_23 - 3.42044786489221e-05*G0_24 - 1.71022393244608e-05*G0_25 + 5.13067179733824e-05*G0_26 - 1.71022393244605e-05*G0_27 + 8.5511196622309e-05*G0_28 + 0.000974827641494299*G0_29 + 8.55111966223071e-05*G0_30 - 3.42044786489217e-05*G0_31 + 0.00051306717973384*G0_32 + 0.000102613435946766*G0_33 + 0.00109454331676553*G0_34;
    A[13] = -0.000149644594089037*G0_0 - 0.000121853455186788*G0_1 - 0.000121853455186788*G0_2 - 6.84089572978461e-05*G0_3 + 0.000273635829191384*G0_4 - 0.000153920153920154*G0_5 + 0.000359147025813692*G0_6 + 0.000273635829191385*G0_7 - 0.000153920153920154*G0_8 + 0.000359147025813692*G0_9 + 0.000136817914595692*G0_10 - 9.83378761156542e-05*G0_11 + 0.000136817914595692*G0_12 + 0.00171022393244614*G0_13 - 0.00125701459034792*G0_14 + 0.000684089572978458*G0_15 + 0.000855111966223069*G0_16 - 0.000654160654160649*G0_17 + 0.000359147025813691*G0_18 + 0.000855111966223072*G0_19 - 0.00065416065416065*G0_20 + 0.000359147025813689*G0_21 + 8.55111966223108e-05*G0_22 + 8.55111966223086e-05*G0_23 + 0.000974827641494303*G0_24 + 0.000102613435946767*G0_25 - 3.42044786489219e-05*G0_26 + 0.000513067179733844*G0_27 + 0.000102613435946769*G0_28 - 3.42044786489187e-05*G0_29 + 0.000513067179733843*G0_30 + 5.13067179733838e-05*G0_31 - 1.7102239324459e-05*G0_32 - 1.71022393244611e-05*G0_33 + 0.00109454331676554*G0_34;
    A[14] = 0.000112233445566778*G0_0 + 8.39078616856391e-05*G0_1 + 8.39078616856394e-05*G0_2 + 0.000112233445566779*G0_3 - 0.000153920153920154*G0_4 + 0.000256533589866923*G0_5 - 0.000654160654160652*G0_6 - 0.000153920153920155*G0_7 + 0.000256533589866923*G0_8 - 0.000654160654160652*G0_9 - 9.83378761156535e-05*G0_10 + 1.92400192400198e-05*G0_11 - 9.83378761156539e-05*G0_12 - 0.00125701459034792*G0_13 + 0.00238576238576237*G0_14 - 0.00125701459034792*G0_15 - 0.000654160654160649*G0_16 + 0.000256533589866922*G0_17 - 0.000153920153920154*G0_18 - 0.00065416065416065*G0_19 + 0.000256533589866923*G0_20 - 0.000153920153920153*G0_21 + 0.000269360269360266*G0_22 + 0.000269360269360267*G0_23 - 0.00101330767997434*G0_24 - 7.69600769600749e-05*G0_25 - 0.000179573512906846*G0_26 - 7.69600769600788e-05*G0_27 - 7.69600769600764e-05*G0_28 - 0.000179573512906849*G0_29 - 7.69600769600795e-05*G0_30 - 0.00101330767997434*G0_31 + 0.000269360269360265*G0_32 + 0.000269360269360266*G0_33 - 0.0010261343594677*G0_34;
    A[15] = -6.84089572978449e-05*G0_0 - 0.000121853455186788*G0_1 - 0.000121853455186788*G0_2 - 0.000149644594089038*G0_3 + 0.000359147025813691*G0_4 - 0.000654160654160651*G0_5 + 0.000855111966223072*G0_6 + 0.000359147025813691*G0_7 - 0.000654160654160651*G0_8 + 0.000855111966223072*G0_9 + 0.000136817914595691*G0_10 - 9.83378761156533e-05*G0_11 + 0.000136817914595691*G0_12 + 0.000684089572978458*G0_13 - 0.00125701459034792*G0_14 + 0.00171022393244614*G0_15 + 0.000359147025813688*G0_16 - 0.000153920153920153*G0_17 + 0.000273635829191384*G0_18 + 0.00035914702581369*G0_19 - 0.000153920153920154*G0_20 + 0.000273635829191381*G0_21 - 1.71022393244611e-05*G0_22 - 1.71022393244604e-05*G0_23 + 5.13067179733835e-05*G0_24 + 0.000513067179733841*G0_25 - 3.4204478648922e-05*G0_26 + 0.000102613435946769*G0_27 + 0.000513067179733842*G0_28 - 3.42044786489213e-05*G0_29 + 0.000102613435946768*G0_30 + 0.000974827641494298*G0_31 + 8.55111966223068e-05*G0_32 + 8.55111966223077e-05*G0_33 + 0.00109454331676553*G0_34;
    A[16] = -0.000149644594089036*G0_0 - 0.000121853455186787*G0_1 - 6.8408957297845e-05*G0_2 - 0.000121853455186787*G0_3 + 0.000359147025813688*G0_4 - 0.000153920153920152*G0_5 + 0.000273635829191382*G0_6 + 0.000136817914595691*G0_7 - 9.8337876115653e-05*G0_8 + 0.000136817914595691*G0_9 + 0.000273635829191381*G0_10 - 0.000153920153920152*G0_11 + 0.000359147025813688*G0_12 + 0.00085511196622307*G0_13 - 0.000654160654160649*G0_14 + 0.000359147025813688*G0_15 + 0.00171022393244614*G0_16 - 0.00125701459034791*G0_17 + 0.000684089572978456*G0_18 + 0.00085511196622307*G0_19 - 0.000654160654160649*G0_20 + 0.000359147025813687*G0_21 + 8.5511196622307e-05*G0_22 + 0.000974827641494301*G0_23 + 8.5511196622308e-05*G0_24 + 0.000102613435946765*G0_25 + 0.000513067179733844*G0_26 - 3.42044786489219e-05*G0_27 + 5.13067179733824e-05*G0_28 - 1.71022393244606e-05*G0_29 - 1.71022393244618e-05*G0_30 + 0.000102613435946766*G0_31 - 3.4204478648923e-05*G0_32 + 0.000513067179733842*G0_33 + 0.00109454331676553*G0_34;
    A[17] = 0.000112233445566777*G0_0 + 8.39078616856391e-05*G0_1 + 0.000112233445566778*G0_2 + 8.39078616856391e-05*G0_3 - 0.000654160654160648*G0_4 + 0.000256533589866921*G0_5 - 0.000153920153920154*G0_6 - 9.83378761156544e-05*G0_7 + 1.92400192400203e-05*G0_8 - 9.83378761156542e-05*G0_9 - 0.000153920153920153*G0_10 + 0.000256533589866921*G0_11 - 0.000654160654160647*G0_12 - 0.000654160654160649*G0_13 + 0.000256533589866922*G0_14 - 0.000153920153920153*G0_15 - 0.00125701459034791*G0_16 + 0.00238576238576236*G0_17 - 0.00125701459034791*G0_18 - 0.000654160654160649*G0_19 + 0.000256533589866923*G0_20 - 0.000153920153920153*G0_21 + 0.000269360269360267*G0_22 - 0.00101330767997434*G0_23 + 0.000269360269360266*G0_24 - 7.69600769600793e-05*G0_25 - 7.69600769600773e-05*G0_26 - 0.000179573512906845*G0_27 - 0.00101330767997434*G0_28 + 0.000269360269360266*G0_29 + 0.000269360269360266*G0_30 - 7.69600769600775e-05*G0_31 - 0.000179573512906846*G0_32 - 7.69600769600771e-05*G0_33 - 0.00102613435946769*G0_34;
    A[18] = -6.84089572978445e-05*G0_0 - 0.000121853455186788*G0_1 - 0.000149644594089037*G0_2 - 0.000121853455186788*G0_3 + 0.00085511196622307*G0_4 - 0.000654160654160649*G0_5 + 0.00035914702581369*G0_6 + 0.000136817914595693*G0_7 - 9.83378761156543e-05*G0_8 + 0.000136817914595692*G0_9 + 0.000359147025813689*G0_10 - 0.000654160654160648*G0_11 + 0.00085511196622307*G0_12 + 0.000359147025813691*G0_13 - 0.000153920153920154*G0_14 + 0.000273635829191384*G0_15 + 0.000684089572978456*G0_16 - 0.00125701459034791*G0_17 + 0.00171022393244614*G0_18 + 0.000359147025813691*G0_19 - 0.000153920153920155*G0_20 + 0.000273635829191382*G0_21 - 1.7102239324461e-05*G0_22 + 5.13067179733836e-05*G0_23 - 1.71022393244591e-05*G0_24 + 0.000513067179733845*G0_25 + 0.000102613435946766*G0_26 - 3.42044786489196e-05*G0_27 + 0.000974827641494302*G0_28 + 8.5511196622308e-05*G0_29 + 8.55111966223094e-05*G0_30 + 0.000513067179733844*G0_31 - 3.4204478648922e-05*G0_32 + 0.000102613435946769*G0_33 + 0.00109454331676554*G0_34;
    A[19] = -0.000149644594089037*G0_0 - 6.84089572978459e-05*G0_1 - 0.000121853455186787*G0_2 - 0.000121853455186788*G0_3 + 0.000136817914595692*G0_4 - 9.83378761156543e-05*G0_5 + 0.000136817914595693*G0_6 + 0.00035914702581369*G0_7 - 0.000153920153920153*G0_8 + 0.000273635829191383*G0_9 + 0.000359147025813689*G0_10 - 0.000153920153920153*G0_11 + 0.000273635829191382*G0_12 + 0.000855111966223072*G0_13 - 0.00065416065416065*G0_14 + 0.00035914702581369*G0_15 + 0.00085511196622307*G0_16 - 0.000654160654160649*G0_17 + 0.000359147025813691*G0_18 + 0.00171022393244614*G0_19 - 0.00125701459034791*G0_20 + 0.000684089572978455*G0_21 + 0.000974827641494302*G0_22 + 8.55111966223087e-05*G0_23 + 8.55111966223104e-05*G0_24 + 5.13067179733826e-05*G0_25 - 1.71022393244601e-05*G0_26 - 1.71022393244587e-05*G0_27 + 0.000102613435946766*G0_28 + 0.000513067179733843*G0_29 - 3.420447864892e-05*G0_30 + 0.000102613435946768*G0_31 + 0.000513067179733842*G0_32 - 3.42044786489211e-05*G0_33 + 0.00109454331676554*G0_34;
    A[20] = 0.000112233445566777*G0_0 + 0.000112233445566778*G0_1 + 8.39078616856388e-05*G0_2 + 8.3907861685639e-05*G0_3 - 9.83378761156539e-05*G0_4 + 1.92400192400202e-05*G0_5 - 9.83378761156542e-05*G0_6 - 0.000654160654160649*G0_7 + 0.000256533589866921*G0_8 - 0.000153920153920154*G0_9 - 0.000654160654160648*G0_10 + 0.000256533589866921*G0_11 - 0.000153920153920153*G0_12 - 0.00065416065416065*G0_13 + 0.000256533589866923*G0_14 - 0.000153920153920154*G0_15 - 0.000654160654160649*G0_16 + 0.000256533589866923*G0_17 - 0.000153920153920155*G0_18 - 0.00125701459034791*G0_19 + 0.00238576238576236*G0_20 - 0.00125701459034791*G0_21 - 0.00101330767997434*G0_22 + 0.000269360269360269*G0_23 + 0.000269360269360266*G0_24 - 0.00101330767997434*G0_25 + 0.000269360269360269*G0_26 + 0.000269360269360265*G0_27 - 7.69600769600807e-05*G0_28 - 7.69600769600769e-05*G0_29 - 0.000179573512906845*G0_30 - 7.69600769600798e-05*G0_31 - 7.69600769600762e-05*G0_32 - 0.000179573512906844*G0_33 - 0.00102613435946769*G0_34;
    A[21] = -6.84089572978438e-05*G0_0 - 0.000149644594089037*G0_1 - 0.000121853455186787*G0_2 - 0.000121853455186787*G0_3 + 0.00013681791459569*G0_4 - 9.83378761156527e-05*G0_5 + 0.00013681791459569*G0_6 + 0.000855111966223068*G0_7 - 0.000654160654160646*G0_8 + 0.000359147025813688*G0_9 + 0.000855111966223068*G0_10 - 0.000654160654160647*G0_11 + 0.000359147025813688*G0_12 + 0.000359147025813689*G0_13 - 0.000153920153920153*G0_14 + 0.000273635829191382*G0_15 + 0.000359147025813687*G0_16 - 0.000153920153920153*G0_17 + 0.000273635829191382*G0_18 + 0.000684089572978455*G0_19 - 0.00125701459034791*G0_20 + 0.00171022393244614*G0_21 + 5.13067179733814e-05*G0_22 - 1.71022393244638e-05*G0_23 - 1.71022393244615e-05*G0_24 + 0.000974827641494301*G0_25 + 8.55111966223051e-05*G0_26 + 8.55111966223076e-05*G0_27 + 0.000513067179733844*G0_28 + 0.000102613435946764*G0_29 - 3.42044786489226e-05*G0_30 + 0.000513067179733843*G0_31 + 0.000102613435946765*G0_32 - 3.42044786489242e-05*G0_33 + 0.00109454331676552*G0_34;
    A[22] = -0.000215915771471324*G0_0 + 0.000288600288600287*G0_1 - 0.000185986852653516*G0_2 - 0.000185986852653517*G0_3 - 3.42044786489231e-05*G0_4 - 0.000179573512906845*G0_5 - 3.42044786489236e-05*G0_6 + 0.000102613435946766*G0_7 - 7.69600769600725e-05*G0_8 + 0.000513067179733841*G0_9 + 0.000102613435946764*G0_10 - 7.69600769600791e-05*G0_11 + 0.000513067179733841*G0_12 + 8.55111966223108e-05*G0_13 + 0.000269360269360266*G0_14 - 1.71022393244611e-05*G0_15 + 8.5511196622307e-05*G0_16 + 0.000269360269360267*G0_17 - 1.7102239324461e-05*G0_18 + 0.000974827641494302*G0_19 - 0.00101330767997434*G0_20 + 5.13067179733814e-05*G0_21 + 0.00779862113195442*G0_22 - 0.00205226871893538*G0_23 - 0.00205226871893537*G0_24 - 0.000205226871893537*G0_25 - 0.00143658810325477*G0_26 - 0.00143658810325476*G0_27 - 0.00143658810325476*G0_28 + 0.00389931056597721*G0_29 - 0.00102613435946769*G0_30 - 0.00143658810325476*G0_31 + 0.0038993105659772*G0_32 - 0.00102613435946769*G0_33 + 0.0016418149751483*G0_34;
    A[23] = -0.000215915771471324*G0_0 - 0.000185986852653519*G0_1 + 0.000288600288600287*G0_2 - 0.000185986852653519*G0_3 + 0.000102613435946766*G0_4 - 7.69600769600751e-05*G0_5 + 0.000513067179733843*G0_6 - 3.42044786489207e-05*G0_7 - 0.000179573512906847*G0_8 - 3.4204478648922e-05*G0_9 + 0.000513067179733843*G0_10 - 7.69600769600788e-05*G0_11 + 0.000102613435946763*G0_12 + 8.55111966223086e-05*G0_13 + 0.000269360269360267*G0_14 - 1.71022393244604e-05*G0_15 + 0.000974827641494302*G0_16 - 0.00101330767997434*G0_17 + 5.13067179733835e-05*G0_18 + 8.55111966223087e-05*G0_19 + 0.000269360269360269*G0_20 - 1.71022393244638e-05*G0_21 - 0.00205226871893538*G0_22 + 0.0077986211319544*G0_23 - 0.00205226871893537*G0_24 - 0.00143658810325476*G0_25 + 0.00389931056597721*G0_26 - 0.00102613435946769*G0_27 - 0.000205226871893536*G0_28 - 0.00143658810325476*G0_29 - 0.00143658810325476*G0_30 - 0.00143658810325476*G0_31 - 0.00102613435946769*G0_32 + 0.0038993105659772*G0_33 + 0.00164181497514829*G0_34;
    A[24] = -0.000215915771471325*G0_0 - 0.000185986852653518*G0_1 - 0.000185986852653519*G0_2 + 0.000288600288600286*G0_3 + 0.000513067179733844*G0_4 - 7.69600769600771e-05*G0_5 + 0.000102613435946769*G0_6 + 0.000513067179733846*G0_7 - 7.6960076960075e-05*G0_8 + 0.000102613435946769*G0_9 - 3.42044786489217e-05*G0_10 - 0.000179573512906844*G0_11 - 3.4204478648922e-05*G0_12 + 0.000974827641494303*G0_13 - 0.00101330767997434*G0_14 + 5.13067179733835e-05*G0_15 + 8.55111966223081e-05*G0_16 + 0.000269360269360266*G0_17 - 1.7102239324459e-05*G0_18 + 8.55111966223104e-05*G0_19 + 0.000269360269360266*G0_20 - 1.71022393244615e-05*G0_21 - 0.00205226871893537*G0_22 - 0.00205226871893537*G0_23 + 0.00779862113195441*G0_24 - 0.00143658810325477*G0_25 - 0.00102613435946768*G0_26 + 0.00389931056597721*G0_27 - 0.00143658810325476*G0_28 - 0.00102613435946768*G0_29 + 0.00389931056597721*G0_30 - 0.000205226871893539*G0_31 - 0.00143658810325476*G0_32 - 0.00143658810325476*G0_33 + 0.00164181497514831*G0_34;
    A[25] = 0.000288600288600288*G0_0 - 0.000215915771471325*G0_1 - 0.000185986852653517*G0_2 - 0.000185986852653518*G0_3 - 3.42044786489231e-05*G0_4 - 0.000179573512906845*G0_5 - 3.4204478648924e-05*G0_6 + 8.55111966223046e-05*G0_7 + 0.000269360269360267*G0_8 - 1.71022393244626e-05*G0_9 + 8.55111966223058e-05*G0_10 + 0.000269360269360269*G0_11 - 1.71022393244608e-05*G0_12 + 0.000102613435946767*G0_13 - 7.69600769600748e-05*G0_14 + 0.00051306717973384*G0_15 + 0.000102613435946765*G0_16 - 7.69600769600793e-05*G0_17 + 0.000513067179733845*G0_18 + 5.13067179733827e-05*G0_19 - 0.00101330767997434*G0_20 + 0.000974827641494301*G0_21 - 0.000205226871893538*G0_22 - 0.00143658810325476*G0_23 - 0.00143658810325477*G0_24 + 0.00779862113195442*G0_25 - 0.00205226871893538*G0_26 - 0.00205226871893537*G0_27 + 0.00389931056597721*G0_28 - 0.00143658810325476*G0_29 - 0.00102613435946769*G0_30 + 0.0038993105659772*G0_31 - 0.00143658810325476*G0_32 - 0.00102613435946769*G0_33 + 0.00164181497514829*G0_34;
    A[26] = -0.000185986852653516*G0_0 - 0.000215915771471326*G0_1 + 0.000288600288600288*G0_2 - 0.000185986852653518*G0_3 + 0.000102613435946766*G0_4 - 7.69600769600741e-05*G0_5 + 0.000513067179733843*G0_6 + 8.55111966223095e-05*G0_7 + 0.000269360269360265*G0_8 - 1.71022393244608e-05*G0_9 + 0.000974827641494302*G0_10 - 0.00101330767997434*G0_11 + 5.13067179733824e-05*G0_12 - 3.42044786489219e-05*G0_13 - 0.000179573512906846*G0_14 - 3.42044786489221e-05*G0_15 + 0.000513067179733844*G0_16 - 7.69600769600772e-05*G0_17 + 0.000102613435946766*G0_18 - 1.71022393244601e-05*G0_19 + 0.000269360269360269*G0_20 + 8.55111966223051e-05*G0_21 - 0.00143658810325477*G0_22 + 0.00389931056597721*G0_23 - 0.00102613435946768*G0_24 - 0.00205226871893538*G0_25 + 0.00779862113195442*G0_26 - 0.00205226871893537*G0_27 - 0.00143658810325476*G0_28 - 0.000205226871893539*G0_29 - 0.00143658810325476*G0_30 - 0.00102613435946769*G0_31 - 0.00143658810325476*G0_32 + 0.00389931056597721*G0_33 + 0.0016418149751483*G0_34;
    A[27] = -0.000185986852653516*G0_0 - 0.000215915771471326*G0_1 - 0.000185986852653519*G0_2 + 0.000288600288600287*G0_3 + 0.000513067179733845*G0_4 - 7.69600769600775e-05*G0_5 + 0.000102613435946769*G0_6 + 0.000974827641494305*G0_7 - 0.00101330767997434*G0_8 + 5.13067179733846e-05*G0_9 + 8.55111966223086e-05*G0_10 + 0.000269360269360267*G0_11 - 1.71022393244605e-05*G0_12 + 0.000513067179733844*G0_13 - 7.69600769600788e-05*G0_14 + 0.000102613435946769*G0_15 - 3.42044786489218e-05*G0_16 - 0.000179573512906845*G0_17 - 3.42044786489195e-05*G0_18 - 1.71022393244587e-05*G0_19 + 0.000269360269360265*G0_20 + 8.55111966223076e-05*G0_21 - 0.00143658810325476*G0_22 - 0.00102613435946769*G0_23 + 0.00389931056597721*G0_24 - 0.00205226871893537*G0_25 - 0.00205226871893537*G0_26 + 0.00779862113195442*G0_27 - 0.00102613435946768*G0_28 - 0.00143658810325476*G0_29 + 0.00389931056597721*G0_30 - 0.00143658810325476*G0_31 - 0.00020522687189354*G0_32 - 0.00143658810325476*G0_33 + 0.00164181497514831*G0_34;
    A[28] = 0.000288600288600287*G0_0 - 0.000185986852653518*G0_1 - 0.000215915771471325*G0_2 - 0.000185986852653518*G0_3 + 8.55111966223083e-05*G0_4 + 0.000269360269360266*G0_5 - 1.71022393244599e-05*G0_6 - 3.42044786489235e-05*G0_7 - 0.000179573512906847*G0_8 - 3.42044786489223e-05*G0_9 - 1.71022393244607e-05*G0_10 + 0.000269360269360268*G0_11 + 8.5511196622309e-05*G0_12 + 0.000102613435946769*G0_13 - 7.69600769600765e-05*G0_14 + 0.000513067179733842*G0_15 + 5.13067179733824e-05*G0_16 - 0.00101330767997434*G0_17 + 0.000974827641494302*G0_18 + 0.000102613435946766*G0_19 - 7.69600769600808e-05*G0_20 + 0.000513067179733844*G0_21 - 0.00143658810325476*G0_22 - 0.000205226871893536*G0_23 - 0.00143658810325476*G0_24 + 0.00389931056597721*G0_25 - 0.00143658810325476*G0_26 - 0.00102613435946768*G0_27 + 0.00779862113195441*G0_28 - 0.00205226871893537*G0_29 - 0.00205226871893537*G0_30 + 0.0038993105659772*G0_31 - 0.00102613435946768*G0_32 - 0.00143658810325476*G0_33 + 0.0016418149751483*G0_34;
    A[29] = -0.000185986852653516*G0_0 + 0.000288600288600287*G0_1 - 0.000215915771471324*G0_2 - 0.000185986852653517*G0_3 + 8.55111966223071e-05*G0_4 + 0.000269360269360268*G0_5 - 1.71022393244605e-05*G0_6 + 0.000102613435946768*G0_7 - 7.69600769600744e-05*G0_8 + 0.000513067179733842*G0_9 + 5.13067179733813e-05*G0_10 - 0.00101330767997434*G0_11 + 0.000974827641494299*G0_12 - 3.42044786489188e-05*G0_13 - 0.000179573512906849*G0_14 - 3.42044786489213e-05*G0_15 - 1.71022393244606e-05*G0_16 + 0.000269360269360266*G0_17 + 8.5511196622308e-05*G0_18 + 0.000513067179733843*G0_19 - 7.69600769600771e-05*G0_20 + 0.000102613435946764*G0_21 + 0.00389931056597721*G0_22 - 0.00143658810325476*G0_23 - 0.00102613435946768*G0_24 - 0.00143658810325476*G0_25 - 0.000205226871893539*G0_26 - 0.00143658810325476*G0_27 - 0.00205226871893537*G0_28 + 0.00779862113195441*G0_29 - 0.00205226871893537*G0_30 - 0.00102613435946768*G0_31 + 0.0038993105659772*G0_32 - 0.00143658810325476*G0_33 + 0.0016418149751483*G0_34;
    A[30] = -0.000185986852653516*G0_0 - 0.000185986852653518*G0_1 - 0.000215915771471327*G0_2 + 0.000288600288600286*G0_3 + 0.000974827641494301*G0_4 - 0.00101330767997434*G0_5 + 5.13067179733835e-05*G0_6 + 0.000513067179733846*G0_7 - 7.69600769600764e-05*G0_8 + 0.000102613435946769*G0_9 - 1.71022393244607e-05*G0_10 + 0.000269360269360266*G0_11 + 8.55111966223071e-05*G0_12 + 0.000513067179733843*G0_13 - 7.69600769600797e-05*G0_14 + 0.000102613435946768*G0_15 - 1.71022393244618e-05*G0_16 + 0.000269360269360266*G0_17 + 8.55111966223093e-05*G0_18 - 3.420447864892e-05*G0_19 - 0.000179573512906845*G0_20 - 3.42044786489226e-05*G0_21 - 0.00102613435946769*G0_22 - 0.00143658810325476*G0_23 + 0.00389931056597721*G0_24 - 0.00102613435946769*G0_25 - 0.00143658810325476*G0_26 + 0.00389931056597721*G0_27 - 0.00205226871893537*G0_28 - 0.00205226871893537*G0_29 + 0.00779862113195441*G0_30 - 0.00143658810325476*G0_31 - 0.00143658810325476*G0_32 - 0.000205226871893541*G0_33 + 0.00164181497514831*G0_34;
    A[31] = 0.000288600288600287*G0_0 - 0.000185986852653518*G0_1 - 0.000185986852653518*G0_2 - 0.000215915771471324*G0_3 - 1.71022393244609e-05*G0_4 + 0.000269360269360267*G0_5 + 8.55111966223065e-05*G0_6 - 1.71022393244627e-05*G0_7 + 0.000269360269360267*G0_8 + 8.55111966223058e-05*G0_9 - 3.42044786489238e-05*G0_10 - 0.000179573512906843*G0_11 - 3.42044786489218e-05*G0_12 + 5.13067179733838e-05*G0_13 - 0.00101330767997434*G0_14 + 0.000974827641494298*G0_15 + 0.000102613435946766*G0_16 - 7.69600769600774e-05*G0_17 + 0.000513067179733844*G0_18 + 0.000102613435946768*G0_19 - 7.69600769600798e-05*G0_20 + 0.000513067179733843*G0_21 - 0.00143658810325476*G0_22 - 0.00143658810325476*G0_23 - 0.000205226871893539*G0_24 + 0.0038993105659772*G0_25 - 0.00102613435946769*G0_26 - 0.00143658810325476*G0_27 + 0.0038993105659772*G0_28 - 0.00102613435946768*G0_29 - 0.00143658810325476*G0_30 + 0.0077986211319544*G0_31 - 0.00205226871893537*G0_32 - 0.00205226871893537*G0_33 + 0.00164181497514829*G0_34;
    A[32] = -0.000185986852653516*G0_0 + 0.000288600288600287*G0_1 - 0.000185986852653517*G0_2 - 0.000215915771471325*G0_3 - 1.71022393244622e-05*G0_4 + 0.000269360269360267*G0_5 + 8.5511196622307e-05*G0_6 + 5.13067179733827e-05*G0_7 - 0.00101330767997434*G0_8 + 0.000974827641494298*G0_9 + 0.000102613435946766*G0_10 - 7.6960076960077e-05*G0_11 + 0.00051306717973384*G0_12 - 1.7102239324459e-05*G0_13 + 0.000269360269360266*G0_14 + 8.55111966223069e-05*G0_15 - 3.42044786489229e-05*G0_16 - 0.000179573512906846*G0_17 - 3.42044786489221e-05*G0_18 + 0.000513067179733842*G0_19 - 7.69600769600761e-05*G0_20 + 0.000102613435946765*G0_21 + 0.0038993105659772*G0_22 - 0.00102613435946769*G0_23 - 0.00143658810325476*G0_24 - 0.00143658810325476*G0_25 - 0.00143658810325476*G0_26 - 0.00020522687189354*G0_27 - 0.00102613435946768*G0_28 + 0.0038993105659772*G0_29 - 0.00143658810325476*G0_30 - 0.00205226871893537*G0_31 + 0.0077986211319544*G0_32 - 0.00205226871893537*G0_33 + 0.00164181497514829*G0_34;
    A[33] = -0.000185986852653516*G0_0 - 0.000185986852653518*G0_1 + 0.000288600288600287*G0_2 - 0.000215915771471325*G0_3 + 5.13067179733818e-05*G0_4 - 0.00101330767997434*G0_5 + 0.0009748276414943*G0_6 - 1.71022393244584e-05*G0_7 + 0.000269360269360265*G0_8 + 8.55111966223081e-05*G0_9 + 0.000513067179733843*G0_10 - 7.69600769600788e-05*G0_11 + 0.000102613435946766*G0_12 - 1.71022393244611e-05*G0_13 + 0.000269360269360266*G0_14 + 8.55111966223078e-05*G0_15 + 0.000513067179733842*G0_16 - 7.69600769600771e-05*G0_17 + 0.000102613435946769*G0_18 - 3.42044786489211e-05*G0_19 - 0.000179573512906844*G0_20 - 3.42044786489242e-05*G0_21 - 0.00102613435946769*G0_22 + 0.0038993105659772*G0_23 - 0.00143658810325476*G0_24 - 0.00102613435946769*G0_25 + 0.00389931056597721*G0_26 - 0.00143658810325476*G0_27 - 0.00143658810325476*G0_28 - 0.00143658810325476*G0_29 - 0.000205226871893542*G0_30 - 0.00205226871893537*G0_31 - 0.00205226871893537*G0_32 + 0.0077986211319544*G0_33 + 0.00164181497514829*G0_34;
    A[34] = -0.000538720538720526*G0_0 - 0.000538720538720536*G0_1 - 0.000538720538720532*G0_2 - 0.000538720538720535*G0_3 + 0.00109454331676553*G0_4 - 0.00102613435946768*G0_5 + 0.00109454331676553*G0_6 + 0.00109454331676554*G0_7 - 0.00102613435946769*G0_8 + 0.00109454331676553*G0_9 + 0.00109454331676553*G0_10 - 0.00102613435946769*G0_11 + 0.00109454331676553*G0_12 + 0.00109454331676554*G0_13 - 0.0010261343594677*G0_14 + 0.00109454331676553*G0_15 + 0.00109454331676553*G0_16 - 0.00102613435946769*G0_17 + 0.00109454331676554*G0_18 + 0.00109454331676554*G0_19 - 0.00102613435946769*G0_20 + 0.00109454331676552*G0_21 + 0.0016418149751483*G0_22 + 0.0016418149751483*G0_23 + 0.00164181497514831*G0_24 + 0.00164181497514829*G0_25 + 0.0016418149751483*G0_26 + 0.00164181497514831*G0_27 + 0.0016418149751483*G0_28 + 0.0016418149751483*G0_29 + 0.00164181497514831*G0_30 + 0.00164181497514829*G0_31 + 0.00164181497514829*G0_32 + 0.00164181497514829*G0_33 + 0.0262690396023728*G0_34;
}

/// Constructor
poisson3d_4_form_0::poisson3d_4_form_0() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson3d_4_form_0::~poisson3d_4_form_0()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson3d_4_form_0::signature() const
{
    return "340d8f5c9ce7b303e79284500b0ce34da2ddca57afa75e9566ee945eb2abf3761d4355deb21c82abb632d72e2c5fd54f899691b5d2be9d1da4d99346ae0cf1a7";
}

/// Return the rank of the global tensor (r)
std::size_t poisson3d_4_form_0::rank() const
{
    return 2;
}

/// Return the number of coefficients (n)
std::size_t poisson3d_4_form_0::num_coefficients() const
{
    return 0;
}

/// Return the number of cell domains
std::size_t poisson3d_4_form_0::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson3d_4_form_0::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson3d_4_form_0::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson3d_4_form_0::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t poisson3d_4_form_0::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson3d_4_form_0::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson3d_4_form_0::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson3d_4_form_0::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson3d_4_form_0::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool poisson3d_4_form_0::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson3d_4_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson3d_4_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson3d_4_form_0::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson3d_4_form_0::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson3d_4_form_0::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson3d_4_form_0::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* poisson3d_4_form_0::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson3d_4_form_0::create_default_cell_integral() const
{
    return new poisson3d_4_cell_integral_0_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson3d_4_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson3d_4_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson3d_4_form_0::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* poisson3d_4_form_0::create_default_custom_integral() const
{
    return 0;
}


/// Constructor
poisson3d_4_form_1::poisson3d_4_form_1() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson3d_4_form_1::~poisson3d_4_form_1()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson3d_4_form_1::signature() const
{
    return "44447132910ec8f7653ba2be711d10970c8c7de03ec051406a760918bc0daf0ca0702a39b67205a5209b58c100823e2885a99ee1f0e6e9149320ea08e1e2cfb2";
}

/// Return the rank of the global tensor (r)
std::size_t poisson3d_4_form_1::rank() const
{
    return 1;
}

/// Return the number of coefficients (n)
std::size_t poisson3d_4_form_1::num_coefficients() const
{
    return 1;
}

/// Return the number of cell domains
std::size_t poisson3d_4_form_1::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson3d_4_form_1::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson3d_4_form_1::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson3d_4_form_1::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t poisson3d_4_form_1::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson3d_4_form_1::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson3d_4_form_1::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson3d_4_form_1::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson3d_4_form_1::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool poisson3d_4_form_1::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson3d_4_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson3d_4_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson3d_4_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson3d_4_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson3d_4_form_1::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson3d_4_form_1::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson3d_4_form_1::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson3d_4_form_1::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* poisson3d_4_form_1::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson3d_4_form_1::create_default_cell_integral() const
{
    return new poisson3d_4_cell_integral_1_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson3d_4_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson3d_4_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson3d_4_form_1::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* poisson3d_4_form_1::create_default_custom_integral() const
{
    return 0;
}


