__author__ = "Anders Logg <logg@simula.no>"
__date__ = "2010-02-14"
__copyright__ = "Copyright (C) 2010 " + __author__
__license__  = "GNU LGPL Version 2.1"

# Last changed: 2010-02-14

import os

__all__ = ["memory_usage"]

def memory_usage(as_string=True):
    """
    Return memory usage of current process. Note that this function
    only works on Linux systems. If the flag as_string is true, memory
    usage is returned as a string. Otherwise, a tuple of integers is
    returned with current memory usage and maximum memory usage in kB.
    """

    # Try reading /proc
    try:
        pid = os.getpid()
        status = open("/proc/%d/status" % pid).read()
    except:
        return "Failed to get memory usage, chances are you are not running GNU/Linux."

    # Parse values
    vmsize = int(status.split("VmSize:")[1].split("kB")[0])
    vmpeak = int(status.split("VmPeak:")[1].split("kB")[0])

    # Return values
    if as_string:
        return "Memory usage is %d kB (peak usage is %d kB)" % (vmsize, vmpeak)
    else:
        return (vmsize, vmpeak)
