/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Params;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.AttList;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.QName;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Table {
    private static int pixelsPerInch = 96;
    protected static Hashtable unitHash = null;
    protected static String foURI = "http://www.w3.org/1999/XSL/Format";

    public DocumentFragment adjustColumnWidths(ExpressionContext context, NodeIterator xalanNI) {
        int count;
        int pixels;
        XPathContext xpcontext = (XPathContext)context;
        DOMHelper dh = xpcontext.getDOMHelper();
        int nominalWidth = Table.convertLength(Params.getString(context, "nominal.table.width"));
        String tableWidth = Params.getString(context, "table.width");
        String styleType = Params.getString(context, "stylesheet.result.type");
        boolean foStylesheet = styleType.equals("fo");
        DocumentFragment xalanRTF = (DocumentFragment)xalanNI.nextNode();
        Element colgroup = (Element)xalanRTF.getFirstChild();
        Node firstCol = null;
        firstCol = colgroup.getLocalName().equals("colgroup") ? colgroup.getFirstChild() : colgroup;
        Node child = firstCol;
        int numColumns = 0;
        while (child != null) {
            if (child.getNodeType() == 1 && (child.getNodeName().equals("col") || child.getNamespaceURI().equals(foURI) && child.getLocalName().equals("table-column"))) {
                ++numColumns;
            }
            child = child.getNextSibling();
        }
        String[] widths = new String[numColumns];
        Element[] columns = new Element[numColumns];
        int colnum = 0;
        child = firstCol;
        while (child != null) {
            if (child.getNodeType() == 1 && (child.getNodeName().equals("col") || child.getNamespaceURI().equals(foURI) && child.getLocalName().equals("table-column"))) {
                Element col = (Element)child;
                NamedNodeMap domAttr = col.getAttributes();
                AttList attr = new AttList(domAttr, dh);
                columns[colnum] = col;
                widths[colnum] = foStylesheet ? (attr.getValue("column-width") == null ? "1*" : attr.getValue("column-width")) : (attr.getValue("width") == null ? "1*" : attr.getValue("width"));
                ++colnum;
            }
            child = child.getNextSibling();
        }
        float relTotal = 0.0f;
        float[] relParts = new float[numColumns];
        float absTotal = 0.0f;
        float[] absParts = new float[numColumns];
        int count2 = 0;
        while (count2 < numColumns) {
            String width = widths[count2];
            int pos = width.indexOf("*");
            if (pos >= 0) {
                String relPart = width.substring(0, pos);
                String absPart = width.substring(pos + 1);
                try {
                    float rel = Float.parseFloat(relPart);
                    relTotal += rel;
                    relParts[count2] = rel;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(String.valueOf(relPart) + " is not a valid relative unit.");
                }
                pixels = 0;
                if (absPart != null && !absPart.equals("")) {
                    pixels = Table.convertLength(absPart);
                }
                absTotal += (float)pixels;
                absParts[count2] = pixels;
            } else {
                relParts[count2] = 0.0f;
                int pixels2 = 0;
                if (width != null && !width.equals("")) {
                    pixels2 = Table.convertLength(width);
                }
                absTotal += (float)pixels2;
                absParts[count2] = pixels2;
            }
            ++count2;
        }
        if (relTotal == 0.0f) {
            count = 0;
            while (count < numColumns) {
                Float f = new Float(absParts[count]);
                if (foStylesheet) {
                    int pixels3 = f.intValue();
                    float inches = (float)pixels3 / (float)pixelsPerInch;
                    widths[count] = String.valueOf(inches) + "in";
                } else {
                    widths[count] = Integer.toString(f.intValue());
                }
                ++count;
            }
        } else if (absTotal == 0.0f) {
            count = 0;
            while (count < numColumns) {
                float rel = relParts[count] / relTotal * 100.0f;
                Float f = new Float(rel);
                widths[count] = String.valueOf(Integer.toString(f.intValue())) + "%";
                ++count;
            }
        } else {
            int pixelWidth = nominalWidth;
            if (tableWidth.indexOf("%") <= 0) {
                pixelWidth = Table.convertLength(tableWidth);
            }
            if ((float)pixelWidth <= absTotal) {
                System.out.println("Table is wider than table width.");
            } else {
                pixelWidth = (int)((float)pixelWidth - absTotal);
            }
            absTotal = 0.0f;
            int count3 = 0;
            while (count3 < numColumns) {
                float rel = relParts[count3] / relTotal * (float)pixelWidth;
                relParts[count3] = rel + absParts[count3];
                absTotal += rel + absParts[count3];
                ++count3;
            }
            if (tableWidth.indexOf("%") <= 0) {
                int count4 = 0;
                while (count4 < numColumns) {
                    Float f = new Float(relParts[count4]);
                    if (foStylesheet) {
                        pixels = f.intValue();
                        float inches = (float)pixels / (float)pixelsPerInch;
                        widths[count4] = String.valueOf(inches) + "in";
                    } else {
                        widths[count4] = Integer.toString(f.intValue());
                    }
                    ++count4;
                }
            } else {
                int count5 = 0;
                while (count5 < numColumns) {
                    float rel = relParts[count5] / absTotal * 100.0f;
                    Float f = new Float(rel);
                    widths[count5] = String.valueOf(Integer.toString(f.intValue())) + "%";
                    ++count5;
                }
            }
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("PCE!");
            return xalanRTF;
        }
        Document doc = docBuilder.newDocument();
        DocumentFragment df = doc.createDocumentFragment();
        DOMBuilder rtf = new DOMBuilder(doc, df);
        try {
            String ns = colgroup.getNamespaceURI();
            String localName = colgroup.getLocalName();
            String name = colgroup.getTagName();
            NamedNodeMap colgroupDomAttr = colgroup.getAttributes();
            AttList colgroupAttr = new AttList(colgroupDomAttr, dh);
            if (colgroup.getLocalName().equals("colgroup")) {
                rtf.startElement(ns, localName, name, (Attributes)colgroupAttr);
            }
            colnum = 0;
            while (colnum < numColumns) {
                Element col = columns[colnum];
                NamedNodeMap domAttr = col.getAttributes();
                AttributesImpl attr = new AttributesImpl();
                int acount = 0;
                while (acount < domAttr.getLength()) {
                    Node a = domAttr.item(acount);
                    String a_ns = a.getNamespaceURI();
                    String a_localName = a.getLocalName();
                    if (foStylesheet && !a_localName.equals("column-width") || !a_localName.equalsIgnoreCase("width")) {
                        attr.addAttribute(a.getNamespaceURI(), a.getLocalName(), a.getNodeName(), "CDATA", a.getNodeValue());
                    }
                    ++acount;
                }
                if (foStylesheet) {
                    attr.addAttribute("", "column-width", "column-width", "CDATA", widths[colnum]);
                } else {
                    attr.addAttribute("", "width", "width", "CDATA", widths[colnum]);
                }
                rtf.startElement(col.getNamespaceURI(), col.getLocalName(), col.getTagName(), (Attributes)attr);
                rtf.endElement(col.getNamespaceURI(), col.getLocalName(), col.getTagName());
                ++colnum;
            }
            if (colgroup.getLocalName().equals("colgroup")) {
                rtf.endElement(ns, localName, name);
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SE!");
            return xalanRTF;
        }
        return df;
    }

    public static int convertLength(String length) {
        int sign = 1;
        String digits = "";
        String units = "";
        char[] lench = length.toCharArray();
        float flength = 0.0f;
        boolean done = false;
        int pos = 0;
        float factor = 1.0f;
        int pixels = 0;
        if (unitHash == null) {
            Table.initializeHash();
        }
        if (lench[pos] == '+' || lench[pos] == '-') {
            if (lench[pos] == '-') {
                sign = -1;
            }
            ++pos;
        }
        while (!done) {
            if (pos >= lench.length) {
                done = true;
                continue;
            }
            if ((lench[pos] > '9' || lench[pos] < '0') && lench[pos] != '.') {
                done = true;
                units = length.substring(pos);
                continue;
            }
            digits = String.valueOf(digits) + lench[pos++];
        }
        try {
            flength = Float.parseFloat(digits);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(String.valueOf(digits) + " is not a number; 1 used instead.");
            flength = 1.0f;
        }
        Float f = null;
        if (!units.equals("")) {
            f = (Float)unitHash.get(units);
            if (f == null) {
                System.out.println(String.valueOf(units) + " is not a known unit; 1 used instead.");
                factor = 1.0f;
            } else {
                factor = f.floatValue();
            }
        } else {
            factor = 1.0f;
        }
        f = new Float(flength * factor);
        pixels = f.intValue() * sign;
        return pixels;
    }

    private boolean getBooleanVariable(ExpressionContext context, String varName) {
        String stringValue = this.getStringVariable(context, varName);
        if (stringValue != null) {
            return !stringValue.equals("0") && !stringValue.equals("");
        }
        return false;
    }

    private int getIntVariable(ExpressionContext context, String varName) {
        String stringValue = this.getStringVariable(context, varName);
        if (stringValue != null) {
            try {
                int value = Integer.parseInt(stringValue);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("$" + varName + " is not an integer.");
            }
        }
        return 0;
    }

    public int getPixelsPerInch() {
        return pixelsPerInch;
    }

    private String getStringVariable(ExpressionContext context, String varName) {
        try {
            XPathContext xpc = (XPathContext)context;
            XObject var = xpc.getVariable(new QName(varName));
            if (var != null) {
                return var.toString();
            }
            System.out.println("$" + varName + " is not a defined parameter.");
            return "";
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer exception getting value of $" + varName);
            return "";
        }
    }

    protected static void initializeHash() {
        unitHash = new Hashtable();
        unitHash.put("in", new Float(pixelsPerInch));
        unitHash.put("cm", new Float((double)pixelsPerInch / 2.54));
        unitHash.put("mm", new Float((double)pixelsPerInch / 25.4));
        unitHash.put("pc", new Float(pixelsPerInch / 72 * 12));
        unitHash.put("pt", new Float(pixelsPerInch / 72));
        unitHash.put("px", new Float(1.0f));
    }

    public static void setPixelsPerInch(int value) {
        if (value > 0) {
            pixelsPerInch = value;
            Table.initializeHash();
        }
    }
}

