#!/bin/sh

FILE=/etc/hotplug/usb.usermap

function uninstall()
{
    if [ ! -f $FILE ]; then exit 0; fi
    sed -ibak -e '/usb2dmx/d;/dmxsunlite/d;/ftdi2dmx/d' $FILE
}

function install()
{
    if [ ! -d /etc/hotplug ]; then exit 0; fi
    if [ ! -f $FILE ]; then touch $FILE; fi

    uninstall

    echo "usb2dmx              0x0003 0x0ce1 0x1 0x0000 0x0000 0x00 0x00 0x00 0x00 0x00 0x00 0x00000000" >> $FILE
    echo "usb2dmx              0x0003 0x0ce1 0x2 0x0000 0x0000 0x00 0x00 0x00 0x00 0x00 0x00 0x00000000" >> $FILE
    echo "usb2dmx              0x0003 0x0ce1 0x3 0x0000 0x0000 0x00 0x00 0x00 0x00 0x00 0x00 0x00000000" >> $FILE

#    echo "dmxsunlite           0x0003 0x0962 0x1000 0x0000 0x0000 0x00 0x00 0x00 0x00 0x00 0x00 0x00000000" >> $FILE
    echo "dmxsunlite           0x0003 0x0962 0x2000 0x0000 0x0000 0x00 0x00 0x00 0x00 0x00 0x00 0x00000000" >> $FILE
    echo "dmxsunlite           0x0003 0x0962 0x2001 0x0000 0x0000 0x00 0x00 0x00 0x00 0x00 0x00 0x00000000" >> $FILE

    echo "ftdi2dmx             0x0003 0x403  0x6001 0x0000 0x0000 0x00 0x00 0x00 0x00 0x00 0x00 0x00000000" >> $FILE
}

if [ "$1" = "install" ]
then install
elif [ "$1" = "uninstall" ]
then uninstall
else
    echo 'setup_hotplug.sh "install"|"uninstall"'
    exit 1
fi

exit 0
