##
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##

import os, os.path

import DiskList

class DSDoc:
    """This class is the model (from MVC view) implementation of the application."""
    
    def __init__ (self):
        """Constructor of DSDoc class."""
        
        # get initial mountpoint (not same on all Unixes)
        self.mountPoint = "/media/cdrom"
        if os.path.exists (self.mountPoint) == 0:
            self.mountPoint = "/mnt/cdrom"
            if os.path.exists (self.mountPoint) == 0:
                self.mountPoint = "/cdrom"

        # these are for remember the search string, the reg-exp and the mount mode
        self.searchString = ""
        self.searchRegExpMode = 0
        self.searchCaseSensitive = 0
        self.mediaType = None
        self.mountMode = 0
        
    def load_disklist (self, archive):
        """This method creates the disk list and tries to read the content from 
        the archive file. The optional (command line argument) archive parameter
        specifies the full filename of the disk archive."""
        
        # get archive filename
        if archive != None:
            # archive file specified on command line
            self.archiveName = os.path.abspath (os.path.expanduser (archive))
        else:
            # default archive file
            self.archiveName = os.path.expanduser ("~/.disksearchdb")
            
            # if the file doesn't exists: maybe the user has still the old ".cdsearchdb" file 
            # => try to rename it to ".disksearchdb" (because the name has changed)
            if os.path.exists (self.archiveName) == False:
                oldArchiveName = os.path.expanduser ("~/.cdsearchdb")                        
                if os.path.exists (oldArchiveName):
                    print "Renaming old archive '" + oldArchiveName + "' to '" + self.archiveName + "' ..."
                    try:
                        os.rename (oldArchiveName, self.archiveName)
                    except OSError, args:
                        print "Exception: " + str (args)
                        
        self.diskList = DiskList.DiskList ()
        self.diskList.read_disk_list (self.archiveName)
