#!/usr/bin/perl -w
#
# Convert OpenLDAP schema files into RHDS format with pretty printing
#
# Mike Jackson <mj@sci.fi> 14 June 2005
#
# GPL license
#

use strict;

my @lines = <>;
my @at;
my @oc;
my $at  = 0;
my $oc  = 0;
my $at_string;
my $oc_string;


for (@lines) {

  next if (/^\s*\#/); # skip comments

  if ($at) {
    s/\n//;
    s/ +/ /;
    s/\t/ /;
    $at_string .= $_;

    if ( /\)$/ ) {
      push @at, $at_string;
      $at = 0;
      $at_string = "";
    }
  }

  if ($oc) {
    s/ +/ /;
    s/\t/ /;
    $oc_string .= $_;

    if ( /^\n/ ) {
      $oc_string =~ s/\n//;
      push @oc, $oc_string;
      $oc = 0;
      $oc_string = "";
    }
    $oc_string =~ s/\n//;
  }

  if ( /attribute[t|T]ype/ ) {
    $at  = 1;
    s/\n//;
    s/attribute[t|T]ype/attributeTypes:/;
    $at_string .= $_;
  }

  if ( /object[c|C]lass/ ) {
    $oc  = 1;
    s/\n//;
    s/object[c|C]lass/objectClasses:/;
    $oc_string .= $_;
  }
}

&seperator;
print "dn: cn=schema\n";
&seperator;


for (@at) {

  s/attributeTypes: \(/attributeTypes: \(\n /;

  s/NAME/\n  NAME/;
  s/EQUALITY/\n  EQUALITY/;
  s/SUBSTRING/\n  SUBSTRING/;
  s/DESC/\n  DESC/;
  s/SYNTAX/\n  SYNTAX/;
  s/SUP/\n  SUP/;
  s/SUBSTR/\n  SUBSTR/;
  s/SINGLE-VALUE/\n  SINGLE-VALUE/;

  s/\)$/\n  )/;
  s/ \n/\n/g;

  print "$_\n";
  &seperator;
}

for (@oc) {

  s/objectClasses: \(/objectClasses: \(\n /;

  s/NAME/\n  NAME/;
  s/SUP/\n  SUP/;
  s/AUXILIARY/\n  AUXILIARY/;
  s/STRUCTURAL/\n  STRUCTURAL/;
  s/DESC/\n  DESC/;
  s/MUST/\n  MUST/;
  s/MAY/\n  MAY/;

  s/\)$/\n  )/;
  s/ \n/\n/g;

  print "$_\n";
  &seperator;
}


## subs
sub seperator {
  print "#\n";
  print "#********************************************************************\n";
  print "#\n";
}
