#include "appsupport.h"
#include "appglobals.h"
#include "usergrouplists.h"
#include "prefsdialog.h"
#include "appfunctions.h"

GtkWidget *
create_messagebox_with_message (char *messagetext)
{
  GtkWidget *messagebox;
  GtkWidget *dialog_vbox6;
  GtkWidget *button35;
  GtkWidget *dialog_action_area6;

  messagebox = gnome_message_box_new (messagetext,
				      GNOME_MESSAGE_BOX_INFO, NULL);
  gtk_object_set_data (GTK_OBJECT (messagebox), "messagebox", messagebox);
  gtk_window_set_title (GTK_WINDOW (messagebox), "Information");
  gtk_window_set_modal (GTK_WINDOW (messagebox), TRUE);
  gtk_window_set_policy (GTK_WINDOW (messagebox), FALSE, FALSE, FALSE);

  dialog_vbox6 = GNOME_DIALOG (messagebox)->vbox;
  gtk_object_set_data (GTK_OBJECT (messagebox), "dialog_vbox6", dialog_vbox6);
  gtk_widget_show (dialog_vbox6);

  gnome_dialog_append_button (GNOME_DIALOG (messagebox),
			      GNOME_STOCK_BUTTON_OK);
  button35 = g_list_last (GNOME_DIALOG (messagebox)->buttons)->data;
  gtk_widget_ref (button35);
  gtk_object_set_data_full (GTK_OBJECT (messagebox), "button35", button35,
			    (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button35);
  GTK_WIDGET_SET_FLAGS (button35, GTK_CAN_DEFAULT);

  dialog_action_area6 = GNOME_DIALOG (messagebox)->action_area;
  gtk_widget_ref (dialog_action_area6);
  gtk_object_set_data_full (GTK_OBJECT (messagebox), "dialog_action_area6",
			    dialog_action_area6,
			    (GtkDestroyNotify) gtk_widget_unref);

  return messagebox;
}



void
fill_users_dropdown (GtkWidget * dropdown)
{
  GList *items = get_user_dn_list (current_connection_profile);
  if (items == NULL)
    gtk_widget_show (create_messagebox_with_message
		     ("Your directory has no users"));
  else
    {
      gtk_combo_set_popdown_strings (GTK_COMBO (dropdown), items);
      g_list_foreach (items, (GFunc) g_free, NULL);
      g_list_free (items);
    }
}

void
fill_groups_dropdown (GtkWidget * dropdown)
{
  GList *items = get_group_list (current_connection_profile);
  if (items == NULL)
    gtk_widget_show (create_messagebox_with_message
		     ("Your directory has no groups"));
  else
    {
      gtk_combo_set_popdown_strings (GTK_COMBO (dropdown), items);
      g_list_foreach (items, (GFunc) g_free, NULL);
      g_list_free (items);
    }
}

gchar *
get_lowest_uid (connection_profile * usethisone)
{

  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  LDAP *conn = NULL;
  gchar *treeroot = NULL;
  char **value_collection;
  gchar *lowestuid = NULL;
  int ldap_errors;
  int counter;
  gchar *filter;
  gchar *attributetoreturn[2];
  GList *milista = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print
	("NOT CONNECTED!!!! - returning! (while filling groups dropdown ");
      return NULL;
    }

  conn = connection_profile_get_ldap_handler (usethisone);
  treeroot = connection_profile_get_treeroot (usethisone);

  filter = "(objectClass=posixAccount)";

  attributetoreturn[0] = "uidnumber";
  attributetoreturn[1] = NULL;

  //look data up
  ldap_errors = ldap_search_s (conn,
			       treeroot,
			       LDAP_SCOPE_SUBTREE,
			       filter, attributetoreturn, 0, &results);
  if (ldap_errors)
    g_print ("LDAP error on get_lowest_uid: %s\n",
	     ldap_err2string (ldap_errors));
  else
    {
      g_assert (results);

      entry =
	ldap_first_entry (connection_profile_get_ldap_handler (usethisone),
			  results);
      if (entry)
	{

	  while (entry)
	    {

	      value_collection = ldap_get_values (conn, entry, "uidnumber");
	      g_assert (value_collection);
	      milista =
		g_list_append (milista, g_strdup (value_collection[0]));
	      ldap_value_free (value_collection);
	      entry = ldap_next_entry (conn, entry);
	    }

	  counter = preferences.logindefaults.VUID_MIN;
	  while (lowestuid == NULL)
	    {
	      lowestuid = g_new0 (gchar, 256);
	      g_snprintf (lowestuid, 256, "%d", counter);
	      if (g_list_find_custom
		  (milista, lowestuid, (GCompareFunc) g_strcasecmp) != NULL)
		{
		  g_free (lowestuid);
		  lowestuid = NULL;
		  counter++;
		}
	    }

	  g_list_foreach (milista, (GFunc) g_free, NULL);
	  g_list_free (milista);

	}
      else
	{
	  lowestuid = g_new0 (gchar, 256);
	  g_snprintf (lowestuid, 256, "%d",
		      preferences.logindefaults.VUID_MIN);
	}

      ldap_msgfree (results);
    }
  return (lowestuid);

}

gchar *
get_lowest_gid (connection_profile * usethisone)
{

  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  char **value_collection;
  gchar *lowestuid = NULL;
  int ldap_errors;
  int counter;
  gchar *filter;
  gchar *attributetoreturn[2];
  GList *milista = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print
	("NOT CONNECTED!!!! - returning! (while filling groups dropdown ");
      return NULL;
    }


  filter = "(objectClass=posixGroup)";

  attributetoreturn[0] = "gidnumber";
  attributetoreturn[1] = NULL;

//debug:  g_print(filter);

  //look data up
  ldap_errors =
    ldap_search_s (connection_profile_get_ldap_handler (usethisone),
		   connection_profile_get_treeroot (usethisone),
		   LDAP_SCOPE_SUBTREE, filter, attributetoreturn, 0,
		   &results);
  if (ldap_errors)
    g_print ("LDAP error on get_lowest_gid: %s\n",
	     ldap_err2string (ldap_errors));
  else
    {
      g_assert (results);

      entry =
	ldap_first_entry (connection_profile_get_ldap_handler (usethisone),
			  results);

      if (entry)
	{
	  while (entry)
	    {

	      value_collection =
		ldap_get_values (connection_profile_get_ldap_handler
				 (usethisone), entry, "gidnumber");
	      g_assert (value_collection);
	      milista =
		g_list_append (milista, g_strdup (value_collection[0]));
	      ldap_value_free (value_collection);
	      entry =
		ldap_next_entry (connection_profile_get_ldap_handler
				 (usethisone), entry);
	    }

	  counter = preferences.logindefaults.VGID_MIN;
	  while (lowestuid == NULL)
	    {
	      lowestuid = g_new0 (gchar, 256);
	      g_snprintf (lowestuid, 256, "%d", counter);
	      if (g_list_find_custom
		  (milista, lowestuid, (GCompareFunc) g_strcasecmp) != NULL)
		{
		  g_free (lowestuid);
		  lowestuid = NULL;
		  counter++;
		}
	    }

	  g_list_foreach (milista, (GFunc) g_free, NULL);
	  g_list_free (milista);
	}
      else
	{
	  lowestuid = g_new0 (gchar, 256);
	  g_snprintf (lowestuid, 256, "%d",
		      preferences.logindefaults.VGID_MIN);
	}
      ldap_msgfree (results);

    }
//  g_free(filter);  NOT FREED - STATIC!
  return (lowestuid);

}

GList *
get_user_ou_list (connection_profile * usethisone)
{

  LDAP *connection;
  gchar *treeroot;
  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  char *dn;
  int ldap_errors;
  gchar *filter;
  gchar *attributetoreturn[2];
  GList *milista = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print ("NOT CONNECTED!!!! - returning! (while getting ou list ");
      return (NULL);
    }
  connection = connection_profile_get_ldap_handler (usethisone);
  treeroot = connection_profile_get_treeroot (usethisone);

  filter = "(objectClass=organizationalUnit)";

  attributetoreturn[0] = "ou";
  attributetoreturn[1] = NULL;

  ldap_errors =
    ldap_search_s (connection, treeroot, LDAP_SCOPE_SUBTREE, filter,
		   attributetoreturn, 0, &results);
  if (ldap_errors)
    g_print ("LDAP error on get_ou_list: %s\n",
	     ldap_err2string (ldap_errors));
  else
    {
      g_assert (results);

      entry = ldap_first_entry (connection, results);
      while (entry)
	{
	  dn = ldap_get_dn (connection, entry);
	  g_print (dn);
	  g_assert (dn);
	  milista = g_list_append (milista, g_strdup (dn));
	  g_free (dn);
	  entry = ldap_next_entry (connection, entry);
	}

    }
  ldap_msgfree (results);

  return (milista);

}

GList *
get_group_ou_list (connection_profile * usethisone)
{

  LDAP *connection;
  gchar *treeroot;
  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  char *dn;
  int ldap_errors;
  gchar *filter;
  gchar *attributetoreturn[2];
  GList *milista = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print ("NOT CONNECTED!!!! - returning! (while getting ou list ");
      return (NULL);
    }
  connection = connection_profile_get_ldap_handler (usethisone);
  treeroot = connection_profile_get_treeroot (usethisone);

  filter = "(objectClass=organizationalUnit)";

  attributetoreturn[0] = "ou";
  attributetoreturn[1] = NULL;

  ldap_errors =
    ldap_search_s (connection, treeroot, LDAP_SCOPE_SUBTREE, filter,
		   attributetoreturn, 0, &results);
  if (ldap_errors)
    g_print ("LDAP error on get_ou_list: %s\n",
	     ldap_err2string (ldap_errors));
  else
    {
      g_assert (results);

      entry = ldap_first_entry (connection, results);
      while (entry)
	{
	  dn = ldap_get_dn (connection, entry);
	  g_print (dn);
	  g_assert (dn);
	  milista = g_list_append (milista, g_strdup (dn));
	  g_free (dn);
	  entry = ldap_next_entry (connection, entry);
	}

    }
  ldap_msgfree (results);

  return (milista);

}



GList *
get_group_list (connection_profile * usethisone)
{

  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  LDAP *conn;
  gchar *treeroot;
  char **value_collection;
  int ldap_errors;
  gchar *filter;
  gchar *attributetoreturn[2];
  GList *milista = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print ("\ndisconnected - returning NULL list\n");
      return NULL;
    }

  conn = connection_profile_get_ldap_handler (usethisone);
  treeroot = connection_profile_get_treeroot (usethisone);

  filter = "(objectClass=posixGroup)";

  attributetoreturn[0] = "cn";
  attributetoreturn[1] = NULL;

  //look data up
  ldap_errors = ldap_search_s (conn,
			       treeroot,
			       LDAP_SCOPE_SUBTREE,
			       filter, attributetoreturn, 0, &results);
  if (ldap_errors)
    g_print ("LDAP error on get_group_list: %s\n",
	     ldap_err2string (ldap_errors));
  else
    {
      g_assert (results);

      entry = ldap_first_entry (conn, results);

      if (entry == NULL)
	{
	  //any error?
	  g_print ("\nNo posix groups available for filling the drop-down\n");
	}

      while (entry)
	{

	  value_collection = ldap_get_values (conn, entry, "cn");
	  g_assert (value_collection);
	  milista = g_list_append (milista, g_strdup (value_collection[0]));
	  ldap_value_free (value_collection);
	  entry = ldap_next_entry (conn, entry);
	}

      ldap_msgfree (results);
    }
  return milista;

}


GList *
get_user_list (connection_profile * usethisone)
{

  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  LDAP *conn;
  gchar *treeroot;
  char **value_collection;
  int ldap_errors;
  gchar *filter;
  gchar *attributetoreturn[2];
  GList *milista = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print ("\ndisconnected - returning NULL list\n");
      return NULL;
    }

  conn = connection_profile_get_ldap_handler (usethisone);
  treeroot = connection_profile_get_treeroot (usethisone);

  filter = "(objectClass=posixAccount)";

  attributetoreturn[0] = "uid";
  attributetoreturn[1] = NULL;

  //look data up
  ldap_errors = ldap_search_s (conn,
			       treeroot,
			       LDAP_SCOPE_SUBTREE,
			       filter, attributetoreturn, 0, &results);
  if (ldap_errors)
    g_print ("LDAP error on get_user_list: %s\n",
	     ldap_err2string (ldap_errors));
  else
    {
      g_assert (results);

      entry = ldap_first_entry (conn, results);

      if (entry == NULL)
	{
	  //any error?
	  g_print ("\nNo posix groups available for filling the drop-down\n");
	}

      while (entry)
	{

	  value_collection = ldap_get_values (conn, entry, "uid");
	  g_assert (value_collection);
	  milista = g_list_append (milista, g_strdup (value_collection[0]));
	  ldap_value_free (value_collection);
	  entry = ldap_next_entry (conn, entry);
	}

      ldap_msgfree (results);
    }
  return milista;

}

GList *
get_user_dn_list (connection_profile * usethisone)
{

  LDAPMessage *results = NULL;
  LDAPMessage *entry = NULL;
  LDAP *conn;
  gchar *treeroot;
  int ldap_errors;
  gchar *filter;
  gchar *attributetoreturn[2];
  GList *milista = NULL;

  if (connection_profile_is_connected (usethisone) == FALSE)
    {
      g_print ("\ndisconnected - returning NULL list\n");
      return NULL;
    }

  conn = connection_profile_get_ldap_handler (usethisone);
  treeroot = connection_profile_get_treeroot (usethisone);

  filter = "(objectClass=posixAccount)";

  attributetoreturn[0] = "uid";
  attributetoreturn[1] = NULL;

  //look data up
  ldap_errors = ldap_search_s (conn,
			       treeroot,
			       LDAP_SCOPE_SUBTREE,
			       filter, attributetoreturn, 0, &results);
  if (ldap_errors)
    g_print ("LDAP error on get_user_list: %s\n",
	     ldap_err2string (ldap_errors));
  else
    {
      g_assert (results);

      entry = ldap_first_entry (conn, results);

      if (entry == NULL)
	{
	  //any error?
	  g_print ("\nNo posix groups available for filling the drop-down\n");
	}

      while (entry)
	{

	  milista =
	    g_list_append (milista, g_strdup (ldap_get_dn (conn, entry)));
	  entry = ldap_next_entry (conn, entry);
	}

      ldap_msgfree (results);
    }
  return milista;

}
