/*
    it8705.h - A user-space library to access the it8705 chip.
    Copyright (c) 2006 Andrew Calkin <calkina@geexbox.org>

    Copyright (c) 2005 Richard Taylor <richard@artaylor.co.uk>


    Heavily based on code for accessing/initializing it8712/it8705
    written by
    (C) Copyright 2004 Wojtek Kaniewski <wojtekka@toxygen.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#define I2C_TRANSACTION_DELAY_MS  500


/* lirc_it87.h */
/* SECTION: Definitions */

/********************************* ITE IT87xx ************************/

/* based on the following documentation from ITE:
   a) IT8712F Preliminary CIR Programming Guide V0.1
   b) IT8705F Simple LPC I/O Preliminary Specifiction V0.3
   c) IT8712F EC-LPC I/O Preliminary Specification V0.5
*/

/* IT8712/05 Ports: */
/*
#define IT87_ADRPORT              0x2e
#define IT87_DATAPORT             0x2f
*/
#define IT87_INIT                 0x87, 0x01, 0x55, 0x55

/* alternate Ports: */
/*
#define IT87_ADRPORT              0x4e
#define IT87_DATAPORT             0x4f
#define IT87_INIT                 0x87, 0x01, 0x55, 0xaa
 */
/* MoBo Temp */
/*#define IT8705_TEMP_REG 0x28 */

#define IT8705_ACCESS_REG         0x2e
#define IT8705_RETURN_REG         0x2f
#define IT8705_CFG_CTRL           0x2

#define IT8705_EC_ACCESS_REG      0x295
#define IT8705_EC_RETURN_REG      0x296
#define IT8705_TEMP_REG1          0x29
#define IT8705_TEMP_REG2          0x2b
#define FAN1                      0x15
#define FAN2                      0x16
#define FAN3                      0x17

#define PME_ENABLE                0xf0
#define BASE_ADDR                 0x20
#define CHAR_MARK                 0xff
#define PME_INDX_REG              0xf5
#define PME_DATA_REG              0xf6

/* IT8712/05 Registers */
#define IT87_CHIP_ID1             0x20
#define IT87_CHIP_ID2             0x21
#define IT87_CFG_VERSION          0x22
#define IT87_SWSUSPEND            0x23

/*
#define IT8712_CIR_LDN            0xa
*/
#define IT8705_CIR_LDN            0x7
#define IT8705_PME_LDN            0x4
#define IT8705_EC_LDN             0x4

/* CIR Configuration Registers: */
#define IT87_CIR_ACT              0x30
#define IT87_CIR_BASE_MSB         0x60
#define IT87_CIR_BASE_LSB         0x61
#define IT87_CIR_IRQ              0x70
#define IT87_CIR_CONFIG           0xf0

/* List of IT87_CIR registers: offset to BaseAddr */
#define IT87_CIR_DR               0
#define IT87_CIR_IER              1
#define IT87_CIR_RCR              2
#define IT87_CIR_TCR1             3
#define IT87_CIR_TCR2             4
#define IT87_CIR_TSR              5
#define IT87_CIR_RSR              6
#define IT87_CIR_BDLR             5
#define IT87_CIR_BDHR             6
#define IT87_CIR_IIR              7

/* Bit Definitionen */
/* IER: */
#define IT87_CIR_IER_TM_EN        0x80
#define IT87_CIR_IER_RESEVED      0x40
#define IT87_CIR_IER_RESET        0x20
#define IT87_CIR_IER_BR           0x10
#define IT87_CIR_IER_IEC          0x8
#define IT87_CIR_IER_RFOIE        0x4
#define IT87_CIR_IER_RDAIE        0x2
#define IT87_CIR_IER_TLDLIE       0x1

/* RCR: */
#define IT87_CIR_RCR_RDWOS        0x80
#define IT87_CIR_RCR_HCFS         0x40
#define IT87_CIR_RCR_RXEN         0x20
#define IT87_CIR_RCR_RXEND        0x10
#define IT87_CIR_RCR_RXACT        0x8
#define IT87_CIR_RCR_RXDCR        0x7

/* TCR1: */
#define IT87_CIR_TCR1_FIFOCLR     0x80
#define IT87_CIR_TCR1_ILE         0x40
#define IT87_CIR_TCR1_FIFOTL      0x30
#define IT87_CIR_TCR1_TXRLE       0x8
#define IT87_CIR_TCR1_TXENDF      0x4
#define IT87_CIR_TCR1_TXMPM       0x3

/* TCR2: */
#define IT87_CIR_TCR2_CFQ         0xf8
#define IT87_CIR_TCR2_TXMPW       0x7

/* TSR: */
#define IT87_CIR_TSR_RESERVED     0xc0
#define IT87_CIR_TSR_TXFBC        0x3f

/* RSR: */
#define IT87_CIR_RSR_RXFTO        0x80
#define IT87_CIR_RSR_RESERVED     0x40
#define IT87_CIR_RSR_RXFBC        0x3f

/* IIR: */
#define IT87_CIR_IIR_RESERVED     0xf8
#define IT87_CIR_IIR_IID          0x6
#define IT87_CIR_IIR_IIP          0x1

/* TM: */
#define IT87_CIR_TM_IL_SEL        0x80
#define IT87_CIR_TM_RESERVED      0x40
#define IT87_CIR_TM_TM_REG        0x3f

#define IT87_CIR_FIFO_SIZE        32

/* Baudratedivisor for IT87: power of 2: only 1,2,4 or 8) */
#define IT87_CIR_BAUDRATE_DIVISOR 0x1
#define IT87_CIR_DEFAULT_IOBASE   0x310
#define IT87_CIR_DEFAULT_IRQ      0x7
#define IT87_CIR_SPACE            0x00
#define IT87_CIR_PULSE            0xff
#define IT87_CIR_FREQ_MIN         27
#define IT87_CIR_FREQ_MAX         58
#define TIME_CONST (IT87_CIR_BAUDRATE_DIVISOR * 8000000ul / 115200ul)

/********************************* ITE IT87xx ************************/



unsigned char it87_read_byte(unsigned char addr);
unsigned char it87_read_ec_byte(unsigned char addr);
int it87_write_byte (unsigned char addr, unsigned char data);
int it87_write_ec_byte (unsigned char addr, unsigned char data);
int it87_ec_port_open(void);
void it87_ec_port_close(void);
int it87_open(void);
void it87_close(void);
char it87_get_temp(void);
int it87_write_ec_byte (unsigned char addr, unsigned char data);
void it87_ldn_set(unsigned char ldn);
unsigned char it87_read_cir_byte(unsigned char addr);
int it87_write_cir_byte (unsigned char addr, unsigned char data);
int it87_cir_port_open(void);
void it87_cir_port_close(void);

