/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void pro_inicializar(void)
{
	gint cont1,cont2;
	
	proyecto.xml=NULL;
	proyecto.xml_viejo=NULL;
	proyecto.archivo=NULL;
	pro_proyecto_cargar=NULL;
	
	for (cont1=0;cont1<LTOTALES;cont1++) {
		for (cont2=0;cont2<LTOTALES;cont2++) {
			pro_dependencias_librerias[cont1][cont2]=FALSE;
		}
	}
	
	//dependencias de gtk
	pro_dependencias_librerias[LGTK2][LGTK_X112]=TRUE;
	pro_dependencias_librerias[LGTK2][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LGTK2][LATK]=TRUE;
	pro_dependencias_librerias[LGTK2][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LGTK2][LPANGOX]=TRUE;
	pro_dependencias_librerias[LGTK2][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LGTK2][LPANGO]=TRUE;
	pro_dependencias_librerias[LGTK2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGTK2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGTK2][LGLIB2]=TRUE;

	//dependencias de gobject
	pro_dependencias_librerias[LGOBJECT2][LGLIB2]=TRUE;

	//dependencias de glib

	//dependencias de gmodule
	pro_dependencias_librerias[LGMODULE2][LGLIB2]=TRUE;

	//dependencias de gthread
	pro_dependencias_librerias[LGTK2][LGLIB2]=TRUE;
	
	//dependencias de x11
	
	//dependencias de gettext
	
	//dependencias de esd
	pro_dependencias_librerias[LESD][LAUDIOFILE]=TRUE;
	
	//dependencias de audiofile
	
	//dependencias de xml
	
	//dependencias de gnome
	pro_dependencias_librerias[LGNOME2][LBONOBO2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LGCONF2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LGNOME_VFS2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LXML2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGNOME2][LLINC]=TRUE;
	
	//dependencias de gnomeui
	pro_dependencias_librerias[LGNOMEUI2][LX11]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LBONOBOUI2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGNOME2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LLIBART2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LPANGOFT2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGTK_X112]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LATK]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LPANGOX]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LPANGO]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LBONOBO2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGCONF2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGNOME_VFS2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LXML2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGNOMECANVAS2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGNOMEUI2][LLINC]=TRUE;
	
	//dependencias de bonobo
	pro_dependencias_librerias[LBONOBO2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LBONOBO2][LXML2]=TRUE;
	pro_dependencias_librerias[LBONOBO2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LBONOBO2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LBONOBO2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LBONOBO2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LBONOBO2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LBONOBO2][LLINC]=TRUE;
	
	//dependencias de bonoboui
	pro_dependencias_librerias[LBONOBOUI2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGNOME2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LPANGO]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LPANGOFT2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGNOME_VFS2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LLINC]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LXML2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LATK]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGCONF2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGNOMECANVAS2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LLIBART2]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LGTK_X112]=TRUE;
	pro_dependencias_librerias[LBONOBOUI2][LPANGOX]=TRUE;
	
	//dependencias de bonobo_activation
	pro_dependencias_librerias[LBONOBO_ACTIVATION2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LBONOBO_ACTIVATION2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LBONOBO_ACTIVATION2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LBONOBO_ACTIVATION2][LXML2]=TRUE;
	pro_dependencias_librerias[LBONOBO_ACTIVATION2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LBONOBO_ACTIVATION2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LBONOBO_ACTIVATION2][LLINC]=TRUE;
	
	//dependencias de gnomeprint
	pro_dependencias_librerias[LGNOMEPRINT2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LXML2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LBONOBO2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LPANGO]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LLINC]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LLIBART2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINT2][LLIBGLADE2]=TRUE;
	
	//dependencias de gnomeprintui
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LXML2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LBONOBO2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGNOMEPRINT2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LPANGO]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LPANGOFT2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LLINC]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LATK]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGNOMECANVAS2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LLIBART2]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LGTK_X112]=TRUE;
	pro_dependencias_librerias[LGNOMEPRINTUI2][LPANGOX]=TRUE;
	
	//dependencias de gnome_mime_data
	
	//dependencias de pango
	pro_dependencias_librerias[LPANGO][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LPANGO][LGLIB2]=TRUE;
	pro_dependencias_librerias[LPANGO][LGMODULE2]=TRUE;
	
	//dependencias de pangoxft
	pro_dependencias_librerias[LPANGOXFT][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LPANGOXFT][LGLIB2]=TRUE;
	pro_dependencias_librerias[LPANGOXFT][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LPANGOXFT][LPANGO]=TRUE;
	
	//dependencias de pangoft
	pro_dependencias_librerias[LPANGOFT2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LPANGOFT2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LPANGOFT2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LPANGOFT2][LPANGO]=TRUE;
	
	//dependencias de gnome_vfs
	pro_dependencias_librerias[LGNOME_VFS2][LXML2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS2][LLINC]=TRUE;
	
	//dependencias de gnome_vfs_module
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LXML2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LBONOBO_ACTIVATION2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LGNOME_VFS2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LGNOME_VFS_MODULE2][LLINC]=TRUE;
	
	//dependencias de orbit
	pro_dependencias_librerias[LORBIT2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LORBIT2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LORBIT2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LORBIT2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LORBIT2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LORBIT2][LLINC]=TRUE;
	
	//dependencias de orbit_cosnaming
	pro_dependencias_librerias[LORBIT_COSNAMING2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LORBIT_COSNAMING2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LORBIT_COSNAMING2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LORBIT_COSNAMING2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LORBIT_COSNAMING2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LORBIT_COSNAMING2][LLINC]=TRUE;
	
	//dependencias de linc
	pro_dependencias_librerias[LLINC][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LLINC][LGLIB2]=TRUE;
	pro_dependencias_librerias[LLINC][LGTHREAD2]=TRUE;
	
	//dependencias de gdk
	pro_dependencias_librerias[LGDK2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGDK2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGDK2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGDK2][LPANGO]=TRUE;
	pro_dependencias_librerias[LGDK2][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LGDK2][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LGDK2][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LGDK2][LPANGOX]=TRUE;
	
	//dependencias de gdk_x11
	pro_dependencias_librerias[LGDK_X112][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGDK_X112][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGDK_X112][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGDK_X112][LPANGO]=TRUE;
	pro_dependencias_librerias[LGDK_X112][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LGDK_X112][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LGDK_X112][LPANGOX]=TRUE;
	
	//dependencias de gdk_pixbuf
	pro_dependencias_librerias[LGDK_PIXBUF2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGDK_PIXBUF2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGDK_PIXBUF2][LGMODULE2]=TRUE;
	
	//dependencias de gdk_pixbuf_xlib
	pro_dependencias_librerias[LGDK_PIXBUF_XLIB2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGDK_PIXBUF_XLIB2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGDK_PIXBUF_XLIB2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGDK_PIXBUF_XLIB2][LGDK_PIXBUF2]=TRUE;
	
	//dependencias de atk
	pro_dependencias_librerias[LATK][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LATK][LGLIB2]=TRUE;
	pro_dependencias_librerias[LATK][LGMODULE2]=TRUE;
	
	//dependencias de gconf
	pro_dependencias_librerias[LGCONF2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGCONF2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGCONF2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGCONF2][LGTHREAD2]=TRUE;
	pro_dependencias_librerias[LGCONF2][LORBIT2]=TRUE;
	pro_dependencias_librerias[LGCONF2][LLINC]=TRUE;
	
	//dependencias de gnomecanvas
	pro_dependencias_librerias[LGNOMECANVAS2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LPANGO]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LATK]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LLIBART2]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LGTK_X112]=TRUE;
	pro_dependencias_librerias[LGNOMECANVAS2][LPANGOX]=TRUE;
	
	//dependencias de libart
	
	//dependencias de libglade
	pro_dependencias_librerias[LLIBGLADE2][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LGLIB2]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LXML2]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LPANGO]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LATK]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LGTK_X112]=TRUE;
	pro_dependencias_librerias[LLIBGLADE2][LPANGOX]=TRUE;
	
	//dependencias de gtk_x11
	pro_dependencias_librerias[LGTK_X112][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LGLIB2]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LPANGO]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LPANGOXFT]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LGDK_X112]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LGDK_PIXBUF2]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LATK]=TRUE;
	pro_dependencias_librerias[LGTK_X112][LPANGOX]=TRUE;
	
	//dependencias de imlib
	pro_dependencias_librerias[LIMLIB][LX11]=TRUE;
	
	//dependencias de imlibgdk
	pro_dependencias_librerias[LIMLIBGDK][LGLIB2]=TRUE;
	pro_dependencias_librerias[LIMLIBGDK][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LIMLIBGDK][LX11]=TRUE;
	
	//dependencias de pangox
	pro_dependencias_librerias[LPANGOX][LGOBJECT2]=TRUE;
	pro_dependencias_librerias[LPANGOX][LGLIB2]=TRUE;
	pro_dependencias_librerias[LPANGOX][LGMODULE2]=TRUE;
	pro_dependencias_librerias[LPANGOX][LPANGO]=TRUE;

	pro_nombre_botones_librerias[LGTK2]=g_strdup("gtk2_libs_boton");
	pro_nombre_botones_librerias[LGOBJECT2]=g_strdup("gobject2_libs_boton");
	pro_nombre_botones_librerias[LGLIB2]=g_strdup("glib2_libs_boton");
	pro_nombre_botones_librerias[LGMODULE2]=g_strdup("gmodule2_libs_boton");
	pro_nombre_botones_librerias[LGTHREAD2]=g_strdup("gthread2_libs_boton");
	pro_nombre_botones_librerias[LX11]=g_strdup("x11_libs_boton");
	pro_nombre_botones_librerias[LGETTEXT]=g_strdup("gettext_libs_boton");
	pro_nombre_botones_librerias[LESD]=g_strdup("esd_libs_boton");
	pro_nombre_botones_librerias[LAUDIOFILE]=g_strdup("audiofile_libs_boton");
	pro_nombre_botones_librerias[LXML2]=g_strdup("xml2_libs_boton");
	pro_nombre_botones_librerias[LGNOME2]=g_strdup("gnome2_libs_boton");
	pro_nombre_botones_librerias[LGNOMEUI2]=g_strdup("gnomeui2_libs_boton");
	pro_nombre_botones_librerias[LBONOBO2]=g_strdup("bonobo2_libs_boton");
	pro_nombre_botones_librerias[LBONOBOUI2]=g_strdup("bonoboui2_libs_boton");
	pro_nombre_botones_librerias[LBONOBO_ACTIVATION2]=g_strdup("bonobo_activation2_libs_boton");
	pro_nombre_botones_librerias[LGNOMEPRINT2]=g_strdup("gnomeprint2_libs_boton");
	pro_nombre_botones_librerias[LGNOMEPRINTUI2]=g_strdup("gnomeprintui2_libs_boton");
	pro_nombre_botones_librerias[LGNOME_MIME_DATA2]=g_strdup("gnome_mime_data2_libs_boton");
	pro_nombre_botones_librerias[LPANGO]=g_strdup("pango_libs_boton");
	pro_nombre_botones_librerias[LPANGOXFT]=g_strdup("pangoxft_libs_boton");
	pro_nombre_botones_librerias[LPANGOFT2]=g_strdup("pangoft2_libs_boton");
	pro_nombre_botones_librerias[LGNOME_VFS2]=g_strdup("gnome_vfs2_libs_boton");
	pro_nombre_botones_librerias[LGNOME_VFS_MODULE2]=g_strdup("gnome_vfs_module2_libs_boton");
	pro_nombre_botones_librerias[LORBIT2]=g_strdup("orbit2_libs_boton");
	pro_nombre_botones_librerias[LORBIT_COSNAMING2]=g_strdup("orbit_cosnaming2_libs_boton");
	pro_nombre_botones_librerias[LLINC]=g_strdup("linc_libs_boton");
	pro_nombre_botones_librerias[LGDK2]=g_strdup("gdk2_libs_boton");
	pro_nombre_botones_librerias[LGDK_X112]=g_strdup("gdk_x11_2_libs_boton");
	pro_nombre_botones_librerias[LGDK_PIXBUF2]=g_strdup("gdk_pixbuf2_libs_boton");
	pro_nombre_botones_librerias[LGDK_PIXBUF_XLIB2]=g_strdup("gdk_pixbuf_xlib2_libs_boton");
	pro_nombre_botones_librerias[LATK]=g_strdup("atk_libs_boton");
	pro_nombre_botones_librerias[LGCONF2]=g_strdup("gconf2_libs_boton");
	pro_nombre_botones_librerias[LGNOMECANVAS2]=g_strdup("gnomecanvas2_libs_boton");
	pro_nombre_botones_librerias[LLIBART2]=g_strdup("libart2_libs_boton");
	pro_nombre_botones_librerias[LLIBGLADE2]=g_strdup("libglade2_libs_boton");
	pro_nombre_botones_librerias[LGTK_X112]=g_strdup("gtk_x11_2_libs_boton");
	pro_nombre_botones_librerias[LIMLIB]=g_strdup("imlib_libs_boton");
	pro_nombre_botones_librerias[LIMLIBGDK]=g_strdup("imlibgdk_libs_boton");
	pro_nombre_botones_librerias[LPANGOX]=g_strdup("pangox_libs_boton");

	pro_nombre_librerias[LGTK2]=g_strdup("gtk+-2.0");
	pro_nombre_librerias[LGOBJECT2]=g_strdup("gobject-2.0");
	pro_nombre_librerias[LGLIB2]=g_strdup("glib-2.0");
	pro_nombre_librerias[LGMODULE2]=g_strdup("gmodule-2.0");
	pro_nombre_librerias[LGTHREAD2]=g_strdup("gthread-2.0");
	pro_nombre_librerias[LX11]=g_strdup("");
	pro_nombre_librerias[LGETTEXT]=g_strdup("");
	pro_nombre_librerias[LESD]=g_strdup("esound");
	pro_nombre_librerias[LAUDIOFILE]=g_strdup("audiofile");
	pro_nombre_librerias[LXML2]=g_strdup("libxml-2.0");
	pro_nombre_librerias[LGNOME2]=g_strdup("libgnome-2.0");
	pro_nombre_librerias[LGNOMEUI2]=g_strdup("libgnomeui-2.0");
	pro_nombre_librerias[LBONOBO2]=g_strdup("libbonobo-2.0");
	pro_nombre_librerias[LBONOBOUI2]=g_strdup("libbonoboui-2.0");
	pro_nombre_librerias[LBONOBO_ACTIVATION2]=g_strdup("bonobo-activation-2.0");
	pro_nombre_librerias[LGNOMEPRINT2]=g_strdup("libgnomeprint-2.0");
	pro_nombre_librerias[LGNOMEPRINTUI2]=g_strdup("libgnomeprintui-2.0");
	pro_nombre_librerias[LGNOME_MIME_DATA2]=g_strdup("gnome-mime-data-2.0");
	pro_nombre_librerias[LPANGO]=g_strdup("pango");
	pro_nombre_librerias[LPANGOXFT]=g_strdup("pangoxft");
	pro_nombre_librerias[LPANGOFT2]=g_strdup("pangoft2");
	pro_nombre_librerias[LGNOME_VFS2]=g_strdup("gnome-vfs-2.0");
	pro_nombre_librerias[LGNOME_VFS_MODULE2]=g_strdup("gnome-vfs-module-2.0");
	pro_nombre_librerias[LORBIT2]=g_strdup("ORBit-2.0");
	pro_nombre_librerias[LORBIT_COSNAMING2]=g_strdup("ORBit-CosNaming-2.0");
	pro_nombre_librerias[LLINC]=g_strdup("linc");
	pro_nombre_librerias[LGDK2]=g_strdup("gdk-2.0");
	pro_nombre_librerias[LGDK_X112]=g_strdup("gdk-x11-2.0");
	pro_nombre_librerias[LGDK_PIXBUF2]=g_strdup("gdk-pixbuf-2.0");
	pro_nombre_librerias[LGDK_PIXBUF_XLIB2]=g_strdup("gdk-pixbuf-xlib-2.0");
	pro_nombre_librerias[LATK]=g_strdup("atk");
	pro_nombre_librerias[LGCONF2]=g_strdup("gconf-2.0");
	pro_nombre_librerias[LGNOMECANVAS2]=g_strdup("libgnomecanvas-2.0");
	pro_nombre_librerias[LLIBART2]=g_strdup("libart-2.0");
	pro_nombre_librerias[LLIBGLADE2]=g_strdup("libglade-2.0");
	pro_nombre_librerias[LGTK_X112]=g_strdup("gtk+-x11-2.0");
	pro_nombre_librerias[LIMLIB]=g_strdup("imlib");
	pro_nombre_librerias[LIMLIBGDK]=g_strdup("imlibgdk");
	pro_nombre_librerias[LPANGOX]=g_strdup("pangox");

	pro_nombre_librerias_autoconf[LGTK2]=g_strdup("GTK2");
	pro_nombre_librerias_autoconf[LGOBJECT2]=g_strdup("GOBJECT2");
	pro_nombre_librerias_autoconf[LGLIB2]=g_strdup("GLIB2");
	pro_nombre_librerias_autoconf[LGMODULE2]=g_strdup("GMODULE2");
	pro_nombre_librerias_autoconf[LGTHREAD2]=g_strdup("GTHREAD2");
	pro_nombre_librerias_autoconf[LX11]=g_strdup("X11");
	pro_nombre_librerias_autoconf[LGETTEXT]=NULL;
	pro_nombre_librerias_autoconf[LESD]=g_strdup("ESD");
	pro_nombre_librerias_autoconf[LAUDIOFILE]=g_strdup("AUDIOFILE");
	pro_nombre_librerias_autoconf[LXML2]=g_strdup("XML2");
	pro_nombre_librerias_autoconf[LGNOME2]=g_strdup("GNOME2");
	pro_nombre_librerias_autoconf[LGNOMEUI2]=g_strdup("GNOMEUI2");
	pro_nombre_librerias_autoconf[LBONOBO2]=g_strdup("BONOBO2");
	pro_nombre_librerias_autoconf[LBONOBOUI2]=g_strdup("BONOBOUI2");
	pro_nombre_librerias_autoconf[LBONOBO_ACTIVATION2]=g_strdup("BONOBO_ACTIVATION2");
	pro_nombre_librerias_autoconf[LGNOMEPRINT2]=g_strdup("GNOMEPRINT2");
	pro_nombre_librerias_autoconf[LGNOMEPRINTUI2]=g_strdup("GNOMEPRINTUI2");
	pro_nombre_librerias_autoconf[LGNOME_MIME_DATA2]=g_strdup("GNOME_MIME_DATA2");
	pro_nombre_librerias_autoconf[LPANGO]=g_strdup("PANGO");
	pro_nombre_librerias_autoconf[LPANGOXFT]=g_strdup("PANGOXFT");
	pro_nombre_librerias_autoconf[LPANGOFT2]=g_strdup("PANGOFT2");
	pro_nombre_librerias_autoconf[LGNOME_VFS2]=g_strdup("GNOME_VFS2");
	pro_nombre_librerias_autoconf[LGNOME_VFS_MODULE2]=g_strdup("GNOME_VFS_MODULE2");
	pro_nombre_librerias_autoconf[LORBIT2]=g_strdup("ORBIT2");
	pro_nombre_librerias_autoconf[LORBIT_COSNAMING2]=g_strdup("ORBIT_COSNAMING2");
	pro_nombre_librerias_autoconf[LLINC]=g_strdup("LINC");
	pro_nombre_librerias_autoconf[LGDK2]=g_strdup("GDK2");
	pro_nombre_librerias_autoconf[LGDK_X112]=g_strdup("GDK_X112");
	pro_nombre_librerias_autoconf[LGDK_PIXBUF2]=g_strdup("GDK_PIXBUF2");
	pro_nombre_librerias_autoconf[LGDK_PIXBUF_XLIB2]=g_strdup("GDK_PIXBUF_XLIB2");
	pro_nombre_librerias_autoconf[LATK]=g_strdup("ATK");
	pro_nombre_librerias_autoconf[LGCONF2]=g_strdup("GCONF2");
	pro_nombre_librerias_autoconf[LGNOMECANVAS2]=g_strdup("GNOMECANVAS2");
	pro_nombre_librerias_autoconf[LLIBART2]=g_strdup("LIBART2");
	pro_nombre_librerias_autoconf[LLIBGLADE2]=g_strdup("LIBGLADE2");
	pro_nombre_librerias_autoconf[LGTK_X112]=g_strdup("GTK_X112");
	pro_nombre_librerias_autoconf[LIMLIB]=g_strdup("IMLIB");
	pro_nombre_librerias_autoconf[LIMLIBGDK]=g_strdup("IMLIBGDK");
	pro_nombre_librerias_autoconf[LPANGOX]=g_strdup("PANGOX");

	pro_nombre_librerias_xml[LGTK2]=g_strdup("gtk2");
	pro_nombre_librerias_xml[LGOBJECT2]=g_strdup("gobject2");
	pro_nombre_librerias_xml[LGLIB2]=g_strdup("glib2");
	pro_nombre_librerias_xml[LGMODULE2]=g_strdup("gmodule2");
	pro_nombre_librerias_xml[LGTHREAD2]=g_strdup("gthread2");
	pro_nombre_librerias_xml[LX11]=g_strdup("x11");
	pro_nombre_librerias_xml[LGETTEXT]=g_strdup("gettext");
	pro_nombre_librerias_xml[LESD]=g_strdup("esd");
	pro_nombre_librerias_xml[LAUDIOFILE]=g_strdup("audiofile");
	pro_nombre_librerias_xml[LXML2]=g_strdup("xml2");
	pro_nombre_librerias_xml[LGNOME2]=g_strdup("gnome2");
	pro_nombre_librerias_xml[LGNOMEUI2]=g_strdup("gnomeui2");
	pro_nombre_librerias_xml[LBONOBO2]=g_strdup("bonobo2");
	pro_nombre_librerias_xml[LBONOBOUI2]=g_strdup("bonoboui2");
	pro_nombre_librerias_xml[LBONOBO_ACTIVATION2]=g_strdup("bonobo_activation2");
	pro_nombre_librerias_xml[LGNOMEPRINT2]=g_strdup("gnomeprint2");
	pro_nombre_librerias_xml[LGNOMEPRINTUI2]=g_strdup("gnomeprintui2");
	pro_nombre_librerias_xml[LGNOME_MIME_DATA2]=g_strdup("gnome_mime_data2");
	pro_nombre_librerias_xml[LPANGO]=g_strdup("pango");
	pro_nombre_librerias_xml[LPANGOXFT]=g_strdup("pangoxft");
	pro_nombre_librerias_xml[LPANGOFT2]=g_strdup("pangoft2");
	pro_nombre_librerias_xml[LGNOME_VFS2]=g_strdup("gnome_vfs2");
	pro_nombre_librerias_xml[LGNOME_VFS_MODULE2]=g_strdup("gnome_vfs_module2");
	pro_nombre_librerias_xml[LORBIT2]=g_strdup("orbit2");
	pro_nombre_librerias_xml[LORBIT_COSNAMING2]=g_strdup("orbit_cosnaming2");
	pro_nombre_librerias_xml[LLINC]=g_strdup("linc");
	pro_nombre_librerias_xml[LGDK2]=g_strdup("gdk2");
	pro_nombre_librerias_xml[LGDK_X112]=g_strdup("gdk_x112");
	pro_nombre_librerias_xml[LGDK_PIXBUF2]=g_strdup("gdk_pixbuf2");
	pro_nombre_librerias_xml[LGDK_PIXBUF_XLIB2]=g_strdup("gdk_pixbuf_xlib2");
	pro_nombre_librerias_xml[LATK]=g_strdup("atk");
	pro_nombre_librerias_xml[LGCONF2]=g_strdup("gconf2");
	pro_nombre_librerias_xml[LGNOMECANVAS2]=g_strdup("gnomecanvas2");
	pro_nombre_librerias_xml[LLIBART2]=g_strdup("libart2");
	pro_nombre_librerias_xml[LLIBGLADE2]=g_strdup("libglade2");
	pro_nombre_librerias_xml[LGTK_X112]=g_strdup("gtk_x11");
	pro_nombre_librerias_xml[LIMLIB]=g_strdup("imlib");
	pro_nombre_librerias_xml[LIMLIBGDK]=g_strdup("imlibgdk");
	pro_nombre_librerias_xml[LPANGOX]=g_strdup("pangox");

}

void pro_crear(void)
{
	xmlNodePtr xmlnode;
	gint cont;

	DEBUG_MSG(->pro_crear);
	proyecto.xml=xmlNewDoc("1.0");
	xmlnode=xmlNewNode(NULL,"Proyecto_DiaSCE");
	(proyecto.xml)->xmlRootNode=xmlnode;
	xmlNewProp(xmlnode,"version",VERSION_PROYECTO);
	
	xmlNewChild(xmlnode,NULL,"general",NULL);
	xmlNewChild(xmlnode,NULL,"archivos",NULL);
	xmlNewChild(xmlnode,NULL,"librerias",NULL);
	xmlNewChild(xmlnode,NULL,"gettext",NULL);
	xmlNewChild(xmlnode,NULL,"avisos",NULL);
	xmlNewChild(xmlnode,NULL,"compilar",NULL);
	xmlNewChild(xmlnode,NULL,"cvs",NULL);
	xmlNewChild(xmlnode,NULL,"fuentes",NULL);
	xmlNewChild(xmlnode,NULL,"cabeceras",NULL);
	xmlNewChild(xmlnode,NULL,"otros",NULL);
	
	//propiedades de general
	xmlnode=xmlnode->xmlChildrenNode;
	xmlNewProp(xmlnode,"nombre","");
	xmlNewProp(xmlnode,"version","0.1");
	xmlNewProp(xmlnode,"autor",preferencias.nombre);
	xmlNewProp(xmlnode,"e-mail",preferencias.e_mail);
	xmlNewProp(xmlnode,"lenguaje","0");	// 0=C, 1=C++
	
	//propiedades de archivos
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"nombre","");
	xmlNewProp(xmlnode,"proyecto",preferencias.directorio);
	xmlNewProp(xmlnode,"fuentes","src/");
	xmlNewProp(xmlnode,"pixmaps","pixmaps/");
	xmlNewProp(xmlnode,"datos","data/");
	xmlNewProp(xmlnode,"documentacion","docs/");
	xmlNewProp(xmlnode,"glade","0");
	xmlNewProp(xmlnode,"glade_file","");
	xmlNewProp(xmlnode,"crear_h","1");
	xmlNewProp(xmlnode,"cabecera","1");
	xmlNewProp(xmlnode,"defines","0");
	
	//propiedades de librerias
	xmlnode=xmlnode->next;
	for (cont=0;cont<LTOTALES;cont++) {
		xmlNewProp(xmlnode,pro_nombre_librerias_xml[cont],"0");
	}
	xmlNewChild(xmlnode,NULL,"otras",NULL);
	xmlNewChild(xmlnode,NULL,"path",NULL);
	xmlNewChild(xmlnode,NULL,"includes",NULL);
	xmlnode=xmlnode->xmlChildrenNode;
	xmlNodeSetContent(xmlnode,"");
	xmlnode=xmlnode->next;
	xmlNodeSetContent(xmlnode,"");
	xmlnode=xmlnode->next;
	xmlNodeSetContent(xmlnode,"");
	xmlnode=xmlnode->parent;

	//propiedades de gettext
	xmlnode=xmlnode->next;
	
	//propiedades de avisos
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"w00","1");
	xmlNewProp(xmlnode,"w01","0");
	xmlNewProp(xmlnode,"w02","0");
	xmlNewProp(xmlnode,"w03","0");
	xmlNewProp(xmlnode,"w04","0");
	xmlNewProp(xmlnode,"w05","0");
	xmlNewProp(xmlnode,"w06","0");
	xmlNewProp(xmlnode,"w07","0");
	xmlNewProp(xmlnode,"w08","0");
	xmlNewProp(xmlnode,"w09","0");
	xmlNewProp(xmlnode,"w10","0");
	xmlNewProp(xmlnode,"w11","0");
	xmlNewProp(xmlnode,"w12","0");
	xmlNewProp(xmlnode,"w13","0");
	xmlNewProp(xmlnode,"w14","0");
	xmlNewProp(xmlnode,"w15","0");
	xmlNewProp(xmlnode,"w16","0");
	xmlNewProp(xmlnode,"w17","0");
	xmlNewProp(xmlnode,"w18","0");
	xmlNewProp(xmlnode,"w19","0");
	xmlNewProp(xmlnode,"w20","0");
	xmlNewProp(xmlnode,"w21","0");
	
	//propiedades de compilar
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"optimizacion","0");
	xmlNewProp(xmlnode,"depuracion","2");
	xmlNewProp(xmlnode,"electric_fence","0");
	xmlNodeSetContent(xmlnode,"");

	//propiedades de CVS
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"activo","0");
	xmlNewProp(xmlnode,"compresion","5");
	xmlNewProp(xmlnode,"autoupdate","0");
	xmlNewProp(xmlnode,"autoaddremove","0");
	xmlNewChild(xmlnode,NULL,"cvsroot",NULL);
	xmlNewChild(xmlnode,NULL,"modul",NULL);
	
	autoconfiguracion=autoconfiguracion | AUTO_CONF | AUTO_MAKE | ACLOCAL | AUTO_HEADER | CONFIGURE;

	DEBUG_MSG(<-pro_crear);
}

void pro_actualizar(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;
	gchar *nombre_proyecto;
	gchar *carpeta_proyecto;
	gchar *carpeta_fuentes;
	gchar *carpeta_pixmaps;
	gchar *carpeta_datos;
	gchar *carpeta_documentacion;
	gint nivel;
	guint cont;
	gchar *directorio;
	gchar *glade_file;

	DEBUG_MSG(->pro_actualizar);
	widget=gtk_widget_get_toplevel(widget);
	xmlnode=(proyecto.xml)->xmlRootNode->xmlChildrenNode;
	
	//propiedades generales
	fuente=glade_xml_get_widget(proyecto_ventana,"nombre_entrada_project");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	nombre_proyecto=texto;
	xmlSetProp(xmlnode,"nombre",texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"version_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"version",texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"autor_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"autor",texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"email_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"e-mail",texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"c_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"lenguaje","0");
	} else {
		xmlSetProp(xmlnode,"lenguaje","1");
	}
	
	//propiedades archivos
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"ejecutable_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		xmlSetProp(xmlnode,"nombre",nombre_proyecto);
	} else {
		xmlSetProp(xmlnode,"nombre",texto);
	}
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"proyecto_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		directorio=g_strdup(preferencias.directorio);
	} else {
		for (cont=0;texto[cont]!=0;cont++);
		if (texto[cont-1]!='/') {
			directorio=g_strdup_printf("%s/",texto);
		} else {
			directorio=g_strdup(texto);
		}
	}
	xmlSetProp(xmlnode,"proyecto",directorio);
	carpeta_proyecto=g_strdup(directorio);
	g_free(directorio);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"fuentes_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	for (cont=0;texto[cont]!=0;cont++);
	if ((cont!=0) && (texto[cont-1]!='/')) {
		directorio=g_strdup_printf("%s/",texto);
	} else {
		directorio=g_strdup(texto);
	}
	xmlSetProp(xmlnode,"fuentes",directorio);
	carpeta_fuentes=g_strdup_printf("%s%s",carpeta_proyecto,directorio);
	g_free(directorio);
	g_free(texto);

	fuente=glade_xml_get_widget(proyecto_ventana,"pixmaps_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	for (cont=0;texto[cont]!=0;cont++);
	if ((cont!=0) && (texto[cont-1]!='/')) {
		directorio=g_strdup_printf("%s/",texto);
	} else {
		directorio=g_strdup(texto);
	}
	g_free(texto);
	xmlSetProp(xmlnode,"pixmaps",directorio);
	carpeta_pixmaps=g_strdup_printf("%s%s",carpeta_proyecto,directorio);
	g_free(directorio);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"datos_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
		for (cont=0;texto[cont]!=0;cont++);
	if ((cont!=0) && (texto[cont-1]!='/')) {
		directorio=g_strdup_printf("%s/",texto);
	} else {
		directorio=g_strdup(texto);
	}
	g_free(texto);
	xmlSetProp(xmlnode,"datos",directorio);
	carpeta_datos=g_strdup_printf("%s%s",carpeta_proyecto,directorio);
	g_free(directorio);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"documentacion_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
			for (cont=0;texto[cont]!=0;cont++);
	if ((cont!=0) && (texto[cont-1]!='/')) {
		directorio=g_strdup_printf("%s/",texto);
	} else {
		directorio=g_strdup(texto);
	}
	g_free(texto);
	xmlSetProp(xmlnode,"documentacion",directorio);
	carpeta_documentacion=g_strdup_printf("%s%s",carpeta_proyecto,directorio);
	g_free(directorio);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"glade_proyecto_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"glade","1");
	} else {
		xmlSetProp(xmlnode,"glade","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"glade_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		xmlSetProp(xmlnode,"glade","0");
	}
	for (cont=0;texto[cont]!=0;cont++);
	for (;(texto[cont]!='/') && (cont!=0);cont--);
	if (texto[cont]=='/') {
		glade_file=g_strdup_printf("%s",&(texto[cont+1]));
	} else {
		glade_file=g_strdup_printf("%s",texto);
	}
	xmlSetProp(xmlnode,"glade_file",glade_file);
	g_free(glade_file);
	g_free(texto);

	fuente=glade_xml_get_widget(proyecto_ventana,"crear_h_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"crear_h","1");
	} else {
		xmlSetProp(xmlnode,"crear_h","0");
	}

	fuente=glade_xml_get_widget(proyecto_ventana,"cabecera_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"cabecera","1");
	} else {
		xmlSetProp(xmlnode,"cabecera","0");
	}

	fuente=glade_xml_get_widget(proyecto_ventana,"defines_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"defines","1");
	} else {
		xmlSetProp(xmlnode,"defines","0");
	}

	//propiedades librerias
	xmlnode=xmlnode->next;

	pro_actualizar_librerias_lincado(widget);	

	xmlnode=xmlnode->xmlChildrenNode;
	fuente=glade_xml_get_widget(proyecto_ventana,"otras_libs_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"path_libs_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"path_cab_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	xmlnode=xmlnode->parent;

	//propiedades gettext
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"gettext_entry");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	//propiedades avisos
	xmlnode=xmlnode->next;
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w00_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w00","1");
	} else {
		xmlSetProp(xmlnode,"w00","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w01_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w01","1");
	} else {
		xmlSetProp(xmlnode,"w01","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w02_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w02","1");
	} else {
		xmlSetProp(xmlnode,"w02","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w03_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w03","1");
	} else {
		xmlSetProp(xmlnode,"w03","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w04_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w04","1");
	} else {
		xmlSetProp(xmlnode,"w04","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w05_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w05","1");
	} else {
		xmlSetProp(xmlnode,"w05","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w06_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w06","1");
	} else {
		xmlSetProp(xmlnode,"w06","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w07_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w07","1");
	} else {
		xmlSetProp(xmlnode,"w07","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w08_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w08","1");
	} else {
		xmlSetProp(xmlnode,"w08","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w09_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w09","1");
	} else {
		xmlSetProp(xmlnode,"w09","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w10_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w10","1");
	} else {
		xmlSetProp(xmlnode,"w10","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w11_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w11","1");
	} else {
		xmlSetProp(xmlnode,"w11","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w12_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w12","1");
	} else {
		xmlSetProp(xmlnode,"w12","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w13_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w13","1");
	} else {
		xmlSetProp(xmlnode,"w13","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w14_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w14","1");
	} else {
		xmlSetProp(xmlnode,"w14","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w15_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w15","1");
	} else {
		xmlSetProp(xmlnode,"w15","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w16_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w16","1");
	} else {
		xmlSetProp(xmlnode,"w16","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w17_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w17","1");
	} else {
		xmlSetProp(xmlnode,"w17","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w18_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w18","1");
	} else {
		xmlSetProp(xmlnode,"w18","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w19_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w19","1");
	} else {
		xmlSetProp(xmlnode,"w19","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w20_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w20","1");
	} else {
		xmlSetProp(xmlnode,"w20","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w21_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"w21","1");
	} else {
		xmlSetProp(xmlnode,"w21","0");
	}
	
	//propiedades compilar
	xmlnode=xmlnode->next;
	
	fuente=glade_xml_get_widget(proyecto_ventana,"optimizar_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		fuente=glade_xml_get_widget(proyecto_ventana,"nivel_optimizacion");
		nivel=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fuente));
		texto=g_strdup_printf("%i",nivel);
		xmlSetProp(xmlnode,"optimizacion",texto);
		g_free(texto);
	} else {
		xmlSetProp(xmlnode,"optimizacion","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"depuracion_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		fuente=glade_xml_get_widget(proyecto_ventana,"nivel_depuracion");
		nivel=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fuente));
		texto=g_strdup_printf("%i",nivel);
		xmlSetProp(xmlnode,"depuracion",texto);
		g_free(texto);
	} else {
		xmlSetProp(xmlnode,"depuracion","0");
	}
	
	fuente=glade_xml_get_widget(proyecto_ventana,"electric_fence_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"electric_fence","1");
	} else {
		xmlSetProp(xmlnode,"electric_fence","0");
	}

	fuente=glade_xml_get_widget(proyecto_ventana,"opciones_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	//propiedades CVS
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"cvs_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"activo","1");
	} else {
		xmlSetProp(xmlnode,"activo","0");
	}
	fuente=glade_xml_get_widget(proyecto_ventana,"compresion_spinbutton");
	nivel=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fuente));
	texto=g_strdup_printf("%i",nivel);
	xmlSetProp(xmlnode,"compresion",texto);
	g_free(texto);
	fuente=glade_xml_get_widget(proyecto_ventana,"autoupdate_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"autoupdate","1");
	} else {
		xmlSetProp(xmlnode,"autoupdate","0");
	}
	fuente=glade_xml_get_widget(proyecto_ventana,"autoaddremove_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"autoaddremove","1");
	} else {
		xmlSetProp(xmlnode,"autoaddremove","0");
	}
	xmlnode=xmlnode->xmlChildrenNode;
	fuente=glade_xml_get_widget(proyecto_ventana,"cvsroot_entry");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"modul_entry");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->parent;
	

	if (proyecto.archivo!=NULL) {
		g_free(proyecto.archivo);
	}
	proyecto.archivo=g_strdup_printf("%s%s.diasceprj",carpeta_proyecto,nombre_proyecto);
	{
		gchar *carpeta;
		gsize read, written;
		GError *error;
		
		carpeta = g_locale_from_utf8(carpeta_proyecto, -1, &read, &written, &error);
		mkdir(carpeta,0x1ed);
		g_free(carpeta);
		carpeta = g_locale_from_utf8(carpeta_fuentes, -1, &read, &written, &error);
		mkdir(carpeta,0x1ed);
		g_free(carpeta);
		carpeta = g_locale_from_utf8(carpeta_pixmaps, -1, &read, &written, &error);
		mkdir(carpeta,0x1ed);
		g_free(carpeta);
		carpeta = g_locale_from_utf8(carpeta_datos, -1, &read, &written, &error);
		mkdir(carpeta,0x1ed);
		g_free(carpeta);
		carpeta = g_locale_from_utf8(carpeta_documentacion, -1, &read, &written, &error);
		mkdir(carpeta,0x1ed);
		g_free(carpeta);
	}
	g_free(carpeta_proyecto);
	g_free(carpeta_fuentes);
	g_free(carpeta_pixmaps);
	g_free(carpeta_datos);
	g_free(carpeta_documentacion);
	g_free(nombre_proyecto);
	pro_guardar();

	DEBUG_MSG(<-pro_actualizar);
}

void pro_mostrar(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;

	DEBUG_MSG(->pro_mostrar);
	xmlnode=(proyecto.xml)->xmlRootNode->xmlChildrenNode;
	
	//propiedades generales
	fuente=glade_xml_get_widget(proyecto_ventana,"nombre_entrada_project");
	texto=xmlGetProp(xmlnode,"nombre");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"version_entrada");
	texto=xmlGetProp(xmlnode,"version");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"autor_entrada");
	texto=xmlGetProp(xmlnode,"autor");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"email_entrada");
	texto=xmlGetProp(xmlnode,"e-mail");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	texto=xmlGetProp(xmlnode,"lenguaje");
	switch (texto[0]) {
		case '0':
			fuente=glade_xml_get_widget(proyecto_ventana,"c_boton");
			break;
		case '1':
			fuente=glade_xml_get_widget(proyecto_ventana,"cpp_boton");
			break;
	};
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),TRUE);
	g_free(texto);
	
	//propiedades archivos
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"ejecutable_entrada");
	texto=xmlGetProp(xmlnode,"nombre");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"proyecto_entrada");
	texto=xmlGetProp(xmlnode,"proyecto");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"fuentes_entrada");
	texto=xmlGetProp(xmlnode,"fuentes");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"pixmaps_entrada");
	texto=xmlGetProp(xmlnode,"pixmaps");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);

	fuente=glade_xml_get_widget(proyecto_ventana,"datos_entrada");
	texto=xmlGetProp(xmlnode,"datos");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);

	fuente=glade_xml_get_widget(proyecto_ventana,"documentacion_entrada");
	texto=xmlGetProp(xmlnode,"documentacion");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	g_free(texto);

	fuente=glade_xml_get_widget(proyecto_ventana,"glade_proyecto_boton");
	texto=xmlGetProp(xmlnode,"glade");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"glade_entrada");
	texto=xmlGetProp(xmlnode,"glade_file");
	gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	if (texto==NULL) {
		fuente=glade_xml_get_widget(proyecto_ventana,"glade_proyecto_boton");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),FALSE);
	}
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"crear_h_boton");
	texto=xmlGetProp(xmlnode,"crear_h");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"cabecera_boton");
	texto=xmlGetProp(xmlnode,"cabecera");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"defines_boton");
	texto=xmlGetProp(xmlnode,"defines");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	//propiedades librerias
	xmlnode=xmlnode->next;
	
	pro_mostrar_librerias_lincado(widget);

	xmlnode=xmlnode->xmlChildrenNode;
	fuente=glade_xml_get_widget(proyecto_ventana,"otras_libs_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"path_libs_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"path_cab_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->parent;

	//propiedades gettext
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"gettext_entry");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	
	//propiedades avisos
	xmlnode=xmlnode->next;
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w00_boton");
	texto=xmlGetProp(xmlnode,"w00");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w01_boton");
	texto=xmlGetProp(xmlnode,"w01");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w02_boton");
	texto=xmlGetProp(xmlnode,"w02");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w03_boton");
	texto=xmlGetProp(xmlnode,"w03");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w04_boton");
	texto=xmlGetProp(xmlnode,"w04");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w05_boton");
	texto=xmlGetProp(xmlnode,"w05");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w06_boton");
	texto=xmlGetProp(xmlnode,"w06");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w07_boton");
	texto=xmlGetProp(xmlnode,"w07");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w08_boton");
	texto=xmlGetProp(xmlnode,"w08");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w09_boton");
	texto=xmlGetProp(xmlnode,"w09");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w10_boton");
	texto=xmlGetProp(xmlnode,"w10");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w11_boton");
	texto=xmlGetProp(xmlnode,"w11");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w12_boton");
	texto=xmlGetProp(xmlnode,"w12");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w13_boton");
	texto=xmlGetProp(xmlnode,"w13");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w14_boton");
	texto=xmlGetProp(xmlnode,"w14");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w15_boton");
	texto=xmlGetProp(xmlnode,"w15");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w16_boton");
	texto=xmlGetProp(xmlnode,"w16");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w17_boton");
	texto=xmlGetProp(xmlnode,"w17");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w18_boton");
	texto=xmlGetProp(xmlnode,"w18");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w19_boton");
	texto=xmlGetProp(xmlnode,"w19");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w20_boton");
	texto=xmlGetProp(xmlnode,"w20");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"w21_boton");
	texto=xmlGetProp(xmlnode,"w21");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	//propiedades compilar
	xmlnode=xmlnode->next;
	
	fuente=glade_xml_get_widget(proyecto_ventana,"optimizar_boton");
	texto=xmlGetProp(xmlnode,"optimizacion");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	if ((texto[0]-48)!=0) {
		fuente=glade_xml_get_widget(proyecto_ventana,"nivel_optimizacion");
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(fuente),texto[0]-48);
	}
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"depuracion_boton");
	texto=xmlGetProp(xmlnode,"depuracion");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	if ((texto[0]-48)!=0) {
		fuente=glade_xml_get_widget(proyecto_ventana,"nivel_depuracion");
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(fuente),texto[0]-48);
	}
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"electric_fence_boton");
	texto=xmlGetProp(xmlnode,"electric_fence");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	
	fuente=glade_xml_get_widget(proyecto_ventana,"opciones_entrada");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);

	//propiedades CVS
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"cvs_checkbutton");
	texto=xmlGetProp(xmlnode,"activo");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	fuente=glade_xml_get_widget(proyecto_ventana,"compresion_spinbutton");
	texto=xmlGetProp(xmlnode,"compresion");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	fuente=glade_xml_get_widget(proyecto_ventana,"autoupdate_checkbutton");
	texto=xmlGetProp(xmlnode,"autoupdate");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	fuente=glade_xml_get_widget(proyecto_ventana,"autoaddremove_checkbutton");
	texto=xmlGetProp(xmlnode,"autoaddremove");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	g_free(texto);
	xmlnode=xmlnode->xmlChildrenNode;
	fuente=glade_xml_get_widget(proyecto_ventana,"cvsroot_entry");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->next;
	fuente=glade_xml_get_widget(proyecto_ventana,"modul_entry");
	texto=xmlNodeGetContent(xmlnode);
	if (texto!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(fuente),texto);
	}
	g_free(texto);
	xmlnode=xmlnode->parent;
		
	DEBUG_MSG(<-pro_mostrar);
}

void pro_guardar(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *comando;
	gchar *libs;
	gchar *install_sh;
	
	DEBUG_MSG(->pro_guardar);
	{
		gchar *archivo;
		gsize read, written;
		GError *error;
		
		archivo = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
		xmlSaveFile(archivo,proyecto.xml);
		g_free(archivo);
	}
	libs=pro_librerias_lincado();
	if (libs[LGETTEXT]=='1') {
		nombre=pro_nombre_completo_archivo("ABOUT-NLS",TRUE, LOCALE);
		comando=g_strdup_printf("cp /usr/share/gettext/ABOUT-NLS %s 2> /dev/stdout\n",nombre);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(nombre);
		comando=g_strdup_printf("cp /usr/share/gettext/intl . -r 2> /dev/stdout\n");
		gen_comando(comando,NULL);
		g_free(comando);
		comando=g_strdup_printf("cp /usr/share/gettext/po . -r 2> /dev/stdout\n");
		gen_comando(comando,NULL);
		g_free(comando);
	}
	g_free(libs);
	install_sh=g_strdup_printf("%s/install-sh",prefix_automake);
	if (gen_existe_fichero(install_sh)) {
		nombre=pro_nombre_completo_archivo("install-sh",FALSE, LOCALE);
		comando=g_strdup_printf("cp %s/install-sh %s 2> /dev/stdout\n",prefix_automake,nombre);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(nombre);
	} else {
		nombre=pro_nombre_completo_archivo("install.sh",FALSE, LOCALE);
		comando=g_strdup_printf("cp %s/install.sh %s 2> /dev/stdout\n",prefix_automake,nombre);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(nombre);
	}
	g_free(install_sh);
	nombre=pro_nombre_completo_archivo("mkinstalldirs",FALSE, LOCALE);
	comando=g_strdup_printf("cp %s/mkinstalldirs %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("missing",FALSE, LOCALE);
	comando=g_strdup_printf("cp %s/missing %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	//Comprobamos que no exista el fichero INSTALL antes de copiarlo
	nombre=pro_nombre_completo_archivo("INSTALL",FALSE, LOCALE);
	archivo = fopen(nombre,"r"); 
	g_free(nombre);
	if (archivo == NULL) {
		nombre=pro_nombre_completo_archivo("INSTALL",FALSE, LOCALE);
		comando=g_strdup_printf("cp %s/INSTALL %s 2> /dev/stdout\n",prefix_automake,nombre);
		gen_comando(comando,NULL);
		g_free(comando);
		g_free(nombre);
	} else {
		fclose (archivo);
	}
	nombre=pro_nombre_completo_archivo("COPYING",FALSE, LOCALE);
	comando=g_strdup_printf("cp %s/COPYING %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("config.guess",FALSE, LOCALE);
	comando=g_strdup_printf("cp %s/config.guess %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("config.sub",FALSE, LOCALE);
	comando=g_strdup_printf("cp %s/config.sub %s 2> /dev/stdout\n",prefix_automake,nombre);
	gen_comando(comando,NULL);
	g_free(comando);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("NEWS",FALSE, LOCALE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("README",FALSE, LOCALE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("AUTHORS",FALSE, LOCALE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	nombre=pro_nombre_completo_archivo("ChangeLog",FALSE, LOCALE);
	archivo=fopen(nombre,"a");
	fclose(archivo);
	g_free(nombre);
	aut_crear_makefile();
	aut_crear_makefile_src();
	aut_crear_configure_ac();
	aut_crear_potfiles_in();
	aut_crear_acconfig_h();
	nombre=pro_nombre_completo_archivo("configure.ac",TRUE, LOCALE);
	g_free(nombre);
	if (autoconfiguracion & ACLOCAL) {
		gen_comando("aclocal 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & AUTO_CONF) {
		nombre=pro_nombre_completo_archivo("config.cache",TRUE, UTF8);
		if (gen_existe_fichero(nombre)) {
			gen_comando("rm config.cache 2> /dev/stdout\n",NULL);
		}
		g_free(nombre);
		gen_comando("autoconf 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & AUTO_HEADER) {
		gen_comando("autoheader 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & AUTO_MAKE) {
		gen_comando("automake 2> /dev/stdout\n",NULL);
	}
	if (autoconfiguracion & CONFIGURE) {
		gen_comando("./configure 2> /dev/stdout\n",NULL);
	}
	autoconfiguracion=0;

	DEBUG_MSG(<-pro_guardar);
}

gint pro_abrir(void)
{
	xmlNodePtr nodo,nodo_nuevo;
	gchar *path_proyecto;
	gint cont;
	gboolean guardar;
	gchar *version;
	gchar *directorio;
	gsize read, written;
	gchar *archivo;
	gchar *directorio_locale;
	GError *error;
	
	DEBUG_MSG(->pro_abrir);
	guardar=FALSE;

	archivo = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
	proyecto.xml=xmlParseFile(archivo);
	g_free(archivo);
	if ((!proyecto.xml) || (!(proyecto.xml)->xmlRootNode) || (!(proyecto.xml)->xmlRootNode->name)) {
		DEBUG_MSG(<-pro_abrir);
		return -2;
	}
	if (	(g_strcasecmp((proyecto.xml)->xmlRootNode->name,"Proyecto_DiaSCE")!=0)) {
		if (g_strcasecmp(proyecto.xml->xmlRootNode->name,"Proyecto_david") == 0) {
			DEBUG_MSG(<-pro_abrir);
			return -1;
		} else {
			DEBUG_MSG(<-pro_abrir);
			return -2;
		}
	}
	nodo=proyecto.xml->xmlRootNode->xmlChildrenNode->next;
	path_proyecto=g_strdup(proyecto.archivo);
	for (cont=0;path_proyecto[cont]!=0;cont++);
	for (;path_proyecto[cont]!='/';cont--);
	path_proyecto[cont+1]=0;
	xmlSetProp(nodo,"proyecto",path_proyecto);
	archivo = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
	xmlSaveFile(archivo,proyecto.xml);
	g_free(archivo);
	autoconfiguracion=0;
	
	nodo=proyecto.xml->xmlRootNode;
	version=xmlGetProp(nodo,"version");
	if (!g_strcasecmp(version,"1.1")) {
		xmlSetProp(nodo,"version",VERSION_PROYECTO);
		nodo=proyecto.xml->xmlRootNode->xmlChildrenNode->next;
		xmlNewProp(nodo,"documentacion","docs/");
		autoconfiguracion=AUTO_CONF | AUTO_HEADER | AUTO_MAKE | CONFIGURE;
		guardar=TRUE;
		directorio=g_strdup_printf("%sdocs",path_proyecto);
		directorio_locale= g_locale_from_utf8(directorio, -1, &read, &written, &error);
		mkdir(directorio_locale,0x1ed);
		g_free(directorio_locale);
		g_free(directorio);
	}
	g_free(version);
	nodo=proyecto.xml->xmlRootNode;
	version=xmlGetProp(nodo,"version");
	if (!g_strcasecmp(version,"1.2")) {
		xmlSetProp(nodo,"version",VERSION_PROYECTO);
		nodo=buscar_nodo_xml(nodo,"librerias");
		nodo_nuevo=xmlNewNode(NULL,"gettext");
		nodo_nuevo->prev=nodo;
		nodo_nuevo->next=nodo->next;
		nodo_nuevo->parent=nodo->parent;
		nodo->next=nodo_nuevo;
		nodo_nuevo->next->prev=nodo_nuevo;
		nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"compilar");
		nodo_nuevo=xmlNewNode(NULL,"cvs");
		nodo_nuevo->prev=nodo;
		nodo_nuevo->next=nodo->next;
		nodo_nuevo->parent=nodo->parent;
		nodo->next=nodo_nuevo;
		nodo_nuevo->next->prev=nodo_nuevo;
		xmlNewProp(nodo_nuevo,"activo","0");
		xmlNewProp(nodo_nuevo,"compresion","5");
		xmlNewProp(nodo_nuevo,"autoupdate","0");
		xmlNewProp(nodo_nuevo,"autoaddremove","0");
		xmlNewChild(nodo_nuevo,NULL,"cvsroot",NULL);	
		xmlNewChild(nodo_nuevo,NULL,"modulo",NULL);
		nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode, "fuentes");	
		nodo = nodo->xmlChildrenNode;
		while (nodo != NULL) {
			xmlNewProp(nodo, "open","-1");
			xmlNewProp(nodo, "line","0");
			nodo = nodo->next;
		}
		nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode, "cabeceras");	
		nodo = nodo->xmlChildrenNode;
		while (nodo != NULL) {
			xmlNewProp(nodo, "open","-1");
			xmlNewProp(nodo, "line","0");
			nodo = nodo->next;
		}
		nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode, "otros");	
		nodo = nodo->xmlChildrenNode;
		while (nodo != NULL) {
			xmlNewProp(nodo, "open","-1");
			xmlNewProp(nodo, "line","0");
			nodo = nodo->next;
		}
		guardar=TRUE;
	}
	g_free(version);
	
	g_free(path_proyecto);
	if (guardar) pro_guardar();
	DEBUG_MSG(<-pro_abrir);
	return 0;
}

void pro_anadir(gchar *nombre)
{
	xmlNodePtr xmlnode, child_node;
	guint tipo;
	
	DEBUG_MSG(->pro_anadir);
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"otros");
			child_node = xmlNewChild(xmlnode,NULL,"otro",nombre);
			xmlNewProp(child_node, "open", "-1");
			xmlNewProp(child_node, "line", "0");
			break;
		case 1:
			xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"fuentes");
			child_node = xmlNewChild(xmlnode,NULL,"fuente",nombre);
			xmlNewProp(child_node, "open", "-1");
			xmlNewProp(child_node, "line", "0");
			autoconfiguracion=autoconfiguracion | ACLOCAL;
			break;
		case 2:
			xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cabeceras");
			child_node = xmlNewChild(xmlnode,NULL,"cabecera",nombre);
			xmlNewProp(child_node, "open", "-1");
			xmlNewProp(child_node, "line", "0");
			autoconfiguracion=autoconfiguracion | ACLOCAL;
			break;
	};
	
	DEBUG_MSG(<-pro_anadir);
}

gchar *pro_nombre(gint encoding)
{
	xmlNodePtr xmlnode;
	char *nombre_utf8;
	gchar *nombre;
	gsize read, written;
	GError *error;
	
	if (proyecto.xml!=NULL) {
		xmlnode=(proyecto.xml)->xmlRootNode->xmlChildrenNode;
		nombre_utf8=xmlGetProp(xmlnode,"nombre");
		if (encoding == LOCALE) {
			nombre = g_locale_from_utf8(nombre_utf8, -1, &read, &written, &error);
			g_free(nombre_utf8);
		} else {
			nombre = nombre_utf8;
		}
	} else {
		nombre=NULL;
	}
	
	return nombre;
}

gchar *pro_fuentes(xmlNodePtr *xmlnode, gint encoding)
{
	gchar *fuentes, *fuentes_utf8;
	gsize read, written;
	GError *error;
	
	if ((*xmlnode)==NULL) {
		(*xmlnode)=buscar_nodo_xml(proyecto.xml->xmlRootNode,"fuentes");
		(*xmlnode)=(*xmlnode)->xmlChildrenNode;
	} else {
		(*xmlnode)=(*xmlnode)->next;
	}
	if ((*xmlnode)!=NULL) {
		if (encoding == LOCALE) {
			fuentes_utf8 = xmlNodeGetContent(*xmlnode);
			fuentes = g_locale_from_utf8(fuentes_utf8, -1, &read, &written, &error);
			g_free(fuentes_utf8);
			return fuentes;
		} else {
			return xmlNodeGetContent(*xmlnode);
		}
	} else {
		return NULL;
	}
}

gchar *pro_cabeceras(xmlNodePtr *xmlnode, gint encoding)
{
	gchar *cabeceras, *cabeceras_utf8;
	gsize read, written;
	GError *error;

	if ((*xmlnode)==NULL) {
		(*xmlnode)=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cabeceras");
		(*xmlnode)=(*xmlnode)->xmlChildrenNode;
	} else {
		(*xmlnode)=(*xmlnode)->next;
	}
	if ((*xmlnode)!=NULL) {
		if (encoding == LOCALE) {
			cabeceras_utf8 = xmlNodeGetContent(*xmlnode);
			cabeceras = g_locale_from_utf8(cabeceras_utf8, -1, &read, &written, &error);
			g_free(cabeceras_utf8);
			return cabeceras;
		} else {
			return xmlNodeGetContent(*xmlnode);
		}
	} else {
		return NULL;
	}
}

gchar *pro_otros(xmlNodePtr *xmlnode, gint encoding)
{
	gchar *otros, *otros_utf8;
	gsize read, written;
	GError *error;

	if ((*xmlnode)==NULL) {
		(*xmlnode)=buscar_nodo_xml(proyecto.xml->xmlRootNode,"otros");
		(*xmlnode)=(*xmlnode)->xmlChildrenNode;
	} else {
		(*xmlnode)=(*xmlnode)->next;
	}
	if ((*xmlnode)!=NULL) {
		if (encoding == LOCALE) {
			otros_utf8 = xmlNodeGetContent(*xmlnode);
			otros = g_locale_from_utf8(otros_utf8, -1, &read, &written, &error);
			g_free(otros_utf8);
			return otros;
		} else {
			return xmlNodeGetContent(*xmlnode);
		}
	} else {
		return NULL;
	}
}

gchar *pro_nombre_completo_archivo(gchar *nombre,gboolean cambiar_directorio, gint encoding)
{
	xmlNodePtr xmlnode;
	gchar *path1,*path2;
	gchar *path, *path_locale;
	guint tipo;
	gchar *archivo, *archivo_locale;
	gsize read, written;
	GError *error;
	
	DEBUG_MSG(->pro_nombre_completo_archivo);
	path=NULL;
	xmlnode=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
	path1=xmlGetProp(xmlnode,"proyecto");
	path2=xmlGetProp(xmlnode,"fuentes");
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			path=g_strdup_printf("%s",path1);
			break;
		case 1:
		case 2:
			path=g_strdup_printf("%s%s",path1,path2);
			break;
	};
	if (cambiar_directorio) {
		path_locale = g_locale_from_utf8(path, -1, &read, &written, &error);
		chdir(path_locale);
		g_free(path_locale);
		g_free(path);
		archivo=g_strdup_printf("%s",nombre);
	} else {
		archivo=g_strdup_printf("%s%s",path,nombre);
		g_free(path);
	}
	g_free(path1);
	g_free(path2);

	DEBUG_MSG(<-pro_nombre_completo_archivo);
	if(encoding == LOCALE) {
		archivo_locale = g_locale_from_utf8(archivo, -1, &read, &written, &error);
		g_free(archivo);
		archivo = archivo_locale;
	}	
	return archivo;
}

gchar *pro_librerias_lincado(void)
{
	xmlNodePtr xmlnode;
	gchar *librerias,*tmp;
	gchar *lib;
	gint cont;

	DEBUG_MSG(->pro_librerias_lincado);
	if (proyecto.xml!=NULL) {
		xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"librerias");
		if (xmlnode==NULL) {
			DEBUG_MSG(el archivo del proyecto no es correcto);
		}
		tmp=g_strdup("");
		for (cont=0;cont<LTOTALES;cont++) {
			lib=xmlGetProp(xmlnode,pro_nombre_librerias_xml[cont]);
			librerias=g_strdup_printf("%s%s",tmp,lib);
			g_free(tmp);
			tmp=librerias;
			g_free(lib);
		}
		// esta linea en el cambio de nodo es porque el electric fence no esta con el resto de las librerias
		xmlnode=xmlnode->next->next;
		lib=xmlGetProp(xmlnode,"electric_fence");
		librerias=g_strdup_printf("%s0%s",tmp,lib); // we add a '0' because we have to leave a space because LTOTAL takes it
		g_free(tmp);
		tmp=librerias;
		g_free(lib);
	} else {
		librerias=NULL;
	}
	
	DEBUG_MSG(<-pro_librerias_lincado);
	return librerias;
}

gchar *pro_opciones_compilacion(void)
{

	xmlNodePtr xmlnode;
	gchar *opciones;
	gchar *estado;
	gchar *temporal;
	gint cont;
	gboolean usar_pkg;

	temporal=NULL;
	opciones=NULL;

	xmlnode=(proyecto.xml)->xmlRootNode->xmlChildrenNode;
	estado=xmlGetProp(xmlnode,"lenguaje");
	switch (estado[0]-48) {
		case 0:
			opciones=g_strdup("gcc");
			break;
		case 1:
			opciones=g_strdup("c++");
			break;
	};
	temporal=opciones;
	g_free(estado);
	
	xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"compilar");
	estado=xmlNodeGetContent(xmlnode);
	if (estado!=NULL) {
		opciones=g_strdup_printf("%s %s",temporal,estado);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"depuracion");
	if (estado[0]!='0') {
		opciones=g_strdup_printf("%s -g%s",temporal,estado);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	estado=xmlGetProp(xmlnode,"optimizacion");
	opciones=g_strdup_printf("%s -O%s",temporal,estado);
	g_free(temporal);
	temporal=opciones;
	g_free(estado);

	xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"avisos");
	estado=xmlGetProp(xmlnode,"w00");
	if (estado[0]=='1') {
		opciones=g_strdup_printf("%s -Wall",temporal);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	opciones=g_strdup_printf("%s %s",temporal,"-I. -I.. -I/usr/include");
	g_free(temporal);
	temporal=opciones;

	xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"librerias");
	for (cont=0;cont<LGLIB2;cont++) {
		estado=xmlGetProp(xmlnode,pro_nombre_librerias_xml[cont]);
		if (estado[0]=='1') {
			opciones=g_strdup_printf("%s %s",temporal,preferencias.inc[cont]);
			g_free(temporal);
			temporal=opciones;
		}
		g_free(estado);
	}
	usar_pkg=FALSE;
	for (cont=LGLIB2;cont<LTOTALES;cont++) {
		estado=xmlGetProp(xmlnode,pro_nombre_librerias_xml[cont]);
		if (estado[0]=='1') {
			if (!usar_pkg) {
				usar_pkg=TRUE;
				opciones=g_strdup_printf("%s `pkg-config --cflags",temporal);
				g_free(temporal);
				temporal=opciones;
			}
			opciones=g_strdup_printf("%s %s",temporal,pro_nombre_librerias[cont]);
			g_free(temporal);
			temporal=opciones;
		}
		g_free(estado);
	}
	if (usar_pkg) {
		opciones=g_strdup_printf("%s`",temporal);
		g_free(temporal);
		temporal=opciones;
	}
	
	xmlnode=xmlnode->xmlChildrenNode->next->next;
	estado=xmlNodeGetContent(xmlnode);
	if (estado!=NULL) {
		opciones=g_strdup_printf("%s %s",temporal,estado);
		g_free(temporal);
		temporal=opciones;
	}
	g_free(estado);

	opciones=g_strdup_printf("%s -c",temporal);
	g_free(temporal);

	return opciones;
}

void pro_eliminar(gchar *nombre)
{
	guint tipo;
	xmlNodePtr xmlnode;
	gchar *contenido;

	xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"fuentes");
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			xmlnode=xmlnode->next->next;
			break;
		case 1:
			break;
		case 2:
			xmlnode=xmlnode->next;
			break;
	};
	xmlnode=xmlnode->xmlChildrenNode;
	contenido=xmlNodeGetContent(xmlnode);
	while (g_strcasecmp(contenido,nombre)) {
		xmlnode=xmlnode->next;
		contenido=xmlNodeGetContent(xmlnode);
	};
	xmlUnlinkNode(xmlnode);
	xmlFreeNode(xmlnode);
	pro_guardar();
	if (tipo!=0) {
		aut_crear_makefile_src();
	}
}

// This function returns TRUE if the file belongs to the project
gboolean pro_existe_archivo(gchar *nombre)
{
	guint tipo;
	xmlNodePtr xmlnode;
	gchar *contenido;
	
	xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"fuentes");
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			xmlnode=xmlnode->next->next;
			break;
		case 1:
			break;
		case 2:
			xmlnode=xmlnode->next;
			break;
	}
	xmlnode=xmlnode->xmlChildrenNode;
	if (xmlnode!=NULL) {
		do {
			contenido=xmlNodeGetContent(xmlnode);
			xmlnode=xmlnode->next;
		} while ((xmlnode!=NULL) && (strcmp(contenido,nombre)));
		if (strcmp(contenido,nombre)) {
			return FALSE;
		} else {
			return TRUE;
		}
	} else {
		return FALSE;
	}
}

gchar *pro_version(void)
{
	xmlNodePtr nodo;
	gchar *version;
	
	if (proyecto.xml!=NULL) {
		nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode;
		version=xmlGetProp(nodo,"version");
	} else {
		version=NULL;
	}
	return version;
}

gchar *pro_lenguaje(void)
{
	xmlNodePtr nodo;
	gchar *lenguaje;

	if (proyecto.xml!=NULL)	{
		nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode;
		lenguaje=xmlGetProp(nodo,"lenguaje");
	} else {
		lenguaje=NULL;
	}
	
	return lenguaje;
}

gchar *pro_librerias_usuario(void)
{
	xmlNodePtr nodo;
	gchar *librerias,*tmp1,*tmp2;

	if (proyecto.xml!=NULL) {	
		nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"librerias");
		nodo=buscar_nodo_xml(nodo,"otras");
		tmp1=xmlNodeGetContent(nodo);
		nodo=nodo->next;
		tmp2=xmlNodeGetContent(nodo);
		if ((tmp1==NULL) && (tmp2==NULL)) {
			return NULL;
		}
		if (tmp1==NULL) {
			tmp1=g_strdup("");
		}
		if (tmp2==NULL) {
			tmp2=g_strdup("");
		}
		librerias=g_strdup_printf("USER_LIBS=\"%s %s\"",tmp1,tmp2);
		g_free(tmp1);
		g_free(tmp2);
	} else {
		librerias=NULL;
	}
	
	return librerias;
	
}

gchar *pro_opciones_cflags(void)
{
	xmlNodePtr nodo;
	gchar *opciones,*tmp,*tmp1,*tmp2,*tmp3;
	
	DEBUG_MSG(->pro_opciones_cflags);
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"compilar");
	if (nodo==NULL) {
		DEBUG_MSG(el archivo del proyecto no es correcto);
	}
	tmp1=xmlGetProp(nodo,"optimizacion");
	tmp2=xmlGetProp(nodo,"depuracion");
	tmp3=xmlNodeGetContent(nodo);
	
	opciones=g_strdup("");
	tmp=opciones;
	if (tmp2[0]!='0') {
		opciones=g_strdup_printf(" -g%s",tmp2);
		g_free(tmp);
		tmp=opciones;
	}
	if (tmp1[0]!='0') {
		opciones=g_strdup_printf("%s -O%s",tmp,tmp1);
		g_free(tmp);
		tmp=opciones;
	}
	if (tmp3!=NULL) {
		opciones=g_strdup_printf("%s %s",tmp,tmp3);
		g_free(tmp);
	}
	g_free(tmp1);
	g_free(tmp2);
	g_free(tmp3);
	
	DEBUG_MSG(<-pro_opciones_cflags);
	return opciones;
}

gchar *pro_includes(void)
{
	xmlNodePtr nodo;
	gchar *includes;
	
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"librerias");
	nodo=buscar_nodo_xml(nodo,"includes");
	includes=xmlNodeGetContent(nodo);
	return includes;
}

gchar *pro_warnings(void)
{
	xmlNodePtr nodo;
	gchar *w,*tmp,*estado;
	
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"avisos");
	w=g_strdup("");
	tmp=w;
	
	estado=xmlGetProp(nodo,"w00");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wall",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w01");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -W",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w02");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wtraditional",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w03");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wundef",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w04");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wshadow",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w05");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wpointer-arith",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w06");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wbad-function-cast",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w07");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wcast-qual",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w08");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wcast-align",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w09");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wwrite-strings",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w10");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wconversion",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w11");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wsign-compare",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w12");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Waggregate-return",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w13");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wstrict-prototypes",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w14");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wmissing-prototypes",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w15");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wmissing-declarations",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w16");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wredundant-decls",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w17");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wnested-esterns",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w18");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Winline",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w19");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wold-style-cast",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w20");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Woverloaded-virtual",tmp);
		g_free(tmp);
		tmp=w;
	}
	estado=xmlGetProp(nodo,"w21");
	if (estado[0]=='1') {
		w=g_strdup_printf("%s -Wsynth",tmp);
		g_free(tmp);
		tmp=w;
	}
	
	return w;
}

gchar *pro_srcdir(gint encoding)
{
	xmlNodePtr nodo;
	gchar *srcdir;
	gint cont;
	gchar *srcdir_locale;
	gsize read, written;
	GError *error;
	
	nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
	srcdir=xmlGetProp(nodo,"fuentes");
	for (cont=0;srcdir[cont]!=0;cont++);
	srcdir[cont-1]=0;
	if (encoding == LOCALE) {
		srcdir_locale = g_locale_from_utf8(srcdir, -1, &read, &written, &error);
		g_free(srcdir);
		return srcdir_locale;
	} else {
		return srcdir;
	}
}

gchar *pro_prodir(gint encoding)
{
	xmlNodePtr nodo;
	gchar *prodir;
	gint cont;
	gchar *prodir_locale;
	gsize read, written;
	GError *error;
	
	nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
	prodir=xmlGetProp(nodo,"proyecto");
	for (cont=0;prodir[cont]!=0;cont++);
	prodir[cont-1]=0;
	if (encoding == LOCALE) {
		prodir_locale = g_locale_from_utf8(prodir, -1, &read, &written, &error);
		g_free(prodir);
		return prodir_locale;
	} else {
		return prodir;
	}
}

gchar *pro_pixdir(gint encoding)
{
	xmlNodePtr nodo;
	gchar *pixdir;
	gint cont;
	gchar *pixdir_locale;
	gsize read, written;
	GError *error;
	
	nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
	pixdir=xmlGetProp(nodo,"pixmaps");
	for (cont=0;pixdir[cont]!=0;cont++);
	pixdir[cont-1]=0;
	if (encoding == LOCALE) {
		pixdir_locale = g_locale_from_utf8(pixdir, -1, &read, &written, &error);
		g_free(pixdir);
		return pixdir_locale;
	} else {
		return pixdir;
	}
}

gchar *pro_datadir(gint encoding)
{
	xmlNodePtr nodo;
	gchar *datadir;
	gint cont;
	gchar *datadir_locale;
	gsize read, written;
	GError *error;
	
	nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
	datadir=xmlGetProp(nodo,"datos");
	for (cont=0;datadir[cont]!=0;cont++);
	datadir[cont-1]=0;
	if (encoding == LOCALE) {
		datadir_locale = g_locale_from_utf8(datadir, -1, &read, &written, &error);
		g_free(datadir);
		return datadir_locale;
	} else {
		return datadir;
	}
}

gchar *pro_docdir(gint encoding)
{
	xmlNodePtr nodo;
	gchar *docdir;
	gint cont;
	gchar *docdir_locale;
	gsize read, written;
	GError *error;
	
	nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
	docdir=xmlGetProp(nodo,"documentacion");
	for (cont=0;docdir[cont]!=0;cont++);
	docdir[cont-1]=0;
	if (encoding == LOCALE) {
		docdir_locale = g_locale_from_utf8(docdir, -1, &read, &written, &error);
		g_free(docdir);
		return docdir_locale;
	} else {
		return docdir;
	}
}

gchar *pro_glade_file(gint encoding)
{
	xmlNodePtr nodo;
	gchar *glade_file_utf8, *glade_file,*glade;
	gsize read, written;
	GError *error;

	if (proyecto.xml!=NULL) {
		nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
		glade=xmlGetProp(nodo,"glade");
		glade_file_utf8=xmlGetProp(nodo,"glade_file");
		if (glade[0]=='0') {
			glade_file=NULL;
		} else {
			if (encoding == LOCALE) {
				glade_file = g_locale_from_utf8(glade_file_utf8, -1, &read, &written, &error);
			} else {
				glade_file = g_strdup(glade_file_utf8);
			}
		}
		g_free(glade_file_utf8);
		g_free(glade);
	} else {
		glade_file=NULL;
	}
	return glade_file;
}

gchar *pro_ejecutable(gint encoding)
{
	xmlNodePtr nodo;
	gchar *ejecutable;
	gchar *ejecutable_locale;
	gsize read, written;
	GError *error;

	nodo=(proyecto.xml)->xmlRootNode->xmlChildrenNode->next;
	ejecutable=xmlGetProp(nodo,"nombre");
	if (encoding == LOCALE) {
		ejecutable_locale = g_locale_from_utf8(ejecutable, -1, &read, &written, &error);
		g_free(ejecutable);
		return ejecutable_locale;
	} else {
		return ejecutable;
	}
}

gchar *pro_cabecera_gnu(void)
{
	gchar *cabecera,*cabecera_locale;
	xmlNodePtr nodo;
	gchar *crear_cabecera;
	gchar *nombre,*autor,*e_mail;
	int fecha;
	struct tm *s_fecha;
	time_t tiempo;
	gsize read, written;
	GError *error;
	
	DEBUG_MSG(->pro_cabecera_gnu);
	nodo=proyecto.xml->xmlRootNode->xmlChildrenNode->next;
	crear_cabecera=xmlGetProp(nodo,"cabecera");
	if (crear_cabecera[0]=='0') {
		g_free(crear_cabecera);
		cabecera=NULL;
		DEBUG_MSG(<-pro_cabedera_gnu NULL);
		return cabecera;
	}
	g_free(crear_cabecera);
	nodo=nodo->prev;
	nombre=xmlGetProp(nodo,"nombre");
	autor=xmlGetProp(nodo,"autor");
	e_mail=xmlGetProp(nodo,"e-mail");
	tiempo=time(NULL);
	s_fecha=gmtime(&tiempo);
	fecha=(s_fecha->tm_year)+1900;
	cabecera=g_strdup_printf(
"/*
 * %s
 * Copyright (C) %i  %s
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * %s
 * %s
 */

"	,nombre,fecha,autor,autor,e_mail);
	cabecera_locale=g_locale_from_utf8(cabecera,-1,&read,&written,&error);
	g_free(nombre);
	g_free(autor);
	g_free(e_mail);
	g_free(cabecera);
	DEBUG_MSG(<-pro_cabecera_gnu);
	return cabecera_locale;
}

gboolean pro_crear_h(void)
{
	xmlNodePtr nodo;
	gchar *estado;
	
	nodo=proyecto.xml->xmlRootNode->xmlChildrenNode->next;
	estado=xmlGetProp(nodo,"crear_h");
	if (estado[0]=='1') {
		g_free(estado);
		return TRUE;
	} else {
		g_free(estado);
		return FALSE;
	}
}

gboolean pro_defines(void)
{
	xmlNodePtr nodo;
	gchar *estado;
	
	nodo=proyecto.xml->xmlRootNode->xmlChildrenNode->next;
	estado=xmlGetProp(nodo,"defines");
	if (estado[0]=='1') {
		g_free(estado);
		return TRUE;
	} else {
		g_free(estado);
		return FALSE;
	}
}

void pro_actualizar_librerias_lincado(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gint cont;

	widget=gtk_widget_get_toplevel(widget);
		xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"librerias");

	for (cont=0;cont<LTOTALES;cont++) {
		fuente=glade_xml_get_widget(proyecto_ventana,pro_nombre_botones_librerias[cont]);
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
			xmlSetProp(xmlnode,pro_nombre_librerias_xml[cont],"1");
		} else {
			xmlSetProp(xmlnode,pro_nombre_librerias_xml[cont],"0");
		}
	}	
}

void pro_mostrar_librerias_lincado(GtkWidget *widget)
{
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;
	gint cont;

	pro_forzando_librerias=TRUE;
	
	xmlnode=buscar_nodo_xml(proyecto.xml->xmlRootNode,"librerias");
	
	for (cont=0;cont<LTOTALES;cont++) {
		fuente=glade_xml_get_widget(proyecto_ventana,pro_nombre_botones_librerias[cont]);
		texto=xmlGetProp(xmlnode,pro_nombre_librerias_xml[cont]);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),texto[0]-48);
	}	

	pro_forzando_librerias=FALSE;
}

void pro_modificar_dependencias_librerias(gint libreria)
{
	gchar *libs;
	xmlNodePtr nodo;
	gint cont;
	
	libs=pro_librerias_lincado();
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"librerias");
	
	if (libs[libreria]=='1') {
		for (cont=0;cont<LTOTALES;cont++) {
			if (pro_dependencias_librerias[libreria][cont]) {
				xmlSetProp(nodo,pro_nombre_librerias_xml[cont],"1");
			}
		}
	} else {
		for (cont=0;cont<LTOTALES;cont++) {
			if (pro_dependencias_librerias[cont][libreria]) {
				xmlSetProp(nodo,pro_nombre_librerias_xml[cont],"0");
			}
		}
	}
	g_free(libs);
}

gchar *pro_idiomas(void)
{
	xmlNodePtr nodo;
	gchar *idiomas;
	
	if (proyecto.xml==NULL) {
		return NULL;
	}
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"gettext");
	idiomas=xmlNodeGetContent(nodo);
	return idiomas;
}

/***********************************************************************
This function updates the project file, storing the open tabs and line
numbers.
************************************************************************/
gint pro_update_open_tabs (void) 
{
	struct s_lista_archivos *file_list;
	xmlNodePtr node, children_node;
	gchar *file_name;
	gchar *pestana, *line;
	GtkTextIter insert_iter;
	GtkTextMark *insert_mark;
	gint line_offset;
	
	//source files
	node = buscar_nodo_xml(proyecto.xml->xmlRootNode, "fuentes");
	children_node = node->xmlChildrenNode;
	while (children_node != NULL) {
		file_name = xmlNodeGetContent(children_node);
		file_list = raiz_lista_archivos;
		while (file_list != NULL) {
			if (!strcmp(file_name, file_list->nombre)) {
				pestana = g_strdup_printf("%i", file_list->pestana);
				xmlSetProp(children_node, "open", pestana);
				g_free(pestana);
				if (file_list->pestana > (-1)) {
					insert_mark = gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(file_list->datos));
					gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(file_list->datos), &insert_iter, insert_mark);
					line_offset = gtk_text_iter_get_offset(&insert_iter);
					line = g_strdup_printf("%i", line_offset);
					xmlSetProp(children_node, "line", line);
					g_free(line);
				} else {
					xmlSetProp(children_node, "line", "0");
				}
				file_list = NULL;
			} else {
				file_list = file_list->siguiente;
			}
		}
		children_node = children_node->next;
	}
	//header files
	node = buscar_nodo_xml(proyecto.xml->xmlRootNode, "cabeceras");
	children_node = node->xmlChildrenNode;
	while (children_node != NULL) {
		file_name = xmlNodeGetContent(children_node);
		file_list = raiz_lista_archivos;
		while (file_list != NULL) {
			if (!strcmp(file_name, file_list->nombre)) {
				pestana = g_strdup_printf("%i", file_list->pestana);
				xmlSetProp(children_node, "open", pestana);
				g_free(pestana);
				if (file_list->pestana > (-1)) {
					insert_mark = gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(file_list->datos));
					gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(file_list->datos), &insert_iter, insert_mark);
					line_offset = gtk_text_iter_get_offset(&insert_iter);
					line = g_strdup_printf("%i", line_offset);
					xmlSetProp(children_node, "line", line);
					g_free(line);
				} else {
					xmlSetProp(children_node, "line", "0");
				}
				file_list = NULL;
			} else {
				file_list = file_list->siguiente;
			}
		}
		children_node = children_node->next;
	}
	//other files
	node = buscar_nodo_xml(proyecto.xml->xmlRootNode, "otros");
	children_node = node->xmlChildrenNode;
	while (children_node != NULL) {
		file_name = xmlNodeGetContent(children_node);
		file_list = raiz_lista_archivos;
		while (file_list != NULL) {
			if (!strcmp(file_name, file_list->nombre)) {
				pestana = g_strdup_printf("%i", file_list->pestana);
				xmlSetProp(children_node, "open", pestana);
				g_free(pestana);
				if (file_list->pestana > (-1)) {
					insert_mark = gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(file_list->datos));
					gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(file_list->datos), &insert_iter, insert_mark);
					line_offset = gtk_text_iter_get_offset(&insert_iter);
					line = g_strdup_printf("%i", line_offset);
					xmlSetProp(children_node, "line", line);
					g_free(line);
				} else {
					xmlSetProp(children_node, "line", "0");
				}
				file_list = NULL;
			} else {
				file_list = file_list->siguiente;
			}
		}
		children_node = children_node->next;
	}
	
	return 0;
}

gchar *pro_cvsroot(void)
{
	xmlNodePtr nodo;
	gchar *cvsroot;
	gchar *activo;
	
	if (proyecto.xml==NULL) {
		return NULL;
	}
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cvs");
	activo=xmlGetProp(nodo,"activo");
	if (activo[0]=='0') {
		g_free(activo);
		return NULL;
	}
	g_free(activo);
	nodo=nodo->xmlChildrenNode;
	cvsroot=xmlNodeGetContent(nodo);
	return cvsroot;
}

gchar *pro_compresion_cvs(void)
{
	xmlNodePtr nodo;
	gchar *compresion;
	
	if (proyecto.xml==NULL) {
		return NULL;
	}
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cvs");
	compresion=xmlGetProp(nodo,"compresion");
	return compresion;
}

gchar *pro_modulo_cvs(void)
{
	xmlNodePtr nodo;
	gchar *modulo;
	gchar *activo;
	
	if (proyecto.xml==NULL) {
		return NULL;
	}
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cvs");
	activo=xmlGetProp(nodo,"activo");
	if (activo[0]=='0') {
		g_free(activo);
		return NULL;
	}
	g_free(activo);
	nodo=nodo->xmlChildrenNode->next;
	modulo=xmlNodeGetContent(nodo);
	return modulo;
}

gboolean pro_autoupdate_cvs(void)
{
	xmlNodePtr nodo;
	gchar *autoupdate;
	gchar *activo;
	
	if (proyecto.xml==NULL) {
		return FALSE;
	}
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cvs");
	activo=xmlGetProp(nodo,"activo");
	if (activo[0]=='0') {
		g_free(activo);
		return FALSE;
	}
	g_free(activo);
	autoupdate=xmlGetProp(nodo,"autoupdate");
	if (autoupdate[0]=='0') {
		return FALSE;
	} else {
		return TRUE;
	}
}

gboolean pro_autoaddremove_cvs(void)
{
	xmlNodePtr nodo;
	gchar *autoaddremove;
	gchar *activo;
	
	if (proyecto.xml==NULL) {
		return FALSE;
	}
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cvs");
	activo=xmlGetProp(nodo,"activo");
	if (activo[0]=='0') {
		g_free(activo);
		return FALSE;
	}
	g_free(activo);
	autoaddremove=xmlGetProp(nodo,"autoaddremove");
	if (autoaddremove[0]=='0') {
		return FALSE;
	} else {
		return TRUE;
	}
}

gboolean pro_cvs_activo(void)
{
	xmlNodePtr nodo;
	gchar *activo;
	
	if (proyecto.xml==NULL) {
		return FALSE;
	}
	nodo=buscar_nodo_xml(proyecto.xml->xmlRootNode,"cvs");
	activo=xmlGetProp(nodo,"activo");
	if (activo[0]=='0') {
		g_free(activo);
		return FALSE;
	}
	g_free(activo);
	return TRUE;
}
