/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void gen_salir(void)
{
	if (proyecto.xml != NULL) {
		gchar *nombre_proyecto_locale;
		gsize read, written;
		GError *error;

		//save the status of open tabs and line positions in the project file
		pro_update_open_tabs();
		nombre_proyecto_locale = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
		xmlSaveFile(nombre_proyecto_locale, proyecto.xml);
		g_free(nombre_proyecto_locale);
	}

	edit_cerrar();
	gla_free_glade_window_list();
	pref_cerrar();
	xmlFreeDoc(proyecto.xml);
	g_free(proyecto.archivo);
	if (texto_busqueda_actual != NULL)
		g_free(texto_busqueda_actual);
	g_free(pro_proyecto_cargar);
	gtk_main_quit();
}

void gen_cerrar_ventana(GtkWidget *widget)
{
	GtkWidget *ventana;
	
	ventana=gtk_widget_get_toplevel(widget);
	gtk_widget_hide(ventana);
}

void gen_anadir(gint destino)
{
	GtkTreeIter nodo_arbol;
	guint cont,cont2;
	gchar *dir_destino;
	gchar *archivo,*archivo_locale,*archivo_destino;
	gchar *prodir,*srcdir,*pixdir,*datadir,*docdir;
	GtkTreeIter iter,iter_destino;
	GtkTreeView *tree_view,*tree_view_destino;
	GtkTreeModel *tree_model;
	GtkListStore *list_store_destino;
	gboolean fin_lista;
	gsize read, written;
	GError *error;
	gchar *comando;
	gboolean copiar,repe;
	gchar *pregunta;
	gint tipo;
	GtkWidget *boton_cvs;
	gboolean add_cvs;
	gint destino_cvs;
	gboolean new_source;
	
	prodir=pro_prodir(LOCALE);
	srcdir=pro_srcdir(LOCALE);
	pixdir=pro_pixdir(LOCALE);
	datadir=pro_datadir(LOCALE);
	docdir=pro_docdir(LOCALE);

	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"file_list_treeview"));
	tree_model=gtk_tree_view_get_model(tree_view);
	boton_cvs=glade_xml_get_widget(add_files_ventana,"addremove_cvs_checkbutton");
	add_cvs=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(boton_cvs));

	dir_destino=NULL;
	tree_view_destino=NULL;
	destino_cvs=0;
	switch (destino) {
		case ADD_SOURCE:
			dir_destino=g_strdup_printf("%s/%s/",prodir,srcdir);
			tree_view_destino=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"sources_treeview"));
			destino_cvs=SOURCE;
			break;
		case ADD_PIXMAP:
			dir_destino=g_strdup_printf("%s/%s/",prodir,pixdir);
			tree_view_destino=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"pixmaps_treeview"));
			destino_cvs=PIXMAP;
			break;
		case ADD_DATA:
			dir_destino=g_strdup_printf("%s/%s/",prodir,datadir);
			tree_view_destino=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"data_treeview"));
			destino_cvs=DATA;
			break;
		case ADD_DOC:
			dir_destino=g_strdup_printf("%s/%s/",prodir,docdir);
			tree_view_destino=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"docs_treeview"));
			destino_cvs=DOC;
			break;
	}
	list_store_destino=GTK_LIST_STORE(gtk_tree_view_get_model(tree_view_destino));
	
	if (!gtk_tree_model_get_iter_first(tree_model,&iter)) {
		g_free(prodir);
		g_free(srcdir);
		g_free(pixdir);
		g_free(datadir);
		g_free(docdir);
		g_free(dir_destino);
		return;
	}
	fin_lista=FALSE;
	
	new_source=FALSE;
	while (!fin_lista) {
		gtk_tree_model_get(tree_model,&iter,0,&archivo,-1);
		archivo_locale=g_locale_from_utf8(archivo,-1,&read,&written,&error);
		for (cont=0;archivo_locale[cont]!=0;cont++);
		for (;archivo_locale[cont]!='/';cont--);
		cont++;
		for (cont2=0;archivo[cont2]!=0;cont2++);
		for (;archivo[cont2]!='/';cont2--);
		cont2++;
		archivo_destino=g_strdup_printf("%s%s",dir_destino,archivo_locale+cont);
		
		copiar=TRUE;
		repe=FALSE;
		if (gen_existe_fichero(archivo_destino)) {
			repe=TRUE;
			if (strcmp(archivo_locale,archivo_destino)) {
				pregunta=g_strdup_printf(_("%s allready exist in the destination directory. Do you want to overwrite it?"),archivo+cont2);
				if (!gen_ventana_confirmacion(pregunta,GTK_BUTTONS_YES_NO)) {
					copiar=FALSE;
				}
				g_free(pregunta);
			}
		}
		if (copiar) {
			if (strcmp(archivo_locale,archivo_destino)) {
				comando=g_strdup_printf("cp %s %s 2> /dev/stdout\n",archivo_locale,dir_destino);
				gen_comando(comando,NULL);
				g_free(comando);
			}
			if (!repe) {
				gtk_list_store_append(list_store_destino,&iter_destino);
				gtk_list_store_set(list_store_destino,&iter_destino,0,archivo+cont2,-1);
			}
			
			if (add_cvs) {
				g_printerr("reconocemos correctamente el boton\n");
				cvs_add(archivo+cont2,destino_cvs);
			}

			// si se trata de un archivo de codigo hay que aadirlo al proyecto
			if (destino==ADD_SOURCE) {
				tipo=gen_tipo_archivo(archivo_locale+cont);
				if ((tipo==1) || (tipo==2)) {
					if (!pro_existe_archivo(archivo+cont2)) {
						arch_anadir(archivo+cont2,&nodo_arbol);
						edit_anadir(archivo,&nodo_arbol);
						pro_anadir(archivo+cont2);
						new_source=TRUE;
					} else {
						// si el archivo ya forma parte del proyecto habra que recargarlo, pero no aadirlo.
						cefv_eliminar_archivo(archivo+cont2);
						edit_recargar_archivo(archivo+cont2);
					}
				}
			}
		}
		fin_lista=!gtk_tree_model_iter_next(tree_model,&iter);
		g_free(archivo);
		g_free(archivo_locale);
		g_free(archivo_destino);
	}
	gtk_list_store_clear(GTK_LIST_STORE(tree_model));
	if (new_source) {
		pro_guardar();
	}

	g_free(prodir);
	g_free(srcdir);
	g_free(pixdir);
	g_free(datadir);
	g_free(docdir);
	g_free(dir_destino);

}

guint gen_comando(gchar *comando, gchar *mensaje)
{
	FILE *tuberia;
	guint salida;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;
	gsize bytes_read, bytes_written;
	GError *error;
	gboolean result =FALSE;
	const gchar *punto_malo;
	G_CONST_RETURN char *locale;
	
	DEBUG_MSG(->gen_comando);
	gen_limpiar_mensajes();
	if (mensaje!=NULL) {
		g_print("%s",mensaje);
	} else {
		g_print("%s",comando);
	}
	tuberia=popen(comando,"r");
	temporal=NULL;
	cadena=NULL;
	do {
		gen_refrescar();
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
			if (letra=='\n') {
				if (gen_es_salida_grep(cadena)) {
					result = g_utf8_validate(temporal, -1, &punto_malo);
					if (!result) {
						temporal = cadena;
						g_get_charset(&locale);
						cadena = g_convert(temporal, strlen(temporal), "UTF-8", locale, &bytes_read, &bytes_written, &error);
						g_free(temporal);
					}
					g_printerr("%s",cadena);
				} else {
					result = g_utf8_validate(temporal, -1, &punto_malo);
					if (!result) {
						temporal = cadena;
						g_get_charset(&locale);
						cadena = g_convert(temporal, strlen(temporal), "UTF-8", locale, &bytes_read, &bytes_written, &error);
						g_free(temporal);
					}
					g_print("%s",cadena);
				}
				g_free(cadena);
				temporal=NULL;
				cadena=NULL;
			}
		}
	} while (mas);	
	if (cadena!=NULL) {
		g_free(cadena);
	}
	salida=pclose(tuberia);
	DEBUG_MSG(<-gen_comando);
	return salida;
}

void gen_nuevo(GtkWidget *widget)
{
	GtkWidget *ventana,*boton_cvs;
	GtkEditable *entrada;
	gchar *nombre;
	gchar *archivo, *archivo_utf8;
	GtkTreeIter nodo_arbol;
	gchar *cabecera;
	gchar *defines;
	gchar *header;
	FILE *file;
	gint tipo;
	gint cont;
	gboolean todos_creados;
	gboolean guardar;
	gboolean add_cvs;
	gsize read, written;
	GError *error;
	
	DEBUG_MSG(->gen_nuevo);
	guardar=FALSE;
	ventana=gtk_widget_get_toplevel(widget);
	entrada=GTK_EDITABLE(glade_xml_get_widget(nuevo_ventana,"nuevo_entrada"));
	boton_cvs=glade_xml_get_widget(nuevo_ventana,"add_nuevo_checkbutton");
	add_cvs=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(boton_cvs));
	nombre=gtk_editable_get_chars(entrada,0,-1);
	
	do {
		todos_creados=TRUE;
		tipo=gen_tipo_archivo(nombre);
		if (!edit_repetido(nombre)) {
			DEBUG_MSG(el archivo no existe);
			archivo=pro_nombre_completo_archivo(nombre,FALSE, LOCALE);
			cabecera=pro_cabecera_gnu();
			if ((cabecera!=NULL) && (tipo!=0)) {
				file=fopen(archivo,"a+");
				fwrite(cabecera,1,strlen(cabecera),file);
				fclose(file);
				g_free(cabecera);
			}
			if ((tipo==2) && (pro_defines())) {
				header=g_strdup(nombre);
				for (cont=0;header[cont]!=0;cont++) {
					if ((header[cont]>='a') && (header[cont]<='z')) {
						header[cont]=header[cont]-32;
					}
					if (header[cont]=='.') {
						header[cont]='_';
					}
				}
				defines=g_strdup_printf("#ifndef %s\n#define %s\n\n\n\n#endif\n",header,header);
				file=fopen(archivo,"a+");
				fwrite(defines,1,strlen(defines),file);
				fclose(file);
				g_free(defines);
				g_free(header);
			}
			arch_anadir(nombre,&nodo_arbol);
			archivo_utf8 = g_locale_to_utf8(archivo, -1, &read, &written, &error);
			edit_anadir(archivo_utf8,&nodo_arbol);
			g_free(archivo_utf8);
			g_free(archivo);
			pro_anadir(nombre);
			guardar=TRUE;
			gen_cerrar_ventana(widget);
			if (add_cvs) {
				cvs_add(nombre,SOURCE);
			}
		} else {
			gen_ventana_mensaje(_("A file with that name already exists."), GTK_MESSAGE_INFO);
		}
		if ((pro_crear_h()) && (tipo==1)) {
			todos_creados=FALSE;
			for (cont=0;nombre[cont]!='.';cont++);
			nombre[cont+1]='h';
			nombre[cont+2]=0;
		}
	} while (!todos_creados);
	if (guardar) {
		pro_guardar();
	}
	g_free(nombre);
	DEBUG_MSG(<-gen_nuevo);
}

guint gen_tipo_archivo(gchar *nombre)
{
	// 0=otros, 1=fuentes, 2=cabeceras
	
	guint cont;
	
	for (cont=0;(nombre[cont]!='.') && (nombre[cont]!=0);cont++);
	if (nombre[cont]==0) {
		return 0;
	}
	cont++;
	if (!g_strcasecmp(nombre+cont,"c")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"cpp")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"c++")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"cc")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"h")) {
		return 2;
	}
	if (!g_strcasecmp(nombre+cont,"hh")) {
		return 2;
	}
	return 0;
}

void gen_ayuda(enum e_ayuda ayuda)
{
	GError *error;
	gchar *archivo;
	
	error=NULL;

	archivo=g_strdup(preferencias.ayuda[ayuda]);
	if ((archivo!=NULL) && (archivo[0]!=0)) {
		gnome_help_display_uri(archivo,&error);
		if (error!=NULL) {
			g_printerr("%s\n",error->message);
			g_error_free(error);
		}
	}
}

void gen_eliminar(void)
{
	if (edit_actual!=NULL) {
		if (pro_autoaddremove_cvs()) {
			cvs_remove(edit_actual->nombre,SOURCE);
		}
		arch_eliminar(edit_actual->nombre);
		pro_eliminar(edit_actual->nombre);
		cefv_eliminar_archivo(edit_actual->nombre);
		edit_eliminar(edit_actual->nombre);
	}
}

void gen_cargar_proyecto(void)
{
	GtkWidget *combo;
	xmlNodePtr xmlnode;
	GtkTreeIter nodo_arbol;
	gchar *nombre;
	gchar *archivo;
	GtkTreeView *tree_view;
	gchar *glade_file, *name;
	gint retorno;
		
	DEBUG_MSG(->gen_cargar_proyecto);
	
	arch_crear();
	cefv_crear();
	
	edit_aplicar_reglas_coloreado(edit_funciones_buffer);
	
	xmlnode=NULL;
	do {
		nombre=pro_fuentes(&xmlnode, UTF8);
		if (nombre!=NULL) {
			archivo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
			arch_anadir(nombre,&nodo_arbol);
			edit_anadir(archivo,&nodo_arbol);
			g_free(nombre);
			g_free(archivo);
		}
	} while (nombre!=NULL);
	
	xmlnode=NULL;
	do {
		nombre=pro_cabeceras(&xmlnode, UTF8);
		if (nombre!=NULL) {
			archivo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
			arch_anadir(nombre,&nodo_arbol);
			edit_anadir(archivo,&nodo_arbol);
			g_free(nombre);
			g_free(archivo);
		}
	} while (nombre!=NULL);
	
	cefv_congelar_lista_combo=TRUE;
	xmlnode=NULL;
	do {
		nombre=pro_otros(&xmlnode, UTF8);
		if (nombre!=NULL) {
			archivo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
			arch_anadir(nombre,&nodo_arbol);
			edit_anadir(archivo,&nodo_arbol);
			g_free(nombre);
			g_free(archivo);
		}
	} while (nombre!=NULL);
	
	if (cefv_lista_combo!=NULL) {
		combo=glade_xml_get_widget(david_ventana,"funciones_combo");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo),cefv_lista_combo);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"");
		cefv_congelar_lista_combo=FALSE;
	}

	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"archivos_arbol"));
	gtk_tree_view_expand_all(tree_view);
	
	//Init the GUI tab treeview
	gla_free_glade_window_list();
	glade_window_list = NULL;
	if (gui_store != NULL)
		gtk_tree_store_clear(gui_store);
	name = pro_glade_file(UTF8);
	if (name != NULL)
		project_has_glade_file = TRUE;
	else
		project_has_glade_file = FALSE;
	if (project_has_glade_file == TRUE) {
		//parse the contents of the glade file
		glade_file = pro_nombre_completo_archivo(name, FALSE, UTF8);
		retorno = gla_create_glade_window_list(glade_file);
		if (retorno == 0)
			gla_gui_treeview_populate();

		glade_widget_list = NULL;
		glade_widget_list_last_widget = NULL;
		
		gla_parse_glade_project_file (glade_file);
		g_free(name);
		g_free(glade_file);
	}
	
	DEBUG_MSG(<-gen_cargar_proyecto);
}

void gen_recargar(void)
{
	
	gchar *nombre_proyecto,*nombre_temp;
	gchar *nombre_proyecto_locale;
	gsize read, written;
	GError *error;

	DEBUG_MSG(->gen_recargar);
	if (proyecto.xml != NULL) {
		//save the status of open tabs and line positions in the project file
		pro_update_open_tabs();
		nombre_proyecto_locale = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
		xmlSaveFile(nombre_proyecto_locale, proyecto.xml);
		g_free(nombre_proyecto_locale);
		//and reload the project
		nombre_proyecto=pro_nombre(UTF8);
		nombre_temp=g_strdup_printf("%s.diasceprj",nombre_proyecto);
		g_free(nombre_proyecto);
		nombre_proyecto=pro_nombre_completo_archivo(nombre_temp,FALSE, UTF8);
		g_free(nombre_temp);
		// ahora recargamos el proyecto
		gen_abrir_proyecto(nombre_proyecto);
		g_free(nombre_proyecto);
		
	}
	DEBUG_MSG(<-gen_recargar);
}

void gen_limpiar(void)
{
	GtkLabel *etiqueta;
	GtkWidget *notebook;
	gint cont;
	GtkCombo *historico_funciones;
	GList *items = NULL;

	DEBUG_MSG(->gen_limpiar);
	gen_limpiar_mensajes();
	
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(edit_editor), GTK_TEXT_BUFFER(empty_buffer));
	gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_editor),TRUE);
	gtk_text_buffer_set_text(GTK_TEXT_BUFFER(edit_funciones_buffer),"",-1);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_editor),FALSE);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(edit_funciones),FALSE);
	notebook=glade_xml_get_widget(david_ventana,"archivos_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),0);
	for (cont=edit_total_pestanas;cont!=1;cont--) {
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),cont);
	}
	edit_total_pestanas=1;
	historico_funciones=GTK_COMBO(glade_xml_get_widget(david_ventana,"historico_funciones_combo"));
	items=g_list_append(items,"");		
	gtk_combo_set_popdown_strings(historico_funciones,items);
	gtk_entry_set_text(GTK_ENTRY(historico_funciones->entry),"");

	etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"editor_etiqueta"));
	gtk_label_set(etiqueta,_("Files"));
	etiqueta=GTK_LABEL(glade_xml_get_widget(david_ventana,"fila_etiqueta"));
	gtk_label_set(etiqueta,_("Row: 0  Colum:0"));
	edit_mensaje("");
	if (proyecto.xml!=NULL) {
		xmlFreeDoc(proyecto.xml);
		edit_cerrar();
		gla_free_glade_window_list();
		if (gui_store != NULL)
			gtk_tree_store_clear (gui_store);
		g_free(proyecto.archivo);
	}
	if (proyecto.xml_viejo!=NULL) {
		xmlFreeDoc(proyecto.xml_viejo);
	}
	pro_inicializar();
	edit_inicializar();
	buscar_inicializar();
	lista_cefv=NULL;
	DEBUG_MSG(<-gen_limpiar);
}

void gen_crear_proyecto(GtkWidget *widget)
{
	gen_limpiar();
	pro_crear();
	pro_actualizar(widget);
	arch_crear();
	cefv_crear();
}

void gen_abrir_proyecto(gchar *nombre)
{
	GtkWidget *menu, *widget;
	xmlNodePtr nodo,nodonuevo;
	gint cont;
	gchar *ultimo;
	gint retorno;
	
	DEBUG_MSG(->gen_abrir_proyecto);
	
	gen_limpiar();
	proyecto.archivo=g_strdup(nombre);
	retorno = pro_abrir();
	if (retorno == 0) {
		nodo=buscar_nodo_xml(preferencias.xml->xmlRootNode, "ultimos");
		nodonuevo=xmlNewNode(NULL,"ultimo");
		nodonuevo->parent=nodo;
		nodonuevo->next=nodo->xmlChildrenNode;
		nodo->xmlChildrenNode=nodonuevo;
		if (nodonuevo->next!=NULL) {
			nodonuevo->next->prev=nodonuevo;
		}
		xmlNodeSetContent(nodonuevo,proyecto.archivo);
		/*Creamos un menuitem para este ultimo proyecto en el menu File*/
		/*Si es el primero, habra que poner el separador tambien*/
		if (separador_recientes == FALSE) {
			widget = gtk_menu_item_new();
			menu = glade_xml_get_widget(david_ventana, "new2");
			menu = menu->parent;
			gtk_menu_insert(GTK_MENU(menu), widget, PRIMER_PROYECTO_RECIENTE);
			gtk_widget_show(widget);
			//Como el separador solo hay que ponerlo una vez, activamos un flag 
			separador_recientes = TRUE;		
		}
		menu = glade_xml_get_widget(david_ventana, "new2");
		menu = menu->parent;
		widget = gtk_menu_item_new_with_label (proyecto.archivo);
		gtk_menu_insert(GTK_MENU(menu), widget,PRIMER_PROYECTO_RECIENTE);
		/*Le asociamos la callback... sera la misma para todos */
		g_signal_connect(G_OBJECT(widget), "activate",G_CALLBACK(gen_recent_project_open), NULL);
		gtk_widget_show(widget);
		cont=1;
		nodo=nodo->xmlChildrenNode;
		while (nodo->next!=NULL) {
			nodo=nodo->next;
			ultimo=xmlNodeGetContent(nodo);
			if (!strcmp(ultimo,proyecto.archivo)) {
				/*El proyecto ya existia entre los ultimos abiertos, asi que eliminamos el nodo viejo*/
				nodonuevo=nodo;
				nodo=nodo->prev;
				xmlUnlinkNode(nodonuevo);
				xmlFreeNode(nodonuevo);
				/*Quitamos el menuitem correspondiente del menu File*/
				/*Obtenemos el menuitem*/
				gtk_menu_set_active(GTK_MENU(menu), PRIMER_PROYECTO_RECIENTE+cont);
				widget = gtk_menu_get_active(GTK_MENU(menu));
				/*y lo eliminamos*/
				gtk_widget_destroy(widget);
				cont--;
			}
			g_free(ultimo);
			cont++;
		}
		if (cont==6) {
			xmlUnlinkNode(nodo);
			xmlFreeNode(nodo);
			/*Quitamos el menuitem correspondiente del menu File*/
			/*Obtenemos el menuitem*/
			gtk_menu_set_active(GTK_MENU(menu), PRIMER_PROYECTO_RECIENTE+cont);
			widget = gtk_menu_get_active(GTK_MENU(menu));
			/*y lo eliminamos*/
			gtk_widget_destroy(widget);
		}
		pref_guardar();
		pref_xml_struct();
		
		if (pro_autoupdate_cvs()) {
			cvs_update();
		}
		gen_cargar_proyecto();
		//And then we load the windows that were open when the project was closed.
		gen_load_stored_project_windows();
	} else {
		xmlFreeDoc(proyecto.xml);
		proyecto.xml=NULL;
		g_free(proyecto.archivo);
		proyecto.archivo=NULL;
		if (retorno == -1) {
			gen_ventana_mensaje(_("You are trying to open a DiaSCE1 project file. DiaSCE2 does not support DiaSCE1 project files.\n You'll have to make a new DiaSCE2 project."),
				GTK_MESSAGE_WARNING);
		} else {
			gen_ventana_mensaje(_("The selected file is not a valid DiaSCE2 project."), GTK_MESSAGE_INFO);
		}
	}
	DEBUG_MSG(<-gen_abrir_proyecto);
}

void gen_mensajes_stderr(gchar *mensaje)
{
	GtkTextView *mensajes;
	GtkTextIter start_iter, end_iter;
	GtkTextBuffer *buffer;
	
	mensajes=GTK_TEXT_VIEW(glade_xml_get_widget(david_ventana,"mensajes_texto"));
	buffer=gtk_text_view_get_buffer(mensajes);
	
	//we add the text at the end of the buffer always
	gtk_text_buffer_get_bounds(buffer, &start_iter, &end_iter);
	gtk_text_buffer_insert_with_tags_by_name(buffer, &end_iter, mensaje, -1,"mensaje_error",NULL);
}

void gen_mensajes_stdout(gchar *mensaje)
{
	GtkTextView *mensajes;
	GtkTextIter start_iter,end_iter;
	GtkTextBuffer *buffer;
	
	mensajes=GTK_TEXT_VIEW(glade_xml_get_widget(david_ventana,"mensajes_texto"));
	buffer=gtk_text_view_get_buffer(mensajes);

	//we add the text at the end of the buffer always
	gtk_text_buffer_get_bounds(buffer, &start_iter, &end_iter);
	gtk_text_buffer_insert(buffer, &end_iter, mensaje, -1);
	gtk_text_view_scroll_mark_onscreen(mensajes,gtk_text_buffer_get_insert(buffer));
}

void gen_limpiar_mensajes(void)
{
	GtkTextView *mensajes;
	GtkTextIter start_iter, end_iter;
	GtkTextBuffer *buffer;
	
	mensajes=GTK_TEXT_VIEW(glade_xml_get_widget(david_ventana,"mensajes_texto"));
	buffer=gtk_text_view_get_buffer(mensajes);
	gtk_text_buffer_get_bounds(buffer, &start_iter, &end_iter);
	gtk_text_buffer_delete(buffer, &start_iter, &end_iter);
}

gboolean gen_existe_fichero(gchar *nombre)
{
	FILE *archivo;
	gchar *nombre_locale;
	gsize read, written;
	GError *error;
	
	nombre_locale = g_locale_from_utf8(nombre, -1, &read, &written, &error);
	archivo=fopen(nombre_locale,"r");
	g_free(nombre_locale);
	if (archivo==NULL) {
		return FALSE;
	} else {
		fclose(archivo);
		return TRUE;
	}
}

void gen_anular_funciones(void)
{
	GtkWidget *widget;
	
	if (!ejecutables.lpr) {
		widget=glade_xml_get_widget(david_ventana,"imprimir_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"imprimir1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("lpr was not found in your path, you will need it to print with DiaSCE\n"));
	}
	if (!ejecutables.grep) {
		g_printerr(_("grep was not found in your path, you will need it to search in multiple files\n"));
	}
	if (!ejecutables.gcc) {
		widget=glade_xml_get_widget(david_ventana,"compilar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"compile1");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"make_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"make1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("gcc was not found in your path, you will need it to compile with DiaSCE\n"));
	}
	if (!ejecutables.gdb) {
		widget=glade_xml_get_widget(david_ventana,"ddd_button");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"ddd1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("gdb was not found in your path, you will need it to debug with DiaSCE\n"));
	}
	if (!ejecutables.ddd) {
		widget=glade_xml_get_widget(david_ventana,"ddd_button");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"ddd1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("ddd was not found in your path, you will need it to debug with DiaSCE\n"));
	}
	if (!ejecutables.glade) {
		widget=glade_xml_get_widget(david_ventana,"glade_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"glade1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("glade was not found in your path, you will nedd it do create GUIs with a graphic enviroment with DiaSCE\n"));
	}
	if (!ejecutables.ctags) {
		widget=glade_xml_get_widget(david_ventana,"abrir_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"project1");
		gtk_widget_set_sensitive(widget,FALSE);
		//widget=glade_xml_get_widget(david_ventana,"abrir1");
		//gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"nuevo1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("ctags was not found in your path, you will need it for DiaSCE to work properly\n"));
	}
	if (!ejecutables.memprof) {
		widget=glade_xml_get_widget(david_ventana,"memprof_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"memprof2");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("MemProf was not found in your path\n"));
	}
	if (!ejecutables.gnome_terminal) {
		widget=glade_xml_get_widget(david_ventana,"ejecutar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"run1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("GnomeTerminal was not found in your path, you will need it to run your executable from DiaSCE\n"));
	}
	if (!ejecutables.make) {
		widget=glade_xml_get_widget(david_ventana,"ejecutar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"run1");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"make_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=glade_xml_get_widget(david_ventana,"make1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("make was not found in your path, you will need it to compile with DiaSCE\n"));
	}
}

/*****************************************************************************************************************
Esta funcion es la encargada de aadir en el menu "File" la lista con los ultimos proyectos abiertos,
para un acceso mas rapido a ellos
*****************************************************************************************************************/
void gen_ultimos_proyectos (void)
{
	xmlNodePtr nodo;
	gchar *recent;
	GtkWidget *widget, *menu;
	int i = 0;
	
	menu=NULL;
	/* Nos posicionamos en el nodo "ultimos" del fichero .diasce2. Los children de este nodo contienen
	los ultimos proyectos abiertos*/
	nodo = buscar_nodo_xml (preferencias.xml->xmlRootNode, "ultimos");
	if (nodo != NULL) {
		/*nos situamos en el primer child*/
		nodo = nodo->xmlChildrenNode;
		/*si hay alguno, aadimos un separator primero*/
		if (nodo != NULL) {
			widget = gtk_menu_item_new();
			menu = glade_xml_get_widget(david_ventana, "new2");
			menu = menu->parent;
			gtk_menu_insert(GTK_MENU(menu), widget, PRIMER_PROYECTO_RECIENTE);
			gtk_widget_show(widget);
			//Como el separador solo hay que ponerlo una vez, activamos un flag 
			separador_recientes = TRUE;		
		} else {
			separador_recientes = FALSE;
		}
		while (nodo != NULL) {
			recent = xmlNodeGetContent (nodo);
			/*Creamos un nuevo menuitem, cuya label es el nombre de uno de los ultimos proyectos abiertos*/
			widget = gtk_menu_item_new_with_label (recent);
			gtk_menu_insert(GTK_MENU(menu), widget,PRIMER_PROYECTO_RECIENTE+i);
			/*Le asociamos la callback... sera la misma para todos */
			g_signal_connect(G_OBJECT(widget), "activate",G_CALLBACK(gen_recent_project_open), NULL);
			gtk_widget_show(widget);
			g_free(recent);
			nodo = nodo->next;
			i = i+1;
		}
	}
}

/*****************************************************************************************
Funcion encargada de abrir un proyecto reciente. Esta asociada a los menuitems
de ultimos proyectos, en el menu File. Recoge el label del menuitem que le ha llamado
en user_data y abre el proyecto indicado por ese label.
*****************************************************************************************/
void gen_recent_project_open (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	gchar *archivo;
	gint ret;
	gchar *nombre_proyecto_locale;
	gsize read, written;
	GError *error;
	
	DEBUG_MSG(->gen_recent_project_open);
	
	archivo=NULL;
	
	if (GTK_BIN(menuitem)->child) {
		GtkWidget *child = GTK_BIN(menuitem)->child;
		if (GTK_IS_LABEL(child)) {
			const gchar *text;
		
			text=gtk_label_get_text(GTK_LABEL(child));
			archivo = g_strdup (text);	
			g_print("%s\n",archivo);
		}
		if (edit_comprobar_perdida_datos()) {
			g_free(pro_proyecto_cargar);
			pro_proyecto_cargar=g_strdup(archivo);
			ventana = gen_create_perdidas_ventana();
			ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
			switch (ret) {
				case 0: //Boton "si"
					if (proyecto.xml != NULL) {
						//save the status of open tabs and line positions in the project file
						pro_update_open_tabs();
						nombre_proyecto_locale = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
						xmlSaveFile(nombre_proyecto_locale, proyecto.xml);
						g_free(nombre_proyecto_locale);
					}
					gen_abrir_proyecto(archivo);
					break;
				case 1: //Boton "no"
					break;
				default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
					break;
			}
			//Creo que no hace falta
			//gtk_widget_hide(ventana); 
		} else {
			if (proyecto.xml != NULL) {
				//save the status of open tabs and line positions in the project file
				pro_update_open_tabs();
				nombre_proyecto_locale = g_locale_from_utf8(proyecto.archivo, -1, &read, &written, &error);
				xmlSaveFile(nombre_proyecto_locale, proyecto.xml);
				g_free(nombre_proyecto_locale);
			}
			gen_abrir_proyecto(archivo);
		}
		g_free (archivo);
	}
	DEBUG_MSG(<-gen_recent_project_open);
}

gboolean gen_es_salida_grep(gchar *salida)
{
	int cont,dos_puntos,cont1,cont2;
	gboolean es_salida_grep;
	
	cont=0;
	cont1=0;
	cont2=0;
	dos_puntos=0;
	while (salida[cont]!='\n') {
		if (salida[cont]==':') {
			dos_puntos++;
			if (dos_puntos==1) cont1=cont;
			if (dos_puntos==2) cont2=cont;
		}
		cont++;
	}

	es_salida_grep=FALSE;
	if (dos_puntos==2) {
		es_salida_grep=TRUE;
		for (cont=cont1+1;cont<cont2;cont++) {
			if ((salida[cont]<'0') || (salida[cont]>'9')) es_salida_grep=FALSE;
		if (salida[cont2+1]=='\n') es_salida_grep=FALSE;
		}
	};
	return es_salida_grep;
}

/**********************************************************************************************
* Esta funcion crea la ventana que indica al usuario que hay ficheros modificados   *
* sin guardar y que si continua se perderan esos datos. Muestra la lista de ficheros  *
* modificados que no han sido guardados, y devuelve un puntero a la ventana        *
* que luego podra ser mostrada con una llamada a gnome_run_dialog                     *
***********************************************************************************************/
GtkWidget *gen_create_perdidas_ventana (void)
{
	GtkWidget *widget;
	struct s_lista_archivos *nodo;
	gchar *archivos_modificados, *tmp, *mensaje;

	//Primero creamos una cadena que contenga una lista de los archivos modificados
	//que no han sido guardados
	archivos_modificados = g_strdup("");
	nodo = raiz_lista_archivos;
	while (nodo != NULL) {
		if (gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(nodo->datos))) {
			tmp = g_strdup(archivos_modificados);
			g_free(archivos_modificados);
			archivos_modificados = g_strconcat (tmp,nodo->nombre,"\n",NULL);
			g_free(tmp);
		}
		nodo = nodo->siguiente;
	}
	//Generamos el mensaje
	mensaje = g_strconcat(
		_("Warning! The following files have unsaved changes:\n\n"), 
		archivos_modificados,
		_("\nIf you continue, data will be lost.\n\nDo you still want to continue?\n"),
		NULL); 
	//una vez que tenemos la lista, generamos la ventana con el mensaje:
	widget = gnome_message_box_new(
		mensaje, 
		GNOME_MESSAGE_BOX_WARNING,
		GNOME_STOCK_BUTTON_YES,
		GNOME_STOCK_BUTTON_NO,
		NULL);
	g_free(archivos_modificados);
	g_free(mensaje);
	//y retornamos un puntero a la ventana
	return widget;
}

/**********************************************************************************
 * esta funcion hace que se atiendan a los eventos pendientes antes de *
 * devolver el control a gtk_main(). De esta forma se puede refrescar la   *
 * pantalla en sitios donde se retenga el control de programa durante      *
 * mucho timepo, como durante la compilacion.                                     *
 **********************************************************************************/
void gen_refrescar(void)
{
	while (gtk_events_pending()) {
		gtk_main_iteration();
	}
}

/**********************************************************************************
 esta funcion sera colgada de la seal CHILD para que haga un wait
 cada vez que un hijo muera. De esta forma se evita que aparezcan
 como "zombi"
 **********************************************************************************/
void gen_hijo_muerto(void)
{
	wait(NULL);
	signal(SIGCHLD,(void *)gen_hijo_muerto);
}

/********************************************************************************************
This function creates the GUI of DiaSCE using Libglade. The code editor widget and
the function editor widget are added manually because we tryed putting them in glade
and they did not work correctly
*********************************************************************************/
gint gen_create_david_gui(void)
{
	GtkWidget *editor_texto, *funciones_texto, *mensajes_texto;
	GtkWidget *scrolledwindow;
	GtkWidget *funciones_vbox, *editor_vbox;
	GtkTextBuffer *buffer;
	FILE *fichero;
	
	fichero = fopen (GLADE_PROJECT, "r");
	if (fichero == NULL) {
		return -1;
	} else {
		fclose(fichero);
	}
	
	david_ventana = glade_xml_new(GLADE_PROJECT,"david_ventana",NULL);
	glade_xml_signal_autoconnect(david_ventana);
	
	proyecto_ventana = glade_xml_new(GLADE_PROJECT,"proyecto_ventana",NULL);
	glade_xml_signal_autoconnect(proyecto_ventana);
	
	preferencias_ventana = glade_xml_new(GLADE_PROJECT,"preferencias_ventana",NULL);
	glade_xml_signal_autoconnect(preferencias_ventana);
	
	archivos_arbol_menu = glade_xml_new(GLADE_PROJECT,"archivos_arbol_menu",NULL);
	glade_xml_signal_autoconnect(archivos_arbol_menu);

	editor_menu = glade_xml_new(GLADE_PROJECT,"editor_menu",NULL);
	glade_xml_signal_autoconnect(editor_menu);

	buscar_ventana = glade_xml_new(GLADE_PROJECT,"buscar_ventana",NULL);
	glade_xml_signal_autoconnect(buscar_ventana);

	nuevo_ventana = glade_xml_new(GLADE_PROJECT,"nuevo_ventana",NULL);
	glade_xml_signal_autoconnect(nuevo_ventana);

	autodetect_ventana = glade_xml_new(GLADE_PROJECT,"autodetect_ventana",NULL);
	glade_xml_signal_autoconnect(autodetect_ventana);
	
	preferencias.fuente=NULL;
	editor_vbox = glade_xml_get_widget(david_ventana,"editor_notebook_vbox");
	editor_texto = editor_texto_new(NULL,NULL,NULL,0,0);
	g_signal_connect (G_OBJECT (editor_texto), "enter_notify_event",G_CALLBACK(on_editor_texto_enter_notify_event),NULL);
	g_signal_connect (G_OBJECT (editor_texto), "button_press_event",G_CALLBACK(on_editor_texto_button_press_event),NULL);
	g_signal_connect (G_OBJECT (editor_texto), "key_press_event",G_CALLBACK(on_editor_texto_key_press_event),NULL);
	g_signal_connect_after (G_OBJECT (editor_texto), "key_press_event",G_CALLBACK(on_editor_texto_key_press_event_despues),NULL);
	scrolledwindow=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scrolledwindow),editor_texto);
	gtk_source_view_set_tab_stop(GTK_SOURCE_VIEW(editor_texto),preferencias.tabulador);
	gtk_container_add(GTK_CONTAINER(editor_vbox),scrolledwindow);
	gtk_widget_show(editor_texto);
	gtk_widget_show(scrolledwindow);
	//global variable that refers to the editor of the File Tab
	edit_editor = GTK_SOURCE_VIEW(editor_texto);
	
	funciones_vbox = glade_xml_get_widget(david_ventana,"funciones_notebook_vbox");
	funciones_texto = editor_texto_new(NULL,NULL,NULL,0,0);
	g_signal_connect (G_OBJECT (funciones_texto), "button_press_event",G_CALLBACK(on_editor_texto_button_press_event),NULL);
	scrolledwindow=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scrolledwindow),funciones_texto);
	gtk_source_view_set_tab_stop(GTK_SOURCE_VIEW(funciones_texto),preferencias.tabulador);
	gtk_container_add(GTK_CONTAINER(funciones_vbox),scrolledwindow);
	gtk_widget_show(funciones_texto);
	gtk_widget_show(scrolledwindow);
	//global variable that refers to the editor of the Function Tab
	edit_funciones = GTK_SOURCE_VIEW(funciones_texto);

	//mark_set callback for the message window
	mensajes_texto = glade_xml_get_widget (david_ventana, "mensajes_texto");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(mensajes_texto));
	g_signal_connect_after (G_OBJECT(buffer), "mark_set", G_CALLBACK(on_mensajes_texto_buffer_mark_set), NULL);

	return 0;
}

// This function is used to short the GtkTreeView.
// The user_data is used to tell the function in which colum is the label that has to be used.
gint gen_GtkTreeIterCompareFunc(GtkTreeModel *model,GtkTreeIter *a,GtkTreeIter *b,gpointer user_data)
{
	gchar *texto_a,*texto_b;
	gint comparacion;
	gint columna;
	GtkTreePath *path;
	
	columna=(gint)user_data;

	if (model==GTK_TREE_MODEL(arch_store)) {
		path=gtk_tree_model_get_path(model,a);
		if (path!=NULL) {
			if (gtk_tree_path_get_depth(path)==2) {
				gtk_tree_path_free(path);
				return 0;
			}
			gtk_tree_path_free(path);
		}
	}
	
	gtk_tree_model_get(model,a,columna,&texto_a,-1);
	gtk_tree_model_get(model,b,columna,&texto_b,-1);		

	if ((texto_a!=NULL) && (texto_b!=NULL)) {
		comparacion=strcasecmp(texto_a,texto_b);
	} else {
		comparacion=0;
	}
	
	g_free(texto_a);
	g_free(texto_b);
	
	return comparacion;
}

void gen_localizar_automake(void)
{	
	FILE *tuberia;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;
	gchar *prefix_end;
	gint cont1,cont2;

	DEBUG_MSG(->gen_localizar_automake);
	if ((!ejecutables.which) || (!ejecutables.automake)) {
		prefix_automake=g_strdup("/usr/share/automake");
		DEBUG_MSG(<-gen_localizar_automake 1);
		return;
	}

	tuberia=popen("which automake","r");
	temporal=NULL;
	cadena=NULL;
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
		}
	} while (mas);
	pclose(tuberia);
	
	prefix_end=strstr(cadena,"/bin/automake");
	if (prefix_end!=NULL) {
		prefix_end[0]=0;
		prefix_automake=g_strdup(cadena);
	} else{
		prefix_automake=g_strdup("/usr/share/automake");
		g_free(cadena);
		DEBUG_MSG(<-gen_localizar_automake 2);
		return;
	}
	
	// before we credate de prefix with the version number, we try with out it, just in case a distribution does not uses the version
	// nuber in the path of automake
	temporal=prefix_automake;
	prefix_automake=g_strdup_printf("%s/share/automake",temporal);
	g_free(temporal);
	temporal=g_strdup_printf("%s/INSTALL",prefix_automake);
	if (gen_existe_fichero(temporal)) {
		g_free(temporal);
		g_free(cadena);
		DEBUG_MSG(<-gen_localizar_automake 3);
		return;
	}
	g_free(temporal);
	g_free(prefix_automake);

	// If the is not a path without the version number, we modify the prefix.
	prefix_automake=g_strdup(cadena);
	g_free(cadena);

	tuberia=popen("automake --version","r");
	temporal=NULL;
	cadena=NULL;
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
		}
	} while (mas);
	pclose(tuberia);

	for (cont1=0;cadena[cont1]!='.';cont1++);
	cont2=cont1+1;
	while ((cadena[cont2]>='0') && (cadena[cont2]<='9')) {
		cont2++;
	}
	cadena[cont2]=0;
	cont1--;
	while ((cadena[cont1]>='0') && (cadena[cont1]<='9')) {
		cont1--;
	}
	cont1++;
	temporal=prefix_automake;
	prefix_automake=g_strdup_printf("%s/share/automake-%s",temporal,cadena+cont1);
	g_free(temporal);
	
	g_free(cadena);
	DEBUG_MSG(<-gen_localizar_automake);
}

//This function restores the files that were open when the project was closed.
gint gen_load_stored_project_windows (void)
{
	typedef struct s_cargados {
		gchar *nombre;
		gint pestana;
		struct s_cargados *siguiente;	
	} s_cargados;
	
	xmlNodePtr node, children_node;
	struct s_cargados *cargados, *ultimo;
	gchar *pestana;
	gint i_pestana;
	gchar *sections[] = {"fuentes", "cabeceras", "otros"};
	gint i, ultima_pestana;
	GtkWidget *widget;

	cargados = NULL;
	ultimo = NULL;
	for (i = 0; i <3; i++) {
		node = buscar_nodo_xml(proyecto.xml->xmlRootNode, sections[i]);
		if (node != NULL) {
			children_node = node->xmlChildrenNode;
			if (children_node != NULL) {
				while (children_node != NULL) {
					pestana = xmlGetProp(children_node, "open");
					sscanf (pestana, "%d\n", &i_pestana);
					if (i_pestana != -1) {
						if (cargados == NULL) {
							cargados = g_malloc (sizeof(s_cargados));
							ultimo = cargados;
						} else {
							ultimo->siguiente = g_malloc(sizeof(s_cargados));
							ultimo = ultimo->siguiente;
						}
						ultimo->nombre = g_strdup(xmlNodeGetContent(children_node));
						ultimo->pestana = i_pestana;
						ultimo->siguiente = NULL;
					}
					children_node = children_node->next;
				}//end of while
			}
		}
	}
	// put each file in his tab
	ultima_pestana=2;
	if (cargados!=NULL) {
		ultimo=cargados;
		while (ultimo!=NULL) {
			if (ultimo->pestana==ultima_pestana) {
				edit_ver(ultimo->nombre);
				on_mover_a_pestana_nueva1_activate(NULL,NULL);
				ultimo=cargados;
				ultima_pestana++;
			} else {
				ultimo=ultimo->siguiente;
			}
		}
		ultimo=cargados;
		while (ultimo!=NULL) {
			if (ultimo->pestana==0) {
				edit_ver(ultimo->nombre);
			}
			ultimo=ultimo->siguiente;
		}
	}
	widget=glade_xml_get_widget(david_ventana,"archivos_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(widget),0);
	
	// delete the created list
	while (cargados!=NULL) {
		g_free(cargados->nombre);
		ultimo=cargados;
		cargados=cargados->siguiente;
		g_free(ultimo);
	}
	return 0;
}

/*************************************************************************************
 * This function  will create a message window only with a close button
 * the window will be modal
 * the options for tipo are:
 * GTK_MESSAGE_INFO			Informational message
 * GTK_MESSAGE_WARNING		Nonfatal warning message
 * GTK_MESSAGE_ERROR			Fatal error message
 ************************************************************************************/
void gen_ventana_mensaje(gchar *mensaje,GtkMessageType tipo)
{
	GtkWidget *dialog;
	GtkWindow *ventana;
	
	ventana=GTK_WINDOW(glade_xml_get_widget(david_ventana, "david_ventana"));
	dialog=gtk_message_dialog_new(ventana,GTK_DIALOG_DESTROY_WITH_PARENT,tipo,GTK_BUTTONS_CLOSE,mensaje);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
}

void gen_add_files_ventana(void)
{
	GtkListStore *files_store;
	GtkTreeView *tree_view;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeSelection *selection;
	GtkWidget *boton_cvs;
	GDir *directorio;
	GError **error;
	G_CONST_RETURN gchar *archivo;
	gchar *prodir,*srcdir,*pixdir,*datadir,*docdir;
	gchar *path;
	GtkTreeIter iter;
	
	if (proyecto.xml==NULL) return;
	
	error=NULL;
	
	prodir=pro_prodir(LOCALE);
	srcdir=pro_srcdir(LOCALE);
	pixdir=pro_pixdir(LOCALE);
	datadir=pro_datadir(LOCALE);
	docdir=pro_docdir(LOCALE);

	add_files_ventana = glade_xml_new(GLADE_PROJECT,"add_files_ventana",NULL);
	glade_xml_signal_autoconnect(add_files_ventana);

	boton_cvs=glade_xml_get_widget(add_files_ventana,"addremove_cvs_checkbutton");
	gtk_widget_set_sensitive(boton_cvs,pro_cvs_activo());
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(boton_cvs),pro_autoaddremove_cvs());

	//here we prepare the colum of the file list treeview
	files_store=gtk_list_store_new(1,G_TYPE_STRING);
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"file_list_treeview"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(files_store));
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(NULL,renderer,"text",0,NULL);
	gtk_tree_view_append_column(tree_view,column);
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_NONE);
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(files_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)0,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(files_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);

	//here we prepare the colum of the sources treeview
	files_store=gtk_list_store_new(1,G_TYPE_STRING);
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"sources_treeview"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(files_store));
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(_("Sources"),renderer,"text",0,NULL);
	gtk_tree_view_append_column(tree_view,column);
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_MULTIPLE);
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(files_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)0,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(files_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);

	//now we read the sources directory to show the contente in the sources colum. Just sorce files included in the project.
	path=g_strdup_printf("%s/%s",prodir,srcdir);
	directorio=g_dir_open(path,0,error);
	archivo=g_dir_read_name(directorio);
	while (archivo!=NULL) {
		if ((!g_file_test(archivo,G_FILE_TEST_IS_DIR)) && (archivo[0]!='.')) {
			if (pro_existe_archivo((gchar *)archivo)) {
				gtk_list_store_append(files_store,&iter);
				gtk_list_store_set(files_store,&iter,0,archivo,-1);
			}
		}
		archivo=g_dir_read_name(directorio);
	}
	g_dir_close(directorio);
	g_free(path);
		
	//here we prepare the colum of the pixmaps treeview
	files_store=gtk_list_store_new(1,G_TYPE_STRING);
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"pixmaps_treeview"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(files_store));
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(_("Pixmaps"),renderer,"text",0,NULL);
	gtk_tree_view_append_column(tree_view,column);
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_MULTIPLE);
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(files_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)0,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(files_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);

	//now we read the pixmaps directory to show the contente in the pixmaps colum
	path=g_strdup_printf("%s/%s",prodir,pixdir);
	directorio=g_dir_open(path,0,error);
	archivo=g_dir_read_name(directorio);
	while (archivo!=NULL) {
		if ((!g_file_test(archivo,G_FILE_TEST_IS_DIR)) && (archivo[0]!='.')) {
			gtk_list_store_append(files_store,&iter);
			gtk_list_store_set(files_store,&iter,0,archivo,-1);			
		}
		archivo=g_dir_read_name(directorio);
	}
	g_dir_close(directorio);
	g_free(path);
		
	//here we prepare the colum of the data treeview
	files_store=gtk_list_store_new(1,G_TYPE_STRING);
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"data_treeview"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(files_store));
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(_("Data"),renderer,"text",0,NULL);
	gtk_tree_view_append_column(tree_view,column);
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_MULTIPLE);
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(files_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)0,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(files_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);

	//now we read the data directory to show the contente in the data colum
	path=g_strdup_printf("%s/%s",prodir,datadir);
	directorio=g_dir_open(path,0,error);
	archivo=g_dir_read_name(directorio);
	while (archivo!=NULL) {
		if ((!g_file_test(archivo,G_FILE_TEST_IS_DIR)) && (archivo[0]!='.')) {
			gtk_list_store_append(files_store,&iter);
			gtk_list_store_set(files_store,&iter,0,archivo,-1);			
		}
		archivo=g_dir_read_name(directorio);
	}
	g_dir_close(directorio);
	g_free(path);
		
	//here we prepare the colum of the docs treeview
	files_store=gtk_list_store_new(1,G_TYPE_STRING);
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"docs_treeview"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(files_store));
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(_("Docs"),renderer,"text",0,NULL);
	gtk_tree_view_append_column(tree_view,column);
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_MULTIPLE);
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(files_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)0,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(files_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);
	
	//now we read the sources docs to show the contente in the docs colum
	path=g_strdup_printf("%s/%s",prodir,docdir);
	directorio=g_dir_open(path,0,error);
	archivo=g_dir_read_name(directorio);
	while (archivo!=NULL) {
		if ((!g_file_test(archivo,G_FILE_TEST_IS_DIR)) && (archivo[0]!='.')) {
			gtk_list_store_append(files_store,&iter);
			gtk_list_store_set(files_store,&iter,0,archivo,-1);			
		}
		archivo=g_dir_read_name(directorio);
	}
	g_dir_close(directorio);
	g_free(path);
		
	g_free(prodir);
	g_free(srcdir);
	g_free(pixdir);
	g_free(datadir);
	g_free(docdir);
}

void gen_anadir_a_lista(GtkWidget *widget)
{
	gchar **seleccion;
	guint cont;
	GtkTreeIter iter;
	GtkTreeView *tree_view;
	GtkListStore *list_store;
	
	seleccion=gtk_file_selection_get_selections(GTK_FILE_SELECTION(widget));
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(add_files_ventana,"file_list_treeview"));
	list_store=GTK_LIST_STORE(gtk_tree_view_get_model(tree_view));
	cont=0;
	while (seleccion[cont]!=NULL) {
		gtk_list_store_append(list_store,&iter);
		gtk_list_store_set(list_store,&iter,0,seleccion[cont],-1);
		cont++;
	}
	g_strfreev(seleccion);
	return;
}

/*************************************************************************************
 * This function  will create a message window with two buttons
 * the window will be modal
 * the options for botones are:
 * GTK_BUTTONS_YES_NO			Yes and No buttons
 * GTK_BUTTONS_OK_CANCEL	OK and Cancel buttons
 * It will return TRUE if YES or OK buttons are pressed, and FALSE in any
 * other case
 ************************************************************************************/
gboolean gen_ventana_confirmacion(gchar *mensaje,GtkButtonsType botones)
{
	GtkWidget *dialog;
	GtkWindow *ventana;
	gint respuesta;
	
	ventana=GTK_WINDOW(glade_xml_get_widget(david_ventana, "david_ventana"));
	dialog=gtk_message_dialog_new(ventana,GTK_DIALOG_DESTROY_WITH_PARENT,GTK_MESSAGE_QUESTION,botones,mensaje);
	respuesta=gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
	switch (respuesta) {
		case GTK_RESPONSE_OK:
		case GTK_RESPONSE_YES:
			return TRUE;
			break;
		default:
			return FALSE;
			break;
	}
}
