/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Esta funcion crea el arbol de archivos con las secciones vacias para
 que luego se vallan introduciendo los arcivos en cada seccion.
 *******************************************************************************/
void arch_crear(void)
{
	GtkCTree *ctree;
	char *texto1[1];
	char *texto2[]={_("Headers")};
	char *texto3[]={_("Sources")};
	char *texto4[]={_("Others")};

	DEBUG_MSG(->arch_crear);
	ctree=GTK_CTREE(lookup_widget(david_ventana,"archivos_arbol"));
	gtk_ctree_remove_node(ctree,NULL);
	texto1[0]=pro_nombre();
	arch_raiz=gtk_ctree_insert_node(ctree,NULL,NULL,texto1,3,pixmaps[PROYECTO],NULL,pixmaps[PROYECTO],NULL,FALSE,TRUE);
	arch_cabeceras=gtk_ctree_insert_node(ctree,arch_raiz,NULL,texto2,3,pixmaps[CABECERAS],NULL,pixmaps[CABECERAS],NULL,FALSE,TRUE);
	arch_fuentes=gtk_ctree_insert_node(ctree,arch_raiz,NULL,texto3,3,pixmaps[FUENTES],NULL,pixmaps[FUENTES],NULL,FALSE,TRUE);
	arch_otros=gtk_ctree_insert_node(ctree,arch_raiz,NULL,texto4,3,pixmaps[OTROS],NULL,pixmaps[OTROS],NULL,FALSE,TRUE);
	g_free(texto1[0]);
	DEBUG_MSG(<-arch_crear);
}

/*******************************************************************************
 Esta funcion aade un arcivo a la seccion del arbol de archivos correspondiente.
 Para colocar el archivo en usa seccion se basa en la externsion del archivo
 *******************************************************************************/
GtkCTreeNode *arch_anadir(gchar *nombre)
{
	guint tipo;
	gchar *texto[1];
	GtkCTree *ctree;
	GtkCTreeNode *nodo;

	DEBUG_MSG(->arch_anadir);
	nodo=NULL;
	ctree=GTK_CTREE(lookup_widget(david_ventana,"archivos_arbol"));
	texto[0]=nombre;
	tipo=gen_tipo_archivo(nombre);
	switch (tipo) {
		case 0:
			nodo=gtk_ctree_insert_node(ctree,arch_otros,NULL,texto,3,pixmaps[OTROS],NULL,pixmaps[OTROS],NULL,TRUE,FALSE);
			gtk_ctree_sort_node(ctree,arch_otros);
			break;
		case 1:
			nodo=gtk_ctree_insert_node(ctree,arch_fuentes,NULL,texto,3,pixmaps[FUENTES],NULL,pixmaps[FUENTES],NULL,TRUE,FALSE);
			gtk_ctree_sort_node(ctree,arch_fuentes);
			break;
		case 2:
			nodo=gtk_ctree_insert_node(ctree,arch_cabeceras,NULL,texto,3,pixmaps[CABECERAS],NULL,pixmaps[CABECERAS],NULL,TRUE,FALSE);
			gtk_ctree_sort_node(ctree,arch_cabeceras);
			break;
	};
	DEBUG_MSG(<-arch_anadir);
	return nodo;
}

/*******************************************************************************
 Esta funcion elimina una entrada del arbol de archivos
 *******************************************************************************/
void arch_eliminar(gchar *nombre)
{
	GtkCTree *ctree;
	struct s_lista_archivos *nodo;

	nodo=edit_conseguir_nodo(nombre);
	ctree=GTK_CTREE(lookup_widget(david_ventana,"archivos_arbol"));
	gtk_ctree_remove_node(ctree,nodo->nodo_arbol);
}
