/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/record_vectors.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] various sequences of @ref
 * ::diagnostics::Record s to test unittesting.
 *
 * @test none
 */


#ifndef DIAGNOSTICS__UTIL__RECORD_VECTORS_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__RECORD_VECTORS_TS_HPP__INCLUDE_GUARD

#include <diagnostics/frame/record.hpp>
#include <diagnostics/unittest/test_system/test_run_result.hpp>
#include <diagnostics/unittest.hpp>

#include <diagnostics/util/dummy_values_for_tid_pid.ts.hpp>

#include <vector>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

struct Record_Vector
{
    /**
     * @brief returns a vector of Records. These Records are used by
     * other tests as sample sequences of logged records.
     */
    virtual ::std::vector< ::diagnostics::Record> records()=0;

    /**
     * @brief checks whether a @ref Test_Run_Result @a t contains the
     * correct results under the assumption that it has been fed with
     * the records from @ref records(). @a logging has to be set to
     * true, iff the record sequence was filtered by a @ref
     * Test_Logger. @a target_level must be set to the used
     * target_level, i.e., it has to be equal @a t.target_level. This
     * is legacy, the redudency might be removed in the future.
     */
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level)=0;
    virtual ~Record_Vector() {}

    virtual Record_Vector* clone() const=0;
};


#if DIAGNOSTICS_SWITCH_SYSTEM_CALLS_ENABLED == 1
#  define CSTR_RECORD(STR_WHAT,LEVEL,TYPE) \
	  Record(LEVEL, \
		 TYPE, \
                 0, \
		 STR_WHAT,"base","file",1, \
		 ::diagnostics::testing::Dummy_Values_For_Pid::value2,\
         ::diagnostics::testing::Dummy_Values_For_Tid::value3,\
         1000,10000,"host" \
		 )
#else
#  define CSTR_RECORD(STR_WHAT,LEVEL,TYPE) \
	  Record(LEVEL, \
		 TYPE, \
                 0, \
		 STR_WHAT,"base","file",1 \
		 )
#endif

struct Empty_Trace_0sec_0usec 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};


////////////////////////////////////////////////////////////////////////////////

struct Empty_Trace_1sec_1usec_No_Carry 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};



////////////////////////////////////////////////////////////////////////////////

struct Empty_Trace_1sec_1usec_With_Carry 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};

////////////////////////////////////////////////////////////////////////////////

struct Trace_With_One_Failure 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};


////////////////////////////////////////////////////////////////////////////////

struct Trace_With_One_Invalidation 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};


////////////////////////////////////////////////////////////////////////////////

struct Trace_With_One_Failed_Check 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};

////////////////////////////////////////////////////////////////////////////////

struct Trace_With_All_Level_Type_Combinations 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
    
    static void inner_records(::std::vector< ::diagnostics::Record> & result);
};

////////////////////////////////////////////////////////////////////////////////

struct Trace_With_All_Level_Type_Combinations_Times_2 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};

////////////////////////////////////////////////////////////////////////////////

struct Trace_With_Two_Test_Case_Enter_Msgs 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};

////////////////////////////////////////////////////////////////////////////////

struct Trace_With_No_Test_Case_Enter 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};

////////////////////////////////////////////////////////////////////////////////

struct Trace_With_Two_Test_Case_Exits 
    : public Record_Vector
{
    virtual Record_Vector* clone() const;
    virtual ::std::vector< ::diagnostics::Record> records();
    virtual void check(::diagnostics::unittest::Test_Run_Result const & t,
		       bool const logging,
		       Level_t const target_level);
};

#undef PUSH_RECORD

TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif
// vim:ts=4:sw=4
