/* changenotehead.c
 * Changes the type of notehead if required
 * 
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) Adam Tee 2000, 2001, 2002
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "calculatepositions.h"
#include "contexts.h"
#include "dialogs.h"
#include "draw.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"
/**
 * Array of different Notehead types
 */
gchar *notehead[4] = { N_("Normal"), N_("Cross"), N_("Diamond"),
  N_("Harmonic")
};

struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *combo;
};

/**
 * Set the correct enum value for the selected 
 * notehead
 */
enum headtype
texttohead (gchar * text)
{
  if (g_strcasecmp (text, _("Normal")) == 0)
    return DENEMO_NORMAL_NOTEHEAD;
  else if (g_strcasecmp (text, _("Cross")) == 0)
    return DENEMO_CROSS_NOTEHEAD;
  else if (g_strcasecmp (text, _("Diamond")) == 0)
    return DENEMO_DIAMOND_NOTEHEAD;
  else if (g_strcasecmp (text, _("Harmonic")) == 0)
    return DENEMO_HARMONIC_NOTEHEAD;
  else
    return DENEMO_NORMAL_NOTEHEAD;
}


/**
 * Set current notes notehead to the selected 
 * value
 */
void
insertnotehead (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = (struct callbackdata *) data;
  struct scoreinfo *si = cbdata->si;
  mudelaobject *obj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  gchar *notehead_string =
    (gchar *)
    gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cbdata->combo)->entry));

  if (obj != NULL && obj->type == CHORD)
    {
      /* Lilypond's behavior is a bit anomalous here. It doesn't seem
       * to like giving chords non-standard noteheads. This is
       * just a default behavior for the time being. */
      ((note *) ((chord *) obj->object)->tones->data)->noteheadtype =
	texttohead (notehead_string);
    }
}

/**
 * Notehead selection dialog
 * Displays the notehead type in a Combobox
 * Callback - insert_notehead
 */
void set_notehead
  (gpointer callback_data, guint callback_action, GtkWidget * widget)
{
  struct scoreinfo *si = (struct scoreinfo *) callback_data;
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *combo;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  gint i;
  static GList *list = NULL;

  static struct callbackdata cbdata;

  if (!list)
    {
      for (i = 0; i < 4; i++)
	{
	  list = g_list_append (list, _(notehead[i]));
	}
    }

  dialog = gtk_dialog_new ();

  gtk_window_set_title (GTK_WINDOW (dialog), _("Change Notehead"));

  label = gtk_label_new (_("Select Notehead Type"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      label, TRUE, TRUE, 0);
  gtk_widget_show (label);

  combo = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), list);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), _(notehead[0]));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), combo,
		      TRUE, TRUE, 0);
  gtk_widget_show (combo);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
		      TRUE, TRUE, 0);
  cbdata.si = si;
  cbdata.combo = combo;
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (insertnotehead), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);
  gtk_widget_grab_focus (combo);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}
