/* keyresponses.h
 * function prototypes for responses to user keypresses
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "commandfuncs.h"
#include "datastructures.h"
#include "draw.h"
#include "selectops.h"


void scorearea_keypress_event (GtkWidget * widget, GdkEventKey * event,
			       gpointer data);

void adjust_measure_less_width_key (struct scoreinfo *si);
void adjust_measure_more_width_key (struct scoreinfo *si);
void adjust_staff_less_height_key (struct scoreinfo *si);
void adjust_staff_more_height_key (struct scoreinfo *si);
void unset_selection_key (struct scoreinfo *si);
void insert_chord_key (struct scoreinfo *si);
void go_to_A_key (struct scoreinfo *si);
void go_to_B_key (struct scoreinfo *si);
void go_to_C_key (struct scoreinfo *si);
void go_to_D_key (struct scoreinfo *si);
void go_to_E_key (struct scoreinfo *si);
void go_to_F_key (struct scoreinfo *si);
void go_to_G_key (struct scoreinfo *si);
void octave_up_key (struct scoreinfo *si);
void octave_down_key (struct scoreinfo *si);
void rest_toggle_key (struct scoreinfo *si);
void append_measure_key (struct scoreinfo *si);
void insert_measure_key (struct scoreinfo *si);
void change_duration_0key (struct scoreinfo *si);
void change_duration_1key (struct scoreinfo *si);
void change_duration_2key (struct scoreinfo *si);
void change_duration_3key (struct scoreinfo *si);
void change_duration_4key (struct scoreinfo *si);
void change_duration_5key (struct scoreinfo *si);
void change_duration_6key (struct scoreinfo *si);
void insert_chord_0key (struct scoreinfo *si);
void insert_chord_1key (struct scoreinfo *si);
void insert_chord_2key (struct scoreinfo *si);
void insert_chord_3key (struct scoreinfo *si);
void insert_chord_4key (struct scoreinfo *si);
void insert_chord_5key (struct scoreinfo *si);
void insert_chord_6key (struct scoreinfo *si);
void insert_rest_0key (struct scoreinfo *si);
void insert_rest_1key (struct scoreinfo *si);
void insert_rest_2key (struct scoreinfo *si);
void insert_rest_3key (struct scoreinfo *si);
void insert_rest_4key (struct scoreinfo *si);
void insert_rest_5key (struct scoreinfo *si);
void insert_rest_6key (struct scoreinfo *si);
void insert_tuplet_0key (struct scoreinfo *si);
void insert_tuplet_1key (struct scoreinfo *si);
void insert_tuplet_2key (struct scoreinfo *si);
void insert_tuplet_3key (struct scoreinfo *si);
void insert_tuplet_4key (struct scoreinfo *si);
void insert_tuplet_5key (struct scoreinfo *si);
void insert_tuplet_6key (struct scoreinfo *si);
void insert_tuplet_7key (struct scoreinfo *si);
void insert_tuplet_9key (struct scoreinfo *si);
void add_tone_key (struct scoreinfo *si);
void remove_tone_key (struct scoreinfo *si);
void backspace_key (struct scoreinfo *si);
void sharpen_key (struct scoreinfo *si);
void flatten_key (struct scoreinfo *si);
void tie_notes_key (struct scoreinfo *si);
void add_dot_key (struct scoreinfo *si);
void remove_dot_key (struct scoreinfo *si);
void insert_clone_key (struct scoreinfo *si);
void add_staccato(struct scoreinfo *si);
void add_fermata(struct scoreinfo *si);
void add_accent(struct scoreinfo *si);
void add_tenuto(struct scoreinfo *si);
void add_mordent(struct scoreinfo *si);
void add_turn(struct scoreinfo *si);
void add_trill(struct scoreinfo *si);
void add_staccatissimo(struct scoreinfo *si);
void set_grace(struct scoreinfo *si);
