#include "dec_prom.h"
#include "delo.h"

extern void *_edata;
extern void *_end;
void *malloc(int size);
const struct callback *callv;
int rex_prom = 0;

int main(int argc, char **argv, int magic, struct callback *cv ) {
	int			i,j,cargc;
	int			retval;
	void (*entry)(int argc, char **argv, int magic, void *cv);
	char	*configbuffer,
		**parray,
		**cargv,
		*kernel,
		partition[3],
		config[_MAX_CONFIG_NAME_LEN];

	/* Clear BSS - This is a non-prom memset */
	memset(_edata, 0x0, _end - _edata);

#if 0
	callv=(void *) 0xa0004c70;

	printf("cv %x\n",cv);
#endif

	/* FIXME We only check for REX but dont handle it right now */
	if (magic == DEC_REX_MAGIC) {
		/* Store Call Vector */
		callv=cv;
		rex_prom=1;
	} 

	puts("delo V0.7 Copyright 2000 Florian Lohoff <flo@rfc822.org>");	

#if DEBUG
	printf("callv addr %x\n",callv);
#endif

#ifdef DEBUG
	for(i=0;i<argc;i++) 
		printf("clo: %d %s\n",
				i,
				argv[i]);
#endif

	/*
	 * Boot command line will look like this:
	 *
	 * boot 3/rz0 5/vmlinux
	 *
	 * It might contain replacement argv stuff e.g
	 *
	 * boot 3/rz0 5/vmlinux root=/dev/sda5 console=ttyS2
	 *
	 * Now we dont use the config file args but the prom command line
	 *
	 */

	/* Initialize to empty partition name */
	partition[0]=0x0;
	/* Initialize to empty config name */
	config[0]=0x0;

	/* get partition name */
	if (argc >= 3) {

		for(i=0;i<strlen(argv[2]) && i < sizeof(partition);i++) {
			if (argv[2][i] <= '9' && argv[2][i] >= '0')
				partition[i]=argv[2][i];
			else
				break;
		}

		/* Set terminating 0x0 */
		partition[i]=0x0;

		/* Is there a slash ? */
		if (argv[2][i] == '/') {
			/* Copy config name */
			strncpy(config, &argv[2][i+1], _MAX_CONFIG_NAME_LEN);
		}
	}

	if (open_partition(partition)) {
		return;
	}

	if (!(configbuffer=readfile(_CONFIG_FILE))) {
		printf("Couldnt fetch config.file %s\n",_CONFIG_FILE);
		return;
	}

	if (!(parray=getconfig(configbuffer, config))) {
		printf("Couldnt find config %s\n", config);
		return;
	}

	/* Do we have parms on the prom command line ? */
	if (argc <= 3) {
		/* FIXME This is completely stupid to work around
		 * a kernel stupidity - Probably the kernel should not
		 * skip anything and/or check for existance of "boot"
		 * at the beginning and skip only if this is the case */
		if (rex_prom) 
			/*
			 * Copy pointer - We take 0 as the kernel
			 * will skip 2 parms anyway for REX so it doesnt
			 * care about our store usage
			 */
			cargv=&parray[0];
		else
			/*
			 * For non REX proms the kernel skips 1 arg
 			 */
			cargv=&parray[1];

		/* Count cargv values */
		for(cargc=0;cargv[cargc];cargc++);
	} else
		cargc=0;

#ifdef DEBUG
	for(i=0;i<cargc;i++) 
		printf("configargv: %d %s\n",
				i,
				cargv[i]);
#endif

	if (!(kernel=readfile(parray[1]))) {
		printf("Couldnt load kernel %s\n", parray[1]);
		return;
	}

	if (!(entry=copyelf(kernel))) {
		printf("Copying kernel failed\n");
		return;
	};

	if (cargc != 0)
		entry(cargc, cargv, magic, cv);
	else
		entry(argc, argv, magic, cv);

	return;
}
