/* BackendRackspace.c generated by valac 0.12.1, the Vala compiler
 * generated from BackendRackspace.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gnome-keyring.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_RACKSPACE (deja_dup_backend_rackspace_get_type ())
#define DEJA_DUP_BACKEND_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspace))
#define DEJA_DUP_BACKEND_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspaceClass))
#define DEJA_DUP_IS_BACKEND_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE))
#define DEJA_DUP_IS_BACKEND_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_RACKSPACE))
#define DEJA_DUP_BACKEND_RACKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspaceClass))

typedef struct _DejaDupBackendRackspace DejaDupBackendRackspace;
typedef struct _DejaDupBackendRackspaceClass DejaDupBackendRackspaceClass;
typedef struct _DejaDupBackendRackspacePrivate DejaDupBackendRackspacePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_CHECKER (deja_dup_checker_get_type ())
#define DEJA_DUP_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupChecker))
#define DEJA_DUP_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))
#define DEJA_DUP_IS_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_IS_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))

typedef struct _DejaDupChecker DejaDupChecker;
typedef struct _DejaDupCheckerClass DejaDupCheckerClass;

#define DEJA_DUP_TYPE_PYTHON_CHECKER (deja_dup_python_checker_get_type ())
#define DEJA_DUP_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonChecker))
#define DEJA_DUP_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))
#define DEJA_DUP_IS_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_IS_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_PYTHON_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))

typedef struct _DejaDupPythonChecker DejaDupPythonChecker;
typedef struct _DejaDupPythonCheckerClass DejaDupPythonCheckerClass;

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_SIMPLE_SETTINGS (deja_dup_simple_settings_get_type ())
#define DEJA_DUP_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettings))
#define DEJA_DUP_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))
#define DEJA_DUP_IS_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_IS_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_SIMPLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))

typedef struct _DejaDupSimpleSettings DejaDupSimpleSettings;
typedef struct _DejaDupSimpleSettingsClass DejaDupSimpleSettingsClass;
typedef struct _DejaDupBackendRackspaceGetEnvpData DejaDupBackendRackspaceGetEnvpData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST,
	DEJA_DUP_OPERATION_MODE_FILEHISTORY
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, GError** error);
	gchar* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	gboolean (*is_ready) (DejaDupBackend* self, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendRackspace {
	DejaDupBackend parent_instance;
	DejaDupBackendRackspacePrivate * priv;
};

struct _DejaDupBackendRackspaceClass {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendRackspacePrivate {
	gchar* settings_id;
	gchar* id;
	gchar* secret_key;
};

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG,
	DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()
struct _DejaDupBackendRackspaceGetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendRackspace* self;
	DejaDupSimpleSettings* _tmp0_;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
};


static gpointer deja_dup_backend_rackspace_parent_class = NULL;

#define DEJA_DUP_RACKSPACE_ROOT "Rackspace"
#define DEJA_DUP_RACKSPACE_USERNAME_KEY "username"
#define DEJA_DUP_RACKSPACE_CONTAINER_KEY "container"
#define DEJA_DUP_RACKSPACE_SERVER "auth.api.rackspacecloud.com"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_rackspace_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_RACKSPACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspacePrivate))
enum  {
	DEJA_DUP_BACKEND_RACKSPACE_DUMMY_PROPERTY
};
GType deja_dup_checker_get_type (void) G_GNUC_CONST;
DejaDupChecker* deja_dup_backend_rackspace_get_checker (void);
GType deja_dup_python_checker_get_type (void) G_GNUC_CONST;
DejaDupPythonChecker* deja_dup_python_checker_get_checker (const gchar* module);
static DejaDupBackend* deja_dup_backend_rackspace_real_clone (DejaDupBackend* base);
DejaDupBackendRackspace* deja_dup_backend_rackspace_new (void);
DejaDupBackendRackspace* deja_dup_backend_rackspace_construct (GType object_type);
static gboolean deja_dup_backend_rackspace_real_is_native (DejaDupBackend* base);
static GIcon* deja_dup_backend_rackspace_real_get_icon (DejaDupBackend* base);
static gboolean deja_dup_backend_rackspace_real_is_ready (DejaDupBackend* base, gchar** when);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
gboolean deja_dup_network_get_connected (DejaDupNetwork* self);
static gchar* deja_dup_backend_rackspace_real_get_location (DejaDupBackend* base, GError** error);
GType deja_dup_simple_settings_get_type (void) G_GNUC_CONST;
DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir);
gchar* deja_dup_get_folder_key (DejaDupSimpleSettings* settings, const gchar* key);
GQuark deja_dup_backup_error_quark (void);
static gchar* deja_dup_backend_rackspace_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void deja_dup_backend_rackspace_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_rackspace_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_rackspace_real_get_envp_co (DejaDupBackendRackspaceGetEnvpData* data);
static void deja_dup_backend_rackspace_got_secret_key (DejaDupBackendRackspace* self);
static void deja_dup_backend_rackspace_found_password (DejaDupBackendRackspace* self, GnomeKeyringResult _result_, GList* list);
static void _deja_dup_backend_rackspace_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self);
static void deja_dup_backend_rackspace_ask_password (DejaDupBackendRackspace* self);
static void deja_dup_backend_rackspace_save_password_callback (DejaDupBackendRackspace* self, GnomeKeyringResult _result_, guint32 val);
static void deja_dup_backend_rackspace_got_password_reply (DejaDupBackendRackspace* self, GMountOperation* mount_op, GMountOperationResult _result_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _deja_dup_backend_rackspace_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void _deja_dup_backend_rackspace_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
void deja_dup_simple_settings_set_string (DejaDupSimpleSettings* self, const gchar* k, const gchar* v);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void deja_dup_backend_rackspace_finalize (GObject* obj);


DejaDupChecker* deja_dup_backend_rackspace_get_checker (void) {
	DejaDupChecker* result = NULL;
	DejaDupPythonChecker* _tmp0_ = NULL;
	_tmp0_ = deja_dup_python_checker_get_checker ("cloudfiles");
	result = (DejaDupChecker*) _tmp0_;
	return result;
}


static DejaDupBackend* deja_dup_backend_rackspace_real_clone (DejaDupBackend* base) {
	DejaDupBackendRackspace * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendRackspace* _tmp0_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = deja_dup_backend_rackspace_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static gboolean deja_dup_backend_rackspace_real_is_native (DejaDupBackend* base) {
	DejaDupBackendRackspace * self;
	gboolean result = FALSE;
	self = (DejaDupBackendRackspace*) base;
	result = FALSE;
	return result;
}


static GIcon* deja_dup_backend_rackspace_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendRackspace * self;
	GIcon* result = NULL;
	GThemedIcon* _tmp0_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	result = (GIcon*) _tmp0_;
	return result;
}


static gboolean deja_dup_backend_rackspace_real_is_ready (DejaDupBackend* base, gchar** when) {
	DejaDupBackendRackspace * self;
	gchar* _when = NULL;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	DejaDupNetwork* _tmp2_ = NULL;
	DejaDupNetwork* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = _ ("Backup will begin when a network connection becomes available.");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_when);
	_when = _tmp1_;
	_tmp2_ = deja_dup_network_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = deja_dup_network_get_connected (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	if (when) {
		*when = _when;
	} else {
		_g_free0 (_when);
	}
	return result;
}


static gchar* deja_dup_backend_rackspace_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendRackspace * self;
	gchar* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* container;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	settings = _tmp0_;
	_tmp1_ = deja_dup_get_folder_key (settings, DEJA_DUP_RACKSPACE_CONTAINER_KEY);
	container = _tmp1_;
	if (g_strcmp0 (container, "") == 0) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = _ ("You must specify a Rackspace container in your preferences.");
		_tmp3_ = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_BAD_CONFIG, _tmp2_);
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (container);
		_g_object_unref0 (settings);
		return NULL;
	}
	_tmp4_ = g_strdup_printf ("cf+http://%s", container);
	result = _tmp4_;
	_g_free0 (container);
	_g_object_unref0 (settings);
	return result;
}


static gchar* deja_dup_backend_rackspace_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendRackspace * self;
	gchar* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* container;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_RACKSPACE_CONTAINER_KEY);
	container = _tmp1_;
	if (g_strcmp0 (container, "") == 0) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = _ ("Rackspace Cloud Files");
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		_g_free0 (container);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = _ ("%s on Rackspace Cloud Files");
		_tmp5_ = g_strdup_printf (_tmp4_, container);
		result = _tmp5_;
		_g_free0 (container);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (container);
	_g_object_unref0 (settings);
}


static void deja_dup_backend_rackspace_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendRackspaceGetEnvpData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendRackspaceGetEnvpData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_rackspace_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendRackspace * self;
	DejaDupBackendRackspaceGetEnvpData* _data_;
	self = (DejaDupBackendRackspace*) base;
	_data_ = g_slice_new0 (DejaDupBackendRackspaceGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_rackspace_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_rackspace_real_get_envp_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_backend_rackspace_real_get_envp_co (_data_);
}


static void deja_dup_backend_rackspace_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendRackspaceGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _deja_dup_backend_rackspace_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self) {
	deja_dup_backend_rackspace_found_password (self, _result_, list);
}


static gboolean deja_dup_backend_rackspace_real_get_envp_co (DejaDupBackendRackspaceGetEnvpData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	data->settings = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_settings_get_string ((GSettings*) data->settings, DEJA_DUP_RACKSPACE_USERNAME_KEY);
	_g_free0 (data->self->priv->settings_id);
	data->self->priv->settings_id = data->_tmp1_;
	if (data->self->priv->settings_id == NULL) {
		data->_tmp2_ = "";
	} else {
		data->_tmp2_ = data->self->priv->settings_id;
	}
	data->_tmp3_ = g_strdup (data->_tmp2_);
	_g_free0 (data->self->priv->id);
	data->self->priv->id = data->_tmp3_;
	if (g_strcmp0 (data->self->priv->id, "") != 0) {
		data->_tmp4_ = data->self->priv->secret_key != NULL;
	} else {
		data->_tmp4_ = FALSE;
	}
	if (data->_tmp4_) {
		deja_dup_backend_rackspace_got_secret_key (data->self);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (g_strcmp0 (data->self->priv->id, "") != 0) {
		_g_free0 (data->self->priv->secret_key);
		data->self->priv->secret_key = NULL;
		gnome_keyring_find_network_password (data->self->priv->id, NULL, DEJA_DUP_RACKSPACE_SERVER, NULL, "https", NULL, (guint32) 0, _deja_dup_backend_rackspace_found_password_gnome_keyring_operation_get_list_callback, g_object_ref (data->self), g_object_unref);
	} else {
		deja_dup_backend_rackspace_ask_password (data->self);
	}
	_g_object_unref0 (data->settings);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_rackspace_found_password (DejaDupBackendRackspace* self, GnomeKeyringResult _result_, GList* list) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (_result_ == GNOME_KEYRING_RESULT_OK) {
		_tmp0_ = list != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (((GnomeKeyringNetworkPasswordData*) list->data)->password);
		_g_free0 (self->priv->secret_key);
		self->priv->secret_key = _tmp1_;
		deja_dup_backend_rackspace_got_secret_key (self);
	} else {
		deja_dup_backend_rackspace_ask_password (self);
	}
}


static void deja_dup_backend_rackspace_save_password_callback (DejaDupBackendRackspace* self, GnomeKeyringResult _result_, guint32 val) {
	g_return_if_fail (self != NULL);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _deja_dup_backend_rackspace_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self) {
	deja_dup_backend_rackspace_save_password_callback (self, _result_, val);
}


static void deja_dup_backend_rackspace_got_password_reply (DejaDupBackendRackspace* self, GMountOperation* mount_op, GMountOperationResult _result_) {
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GPasswordSave _tmp6_;
	GPasswordSave remember;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount_op != NULL);
	if (_result_ != G_MOUNT_OPERATION_HANDLED) {
		GList* _tmp0_;
		const gchar* _tmp1_ = NULL;
		_tmp0_ = NULL;
		_tmp1_ = _ ("Permission denied");
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp0_, _tmp1_);
		__g_list_free__g_free0_0 (_tmp0_);
		return;
	}
	_tmp2_ = g_mount_operation_get_username (mount_op);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->id);
	self->priv->id = _tmp3_;
	_tmp4_ = g_mount_operation_get_password (mount_op);
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->secret_key);
	self->priv->secret_key = _tmp5_;
	_tmp6_ = g_mount_operation_get_password_save (mount_op);
	remember = _tmp6_;
	if (remember != G_PASSWORD_SAVE_NEVER) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* where;
		if (remember == G_PASSWORD_SAVE_FOR_SESSION) {
			_tmp7_ = "session";
		} else {
			_tmp7_ = GNOME_KEYRING_DEFAULT;
		}
		_tmp8_ = g_strdup (_tmp7_);
		where = _tmp8_;
		gnome_keyring_set_network_password (where, self->priv->id, NULL, DEJA_DUP_RACKSPACE_SERVER, NULL, "https", NULL, (guint32) 0, self->priv->secret_key, _deja_dup_backend_rackspace_save_password_callback_gnome_keyring_operation_get_int_callback, g_object_ref (self), g_object_unref);
		_g_free0 (where);
	}
	deja_dup_backend_rackspace_got_secret_key (self);
}


static void _deja_dup_backend_rackspace_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	deja_dup_backend_rackspace_got_password_reply (self, _sender, _result_);
}


static void deja_dup_backend_rackspace_ask_password (DejaDupBackendRackspace* self) {
	GMountOperation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GMountOperation* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GMountOperation* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMountOperation* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GMountOperation* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GMountOperation* _tmp12_ = NULL;
	GMountOperation* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp1_ = _ ("You can sign up for a Rackspace Cloud Files account <a href=\"%s\">onl" \
"ine</a>.");
	_tmp2_ = g_strdup_printf (_tmp1_, "https://signup.rackspacecloud.com/signup");
	_tmp3_ = _tmp2_;
	g_object_set ((GObject*) _tmp0_, "label_help", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	_tmp4_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp5_ = _ ("Connect to Rackspace Cloud Files");
	g_object_set ((GObject*) _tmp4_, "label_title", _tmp5_, NULL);
	_tmp6_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp7_ = _ ("_API access key");
	g_object_set ((GObject*) _tmp6_, "label_password", _tmp7_, NULL);
	_tmp8_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp9_ = _ ("S_how API access key");
	g_object_set ((GObject*) _tmp8_, "label_show_password", _tmp9_, NULL);
	_tmp10_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp11_ = _ ("_Remember API access key");
	g_object_set ((GObject*) _tmp10_, "label_remember_password", _tmp11_, NULL);
	_tmp12_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	g_signal_connect_object (_tmp12_, "reply", (GCallback) _deja_dup_backend_rackspace_got_password_reply_g_mount_operation_reply, self, 0);
	_tmp13_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	g_signal_emit_by_name (_tmp13_, "ask-password", "", self->priv->id, "", (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_SAVING_SUPPORTED);
}


static void deja_dup_backend_rackspace_got_secret_key (DejaDupBackendRackspace* self) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	GList* envp;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	settings = _tmp0_;
	if (g_strcmp0 (self->priv->id, self->priv->settings_id) != 0) {
		deja_dup_simple_settings_set_string (settings, DEJA_DUP_RACKSPACE_USERNAME_KEY, self->priv->id);
	}
	envp = NULL;
	_tmp1_ = g_strdup_printf ("CLOUDFILES_USERNAME=%s", self->priv->id);
	envp = g_list_append (envp, _tmp1_);
	_tmp2_ = g_strdup_printf ("CLOUDFILES_APIKEY=%s", self->priv->secret_key);
	envp = g_list_append (envp, _tmp2_);
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	__g_list_free__g_free0_0 (envp);
	_g_object_unref0 (settings);
}


DejaDupBackendRackspace* deja_dup_backend_rackspace_construct (GType object_type) {
	DejaDupBackendRackspace * self = NULL;
	self = (DejaDupBackendRackspace*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendRackspace* deja_dup_backend_rackspace_new (void) {
	return deja_dup_backend_rackspace_construct (DEJA_DUP_TYPE_BACKEND_RACKSPACE);
}


static void deja_dup_backend_rackspace_class_init (DejaDupBackendRackspaceClass * klass) {
	deja_dup_backend_rackspace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendRackspacePrivate));
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_rackspace_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->is_native = deja_dup_backend_rackspace_real_is_native;
	DEJA_DUP_BACKEND_CLASS (klass)->get_icon = deja_dup_backend_rackspace_real_get_icon;
	DEJA_DUP_BACKEND_CLASS (klass)->is_ready = deja_dup_backend_rackspace_real_is_ready;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_rackspace_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_rackspace_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_rackspace_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp_finish = deja_dup_backend_rackspace_real_get_envp_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_rackspace_finalize;
}


static void deja_dup_backend_rackspace_instance_init (DejaDupBackendRackspace * self) {
	self->priv = DEJA_DUP_BACKEND_RACKSPACE_GET_PRIVATE (self);
}


static void deja_dup_backend_rackspace_finalize (GObject* obj) {
	DejaDupBackendRackspace * self;
	self = DEJA_DUP_BACKEND_RACKSPACE (obj);
	_g_free0 (self->priv->settings_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_rackspace_parent_class)->finalize (obj);
}


GType deja_dup_backend_rackspace_get_type (void) {
	static volatile gsize deja_dup_backend_rackspace_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_rackspace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendRackspaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_rackspace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendRackspace), 0, (GInstanceInitFunc) deja_dup_backend_rackspace_instance_init, NULL };
		GType deja_dup_backend_rackspace_type_id;
		deja_dup_backend_rackspace_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendRackspace", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_rackspace_type_id__volatile, deja_dup_backend_rackspace_type_id);
	}
	return deja_dup_backend_rackspace_type_id__volatile;
}



