/**
 * Parse-tree data type.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include <stdlib.h>
#include "tree.h"
#include "util.h"


/** Creates a new node containing the specified data. */
Tree*
create_node( int data)
{
	Tree* node = allocate_memory( sizeof *node);
	node->data = data;
	node->count = 0;
	return node;
}


/** Destroys this tree. */
void
destroy_tree( Tree* tree)
{
	while( tree->count)
		destroy_tree( tree->children[--tree->count]);
	free( tree);
}


/** Prints this tree. */
void
print_tree( Tree* tree)
{
	int i;
	if( tree == NULL)
		return;
	if( tree->count) {
		printf( "(%d", tree->data);
		for( i = 0; i < tree->count; i++) {
			putchar( ' ');
			print_tree( tree->children[i]);
		}
		putchar( ')');
	} else
		printf( "%d", tree->data);
}
