#!/bin/sh
#
# partial mirror script for your machine by using debmirror
#

set -e

########################################################
MIRRORHOST=ftp.debian.org
DIST=unstable
NAME=partial
PREFIX=""

# if you don't want non-us packages, comment out NONUSHOST.
NONUSHOST=non-us.debian.org
NONUSDIST=unstable/non-US
NONUSNAME=partial-non-US

#### If you don't need sources, then uncommen this.
#NOSOURCE=--nosource

ARCH=i386
SIZE=CD74
DATADIR=/home/ftp/debian/
MIRRORDIR=/home/ftp/pub/debmirror

IGNORE_OPT="--ignore=Packages --ignore=Sources --ignore=Release"

########################################################

tmp=`tempfile`
trap "rm -f $tmp" 0

if test -z "$NONUSHOST"; then
  NONUSDIST=""
  NONUSNAME=""
fi

dpkg --get-selections | grep -v deinstall | awk -F' ' '{print $1;}' > $tmp &
install -d $DATADIR

debmirror -a $ARCH -h $MIRRORHOST \
  -d $DIST --debug --exclude=. --nocleanup $DATADIR $NOSOURCE

if test -n "$NONUSHOST"; then
  debmirror -a $ARCH -r debian-non-US -h $NONUSHOST \
    -d $NONUSDIST --debug --exclude=. --nocleanup $DATADIR $NOSOURCE
fi
wait

find $MIRRORDIR/$NAME -name Packages.gz -o -name Sources.gz | while read f
do
  zcat $f > `dirname $f`/`basename $f .gz`
done &

if test -n "$NONUSHOST"; then
  find $MIRRORDIR/$NONUSNAME -name Packages.gz -o -name Sources.gz | while read f
  do
    zcat $f > `dirname $f`/`basename $f .gz`
  done &
fi

debpartial --size=$SIZE -m -l 1 --dirprefix=$PREFIX -a $ARCH -D $NAME \
  -d "$DIST,$NONUSDIST" --include-from $tmp $DATADIR $MIRRORDIR $NOSOURCE

if test -n "$NONUSHOST"; then
  IFS=','
  for d in `echo $NONUSDIST`
  do
    install -d $MIRRORDIR/$NONUSNAME/dists/$d
    cp -a $MIRRORDIR/$NAME/dists/$d/* $MIRRORDIR/$NONUSNAME/dists/$d
  done
fi

IFS=" "
debmirror -a $ARCH -h $MIRRORHOST -d $DIST --debug \
   $IGNORE_OPT $MIRRORDIR/$NAME --skippackages $NOSOURCE &

if test -n "$NONUSHOST"; then
  debmirror -r debian-non-US -a $ARCH -h $NONUSHOST -d $NONUSDIST --debug \
     $IGNORE_OPT $MIRRORDIR/$NONUSNAME --skippackages $NOSOURCE
fi

wait
