// $Id: TextSetS.C,v 1.1 2000/05/23 13:04:38 andreas Exp $ -*- C++ -*-
// XmTextSetSelection() wrapper

// Copyright (C) 2000 Universitaet Passau, Germany.
// Written by Andreas Zeller <zeller@gnu.org>.
// 
// This file is part of DDD.
// 
// DDD is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// DDD is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with DDD -- see the file COPYING.
// If not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.gnu.org/software/ddd/',
// or send a mail to the DDD developers <ddd@gnu.org>.

char TextSetSelection_rcsid[] = 
    "$Id: TextSetS.C,v 1.1 2000/05/23 13:04:38 andreas Exp $";

#ifdef __GNUG__
#pragma implementation
#endif

#include "TextSetS.h"


void TextSetSelection(Widget w, 
		      XmTextPosition first, 
		      XmTextPosition last,
		      Time time)
{
    XmTextPosition old_first, old_last;
    if (XmTextGetSelectionPosition(w, &old_first, &old_last))
    {
	if (old_first != first || old_last != last)
	{
	    // Selection has changed
	    XmTextSetSelection(w, first, last, time);
	}
    }
    else
    {
	// Nothing selected yet
	XmTextSetSelection(w, first, last, time);
    }
}

void TextFieldSetSelection(Widget w, 
			   XmTextPosition first, 
			   XmTextPosition last, 
			   Time time)
{
    XmTextPosition old_first, old_last;
    if (XmTextFieldGetSelectionPosition(w, &old_first, &old_last))
    {
	if (old_first != first || old_last != last)
	{
	    // Selection has changed
	    XmTextFieldSetSelection(w, first, last, time);
	}
    }
    else
    {
	// Nothing selected yet
	XmTextFieldSetSelection(w, first, last, time);
    }
}

