/*!

\if MANPAGES
\page dcmgpdir Create a general purpose DICOMDIR
\else
\page dcmgpdir dcmgpdir: Create a general purpose DICOMDIR
\endif

\section synopsis SYNOPSIS

\verbatim
dcmgpdir [options] dcmfile-in...
\endverbatim

\section description DESCRIPTION

The \b dcmgpdir utility creates a \e DICOMDIR file from the specified
referenced DICOM files according to the DICOM Part 11 Media Storage Application
Profiles.

Currently, the following profiles are supported:

\li General Purpose CD-R Interchange (STD-GEN-CD)
\li General Purpose Interchange on DVD-RAM Media (STD-GEN-DVD-RAM)

\b dcmmkdir is an extended version of this tool which also supports other
Media Storage Application Profiles than the general purpose one (e.g. both
cardio profiles requiring the use of icon images).

\section parameters PARAMETERS

\verbatim
dcmfile-in  referenced DICOM file
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -q    --quiet
          quiet mode, print no warnings and errors

  -d    --debug
          debug mode, print debug information
\endverbatim

\subsection input_options input options
\verbatim
DICOMDIR identifiers:

  +D    --output-file  [f]ilename : string
          generate specific DICOMDIR file
          (default: DICOMDIR in current directory)

  +F    --fileset-id  [i]d: string (default: DCMTK_MEDIA_DEMO)
          use specific file set ID

  +R    --descriptor  [f]ilename : string
          add a file set descriptor file ID
          (e.g. README, default: no descriptor)

  +C    --char-set  [c]har-set : string
          add a specific character set for descriptor
          (default: "ISO_IR 100" if descriptor present)

type 1 attributes:

  -I    --strict
          exit with error if DICOMDIR type 1 attributes
          are missing in DICOM file (default)

  +I    --invent
          invent DICOMDIR type 1 attributes if missing in DICOM file

reading:

  +id   --input-directory  [d]irectory : string
          read referenced DICOM files from directory d
          (default for --recurse: ".")

  -m    --keep-filenames
          expect filenames to be in DICOM format (default)

  +m    --map-filenames
          map to DICOM filenames (lowercase->uppercase,
          and remove trailing period)

  -r    --no-recurse
          do not recurse within directories (default)

  +r    --recurse
          recurse within filesystem directories

  +p    --pattern  [p]attern : string (only with --recurse)
          pattern for filename matching (wildcards)

          # possibly not available on all systems

checking:

  -W    --no-consistency-check
          do not check files for consistency

  +W    --warn-inconsist-files
          warn about inconsistant files (default)

  -a    --abort-inconsist-file
          abort on first inconsistant file

  +Ipi  --invent-patient-id
          invent new PatientID in case of inconsistant
          PatientsName attributes
\endverbatim

\subsection output_options output options
\verbatim
writing:

  -A    --replace
          replace existing DICOMDIR (default)
  +A    --append
          append to existing DICOMDIR

  -w    --discard
          do not write out DICOMDIR

  -nb   --no-backup
          do not create a backup of existing DICOMDIR

post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

group length encoding:

  -g    --group-length-remove
          write without group length elements (default)

  +g    --group-length-create
          write with group length elements

length encoding in sequences and items:

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths
\endverbatim

\section notes NOTES

All files specified on the command line (or discovered by recursivly examining
the contents of directories with the \e +r option) are first evaluated for
their compatibility with the General Purpose CD-R Image Interchange Profile
(Supplement 19).  Only appropriate files encoded using the Explicit VR Little
Endian Uncompressed Transfer Syntax will be accepted.  Files having invalid
filenames will be rejected (the rules can be relaxed via the \e +m option).
Files missing required attributes will be rejected (the \e +I option can relax
this behaviour).

A \e DICOMDIR file will only be constructed if all files have passed initial
tests.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmgpdir utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section see_also SEE ALSO

<b>dcmmkdir</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1996-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/
