<?xml version="1.0"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/><xsl:template match="/">
<html><head>
	<title>Schema Display</title>
	<style type="text/css">
		body { background-color: white; margin-left: 10%; margin-right: 10%; }
		th { text-align: left; }
		th.header { border-bottom: solid black 2px; cursor: hand; cursor: pointer; }
		tr.even { background-color: white; }
		tr.odd { background-color: #c0c0c0; }
		table { width: 100%; }
		img { border: solid black 1px; }
	</style>
	<script language="JavaScript">
	<![CDATA[
		function showHide(sDiv)
		{
			var oDiv = document.getElementById(sDiv);
			if (oDiv)
				oDiv.style.display = oDiv.style.display == "none" ? "" : "none";
		}
	]]>
	</script>
</head><body>
	<xsl:for-each select="tables/table"><xsl:sort select="@name"/>
		<table border="0">
			<tr><th class="header" colspan="6" onclick="showHide('{@name}');"><xsl:value-of select="@name"/></th></tr>
		</table>
		<div id="{@name}" style="display: none;">
		<table border="0">
		<tr><th>Name</th><th>Type</th><th>Size</th><th>Scale</th><th>Null?</th><th>Default</th></tr>
		<xsl:for-each select="fields/field">
			<xsl:variable name="tdclass">
				<xsl:choose>
				<xsl:when test="(position() mod 2) = 0">even</xsl:when>
				<xsl:otherwise>odd</xsl:otherwise>
				</xsl:choose>
				</xsl:variable>
			<tr class="{$tdclass}">
				<xsl:variable name="name"><xsl:value-of select="@name"/></xsl:variable>
				<td><xsl:value-of select="$name"/>
					<xsl:for-each select="../../primarykey/pkfield">
						<xsl:if test=". = $name"><xsl:text> </xsl:text><img src="key.png"/></xsl:if>
					</xsl:for-each>
				</td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@size"/></td>
				<td><xsl:value-of select="@scale"/></td>
				<td>
					<xsl:choose>
					<xsl:when test="@nullable = &quot;N&quot;"><img src="no.png"/></xsl:when>
					<xsl:otherwise><img src="yes.png"/></xsl:otherwise>
					</xsl:choose>
				</td>
				<td><xsl:value-of select="@default"/></td>
			</tr>
		</xsl:for-each>
	</table>
	</div>
	</xsl:for-each>
</body></html>
</xsl:template></xsl:stylesheet>
