<?php
/*
 * $Id: class.htmlPersonnel.inc.php,v 1.2.2.1.2.6 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('usr');

class htmlPersonnel
{
	function createCombo($default = 0, $cbName = 'responsible', $longShort = 'lastfirst', $size = 0, $activeOnly = true, $minsec = 0, $projectid = 0)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly, $minsec, $projectid);
	}

	function GetCombo($default = 0, $cbName = 'responsible', $longShort = 'lastfirst', $size = 0, $activeOnly = true, $minsec = 0, $projectid = 0)
	{
		$objDBPersonnel = CreateObject('dcl.dbPersonnel');
		$objDBPersonnel->Connect();
		$objDBPersonnel->cacheEnabled = false;

		if ($longShort == 'lastfirst')
			$orderBy = 'lastname, firstname';
		else if ($longShort == 'firstlast' || $longShort == 'name')
				$orderBy = 'firstname, lastname';
			else
				$orderBy = 'short';


		if ($projectid > 0)
		{
			// Show people in the project only
			$query = "SELECT DISTINCT personnel.* FROM personnel ";
			$query .= ', workorders a, projectmap b WHERE ';
			$query .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND b.projectid=$projectid ";
			$query .= 'AND id=a.responsible ';
		}
		else
		{
			$query = "SELECT * FROM personnel ";
			if ($activeOnly)
				$query .= 'WHERE active=\'Y\' ';

			if ($minsec > 0)
			{
				if ($activeOnly)
					$query .= 'AND';
				else
					$query .= 'WHERE';

				$query .= " security>=$minsec ";
			}
		}

		$query .= "ORDER BY $orderBy";
		$objDBPersonnel->Query($query);

		$oSelect = CreateObject('dcl.htmlSelect');
		$oSelect->vDefault = $default;
		$oSelect->sName = $cbName;
		$oSelect->iSize = $size;
		$oSelect->sZeroOption = STR_CMMN_SELECTONE;
		$oSelect->bCastToInt = true;

		while ($objDBPersonnel->next_record())
		{
			$objDBPersonnel->GetRow();

			if ($longShort == 'lastfirst')
				$name = $objDBPersonnel->lastNameFirst;
			else if ($longShort == 'firstlast' || $longShort == 'name')
				$name = $objDBPersonnel->firstNameLast;
			else
				$name = $objDBPersonnel->short;

			$oSelect->AddOption($objDBPersonnel->id, $name);
		}

		return $oSelect->GetHTML();
	}

	function displayPasswdForm()
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_CHG_PWD']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlPersonnelPasswdForm.tpl'));
		$Template->set_block('hForm', 'sa', 'hSa');
		$Template->set_block('hForm', 'notsa', 'hNotSa');
		$Template->set_var('hSa', '');
		$Template->set_var('hNotSa', '');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_CHGPWD', STR_USR_CHGPWD);

		$hidden_vars = '<input type="hidden" name="menuAction" value="boPersonnel.dbpasswd">';
		if ($GLOBALS['DCLID'] > 1)
		{
			$hidden_vars .= sprintf('<input type="hidden" name="userid" value="%d">', $GLOBALS['DCLID']);
			$Template->set_var('TXT_CURRPWD', STR_USR_CURRPWD);
			$Template->parse('hNotSa', 'notsa');
		}
		else
		{
			$Template->set_var('TXT_USER', STR_USR_USER);
			$Template->set_var('CMB_USERID', $this->GetCombo($GLOBALS['DCLID'], 'userid'));
			$Template->parse('hSa', 'sa');
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);
		$Template->set_var('TXT_NEWPWD', STR_USR_NEWPWD);
		$Template->set_var('TXT_CONFIRMPWD', STR_USR_CONFIRMPWD);
		$Template->set_var('BTN_CHANGE', STR_USR_CHANGE);
		$Template->set_var('BTN_CLEAR', STR_USR_CLEAR);

		$Template->pparse('out', 'hForm');
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlPersonnelForm.tpl'));
		$Template->set_block('hForm', 'add', 'hAdd');
		$Template->set_block('hForm', 'edit', 'hEdit');
		$Template->set_var('hAdd', '');
		$Template->set_var('hEdit', '');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', STR_USR_EDIT);
			$hidden_vars = '<input type="hidden" name="menuAction" value="boPersonnel.dbmodify">' .
				'<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_USR_ADD);
			$hidden_vars = '<input type="hidden" name="menuAction" value="boPersonnel.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_LOGIN', STR_USR_LOGIN);
		$Template->set_var('TXT_ACTIVE', STR_USR_ACTIVE);
		$Template->set_var('TXT_FIRSTNAME', STR_USR_FIRSTNAME);
		$Template->set_var('TXT_LASTNAME', STR_USR_LASTNAME);
		$Template->set_var('TXT_REPORTTO', STR_USR_REPORTTO);
		$Template->set_var('TXT_DEPARTMENT', STR_USR_DEPARTMENT);
		$Template->set_var('TXT_PASSWORD', STR_USR_PASSWORD);
		$Template->set_var('TXT_SECLVL', STR_USR_SECLVL);
		$Template->set_var('TXT_CONFIRMPWD', STR_USR_CONFIRMPWD);
		$Template->set_var('TXT_EMAIL', STR_USR_EMAIL);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_USR_HIGHLIGHTEDNOTE);
		$Template->set_var('LNK_CANCEL', menuLink('', 'menuAction=htmlPersonnel.PrintAll'));

		$oSelect = CreateObject('dcl.htmlSelect');
		$oSelect->vDefault = is_object($obj) ? $obj->security : 0;
		$oSelect->sName = 'security';
		$oSelect->sZeroOption = STR_CMMN_SELECTONE;
		$oSelect->AddOption($dcl_info['DCL_ADD_USER'], sprintf('(%d) %s', $dcl_info['DCL_ADD_USER'], STR_USR_ADMIN));
		$oSelect->AddOption($dcl_info['DCL_DEL_WO'], sprintf('(%d) %s', $dcl_info['DCL_DEL_WO'], STR_USR_DELWO));
		$oSelect->AddOption($dcl_info['DCL_MOD_WO'], sprintf('(%d) %s', $dcl_info['DCL_MOD_WO'], STR_USR_MODWO));
		$oSelect->AddOption($dcl_info['DCL_ASSIGN_WO'], sprintf('(%d) %s', $dcl_info['DCL_ASSIGN_WO'], STR_USR_ADDASSGN));
		$oSelect->AddOption($dcl_info['DCL_HAVE_WO'], sprintf('(%d) %s', $dcl_info['DCL_HAVE_WO'], STR_USR_RESPONSIBLE));
		$oSelect->AddOption($dcl_info['DCL_CHG_PWD'], sprintf('(%d) %s', $dcl_info['DCL_CHG_PWD'], STR_USR_CANCHGPWD));
		$oSelect->AddOption($dcl_info['DCL_ADD_WO'], sprintf('(%d) %s', $dcl_info['DCL_ADD_WO'], STR_USR_ADDWO));
		$Template->set_var('CMB_SECURITY', $oSelect->GetHTML());

		$objHTMLDepartments = CreateObject('dcl.htmlDepartments');

		// Data
		if ($isEdit)
		{
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_FIRSTNAME', $obj->firstname);
			$Template->set_var('VAL_LASTNAME', $obj->lastname);
			$Template->set_var('CMB_REPORTTO', $this->GetCombo($obj->reportto, 'reportto'));
			$Template->set_var('CMB_DEPARTMENT', $objHTMLDepartments->GetCombo($obj->department));
			$Template->set_var('VAL_SECURITY', $obj->security);
			$Template->set_var('VAL_EMAIL', $obj->email);
			$Template->parse('hEdit', 'edit');
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('CMB_REPORTTO', $this->GetCombo($GLOBALS['DCLID'], 'reportto'));
			$Template->set_var('CMB_DEPARTMENT', $objHTMLDepartments->GetCombo());
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_FIRSTNAME', '');
			$Template->set_var('VAL_LASTNAME', '');
			$Template->set_var('VAL_SECURITY', '');
			$Template->set_var('VAL_EMAIL', '');
			$Template->parse('hAdd', 'add');
		}			

		$Template->pparse('out', 'hForm');
	}

	function RenderOptions(&$aRecord)
	{
		global $dcl_info, $g_oSec;

		$str = '<td>';

		if ($aRecord[8] != '')
		{
			$str .= '<a class="adark" href="mailto:' . $aRecord[8] . '">' . STR_USR_EMAIL . '</a>';
		}
		else
		{
			$str .= '<span style="color: grey;">' . STR_USR_EMAIL . '</span>';
		}

		$str .= '&nbsp;|&nbsp;';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boPersonnel.modify&id=' . $aRecord[0]) . '">' . STR_CMMN_EDIT . '</a>';
		$str .= '&nbsp;|&nbsp;';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boPersonnel.delete&id=' . $aRecord[0]) . '">' . STR_CMMN_DELETE . '</a>';
		$str .= '</td>';
		echo $str;
	}

	function PrintAll($orderBy = 'short')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		commonHeader();

		$oView = CreateObject('dcl.boView');
		$oView->startrow = 0;
		$oView->numrows = 25;

		$filterActive = '';
		$filterDepartment = '0';
		if (IsSet($GLOBALS['filterActive']))
			$filterActive = $GLOBALS['filterActive'];
		if (IsSet($GLOBALS['filterDepartment']))
			$filterDepartment = $GLOBALS['filterDepartment'];

		$oView->table = 'personnel';
		$oView->style = 'report';
		$oView->title = sprintf(STR_USR_TABLETITLE, $orderBy);
		$oView->AddDef('columnhdrs', '', array(STR_USR_ID, STR_USR_ACTIVEABB, STR_USR_LOGIN,
					STR_USR_LASTNAME, STR_USR_FIRSTNAME, STR_USR_REPORTTO, STR_USR_DEPARTMENT,
					STR_USR_SECLVL, STR_USR_EMAIL));

		$oView->AddDef('columns', '', array('id', 'active', 'short', 'lastname', 'firstname', 'reportto.short', 'departments.name', 'security', 'email'));

		$oView->AddDef('order', '', array('personnel.short'));

		if ($filterActive == 'Y' || $filterActive == 'N')
			$oView->AddDef('filter', 'active', "'$filterActive'");

		if ($filterDepartment != '0')
			$oView->AddDef('filter', 'department', $filterDepartment);

		$oHtml = CreateObject('dcl.htmlPersonnelBrowse');
		$oHtml->Render($oView);
	}
}
?>
