/* Copyright (C) 2007 db4objects Inc. http://www.db4o.com */

package com.db4odoc.builtintranslators;

import java.io.File;

import com.db4o.DatabaseFileLockedException;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.config.TNull;
import com.db4o.config.TSerializable;
import com.db4o.config.TTransient;
import com.db4o.ext.Db4oException;
import com.db4o.query.Query;


public class BuiltInTranslatorsExample {
    private static  final String DB4O_FILE_NAME = "reference.db4o";

    private static ObjectContainer _container = null;

    public static void main(String[] args)
    {
        testTNull();
        testSerializable();
    	testTTransient();
    }
    // end main

    private static ObjectContainer database()
    {
        if (_container == null)
        {
            try
            {
                _container = Db4o.openFile(DB4O_FILE_NAME);
            }
            catch (DatabaseFileLockedException ex)
            {
                ex.printStackTrace();
            }
        }
        return _container;
    }

    // end Database

    private static ObjectContainer database(Configuration configuration)
    {
        if (_container == null)
        {
            try
            {
                _container = Db4o.openFile(configuration, DB4O_FILE_NAME);
            }
            catch (DatabaseFileLockedException ex)
            {
            	ex.printStackTrace();
            }
        }
        return _container;
    }

    // end database

    private static void closeDatabase()
    {
        if (_container != null)
        {
            _container.close();
            _container = null;
        }
    }

    // end closeDatabase


    public static void saveNotStorable()
    {
        new File(DB4O_FILE_NAME).delete();
        Configuration configuration = Db4o.newConfiguration();
        // Configure NotStorable class with TNull translator to prevent its storage
        configuration.objectClass(NotStorable.class).translate(new TNull());
        ObjectContainer container = database(configuration);
        if (container != null)
        {
            try
            {
                NotStorable ns =  new NotStorable("test1");
                container.set(ns);
                ns = new NotStorable("test2");
                container.set(ns);
            }
            catch (Db4oException ex)
            {
            	ex.printStackTrace();
            }
            catch (Exception ex)
            {
            	ex.printStackTrace();
            }
            finally
            {
                closeDatabase();
            }
        }
    }
    // end saveNotStorable

    public static void saveTransient()
    {
        new File(DB4O_FILE_NAME).delete();
        Configuration configuration = Db4o.newConfiguration();
        // Configure NotStorable class with TTransient translator to prevent its storage
        configuration.objectClass(NotStorable.class).translate(new TTransient());
        ObjectContainer container = database(configuration);
        if (container != null)
        {
            try
            {
                Item item =  new Item("Test1", new NotStorable("test1"));
                container.set(item);
                item =  new Item("Test2", new NotStorable("test2"));
                container.set(item);
            }
            catch (Db4oException ex)
            {
            	ex.printStackTrace();
            }
            catch (Exception ex)
            {
            	ex.printStackTrace();
            }
            finally
            {
                closeDatabase();
            }
        }
    }
    // end saveTransient
    
    public static void testTNull()
    {
        saveNotStorable();
        ObjectContainer container = database();
        if (container != null)
        {
            try
            {
                // Trying to retrieve
                ObjectSet result = container.query(NotStorable.class);
                // As the class is configured with TNull, the data should be null
                listResult(result);
            }
            catch (Db4oException ex)
            {
            	ex.printStackTrace();
            }
            catch (Exception ex)
            {
            	ex.printStackTrace();
            }
            finally
            {
                closeDatabase();
            }
        }
    }
    // end testTNull

    public static void testTTransient()
    {
        saveTransient();
        ObjectContainer container = database();
        if (container != null)
        {
            try
            {
                // Trying to retrieve
                ObjectSet result = container.query(Item.class);
                // NotStorable class is configured transient, so we will 
                // see null values for _ns field.
                listResult(result);
            }
            catch (Db4oException ex)
            {
            	ex.printStackTrace();
            }
            catch (Exception ex)
            {
            	ex.printStackTrace();
            }
            finally
            {
                closeDatabase();
            }
        }
    }
    // end testTTransient

    public static void testSerializable()
    {
        saveSerializable();
        Configuration configuration = Db4o.newConfiguration();
        // configure class as serializable to retrieve correctly
        configuration.objectClass(Pilot.class).translate(new TSerializable());
        ObjectContainer container = database(configuration);
        if (container != null)
        {
            try
            {
            	System.out.println("Retrieving pilots by name:");
                Query query = container.query();
                query.constrain(Pilot.class);
                query.descend("_name").constrain("Test Pilot 1");
                ObjectSet resultByName = query.execute();
                listResult(resultByName);
                
                System.out.println("Retrieve all pilot objects:");
                ObjectSet result = container.query(Pilot.class);
                listResult(result);
            }
            catch (Db4oException ex)
            {
            	ex.printStackTrace();
            }
            catch (Exception ex)
            {
            	ex.printStackTrace();
            }
            finally
            {
                closeDatabase();
            }
        }
    }
    // end testSerializable

    public static void saveSerializable()
    {
        new File(DB4O_FILE_NAME).delete();
        Configuration configuration = Db4o.newConfiguration();
        // configure class as serializable
        configuration.objectClass(Pilot.class).translate(new TSerializable());
        ObjectContainer container = database(configuration);
        if (container != null)
        {
            try
            {
                Pilot pilot = new Pilot("Test Pilot 1", 99);
                container.set(pilot);
                pilot = new Pilot("Test Pilot 2", 100);
                container.set(pilot);
            }
            catch (Db4oException ex)
            {
            	ex.printStackTrace();
            }
            catch (Exception ex)
            {
            	ex.printStackTrace();
            }
            finally
            {
                closeDatabase();
            }
        }

    }
    // end saveSerializable


    private static void listResult(ObjectSet result)
    {
    	System.out.println(result.size());
        for (int i = 0; i < result.size(); i++)
        {
        	System.out.println(result.get(i));
        }
    }

    // end listResult

}
