/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class DescendToNullFieldTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		private static int COUNT = 2;

		public class ParentItem
		{
			public string _name;

			public Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ChildItem
				 one;

			public Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ChildItem
				 two;

			public ParentItem(string name, Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ChildItem
				 child1, Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ChildItem
				 child2)
			{
				_name = name;
				one = child1;
				two = child2;
			}
		}

		public class ChildItem
		{
			public string _name;

			public ChildItem(string name)
			{
				_name = name;
			}
		}

		protected override void Store()
		{
			for (int i = 0; i < COUNT; i++)
			{
				Store(new Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ParentItem
					("one", new Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ChildItem
					("one"), null));
			}
			for (int i = 0; i < COUNT; i++)
			{
				Store(new Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ParentItem
					("two", null, new Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ChildItem
					("two")));
			}
		}

		public virtual void Test()
		{
			AssertResults("one");
			AssertResults("two");
		}

		private void AssertResults(string name)
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(typeof(Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ParentItem)
				);
			query.Descend(name).Descend("_name").Constrain(name);
			Db4objects.Db4o.IObjectSet objectSet = query.Execute();
			Db4oUnit.Assert.AreEqual(COUNT, objectSet.Size());
			while (objectSet.HasNext())
			{
				Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ParentItem parentItem
					 = (Db4objects.Db4o.Tests.Common.Assorted.DescendToNullFieldTestCase.ParentItem)
					objectSet.Next();
				Db4oUnit.Assert.AreEqual(name, parentItem._name);
			}
		}
	}
}
