<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:variable name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
  <xsl:param name="TestDocDir">.</xsl:param>
  <xsl:include href="DashboardConfig.xsl"/>
  <xsl:output method="html"/>
  <xsl:template match="/">
    <xsl:call-template name="Summary"/>
    <xsl:call-template name="Purify"/>
  </xsl:template>

  <xsl:template name="Purify">
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">Purify <xsl:value-of select="Site/@Name"/> -- <xsl:value-of select="Site/@BuildName"/></xsl:with-param>
        <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
        <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      </xsl:call-template>
     <p><b><xsl:text>Site:</xsl:text></b><xsl:value-of select="Site/@Name"/></p>
     <p>
       <b>
         <xsl:text>Build Name:</xsl:text>
       </b>
       <xsl:value-of select="Site/@BuildName"/>
     </p> 

    <table cellspacing="0">
      <tr>
        <th>Name</th>
        <th>Status</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    MLK
            <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        </th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    PLK
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    MPK
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    UMC
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    UMR
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    ABR
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    ABW
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    ABWL
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    IPR
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    NPR
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    ODS
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    COR
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    EXU
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    FMM
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    FUM
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    FMR
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    FMW
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    FFM
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	    MAF
	    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</th>
      </tr>

      <xsl:for-each select="Site/Purify/Test">
        <xsl:sort select="sum(Results/MLK)+sum(Results/PLK)+sum(Results/MPK)+sum(Results/UMC)+sum(Results/UMR)+sum(Results/ABR)+sum(Results/ABW)+sum(Results/ABWL)+sum(Results/IPR)+sum(Results/NPR)+sum(Results/ODS)+sum(Results/COR)+sum(Results/EXU)+sum(Results/FMM)+sum(Results/FUM)+sum(Results/FMR)+sum(Results/FMW)+sum(Results/FFM)+sum(Results/MAF) > 0" order="descending"/>
        <xsl:sort select="Name"/>

	<xsl:if test="sum(Results/MLK)+sum(Results/PLK)+sum(Results/MPK)+sum(Results/UMC)+sum(Results/UMR)+sum(Results/ABR)+sum(Results/ABW)+sum(Results/ABWL)+sum(Results/IPR)+sum(Results/NPR)+sum(Results/ODS)+sum(Results/COR)+sum(Results/EXU)+sum(Results/FMM)+sum(Results/FUM)+sum(Results/FMR)+sum(Results/FMW)+sum(Results/FFM)+sum(Results/MAF)">
         <xsl:call-template name="Test"/>
         <tr align="center">
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="bgcolor"><xsl:value-of select="$LightBlue"/></xsl:attribute>
          </xsl:if>
          <td align="left">
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">Purify/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:call-template name="SoftHyphenStringAtSlash">
                <xsl:with-param name="src">
	          <xsl:value-of select="Name"/>
                </xsl:with-param>
	      </xsl:call-template>
            </a>
          </td>
          <td>
            <xsl:choose>
              <xsl:when test="contains('passed',@Status)">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$NormalColor"/></xsl:attribute>
                Passed
              </xsl:when>
              <xsl:when test="contains('failed',@Status)">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$WarningColor"/></xsl:attribute>
                Failed
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="bgcolor"><xsl:value-of select="$ErrorColor"/></xsl:attribute>
                Not Run
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td>
            <xsl:if test="Results/MLK != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/MLK"/>
          </td>
          <td>
            <xsl:if test="Results/PLK != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/PLK"/>
          </td>
          <td>
            <xsl:if test="Results/MPK != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/MPK"/>
          </td>
          <td>
            <xsl:if test="Results/UMC != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/UMC"/>
          </td>
          <td>
            <xsl:if test="Results/UMR != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/UMR"/>
          </td>
          <td>
            <xsl:if test="Results/ABR != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/ABR"/>
          </td>
          <td>
            <xsl:if test="Results/ABW != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/ABW"/>
          </td>
          <td>
            <xsl:if test="Results/ABWL != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/ABWL"/>
          </td>
          <td>
            <xsl:if test="Results/IPR != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/IPR"/>
          </td>
          <td>
            <xsl:if test="Results/NPR != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/NPR"/>
          </td>
          <td>
            <xsl:if test="Results/ODS != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/ODS"/>
          </td>
          <td>
            <xsl:if test="Results/COR != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/COR"/>
          </td>
          <td>
            <xsl:if test="Results/EXU != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/EXU"/>
          </td>
          <td>
            <xsl:if test="Results/FMM != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/FMM"/>
          </td>
          <td>
            <xsl:if test="Results/FUM != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/FUM"/>
          </td>
          <td>
            <xsl:if test="Results/FMR != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/FMR"/>
          </td>
          <td>
            <xsl:if test="Results/FMW != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/FMW"/>
          </td>
          <td>
            <xsl:if test="Results/FFM != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/FFM"/>
          </td>
          <td>
            <xsl:if test="Results/MAF != 0">
              <xsl:attribute name="bgcolor">
                <xsl:value-of select="$WarningColor"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="Results/MAF"/>
          </td>
        </tr>
      </xsl:if>
      </xsl:for-each>
    </table>

    <xsl:call-template name="DashboardFooter">
	<xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>

  </xsl:template>


   <xsl:template name="Test">
     <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/Purify/', translate ( FullName, '/.', '__' ) , '.html' )"/>
     <xsl:result-document href="{$uri}" >
       <xsl:call-template name="DashboardHeader">
         <xsl:with-param name="Title">Purify results for <xsl:value-of select="Name"/></xsl:with-param>
         <xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
         <xsl:with-param name="DashboardDir">../<xsl:value-of select="$DashboardDir"/></xsl:with-param>
       </xsl:call-template>
       <p>
         <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
       </p>
       <p>
         <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
       </p>
       <a>
         <xsl:attribute name="href">
           <xsl:call-template name="TranslateTestName">
             <xsl:with-param name="Prefix">../<xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
             <xsl:with-param name="TestName" select="FullName"/>
             <xsl:with-param name="Postfix">.html</xsl:with-param>
           </xsl:call-template>
         </xsl:attribute>
         <xsl:value-of select="Name"/> 
       </a>
       <xsl:choose>
         <xsl:when test="contains('failed',@Status)">
           <font>
             <xsl:attribute name="color"><xsl:value-of select="$WarningColor"/></xsl:attribute>
             Failed
           </font>
         </xsl:when>
         <xsl:when test="contains('passed',@Status)">
           <font>
             <xsl:attribute name="color"><xsl:value-of select="$NormalColor"/></xsl:attribute>
             Passed
           </font>
         </xsl:when>
       </xsl:choose>
      
       <pre>
         <xsl:value-of select="Log" disable-output-escaping="yes"/>
       </pre>

       <xsl:call-template name="DashboardFooter">
         <xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
       </xsl:call-template>
     </xsl:result-document>
   </xsl:template>



<xsl:template name="Summary">
  <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/PurifySummary.xml' )"/>
  <xsl:result-document href="{$uri}">
    <Purify>
      <SiteName><xsl:value-of select="Site/@Name"/></SiteName>
      <BuildName><xsl:value-of select="Site/@BuildName"/></BuildName>
      <BuildStamp><xsl:value-of select="Site/@BuildStamp"/></BuildStamp>
      <StartDateTime><xsl:value-of select="Site/Purify/StartDateTime"/></StartDateTime>

      <DefectCount><xsl:value-of select="sum(Site/Purify/Test/Results/MLK)+sum(Site/Purify/Test/Results/PLK)+sum(Site/Purify/Test/Results/MPK)+sum(Site/Purify/Test/Results/UMC)+sum(Site/Purify/Test/Results/UMR)+sum(Site/Purify/Test/Results/ABR)+sum(Site/Purify/Test/Results/ABW)+sum(Site/Purify/Test/Results/ABWL)+sum(Site/Purify/Test/Results/IPR)+sum(Site/Purify/Test/Results/NPR)+sum(Site/Purify/Test/Results/ODS)+sum(Site/Purify/Test/Results/COR)+sum(Site/Purify/Test/Results/EXU)+sum(Site/Purify/Test/Results/FMM)+sum(Site/Purify/Test/Results/FUM)+sum(Site/Purify/Test/Results/FMR)+sum(Site/Purify/Test/Results/FMW)+sum(Site/Purify/Test/Results/FFM)+sum(Site/Purify/Test/Results/MAF)"/></DefectCount>
      <EndDateTime><xsl:value-of select="Site/Purify/EndDateTime"/></EndDateTime>
    </Purify>
  </xsl:result-document>
</xsl:template>

</xsl:stylesheet>
