/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.Comparator;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.Variable;
import net.sf.saxon.xpath.XPathException;

public class StandaloneContext
implements StaticContext {
    private NamePool namePool;
    private HashMap namespaces = new HashMap();
    private HashMap collations = new HashMap();
    private HashMap variables = new HashMap();
    private String defaultCollationName = null;
    private String baseURI = null;
    private Configuration config;

    public StandaloneContext() {
        this(new Configuration());
    }

    public StandaloneContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.clearNamespaces();
    }

    public StandaloneContext(NodeInfo nodeInfo) {
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (documentInfo == null) {
            throw new IllegalArgumentException("The node used to establish a standalone context must be in a tree whose root is a document node");
        }
        this.namePool = documentInfo.getNamePool();
        this.setNamespaces(nodeInfo);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        this.namespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xdt", "http://www.w3.org/2003/11/xpath-datatypes");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo nodeInfo) {
        this.namespaces.clear();
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            this.declareNamespace(nodeInfo2.getLocalPart(), nodeInfo2.getStringValue());
        }
        return;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void declareCollation(String string, Comparator comparator, boolean bl) {
        this.collations.put(string, comparator);
        if (bl) {
            this.defaultCollationName = string;
        }
    }

    public Variable declareVariable(String string, Object object) throws XPathException {
        String string2;
        String string3;
        Object object2;
        try {
            object2 = Name.getQNameParts(string);
            string3 = object2[0];
            string2 = object2[1];
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static("Invalid QName for variable: " + string);
        }
        object2 = "";
        if (!"".equals(string3)) {
            object2 = this.getURIForPrefix(string3);
        }
        Variable variable = Variable.make(string);
        variable.setValue(object);
        int n = this.namePool.allocate(string3, (String)object2, string2) & 0xFFFFF;
        this.variables.put(new Integer(n), variable);
        return variable;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string) {
        System.err.println(string);
    }

    public String getSystemId() {
        return "";
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = (String)this.namespaces.get(string);
        if (string2 == null) {
            throw new XPathException.Static("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public VariableDeclaration bindVariable(int n) throws XPathException.Static {
        Variable variable = (Variable)this.variables.get(new Integer(n));
        if (variable == null) {
            throw new XPathException.Static("Undeclared variable in a standalone expression");
        }
        return variable;
    }

    protected int getNumberOfVariables() {
        return this.variables.size();
    }

    public Expression bindFunction(String string, Expression[] expressionArray) throws XPathException {
        int n = string.indexOf(":");
        if (n < 0) {
            return this.bindSystemFunction(string, expressionArray);
        }
        String string2 = string.substring(0, n);
        String string3 = this.getURIForPrefix(string2);
        String string4 = string.substring(n + 1);
        int n2 = this.namePool.allocate(string2, string3, string4);
        int n3 = n2 & 0xFFFFF;
        if (string3.equals("http://www.w3.org/2003/11/xpath-functions")) {
            return this.bindSystemFunction(string4, expressionArray);
        }
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "evaluate")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:evaluate");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "expression")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:expression");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "parse")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:parse");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "serialize")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:serialize");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (string3.equals("http://www.w3.org/2001/XMLSchema") || string3.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string3.equals("http://www.w3.org/2003/11/xpath-datatypes")) {
            if (expressionArray.length != 1) {
                throw new XPathException.Static("A constructor function must have exactly one argument");
            }
            AtomicType atomicType = (AtomicType)Type.getBuiltInItemType(string3, string4);
            if (atomicType == null) {
                throw new XPathException.Static("Unknown constructor function: " + string);
            }
            return new CastExpression(expressionArray[0], atomicType, false);
        }
        Class clazz = null;
        try {
            clazz = this.getExternalJavaClass(string3);
        }
        catch (Exception exception) {
            throw new XPathException.Static("Cannot load external Java class", exception);
        }
        if (clazz != null) {
            FunctionProxy functionProxy = new FunctionProxy();
            functionProxy.setArguments(expressionArray);
            functionProxy.setFunctionName(clazz, string4, expressionArray.length);
            return functionProxy;
        }
        throw new XPathException.Static("Unknown function: " + string);
    }

    private FunctionCall bindSystemFunction(String string, Expression[] expressionArray) throws XPathException {
        FunctionCall functionCall = SystemFunction.makeSystemFunction(string);
        if (functionCall == null) {
            throw new XPathException.Static("Unknown system function: " + string);
        }
        if (functionCall instanceof XSLTFunction) {
            throw new XPathException.Static("Function " + string + " is available only in XSLT");
        }
        functionCall.setArguments(expressionArray);
        return functionCall;
    }

    private Class getExternalJavaClass(String string) {
        Class clazz = FunctionProxy.getVendorExtensionClass(string);
        if (clazz != null) {
            return clazz;
        }
        return FunctionProxy.getImplicitJavaClass(string);
    }

    public Comparator getCollation(String string) {
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public short getDefaultElementNamespace() {
        return 0;
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public boolean isImportedSchema(String string) {
        return false;
    }
}

