/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SequenceInstruction;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class XSLTemplate
extends StyleElement {
    private int[] modeNameCodes;
    private int templateFingerprint = -1;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private Procedure procedure = new Procedure();
    private boolean needsStackFrame;
    private Template compiledTemplate = new Template();
    private SequenceType requiredType = null;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public int getTemplateFingerprint() {
        try {
            String string;
            if (this.templateFingerprint == -1 && (string = this.getAttributeValue("name")) != null) {
                this.templateFingerprint = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            return this.templateFingerprint;
        }
        catch (NamespaceException namespaceException) {
            return -1;
        }
        catch (XPathException xPathException) {
            return -1;
        }
    }

    protected ItemType getReturnedItemType() {
        if (this.requiredType == null) {
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    private int getMinImportPrecedence() {
        return ((XSLStyleSheet)this.getDocumentElement()).getMinImportPrecedence();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            String string6 = this.getNamePool().getClarkName(n);
            if (string6 == "mode") {
                string = attributeCollection.getValue(n2).trim();
            } else if (string6 == "name") {
                string2 = attributeCollection.getValue(n2).trim();
            } else if (string6 == "match") {
                string4 = attributeCollection.getValue(n2);
            } else if (string6 == "priority") {
                string3 = attributeCollection.getValue(n2).trim();
            } else if (string6 == "as") {
                string5 = attributeCollection.getValue(n2);
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        try {
            if (string == null) {
                this.modeNameCodes = new int[1];
                this.modeNameCodes[0] = -1;
            } else {
                if (string4 == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent");
                }
                n = 0;
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n;
                }
                if (n == 0) {
                    this.compileError("The mode attribute must not be empty");
                }
                this.modeNameCodes = new int[n];
                n = 0;
                stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    if (string7.equals("#default")) {
                        this.modeNameCodes[n++] = -1;
                        continue;
                    }
                    if (string7.equals("#all")) {
                        bl = true;
                        this.modeNameCodes[n++] = -2;
                        continue;
                    }
                    this.modeNameCodes[n++] = this.makeNameCode(string7);
                }
                if (bl && n > 1) {
                    this.compileError("mode='#all' cannot be combined with other modes");
                }
            }
            if (string2 != null) {
                this.templateFingerprint = this.makeNameCode(string2.trim()) & 0xFFFFF;
            }
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
        boolean bl = this.prioritySpecified = string3 != null;
        if (this.prioritySpecified) {
            if (string4 == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent");
            }
            try {
                this.priority = new Double(string3.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ")");
            }
        }
        if (string4 != null) {
            this.match = this.makePattern(string4);
        }
        if (this.match == null && string2 == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)");
        }
        if (string5 != null) {
            this.requiredType = this.makeSequenceType(string5);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.typeCheck("match", this.match);
        this.markTailCalls();
    }

    public void markTailCalls() {
        StyleElement styleElement;
        if (this.requiredType == null && (styleElement = this.getLastChildInstruction()) != null) {
            styleElement.markTailCalls();
        }
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        SequenceInstruction sequenceInstruction = new SequenceInstruction(null, this.requiredType);
        this.compileChildren(executable, sequenceInstruction);
        this.needsStackFrame = this.procedure.getNumberOfVariables() > 0;
        this.compiledTemplate.init(sequenceInstruction, this.needsStackFrame, this.getPrecedence(), this.getMinImportPrecedence(), this.getSystemId(), this.getLineNumber());
        if (this.match != null) {
            RuleManager ruleManager = this.getPrincipalStyleSheet().getRuleManager();
            int n = 0;
            while (n < this.modeNameCodes.length) {
                int n2 = this.modeNameCodes[n];
                Mode mode = ruleManager.getMode(n2);
                if (n2 != -1 && n2 != -2) {
                    mode.setModeName(this.getTargetNamePool().getDisplayName(n2));
                }
                if (this.prioritySpecified) {
                    ruleManager.setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence(), this.priority);
                } else {
                    ruleManager.setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence());
                }
                ++n;
            }
        }
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
        return null;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public Template getCompiledTemplate() {
        return this.compiledTemplate;
    }
}

