/*
 * $Id: nt_property.h,v 1.6 2000/11/28 22:39:51 syatskevich Exp $
 *
 * GNOME applet for WebDownloader for X.
 *
 * Author: Sergey N. Yatskevich <syatskevich@mail.ru>
 */

#ifndef __NT_PROPERTY_H
#define __NT_PROPERTY_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define NT_PROPS_TYPE            (nt_props_get_type ())
#define NT_PROPS(obj)            (GTK_CHECK_CAST ((obj), NT_PROPS_TYPE, NTProps))
#define NT_PROPS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), NT_PROPS_TYPE, NTPropsClass))
#define IS_NT_PROPS(obj)         (GTK_CHECK_TYPE ((obj), NT_PROPS_TYPE))
#define IS_NT_PROPS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), NT_PROPS_TYPE))

#define NT_PROPS_GET_CLASS(obj)  (NT_PROPS_CLASS (NT_PROPS (obj)->base.klass))
#define NT_PROPS_GET_TYPE(obj)   (GTK_OBJECT_TYPE (obj))

typedef struct _NTProps NTProps;
typedef struct _NTPropsClass NTPropsClass;

struct _NTProps {
	GtkObject base;

	gchar    *nta_animation_fname;
	gchar    *nta_tile_up_fname;
	gchar    *nta_tile_down_fname;
	gint     nta_direction;
	gint     nta_mode;
	gboolean nta_tiles_enabled;
	gint     nta_depth;
	gboolean nta_prelight_button_on_mouseover;
	gint     nta_download_cmd;

	GtkWidget *dialog;

	GtkWidget *pixmap_entry;
	GtkWidget *forward, *backward, *pingpong;
	GtkWidget *continue_animation, *stop, *switch_to_null, *blink;
	GtkWidget *tiles_enabled, *tile_up_icon_entry, *tile_down_icon_entry;
	GtkWidget *depth, *prelight_button_on_mouseover;
	GtkWidget *download_ask, *download_not_ask;
};

struct _NTPropsClass {
	GtkObjectClass base_class;
};

GtkType nt_props_get_type (void);

GtkObject *nt_props_new (void);

void     nt_props_load (NTProps *ntp, char *cfgpath, char *globcfgpath);
void     nt_props_open (NTProps *ntp);
gboolean nt_props_save_session (NTProps *ntp, char *cfgpath, char *globcfgpath);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __NT_PROPERTY_H */
