/*
 * $Id: nt_property.c,v 1.11 2000/11/28 22:39:51 syatskevich Exp $
 *
 * GNOME applet for WebDownloader for X.
 *
 * Author: Sergey N. Yatskevich <syatskevich@mail.ru>
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "support.h"
#include "interface.h"
#include "callbacks.h"

#include "nt_property.h"
#include "nt_applet.h"
#include "nt.h"

enum {
	CONFIG_CHANGED,
	LAST_SIGNAL
};

static void nt_props_init (NTProps *ntp);
static void nt_props_class_init (NTPropsClass *klass);
static void nt_props_destroy (GtkObject *ntp);

static void nt_props_clean (NTProps *ntp);
static void nt_props_apply (NTProps *ntp);

static GtkObjectClass *parent_class = NULL;
static guint nt_props_signals[LAST_SIGNAL] = { 0 };

GtkType
nt_props_get_type (void)
{
	static GtkType nt_props_type = 0;

	if (!nt_props_type)
	{
		static const GtkTypeInfo nt_props_info = {
			"NTProps",
			sizeof (NTProps),
			sizeof (NTPropsClass),
			(GtkClassInitFunc) nt_props_class_init,
			(GtkObjectInitFunc) nt_props_init,
			(GtkArgSetFunc) NULL,
			(GtkArgGetFunc) NULL,
			(GtkClassInitFunc) NULL
		};

		nt_props_type = gtk_type_unique (GTK_TYPE_OBJECT, &nt_props_info);
	}

	return nt_props_type;
}

static void
nt_props_init (NTProps *ntp)
{
	ntp->dialog = NULL;

	ntp->nta_animation_fname              = NULL;
	ntp->nta_tile_up_fname                = NULL;
	ntp->nta_tile_down_fname              = NULL;
	ntp->nta_direction                    = NTA_DIR_PINGPONG;
	ntp->nta_mode                         = NTA_MODE_BLINK;
	ntp->nta_tiles_enabled                = TRUE;
	ntp->nta_depth                        = -2;
	ntp->nta_prelight_button_on_mouseover = FALSE;

	ntp->nta_download_cmd = PACKET_ADD_OPEN;
}

static void
nt_props_class_init (NTPropsClass *klass)
{
	parent_class = GTK_OBJECT_CLASS (gtk_type_class (GTK_TYPE_OBJECT));

	nt_props_signals[CONFIG_CHANGED] =
		gtk_signal_new ("config_changed",
    			0, NT_PROPS_TYPE,
			0, gtk_marshal_NONE__NONE,
			GTK_TYPE_NONE, 0);

	gtk_object_class_add_signals (GTK_OBJECT_CLASS (klass),
	                              nt_props_signals, LAST_SIGNAL);

	GTK_OBJECT_CLASS (klass)->destroy = nt_props_destroy;
}

static void
nt_props_clean (NTProps *ntp)
{
	g_free (ntp->nta_animation_fname);
	g_free (ntp->nta_tile_up_fname);
	g_free (ntp->nta_tile_down_fname);

	ntp->nta_animation_fname = NULL;
	ntp->nta_tile_up_fname   = NULL;
	ntp->nta_tile_down_fname = NULL;
	ntp->nta_direction       = NTA_DIR_PINGPONG;
	ntp->nta_mode            = NTA_MODE_BLINK;
	ntp->nta_tiles_enabled   = TRUE;
	ntp->nta_depth           = -2;

	ntp->nta_download_cmd = PACKET_ADD_OPEN;
}

static void
nt_props_destroy (GtkObject *_ntp)
{
	NTProps *ntp = NT_PROPS (_ntp);

	if (ntp->dialog)
		gtk_object_unref (GTK_OBJECT (ntp->dialog));

	nt_props_clean (ntp);

	parent_class->destroy (_ntp);
}

void
nt_props_load (NTProps *ntp, char *cfgpath, char *globcfgpath)
{
	g_return_if_fail (ntp != NULL);
	g_return_if_fail (IS_NT_PROPS (ntp));

	nt_props_clean (ntp);

	if (cfgpath)
		gnome_config_push_prefix (cfgpath);

	ntp->nta_animation_fname              = gnome_config_get_string ("nt_applet/animation_fname=nt_applet/nt-animation.default");
	ntp->nta_tile_up_fname                = gnome_config_get_string ("nt_applet/tile_up_fname=tiles/tile-normal-up.png");
	ntp->nta_tile_down_fname              = gnome_config_get_string ("nt_applet/tile_down_fname=tiles/tile-normal-down.png");
	ntp->nta_direction                    = gnome_config_get_int ("nt_applet/direction=2");
	ntp->nta_mode                         = gnome_config_get_int ("nt_applet/animation_mode=2");
	ntp->nta_tiles_enabled                = gnome_config_get_bool ("nt_applet/tiles_enabled=true");
	ntp->nta_depth                        = gnome_config_get_int ("nt_applet/depth=-2");
	ntp->nta_prelight_button_on_mouseover = gnome_config_get_bool ("nt_applet/prelight_button_on_mouseover=false");

	ntp->nta_download_cmd = gnome_config_get_int ("nt_applet/download_cmd=16");

	if (cfgpath)
		gnome_config_pop_prefix ();

	gtk_signal_emit (GTK_OBJECT (ntp), nt_props_signals[CONFIG_CHANGED]);
}

gboolean
nt_props_save_session (NTProps *ntp, char *cfgpath, char *globcfgpath)
{
	g_return_val_if_fail ((ntp != NULL), FALSE);
	g_return_val_if_fail (IS_NT_PROPS (ntp), FALSE);

	if (cfgpath)
		gnome_config_push_prefix (cfgpath);

	gnome_config_set_string ("nt_applet/animation_fname", ntp->nta_animation_fname);
	gnome_config_set_string ("nt_applet/tile_up_fname", ntp->nta_tile_up_fname);
	gnome_config_set_string ("nt_applet/tile_down_fname", ntp->nta_tile_down_fname);
	gnome_config_set_int ("nt_applet/direction", ntp->nta_direction);
	gnome_config_set_int ("nt_applet/animation_mode", ntp->nta_mode);
	gnome_config_set_bool ("nt_applet/tiles_enabled", ntp->nta_tiles_enabled);
	gnome_config_set_int ("nt_applet/depth", ntp->nta_depth);
	gnome_config_set_bool ("nt_applet/prelight_button_on_mouseover", ntp->nta_prelight_button_on_mouseover);

	gnome_config_set_int ("nt_applet/download_cmd", ntp->nta_download_cmd);

	gnome_config_sync ();
	gnome_config_drop_all ();

	if (cfgpath)
		gnome_config_pop_prefix ();

	return FALSE;
}

static void
nt_props_apply (NTProps *ntp)
{
	nt_props_clean (ntp);

	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (ntp->forward)))
			ntp->nta_direction = NTA_DIR_FORWARD;
	else if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON (ntp->backward)))
			ntp->nta_direction = NTA_DIR_BACKWARD;
	else
			ntp->nta_direction = NTA_DIR_PINGPONG;

	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (ntp->continue_animation)))
			ntp->nta_mode = NTA_MODE_CONTINUE;
	else if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON (ntp->stop)))
			ntp->nta_mode = NTA_MODE_STOP;
	else if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON (ntp->switch_to_null)))
			ntp->nta_mode = NTA_MODE_SWITCH;
	else
			ntp->nta_mode = NTA_MODE_BLINK;

	ntp->nta_animation_fname = gnome_pixmap_entry_get_filename
			 (GNOME_PIXMAP_ENTRY (ntp->pixmap_entry));

	ntp->nta_tiles_enabled = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ntp->tiles_enabled));
	ntp->nta_tile_up_fname = gnome_icon_entry_get_filename (GNOME_ICON_ENTRY (ntp->tile_up_icon_entry));
	ntp->nta_tile_down_fname = gnome_icon_entry_get_filename (GNOME_ICON_ENTRY (ntp->tile_down_icon_entry));

	ntp->nta_depth = (gint)gtk_range_get_adjustment (GTK_RANGE(ntp->depth))->value;
	ntp->nta_prelight_button_on_mouseover = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ntp->prelight_button_on_mouseover));

	if (gtk_toggle_button_get_active
		(GTK_TOGGLE_BUTTON (ntp->download_ask)))
			ntp->nta_download_cmd = PACKET_ADD_OPEN;
	else
			ntp->nta_download_cmd = PACKET_ADD;

	gtk_signal_emit (GTK_OBJECT (ntp), nt_props_signals[CONFIG_CHANGED]);
}

void
nt_props_open (NTProps *ntp)
{
	GtkWidget *file_entry = NULL;

	g_return_if_fail (ntp != NULL);
	g_return_if_fail (IS_NT_PROPS (ntp));

	if(ntp->dialog)
	{
		gdk_window_raise(ntp->dialog->window);
		return;
	}

	ntp->dialog = create_nt_property_dialog();
	gtk_signal_connect (GTK_OBJECT (ntp->dialog), "destroy",
                    	    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &ntp->dialog);

	ntp->forward  = lookup_widget (ntp->dialog, "forward");
	ntp->backward = lookup_widget (ntp->dialog, "backward");
	ntp->pingpong = lookup_widget (ntp->dialog, "pingpong");

	ntp->continue_animation = lookup_widget (ntp->dialog, "continue_animation");
	ntp->stop               = lookup_widget (ntp->dialog, "stop");
	ntp->switch_to_null     = lookup_widget (ntp->dialog, "switch_to_null");
	ntp->blink              = lookup_widget (ntp->dialog, "blink");

	ntp->pixmap_entry       = lookup_widget (ntp->dialog, "pixmap_entry");

	ntp->tiles_enabled  = lookup_widget (ntp->dialog, "tiles_enabled");

	/* FIXME
	 *
	 * signals for icon_entry must be defined in interface.c,
	 * but Glade do not allow define it properly :-(((
	 */
	ntp->tile_up_icon_entry   = lookup_widget (ntp->dialog, "tile_up_icon_entry");
	gtk_signal_connect_object (GTK_OBJECT (gnome_icon_entry_gtk_entry (GNOME_ICON_ENTRY (ntp->tile_up_icon_entry))),
				   "changed",
            			   GTK_SIGNAL_FUNC (gnome_property_box_changed),
            			   GTK_OBJECT (ntp->dialog));
	ntp->tile_down_icon_entry = lookup_widget (ntp->dialog, "tile_down_icon_entry");
	gtk_signal_connect_object (GTK_OBJECT (gnome_icon_entry_gtk_entry (GNOME_ICON_ENTRY (ntp->tile_down_icon_entry))),
			           "changed",
            			   GTK_SIGNAL_FUNC (gnome_property_box_changed),
            			   GTK_OBJECT (ntp->dialog));
	ntp->depth = lookup_widget (ntp->dialog, "depth");
	gtk_adjustment_set_value (gtk_range_get_adjustment (GTK_RANGE(ntp->depth)),
				  (gfloat)ntp->nta_depth);
	gtk_signal_connect_object (GTK_OBJECT (gtk_range_get_adjustment (GTK_RANGE(ntp->depth))),
				   "value_changed",
				   GTK_SIGNAL_FUNC (gnome_property_box_changed),
				   GTK_OBJECT (ntp->dialog));

	ntp->prelight_button_on_mouseover  = lookup_widget (ntp->dialog, "prelight_button_on_mouseover");

	ntp->download_ask     = lookup_widget (ntp->dialog, "download_ask");
	ntp->download_not_ask = lookup_widget (ntp->dialog, "download_not_ask");

	if (ntp->nta_direction == NTA_DIR_FORWARD)
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->forward), TRUE);
	else if (ntp->nta_direction == NTA_DIR_BACKWARD)
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->backward), TRUE);
	else
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->pingpong), TRUE);

	if (ntp->nta_mode == NTA_MODE_CONTINUE)
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->continue_animation), TRUE);
	else if (ntp->nta_mode == NTA_MODE_STOP)
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->stop), TRUE);
	else if (ntp->nta_mode == NTA_MODE_SWITCH)
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->switch_to_null), TRUE);
	else
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->blink), TRUE);

	file_entry = lookup_widget (ntp->dialog, "pixmap_file_entry");
	gtk_entry_set_text (GTK_ENTRY (file_entry),
		            ntp->nta_animation_fname);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ntp->tiles_enabled),
				      ntp->nta_tiles_enabled);
	gtk_toggle_button_toggled (GTK_TOGGLE_BUTTON (ntp->tiles_enabled));

	gnome_icon_entry_set_icon (GNOME_ICON_ENTRY (ntp->tile_up_icon_entry),
				   ntp->nta_tile_up_fname);
	gnome_icon_entry_set_icon (GNOME_ICON_ENTRY (ntp->tile_down_icon_entry),
				   ntp->nta_tile_down_fname);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ntp->prelight_button_on_mouseover),
				      ntp->nta_prelight_button_on_mouseover);

	if (ntp->nta_download_cmd == PACKET_ADD)
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->download_not_ask), TRUE);
	else
		gtk_toggle_button_set_active
			(GTK_TOGGLE_BUTTON (ntp->download_ask), TRUE);

	gtk_signal_connect_object (GTK_OBJECT (ntp->dialog), "apply",
				   nt_props_apply, GTK_OBJECT (ntp));

	gnome_property_box_set_modified
		(GNOME_PROPERTY_BOX (ntp->dialog), FALSE);

	gtk_widget_show (ntp->dialog);
}

GtkObject *
nt_props_new (void)
{
	return gtk_type_new (NT_PROPS_TYPE);
}
