%option noyywrap

%{

/***************************************************************************
                          scanner.ll  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#include <cstdio>
#include <cstdlib>

#include <qfile.h>

#include "cuyointl.h"
#include "code.h"
#include "knoten.h"
/* parser.h darf erst hier included werden, weil es gemeinerweise
   ohne selbst zu includen auf code.h und knoten.h zugreift */
#include "parser.h"

/* Um nach include-Dateien zu suchen...: */
#include "pfaditerator.h"




/***** lex-Einstellungen *****/


/* _Nicht_ so parsen, dass man interaktiv die level.descr eingeben knnte,
   whrend sie geparst wird. */
#define YY_NEVER_INTERACTIVE 1

/* Wenn bison reentrant sein soll (d. h. nur lokale Variablen benutzen),
   wird die an die Lex-Hauptroutine yylex() noch ein Pointer bergeben
   auf die Variable, in die man den lval schreiben kann. */
#define YY_DECL int yylex(YYSTYPE * lvalPtr)



extern __String gDateiName;
extern int gZeilenNr;
extern bool gGabFehler;




__String * expandiereBackslash(char * a) {
  __String r;
  a++; // erstes " berspringen
  while (*(a + 1)) { // Letztes Zeichen auch auslassen
    if (*a == '\\') {
      a++;
      switch (*a) {
      case 'n':
        r += '\n';
        break;
      case '"':
        r += '"';
        break;
      case '\\':
        r += '\\';
        break;
      default:
        throw Fehler(_("Unknown escape sequence"));
      }
    } else
      r += *a;
    a++;
  }
  return new __String(r);
}





/** Wechselt die Lex-Datei temporr. Liefert was zurck, was an popLex
    bergeben werden muss, um wieder zurckzuschalten. Throwt evtl.
    setzdefault wird an den Pfaditerator bergeben. */
void * pushLex(char * na, bool setzdefault = false) {
  /* Alte Datei merken */
  YY_BUFFER_STATE merkBuf = YY_CURRENT_BUFFER;

  /* Neue Datei suchen. */
  PfadIterator pi(na, setzdefault);
  for (; !QFile(pi.pfad()).exists(); ++pi);
  
  /* ffnen */
  FILE * neudat;
  neudat = fopen(pi.pfad(), "r");
  if (!neudat)
    throw Fehler(_("Error opening file \"%s\"."), na);

  /* Auf neue Datei umschalten */
  yy_switch_to_buffer(yy_create_buffer(neudat, YY_BUF_SIZE));
  
  return merkBuf;
}


void popLex(void * merkBuf) {
  /* Aktuelle Datei schlieen */
  FILE * f = yyin;
  yy_delete_buffer( YY_CURRENT_BUFFER );
  /* Die Datei lieber erst nach dem yy_delete_buffer() schlieen.
     Man wei nicht so recht, ob yy_delete_buffer() noch was mit
     der Datei macht... */
  fclose(f);

  /* Auf ursprngliche Datei zurckschalten */
  yy_switch_to_buffer((YY_BUFFER_STATE) merkBuf);
  /* Hoffentlich kmmert sich lex drum, die neu geffnete Datei
     yyin wieder zu schlieen und yyin zurckzusetzen. */
}




%}

STRINGBUCH [ !#-\[\]-\xff]|(\\[n"\\])



%%


<INITIAL>var            { return VAR_TOK; }
<INITIAL>busy           { return BUSY_TOK; }
<INITIAL>switch         { return SWITCH_TOK; }
<INITIAL>if             { return IF_TOK; }
<INITIAL>else           { return ELSE_TOK; }
<INITIAL>rnd            { return RND_TOK; }
<INITIAL>gcd            { return GGT_TOK; }
<INITIAL>include        { return INCLUDE_TOK; }
<INITIAL>bonus          { return BONUS_TOK; }
<INITIAL>message        { return MESSAGE_TOK; }
<INITIAL>explode        { return EXPLODE_TOK; }
<INITIAL>"<<"           { return BEGIN_CODE_TOK; }
<INITIAL>">>"           { return END_CODE_TOK; }
<INITIAL>".."           { return BIS_TOK; }
<INITIAL>[01]           { lvalPtr->zahl = yytext[0]-'0';
                          return NULLEINS_TOK;
                        }
<INITIAL>[A-Za-z]       {
                            if (yytext[0] >= 'a')
                              lvalPtr->zahl = yytext[0] - 'a' + 26;
                            else
                              lvalPtr->zahl = yytext[0] - 'A';
                            return BUCHSTABE_TOK;
                        }
<INITIAL>[A-Za-z]+      {
                            lvalPtr->str = new __String(yytext);
                            return REINWORT_TOK;
                        }
<INITIAL>[A-Za-z_][A-Za-z_.0-9]*  {
                            lvalPtr->str = new __String(yytext);
                            return WORT_TOK;
                        }
<INITIAL>[01?][01?][01?][01?][01?][01?][01?][01?] {
                          lvalPtr->str = new __String(yytext);
                          return NACHBAR8_TOK;
                        }
<INITIAL>[01?][01?][01?][01?][01?][01?] {
                          lvalPtr->str = new __String(yytext);
                          return NACHBAR6_TOK;
                        }
<INITIAL>([0-9]+)|(0[Xx][0-9A-Fa-f]+) {
                          sscanf(yytext, "%i", &lvalPtr->zahl);
                          return ZAHL_TOK;
                        }
<INITIAL>[0-9]*\.5      {
                          /* Falls der Benutzer ".5" schreibt,
			     wird sscanf nix scannen... */
               	          lvalPtr->zahl = 0;
			  
                          /* sscanf mit %d liest nur alles vor dem "." */
                          sscanf(yytext, "%d", &lvalPtr->zahl);
                          return HALBZAHL_TOK;
                        }
<INITIAL>"->"           {
                          lvalPtr->zahl = ohne_merk_pfeil;  // siehe code.h
                          return PFEIL_TOK;
                        }
<INITIAL>"=>"           {
                          lvalPtr->zahl = mit_merk_pfeil;  // siehe code.h
                          return PFEIL_TOK;
                        }
<INITIAL>"=="           { return EQ_TOK; }
<INITIAL>"!="           { return NE_TOK; }
<INITIAL>"<="           { return LE_TOK; }
<INITIAL>">="           { return GE_TOK; }
<INITIAL>"&&"           { return AND_TOK; }
<INITIAL>"||"           { return OR_TOK; }
<INITIAL>"+="           { return ADD_TOK; }
<INITIAL>"-="           { return SUB_TOK; }
<INITIAL>"*="           { return MUL_TOK; }
<INITIAL>"/="           { return DIV_TOK; }
<INITIAL>"%="           { return MOD_TOK; }
<INITIAL>\"({STRINGBUCH})*\"   {
                           PBEGIN_TRY
                             lvalPtr->str = expandiereBackslash(yytext);
                             return WORT_TOK;
                           PEND_TRY(lvalPtr->str = new __String())
                        }
<INITIAL>[=+,;(){}*@/~!%:<>&] {return yytext[0];}
<INITIAL>"-"             {return yytext[0];}
<INITIAL>"["             {return yytext[0];}
<INITIAL>"]"             {return yytext[0];}
<INITIAL>[ \t]+           /* Leerzeug */
<INITIAL>"#"+[^\n]*       /* Kommentar */
<INITIAL>\n               gZeilenNr++;
<INITIAL>.                { PBEGIN_TRY
                              __String e;
                              e.sprintf("Wrong character '%s'", yytext);
                              throw Fehler(e);
                            PEND_TRY(;);
                          }
                            
%%

