/***************************************************************************
                          pfaditerator.h  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PFADITERATOR_H
#define PFADITERATOR_H

#include "inkompatibel.h"

#include <qstring.h>




/** Iteriert durch alle Pfade, an denen sich eine
    Daten-Datei befinden knnte. Throwt selbstndig, wenn
    die Datei gar nicht existiert.
Verwendung:
  for (PfadIterator pi("pics/miez.xpm"); !test_ex(pi.pfad()); ++pi);

  *@author Immi
  */

class PfadIterator {
public: 
  PfadIterator(__String dat, bool setzDefault = false);
  ~PfadIterator();
  
  /** Nchster Pfad */
  PfadIterator & operator++();
  
  /** Aktueller Pfad */
  __String pfad() const;

  /** Muss einmal am Anfang von main() aufgerufen werden */
  static void init(int argc, char ** argv);

 protected:
  int mPos;
  __String mDatei;
  /** true: In Zukunft soll der Default-Pfad der sein, wo diese Datei
      gefunden wird. */
  bool mSetzDefault;

  /** Der Pfad, wo cuyo aufgerufen wurde. */
  static __String mLokalPfad;
  /** Nummer vom Default-Pfad */
  static int mDefaultPfad;
};

#endif
